/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.Autoscaler;
import com.google.api.services.compute.model.AutoscalerStatusDetails;
import com.google.api.services.compute.model.AutoscalingPolicy;
import com.google.api.services.compute.model.AutoscalingPolicyCpuUtilization;
import com.google.api.services.compute.model.AutoscalingPolicyCustomMetricUtilization;
import com.google.api.services.compute.model.AutoscalingPolicyLoadBalancingUtilization;
import com.google.api.services.compute.model.AutoscalingPolicyScaleInControl;
import com.google.api.services.compute.model.AutoscalingPolicyScalingSchedule;
import com.google.api.services.compute.model.DistributionPolicy;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceGroupManagerAutoHealingPolicy;
import com.google.api.services.compute.model.InstanceProperties;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.NamedPort;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.ServiceAccount;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.netflix.frigga.ami.AppVersion;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.cache.DefaultJsonCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandMetricsSupport;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.cache.CacheResultBuilder;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.compute.BatchPaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeApiFactory;
import com.netflix.spinnaker.clouddriver.google.compute.InstanceTemplates;
import com.netflix.spinnaker.clouddriver.google.compute.Instances;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoscalingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleDistributionPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstance;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstances;
import com.netflix.spinnaker.clouddriver.google.model.GoogleLabeledResource;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancingPolicy;
import com.netflix.spinnaker.clouddriver.google.provider.GoogleInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.moniker.Moniker;
import com.netflix.spinnaker.moniker.Namer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public abstract class AbstractGoogleServerGroupCachingAgent
implements CachingAgent,
OnDemandAgent,
AccountAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGoogleServerGroupCachingAgent.class);
    private static final ImmutableSet<AgentDataType> DATA_TYPES = ImmutableSet.of((Object)AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.SERVER_GROUPS.getNs()), (Object)AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.APPLICATIONS.getNs()), (Object)AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.CLUSTERS.getNs()), (Object)AgentDataType.Authority.INFORMATIVE.forType(Keys.Namespace.LOAD_BALANCERS.getNs()));
    private static final String ON_DEMAND_TYPE = String.join((CharSequence)":", GoogleCloudProvider.getID(), OnDemandType.ServerGroup.getValue());
    private static final Splitter COMMA = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Splitter.MapSplitter IMAGE_DESCRIPTION_SPLITTER = Splitter.on((char)',').withKeyValueSeparator(": ");
    private final GoogleNamedAccountCredentials credentials;
    private final GoogleComputeApiFactory computeApiFactory;
    private final String region;
    private final OnDemandMetricsSupport onDemandMetricsSupport;
    private final ObjectMapper objectMapper;
    private final Namer<GoogleLabeledResource> naming;

    AbstractGoogleServerGroupCachingAgent(GoogleNamedAccountCredentials credentials, GoogleComputeApiFactory computeApiFactory, Registry registry, String region, ObjectMapper objectMapper) {
        this.credentials = credentials;
        this.computeApiFactory = computeApiFactory;
        this.region = region;
        this.onDemandMetricsSupport = new OnDemandMetricsSupport(registry, (OnDemandAgent)this, ON_DEMAND_TYPE);
        this.objectMapper = objectMapper;
        this.naming = NamerRegistry.lookup().withProvider(GoogleCloudProvider.getID()).withAccount(credentials.getName()).withResource(GoogleLabeledResource.class);
    }

    public CacheResult loadData(ProviderCache providerCache) {
        try {
            CacheResultBuilder cacheResultBuilder = new CacheResultBuilder((Collection<AgentDataType>)DATA_TYPES);
            cacheResultBuilder.setStartTime(System.currentTimeMillis());
            List<GoogleServerGroup> serverGroups = this.getServerGroups(providerCache);
            Set serverGroupKeys = (Set)serverGroups.stream().map(this::getServerGroupKey).collect(ImmutableSet.toImmutableSet());
            providerCache.getAll(Keys.Namespace.ON_DEMAND.getNs(), (Collection)serverGroupKeys).forEach(cacheData -> {
                long cacheTime = (Long)cacheData.getAttributes().get("cacheTime");
                if (cacheTime < cacheResultBuilder.getStartTime() && (Integer)cacheData.getAttributes().get("processedCount") > 0) {
                    cacheResultBuilder.getOnDemand().getToEvict().add(cacheData.getId());
                } else {
                    cacheResultBuilder.getOnDemand().getToKeep().put(cacheData.getId(), (CacheData)cacheData);
                }
            });
            CacheResult cacheResult = this.buildCacheResult(cacheResultBuilder, serverGroups);
            ((Collection)cacheResult.getCacheResults().get(Keys.Namespace.ON_DEMAND.getNs())).forEach(cacheData -> {
                cacheData.getAttributes().put("processedTime", System.currentTimeMillis());
                int processedCount = (Integer)cacheData.getAttributes().get("processedCount");
                cacheData.getAttributes().put("processedCount", processedCount + 1);
            });
            return cacheResult;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean handles(OnDemandType type, String cloudProvider) {
        return OnDemandType.ServerGroup.equals((Object)type) && GoogleCloudProvider.getID().equals(cloudProvider);
    }

    @Nullable
    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ?> data) {
        try {
            String serverGroupName = (String)data.get("serverGroupName");
            if (serverGroupName == null || !this.getAccountName().equals(data.get("account")) || !this.region.equals(data.get("region"))) {
                return null;
            }
            Optional serverGroup = (Optional)this.getMetricsSupport().readData(() -> this.getServerGroup(serverGroupName, providerCache));
            CacheResultBuilder cacheResultBuilder = new CacheResultBuilder();
            if (serverGroup.isPresent()) {
                String serverGroupKey = this.getServerGroupKey((GoogleServerGroup)serverGroup.get());
                CacheResult result = (CacheResult)this.getMetricsSupport().transformData(() -> this.buildCacheResult(cacheResultBuilder, (List<GoogleServerGroup>)ImmutableList.of((Object)((GoogleServerGroup)serverGroup.get()))));
                String cacheResults = this.objectMapper.writeValueAsString((Object)result.getCacheResults());
                CacheData cacheData = (CacheData)this.getMetricsSupport().onDemandStore(() -> new DefaultCacheData(serverGroupKey, (int)Duration.ofMinutes(10L).getSeconds(), (Map)ImmutableMap.of((Object)"cacheTime", (Object)System.currentTimeMillis(), (Object)"cacheResults", (Object)cacheResults, (Object)"processedCount", (Object)0), (Map)ImmutableMap.of()));
                providerCache.putCacheData(Keys.Namespace.ON_DEMAND.getNs(), cacheData);
                return new OnDemandAgent.OnDemandResult(this.getOnDemandAgentType(), result, (Map)ImmutableMap.of());
            }
            Collection<String> existingIdentifiers = this.getOnDemandKeysToEvictForMissingServerGroup(providerCache, serverGroupName);
            providerCache.evictDeletedItems(Keys.Namespace.ON_DEMAND.getNs(), existingIdentifiers);
            return new OnDemandAgent.OnDemandResult(this.getOnDemandAgentType(), (CacheResult)new DefaultCacheResult((Map)ImmutableMap.of()), (Map)ImmutableMap.of((Object)Keys.Namespace.SERVER_GROUPS.getNs(), (Object)ImmutableList.copyOf(existingIdentifiers)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    abstract Collection<String> getOnDemandKeysToEvictForMissingServerGroup(ProviderCache var1, String var2);

    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache providerCache) {
        List ownedKeys = (List)providerCache.getIdentifiers(Keys.Namespace.ON_DEMAND.getNs()).stream().filter(this::keyOwnedByThisAgent).collect(ImmutableList.toImmutableList());
        return (Collection)providerCache.getAll(Keys.Namespace.ON_DEMAND.getNs(), (Collection)ownedKeys).stream().map(cacheData -> {
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            map.put("details", Keys.parse(cacheData.getId()));
            map.put("moniker", (Map<String, String>)cacheData.getAttributes().get("moniker"));
            map.put("cacheTime", (Map<String, String>)cacheData.getAttributes().get("cacheTime"));
            map.put("processedCount", (Map<String, String>)cacheData.getAttributes().get("processedCount"));
            map.put("processedTime", (Map<String, String>)cacheData.getAttributes().get("processedTime"));
            return map;
        }).collect(ImmutableList.toImmutableList());
    }

    private boolean keyOwnedByThisAgent(String key) {
        Map<String, String> parsedKey = Keys.parse(key);
        return parsedKey != null && parsedKey.get("type").equals(Keys.Namespace.SERVER_GROUPS.getNs()) && this.keyOwnedByThisAgent(parsedKey);
    }

    abstract boolean keyOwnedByThisAgent(Map<String, String> var1);

    private CacheResult buildCacheResult(CacheResultBuilder cacheResultBuilder, List<GoogleServerGroup> serverGroups) {
        try {
            for (GoogleServerGroup serverGroup : serverGroups) {
                Moniker moniker = this.naming.deriveMoniker((Object)serverGroup);
                String applicationKey = Keys.getApplicationKey(moniker.getApp());
                String clusterKey = Keys.getClusterKey(this.getAccountName(), moniker.getApp(), moniker.getCluster());
                String serverGroupKey = this.getServerGroupKey(serverGroup);
                Set instanceKeys = (Set)serverGroup.getInstances().stream().map(instance -> Keys.getInstanceKey(this.getAccountName(), this.region, instance.getName())).collect(ImmutableSet.toImmutableSet());
                CacheResultBuilder.CacheDataBuilder application = cacheResultBuilder.namespace(Keys.Namespace.APPLICATIONS.getNs()).keep(applicationKey);
                application.getAttributes().put("name", moniker.getApp());
                application.getRelationships().get(Keys.Namespace.CLUSTERS.getNs()).add(clusterKey);
                application.getRelationships().get(Keys.Namespace.INSTANCES.getNs()).addAll(instanceKeys);
                CacheResultBuilder.CacheDataBuilder cluster = cacheResultBuilder.namespace(Keys.Namespace.CLUSTERS.getNs()).keep(clusterKey);
                cluster.getAttributes().put("name", moniker.getCluster());
                cluster.getAttributes().put("accountName", this.getAccountName());
                cluster.getAttributes().put("moniker", moniker);
                cluster.getRelationships().get(Keys.Namespace.APPLICATIONS.getNs()).add(applicationKey);
                cluster.getRelationships().get(Keys.Namespace.SERVER_GROUPS.getNs()).add(serverGroupKey);
                cluster.getRelationships().get(Keys.Namespace.INSTANCES.getNs()).addAll(instanceKeys);
                ImmutableSet<String> loadBalancerKeys = this.getLoadBalancerKeys(serverGroup);
                loadBalancerKeys.forEach(key -> cacheResultBuilder.namespace(Keys.Namespace.LOAD_BALANCERS.getNs()).keep((String)key).getRelationships().get(Keys.Namespace.SERVER_GROUPS.getNs()).add(serverGroupKey));
                if (AbstractGoogleServerGroupCachingAgent.shouldUseOnDemandData(cacheResultBuilder, serverGroupKey)) {
                    this.moveOnDemandDataToNamespace(cacheResultBuilder, serverGroup);
                    continue;
                }
                CacheResultBuilder.CacheDataBuilder serverGroupCacheData = cacheResultBuilder.namespace(Keys.Namespace.SERVER_GROUPS.getNs()).keep(serverGroupKey);
                serverGroupCacheData.setAttributes((Map)this.objectMapper.convertValue((Object)serverGroup, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                serverGroupCacheData.getRelationships().get(Keys.Namespace.APPLICATIONS.getNs()).add(applicationKey);
                serverGroupCacheData.getRelationships().get(Keys.Namespace.CLUSTERS.getNs()).add(clusterKey);
                serverGroupCacheData.getRelationships().get(Keys.Namespace.LOAD_BALANCERS.getNs()).addAll((Collection<String>)loadBalancerKeys);
                serverGroupCacheData.getRelationships().get(Keys.Namespace.INSTANCES.getNs()).addAll(instanceKeys);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return cacheResultBuilder.build();
    }

    private ImmutableSet<String> getLoadBalancerKeys(GoogleServerGroup serverGroup) {
        ImmutableSet.Builder loadBalancerKeys = ImmutableSet.builder();
        AbstractGoogleServerGroupCachingAgent.nullableStream((Collection)serverGroup.getAsg().get("load-balancer-names")).map(name -> Keys.getLoadBalancerKey(this.region, this.getAccountName(), name)).forEach(arg_0 -> ((ImmutableSet.Builder)loadBalancerKeys).add(arg_0));
        AbstractGoogleServerGroupCachingAgent.nullableStream((Collection)serverGroup.getAsg().get("global-load-balancer-names")).map(name -> Keys.getLoadBalancerKey("global", this.getAccountName(), name)).forEach(arg_0 -> ((ImmutableSet.Builder)loadBalancerKeys).add(arg_0));
        return loadBalancerKeys.build();
    }

    private static <T> Stream<T> nullableStream(@Nullable Collection<T> collection) {
        return ((Collection)Optional.ofNullable(collection).orElse((Collection<ImmutableList>)ImmutableList.of())).stream();
    }

    private static boolean shouldUseOnDemandData(CacheResultBuilder cacheResultBuilder, String serverGroupKey) {
        CacheData cacheData = cacheResultBuilder.getOnDemand().getToKeep().get(serverGroupKey);
        return cacheData != null && (Long)cacheData.getAttributes().get("cacheTime") > cacheResultBuilder.getStartTime();
    }

    private void moveOnDemandDataToNamespace(CacheResultBuilder cacheResultBuilder, GoogleServerGroup serverGroup) throws IOException {
        String serverGroupKey = this.getServerGroupKey(serverGroup);
        Map onDemandData = (Map)this.objectMapper.readValue((String)cacheResultBuilder.getOnDemand().getToKeep().get(serverGroupKey).getAttributes().get("cacheResults"), (TypeReference)new TypeReference<Map<String, List<DefaultJsonCacheData>>>(){});
        onDemandData.forEach((namespace, cacheDatas) -> {
            if (namespace.equals(Keys.Namespace.ON_DEMAND.getNs())) {
                return;
            }
            cacheDatas.forEach(cacheData -> {
                CacheResultBuilder.CacheDataBuilder cacheDataBuilder = cacheResultBuilder.namespace((String)namespace).keep(cacheData.getId());
                cacheDataBuilder.setAttributes(cacheData.getAttributes());
                cacheDataBuilder.setRelationships(Utils.mergeOnDemandCacheRelationships(cacheData.getRelationships(), cacheDataBuilder.getRelationships()));
                cacheResultBuilder.getOnDemand().getToKeep().remove(cacheData.getId());
            });
        });
    }

    private String getServerGroupKey(GoogleServerGroup serverGroup) {
        return Keys.getServerGroupKey(serverGroup.getName(), this.naming.deriveMoniker((Object)serverGroup).getCluster(), this.getAccountName(), this.region, serverGroup.getZone());
    }

    private List<GoogleServerGroup> getServerGroups(ProviderCache providerCache) throws IOException {
        ImmutableList instances = (ImmutableList)this.retrieveAllInstancesInRegion().stream().map(instance -> GoogleInstances.createFromComputeInstance(instance, this.credentials)).collect(ImmutableList.toImmutableList());
        return this.constructServerGroups(providerCache, this.retrieveInstanceGroupManagers(), (Collection<GoogleInstance>)instances, this.retrieveInstanceTemplates(), this.retrieveAutoscalers());
    }

    abstract Collection<InstanceGroupManager> retrieveInstanceGroupManagers() throws IOException;

    abstract Collection<Autoscaler> retrieveAutoscalers() throws IOException;

    private Optional<GoogleServerGroup> getServerGroup(String name, ProviderCache providerCache) {
        InstanceTemplates instanceTemplatesApi = this.computeApiFactory.createInstanceTemplates(this.credentials);
        try {
            Optional<InstanceGroupManager> managerOpt = this.retrieveInstanceGroupManager(name);
            if (!managerOpt.isPresent()) {
                return Optional.empty();
            }
            InstanceGroupManager manager = managerOpt.get();
            List instances = (List)this.retrieveRelevantInstances(manager).stream().map(instance -> GoogleInstances.createFromComputeInstance(instance, this.credentials)).collect(ImmutableList.toImmutableList());
            List autoscalers = (List)this.retrieveAutoscaler(manager).map(ImmutableList::of).orElse(ImmutableList.of());
            ArrayList<InstanceTemplate> instanceTemplates = new ArrayList<InstanceTemplate>();
            if (manager.getInstanceTemplate() != null) {
                instanceTemplatesApi.get(Utils.getLocalName(manager.getInstanceTemplate())).executeGet().ifPresent(instanceTemplates::add);
            }
            return this.constructServerGroups(providerCache, (Collection<InstanceGroupManager>)ImmutableList.of((Object)manager), instances, instanceTemplates, autoscalers).stream().findAny();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    abstract Optional<InstanceGroupManager> retrieveInstanceGroupManager(String var1) throws IOException;

    abstract Optional<Autoscaler> retrieveAutoscaler(InstanceGroupManager var1) throws IOException;

    abstract Collection<Instance> retrieveRelevantInstances(InstanceGroupManager var1) throws IOException;

    private List<GoogleServerGroup> constructServerGroups(ProviderCache providerCache, Collection<InstanceGroupManager> managers, Collection<GoogleInstance> instances, Collection<InstanceTemplate> instanceTemplates, Collection<Autoscaler> autoscalers) {
        Map autoscalerMap = (Map)autoscalers.stream().collect(ImmutableMap.toImmutableMap(TargetAndScope::forAutoscaler, scaler -> scaler));
        Map instanceTemplatesMap = (Map)instanceTemplates.stream().collect(ImmutableMap.toImmutableMap(InstanceTemplate::getName, i -> i));
        return (List)managers.stream().map(manager -> {
            ImmutableSet ownedInstances = ImmutableSet.of();
            if (manager.getBaseInstanceName() != null) {
                ownedInstances = (ImmutableSet)instances.stream().filter(instance -> instance.getName().startsWith(manager.getBaseInstanceName())).filter(instance -> this.instanceScopedToManager((GoogleInstance)instance, (InstanceGroupManager)manager)).collect(ImmutableSet.toImmutableSet());
            }
            TargetAndScope key = TargetAndScope.forInstanceGroupManager(manager);
            Autoscaler autoscaler = (Autoscaler)autoscalerMap.get(key);
            InstanceTemplate instanceTemplate = (InstanceTemplate)instanceTemplatesMap.get(Utils.getLocalName(manager.getInstanceTemplate()));
            return this.createServerGroup((InstanceGroupManager)manager, (ImmutableSet<GoogleInstance>)ownedInstances, instanceTemplate, autoscaler, providerCache);
        }).collect(ImmutableList.toImmutableList());
    }

    private boolean instanceScopedToManager(GoogleInstance instance, InstanceGroupManager manager) {
        if (manager.getZone() == null) {
            return true;
        }
        return Utils.getLocalName(manager.getZone()).equals(instance.getZone());
    }

    private GoogleServerGroup createServerGroup(InstanceGroupManager manager, ImmutableSet<GoogleInstance> instances, @Nullable InstanceTemplate instanceTemplate, @Nullable Autoscaler autoscaler, ProviderCache providerCache) {
        InstanceProperties properties;
        GoogleServerGroup serverGroup = new GoogleServerGroup();
        serverGroup.setName(manager.getName());
        this.setRegionConfig(serverGroup, manager);
        serverGroup.setAccount(this.getAccountName());
        serverGroup.setInstances((Set<GoogleInstance>)instances);
        serverGroup.setNamedPorts((Map<String, Integer>)AbstractGoogleServerGroupCachingAgent.convertNamedPorts(manager));
        serverGroup.setSelfLink(manager.getSelfLink());
        serverGroup.setCurrentActions(manager.getCurrentActions());
        this.setLaunchConfig(serverGroup, manager, instanceTemplate, providerCache);
        this.setAutoscalerGroup(serverGroup, manager, instanceTemplate);
        if (instanceTemplate != null && (properties = instanceTemplate.getProperties()) != null) {
            serverGroup.setCanIpForward(properties.getCanIpForward());
            if (properties.getServiceAccounts() != null) {
                serverGroup.setInstanceTemplateServiceAccounts((Set<ServiceAccount>)ImmutableSet.copyOf((Collection)properties.getServiceAccounts()));
            }
            if (properties.getTags() != null && properties.getTags().getItems() != null) {
                serverGroup.setInstanceTemplateTags((Set<String>)ImmutableSet.copyOf((Collection)properties.getTags().getItems()));
            }
            if (properties.getLabels() != null) {
                serverGroup.setInstanceTemplateLabels((Map<String, String>)ImmutableMap.copyOf((Map)properties.getLabels()));
            }
            if (properties.getNetworkInterfaces() != null && !properties.getNetworkInterfaces().isEmpty() && properties.getNetworkInterfaces().get(0) != null) {
                serverGroup.setNetworkName(Utils.decorateXpnResourceIdIfNeeded(this.credentials.getProject(), ((NetworkInterface)properties.getNetworkInterfaces().get(0)).getNetwork()));
            }
        }
        serverGroup.setStatefulPolicy(manager.getStatefulPolicy());
        if (manager.getAutoHealingPolicies() != null && !manager.getAutoHealingPolicies().isEmpty()) {
            serverGroup.setAutoHealingPolicy((InstanceGroupManagerAutoHealingPolicy)manager.getAutoHealingPolicies().get(0));
        }
        AbstractGoogleServerGroupCachingAgent.populateAutoscaler(serverGroup, autoscaler);
        return serverGroup;
    }

    private void setRegionConfig(GoogleServerGroup serverGroup, InstanceGroupManager manager) {
        serverGroup.setRegional(manager.getZone() == null);
        if (serverGroup.getRegional().booleanValue()) {
            serverGroup.setRegion(Utils.getLocalName(manager.getRegion()));
            DistributionPolicy distributionPolicy = manager.getDistributionPolicy();
            ImmutableList<String> zones = AbstractGoogleServerGroupCachingAgent.getZones(distributionPolicy);
            serverGroup.setZones((Set<String>)ImmutableSet.copyOf(zones));
            serverGroup.setDistributionPolicy(new GoogleDistributionPolicy((List<String>)zones, AbstractGoogleServerGroupCachingAgent.getTargetShape(distributionPolicy)));
        } else {
            String zone = Utils.getLocalName(manager.getZone());
            serverGroup.setZone(zone);
            serverGroup.setZones((Set<String>)ImmutableSet.of((Object)zone));
            serverGroup.setRegion(this.credentials.regionFromZone(zone));
        }
    }

    private static ImmutableList<String> getZones(@Nullable DistributionPolicy distributionPolicy) {
        if (distributionPolicy == null || distributionPolicy.getZones() == null) {
            return ImmutableList.of();
        }
        return (ImmutableList)distributionPolicy.getZones().stream().map(z -> Utils.getLocalName(z.getZone())).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    private static String getTargetShape(@Nullable DistributionPolicy distributionPolicy) {
        if (distributionPolicy == null) {
            return null;
        }
        return distributionPolicy.getTargetShape();
    }

    @Nullable
    private static ImmutableMap<String, Integer> convertNamedPorts(InstanceGroupManager manager) {
        if (manager.getNamedPorts() == null) {
            return null;
        }
        return (ImmutableMap)manager.getNamedPorts().stream().filter(namedPort -> namedPort.getName() != null).filter(namedPort -> namedPort.getPort() != null).collect(ImmutableMap.toImmutableMap(NamedPort::getName, NamedPort::getPort));
    }

    private void setLaunchConfig(GoogleServerGroup serverGroup, InstanceGroupManager manager, @Nullable InstanceTemplate instanceTemplate, ProviderCache providerCache) {
        HashMap<String, Object> launchConfig = new HashMap<String, Object>();
        launchConfig.put("createdTime", Utils.getTimeFromTimestamp(manager.getCreationTimestamp()));
        if (instanceTemplate != null) {
            launchConfig.put("launchConfigurationName", instanceTemplate.getName());
            launchConfig.put("instanceTemplate", instanceTemplate);
            if (instanceTemplate.getProperties() != null) {
                ImmutableList<AttachedDisk> disks = AbstractGoogleServerGroupCachingAgent.getDisks(instanceTemplate);
                instanceTemplate.getProperties().setDisks(disks);
                if (instanceTemplate.getProperties().getMachineType() != null) {
                    launchConfig.put("instanceType", instanceTemplate.getProperties().getMachineType());
                }
                if (instanceTemplate.getProperties().getMinCpuPlatform() != null) {
                    launchConfig.put("minCpuPlatform", instanceTemplate.getProperties().getMinCpuPlatform());
                }
                this.setSourceImage(serverGroup, (Map<String, Object>)launchConfig, (List<AttachedDisk>)disks, providerCache);
            }
        }
        serverGroup.setLaunchConfig((Map<String, Object>)AbstractGoogleServerGroupCachingAgent.copyToImmutableMapWithoutNullValues(launchConfig));
    }

    private static ImmutableList<AttachedDisk> getDisks(InstanceTemplate template) {
        if (template.getProperties() == null || template.getProperties().getDisks() == null) {
            return ImmutableList.of();
        }
        List persistentDisks = (List)template.getProperties().getDisks().stream().filter(disk -> "PERSISTENT".equals(disk.getType())).collect(ImmutableList.toImmutableList());
        if (persistentDisks.isEmpty() || ((AttachedDisk)persistentDisks.get(0)).getBoot().booleanValue()) {
            return ImmutableList.copyOf((Collection)template.getProperties().getDisks());
        }
        ImmutableList.Builder sortedDisks = ImmutableList.builder();
        Optional<AttachedDisk> firstBootDisk = persistentDisks.stream().filter(AttachedDisk::getBoot).findFirst();
        firstBootDisk.ifPresent(arg_0 -> ((ImmutableList.Builder)sortedDisks).add(arg_0));
        template.getProperties().getDisks().stream().filter(disk -> disk.getBoot() == false).forEach(arg_0 -> ((ImmutableList.Builder)sortedDisks).add(arg_0));
        return sortedDisks.build();
    }

    private void setSourceImage(GoogleServerGroup serverGroup, Map<String, Object> launchConfig, List<AttachedDisk> disks, ProviderCache providerCache) {
        if (disks.isEmpty()) {
            return;
        }
        AttachedDisk firstDisk = disks.get(0);
        if (!firstDisk.getBoot().booleanValue()) {
            return;
        }
        if (firstDisk.getInitializeParams() != null && firstDisk.getInitializeParams().getSourceImage() != null) {
            String description;
            ImmutableMap<String, Object> buildInfo;
            String sourceImage = Utils.getLocalName(firstDisk.getInitializeParams().getSourceImage());
            launchConfig.put("imageId", sourceImage);
            String imageKey = Keys.getImageKey(this.getAccountName(), sourceImage);
            CacheData image = providerCache.get(Keys.Namespace.IMAGES.getNs(), imageKey);
            if (image != null && (buildInfo = AbstractGoogleServerGroupCachingAgent.createBuildInfo(description = (String)((Map)image.getAttributes().get("image")).get("description"))) != null) {
                serverGroup.setBuildInfo((Map)buildInfo);
            }
        }
    }

    @Nullable
    private static ImmutableMap<String, Object> createBuildInfo(@Nullable String imageDescription) {
        Map tags;
        if (imageDescription == null) {
            return null;
        }
        try {
            tags = IMAGE_DESCRIPTION_SPLITTER.split((CharSequence)imageDescription);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (!tags.containsKey("appversion")) {
            return null;
        }
        AppVersion appversion = AppVersion.parseName((String)((String)tags.get("appversion")));
        if (appversion == null) {
            return null;
        }
        HashMap<String, String> buildInfo = new HashMap<String, String>();
        buildInfo.put("package_name", appversion.getPackageName());
        buildInfo.put("version", appversion.getVersion());
        buildInfo.put("commit", appversion.getCommit());
        if (appversion.getBuildJobName() != null) {
            HashMap<String, String> jenkinsInfo = new HashMap<String, String>();
            jenkinsInfo.put("name", appversion.getBuildJobName());
            jenkinsInfo.put("number", appversion.getBuildNumber());
            if (tags.containsKey("build_host")) {
                jenkinsInfo.put("host", (String)tags.get("build_host"));
            }
            buildInfo.put("jenkins", (String)AbstractGoogleServerGroupCachingAgent.copyToImmutableMap(jenkinsInfo));
        }
        if (tags.containsKey("build_info_url")) {
            buildInfo.put("buildInfoUrl", (String)tags.get("build_info_url"));
        }
        return AbstractGoogleServerGroupCachingAgent.copyToImmutableMap(buildInfo);
    }

    private static <K, V> ImmutableMap<K, V> copyToImmutableMap(Map<K, V> map) {
        return (ImmutableMap)map.entrySet().stream().filter(e -> e.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void setAutoscalerGroup(GoogleServerGroup serverGroup, InstanceGroupManager manager, @Nullable InstanceTemplate instanceTemplate) {
        HashMap<String, Object> autoscalerGroup = new HashMap<String, Object>();
        if (manager.getTargetSize() != null) {
            autoscalerGroup.put("minSize", manager.getTargetSize());
            autoscalerGroup.put("maxSize", manager.getTargetSize());
            autoscalerGroup.put("desiredCapacity", manager.getTargetSize());
        }
        if (instanceTemplate != null && instanceTemplate.getProperties() != null && instanceTemplate.getProperties().getMetadata() != null && instanceTemplate.getProperties().getMetadata().getItems() != null) {
            ImmutableMap metadata = (ImmutableMap)instanceTemplate.getProperties().getMetadata().getItems().stream().filter(item -> item.getKey() != null).filter(item -> item.getValue() != null).collect(ImmutableMap.toImmutableMap(Metadata.Items::getKey, Metadata.Items::getValue));
            if (metadata.containsKey((Object)"global-load-balancer-names")) {
                autoscalerGroup.put("global-load-balancer-names", COMMA.splitToList((CharSequence)metadata.get((Object)"global-load-balancer-names")));
            }
            if (metadata.containsKey((Object)"load-balancer-names")) {
                autoscalerGroup.put("load-balancer-names", COMMA.splitToList((CharSequence)metadata.get((Object)"load-balancer-names")));
                List<String> loadBalancerNames = Utils.deriveNetworkLoadBalancerNamesFromTargetPoolUrls(manager.getTargetPools());
                serverGroup.setDisabled(loadBalancerNames.isEmpty());
            }
            if (metadata.containsKey((Object)"backend-service-names")) {
                autoscalerGroup.put("backend-service-names", COMMA.splitToList((CharSequence)metadata.get((Object)"backend-service-names")));
            }
            if (metadata.containsKey((Object)"region-backend-service-names")) {
                autoscalerGroup.put("region-backend-service-names", COMMA.splitToList((CharSequence)metadata.get((Object)"region-backend-service-names")));
            }
            if (metadata.containsKey((Object)"load-balancing-policy")) {
                try {
                    autoscalerGroup.put("load-balancing-policy", this.objectMapper.readValue((String)metadata.get((Object)"load-balancing-policy"), GoogleHttpLoadBalancingPolicy.class));
                }
                catch (IOException e) {
                    log.warn("Error parsing load balancing policy", (Throwable)e);
                }
            }
        }
        serverGroup.setAsg((Map<String, Object>)AbstractGoogleServerGroupCachingAgent.copyToImmutableMapWithoutNullValues(autoscalerGroup));
    }

    private static void populateAutoscaler(GoogleServerGroup serverGroup, @Nullable Autoscaler autoscaler) {
        if (autoscaler == null) {
            return;
        }
        AutoscalingPolicy autoscalingPolicy = autoscaler.getAutoscalingPolicy();
        if (autoscalingPolicy != null) {
            serverGroup.setAutoscalingPolicy(AbstractGoogleServerGroupCachingAgent.convertAutoscalingPolicy(autoscalingPolicy));
            HashMap<String, Object> autoscalingGroup = new HashMap<String, Object>(serverGroup.getAsg());
            autoscalingGroup.put("minSize", autoscalingPolicy.getMinNumReplicas());
            autoscalingGroup.put("maxSize", autoscalingPolicy.getMaxNumReplicas());
            serverGroup.setAsg((Map<String, Object>)AbstractGoogleServerGroupCachingAgent.copyToImmutableMapWithoutNullValues(autoscalingGroup));
        }
        if (autoscaler.getStatusDetails() != null) {
            serverGroup.setAutoscalingMessages((List)autoscaler.getStatusDetails().stream().map(AutoscalerStatusDetails::getMessage).filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
        }
    }

    private static GoogleAutoscalingPolicy convertAutoscalingPolicy(AutoscalingPolicy input) {
        GoogleAutoscalingPolicy.CpuUtilization cpu = AbstractGoogleServerGroupCachingAgent.convertCpuUtilization(input.getCpuUtilization());
        GoogleAutoscalingPolicy.LoadBalancingUtilization loadBalancing = AbstractGoogleServerGroupCachingAgent.convertLoadBalancingUtilization(input.getLoadBalancingUtilization());
        ImmutableList<GoogleAutoscalingPolicy.CustomMetricUtilization> customMetrics = AbstractGoogleServerGroupCachingAgent.convertCustomMetricUtilizations(input.getCustomMetricUtilizations());
        List<GoogleAutoscalingPolicy.ScalingSchedule> scalingSchedules = AbstractGoogleServerGroupCachingAgent.convertScalingSchedules(input.getScalingSchedules());
        GoogleAutoscalingPolicy output = new GoogleAutoscalingPolicy();
        output.setCoolDownPeriodSec(input.getCoolDownPeriodSec());
        output.setCpuUtilization(cpu);
        output.setCustomMetricUtilizations((List<GoogleAutoscalingPolicy.CustomMetricUtilization>)customMetrics);
        output.setScalingSchedules(scalingSchedules);
        output.setLoadBalancingUtilization(loadBalancing);
        output.setMaxNumReplicas(input.getMaxNumReplicas());
        output.setMinNumReplicas(input.getMinNumReplicas());
        output.setMode(AbstractGoogleServerGroupCachingAgent.convertAutoscalingMode(input.getMode()));
        output.setScaleInControl(AbstractGoogleServerGroupCachingAgent.convertScaleInControl(input.getScaleInControl()));
        return output;
    }

    @Nullable
    private static GoogleAutoscalingPolicy.CpuUtilization convertCpuUtilization(@Nullable AutoscalingPolicyCpuUtilization input) {
        if (input == null) {
            return null;
        }
        GoogleAutoscalingPolicy.CpuUtilization output = new GoogleAutoscalingPolicy.CpuUtilization();
        output.setUtilizationTarget(input.getUtilizationTarget());
        output.setPredictiveMethod(AbstractGoogleServerGroupCachingAgent.valueOf(GoogleAutoscalingPolicy.CpuUtilization.PredictiveMethod.class, input.getPredictiveMethod()));
        return output;
    }

    @Nullable
    private static GoogleAutoscalingPolicy.LoadBalancingUtilization convertLoadBalancingUtilization(@Nullable AutoscalingPolicyLoadBalancingUtilization input) {
        if (input == null) {
            return null;
        }
        GoogleAutoscalingPolicy.LoadBalancingUtilization output = new GoogleAutoscalingPolicy.LoadBalancingUtilization();
        output.setUtilizationTarget(input.getUtilizationTarget());
        return output;
    }

    @Nullable
    private static ImmutableList<GoogleAutoscalingPolicy.CustomMetricUtilization> convertCustomMetricUtilizations(@Nullable List<AutoscalingPolicyCustomMetricUtilization> input) {
        if (input == null) {
            return null;
        }
        return (ImmutableList)input.stream().map(AbstractGoogleServerGroupCachingAgent::convertCustomMetricUtilization).collect(ImmutableList.toImmutableList());
    }

    private static GoogleAutoscalingPolicy.CustomMetricUtilization convertCustomMetricUtilization(AutoscalingPolicyCustomMetricUtilization input) {
        GoogleAutoscalingPolicy.CustomMetricUtilization output = new GoogleAutoscalingPolicy.CustomMetricUtilization();
        output.setMetric(input.getMetric());
        output.setUtilizationTarget(input.getUtilizationTarget());
        output.setUtilizationTargetType(AbstractGoogleServerGroupCachingAgent.valueOf(GoogleAutoscalingPolicy.CustomMetricUtilization.UtilizationTargetType.class, input.getUtilizationTargetType()));
        return output;
    }

    private static GoogleAutoscalingPolicy.AutoscalingMode convertAutoscalingMode(@Nullable String input) {
        if (Objects.equals(input, "ONLY_UP")) {
            return GoogleAutoscalingPolicy.AutoscalingMode.ONLY_SCALE_OUT;
        }
        return AbstractGoogleServerGroupCachingAgent.valueOf(GoogleAutoscalingPolicy.AutoscalingMode.class, input);
    }

    private static GoogleAutoscalingPolicy.ScaleInControl convertScaleInControl(@Nullable AutoscalingPolicyScaleInControl input) {
        if (input == null) {
            return null;
        }
        GoogleAutoscalingPolicy.FixedOrPercent maxScaledInReplicas = null;
        if (input.getMaxScaledInReplicas() != null) {
            maxScaledInReplicas = new GoogleAutoscalingPolicy.FixedOrPercent();
            maxScaledInReplicas.setFixed(input.getMaxScaledInReplicas().getFixed());
            maxScaledInReplicas.setPercent(input.getMaxScaledInReplicas().getPercent());
        }
        GoogleAutoscalingPolicy.ScaleInControl output = new GoogleAutoscalingPolicy.ScaleInControl();
        output.setTimeWindowSec(input.getTimeWindowSec());
        output.setMaxScaledInReplicas(maxScaledInReplicas);
        return output;
    }

    private static List<GoogleAutoscalingPolicy.ScalingSchedule> convertScalingSchedules(@Nullable Map<String, AutoscalingPolicyScalingSchedule> map) {
        if (map == null) {
            return null;
        }
        ArrayList<GoogleAutoscalingPolicy.ScalingSchedule> scalingSchedules = new ArrayList<GoogleAutoscalingPolicy.ScalingSchedule>();
        for (String key : map.keySet()) {
            AutoscalingPolicyScalingSchedule input = map.get(key);
            GoogleAutoscalingPolicy.ScalingSchedule output = new GoogleAutoscalingPolicy.ScalingSchedule();
            output.setScheduleName(key);
            output.setScheduleDescription(input.getDescription());
            output.setEnabled(input.getDisabled() == false);
            output.setDuration(input.getDurationSec());
            output.setMinimumRequiredInstances(input.getMinRequiredReplicas());
            output.setScheduleCron(input.getSchedule());
            output.setTimezone(input.getTimeZone());
            scalingSchedules.add(output);
        }
        return scalingSchedules;
    }

    private static <T extends Enum<T>> T valueOf(Class<T> enumType, @Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumType, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <K, V> ImmutableMap<K, V> copyToImmutableMapWithoutNullValues(Map<K, V> map) {
        return (ImmutableMap)map.entrySet().stream().filter(e -> e.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    Collection<Instance> retrieveAllInstancesInRegion() throws IOException {
        Instances instancesApi = this.computeApiFactory.createInstances(this.credentials);
        BatchPaginatedComputeRequest instancesRequest = this.computeApiFactory.createPaginatedBatchRequest(this.credentials);
        this.getZonesForRegion().forEach(zone -> instancesRequest.queue(instancesApi.list((String)zone)));
        return instancesRequest.execute(this.getBatchContext(".instance"));
    }

    private Collection<InstanceTemplate> retrieveInstanceTemplates() throws IOException {
        InstanceTemplates instanceTemplatesApi = this.computeApiFactory.createInstanceTemplates(this.credentials);
        return instanceTemplatesApi.list().execute();
    }

    Collection<String> getZonesForRegion() {
        return Optional.ofNullable(this.credentials.getZonesFromRegion(this.region)).orElse((List<String>)ImmutableList.of());
    }

    String getBatchContext(String subcontext) {
        return String.join((CharSequence)".", this.getBatchContextPrefix(), subcontext);
    }

    abstract String getBatchContextPrefix();

    public String getProviderName() {
        return GoogleInfrastructureProvider.class.getName();
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return DATA_TYPES;
    }

    public String getAgentType() {
        return String.format("%s/%s/%s", this.getAccountName(), this.region, this.getClass().getSimpleName());
    }

    public String getOnDemandAgentType() {
        return this.getAgentType() + "-OnDemand";
    }

    public OnDemandMetricsSupport getMetricsSupport() {
        return this.onDemandMetricsSupport;
    }

    public String getAccountName() {
        return this.credentials.getName();
    }

    GoogleNamedAccountCredentials getCredentials() {
        return this.credentials;
    }

    GoogleComputeApiFactory getComputeApiFactory() {
        return this.computeApiFactory;
    }

    String getRegion() {
        return this.region;
    }

    private static final class TargetAndScope {
        private final String target;
        @Nullable
        private final String region;
        @Nullable
        private final String zone;

        static TargetAndScope forAutoscaler(Autoscaler autoscaler) {
            return new TargetAndScope(Utils.getLocalName(autoscaler.getTarget()), Utils.getLocalName(autoscaler.getRegion()), Utils.getLocalName(autoscaler.getZone()));
        }

        static TargetAndScope forInstanceGroupManager(InstanceGroupManager manager) {
            return new TargetAndScope(manager.getName(), Utils.getLocalName(manager.getRegion()), Utils.getLocalName(manager.getZone()));
        }

        @Generated
        public TargetAndScope(String target, @Nullable String region, @Nullable String zone) {
            this.target = target;
            this.region = region;
            this.zone = zone;
        }

        @Generated
        public String getTarget() {
            return this.target;
        }

        @Nullable
        @Generated
        public String getRegion() {
            return this.region;
        }

        @Nullable
        @Generated
        public String getZone() {
            return this.zone;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TargetAndScope)) {
                return false;
            }
            TargetAndScope other = (TargetAndScope)o;
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$zone = this.getZone();
            String other$zone = other.getZone();
            return !(this$zone == null ? other$zone != null : !this$zone.equals(other$zone));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $zone = this.getZone();
            result = result * 59 + ($zone == null ? 43 : $zone.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractGoogleServerGroupCachingAgent.TargetAndScope(target=" + this.getTarget() + ", region=" + this.getRegion() + ", zone=" + this.getZone() + ")";
        }
    }
}

