/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.agent.util;

import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.services.compute.ComputeRequest;
import com.netflix.spinnaker.clouddriver.google.batch.GoogleBatchRequest;
import com.netflix.spinnaker.clouddriver.google.provider.agent.AbstractGoogleCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.util.PaginatedCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public abstract class PaginatedRequest<T> {
    private final AbstractGoogleCachingAgent cachingAgent;

    public PaginatedRequest(AbstractGoogleCachingAgent cachingAgent) {
        this.cachingAgent = cachingAgent;
    }

    public void queue(GoogleBatchRequest googleBatchRequest, JsonBatchCallback callback, final String instrumentationContext) throws IOException {
        PaginatedCallback paginatedCallback = new PaginatedCallback<T>(callback){

            @Override
            protected void requestNextBatch(T t) throws IOException {
                String nextPageToken = PaginatedRequest.this.getNextPageToken(t);
                GoogleBatchRequest batch = PaginatedRequest.this.cachingAgent.buildGoogleBatchRequest();
                if (nextPageToken != null) {
                    batch.queue(PaginatedRequest.this.request(nextPageToken), this);
                }
                PaginatedRequest.this.cachingAgent.executeIfRequestsAreQueued(batch, instrumentationContext);
            }
        };
        googleBatchRequest.queue(this.request(null), paginatedCallback);
    }

    public <U> List<U> timeExecute(Function<T, List<U>> itemExtractor, String api, String ... tags) throws IOException {
        Object results;
        String pageToken = null;
        ArrayList<U> resultList = new ArrayList<U>();
        do {
            List<U> newItems;
            if ((newItems = itemExtractor.apply(results = this.cachingAgent.timeExecute((AbstractGoogleClientRequest)this.request(pageToken), api, tags))) == null) continue;
            resultList.addAll(newItems);
        } while ((pageToken = this.getNextPageToken(results)) != null);
        return resultList;
    }

    protected abstract String getNextPageToken(T var1);

    protected abstract ComputeRequest<T> request(String var1);
}

