/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeApiFactory;
import com.netflix.spinnaker.clouddriver.google.config.GoogleConfigurationProperties;
import com.netflix.spinnaker.clouddriver.google.provider.GoogleInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.google.provider.agent.AbstractGoogleCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.AbstractGoogleServerGroupCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleBackendServiceCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleGlobalAddressCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleHealthCheckCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleHttpHealthCheckCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleHttpLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleImageCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleInstanceCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleInternalHttpLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleInternalLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleNetworkCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleNetworkLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleRegionalAddressCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleRegionalServerGroupCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleSecurityGroupCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleSslCertificateCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleSslLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleSubnetCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleTcpLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.google.provider.agent.GoogleZonalServerGroupCachingAgent;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class GoogleCredentialsLifecycleHandler
implements CredentialsLifecycleHandler<GoogleNamedAccountCredentials> {
    private final GoogleInfrastructureProvider googleInfrastructureProvider;
    private final GoogleConfigurationProperties googleConfigurationProperties;
    private final GoogleComputeApiFactory googleComputeApiFactory;
    private final ObjectMapper objectMapper;
    private final Registry registry;
    private final String clouddriverUserAgentApplicationName;

    public void credentialsAdded(GoogleNamedAccountCredentials credentials) {
        this.addAgentFor(credentials);
    }

    public void credentialsUpdated(GoogleNamedAccountCredentials credentials) {
        this.googleInfrastructureProvider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
        this.addAgentFor(credentials);
    }

    public void credentialsDeleted(GoogleNamedAccountCredentials credentials) {
        this.googleInfrastructureProvider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
    }

    private void addAgentFor(GoogleNamedAccountCredentials credentials) {
        List<Map> regionZonesMap = credentials.getRegions();
        ArrayList<String> regions = new ArrayList<String>();
        for (Map map : regionZonesMap) {
            String reg = String.valueOf(map.get("name"));
            regions.add(reg);
        }
        LinkedList<AbstractGoogleCachingAgent> googleCachingAgents = new LinkedList<AbstractGoogleCachingAgent>();
        LinkedList<AbstractGoogleServerGroupCachingAgent> googleServerGroupAgents = new LinkedList<AbstractGoogleServerGroupCachingAgent>();
        googleCachingAgents.add(new GoogleSecurityGroupCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        googleCachingAgents.add(new GoogleNetworkCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        googleCachingAgents.add(new GoogleGlobalAddressCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        googleCachingAgents.add(new GoogleHealthCheckCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        googleCachingAgents.add(new GoogleHttpHealthCheckCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        googleCachingAgents.add(new GoogleSslLoadBalancerCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        googleCachingAgents.add(new GoogleSslCertificateCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        googleCachingAgents.add(new GoogleTcpLoadBalancerCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        googleCachingAgents.add(new GoogleBackendServiceCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        googleCachingAgents.add(new GoogleInstanceCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        googleCachingAgents.add(new GoogleImageCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry, credentials.getImageProjects(), this.googleConfigurationProperties.getBaseImageProjects()));
        googleCachingAgents.add(new GoogleHttpLoadBalancerCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry));
        for (String region : regions) {
            googleCachingAgents.add(new GoogleSubnetCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry, region));
            googleCachingAgents.add(new GoogleRegionalAddressCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry, region));
            googleCachingAgents.add(new GoogleInternalLoadBalancerCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry, region));
            googleCachingAgents.add(new GoogleInternalHttpLoadBalancerCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry, region));
            googleCachingAgents.add(new GoogleNetworkLoadBalancerCachingAgent(this.clouddriverUserAgentApplicationName, credentials, this.objectMapper, this.registry, region));
            googleServerGroupAgents.add(new GoogleRegionalServerGroupCachingAgent(credentials, this.googleComputeApiFactory, this.registry, region, this.objectMapper));
            googleServerGroupAgents.add(new GoogleZonalServerGroupCachingAgent(credentials, this.googleComputeApiFactory, this.registry, region, this.objectMapper));
        }
        this.googleInfrastructureProvider.addAgents(googleCachingAgents);
        this.googleInfrastructureProvider.addAgents(googleServerGroupAgents);
    }

    @Generated
    public GoogleCredentialsLifecycleHandler(GoogleInfrastructureProvider googleInfrastructureProvider, GoogleConfigurationProperties googleConfigurationProperties, GoogleComputeApiFactory googleComputeApiFactory, ObjectMapper objectMapper, Registry registry, String clouddriverUserAgentApplicationName) {
        this.googleInfrastructureProvider = googleInfrastructureProvider;
        this.googleConfigurationProperties = googleConfigurationProperties;
        this.googleComputeApiFactory = googleComputeApiFactory;
        this.objectMapper = objectMapper;
        this.registry = registry;
        this.clouddriverUserAgentApplicationName = clouddriverUserAgentApplicationName;
    }
}

