/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponseException;
import com.google.api.services.compute.ComputeRequest;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.google.compute.BatchComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.BatchPaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequestImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

final class BatchPaginatedComputeRequestImpl<ComputeRequestT extends ComputeRequest<ResponseT>, ResponseT, ItemT>
implements BatchPaginatedComputeRequest<ComputeRequestT, ItemT> {
    private final Supplier<BatchComputeRequest<ComputeRequestT, ResponseT>> batchRequestSupplier;
    private final Map<PaginatedComputeRequestImpl<ComputeRequestT, ResponseT, ItemT>, String> nextPageTokens = new HashMap<PaginatedComputeRequestImpl<ComputeRequestT, ResponseT, ItemT>, String>();
    private IOException exception;

    BatchPaginatedComputeRequestImpl(Supplier<BatchComputeRequest<ComputeRequestT, ResponseT>> batchRequestSupplier) {
        this.batchRequestSupplier = batchRequestSupplier;
    }

    @Override
    public void queue(PaginatedComputeRequest<ComputeRequestT, ItemT> request) {
        this.nextPageTokens.put((PaginatedComputeRequestImpl)request, "");
    }

    @Override
    public ImmutableSet<ItemT> execute(String batchContext) throws IOException {
        ImmutableSet.Builder results = ImmutableSet.builder();
        while (!this.nextPageTokens.isEmpty() && this.exception == null) {
            BatchComputeRequest pageRequest = this.batchRequestSupplier.get();
            for (Map.Entry<PaginatedComputeRequestImpl<ComputeRequestT, ResponseT, ItemT>, String> entry : this.nextPageTokens.entrySet()) {
                GoogleComputeRequest request = entry.getKey().requestGenerator.createRequest(entry.getValue());
                entry.getKey().requestModifier.accept(request.getRequest());
                pageRequest.queue(request, new PageCallback(entry.getKey(), results));
            }
            pageRequest.execute(batchContext);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return results.build();
    }

    private class PageCallback
    extends JsonBatchCallback<ResponseT> {
        private final PaginatedComputeRequestImpl<ComputeRequestT, ResponseT, ItemT> request;
        private final ImmutableSet.Builder<ItemT> results;

        private PageCallback(PaginatedComputeRequestImpl<ComputeRequestT, ResponseT, ItemT> request, ImmutableSet.Builder<ItemT> results) {
            this.request = request;
            this.results = results;
        }

        public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
            BatchPaginatedComputeRequestImpl.this.nextPageTokens.remove(this.request);
            HttpResponseException newException = new HttpResponseException.Builder(e.getCode(), e.getMessage(), responseHeaders).setMessage(e.getMessage()).build();
            if (BatchPaginatedComputeRequestImpl.this.exception == null) {
                BatchPaginatedComputeRequestImpl.this.exception = newException;
            } else {
                BatchPaginatedComputeRequestImpl.this.exception.addSuppressed((Throwable)newException);
            }
        }

        public void onSuccess(ResponseT response, HttpHeaders responseHeaders) {
            Optional.ofNullable(this.request.itemRetriever.getItems(response)).ifPresent(arg_0 -> this.results.addAll(arg_0));
            String nextPageToken = this.request.nextPageTokenRetriever.getNextPageToken(response);
            if (Strings.isNullOrEmpty((String)nextPageToken)) {
                BatchPaginatedComputeRequestImpl.this.nextPageTokens.remove(this.request);
            } else {
                BatchPaginatedComputeRequestImpl.this.nextPageTokens.put(this.request, nextPageToken);
            }
        }
    }
}

