/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.ComputeRequest;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.BatchComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.BatchComputeRequestImpl;
import com.netflix.spinnaker.clouddriver.google.compute.BatchPaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.BatchPaginatedComputeRequestImpl;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleServerGroupManagers;
import com.netflix.spinnaker.clouddriver.google.compute.Images;
import com.netflix.spinnaker.clouddriver.google.compute.InstanceTemplates;
import com.netflix.spinnaker.clouddriver.google.compute.Instances;
import com.netflix.spinnaker.clouddriver.google.compute.RegionAutoscalers;
import com.netflix.spinnaker.clouddriver.google.compute.RegionGoogleServerGroupManagers;
import com.netflix.spinnaker.clouddriver.google.compute.RegionInstanceGroupManagers;
import com.netflix.spinnaker.clouddriver.google.compute.ZoneAutoscalers;
import com.netflix.spinnaker.clouddriver.google.compute.ZoneGoogleServerGroupManagers;
import com.netflix.spinnaker.clouddriver.google.compute.ZoneInstanceGroupManagers;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class GoogleComputeApiFactory {
    private final GoogleOperationPoller operationPoller;
    private final Registry registry;
    private String clouddriverUserAgentApplicationName;
    private ListeningExecutorService batchExecutor;

    @Autowired
    public GoogleComputeApiFactory(GoogleOperationPoller operationPoller, Registry registry, String clouddriverUserAgentApplicationName, @Qualifier(value="batchRequestExecutor") ListeningExecutorService batchExecutor) {
        this.operationPoller = operationPoller;
        this.registry = registry;
        this.clouddriverUserAgentApplicationName = clouddriverUserAgentApplicationName;
        this.batchExecutor = batchExecutor;
    }

    public Images createImages(GoogleNamedAccountCredentials credentials) {
        return new Images(credentials, this.operationPoller, this.registry);
    }

    public Instances createInstances(GoogleNamedAccountCredentials credentials) {
        return new Instances(credentials, this.operationPoller, this.registry);
    }

    public InstanceTemplates createInstanceTemplates(GoogleNamedAccountCredentials credentials) {
        return new InstanceTemplates(credentials, this.operationPoller, this.registry);
    }

    public RegionAutoscalers createRegionAutoscalers(GoogleNamedAccountCredentials credentials) {
        return new RegionAutoscalers(credentials, this.operationPoller, this.registry);
    }

    public RegionInstanceGroupManagers createRegionInstanceGroupManagers(GoogleNamedAccountCredentials credentials) {
        return new RegionInstanceGroupManagers(credentials, this.operationPoller, this.registry);
    }

    public ZoneAutoscalers createZoneAutoscalers(GoogleNamedAccountCredentials credentials) {
        return new ZoneAutoscalers(credentials, this.operationPoller, this.registry);
    }

    public ZoneInstanceGroupManagers createZoneInstanceGroupManagers(GoogleNamedAccountCredentials credentials) {
        return new ZoneInstanceGroupManagers(credentials, this.operationPoller, this.registry);
    }

    public GoogleServerGroupManagers createServerGroupManagers(GoogleNamedAccountCredentials credentials, GoogleServerGroup.View serverGroup) {
        return serverGroup.getRegional() != false ? new RegionGoogleServerGroupManagers(credentials, this.operationPoller, this.registry, serverGroup.getName(), serverGroup.getRegion()) : new ZoneGoogleServerGroupManagers(credentials, this.operationPoller, this.registry, serverGroup.getName(), serverGroup.getZone());
    }

    public <RequestT extends ComputeRequest<ResponseT>, ResponseT> BatchComputeRequest<RequestT, ResponseT> createBatchRequest(GoogleNamedAccountCredentials credentials) {
        return new BatchComputeRequestImpl(credentials.getCompute(), this.registry, this.clouddriverUserAgentApplicationName, this.batchExecutor);
    }

    public <ComputeRequestT extends ComputeRequest<ResponseT>, ResponseT, ItemT> BatchPaginatedComputeRequest<ComputeRequestT, ItemT> createPaginatedBatchRequest(GoogleNamedAccountCredentials credentials) {
        return new BatchPaginatedComputeRequestImpl(() -> this.createBatchRequest(credentials));
    }
}

