/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.converters;

import com.netflix.spinnaker.clouddriver.google.GoogleOperation;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeApiFactory;
import com.netflix.spinnaker.clouddriver.google.config.GoogleConfigurationProperties;
import com.netflix.spinnaker.clouddriver.google.deploy.converters.GoogleAtomicOperationConverterHelper;
import com.netflix.spinnaker.clouddriver.google.deploy.description.StatefullyUpdateBootImageDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.StatefullyUpdateBootImageAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsConverter;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@GoogleOperation(value="statefullyUpdateBootImage")
@Component
public class StatefullyUpdateBootImageOperationConverter
extends AbstractAtomicOperationsCredentialsConverter<GoogleNamedAccountCredentials> {
    private final GoogleClusterProvider clusterProvider;
    private final GoogleComputeApiFactory computeApiFactory;
    private final GoogleConfigurationProperties googleConfigurationProperties;

    @Autowired
    public StatefullyUpdateBootImageOperationConverter(GoogleClusterProvider clusterProvider, GoogleComputeApiFactory computeApiFactory, GoogleConfigurationProperties googleConfigurationProperties) {
        this.clusterProvider = clusterProvider;
        this.computeApiFactory = computeApiFactory;
        this.googleConfigurationProperties = googleConfigurationProperties;
    }

    public StatefullyUpdateBootImageAtomicOperation convertOperation(Map input) {
        return new StatefullyUpdateBootImageAtomicOperation(this.clusterProvider, this.computeApiFactory, this.googleConfigurationProperties, this.convertDescription(input));
    }

    public StatefullyUpdateBootImageDescription convertDescription(Map input) {
        return GoogleAtomicOperationConverterHelper.convertDescription(input, this, StatefullyUpdateBootImageDescription.class);
    }
}

