/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.validators;

import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.description.BaseGoogleInstanceDescription;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoHealingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoscalingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleDisk;
import com.netflix.spinnaker.clouddriver.google.model.GoogleDiskType;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstanceTypeDisk;
import com.netflix.spinnaker.clouddriver.google.security.GoogleCredentials;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class StandardGceAttributeValidator
implements GroovyObject {
    private String context;
    private ValidationErrors errors;
    private Object customInstanceRegExp;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public StandardGceAttributeValidator(String context, ValidationErrors errors) {
        ValidationErrors validationErrors;
        String string;
        MetaClass metaClass;
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        String string2 = "(.*)-?custom-(\\d{1,2})-(\\d{3,6})(-ext)?";
        this.customInstanceRegExp = string2;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.context = string = context;
        this.errors = validationErrors = errors;
    }

    public Object validateNotEmpty(Object value, String attribute) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        return callSiteArray[0].callCurrent((GroovyObject)this, value, (Object)attribute, (Object)attribute);
    }

    public Object validateNotEmptyAsPart(Object value, String attribute, String part) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)value) || value instanceof Number) {
            return true;
        }
        callSiteArray[1].call((Object)this.errors, (Object)attribute, (Object)new GStringImpl(new Object[]{this.context, part}, new String[]{"", ".", ".empty"}));
        return false;
    }

    public Object validateName(String value, String attribute) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[2].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, (Object)attribute);
        }
        return this.validateNameAsPart(value, attribute, attribute);
    }

    public Object validateNameAsPart(String value, String attribute, String part) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        Object result = callSiteArray[3].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, (Object)part);
        return result;
    }

    public Object validateCredentials(String accountName, CredentialsRepository<GoogleNamedAccountCredentials> credentialsRepository) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        Object result = callSiteArray[4].callCurrent((GroovyObject)this, (Object)accountName, (Object)"credentials");
        if (DefaultTypeTransformation.booleanUnbox((Object)result)) {
            Object credentials = callSiteArray[5].call(credentialsRepository, (Object)accountName);
            if (!(callSiteArray[6].callGetPropertySafe(credentials) instanceof GoogleCredentials)) {
                callSiteArray[7].call((Object)this.errors, (Object)"credentials", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".credentials.invalid"}));
                result = false;
            }
        }
        return result;
    }

    public Object validateRegion(String region, GoogleNamedAccountCredentials credentials) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callCurrent((GroovyObject)this, (Object)region, (Object)"region")) && DefaultTypeTransformation.booleanUnbox((Object)((Object)credentials))) {
            if (!ScriptBytecodeAdapter.isCase((Object)region, (Object)callSiteArray[9].callGroovyObjectGetProperty((Object)credentials))) {
                return callSiteArray[10].call((Object)this.errors, (Object)"region", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".region.invalid"}));
            }
            if (!ScriptBytecodeAdapter.isCase((Object)region, (Object)ScriptBytecodeAdapter.getPropertySpreadSafe(StandardGceAttributeValidator.class, (Object)callSiteArray[11].callGroovyObjectGetProperty((Object)credentials), (String)"name"))) {
                return callSiteArray[12].call((Object)this.errors, (Object)"region", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".region.unconfigured"}));
            }
            return null;
        }
        return null;
    }

    public Object validateZone(String zone, GoogleNamedAccountCredentials credentials) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callCurrent((GroovyObject)this, (Object)zone, (Object)"zone")) && DefaultTypeTransformation.booleanUnbox((Object)((Object)credentials))) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call((Object)credentials, (Object)zone))) {
                return callSiteArray[15].call((Object)this.errors, (Object)"zone", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".zone.invalid"}));
            }
            if (!ScriptBytecodeAdapter.isCase((Object)callSiteArray[16].call((Object)credentials, (Object)zone), (Object)ScriptBytecodeAdapter.getPropertySpreadSafe(StandardGceAttributeValidator.class, (Object)callSiteArray[17].callGroovyObjectGetProperty((Object)credentials), (String)"name"))) {
                return callSiteArray[18].call((Object)this.errors, (Object)"zone", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".zone.unconfigured"}));
            }
            return null;
        }
        return null;
    }

    public Object validateNetwork(String network) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        return callSiteArray[19].callCurrent((GroovyObject)this, (Object)network, (Object)"network");
    }

    public Object validateNonNegativeLong(long value, String attribute) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        Boolean result = true;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigL() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (value < (long)0) {
                callSiteArray[20].call((Object)this.errors, (Object)attribute, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".negative"}));
                result = false;
            }
        } else if (value < (long)0) {
            callSiteArray[21].call((Object)this.errors, (Object)attribute, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".negative"}));
            result = false;
        }
        return result;
    }

    public Object validateInRangeExclusive(double value, double min, double max, String attribute) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        Boolean result = true;
        if (!BytecodeInterface8.isOrigD() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (value <= min || !(value < max)) {
                callSiteArray[22].call((Object)this.errors, (Object)attribute, (Object)new GStringImpl(new Object[]{this.context, attribute, min, max}, new String[]{"", ".", " must be between ", " and ", "."}));
                result = false;
            }
        } else if (value <= min || !(value < max)) {
            callSiteArray[23].call((Object)this.errors, (Object)attribute, (Object)new GStringImpl(new Object[]{this.context, attribute, min, max}, new String[]{"", ".", " must be between ", " and ", "."}));
            result = false;
        }
        return result;
    }

    public Object validateInRangeInclusive(int value, int min, int max, String attribute) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        Boolean result = true;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (value < min || value > max) {
                callSiteArray[24].call((Object)this.errors, (Object)attribute, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".rangeViolation"}), (Object)new GStringImpl(new Object[]{this.context, attribute, min, max}, new String[]{"", ".", " must be between ", " and ", ", inclusive."}));
                result = false;
            }
        } else if (value < min || value > max) {
            callSiteArray[25].call((Object)this.errors, (Object)attribute, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".rangeViolation"}), (Object)new GStringImpl(new Object[]{this.context, attribute, min, max}, new String[]{"", ".", " must be between ", " and ", ", inclusive."}));
            result = false;
        }
        return result;
    }

    public Object validateMaxNotLessThanMin(long minValue, long maxValue, String minAttribute, String maxAttribute) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        Boolean result = true;
        if (!BytecodeInterface8.isOrigL() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (maxValue < minValue) {
                callSiteArray[26].call((Object)this.errors, (Object)maxAttribute, (Object)new GStringImpl(new Object[]{this.context, maxAttribute}, new String[]{"", ".", ".lessThanMin"}), (Object)new GStringImpl(new Object[]{this.context, maxAttribute, this.context, minAttribute}, new String[]{"", ".", " must not be less than ", ".", "."}));
                result = false;
            }
        } else if (maxValue < minValue) {
            callSiteArray[27].call((Object)this.errors, (Object)maxAttribute, (Object)new GStringImpl(new Object[]{this.context, maxAttribute}, new String[]{"", ".", ".lessThanMin"}), (Object)new GStringImpl(new Object[]{this.context, maxAttribute, this.context, minAttribute}, new String[]{"", ".", " must not be less than ", ".", "."}));
            result = false;
        }
        return result;
    }

    public Object validateServerGroupName(String serverGroupName) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[28].callCurrent((GroovyObject)this, (Object)serverGroupName, (Object)"serverGroupName");
        }
        return this.validateName(serverGroupName, "serverGroupName");
    }

    public Object validateImage(BaseGoogleInstanceDescription.ImageSource imageSource, String image, Artifact imageArtifact) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)imageSource), (Object)callSiteArray[29].callGetProperty(BaseGoogleInstanceDescription.ImageSource.class))) {
                return callSiteArray[30].callCurrent((GroovyObject)this, (Object)imageArtifact);
            }
            return callSiteArray[31].callCurrent((GroovyObject)this, (Object)image, (Object)"image");
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)imageSource), (Object)callSiteArray[32].callGetProperty(BaseGoogleInstanceDescription.ImageSource.class))) {
            return this.validateImageArtifact(imageArtifact);
        }
        return callSiteArray[33].callCurrent((GroovyObject)this, (Object)image, (Object)"image");
    }

    public Object validateImageArtifact(Artifact imageArtifact) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[34].callCurrent((GroovyObject)this, (Object)imageArtifact, (Object)"imageArtifact"))) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[35].call((Object)imageArtifact), (Object)callSiteArray[36].callGetProperty(GCEUtil.class))) {
            return callSiteArray[37].call((Object)this.errors, (Object)"imageArtifact.type", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".imageArtifact.type.invalid"}));
        }
        return null;
    }

    public Object validateImageName(String imageName) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        return callSiteArray[38].callCurrent((GroovyObject)this, (Object)imageName, (Object)"imageName");
    }

    public Object validateNameList(List<String> names, String componentDescription) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        return callSiteArray[39].callCurrent((GroovyObject)this, names, (Object)componentDescription, (Object)false);
    }

    public Object validateOptionalNameList(List<String> names, String componentDescription) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        return callSiteArray[40].callCurrent((GroovyObject)this, names, (Object)componentDescription, (Object)true);
    }

    public Object validateNameListHelper(List<String> names, String componentDescription, boolean emptyListIsOk) {
        Reference componentDescription2 = new Reference((Object)componentDescription);
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? emptyListIsOk && !DefaultTypeTransformation.booleanUnbox(names) : emptyListIsOk && !DefaultTypeTransformation.booleanUnbox(names)) {
            return true;
        }
        Reference result = new Reference(callSiteArray[41].callCurrent((GroovyObject)this, names, (Object)new GStringImpl(new Object[]{(String)componentDescription2.get()}, new String[]{"", "s"})));
        public final class _validateNameListHelper_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private /* synthetic */ Reference componentDescription;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateNameListHelper_closure1(Object _outerInstance, Object _thisObject, Reference result, Reference componentDescription) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _validateNameListHelper_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.result = reference2 = result;
                this.componentDescription = reference = componentDescription;
            }

            public Object doCall(Object value, Object index) {
                CallSite[] callSiteArray = _validateNameListHelper_closure1.$getCallSiteArray();
                Object object = callSiteArray[0].call(this.result.get(), callSiteArray[1].callCurrent((GroovyObject)this, value, (Object)new GStringImpl(new Object[]{this.componentDescription.get()}, new String[]{"", "s"}), (Object)new GStringImpl(new Object[]{this.componentDescription.get(), index}, new String[]{"", "", ""})));
                this.result.set(object);
                return object;
            }

            @Generated
            public Object call(Object value, Object index) {
                CallSite[] callSiteArray = _validateNameListHelper_closure1.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, value, index);
            }

            @Generated
            public Object getResult() {
                CallSite[] callSiteArray = _validateNameListHelper_closure1.$getCallSiteArray();
                return this.result.get();
            }

            @Generated
            public String getComponentDescription() {
                CallSite[] callSiteArray = _validateNameListHelper_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.componentDescription.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateNameListHelper_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "and";
                stringArray[1] = "validateNameAsPart";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _validateNameListHelper_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateNameListHelper_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateNameListHelper_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[42].call(names, (Object)new _validateNameListHelper_closure1(this, this, result, componentDescription2));
        return result.get();
    }

    public Object validateInstanceIds(List<String> instanceIds) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        return callSiteArray[43].callCurrent((GroovyObject)this, instanceIds, (Object)"instanceId");
    }

    public Object validateInstanceName(String instanceName) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[44].callCurrent((GroovyObject)this, (Object)instanceName, (Object)"instanceName");
        }
        return this.validateName(instanceName, "instanceName");
    }

    public Object validateInstanceType(String instanceType, String location, GoogleNamedAccountCredentials credentials) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        callSiteArray[45].callCurrent((GroovyObject)this, (Object)instanceType, (Object)"instanceType");
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].callSafe((Object)instanceType, (Object)"custom"))) {
            boolean extendMemory = false;
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callSafe((Object)instanceType, (Object)"ext"))) {
                extendMemory = true;
            }
            return callSiteArray[48].callCurrent((GroovyObject)this, (Object)instanceType, (Object)location, (Object)credentials, (Object)extendMemory);
        }
        return null;
    }

    public Object validateCustomInstanceType(String instanceType, String location, GoogleNamedAccountCredentials credentials, boolean extendMemory) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        Matcher customTypeMatcher = ScriptBytecodeAdapter.findRegex((Object)instanceType, (Object)this.customInstanceRegExp);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[49].call((Object)customTypeMatcher))) {
            callSiteArray[50].call((Object)this.errors, (Object)"instanceType", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), (Object)"Custom instance string must match pattern /(.*)-?custom-(\\d{1,2})-(\\d{3,6})(-ext)?/.");
            return false;
        }
        Object vCpuCount = callSiteArray[51].call(callSiteArray[52].call((Object)customTypeMatcher, (Object)2));
        Object memory = callSiteArray[53].call(callSiteArray[54].call((Object)customTypeMatcher, (Object)3));
        Object memoryInGbs = callSiteArray[55].call(memory, (Object)1024);
        Object maxMemory = callSiteArray[56].call(vCpuCount, (Object)8);
        Object minMemory = callSiteArray[57].call(callSiteArray[58].call(Math.class, callSiteArray[59].call(callSiteArray[60].call((Object)$const$0, vCpuCount), (Object)4)), (Object)4);
        if (ScriptBytecodeAdapter.compareLessThan((Object)vCpuCount, (Object)1)) {
            callSiteArray[61].call((Object)this.errors, (Object)"instanceType", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), (Object)"vCPU count must be greater than or equal to 1.");
            return false;
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)vCpuCount, (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[62].call(vCpuCount, (Object)2), (Object)1)) {
                callSiteArray[63].call((Object)this.errors, (Object)"instanceType", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), (Object)"Above 1, vCPU count must be even.");
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)vCpuCount, (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[64].call(vCpuCount, (Object)2), (Object)1)) {
            callSiteArray[65].call((Object)this.errors, (Object)"instanceType", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), (Object)"Above 1, vCPU count must be even.");
        }
        if (!extendMemory) {
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)memoryInGbs, (Object)maxMemory)) {
                callSiteArray[66].call((Object)this.errors, (Object)"instanceType", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), (Object)"Memory per vCPU must be less than 8GB.");
            }
            if (ScriptBytecodeAdapter.compareLessThan((Object)memoryInGbs, (Object)minMemory)) {
                callSiteArray[67].call((Object)this.errors, (Object)"instanceType", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), (Object)"Memory per vCPU must be greater than 0.5GB.");
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[68].call(memory, (Object)256), (Object)0)) {
            callSiteArray[69].call((Object)this.errors, (Object)"instanceType", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), (Object)"Total memory must be a multiple of 256MB.");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)location)) {
            if (ScriptBytecodeAdapter.isCase((Object)location, (Object)callSiteArray[70].callGroovyObjectGetProperty((Object)credentials))) {
                Object vCpuMaxForLocation = callSiteArray[71].callGetPropertySafe(callSiteArray[72].call(callSiteArray[73].callGroovyObjectGetProperty((Object)credentials), (Object)location));
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)vCpuCount, (Object)vCpuMaxForLocation)) {
                    return callSiteArray[74].call((Object)this.errors, (Object)"instanceType", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), (Object)new GStringImpl(new Object[]{location, vCpuMaxForLocation}, new String[]{"", " does not support more than ", " vCPUs."}));
                }
                return null;
            }
            return callSiteArray[75].call((Object)this.errors, (Object)"instanceType", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), (Object)new GStringImpl(new Object[]{location}, new String[]{"", " not found."}));
        }
        return null;
    }

    public Object validateMinCpuPlatform(String minCpuPlatform, String location, GoogleNamedAccountCredentials credentials) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[76].callSafe(callSiteArray[77].call(callSiteArray[78].callGroovyObjectGetProperty((Object)credentials), (Object)location), (Object)minCpuPlatform))) {
            return callSiteArray[79].call((Object)this.errors, (Object)"minCpuPlatform", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".minCpuPlatform.invalid"}), (Object)new GStringImpl(new Object[]{minCpuPlatform, location}, new String[]{"CPU platform ", " is not available in ", "."}));
        }
        return null;
    }

    public Object validateInstanceTypeDisks(GoogleInstanceTypeDisk instanceTypeDisk, List<GoogleDisk> specifiedDisks) {
        Reference instanceTypeDisk2 = new Reference((Object)instanceTypeDisk);
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        public final class _validateInstanceTypeDisks_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateInstanceTypeDisks_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object disk, Object index) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure2.$getCallSiteArray();
                callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].callGetProperty(disk), (Object)"disks", (Object)new GStringImpl(new Object[]{index}, new String[]{"disk", ".type"}));
                callSiteArray[2].callCurrent((GroovyObject)this, callSiteArray[3].callGetProperty(disk), (Object)"disks", (Object)new GStringImpl(new Object[]{index}, new String[]{"disk", ".sizeGb"}));
                Object object = callSiteArray[5].callGetProperty(disk);
                return callSiteArray[4].callCurrent((GroovyObject)this, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0), (Object)new GStringImpl(new Object[]{index}, new String[]{"disk", ".sizeGb"}));
            }

            @Generated
            public Object call(Object disk, Object index) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure2.$getCallSiteArray();
                return callSiteArray[6].callCurrent((GroovyObject)this, disk, index);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "validateNotEmptyAsPart";
                stringArray[1] = "type";
                stringArray[2] = "validateNotEmptyAsPart";
                stringArray[3] = "sizeGb";
                stringArray[4] = "validateNonNegativeLong";
                stringArray[5] = "sizeGb";
                stringArray[6] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _validateInstanceTypeDisks_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateInstanceTypeDisks_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateInstanceTypeDisks_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[80].call(specifiedDisks, (Object)new _validateInstanceTypeDisks_closure2(this, this));
        if (DefaultTypeTransformation.booleanUnbox(specifiedDisks)) {
            public final class _validateInstanceTypeDisks_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _validateInstanceTypeDisks_closure3(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _validateInstanceTypeDisks_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _validateInstanceTypeDisks_closure3.$getCallSiteArray();
                    return callSiteArray[0].callGetProperty(it);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _validateInstanceTypeDisks_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "persistent";
                    return new CallSiteArray(_validateInstanceTypeDisks_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _validateInstanceTypeDisks_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            int persistentDiskCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[81].call(callSiteArray[82].call(specifiedDisks, (Object)new _validateInstanceTypeDisks_closure3(this, this))));
            if (!(persistentDiskCount != 0)) {
                callSiteArray[83].call((Object)this.errors, (Object)"disks", (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".disks.missingPersistentDisk"}), (Object)"A persistent boot disk is required.");
            }
        }
        public final class _validateInstanceTypeDisks_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateInstanceTypeDisks_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure4.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "persistent";
                return new CallSiteArray(_validateInstanceTypeDisks_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateInstanceTypeDisks_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _validateInstanceTypeDisks_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateInstanceTypeDisks_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object persistentDisk, Object index) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure5.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[0].callGetProperty(persistentDisk), (Object)10)) {
                    return callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)"disks", (Object)new GStringImpl(new Object[]{callSiteArray[3].callGroovyObjectGetProperty((Object)this), index}, new String[]{"", ".disk", ".sizeGb.invalidSize"}), (Object)"Persistent disks must be at least 10GB.");
                }
                return null;
            }

            @Generated
            public Object call(Object persistentDisk, Object index) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure5.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, persistentDisk, index);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "sizeGb";
                stringArray[1] = "rejectValue";
                stringArray[2] = "errors";
                stringArray[3] = "context";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _validateInstanceTypeDisks_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateInstanceTypeDisks_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateInstanceTypeDisks_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[84].call(callSiteArray[85].call(specifiedDisks, (Object)new _validateInstanceTypeDisks_closure4(this, this)), (Object)new _validateInstanceTypeDisks_closure5(this, this));
        public final class _validateInstanceTypeDisks_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateInstanceTypeDisks_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure6.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "persistent";
                return new CallSiteArray(_validateInstanceTypeDisks_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateInstanceTypeDisks_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference firstPersistentDisk = new Reference(callSiteArray[86].call(specifiedDisks, (Object)new _validateInstanceTypeDisks_closure6(this, this)));
        public final class _validateInstanceTypeDisks_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference firstPersistentDisk;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateInstanceTypeDisks_closure7(Object _outerInstance, Object _thisObject, Reference firstPersistentDisk) {
                Reference reference;
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.firstPersistentDisk = reference = firstPersistentDisk;
            }

            public Object doCall(Object disk, Object index) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure7.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(disk, this.firstPersistentDisk.get()))) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty(this.firstPersistentDisk.get()))) {
                        return callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)"disks", (Object)new GStringImpl(new Object[]{callSiteArray[4].callGroovyObjectGetProperty((Object)this), index}, new String[]{"", ".disk", ".sourceImage.unexpected"}), (Object)"The boot disk must not specify source image, it must be specified at the top-level on the request as `image`.");
                    }
                    return null;
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGetProperty(disk)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGetProperty(disk))) {
                    return callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), (Object)"disks", (Object)new GStringImpl(new Object[]{callSiteArray[9].callGroovyObjectGetProperty((Object)this), index}, new String[]{"", ".disk", ".sourceImage.required"}), (Object)"All non-boot persistent disks are required to specify source image.");
                }
                return null;
            }

            @Generated
            public Object call(Object disk, Object index) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure7.$getCallSiteArray();
                return callSiteArray[10].callCurrent((GroovyObject)this, disk, index);
            }

            @Generated
            public Object getFirstPersistentDisk() {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure7.$getCallSiteArray();
                return this.firstPersistentDisk.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "is";
                stringArray[1] = "sourceImage";
                stringArray[2] = "rejectValue";
                stringArray[3] = "errors";
                stringArray[4] = "context";
                stringArray[5] = "persistent";
                stringArray[6] = "sourceImage";
                stringArray[7] = "rejectValue";
                stringArray[8] = "errors";
                stringArray[9] = "context";
                stringArray[10] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[11];
                _validateInstanceTypeDisks_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateInstanceTypeDisks_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateInstanceTypeDisks_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[87].call(specifiedDisks, (Object)new _validateInstanceTypeDisks_closure7(this, this, firstPersistentDisk));
        public final class _validateInstanceTypeDisks_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateInstanceTypeDisks_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure8.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(GoogleDiskType.class));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "type";
                stringArray[1] = "LOCAL_SSD";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _validateInstanceTypeDisks_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateInstanceTypeDisks_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateInstanceTypeDisks_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _validateInstanceTypeDisks_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instanceTypeDisk;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateInstanceTypeDisks_closure9(Object _outerInstance, Object _thisObject, Reference instanceTypeDisk) {
                Reference reference;
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.instanceTypeDisk = reference = instanceTypeDisk;
            }

            public Object doCall(Object localSSDDisk, Object index) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure9.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGroovyObjectGetProperty(this.instanceTypeDisk.get()))) {
                    callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)"disks", (Object)new GStringImpl(new Object[]{callSiteArray[3].callGroovyObjectGetProperty((Object)this), index}, new String[]{"", ".disk", ".type.localSSDUnsupported"}), (Object)new GStringImpl(new Object[]{callSiteArray[4].callGroovyObjectGetProperty(this.instanceTypeDisk.get())}, new String[]{"Instance type ", " does not support Local SSD."}));
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[5].callGetProperty(localSSDDisk), (Object)375)) {
                    callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), (Object)"disks", (Object)new GStringImpl(new Object[]{callSiteArray[8].callGroovyObjectGetProperty((Object)this), index}, new String[]{"", ".disk", ".sizeGb.invalidSize"}), (Object)"Local SSD disks must be exactly 375GB.");
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGetProperty(localSSDDisk))) {
                    return callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty((Object)this), (Object)"disks", (Object)new GStringImpl(new Object[]{callSiteArray[12].callGroovyObjectGetProperty((Object)this), index}, new String[]{"", ".disk", ".autoDelete.required"}), (Object)"Local SSD disks must have auto-delete set.");
                }
                return null;
            }

            @Generated
            public Object call(Object localSSDDisk, Object index) {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure9.$getCallSiteArray();
                return callSiteArray[13].callCurrent((GroovyObject)this, localSSDDisk, index);
            }

            @Generated
            public GoogleInstanceTypeDisk getInstanceTypeDisk() {
                CallSite[] callSiteArray = _validateInstanceTypeDisks_closure9.$getCallSiteArray();
                return (GoogleInstanceTypeDisk)ScriptBytecodeAdapter.castToType((Object)this.instanceTypeDisk.get(), GoogleInstanceTypeDisk.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "supportsLocalSSD";
                stringArray[1] = "rejectValue";
                stringArray[2] = "errors";
                stringArray[3] = "context";
                stringArray[4] = "instanceType";
                stringArray[5] = "sizeGb";
                stringArray[6] = "rejectValue";
                stringArray[7] = "errors";
                stringArray[8] = "context";
                stringArray[9] = "autoDelete";
                stringArray[10] = "rejectValue";
                stringArray[11] = "errors";
                stringArray[12] = "context";
                stringArray[13] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[14];
                _validateInstanceTypeDisks_closure9.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateInstanceTypeDisks_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateInstanceTypeDisks_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[88].call(callSiteArray[89].call(specifiedDisks, (Object)new _validateInstanceTypeDisks_closure8(this, this)), (Object)new _validateInstanceTypeDisks_closure9(this, this, instanceTypeDisk2));
    }

    public Object validateAutoscalingPolicy(GoogleAutoscalingPolicy policy) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)policy)) {
            public final class _validateAutoscalingPolicy_closure10
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _validateAutoscalingPolicy_closure10(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _validateAutoscalingPolicy_closure10.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _validateAutoscalingPolicy_closure10.$getCallSiteArray();
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this), null)) {
                        callSiteArray[1].callCurrent((GroovyObject)this, callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)"autoscalingPolicy.minNumReplicas");
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), null)) {
                        callSiteArray[4].callCurrent((GroovyObject)this, callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"autoscalingPolicy.maxNumReplicas");
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[6].callGroovyObjectGetProperty((Object)this), null)) {
                        callSiteArray[7].callCurrent((GroovyObject)this, callSiteArray[8].callGroovyObjectGetProperty((Object)this), (Object)"autoscalingPolicy.coolDownPeriodSec");
                    }
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[9].callGroovyObjectGetProperty((Object)this), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[10].callGroovyObjectGetProperty((Object)this), null)) {
                            callSiteArray[11].callCurrent((GroovyObject)this, callSiteArray[12].callGroovyObjectGetProperty((Object)this), callSiteArray[13].callGroovyObjectGetProperty((Object)this), (Object)"autoscalingPolicy.minNumReplicas", (Object)"autoscalingPolicy.maxNumReplicas");
                        }
                    } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[14].callGroovyObjectGetProperty((Object)this), null) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[15].callGroovyObjectGetProperty((Object)this), null)) {
                        callSiteArray[16].callCurrent((GroovyObject)this, callSiteArray[17].callGroovyObjectGetProperty((Object)this), callSiteArray[18].callGroovyObjectGetProperty((Object)this), (Object)"autoscalingPolicy.minNumReplicas", (Object)"autoscalingPolicy.maxNumReplicas");
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[19].callGroovyObjectGetProperty((Object)this), null)) {
                        public final class _closure13
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure13(Object _outerInstance, Object _thisObject) {
                                CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this), null)) {
                                    callSiteArray[1].callCurrent((GroovyObject)this, callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)0, (Object)1, (Object)"autoscalingPolicy.cpuUtilization.utilizationTarget");
                                }
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), null)) {
                                    return callSiteArray[4].callCurrent((GroovyObject)this, callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"autoscalingPolicy.cpuUtilization.predictiveMethod");
                                }
                                return null;
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure13.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure13.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "utilizationTarget";
                                stringArray[1] = "validateInRangeExclusive";
                                stringArray[2] = "utilizationTarget";
                                stringArray[3] = "predictiveMethod";
                                stringArray[4] = "validateNotEmpty";
                                stringArray[5] = "predictiveMethod";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[6];
                                _closure13.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure13.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure13.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty((Object)this), (Object)new _closure13((Object)this, this.getThisObject()));
                    }
                    public final class _closure14
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure14(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object utilization, Object index) {
                            CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                            Reference path = new Reference((Object)new GStringImpl(new Object[]{index}, new String[]{"autoscalingPolicy.customMetricUtilizations[", "]"}));
                            public final class _closure16
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference path;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;

                                public _closure16(Object _outerInstance, Object _thisObject, Reference path) {
                                    Reference reference;
                                    CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                    super(_outerInstance, _thisObject);
                                    this.path = reference = path;
                                }

                                public Object doCall(Object it) {
                                    CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                    callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{this.path.get()}, new String[]{"", ".metric"}));
                                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[2].callGroovyObjectGetProperty((Object)this), null)) {
                                        callSiteArray[3].callCurrent((GroovyObject)this, callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{this.path.get()}, new String[]{"", ".utilizationTargetType"}));
                                        if (ScriptBytecodeAdapter.compareLessThanEqual((Object)callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)0)) {
                                            callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[8].callGroovyObjectGetProperty((Object)this), this.path.get()}, new String[]{"", ".", ".utilizationTarget"}), (Object)new GStringImpl(new Object[]{callSiteArray[9].callGroovyObjectGetProperty((Object)this), this.path.get()}, new String[]{"", ".", ".utilizationTarget must be greater than zero."}));
                                        }
                                    }
                                    if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[10].callGroovyObjectGetProperty((Object)this), null) && ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[11].callGroovyObjectGetProperty((Object)this), (Object)0)) {
                                            return callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[14].callGroovyObjectGetProperty((Object)this), this.path.get()}, new String[]{"", ".", ".singleInstanceAssignment"}), (Object)new GStringImpl(new Object[]{callSiteArray[15].callGroovyObjectGetProperty((Object)this), this.path.get()}, new String[]{"", ".", ".singleInstanceAssignment must be greater than zero."}));
                                        }
                                        return null;
                                    }
                                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[16].callGroovyObjectGetProperty((Object)this), null) && ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[17].callGroovyObjectGetProperty((Object)this), (Object)0)) {
                                        return callSiteArray[18].call(callSiteArray[19].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[20].callGroovyObjectGetProperty((Object)this), this.path.get()}, new String[]{"", ".", ".singleInstanceAssignment"}), (Object)new GStringImpl(new Object[]{callSiteArray[21].callGroovyObjectGetProperty((Object)this), this.path.get()}, new String[]{"", ".", ".singleInstanceAssignment must be greater than zero."}));
                                    }
                                    return null;
                                }

                                @Generated
                                public Object getPath() {
                                    CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                    return this.path.get();
                                }

                                @Generated
                                public Object doCall() {
                                    CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure16.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                    stringArray[0] = "validateNotEmpty";
                                    stringArray[1] = "metric";
                                    stringArray[2] = "utilizationTarget";
                                    stringArray[3] = "validateNotEmpty";
                                    stringArray[4] = "utilizationTargetType";
                                    stringArray[5] = "utilizationTarget";
                                    stringArray[6] = "rejectValue";
                                    stringArray[7] = "errors";
                                    stringArray[8] = "context";
                                    stringArray[9] = "context";
                                    stringArray[10] = "singleInstanceAssignment";
                                    stringArray[11] = "singleInstanceAssignment";
                                    stringArray[12] = "rejectValue";
                                    stringArray[13] = "errors";
                                    stringArray[14] = "context";
                                    stringArray[15] = "context";
                                    stringArray[16] = "singleInstanceAssignment";
                                    stringArray[17] = "singleInstanceAssignment";
                                    stringArray[18] = "rejectValue";
                                    stringArray[19] = "errors";
                                    stringArray[20] = "context";
                                    stringArray[21] = "context";
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[22];
                                    _closure16.$createCallSiteArray_1(stringArray);
                                    return new CallSiteArray(_closure16.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _closure16.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }
                            }
                            return callSiteArray[0].call(utilization, (Object)new _closure16((Object)this, this.getThisObject(), path));
                        }

                        @Generated
                        public Object call(Object utilization, Object index) {
                            CallSite[] callSiteArray = _closure14.$getCallSiteArray();
                            return callSiteArray[1].callCurrent((GroovyObject)this, utilization, index);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure14.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "with";
                            stringArray[1] = "doCall";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure14.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure14.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure14.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty((Object)this), (Object)new _closure14((Object)this, this.getThisObject()));
                    public final class _closure15
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure15(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object scalingSchedule) {
                            CallSite[] callSiteArray = _closure15.$getCallSiteArray();
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)scalingSchedule, null)) {
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].callGetProperty(scalingSchedule), null)) {
                                    callSiteArray[1].callCurrent((GroovyObject)this, callSiteArray[2].callGetProperty(scalingSchedule), (Object)300, callSiteArray[3].callGetProperty(Integer.class), (Object)"autoscalingPolicy.scalingSchedule.duration");
                                }
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[4].callGetProperty(scalingSchedule), null)) {
                                    callSiteArray[5].callCurrent((GroovyObject)this, callSiteArray[6].callGetProperty(scalingSchedule), (Object)"autoscalingPolicy.scalingSchedule.scheduleCron");
                                }
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[7].callGetProperty(scalingSchedule), null)) {
                                    return callSiteArray[8].callCurrent((GroovyObject)this, callSiteArray[9].callGetProperty(scalingSchedule), (Object)"autoscalingPolicy.scalingSchedule.timezone");
                                }
                                return null;
                            }
                            return null;
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure15.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "duration";
                            stringArray[1] = "validateInRangeExclusive";
                            stringArray[2] = "duration";
                            stringArray[3] = "MAX_VALUE";
                            stringArray[4] = "scheduleCron";
                            stringArray[5] = "validateCronExpression";
                            stringArray[6] = "scheduleCron";
                            stringArray[7] = "timezone";
                            stringArray[8] = "validateTimeZone";
                            stringArray[9] = "timezone";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[10];
                            _closure15.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure15.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure15.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    callSiteArray[24].call(callSiteArray[25].callGroovyObjectGetProperty((Object)this), (Object)new _closure15((Object)this, this.getThisObject()));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[26].callGroovyObjectGetProperty((Object)this), null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].callGetProperty(callSiteArray[28].callGroovyObjectGetProperty((Object)this)))) {
                        return callSiteArray[29].callCurrent((GroovyObject)this, callSiteArray[30].callGetProperty(callSiteArray[31].callGroovyObjectGetProperty((Object)this)), (Object)0, (Object)1, (Object)"autoscalingPolicy.loadBalancingUtilization.utilizationTarget");
                    }
                    return null;
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _validateAutoscalingPolicy_closure10.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _validateAutoscalingPolicy_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "minNumReplicas";
                    stringArray[1] = "validateNonNegativeLong";
                    stringArray[2] = "minNumReplicas";
                    stringArray[3] = "maxNumReplicas";
                    stringArray[4] = "validateNonNegativeLong";
                    stringArray[5] = "maxNumReplicas";
                    stringArray[6] = "coolDownPeriodSec";
                    stringArray[7] = "validateNonNegativeLong";
                    stringArray[8] = "coolDownPeriodSec";
                    stringArray[9] = "minNumReplicas";
                    stringArray[10] = "maxNumReplicas";
                    stringArray[11] = "validateMaxNotLessThanMin";
                    stringArray[12] = "minNumReplicas";
                    stringArray[13] = "maxNumReplicas";
                    stringArray[14] = "minNumReplicas";
                    stringArray[15] = "maxNumReplicas";
                    stringArray[16] = "validateMaxNotLessThanMin";
                    stringArray[17] = "minNumReplicas";
                    stringArray[18] = "maxNumReplicas";
                    stringArray[19] = "cpuUtilization";
                    stringArray[20] = "with";
                    stringArray[21] = "cpuUtilization";
                    stringArray[22] = "eachWithIndex";
                    stringArray[23] = "customMetricUtilizations";
                    stringArray[24] = "each";
                    stringArray[25] = "scalingSchedules";
                    stringArray[26] = "loadBalancingUtilization";
                    stringArray[27] = "utilizationTarget";
                    stringArray[28] = "loadBalancingUtilization";
                    stringArray[29] = "validateInRangeExclusive";
                    stringArray[30] = "utilizationTarget";
                    stringArray[31] = "loadBalancingUtilization";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[32];
                    _validateAutoscalingPolicy_closure10.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_validateAutoscalingPolicy_closure10.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _validateAutoscalingPolicy_closure10.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            return callSiteArray[90].call((Object)policy, (Object)new _validateAutoscalingPolicy_closure10(this, this));
        }
        return null;
    }

    public Object validateAutoHealingPolicy(GoogleAutoHealingPolicy policy, boolean rejectEmptyMaxUnavailable) {
        Reference rejectEmptyMaxUnavailable2 = new Reference((Object)rejectEmptyMaxUnavailable);
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        public final class _validateAutoHealingPolicy_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference rejectEmptyMaxUnavailable;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateAutoHealingPolicy_closure11(Object _outerInstance, Object _thisObject, Reference rejectEmptyMaxUnavailable) {
                Reference reference;
                CallSite[] callSiteArray = _validateAutoHealingPolicy_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.rejectEmptyMaxUnavailable = reference = rejectEmptyMaxUnavailable;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _validateAutoHealingPolicy_closure11.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this), null)) {
                    callSiteArray[1].callCurrent((GroovyObject)this, callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)"autoHealingPolicy.initialDelaySec");
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), null)) {
                    callSiteArray[4].callCurrent((GroovyObject)this, callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"autoHealingPolicy.healthCheck");
                    public final class _closure17
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference rejectEmptyMaxUnavailable;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure17(Object _outerInstance, Object _thisObject, Reference rejectEmptyMaxUnavailable) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.rejectEmptyMaxUnavailable = reference = rejectEmptyMaxUnavailable;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)this), null)) {
                                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[2].callGroovyObjectGetProperty((Object)this), Integer.TYPE)), Integer.TYPE), (Object)"autoHealingPolicy.maxUnavailable.fixed");
                            }
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[3].callGroovyObjectGetProperty((Object)this), null)) {
                                return callSiteArray[4].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[5].callGroovyObjectGetProperty((Object)this), Integer.TYPE)), Integer.TYPE), (Object)0, (Object)100, (Object)"autoHealingPolicy.maxUnavailable.percent");
                            }
                            if (DefaultTypeTransformation.booleanUnbox((Object)this.rejectEmptyMaxUnavailable.get())) {
                                return callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty(this.getThisObject()), (Object)"autoHealingPolicy.maxUnavailable", (Object)new GStringImpl(new Object[]{callSiteArray[8].callGroovyObjectGetProperty(this.getThisObject())}, new String[]{"", ".autoHealingPolicy.maxUnavailable.neitherFixedNorPercent"}));
                            }
                            return null;
                        }

                        @Generated
                        public boolean getRejectEmptyMaxUnavailable() {
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            return DefaultTypeTransformation.booleanUnbox((Object)this.rejectEmptyMaxUnavailable.get());
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure17.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure17.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "fixed";
                            stringArray[1] = "validateNonNegativeLong";
                            stringArray[2] = "fixed";
                            stringArray[3] = "percent";
                            stringArray[4] = "validateInRangeInclusive";
                            stringArray[5] = "percent";
                            stringArray[6] = "rejectValue";
                            stringArray[7] = "errors";
                            stringArray[8] = "context";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[9];
                            _closure17.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure17.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure17.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    return callSiteArray[6].callSafe(callSiteArray[7].callGroovyObjectGetProperty((Object)this), (Object)new _closure17((Object)this, this.getThisObject(), this.rejectEmptyMaxUnavailable));
                }
                return null;
            }

            @Generated
            public boolean getRejectEmptyMaxUnavailable() {
                CallSite[] callSiteArray = _validateAutoHealingPolicy_closure11.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.rejectEmptyMaxUnavailable.get());
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _validateAutoHealingPolicy_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateAutoHealingPolicy_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "initialDelaySec";
                stringArray[1] = "validateNonNegativeLong";
                stringArray[2] = "initialDelaySec";
                stringArray[3] = "healthCheck";
                stringArray[4] = "validateName";
                stringArray[5] = "healthCheck";
                stringArray[6] = "with";
                stringArray[7] = "maxUnavailable";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _validateAutoHealingPolicy_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateAutoHealingPolicy_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateAutoHealingPolicy_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return callSiteArray[91].callSafe((Object)policy, (Object)new _validateAutoHealingPolicy_closure11(this, this, rejectEmptyMaxUnavailable2));
    }

    public Object validateTags(List<String> tags) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        return callSiteArray[92].callCurrent((GroovyObject)this, tags, (Object)"tag");
    }

    public Object validateMap(Map<String, String> mappings, String componentDescription) {
        Reference componentDescription2 = new Reference((Object)componentDescription);
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual(mappings, null)) {
            callSiteArray[93].call((Object)this.errors, (Object)new GStringImpl(new Object[]{(String)componentDescription2.get()}, new String[]{"", "s"}), (Object)new GStringImpl(new Object[]{this.context, (String)componentDescription2.get()}, new String[]{"", ".", "s.empty"}));
            return false;
        }
        Reference result = new Reference((Object)true);
        public final class _validateMap_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private /* synthetic */ Reference componentDescription;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateMap_closure12(Object _outerInstance, Object _thisObject, Reference result, Reference componentDescription) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _validateMap_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.result = reference2 = result;
                this.componentDescription = reference = componentDescription;
            }

            public Object doCall(Object key, Object value) {
                CallSite[] callSiteArray = _validateMap_closure12.$getCallSiteArray();
                this.result.set(callSiteArray[0].call(this.result.get(), callSiteArray[1].callCurrent((GroovyObject)this, key, (Object)new GStringImpl(new Object[]{this.componentDescription.get()}, new String[]{"", "s"}), (Object)new GStringImpl(new Object[]{this.componentDescription.get()}, new String[]{"", "s.key"}))));
                if (DefaultTypeTransformation.booleanUnbox((Object)value)) {
                    Object object = callSiteArray[2].call(this.result.get(), callSiteArray[3].callCurrent((GroovyObject)this, value, (Object)new GStringImpl(new Object[]{this.componentDescription.get()}, new String[]{"", "s"}), (Object)new GStringImpl(new Object[]{this.componentDescription.get(), key}, new String[]{"", ".", ".value"})));
                    this.result.set(object);
                    return object;
                }
                return null;
            }

            @Generated
            public Object call(Object key, Object value) {
                CallSite[] callSiteArray = _validateMap_closure12.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, key, value);
            }

            @Generated
            public Object getResult() {
                CallSite[] callSiteArray = _validateMap_closure12.$getCallSiteArray();
                return this.result.get();
            }

            @Generated
            public String getComponentDescription() {
                CallSite[] callSiteArray = _validateMap_closure12.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.componentDescription.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateMap_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "and";
                stringArray[1] = "validateNameAsPart";
                stringArray[2] = "and";
                stringArray[3] = "validateNameAsPart";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _validateMap_closure12.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateMap_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateMap_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[94].call(mappings, (Object)new _validateMap_closure12(this, this, result, componentDescription2));
        return result.get();
    }

    public Object validateAuthScopes(List<String> authScopes) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        return callSiteArray[95].callCurrent((GroovyObject)this, authScopes, (Object)"authScope");
    }

    public Object validateCronExpression(String expression, String attribute) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        Object result = callSiteArray[96].call(CronSequenceGenerator.class, callSiteArray[97].call((Object)"* ", (Object)expression));
        if (!DefaultTypeTransformation.booleanUnbox((Object)result)) {
            callSiteArray[98].call((Object)this.errors, (Object)attribute, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", " must be a valid CRON expression."}));
        }
        return result;
    }

    public Object validateTimeZone(String timeZone, String attribute) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        Object result = true;
        try {
            result = callSiteArray[99].call(callSiteArray[100].call(Set.class, callSiteArray[101].call(TimeZone.class)), (Object)timeZone);
        }
        catch (Exception e) {
            callSiteArray[102].call((Object)this.errors, (Object)attribute, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", " must be a time zone name from the tz database."}));
            result = false;
        }
        return result;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StandardGceAttributeValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public Object validateAutoHealingPolicy(GoogleAutoHealingPolicy policy) {
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        return this.validateAutoHealingPolicy(policy, true);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        CallSite[] callSiteArray = StandardGceAttributeValidator.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal = new BigDecimal("0.5");
    }

    static {
        StandardGceAttributeValidator.__$swapInit();
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public void setContext(String string) {
        this.context = string;
    }

    @Generated
    public ValidationErrors getErrors() {
        return this.errors;
    }

    @Generated
    public void setErrors(ValidationErrors validationErrors) {
        this.errors = validationErrors;
    }

    @Generated
    public Object getCustomInstanceRegExp() {
        return this.customInstanceRegExp;
    }

    @Generated
    public void setCustomInstanceRegExp(Object object) {
        this.customInstanceRegExp = object;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "validateNotEmptyAsPart";
        stringArray[1] = "rejectValue";
        stringArray[2] = "validateNameAsPart";
        stringArray[3] = "validateNotEmptyAsPart";
        stringArray[4] = "validateNotEmpty";
        stringArray[5] = "getOne";
        stringArray[6] = "credentials";
        stringArray[7] = "rejectValue";
        stringArray[8] = "validateNotEmpty";
        stringArray[9] = "regionToZonesMap";
        stringArray[10] = "rejectValue";
        stringArray[11] = "regions";
        stringArray[12] = "rejectValue";
        stringArray[13] = "validateNotEmpty";
        stringArray[14] = "regionFromZone";
        stringArray[15] = "rejectValue";
        stringArray[16] = "regionFromZone";
        stringArray[17] = "regions";
        stringArray[18] = "rejectValue";
        stringArray[19] = "validateNotEmpty";
        stringArray[20] = "rejectValue";
        stringArray[21] = "rejectValue";
        stringArray[22] = "rejectValue";
        stringArray[23] = "rejectValue";
        stringArray[24] = "rejectValue";
        stringArray[25] = "rejectValue";
        stringArray[26] = "rejectValue";
        stringArray[27] = "rejectValue";
        stringArray[28] = "validateName";
        stringArray[29] = "ARTIFACT";
        stringArray[30] = "validateImageArtifact";
        stringArray[31] = "validateNotEmpty";
        stringArray[32] = "ARTIFACT";
        stringArray[33] = "validateNotEmpty";
        stringArray[34] = "validateNotEmpty";
        stringArray[35] = "getType";
        stringArray[36] = "GCE_IMAGE_TYPE";
        stringArray[37] = "rejectValue";
        stringArray[38] = "validateNotEmpty";
        stringArray[39] = "validateNameListHelper";
        stringArray[40] = "validateNameListHelper";
        stringArray[41] = "validateNotEmpty";
        stringArray[42] = "eachWithIndex";
        stringArray[43] = "validateNameList";
        stringArray[44] = "validateName";
        stringArray[45] = "validateNotEmpty";
        stringArray[46] = "contains";
        stringArray[47] = "contains";
        stringArray[48] = "validateCustomInstanceType";
        stringArray[49] = "matches";
        stringArray[50] = "rejectValue";
        stringArray[51] = "toDouble";
        stringArray[52] = "group";
        stringArray[53] = "toDouble";
        stringArray[54] = "group";
        stringArray[55] = "div";
        stringArray[56] = "multiply";
        stringArray[57] = "div";
        stringArray[58] = "ceil";
        stringArray[59] = "multiply";
        stringArray[60] = "multiply";
        stringArray[61] = "rejectValue";
        stringArray[62] = "mod";
        stringArray[63] = "rejectValue";
        stringArray[64] = "mod";
        stringArray[65] = "rejectValue";
        stringArray[66] = "rejectValue";
        stringArray[67] = "rejectValue";
        stringArray[68] = "mod";
        stringArray[69] = "rejectValue";
        stringArray[70] = "locationToInstanceTypesMap";
        stringArray[71] = "vCpuMax";
        stringArray[72] = "getAt";
        stringArray[73] = "locationToInstanceTypesMap";
        stringArray[74] = "rejectValue";
        stringArray[75] = "rejectValue";
        stringArray[76] = "contains";
        stringArray[77] = "getAt";
        stringArray[78] = "locationToCpuPlatformsMap";
        stringArray[79] = "rejectValue";
        stringArray[80] = "eachWithIndex";
        stringArray[81] = "size";
        stringArray[82] = "findAll";
        stringArray[83] = "rejectValue";
        stringArray[84] = "eachWithIndex";
        stringArray[85] = "findAll";
        stringArray[86] = "find";
        stringArray[87] = "eachWithIndex";
        stringArray[88] = "eachWithIndex";
        stringArray[89] = "findAll";
        stringArray[90] = "with";
        stringArray[91] = "with";
        stringArray[92] = "validateOptionalNameList";
        stringArray[93] = "rejectValue";
        stringArray[94] = "each";
        stringArray[95] = "validateOptionalNameList";
        stringArray[96] = "isValidExpression";
        stringArray[97] = "plus";
        stringArray[98] = "rejectValue";
        stringArray[99] = "contains";
        stringArray[100] = "of";
        stringArray[101] = "getAvailableIDs";
        stringArray[102] = "rejectValue";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[103];
        StandardGceAttributeValidator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(StandardGceAttributeValidator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = StandardGceAttributeValidator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

