/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.iam.v1.model.ServiceAccount;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSecurityGroup;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.model.AddressableRange;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupProvider;
import com.netflix.spinnaker.clouddriver.model.securitygroups.IpRangeRule;
import com.netflix.spinnaker.clouddriver.model.securitygroups.Rule;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoogleSecurityGroupProvider
implements SecurityGroupProvider<GoogleSecurityGroup>,
GroovyObject {
    private final CredentialsRepository<GoogleNamedAccountCredentials> credentialsRepository;
    private final Cache cacheView;
    private final ObjectMapper objectMapper;
    private final String cloudProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Autowired
    public GoogleSecurityGroupProvider(CredentialsRepository<GoogleNamedAccountCredentials> credentialsRepository, Cache cacheView, ObjectMapper objectMapper) {
        ObjectMapper objectMapper2;
        Cache cache;
        MetaClass metaClass;
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        Object object = callSiteArray[0].callGetProperty(GoogleCloudProvider.class);
        this.cloudProvider = ShortTypeHandling.castToString((Object)object);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        CredentialsRepository<GoogleNamedAccountCredentials> credentialsRepository2 = credentialsRepository;
        this.credentialsRepository = credentialsRepository2;
        this.cacheView = cache = cacheView;
        this.objectMapper = objectMapper2 = objectMapper;
    }

    public Set<GoogleSecurityGroup> getAll(boolean includeRules) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callCurrent((GroovyObject)this, callSiteArray[2].call(Keys.class, (Object)"*", (Object)"*", (Object)"*", (Object)"*"), (Object)includeRules), Set.class);
    }

    public Set<GoogleSecurityGroup> getAllByRegion(boolean includeRules, String region) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callCurrent((GroovyObject)this, callSiteArray[4].call(Keys.class, (Object)"*", (Object)"*", (Object)region, (Object)"*"), (Object)includeRules), Set.class);
    }

    public Set<GoogleSecurityGroup> getAllByAccount(boolean includeRules, String account) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].callCurrent((GroovyObject)this, callSiteArray[6].call(Keys.class, (Object)"*", (Object)"*", (Object)"*", (Object)account), (Object)includeRules), Set.class);
    }

    public Set<GoogleSecurityGroup> getAllByAccountAndName(boolean includeRules, String account, String name) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callCurrent((GroovyObject)this, callSiteArray[8].call(Keys.class, (Object)name, (Object)"*", (Object)"*", (Object)account), (Object)includeRules), Set.class);
    }

    public Set<GoogleSecurityGroup> getAllByAccountAndRegion(boolean includeRules, String account, String region) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callCurrent((GroovyObject)this, callSiteArray[10].call(Keys.class, (Object)"*", (Object)"*", (Object)region, (Object)account), (Object)includeRules), Set.class);
    }

    public GoogleSecurityGroup get(String account, String region, String name, String vpcId) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        return (GoogleSecurityGroup)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(callSiteArray[12].callCurrent((GroovyObject)this, callSiteArray[13].call(Keys.class, (Object)name, (Object)"*", (Object)region, (Object)account), (Object)true), (Object)0), GoogleSecurityGroup.class);
    }

    public GoogleSecurityGroup getById(String account, String region, String id, String vpcId) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        return (GoogleSecurityGroup)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].call(callSiteArray[15].callCurrent((GroovyObject)this, callSiteArray[16].call(Keys.class, (Object)"*", (Object)id, (Object)region, (Object)account), (Object)true), (Object)0), GoogleSecurityGroup.class);
    }

    public Set<GoogleSecurityGroup> getAllMatchingKeyPattern(String pattern, boolean includeRules) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callCurrent((GroovyObject)this, (Object)includeRules, callSiteArray[18].call((Object)this.cacheView, callSiteArray[19].callGetProperty(callSiteArray[20].callGetProperty(Keys.Namespace.class)), (Object)pattern)), Set.class);
    }

    public Set<GoogleSecurityGroup> loadResults(boolean includeRules, Collection<String> identifiers) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        Object transform = callSiteArray[21].call((Object)ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"fromCacheData"), (Object)includeRules);
        Object data = callSiteArray[22].call((Object)this.cacheView, callSiteArray[23].callGetProperty(callSiteArray[24].callGetProperty(Keys.Namespace.class)), identifiers, callSiteArray[25].call(RelationshipCacheFilter.class));
        Object transformed = callSiteArray[26].call(data, transform);
        return (Set)ScriptBytecodeAdapter.castToType((Object)transformed, Set.class);
    }

    public GoogleSecurityGroup fromCacheData(boolean includeRules, CacheData cacheData) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        Map firewall = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callGetProperty(callSiteArray[28].callGetProperty((Object)cacheData)), Map.class);
        Map parts = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].call(Keys.class, callSiteArray[30].callGetProperty((Object)cacheData)), Map.class);
        Object project = callSiteArray[31].callGetProperty(callSiteArray[32].callGetProperty((Object)cacheData));
        return (GoogleSecurityGroup)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)includeRules, (Object)firewall, (Object)callSiteArray[34].callGetProperty((Object)parts), (Object)callSiteArray[35].callGetProperty((Object)parts), (Object)project)), GoogleSecurityGroup.class);
    }

    private GoogleSecurityGroup convertToGoogleSecurityGroup(boolean includeRules, Map firewall, String account, String region, String project) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        List inboundRules = (List)ScriptBytecodeAdapter.castToType((Object)(includeRules ? callSiteArray[36].callCurrent((GroovyObject)this, (Object)firewall) : ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class);
        return (GoogleSecurityGroup)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].callConstructor(GoogleSecurityGroup.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[38].callCurrent((GroovyObject)this, (Object)project, callSiteArray[39].callGetProperty((Object)firewall)), "name", callSiteArray[40].callGetProperty((Object)firewall), "description", callSiteArray[41].callGetProperty((Object)firewall), "accountName", account, "region", region, "network", callSiteArray[42].callCurrent((GroovyObject)this, (Object)project, callSiteArray[43].callGetProperty((Object)firewall)), "selfLink", callSiteArray[44].callGetProperty((Object)firewall), "sourceTags", callSiteArray[45].callGetProperty((Object)firewall), "targetTags", callSiteArray[46].callGetProperty((Object)firewall), "sourceServiceAccounts", callSiteArray[47].callGetProperty((Object)firewall), "targetServiceAccounts", callSiteArray[48].callGetProperty((Object)firewall), "inboundRules", inboundRules})), GoogleSecurityGroup.class);
    }

    private List<Rule> buildInboundIpRangeRules(Map firewall) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        Reference rangeRules = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _buildInboundIpRangeRules_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildInboundIpRangeRules_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object sourceRange) {
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure1.$getCallSiteArray();
                List rangeParts = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].call(sourceRange, (Object)"/"), List.class);
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].call((Object)rangeParts), (Object)1)) {
                    callSiteArray[2].call((Object)rangeParts, (Object)"32");
                }
                return callSiteArray[3].callConstructor(AddressableRange.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ip", callSiteArray[4].call((Object)rangeParts, (Object)0), "cidr", new GStringImpl(new Object[]{callSiteArray[5].call((Object)rangeParts, (Object)1)}, new String[]{"/", ""})}));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInboundIpRangeRules_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "split";
                stringArray[1] = "size";
                stringArray[2] = "leftShift";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "getAt";
                stringArray[5] = "getAt";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _buildInboundIpRangeRules_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildInboundIpRangeRules_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildInboundIpRangeRules_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference sourceRanges = new Reference((Object)((List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].callSafe(callSiteArray[50].callGetProperty((Object)firewall), (Object)new _buildInboundIpRangeRules_closure1(this, this)), List.class)));
        public final class _buildInboundIpRangeRules_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildInboundIpRangeRules_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure2.$getCallSiteArray();
                return callSiteArray[0].callConstructor(HashSet.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInboundIpRangeRules_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "<$constructor$>";
                return new CallSiteArray(_buildInboundIpRangeRules_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildInboundIpRangeRules_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference protocolToAllowedsMap = new Reference(callSiteArray[51].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Object)new _buildInboundIpRangeRules_closure2(this, this)));
        public final class _buildInboundIpRangeRules_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference protocolToAllowedsMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildInboundIpRangeRules_closure3(Object _outerInstance, Object _thisObject, Reference protocolToAllowedsMap) {
                Reference reference;
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.protocolToAllowedsMap = reference = protocolToAllowedsMap;
            }

            public Object doCall(Object allowed) {
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure3.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(this.protocolToAllowedsMap.get(), callSiteArray[2].callGetProperty(allowed)), allowed);
            }

            @Generated
            public Object getProtocolToAllowedsMap() {
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure3.$getCallSiteArray();
                return this.protocolToAllowedsMap.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInboundIpRangeRules_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "getAt";
                stringArray[2] = "IPProtocol";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _buildInboundIpRangeRules_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildInboundIpRangeRules_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildInboundIpRangeRules_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[52].callSafe(callSiteArray[53].callGetProperty((Object)firewall), (Object)new _buildInboundIpRangeRules_closure3(this, this, protocolToAllowedsMap));
        public final class _buildInboundIpRangeRules_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sourceRanges;
            private /* synthetic */ Reference rangeRules;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _buildInboundIpRangeRules_closure4(Object _outerInstance, Object _thisObject, Reference sourceRanges, Reference rangeRules) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.sourceRanges = reference2 = sourceRanges;
                this.rangeRules = reference = rangeRules;
            }

            public Object doCall(String ipProtocol, Set<Map> allowedSet) {
                Reference ipProtocol2 = new Reference((Object)ipProtocol);
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure4.$getCallSiteArray();
                Reference portRanges = new Reference((Object)((SortedSet)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), SortedSet.class)));
                public final class _closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference portRanges;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure6(Object _outerInstance, Object _thisObject, Reference portRanges) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.portRanges = reference = portRanges;
                    }

                    public Object doCall(Object allowed) {
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        public final class _closure8
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference portRanges;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure8(Object _outerInstance, Object _thisObject, Reference portRanges) {
                                Reference reference;
                                CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.portRanges = reference = portRanges;
                            }

                            public Object doCall(Object port) {
                                CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                                Object portRangeParts = callSiteArray[0].call(port, (Object)"-");
                                if (DefaultTypeTransformation.booleanUnbox((Object)portRangeParts)) {
                                    Rule.PortRange portRange = (Rule.PortRange)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callConstructor(Rule.PortRange.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"startPort", callSiteArray[2].callConstructor(Integer.class, callSiteArray[3].call(portRangeParts, (Object)0))})), Rule.PortRange.class);
                                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callGetProperty(portRangeParts), (Object)2)) {
                                        Object object = callSiteArray[5].callConstructor(Integer.class, callSiteArray[6].call(portRangeParts, (Object)1));
                                        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)portRange, (String)"endPort");
                                    } else {
                                        Object object = callSiteArray[7].callGetProperty((Object)portRange);
                                        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)portRange, (String)"endPort");
                                    }
                                    return callSiteArray[8].call(this.portRanges.get(), (Object)portRange);
                                }
                                return null;
                            }

                            @Generated
                            public SortedSet getPortRanges() {
                                CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                                return (SortedSet)ScriptBytecodeAdapter.castToType((Object)this.portRanges.get(), SortedSet.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure8.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "split";
                                stringArray[1] = "<$constructor$>";
                                stringArray[2] = "<$constructor$>";
                                stringArray[3] = "getAt";
                                stringArray[4] = "length";
                                stringArray[5] = "<$constructor$>";
                                stringArray[6] = "getAt";
                                stringArray[7] = "startPort";
                                stringArray[8] = "leftShift";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[9];
                                _closure8.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure8.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure8.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[0].callSafe(callSiteArray[1].callGetProperty(allowed), (Object)new _closure8((Object)this, this.getThisObject(), this.portRanges));
                    }

                    @Generated
                    public SortedSet getPortRanges() {
                        CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                        return (SortedSet)ScriptBytecodeAdapter.castToType((Object)this.portRanges.get(), SortedSet.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "each";
                        stringArray[1] = "ports";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _closure6.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure6.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure6.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[0].call(allowedSet, (Object)new _closure6((Object)this, this.getThisObject(), portRanges));
                if (!DefaultTypeTransformation.booleanUnbox((Object)((SortedSet)portRanges.get())) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"tcp", "udp", "sctp"}), (Object)((String)ipProtocol2.get())))) {
                    callSiteArray[2].call((Object)((SortedSet)portRanges.get()), callSiteArray[3].callConstructor(Rule.PortRange.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"startPort", 1, "endPort", 65535})));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)this.sourceRanges.get())) {
                    public final class _closure7
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference rangeRules;
                        private /* synthetic */ Reference portRanges;
                        private /* synthetic */ Reference ipProtocol;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure7(Object _outerInstance, Object _thisObject, Reference rangeRules, Reference portRanges, Reference ipProtocol) {
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.rangeRules = reference3 = rangeRules;
                            this.portRanges = reference2 = portRanges;
                            this.ipProtocol = reference = ipProtocol;
                        }

                        public Object doCall(Object sourceRange) {
                            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                            return callSiteArray[0].call(this.rangeRules.get(), callSiteArray[1].callConstructor(IpRangeRule.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"range", sourceRange, "portRanges", this.portRanges.get(), "protocol", this.ipProtocol.get()})));
                        }

                        @Generated
                        public List getRangeRules() {
                            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                            return (List)ScriptBytecodeAdapter.castToType((Object)this.rangeRules.get(), List.class);
                        }

                        @Generated
                        public SortedSet getPortRanges() {
                            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                            return (SortedSet)ScriptBytecodeAdapter.castToType((Object)this.portRanges.get(), SortedSet.class);
                        }

                        @Generated
                        public String getIpProtocol() {
                            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                            return ShortTypeHandling.castToString((Object)this.ipProtocol.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure7.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "add";
                            stringArray[1] = "<$constructor$>";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure7.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure7.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure7.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    return callSiteArray[4].call(this.sourceRanges.get(), (Object)new _closure7((Object)this, this.getThisObject(), this.rangeRules, portRanges, ipProtocol2));
                }
                return callSiteArray[5].call(this.rangeRules.get(), callSiteArray[6].callConstructor(IpRangeRule.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"range", callSiteArray[7].callConstructor(AddressableRange.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ip", "", "cidr", ""})), "portRanges", (SortedSet)portRanges.get(), "protocol", (String)ipProtocol2.get()})));
            }

            @Generated
            public Object call(String ipProtocol, Set<Map> allowedSet) {
                Reference ipProtocol2 = new Reference((Object)ipProtocol);
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure4.$getCallSiteArray();
                return callSiteArray[8].callCurrent((GroovyObject)this, (Object)((String)ipProtocol2.get()), allowedSet);
            }

            @Generated
            public List getSourceRanges() {
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure4.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.sourceRanges.get(), List.class);
            }

            @Generated
            public List getRangeRules() {
                CallSite[] callSiteArray = _buildInboundIpRangeRules_closure4.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.rangeRules.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInboundIpRangeRules_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "each";
                stringArray[1] = "contains";
                stringArray[2] = "leftShift";
                stringArray[3] = "<$constructor$>";
                stringArray[4] = "each";
                stringArray[5] = "add";
                stringArray[6] = "<$constructor$>";
                stringArray[7] = "<$constructor$>";
                stringArray[8] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[9];
                _buildInboundIpRangeRules_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_buildInboundIpRangeRules_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _buildInboundIpRangeRules_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[54].call(protocolToAllowedsMap.get(), (Object)new _buildInboundIpRangeRules_closure4(this, this, sourceRanges, rangeRules));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call((Object)((List)rangeRules.get())), List.class);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getMatchingSecurityGroupNames(String account, Set<GoogleSecurityGroup> securityGroups, Set<String> tags, Set<ServiceAccount> serviceAccounts, String networkName) {
        void var3_3;
        void var2_2;
        Reference account2 = new Reference((Object)account);
        Reference tags2 = new Reference((Object)var2_2);
        Reference serviceAccounts2 = new Reference((Object)var3_3);
        Reference networkName2 = new Reference((Object)networkName);
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        Set set = (Set)tags2.get();
        tags2.set((Object)(DefaultTypeTransformation.booleanUnbox((Object)set) ? set : (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
        Set set2 = (Set)serviceAccounts2.get();
        serviceAccounts2.set((Object)(DefaultTypeTransformation.booleanUnbox((Object)set2) ? set2 : (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
        public final class _getMatchingSecurityGroupNames_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference networkName;
            private /* synthetic */ Reference tags;
            private /* synthetic */ Reference serviceAccounts;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getMatchingSecurityGroupNames_closure5(Object _outerInstance, Object _thisObject, Reference account, Reference networkName, Reference tags, Reference serviceAccounts) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _getMatchingSecurityGroupNames_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.account = reference4 = account;
                this.networkName = reference3 = networkName;
                this.tags = reference2 = tags;
                this.serviceAccounts = reference = serviceAccounts;
            }

            public Object doCall(GoogleSecurityGroup securityGroup) {
                Reference securityGroup2 = new Reference((Object)securityGroup);
                CallSite[] callSiteArray = _getMatchingSecurityGroupNames_closure5.$getCallSiteArray();
                Boolean accountAndNetworkMatch = null;
                accountAndNetworkMatch = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? Boolean.valueOf(ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGroovyObjectGetProperty((Object)((GoogleSecurityGroup)securityGroup2.get())), (Object)this.account.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGroovyObjectGetProperty((Object)((GoogleSecurityGroup)securityGroup2.get())), (Object)this.networkName.get())) : Boolean.valueOf(ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGroovyObjectGetProperty((Object)((GoogleSecurityGroup)securityGroup2.get())), (Object)this.account.get()) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGroovyObjectGetProperty((Object)((GoogleSecurityGroup)securityGroup2.get())), (Object)this.networkName.get()));
                if (!DefaultTypeTransformation.booleanUnbox((Object)accountAndNetworkMatch)) {
                    return null;
                }
                boolean hasTargetTags = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callGroovyObjectGetProperty((Object)((GoogleSecurityGroup)securityGroup2.get())));
                Object targetTagsInCommon = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                if (hasTargetTags) {
                    targetTagsInCommon = callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)((GoogleSecurityGroup)securityGroup2.get())), this.tags.get());
                }
                boolean hasTargetServiceAccounts = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callGroovyObjectGetProperty((Object)((GoogleSecurityGroup)securityGroup2.get())));
                Reference targetServiceAccountsInCommon = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                public final class _closure9
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference securityGroup;
                    private /* synthetic */ Reference targetServiceAccountsInCommon;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure9(Object _outerInstance, Object _thisObject, Reference securityGroup, Reference targetServiceAccountsInCommon) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.securityGroup = reference2 = securityGroup;
                        this.targetServiceAccountsInCommon = reference = targetServiceAccountsInCommon;
                    }

                    public Object doCall(Object serviceAccount) {
                        CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                        if (ScriptBytecodeAdapter.isCase((Object)callSiteArray[0].callGetProperty(serviceAccount), (Object)callSiteArray[1].callGroovyObjectGetProperty(this.securityGroup.get()))) {
                            return callSiteArray[2].call(this.targetServiceAccountsInCommon.get(), callSiteArray[3].callGetProperty(serviceAccount));
                        }
                        return null;
                    }

                    @Generated
                    public GoogleSecurityGroup getSecurityGroup() {
                        CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                        return (GoogleSecurityGroup)ScriptBytecodeAdapter.castToType((Object)this.securityGroup.get(), GoogleSecurityGroup.class);
                    }

                    @Generated
                    public Object getTargetServiceAccountsInCommon() {
                        CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                        return this.targetServiceAccountsInCommon.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "email";
                        stringArray[1] = "targetServiceAccounts";
                        stringArray[2] = "add";
                        stringArray[3] = "email";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure9.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure9.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure9.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[8].call(this.serviceAccounts.get(), (Object)new _closure9((Object)this, this.getThisObject(), securityGroup2, targetServiceAccountsInCommon));
                int isDefaultFirewallRule = 0;
                isDefaultFirewallRule = !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (!hasTargetTags && !hasTargetServiceAccounts ? 1 : 0) : (!hasTargetTags && !hasTargetServiceAccounts ? 1 : 0);
                return isDefaultFirewallRule != 0 || DefaultTypeTransformation.booleanUnbox((Object)targetTagsInCommon) || DefaultTypeTransformation.booleanUnbox((Object)targetServiceAccountsInCommon.get()) ? callSiteArray[9].callGroovyObjectGetProperty((Object)((GoogleSecurityGroup)securityGroup2.get())) : null;
            }

            @Generated
            public Object call(GoogleSecurityGroup securityGroup) {
                Reference securityGroup2 = new Reference((Object)securityGroup);
                CallSite[] callSiteArray = _getMatchingSecurityGroupNames_closure5.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[10].callCurrent((GroovyObject)this, (Object)((GoogleSecurityGroup)securityGroup2.get()));
                }
                return this.doCall((GoogleSecurityGroup)securityGroup2.get());
            }

            @Generated
            public String getAccount() {
                CallSite[] callSiteArray = _getMatchingSecurityGroupNames_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.account.get());
            }

            @Generated
            public String getNetworkName() {
                CallSite[] callSiteArray = _getMatchingSecurityGroupNames_closure5.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.networkName.get());
            }

            @Generated
            public Set getTags() {
                CallSite[] callSiteArray = _getMatchingSecurityGroupNames_closure5.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType((Object)this.tags.get(), Set.class);
            }

            @Generated
            public Set getServiceAccounts() {
                CallSite[] callSiteArray = _getMatchingSecurityGroupNames_closure5.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.castToType((Object)this.serviceAccounts.get(), Set.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMatchingSecurityGroupNames_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "accountName";
                stringArray[1] = "network";
                stringArray[2] = "accountName";
                stringArray[3] = "network";
                stringArray[4] = "targetTags";
                stringArray[5] = "intersect";
                stringArray[6] = "targetTags";
                stringArray[7] = "targetServiceAccounts";
                stringArray[8] = "each";
                stringArray[9] = "name";
                stringArray[10] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[11];
                _getMatchingSecurityGroupNames_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getMatchingSecurityGroupNames_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getMatchingSecurityGroupNames_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object = callSiteArray[56].callSafe(securityGroups, (Object)new _getMatchingSecurityGroupNames_closure5(GoogleSecurityGroupProvider.class, GoogleSecurityGroupProvider.class, account2, networkName2, tags2, serviceAccounts2));
        return (List)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0])), List.class);
    }

    private String deriveResourceId(String project, String resourceLink) {
        CallSite[] callSiteArray = GoogleSecurityGroupProvider.$getCallSiteArray();
        Object firewallProject = callSiteArray[57].call(GCEUtil.class, (Object)resourceLink);
        Object firewallId = callSiteArray[58].call(GCEUtil.class, (Object)resourceLink);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)firewallProject, (Object)project)) {
            firewallId = new GStringImpl(new Object[]{firewallProject, firewallId}, new String[]{"", "/", ""});
        }
        return ShortTypeHandling.castToString((Object)firewallId);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleSecurityGroupProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = GoogleSecurityGroupProvider.$getCallSiteArray()[59].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSecurityGroupProvider");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "ID";
        stringArray[1] = "getAllMatchingKeyPattern";
        stringArray[2] = "getSecurityGroupKey";
        stringArray[3] = "getAllMatchingKeyPattern";
        stringArray[4] = "getSecurityGroupKey";
        stringArray[5] = "getAllMatchingKeyPattern";
        stringArray[6] = "getSecurityGroupKey";
        stringArray[7] = "getAllMatchingKeyPattern";
        stringArray[8] = "getSecurityGroupKey";
        stringArray[9] = "getAllMatchingKeyPattern";
        stringArray[10] = "getSecurityGroupKey";
        stringArray[11] = "getAt";
        stringArray[12] = "getAllMatchingKeyPattern";
        stringArray[13] = "getSecurityGroupKey";
        stringArray[14] = "getAt";
        stringArray[15] = "getAllMatchingKeyPattern";
        stringArray[16] = "getSecurityGroupKey";
        stringArray[17] = "loadResults";
        stringArray[18] = "filterIdentifiers";
        stringArray[19] = "ns";
        stringArray[20] = "SECURITY_GROUPS";
        stringArray[21] = "curry";
        stringArray[22] = "getAll";
        stringArray[23] = "ns";
        stringArray[24] = "SECURITY_GROUPS";
        stringArray[25] = "none";
        stringArray[26] = "collect";
        stringArray[27] = "firewall";
        stringArray[28] = "attributes";
        stringArray[29] = "parse";
        stringArray[30] = "id";
        stringArray[31] = "project";
        stringArray[32] = "attributes";
        stringArray[33] = "convertToGoogleSecurityGroup";
        stringArray[34] = "account";
        stringArray[35] = "region";
        stringArray[36] = "buildInboundIpRangeRules";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "deriveResourceId";
        stringArray[39] = "selfLink";
        stringArray[40] = "name";
        stringArray[41] = "description";
        stringArray[42] = "deriveResourceId";
        stringArray[43] = "network";
        stringArray[44] = "selfLink";
        stringArray[45] = "sourceTags";
        stringArray[46] = "targetTags";
        stringArray[47] = "sourceServiceAccounts";
        stringArray[48] = "targetServiceAccounts";
        stringArray[49] = "collect";
        stringArray[50] = "sourceRanges";
        stringArray[51] = "withDefault";
        stringArray[52] = "each";
        stringArray[53] = "allowed";
        stringArray[54] = "each";
        stringArray[55] = "sort";
        stringArray[56] = "findResults";
        stringArray[57] = "deriveProjectId";
        stringArray[58] = "getLocalName";
        stringArray[59] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[60];
        GoogleSecurityGroupProvider.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(GoogleSecurityGroupProvider.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = GoogleSecurityGroupProvider.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

