/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Image;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.GlobalGoogleComputeRequestFactory;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;

public class Images {
    private final GoogleNamedAccountCredentials credentials;
    private final GlobalGoogleComputeRequestFactory requestFactory;

    public Images(GoogleNamedAccountCredentials credentials, GoogleOperationPoller operationPoller, Registry registry) {
        this.credentials = credentials;
        this.requestFactory = new GlobalGoogleComputeRequestFactory("images", credentials, operationPoller, registry);
    }

    public GoogleComputeGetRequest<Compute.Images.Get, Image> get(String project, String image) throws IOException {
        Compute.Images.Get request = this.credentials.getCompute().images().get(project, image);
        return this.requestFactory.wrapGetRequest(request, "get");
    }
}

