/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.ConnectionDraining;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.HostRule;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.PathRule;
import com.google.api.services.compute.model.TargetHttpProxy;
import com.google.api.services.compute.model.TargetHttpsProxiesSetSslCertificatesRequest;
import com.google.api.services.compute.model.TargetHttpsProxy;
import com.google.api.services.compute.model.UrlMap;
import com.google.api.services.compute.model.UrlMapReference;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.UpsertGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationException;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.UpsertGoogleLoadBalancerAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.GoogleHealthCheck;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleBackendService;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHostRule;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancedBackend;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSessionAffinity;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTargetProxyType;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationsRegistry;
import com.netflix.spinnaker.clouddriver.orchestration.OrchestrationProcessor;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertGoogleHttpLoadBalancerAtomicOperation
extends UpsertGoogleLoadBalancerAtomicOperation {
    private static final String BASE_PHASE = "UPSERT_HTTP_LOAD_BALANCER";
    private static final String PATH_MATCHER_PREFIX = "pm";
    public static final String TARGET_HTTP_PROXY_NAME_PREFIX = "target-http-proxy";
    public static final String TARGET_HTTPS_PROXY_NAME_PREFIX = "target-https-proxy";
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private AtomicOperationsRegistry atomicOperationsRegistry;
    @Autowired
    private OrchestrationProcessor orchestrationProcessor;
    @Autowired
    private SafeRetry safeRetry;
    private final UpsertGoogleLoadBalancerDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public UpsertGoogleHttpLoadBalancerAtomicOperation(UpsertGoogleLoadBalancerDescription description) {
        UpsertGoogleLoadBalancerDescription upsertGoogleLoadBalancerDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = upsertGoogleLoadBalancerDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map operate(List priorOutputs) {
        CallSite httpLoadBalancer = IndyInterface.bootstrap("init", "<init>", 0, GoogleHttpLoadBalancer.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), "urlMapName", IndyInterface.bootstrap("getProperty", "urlMapName", 4, this.description), "defaultService", IndyInterface.bootstrap("getProperty", "defaultService", 4, this.description), "hostRules", IndyInterface.bootstrap("getProperty", "hostRules", 4, this.description), "certificate", IndyInterface.bootstrap("getProperty", "certificate", 4, this.description), "ipAddress", IndyInterface.bootstrap("getProperty", "ipAddress", 4, this.description), "ipProtocol", IndyInterface.bootstrap("getProperty", "ipProtocol", 4, this.description), "portRange", IndyInterface.bootstrap("getProperty", "portRange", 4, this.description)}));
        CallSite httpLoadBalancerName = IndyInterface.bootstrap("getProperty", "name", 0, httpLoadBalancer);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{httpLoadBalancerName}, new String[]{"Initializing upsert of HTTP load balancer ", "..."}));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "accountName", 4, this.description)}, new String[]{"Unable to resolve credentials for Google account '", "'."})));
        }
        Reference compute = new Reference((Object)IndyInterface.bootstrap("getProperty", "compute", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
        Reference project = new Reference((Object)IndyInterface.bootstrap("getProperty", "project", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
        Reference healthCheckExistsSet = new Reference((Object)((HashSet)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), HashSet.class))));
        Reference healthCheckNeedsUpdatedSet = new Reference((Object)((HashSet)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), HashSet.class))));
        Reference serviceExistsSet = new Reference((Object)((HashSet)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), HashSet.class))));
        Reference serviceNeedsUpdatedSet = new Reference((Object)((HashSet)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), HashSet.class))));
        CallSite urlMapExists = null;
        Object targetProxyExists = false;
        Boolean targetProxyNeedsUpdated = false;
        CallSite forwardingRuleExists = null;
        CallSite backendServicesFromDescription = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "unique", 0, IndyInterface.bootstrap("invoke", "getBackendServicesFromHttpLoadBalancerView", 0, Utils.class, IndyInterface.bootstrap("getProperty", "view", 0, httpLoadBalancer))));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "healthCheck", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite healthChecksFromDescription = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "unique", 0, IndyInterface.bootstrap("invoke", "collect", 0, backendServicesFromDescription, new _operate_closure1(this, this))));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "urlMapName", 1, httpLoadBalancer);
        CallSite urlMapName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : httpLoadBalancerName);
        Set legacyHealthChecks = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getItems", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "list", 0, IndyInterface.bootstrap("invoke", "httpHealthChecks", 0, compute.get()), project.get()), "compute.httpHealthChecks.list", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this))), Set.class));
        Reference existingHealthChecks = new Reference((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getItems", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "list", 0, IndyInterface.bootstrap("invoke", "healthChecks", 0, compute.get()), project.get()), "compute.healthChecks.list", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this))), Set.class))));
        Reference existingServices = new Reference((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getItems", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "list", 0, IndyInterface.bootstrap("invoke", "backendServices", 0, compute.get()), project.get()), "compute.backendServices.list", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this))), Set.class))));
        Reference existingUrlMap = new Reference(null);
        try {
            existingUrlMap.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "urlMaps", 0, compute.get()), project.get(), urlMapName), "compute.urlMaps.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this))));
        }
        catch (GoogleJsonResponseException e) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getStatusCode", 0, e), (Object)404)) {
                throw (Throwable)e;
            }
        }
        urlMapExists = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, (UrlMap)existingUrlMap.get(), Boolean.class));
        CallSite existingRule = null;
        try {
            existingRule = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "globalForwardingRules", 0, compute.get()), project.get(), httpLoadBalancerName), "compute.globalForwardingRules.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)));
        }
        catch (GoogleJsonResponseException e) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getStatusCode", 0, e), (Object)404)) {
                throw (Throwable)e;
            }
        }
        forwardingRuleExists = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, existingRule, Boolean.class));
        CallSite existingProxy = null;
        if (IndyInterface.bootstrap("cast", "()", 0, forwardingRuleExists) != false) {
            CallSite targetProxyName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getTarget", 0, existingRule)));
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "getTargetProxyType", 0, Utils.class, IndyInterface.bootstrap("invoke", "getTarget", 0, existingRule));
            if (ScriptBytecodeAdapter.isCase((Object)callSite2, (Object)IndyInterface.bootstrap("getProperty", "HTTP", 0, GoogleTargetProxyType.class))) {
                existingProxy = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "targetHttpProxies", 0, compute.get()), project.get(), targetProxyName), "compute.targetHttpProxies.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
            } else if (ScriptBytecodeAdapter.isCase((Object)callSite2, (Object)IndyInterface.bootstrap("getProperty", "HTTPS", 0, GoogleTargetProxyType.class))) {
                existingProxy = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "targetHttpsProxies", 0, compute.get()), project.get(), targetProxyName), "compute.targetHttpsProxies.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "certificate", 0, httpLoadBalancer)) == false) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{httpLoadBalancerName}, new String[]{"", " is an Https load balancer, but the upsert description does not contain a certificate."})));
                }
                targetProxyNeedsUpdated = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getSslCertificates", 1, existingProxy), false)), (Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "buildCertificateUrl", 0, GCEUtil.class, project.get(), IndyInterface.bootstrap("getProperty", "certificate", 0, httpLoadBalancer))));
            } else {
                CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "warn", 0, log, new GStringImpl(new Object[]{targetProxyName}, new String[]{"Unexpected target proxy type for ", "."})) : null;
            }
            targetProxyExists = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, existingProxy, Boolean.class));
            if (DefaultTypeTransformation.booleanUnbox((Object)existingProxy) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getUrlMap", 0, existingProxy)), (Object)IndyInterface.bootstrap("getProperty", "urlMapName", 4, this.description))) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getName", 0, existingRule), IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getUrlMap", 0, existingProxy))}, new String[]{"Listener with name ", " already exists and points to url map: ", ","}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "urlMapName", 4, this.description)}, new String[]{" which is different from the description url map: ", "."}))));
            }
        }
        public final class _operate_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "name", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, healthChecksFromDescription), (Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "unique", 0, healthChecksFromDescription, false, new _operate_closure2(this, this))))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleOperationException.class, IndyInterface.bootstrap("invoke", "plus", 0, "Duplicate health checks with different attributes in the description. ", "Please specify one object per named health check.")));
        }
        public final class _operate_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingHealthChecks;
            private /* synthetic */ Reference healthCheckExistsSet;
            private /* synthetic */ Reference healthCheckNeedsUpdatedSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure3(Object _outerInstance, Object _thisObject, Reference existingHealthChecks, Reference healthCheckExistsSet, Reference healthCheckNeedsUpdatedSet) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.existingHealthChecks = reference3 = existingHealthChecks;
                this.healthCheckExistsSet = reference2 = healthCheckExistsSet;
                this.healthCheckNeedsUpdatedSet = reference = healthCheckNeedsUpdatedSet;
            }

            public Object doCall(GoogleHealthCheck healthCheck) {
                Reference healthCheckName = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 4, healthCheck)));
                public final class _closure14
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference healthCheckName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure14(Object _outerInstance, Object _thisObject, Reference healthCheckName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.healthCheckName = reference = healthCheckName;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.healthCheckName.get()));
                    }

                    @Generated
                    public String getHealthCheckName() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.healthCheckName.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure14.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite existingHealthCheck = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingHealthChecks.get()), new _closure14((Object)this, this.getThisObject(), healthCheckName));
                if (IndyInterface.bootstrap("cast", "()", 0, existingHealthCheck) != false) {
                    IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.healthCheckExistsSet.get()), IndyInterface.bootstrap("getProperty", "name", 4, healthCheck));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "healthCheckShouldBeUpdated", 0, GCEUtil.class, existingHealthCheck, healthCheck)) != false) {
                        return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.healthCheckNeedsUpdatedSet.get()), IndyInterface.bootstrap("getProperty", "name", 4, healthCheck));
                    }
                }
                return null;
            }

            @Generated
            public Object call(GoogleHealthCheck healthCheck) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, healthCheck);
            }

            @Generated
            public Set getExistingHealthChecks() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingHealthChecks.get());
            }

            @Generated
            public HashSet getHealthCheckExistsSet() {
                return IndyInterface.bootstrap("cast", "()", 0, this.healthCheckExistsSet.get());
            }

            @Generated
            public HashSet getHealthCheckNeedsUpdatedSet() {
                return IndyInterface.bootstrap("cast", "()", 0, this.healthCheckNeedsUpdatedSet.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, healthChecksFromDescription, new _operate_closure3(this, this, existingHealthChecks, healthCheckExistsSet, healthCheckNeedsUpdatedSet));
        public final class _operate_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "name", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, backendServicesFromDescription), (Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "unique", 0, backendServicesFromDescription, false, new _operate_closure4(this, this))))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleOperationException.class, IndyInterface.bootstrap("invoke", "plus", 0, "Duplicate backend services with different attributes in the description. ", "Please specify one object per named backend service.")));
        }
        Object object = ScriptBytecodeAdapter.getPropertySpreadSafe(UpsertGoogleHttpLoadBalancerAtomicOperation.class, (Object)legacyHealthChecks, (String)"name");
        Reference legacyHealthCheckNames = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, object) != false ? object : ScriptBytecodeAdapter.createList((Object[])new Object[0])));
        public final class _operate_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingServices;
            private /* synthetic */ Reference serviceExistsSet;
            private /* synthetic */ Reference legacyHealthCheckNames;
            private /* synthetic */ Reference serviceNeedsUpdatedSet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure5(Object _outerInstance, Object _thisObject, Reference existingServices, Reference serviceExistsSet, Reference legacyHealthCheckNames, Reference serviceNeedsUpdatedSet) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.existingServices = reference4 = existingServices;
                this.serviceExistsSet = reference3 = serviceExistsSet;
                this.legacyHealthCheckNames = reference2 = legacyHealthCheckNames;
                this.serviceNeedsUpdatedSet = reference = serviceNeedsUpdatedSet;
            }

            public Object doCall(GoogleBackendService backendService) {
                Reference backendServiceName = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 4, backendService)));
                public final class _closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference backendServiceName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure15(Object _outerInstance, Object _thisObject, Reference backendServiceName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.backendServiceName = reference = backendServiceName;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.backendServiceName.get()));
                    }

                    @Generated
                    public String getBackendServiceName() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.backendServiceName.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite existingService = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingServices.get()), new _closure15((Object)this, this.getThisObject(), backendServiceName));
                if (IndyInterface.bootstrap("cast", "()", 0, existingService) != false) {
                    IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.serviceExistsSet.get()), IndyInterface.bootstrap("getProperty", "name", 4, backendService));
                    public final class _closure16
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure16(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, it);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure16.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    Boolean differentHealthChecks = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getHealthChecks", 0, existingService), new _closure16((Object)this, this.getThisObject())), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, backendService))}));
                    CallSite updateFromLegacyHealthCheck = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.legacyHealthCheckNames.get()), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, backendService))));
                    Boolean differentSessionAffinity = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "valueOf", 0, GoogleSessionAffinity.class, IndyInterface.bootstrap("invoke", "getSessionAffinity", 0, existingService)), (Object)IndyInterface.bootstrap("getProperty", "sessionAffinity", 4, backendService));
                    Boolean differentSessionCookieTtl = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getAffinityCookieTtlSec", 0, existingService), (Object)IndyInterface.bootstrap("getProperty", "affinityCookieTtlSec", 4, backendService));
                    Boolean differentCDN = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getEnableCDN", 0, existingService), (Object)IndyInterface.bootstrap("getProperty", "enableCDN", 4, backendService));
                    Boolean differentPortName = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getPortName", 0, existingService), (Object)IndyInterface.bootstrap("getProperty", "portName", 4, backendService));
                    Boolean differentConnectionDraining = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getDrainingTimeoutSec", 1, IndyInterface.bootstrap("invoke", "getConnectionDraining", 0, existingService)), (Object)IndyInterface.bootstrap("getProperty", "connectionDrainingTimeoutSec", 5, backendService));
                    if (DefaultTypeTransformation.booleanUnbox((Object)differentHealthChecks) || DefaultTypeTransformation.booleanUnbox((Object)differentSessionAffinity) || DefaultTypeTransformation.booleanUnbox((Object)differentSessionCookieTtl) || DefaultTypeTransformation.booleanUnbox((Object)differentCDN) || DefaultTypeTransformation.booleanUnbox((Object)differentPortName) || DefaultTypeTransformation.booleanUnbox((Object)differentConnectionDraining) || DefaultTypeTransformation.booleanUnbox((Object)updateFromLegacyHealthCheck)) {
                        return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.serviceNeedsUpdatedSet.get()), IndyInterface.bootstrap("getProperty", "name", 4, backendService));
                    }
                }
                return null;
            }

            @Generated
            public Object call(GoogleBackendService backendService) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, backendService);
            }

            @Generated
            public Set getExistingServices() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingServices.get());
            }

            @Generated
            public HashSet getServiceExistsSet() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serviceExistsSet.get());
            }

            @Generated
            public List getLegacyHealthCheckNames() {
                return IndyInterface.bootstrap("cast", "()", 0, this.legacyHealthCheckNames.get());
            }

            @Generated
            public HashSet getServiceNeedsUpdatedSet() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serviceNeedsUpdatedSet.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, backendServicesFromDescription, new _operate_closure5(this, this, existingServices, serviceExistsSet, legacyHealthCheckNames, serviceNeedsUpdatedSet));
        public final class _operate_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference healthCheckExistsSet;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference healthCheckNeedsUpdatedSet;
            private /* synthetic */ Reference existingHealthChecks;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure6(Object _outerInstance, Object _thisObject, Reference healthCheckExistsSet, Reference compute, Reference project, Reference healthCheckNeedsUpdatedSet, Reference existingHealthChecks) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.healthCheckExistsSet = reference5 = healthCheckExistsSet;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.healthCheckNeedsUpdatedSet = reference2 = healthCheckNeedsUpdatedSet;
                this.existingHealthChecks = reference = existingHealthChecks;
            }

            public Object doCall(GoogleHealthCheck healthCheck) {
                Reference healthCheckName = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 4, healthCheck)));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.healthCheckExistsSet.get()), IndyInterface.bootstrap("getProperty", "name", 4, healthCheck))) == false) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{(String)healthCheckName.get()}, new String[]{"Creating health check ", "..."}));
                    CallSite newHealthCheck = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createNewHealthCheck", 0, GCEUtil.class, healthCheck));
                    CallSite insertHealthCheckOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "healthChecks", 0, this.compute.get()), this.project.get(), newHealthCheck), "compute.healthChecks.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                    return IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.compute.get(), this.project.get(), IndyInterface.bootstrap("invoke", "getName", 0, insertHealthCheckOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "health check ", (String)healthCheckName.get()), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.healthCheckExistsSet.get()), IndyInterface.bootstrap("getProperty", "name", 4, healthCheck))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.healthCheckNeedsUpdatedSet.get()), IndyInterface.bootstrap("getProperty", "name", 4, healthCheck)))) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{(String)healthCheckName.get()}, new String[]{"Updating health check ", "..."}));
                    public final class _closure17
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference healthCheckName;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure17(Object _outerInstance, Object _thisObject, Reference healthCheckName) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.healthCheckName = reference = healthCheckName;
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.healthCheckName.get()));
                        }

                        @Generated
                        public String getHealthCheckName() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.healthCheckName.get());
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure17.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite hcToUpdate = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingHealthChecks.get()), new _closure17((Object)this, this.getThisObject(), healthCheckName));
                    IndyInterface.bootstrap("invoke", "updateExistingHealthCheck", 0, GCEUtil.class, hcToUpdate, healthCheck);
                    CallSite updateHealthCheckOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "update", 0, IndyInterface.bootstrap("invoke", "healthChecks", 0, this.compute.get()), this.project.get(), (String)healthCheckName.get(), hcToUpdate), "compute.healthChecks.update", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                    return IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.compute.get(), this.project.get(), IndyInterface.bootstrap("invoke", "getName", 0, updateHealthCheckOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{(String)healthCheckName.get()}, new String[]{"health check ", ""}), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
                }
                return null;
            }

            @Generated
            public Object call(GoogleHealthCheck healthCheck) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, healthCheck);
            }

            @Generated
            public HashSet getHealthCheckExistsSet() {
                return IndyInterface.bootstrap("cast", "()", 0, this.healthCheckExistsSet.get());
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public HashSet getHealthCheckNeedsUpdatedSet() {
                return IndyInterface.bootstrap("cast", "()", 0, this.healthCheckNeedsUpdatedSet.get());
            }

            @Generated
            public Set getExistingHealthChecks() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingHealthChecks.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, healthChecksFromDescription, new _operate_closure6(this, this, healthCheckExistsSet, compute, project, healthCheckNeedsUpdatedSet, existingHealthChecks));
        public final class _operate_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serviceExistsSet;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference serviceNeedsUpdatedSet;
            private /* synthetic */ Reference existingServices;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure7(Object _outerInstance, Object _thisObject, Reference serviceExistsSet, Reference project, Reference compute, Reference serviceNeedsUpdatedSet, Reference existingServices) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.serviceExistsSet = reference5 = serviceExistsSet;
                this.project = reference4 = project;
                this.compute = reference3 = compute;
                this.serviceNeedsUpdatedSet = reference2 = serviceNeedsUpdatedSet;
                this.existingServices = reference = existingServices;
            }

            public Object doCall(GoogleBackendService backendService) {
                Reference backendServiceName = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 4, backendService)));
                CallSite callSite = IndyInterface.bootstrap("invoke", "toString", 1, IndyInterface.bootstrap("getProperty", "sessionAffinity", 5, backendService));
                CallSite sessionAffinity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "NONE");
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.serviceExistsSet.get()), IndyInterface.bootstrap("getProperty", "name", 4, backendService))) == false) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{(String)backendServiceName.get()}, new String[]{"Creating backend service ", "..."}));
                    Object[] objectArray = new Object[14];
                    objectArray[0] = "name";
                    objectArray[1] = (String)backendServiceName.get();
                    objectArray[2] = "portName";
                    CallSite callSite2 = IndyInterface.bootstrap("getProperty", "portName", 4, backendService);
                    objectArray[3] = IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : IndyInterface.bootstrap("getProperty", "HTTP_DEFAULT_PORT_NAME", 0, GoogleHttpLoadBalancingPolicy.class);
                    objectArray[4] = "connectionDraining";
                    objectArray[5] = IndyInterface.bootstrap("invoke", "setDrainingTimeoutSec", 0, IndyInterface.bootstrap("init", "<init>", 0, ConnectionDraining.class), IndyInterface.bootstrap("getProperty", "connectionDrainingTimeoutSec", 4, backendService));
                    objectArray[6] = "healthChecks";
                    objectArray[7] = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "buildHealthCheckUrl", 0, GCEUtil.class, this.project.get(), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, backendService)))});
                    objectArray[8] = "sessionAffinity";
                    objectArray[9] = sessionAffinity;
                    objectArray[10] = "enableCDN";
                    objectArray[11] = IndyInterface.bootstrap("getProperty", "enableCDN", 4, backendService);
                    objectArray[12] = "affinityCookieTtlSec";
                    objectArray[13] = IndyInterface.bootstrap("getProperty", "affinityCookieTtlSec", 4, backendService);
                    CallSite bs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, BackendService.class, ScriptBytecodeAdapter.createMap((Object[])objectArray)));
                    CallSite insertBackendServiceOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "backendServices", 0, this.compute.get()), this.project.get(), bs), "compute.backendServices.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                    return IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.compute.get(), this.project.get(), IndyInterface.bootstrap("invoke", "getName", 0, insertBackendServiceOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "backend service ", (String)backendServiceName.get()), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.serviceExistsSet.get()), IndyInterface.bootstrap("getProperty", "name", 4, backendService))) != false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.serviceNeedsUpdatedSet.get()), IndyInterface.bootstrap("getProperty", "name", 4, backendService))) != false) {
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{(String)backendServiceName.get()}, new String[]{"Updating backend service ", "..."}));
                        public final class _closure18
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference backendServiceName;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure18(Object _outerInstance, Object _thisObject, Reference backendServiceName) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.backendServiceName = reference = backendServiceName;
                            }

                            public Object doCall(Object it) {
                                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.backendServiceName.get()));
                            }

                            @Generated
                            public String getBackendServiceName() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.backendServiceName.get());
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure18.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite bsToUpdate = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingServices.get()), new _closure18((Object)this, this.getThisObject(), backendServiceName));
                        CallSite hcName = IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, backendService));
                        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "portName", 4, backendService);
                        CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : IndyInterface.bootstrap("getProperty", "HTTP_DEFAULT_PORT_NAME", 0, GoogleHttpLoadBalancingPolicy.class);
                        ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)bsToUpdate, (String)"portName");
                        CallSite callSite5 = IndyInterface.bootstrap("invoke", "setDrainingTimeoutSec", 0, IndyInterface.bootstrap("init", "<init>", 0, ConnectionDraining.class), IndyInterface.bootstrap("getProperty", "connectionDrainingTimeoutSec", 4, backendService));
                        ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)bsToUpdate, (String)"connectionDraining");
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "buildHealthCheckUrl", 0, GCEUtil.class, this.project.get(), hcName)});
                        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)bsToUpdate, (String)"healthChecks");
                        CallSite callSite6 = sessionAffinity;
                        ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)bsToUpdate, (String)"sessionAffinity");
                        CallSite callSite7 = IndyInterface.bootstrap("getProperty", "enableCDN", 4, backendService);
                        ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)bsToUpdate, (String)"enableCDN");
                        CallSite callSite8 = IndyInterface.bootstrap("getProperty", "affinityCookieTtlSec", 4, backendService);
                        ScriptBytecodeAdapter.setProperty((Object)callSite8, null, (Object)bsToUpdate, (String)"affinityCookieTtlSec");
                        CallSite updateServiceOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "update", 0, IndyInterface.bootstrap("invoke", "backendServices", 0, this.compute.get()), this.project.get(), (String)backendServiceName.get(), bsToUpdate), "compute.backendServices.update", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                        IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.compute.get(), this.project.get(), IndyInterface.bootstrap("invoke", "getName", 0, updateServiceOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{(String)backendServiceName.get()}, new String[]{"backend service  ", ""}), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
                    }
                    return IndyInterface.bootstrap("invoke", "fixBackendMetadata", 2, this, this.compute.get(), IndyInterface.bootstrap("getProperty", "credentials", 4, IndyInterface.bootstrap("getProperty", "description", 12, this)), this.project.get(), IndyInterface.bootstrap("getProperty", "atomicOperationsRegistry", 12, this), IndyInterface.bootstrap("getProperty", "orchestrationProcessor", 12, this), IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, IndyInterface.bootstrap("getProperty", "description", 12, this)), backendService);
                }
                return null;
            }

            @Generated
            public Object call(GoogleBackendService backendService) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, backendService);
            }

            @Generated
            public HashSet getServiceExistsSet() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serviceExistsSet.get());
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public HashSet getServiceNeedsUpdatedSet() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serviceNeedsUpdatedSet.get());
            }

            @Generated
            public Set getExistingServices() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingServices.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, backendServicesFromDescription, new _operate_closure7(this, this, serviceExistsSet, project, compute, serviceNeedsUpdatedSet, existingServices));
        public final class _operate_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure8(Object _outerInstance, Object _thisObject, Reference compute, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.compute = reference2 = compute;
                this.project = reference = project;
            }

            public Object doCall(GoogleBackendService backendService) {
                return IndyInterface.bootstrap("invoke", "fixBackendMetadata", 2, this, this.compute.get(), IndyInterface.bootstrap("getProperty", "credentials", 4, IndyInterface.bootstrap("getProperty", "description", 12, this)), this.project.get(), IndyInterface.bootstrap("getProperty", "atomicOperationsRegistry", 12, this), IndyInterface.bootstrap("getProperty", "orchestrationProcessor", 12, this), IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, IndyInterface.bootstrap("getProperty", "description", 12, this)), backendService);
            }

            @Generated
            public Object call(GoogleBackendService backendService) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, backendService);
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "backendServiceDiff", 5, this.description), new _operate_closure8(this, this, compute, project));
        Object urlMapToUpdate = null;
        CallSite urlMapUrl = null;
        if (IndyInterface.bootstrap("cast", "()", 0, urlMapExists) == false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{urlMapName}, new String[]{"Creating URL map ", "..."}));
            Reference newUrlMap = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, UrlMap.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", urlMapName, "hostRules", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "pathMatchers", ScriptBytecodeAdapter.createList((Object[])new Object[0])}))));
            CallSite callSite4 = IndyInterface.bootstrap("invoke", "buildBackendServiceUrl", 0, GCEUtil.class, project.get(), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "defaultService", 0, httpLoadBalancer)));
            ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)((UrlMap)newUrlMap.get()), (String)"defaultService");
            public final class _operate_closure9
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference newUrlMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure9(Object _outerInstance, Object _thisObject, Reference project, Reference newUrlMap) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.project = reference2 = project;
                    this.newUrlMap = reference = newUrlMap;
                }

                public Object doCall(GoogleHostRule hostRule) {
                    CallSite pathMatcherName = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "PATH_MATCHER_PREFIX", 12, this), IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class))}, new String[]{"", "-", ""}));
                    CallSite pathMatcher = IndyInterface.bootstrap("getProperty", "pathMatcher", 4, hostRule);
                    public final class _closure19
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference project;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure19(Object _outerInstance, Object _thisObject, Reference project) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.project = reference = project;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("init", "<init>", 0, PathRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"paths", IndyInterface.bootstrap("getProperty", "paths", 0, it), "service", IndyInterface.bootstrap("invoke", "buildBackendServiceUrl", 0, GCEUtil.class, this.project.get(), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "backendService", 0, it)))}));
                        }

                        @Generated
                        public Object getProject() {
                            return this.project.get();
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure19.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite newPathMatcher = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PathMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", pathMatcherName, "defaultService", IndyInterface.bootstrap("invoke", "buildBackendServiceUrl", 0, GCEUtil.class, this.project.get(), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "defaultService", 0, pathMatcher))), "pathRules", IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "pathRules", 0, pathMatcher), new _closure19((Object)this, this.getThisObject(), this.project))})));
                    IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "pathMatchers", 0, IndyInterface.bootstrap("cast", "()", 0, this.newUrlMap.get())), newPathMatcher);
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "hostRules", 0, IndyInterface.bootstrap("cast", "()", 0, this.newUrlMap.get())), IndyInterface.bootstrap("init", "<init>", 0, HostRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pathMatcher", pathMatcherName, "hosts", IndyInterface.bootstrap("getProperty", "hostPatterns", 4, hostRule)})));
                }

                @Generated
                public Object call(GoogleHostRule hostRule) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, hostRule);
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public UrlMap getNewUrlMap() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.newUrlMap.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "hostRules", 1, httpLoadBalancer), new _operate_closure9(this, this, project, newUrlMap));
            CallSite insertUrlMapOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "urlMaps", 0, compute.get()), project.get(), (UrlMap)newUrlMap.get()), "compute.urlMaps.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
            IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("invoke", "getName", 0, insertUrlMapOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "url map ", urlMapName), BASE_PHASE);
            urlMapUrl = IndyInterface.bootstrap("invoke", "getTargetLink", 0, insertUrlMapOperation);
        } else if (IndyInterface.bootstrap("cast", "()", 0, urlMapExists) != false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{urlMapName}, new String[]{"Updating URL map ", "..."}));
            CallSite callSite5 = IndyInterface.bootstrap("invoke", "buildBackendServiceUrl", 0, GCEUtil.class, project.get(), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "defaultService", 0, httpLoadBalancer)));
            ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)((UrlMap)existingUrlMap.get()), (String)"defaultService");
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)((UrlMap)existingUrlMap.get()), (String)"pathMatchers");
            List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)list2, null, (Object)((UrlMap)existingUrlMap.get()), (String)"hostRules");
            public final class _operate_closure10
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference existingUrlMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure10(Object _outerInstance, Object _thisObject, Reference project, Reference existingUrlMap) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.project = reference2 = project;
                    this.existingUrlMap = reference = existingUrlMap;
                }

                public Object doCall(GoogleHostRule hostRule) {
                    CallSite pathMatcherName = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "PATH_MATCHER_PREFIX", 12, this), IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class))}, new String[]{"", "-", ""}));
                    CallSite pathMatcher = IndyInterface.bootstrap("getProperty", "pathMatcher", 4, hostRule);
                    public final class _closure20
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference project;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure20(Object _outerInstance, Object _thisObject, Reference project) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.project = reference = project;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("init", "<init>", 0, PathRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"paths", IndyInterface.bootstrap("getProperty", "paths", 0, it), "service", IndyInterface.bootstrap("invoke", "buildBackendServiceUrl", 0, GCEUtil.class, this.project.get(), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "backendService", 0, it)))}));
                        }

                        @Generated
                        public Object getProject() {
                            return this.project.get();
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure20.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite newPathMatcher = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, PathMatcher.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", pathMatcherName, "defaultService", IndyInterface.bootstrap("invoke", "buildBackendServiceUrl", 0, GCEUtil.class, this.project.get(), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "defaultService", 0, pathMatcher))), "pathRules", IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "pathRules", 0, pathMatcher), new _closure20((Object)this, this.getThisObject(), this.project))})));
                    IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "pathMatchers", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingUrlMap.get())), newPathMatcher);
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "hostRules", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingUrlMap.get())), IndyInterface.bootstrap("init", "<init>", 0, HostRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pathMatcher", pathMatcherName, "hosts", IndyInterface.bootstrap("getProperty", "hostPatterns", 4, hostRule)})));
                }

                @Generated
                public Object call(GoogleHostRule hostRule) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, hostRule);
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public UrlMap getExistingUrlMap() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.existingUrlMap.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "hostRules", 1, httpLoadBalancer), new _operate_closure10(this, this, project, existingUrlMap));
            CallSite updateUrlMapOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "update", 0, IndyInterface.bootstrap("invoke", "urlMaps", 0, compute.get()), project.get(), urlMapName, (UrlMap)existingUrlMap.get()), "compute.urlMaps.update", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
            IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("invoke", "getName", 0, updateUrlMapOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{urlMapName}, new String[]{"url map ", ""}), BASE_PHASE);
            urlMapUrl = IndyInterface.bootstrap("invoke", "getTargetLink", 0, updateUrlMapOperation);
        } else {
            urlMapUrl = IndyInterface.bootstrap("invoke", "getSelfLink", 0, (UrlMap)existingUrlMap.get());
        }
        CallSite targetProxyName = null;
        CallSite targetProxy = null;
        CallSite insertTargetProxyOperation = null;
        CallSite targetProxyUrl = null;
        if (IndyInterface.bootstrap("cast", "()", 0, targetProxyExists) == false) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "certificate", 0, httpLoadBalancer)) != false) {
                targetProxyName = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{httpLoadBalancerName, TARGET_HTTPS_PROXY_NAME_PREFIX}, new String[]{"", "-", ""}));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{targetProxyName}, new String[]{"Creating target proxy ", "..."}));
                targetProxy = IndyInterface.bootstrap("init", "<init>", 0, TargetHttpsProxy.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", targetProxyName, "sslCertificates", ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "buildCertificateUrl", 0, GCEUtil.class, project.get(), IndyInterface.bootstrap("getProperty", "certificate", 0, httpLoadBalancer))}), "urlMap", urlMapUrl}));
                insertTargetProxyOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "targetHttpsProxies", 0, compute.get()), project.get(), targetProxy), "compute.targetHttpsProxies.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
            } else {
                targetProxyName = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{httpLoadBalancerName, TARGET_HTTP_PROXY_NAME_PREFIX}, new String[]{"", "-", ""}));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{targetProxyName}, new String[]{"Creating target proxy ", "..."}));
                targetProxy = IndyInterface.bootstrap("init", "<init>", 0, TargetHttpProxy.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", targetProxyName, "urlMap", urlMapUrl}));
                insertTargetProxyOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "targetHttpProxies", 0, compute.get()), project.get(), targetProxy), "compute.targetHttpProxies.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
            }
            IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("invoke", "getName", 0, insertTargetProxyOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{targetProxyName}, new String[]{"target proxy ", ""}), BASE_PHASE);
            targetProxyUrl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTargetLink", 0, insertTargetProxyOperation));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)targetProxyExists) && DefaultTypeTransformation.booleanUnbox((Object)targetProxyNeedsUpdated)) {
            CallSite proxyType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTargetProxyType", 0, Utils.class, IndyInterface.bootstrap("invoke", "getSelfLink", 1, existingProxy)));
            CallSite callSite6 = proxyType;
            if (!ScriptBytecodeAdapter.isCase((Object)callSite6, (Object)IndyInterface.bootstrap("getProperty", "HTTP", 0, GoogleTargetProxyType.class))) {
                if (!ScriptBytecodeAdapter.isCase((Object)callSite6, (Object)IndyInterface.bootstrap("getProperty", "HTTPS", 0, GoogleTargetProxyType.class))) throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{httpLoadBalancerName}, new String[]{"Updating Http load balancer ", " failed. "}), new GStringImpl(new Object[]{targetProxyName, proxyType}, new String[]{"Could not update target proxy ", "; Illegal target proxy type ", "."}))));
                targetProxyName = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{httpLoadBalancerName, TARGET_HTTPS_PROXY_NAME_PREFIX}, new String[]{"", "-", ""}));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{targetProxyName}, new String[]{"Updating target proxy ", "..."}));
                CallSite setSslReq = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, TargetHttpsProxiesSetSslCertificatesRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sslCertificates", ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "buildCertificateUrl", 0, GCEUtil.class, project.get(), IndyInterface.bootstrap("getProperty", "certificate", 0, httpLoadBalancer))})})));
                CallSite sslCertOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setSslCertificates", 0, IndyInterface.bootstrap("invoke", "targetHttpsProxies", 0, compute.get()), project.get(), targetProxyName, setSslReq), "compute.targetHttpsProxies.setSslCertificates", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("invoke", "getName", 0, sslCertOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "certificate", 0, httpLoadBalancer)}, new String[]{"set ssl cert ", ""}), BASE_PHASE);
                CallSite urlMapRef = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, UrlMapReference.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"urlMap", urlMapUrl})));
                CallSite setUrlMapOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setUrlMap", 0, IndyInterface.bootstrap("invoke", "targetHttpsProxies", 0, compute.get()), project.get(), targetProxyName, urlMapRef), "compute.targetHttpsProxies.setUrlMap", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("invoke", "getName", 0, setUrlMapOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{urlMapUrl, targetProxyName}, new String[]{"set urlMap ", " for target proxy ", ""}), BASE_PHASE);
                targetProxyUrl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTargetLink", 0, setUrlMapOp));
            }
        } else {
            targetProxyUrl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSelfLink", 0, existingProxy));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, forwardingRuleExists) == false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{httpLoadBalancerName}, new String[]{"Creating global forwarding rule ", "..."}));
            Reference forwardingRule = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, ForwardingRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", httpLoadBalancerName, "IPAddress", IndyInterface.bootstrap("getProperty", "ipAddress", 0, httpLoadBalancer), "IPProtocol", IndyInterface.bootstrap("getProperty", "ipProtocol", 0, httpLoadBalancer), "portRange", IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "certificate", 0, httpLoadBalancer)) != false ? "443" : IndyInterface.bootstrap("getProperty", "portRange", 0, httpLoadBalancer), "target", targetProxyUrl})));
            public final class _operate_closure11
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference forwardingRule;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure11(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference forwardingRule) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.forwardingRule = reference = forwardingRule;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "globalForwardingRules", 0, this.compute.get()), this.project.get(), this.forwardingRule.get()), "compute.globalForwardingRules.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getForwardingRule() {
                    return this.forwardingRule.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Operation forwardingRuleOp = (Operation)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, new _operate_closure11(this, this, compute, project, forwardingRule), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Global forwarding rule ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "insert", "phase", BASE_PHASE, "operation", "compute.globalForwardingRules.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this)), Operation.class);
            IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("invoke", "getName", 0, forwardingRuleOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "forwarding rule ", httpLoadBalancerName), BASE_PHASE);
        }
        public final class _operate_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure12(Object _outerInstance, Object _thisObject, Reference compute, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.compute = reference2 = compute;
                this.project = reference = project;
            }

            public Object doCall(String forwardingRuleName) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{forwardingRuleName}, new String[]{"Deleting listener ", "..."}));
                return IndyInterface.bootstrap("invoke", "deleteGlobalListener", 0, GCEUtil.class, this.compute.get(), this.project.get(), forwardingRuleName, IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), IndyInterface.bootstrap("getProperty", "safeRetry", 12, this), this.getThisObject());
            }

            @Generated
            public Object call(String forwardingRuleName) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, forwardingRuleName);
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "listenersToDelete", 4, this.description), new _operate_closure12(this, this, compute, project));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{httpLoadBalancerName}, new String[]{"Done upserting HTTP load balancer ", ""}));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancers", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"global", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", httpLoadBalancerName})})});
    }

    /*
     * WARNING - void declaration
     */
    private void fixBackendMetadata(Compute compute, GoogleNamedAccountCredentials credentials, String project, AtomicOperationsRegistry atomicOperationsRegistry, OrchestrationProcessor orchestrationProcessor, String loadBalancerName, GoogleBackendService backendService) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference credentials2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)var3_3);
        Reference atomicOperationsRegistry2 = new Reference((Object)atomicOperationsRegistry);
        Reference orchestrationProcessor2 = new Reference((Object)orchestrationProcessor);
        Reference loadBalancerName2 = new Reference((Object)loadBalancerName);
        Reference backendService2 = new Reference((Object)backendService);
        public final class _fixBackendMetadata_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference loadBalancerName;
            private /* synthetic */ Reference backendService;
            private /* synthetic */ Reference atomicOperationsRegistry;
            private /* synthetic */ Reference orchestrationProcessor;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fixBackendMetadata_closure13(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference credentials, Reference loadBalancerName, Reference backendService, Reference atomicOperationsRegistry, Reference orchestrationProcessor) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                this.compute = reference7 = compute;
                this.project = reference6 = project;
                this.credentials = reference5 = credentials;
                this.loadBalancerName = reference4 = loadBalancerName;
                this.backendService = reference3 = backendService;
                this.atomicOperationsRegistry = reference2 = atomicOperationsRegistry;
                this.orchestrationProcessor = reference = orchestrationProcessor;
            }

            public Object doCall(GoogleLoadBalancedBackend backend) {
                CallSite groupName = IndyInterface.bootstrap("invoke", "getLocalName", 0, Utils.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 4, backend));
                CallSite groupRegion = IndyInterface.bootstrap("invoke", "getRegionFromGroupUrl", 0, Utils.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 4, backend));
                CallSite templateUrl = null;
                CallSite callSite = IndyInterface.bootstrap("invoke", "determineServerGroupType", 0, Utils.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 4, backend));
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "REGIONAL", 0, GoogleServerGroup.ServerGroupType.class))) {
                    templateUrl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceTemplate", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "regionInstanceGroupManagers", 0, IndyInterface.bootstrap("cast", "()", 0, this.compute.get())), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), groupRegion, groupName), "compute.regionInstanceGroupManagers.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), groupRegion)));
                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "ZONAL", 0, GoogleServerGroup.ServerGroupType.class))) {
                    CallSite groupZone = IndyInterface.bootstrap("invoke", "getZoneFromGroupUrl", 0, Utils.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 4, backend));
                    templateUrl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceTemplate", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "instanceGroupManagers", 0, IndyInterface.bootstrap("cast", "()", 0, this.compute.get())), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), groupZone, groupName), "compute.instanceGroupManagers.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), groupZone)));
                } else {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "serverGroupUrl", 4, backend)}, new String[]{"Server group referenced by ", " has illegal type."})));
                }
                CallSite template = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "instanceTemplates", 0, IndyInterface.bootstrap("cast", "()", 0, this.compute.get())), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("invoke", "getLocalName", 0, Utils.class, templateUrl)), "compute.instancesTemplates.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)));
                CallSite instanceDescription = IndyInterface.bootstrap("invoke", "buildInstanceDescriptionFromTemplate", 0, GCEUtil.class, IndyInterface.bootstrap("cast", "()", 0, this.project.get()), template);
                Map templateOpMap = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"image", IndyInterface.bootstrap("getProperty", "image", 0, instanceDescription), "instanceType", IndyInterface.bootstrap("getProperty", "instanceType", 0, instanceDescription), "credentials", IndyInterface.bootstrap("invoke", "getName", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), "disks", IndyInterface.bootstrap("getProperty", "disks", 0, instanceDescription), "instanceMetadata", IndyInterface.bootstrap("getProperty", "instanceMetadata", 0, instanceDescription), "tags", IndyInterface.bootstrap("getProperty", "tags", 0, instanceDescription), "network", IndyInterface.bootstrap("getProperty", "network", 0, instanceDescription), "subnet", IndyInterface.bootstrap("getProperty", "subnet", 0, instanceDescription), "serviceAccountEmail", IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 0, instanceDescription), "authScopes", IndyInterface.bootstrap("getProperty", "authScopes", 0, instanceDescription), "preemptible", IndyInterface.bootstrap("getProperty", "preemptible", 0, instanceDescription), "automaticRestart", IndyInterface.bootstrap("getProperty", "automaticRestart", 0, instanceDescription), "onHostMaintenance", IndyInterface.bootstrap("getProperty", "onHostMaintenance", 0, instanceDescription), "region", groupRegion, "serverGroupName", groupName});
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "minCpuPlatform", 0, instanceDescription)) != false) {
                    CallSite callSite2 = IndyInterface.bootstrap("getProperty", "minCpuPlatform", 0, instanceDescription);
                    ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)templateOpMap, (String)"minCpuPlatform");
                }
                CallSite instanceMetadata = IndyInterface.bootstrap("getProperty", "instanceMetadata", 1, templateOpMap);
                if (IndyInterface.bootstrap("cast", "()", 0, instanceMetadata) != false) {
                    CallSite callSite3 = IndyInterface.bootstrap("invoke", "split", 1, ScriptBytecodeAdapter.getProperty(_fixBackendMetadata_closure13.class, (Object)instanceMetadata, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "GLOBAL_LOAD_BALANCER_NAMES", 12, this)))), ",");
                    CallSite globalLbs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                    globalLbs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, globalLbs) != false ? IndyInterface.bootstrap("invoke", "plus", 0, globalLbs, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get())) : ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get())}));
                    CallSite callSite4 = IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "unique", 0, globalLbs), ",");
                    ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)instanceMetadata, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "GLOBAL_LOAD_BALANCER_NAMES", 12, this))));
                    CallSite callSite5 = IndyInterface.bootstrap("invoke", "split", 1, ScriptBytecodeAdapter.getProperty(_fixBackendMetadata_closure13.class, (Object)instanceMetadata, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "BACKEND_SERVICE_NAMES", 12, this)))), ",");
                    CallSite bsNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite5) != false ? callSite5 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                    bsNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, bsNames) != false ? IndyInterface.bootstrap("invoke", "plus", 0, bsNames, IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.backendService.get()))) : ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.backendService.get()))}));
                    CallSite callSite6 = IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "unique", 0, bsNames), ",");
                    ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)instanceMetadata, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "BACKEND_SERVICE_NAMES", 12, this))));
                } else {
                    Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "GLOBAL_LOAD_BALANCER_NAMES", 0, GCEUtil.class), IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()), IndyInterface.bootstrap("getProperty", "BACKEND_SERVICE_NAMES", 0, GCEUtil.class), IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.backendService.get()))});
                    ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)templateOpMap, (String)"instanceMetadata");
                }
                CallSite converter = IndyInterface.bootstrap("invoke", "getAtomicOperationConverter", 0, IndyInterface.bootstrap("cast", "()", 0, this.atomicOperationsRegistry.get()), "modifyGoogleServerGroupInstanceTemplateDescription", "gce");
                CallSite templateOp = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertOperation", 0, converter, templateOpMap));
                return IndyInterface.bootstrap("invoke", "process", 0, IndyInterface.bootstrap("cast", "()", 0, this.orchestrationProcessor.get()), "gce", ScriptBytecodeAdapter.createList((Object[])new Object[]{templateOp}), IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)));
            }

            @Generated
            public Object call(GoogleLoadBalancedBackend backend) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, backend);
            }

            @Generated
            public Compute getCompute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
            }

            @Generated
            public String getProject() {
                return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
            }

            @Generated
            public GoogleNamedAccountCredentials getCredentials() {
                return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
            }

            @Generated
            public String getLoadBalancerName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get());
            }

            @Generated
            public GoogleBackendService getBackendService() {
                return IndyInterface.bootstrap("cast", "()", 0, this.backendService.get());
            }

            @Generated
            public AtomicOperationsRegistry getAtomicOperationsRegistry() {
                return IndyInterface.bootstrap("cast", "()", 0, this.atomicOperationsRegistry.get());
            }

            @Generated
            public OrchestrationProcessor getOrchestrationProcessor() {
                return IndyInterface.bootstrap("cast", "()", 0, this.orchestrationProcessor.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fixBackendMetadata_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "backends", 4, (GoogleBackendService)backendService2.get()), new _fixBackendMetadata_closure13(this, this, compute2, project2, credentials2, loadBalancerName2, backendService2, atomicOperationsRegistry2, orchestrationProcessor2));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertGoogleHttpLoadBalancerAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.UpsertGoogleHttpLoadBalancerAtomicOperation");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public AtomicOperationsRegistry getAtomicOperationsRegistry() {
        return this.atomicOperationsRegistry;
    }

    @Generated
    public @VisibleForTesting @VisibleForTesting void setAtomicOperationsRegistry(AtomicOperationsRegistry atomicOperationsRegistry) {
        this.atomicOperationsRegistry = atomicOperationsRegistry;
    }

    @Generated
    public OrchestrationProcessor getOrchestrationProcessor() {
        return this.orchestrationProcessor;
    }

    @Generated
    public @VisibleForTesting @VisibleForTesting void setOrchestrationProcessor(OrchestrationProcessor orchestrationProcessor) {
        this.orchestrationProcessor = orchestrationProcessor;
    }

    @Override
    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Override
    @Generated
    public @VisibleForTesting @VisibleForTesting void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ Map super$3$operate(List list) {
        return super.operate(list);
    }

    public /* synthetic */ SafeRetry super$3$getSafeRetry() {
        return super.getSafeRetry();
    }

    public /* synthetic */ void super$3$setSafeRetry(SafeRetry safeRetry) {
        super.setSafeRetry(safeRetry);
    }
}

