/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.snapshot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.config.GoogleConfigurationProperties;
import com.netflix.spinnaker.clouddriver.google.deploy.description.snapshot.RestoreSnapshotDescription;
import com.netflix.spinnaker.clouddriver.google.model.GoogleCluster;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSecurityGroup;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancerView;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleNetworkLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleLoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSecurityGroupProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.jobs.JobExecutor;
import com.netflix.spinnaker.clouddriver.jobs.JobRequest;
import com.netflix.spinnaker.clouddriver.jobs.JobResult;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class RestoreSnapshotAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    private static final String BASE_PHASE = "RESTORE_SNAPSHOT";
    private final RestoreSnapshotDescription description;
    private final String applicationName;
    private final String accountName;
    private final Long snapshotTimestamp;
    private final String directory;
    private String project;
    private String credentialPath;
    private Set imported;
    private List applicationTags;
    private boolean hasEnvCredentials;
    @Autowired
    private GoogleConfigurationProperties googleConfigurationProperties;
    @Autowired
    private GoogleClusterProvider googleClusterProvider;
    @Autowired
    private GoogleLoadBalancerProvider googleLoadBalancerProvider;
    @Autowired
    private GoogleSecurityGroupProvider googleSecurityGroupProvider;
    @Autowired
    private AccountCredentialsRepository accountCredentialsRepository;
    @Autowired
    private JobExecutor jobExecutor;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private Front50Service front50Service;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public RestoreSnapshotAtomicOperation(RestoreSnapshotDescription description) {
        List list;
        boolean bl;
        RestoreSnapshotDescription restoreSnapshotDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = restoreSnapshotDescription = description;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "applicationName", 4, description);
        this.applicationName = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "accountName", 4, description);
        this.accountName = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "snapshotTimestamp", 4, description);
        this.snapshotTimestamp = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        GStringImpl gStringImpl = new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"", "-", ""});
        this.directory = IndyInterface.bootstrap("cast", "()", 0, gStringImpl);
        CallSite callSite4 = IndyInterface.bootstrap("init", "<init>", 0, HashSet.class);
        this.imported = IndyInterface.bootstrap("cast", "()", 0, callSite4);
        this.hasEnvCredentials = bl = false;
        this.applicationTags = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        GoogleNamedAccountCredentials credentials = (GoogleNamedAccountCredentials)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getOne", 0, this.accountCredentialsRepository, this.accountName), GoogleNamedAccountCredentials.class));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "project", 0, credentials);
        this.project = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite pb = IndyInterface.bootstrap("init", "<init>", 0, ProcessBuilder.class);
        CallSite env = IndyInterface.bootstrap("invoke", "environment", 0, pb);
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "GOOGLE_PROJECT", 0, env), (Object)this.project) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "GOOGLE_CREDENTIALS", 0, env)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "GOOGLE_REGION", 0, env))) {
            boolean bl;
            this.hasEnvCredentials = bl = true;
        } else {
            CallSite account = null;
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "accounts", 4, this.googleConfigurationProperties)));
            if (callSite2 != null) {
                while (callSite2.hasNext()) {
                    account = IndyInterface.bootstrap("cast", "()", 0, callSite2.next());
                    if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 4, account), (Object)this.accountName)) continue;
                    CallSite callSite3 = IndyInterface.bootstrap("getProperty", "jsonPath", 4, account);
                    this.credentialPath = IndyInterface.bootstrap("cast", "()", 0, callSite3);
                    break;
                }
            }
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.credentialPath, null) && !this.hasEnvCredentials) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{this.accountName}, new String[]{"Could not find credentials for ", ""})));
        }
        CallSite dir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, this.directory));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mkdir", 0, dir)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{this.directory}, new String[]{"Error creating directory ", ""})));
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"Importing state of server groups for the application ", " in account ", ""}));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(GoogleCluster.View cluster) {
                public final class _closure7
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure7(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(GoogleServerGroup.View serverGroup) {
                        return IndyInterface.bootstrap("invoke", "importServerGroupState", 2, this, serverGroup);
                    }

                    @Generated
                    public Object call(GoogleServerGroup.View serverGroup) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, serverGroup);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "serverGroups", 4, cluster), new _closure7((Object)this, this.getThisObject()));
            }

            @Generated
            public Object call(GoogleCluster.View cluster) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, cluster);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getClusters", 0, this.googleClusterProvider, this.applicationName, this.accountName), new _operate_closure1(this, this));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"Importing state of load balancers for the application ", " in account ", ""}));
        public final class _operate_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(GoogleLoadBalancerView loadBalancer) {
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "account", 4, loadBalancer), (Object)IndyInterface.bootstrap("getProperty", "accountName", 12, this))) {
                    return IndyInterface.bootstrap("invoke", "importLoadBalancerState", 2, this, loadBalancer);
                }
                return null;
            }

            @Generated
            public Object call(GoogleLoadBalancerView loadBalancer) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, loadBalancer);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getApplicationLoadBalancers", 0, this.googleLoadBalancerProvider, this.applicationName), new _operate_closure2(this, this));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"Importing state of security groups for application ", " in account ", ""}));
        public final class _operate_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(GoogleSecurityGroup securityGroup) {
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "accountName", 4, securityGroup), (Object)IndyInterface.bootstrap("getProperty", "accountName", 12, this)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "targetTags", 4, securityGroup)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "disjoint", 0, Collections.class, IndyInterface.bootstrap("getProperty", "targetTags", 4, securityGroup), IndyInterface.bootstrap("getProperty", "applicationTags", 12, this))) == false) {
                    return IndyInterface.bootstrap("invoke", "importSecurityGroupState", 2, this, securityGroup);
                }
                return null;
            }

            @Generated
            public Object call(GoogleSecurityGroup securityGroup) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, securityGroup);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.googleSecurityGroupProvider, true), new _operate_closure3(this, this));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{this.snapshotTimestamp, this.applicationName, this.accountName}, new String[]{"Restoring snapshot with timestamp ", " for application ", " in account ", ""}));
        IndyInterface.bootstrap("invoke", "createTerraformConfig", 2, this);
        CallSite command = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"terraform", "apply", IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "-state=", this.directory), "/terraform.tfstate"), this.directory}));
        CallSite jobStatus = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "runJob", 0, this.jobExecutor, IndyInterface.bootstrap("init", "<init>", 0, JobRequest.class, command)));
        IndyInterface.bootstrap("invoke", "cleanUpDirectory", 2, this);
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getResult", 0, jobStatus), (Object)IndyInterface.bootstrap("getProperty", "FAILURE", 0, JobResult.Result.class)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "getOutput", 0, jobStatus))) {
            CallSite stdOut = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getOutput", 0, jobStatus));
            CallSite stdErr = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getError", 0, jobStatus));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{stdOut, stdErr}, new String[]{"", " + ", ""})));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void importServerGroupState(GoogleServerGroup.View serverGroup) {
        IndyInterface.bootstrap("invoke", "importResource", 2, this, "google_compute_instance_group_manager", IndyInterface.bootstrap("getProperty", "name", 4, serverGroup), IndyInterface.bootstrap("getProperty", "name", 4, serverGroup), IndyInterface.bootstrap("getProperty", "region", 4, serverGroup));
        CallSite instanceTemplate = IndyInterface.bootstrap("getProperty", "image", 0, IndyInterface.bootstrap("getProperty", "imageSummary", 4, serverGroup));
        if (DefaultTypeTransformation.booleanUnbox((Object)instanceTemplate) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.imported, IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate))) == false) {
            IndyInterface.bootstrap("invoke", "importResource", 2, this, "google_compute_instance_template", IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate), IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate), IndyInterface.bootstrap("getProperty", "region", 4, serverGroup));
            IndyInterface.bootstrap("invoke", "add", 0, this.imported, IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "items", 1, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)))) != false) {
                IndyInterface.bootstrap("invoke", "addAll", 0, this.applicationTags, IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate))));
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 4, serverGroup)) != false) {
            IndyInterface.bootstrap("invoke", "importResource", 2, this, "google_compute_autoscaler", IndyInterface.bootstrap("getProperty", "name", 4, serverGroup), IndyInterface.bootstrap("getProperty", "name", 4, serverGroup), IndyInterface.bootstrap("getProperty", "region", 4, serverGroup));
        }
        CallSite stateFile = IndyInterface.bootstrap("init", "<init>", 0, File.class, new GStringImpl(new Object[]{this.directory}, new String[]{"", "/terraform.tfstate"}));
        CallSite stateJson = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, IndyInterface.bootstrap("invoke", "useDelimiter", 0, IndyInterface.bootstrap("init", "<init>", 0, Scanner.class, stateFile), "\\Z")));
        Reference state = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readValue", 0, this.objectMapper, stateJson, new GroovyObject(this){
            final /* synthetic */ RestoreSnapshotAtomicOperation this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                RestoreSnapshotAtomicOperation restoreSnapshotAtomicOperation;
                this.this$0 = restoreSnapshotAtomicOperation = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                try {
                    return this.this$0.this$dist$invoke$1(name, args);
                }
                catch (MissingMethodException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound)));
                }
            }

            /*
             * Unable to fully structure code
             */
            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                if (!(args instanceof Object[] == false)) ** GOTO lbl8
                var2_2 = ScriptBytecodeAdapter.invokeMethodN(1.class, RestoreSnapshotAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                return var2_2;
lbl8:
                // 1 sources

                if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
                var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, RestoreSnapshotAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
                return var3_3;
lbl14:
                // 1 sources

                var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, RestoreSnapshotAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                try {
                    return var4_4;
                }
                catch (MissingMethodException notFound) {
                    throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
                }
            }

            public /* synthetic */ @VisibleForTesting void propertyMissing(String name, Object value) {
                try {
                    this.this$0.this$dist$set$1(name, value);
                    return;
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            public static /* synthetic */ @VisibleForTesting void $static_propertyMissing(String name, Object value) {
                try {
                    Object object = value;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, RestoreSnapshotAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            public /* synthetic */ Object propertyMissing(String name) {
                try {
                    return this.this$0.this$dist$get$1(name);
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                Object object = ScriptBytecodeAdapter.getProperty(1.class, RestoreSnapshotAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                try {
                    return object;
                }
                catch (MissingPropertyException notFound) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                }
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        })));
        public final class _importServerGroupState_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _importServerGroupState_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String loadBalancer) {
                return new GStringImpl(new Object[]{loadBalancer}, new String[]{"google_compute_target_pool.", ""});
            }

            @Generated
            public Object call(String loadBalancer) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, loadBalancer);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _importServerGroupState_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite igmDependencies = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 4, serverGroup), new _importServerGroupState_closure4(this, this));
        IndyInterface.bootstrap("invoke", "leftShift", 0, igmDependencies, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate)}, new String[]{"google_compute_instance_template.", ""}));
        IndyInterface.bootstrap("invoke", "addDependencies", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "resources", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "modules", 0, (Map)state.get()), false)), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, serverGroup)}, new String[]{"google_compute_instance_group_manager.", ""})), igmDependencies);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 4, serverGroup)) != false) {
            IndyInterface.bootstrap("invoke", "addDependencies", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "resources", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "modules", 0, (Map)state.get()), false)), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, serverGroup)}, new String[]{"google_compute_autoscaler.", ""})), ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, serverGroup)}, new String[]{"google_compute_instance_group_manager.", ""})}));
        }
        public final class _importServerGroupState_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference state;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _importServerGroupState_closure5(Object _outerInstance, Object _thisObject, Reference state) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.state = reference = state;
            }

            public Object doCall(Object w) {
                return IndyInterface.bootstrap("invoke", "leftShift", 0, w, IndyInterface.bootstrap("invoke", "writeValueAsString", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.state.get())));
            }

            @Generated
            public Map getState() {
                return IndyInterface.bootstrap("cast", "()", 0, this.state.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _importServerGroupState_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "withWriter", 0, IndyInterface.bootstrap("invoke", "newWriter", 0, stateFile), new _importServerGroupState_closure5(this, this, state));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void importLoadBalancerState(GoogleLoadBalancerView loadBalancer) {
        if (loadBalancer instanceof GoogleNetworkLoadBalancer.View) {
            CallSite targetPoolName = IndyInterface.bootstrap("invoke", "last", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("getProperty", "targetPool", 4, loadBalancer), "/"));
            IndyInterface.bootstrap("invoke", "importResource", 2, this, "google_compute_target_pool", IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer), targetPoolName, IndyInterface.bootstrap("getProperty", "region", 4, loadBalancer));
            IndyInterface.bootstrap("invoke", "importResource", 2, this, "google_compute_forwarding_rule", IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer), IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer), IndyInterface.bootstrap("getProperty", "region", 4, loadBalancer));
            if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "healthCheck", 4, loadBalancer)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, this.imported, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, loadBalancer)))) == false) {
                IndyInterface.bootstrap("invoke", "importResource", 2, this, "google_compute_http_health_check", IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, loadBalancer)), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, loadBalancer)), IndyInterface.bootstrap("getProperty", "region", 4, loadBalancer));
                IndyInterface.bootstrap("invoke", "add", 0, this.imported, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, loadBalancer)));
            }
            CallSite stateFile = IndyInterface.bootstrap("init", "<init>", 0, File.class, new GStringImpl(new Object[]{this.directory}, new String[]{"", "/terraform.tfstate"}));
            CallSite stateJson = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, IndyInterface.bootstrap("invoke", "useDelimiter", 0, IndyInterface.bootstrap("init", "<init>", 0, Scanner.class, stateFile), "\\Z")));
            Reference state = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readValue", 0, this.objectMapper, stateJson, new GroovyObject(this){
                final /* synthetic */ RestoreSnapshotAtomicOperation this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    RestoreSnapshotAtomicOperation restoreSnapshotAtomicOperation;
                    this.this$0 = restoreSnapshotAtomicOperation = p0;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    try {
                        return this.this$0.this$dist$invoke$1(name, args);
                    }
                    catch (MissingMethodException notFound) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound)));
                    }
                }

                /*
                 * Unable to fully structure code
                 */
                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    if (!(args instanceof Object[] == false)) ** GOTO lbl8
                    var2_2 = ScriptBytecodeAdapter.invokeMethodN(2.class, RestoreSnapshotAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                    return var2_2;
lbl8:
                    // 1 sources

                    if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
                    var3_3 = ScriptBytecodeAdapter.invokeMethodN(2.class, RestoreSnapshotAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
                    return var3_3;
lbl14:
                    // 1 sources

                    var4_4 = ScriptBytecodeAdapter.invokeMethodN(2.class, RestoreSnapshotAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                    try {
                        return var4_4;
                    }
                    catch (MissingMethodException notFound) {
                        throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 2.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
                    }
                }

                public /* synthetic */ @VisibleForTesting void propertyMissing(String name, Object value) {
                    try {
                        this.this$0.this$dist$set$1(name, value);
                        return;
                    }
                    catch (MissingPropertyException notFound) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                    }
                }

                public static /* synthetic */ @VisibleForTesting void $static_propertyMissing(String name, Object value) {
                    try {
                        Object object = value;
                        ScriptBytecodeAdapter.setProperty((Object)object, null, RestoreSnapshotAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                    }
                    catch (MissingPropertyException notFound) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 2.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                    }
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    try {
                        return this.this$0.this$dist$get$1(name);
                    }
                    catch (MissingPropertyException notFound) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                    }
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    Object object = ScriptBytecodeAdapter.getProperty(2.class, RestoreSnapshotAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                    try {
                        return object;
                    }
                    catch (MissingPropertyException notFound) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 2.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                    }
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != 2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                @Transient
                public MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            })));
            IndyInterface.bootstrap("invoke", "addDependencies", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "resources", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "modules", 0, (Map)state.get()), false)), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer)}, new String[]{"google_compute_forwarding_rule.", ""})), ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer)}, new String[]{"google_compute_target_pool.", ""})}));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, loadBalancer)) != false) {
                IndyInterface.bootstrap("invoke", "addDependencies", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "resources", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "modules", 0, (Map)state.get()), false)), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer)}, new String[]{"google_compute_target_pool.", ""})), ScriptBytecodeAdapter.createList((Object[])new Object[]{new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, loadBalancer))}, new String[]{"google_compute_http_health_check.", ""})}));
            }
            public final class _importLoadBalancerState_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference state;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _importLoadBalancerState_closure6(Object _outerInstance, Object _thisObject, Reference state) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.state = reference = state;
                }

                public Object doCall(Object w) {
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, w, IndyInterface.bootstrap("invoke", "writeValueAsString", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.state.get())));
                }

                @Generated
                public Map getState() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.state.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _importLoadBalancerState_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "withWriter", 0, IndyInterface.bootstrap("invoke", "newWriter", 0, stateFile), new _importLoadBalancerState_closure6(this, this, state));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void importSecurityGroupState(GoogleSecurityGroup securityGroup) {
        IndyInterface.bootstrap("invoke", "importResource", 2, this, "google_compute_firewall", IndyInterface.bootstrap("getProperty", "name", 4, securityGroup), IndyInterface.bootstrap("getProperty", "name", 4, securityGroup), IndyInterface.bootstrap("getProperty", "region", 4, securityGroup));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private void importResource(String resource, String name, String id, String region) {
        CallSite inputStream = null;
        CallSite pb = IndyInterface.bootstrap("init", "<init>", 0, ProcessBuilder.class);
        CallSite env = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "environment", 0, pb));
        if (!this.hasEnvCredentials) {
            inputStream = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ByteArrayInputStream.class, IndyInterface.bootstrap("invoke", "getBytes", 0, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.credentialPath, this.project, region}, new String[]{"", "\n", "\n", ""})))));
        } else {
            inputStream = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ByteArrayInputStream.class));
            String string = region;
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)env, (String)"GOOGLE_REGION");
        }
        CallSite command = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"terraform", "import", IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "-state=", this.directory), "/terraform.tfstate"), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, resource, "."), name), id}));
        CallSite jobStatus = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "runJob", 0, this.jobExecutor, IndyInterface.bootstrap("init", "<init>", 0, JobRequest.class, command, env, inputStream)));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getResult", 0, jobStatus), (Object)IndyInterface.bootstrap("getProperty", "FAILURE", 0, JobResult.Result.class)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "getOutput", 0, jobStatus))) {
            IndyInterface.bootstrap("invoke", "cleanUpDirectory", 2, this);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getOutput", 0, jobStatus), IndyInterface.bootstrap("invoke", "getError", 0, jobStatus))));
        }
    }

    private void createTerraformConfig() {
        CallSite snapshot = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSnapshotVersion", 0, this.front50Service, this.directory, IndyInterface.bootstrap("invoke", "toString", 0, this.snapshotTimestamp)));
        Map terraformConfig = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "infrastructure", 0, snapshot);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)terraformConfig, (String)"resource");
        if (!this.hasEnvCredentials) {
            Map provider = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)provider, (String)"google");
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{this.credentialPath}, new String[]{"${file(\"", "\")}"}));
            ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)IndyInterface.bootstrap("getProperty", "google", 0, provider), (String)"credentials");
            String string = this.project;
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)IndyInterface.bootstrap("getProperty", "google", 0, provider), (String)"project");
            String string2 = "us-central1";
            ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)IndyInterface.bootstrap("getProperty", "google", 0, provider), (String)"region");
            Map map2 = provider;
            ScriptBytecodeAdapter.setProperty((Object)map2, null, (Object)terraformConfig, (String)"provider");
        }
        CallSite file = IndyInterface.bootstrap("init", "<init>", 0, File.class, new GStringImpl(new Object[]{this.directory}, new String[]{"", "/snapshot.tf.json"}));
        IndyInterface.bootstrap("invoke", "write", 0, file, IndyInterface.bootstrap("invoke", "writeValueAsString", 0, this.objectMapper, terraformConfig));
    }

    private void addDependencies(Map resource, List dependencies) {
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "depends_on", 0, resource), null)) {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)resource, (String)"depends_on");
        }
        CallSite dependency = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, dependencies));
        if (callSite != null) {
            while (callSite.hasNext()) {
                dependency = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "depends_on", 0, resource), dependency);
            }
        }
    }

    private void cleanUpDirectory() {
        CallSite files = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        IndyInterface.bootstrap("invoke", "leftShift", 0, files, IndyInterface.bootstrap("init", "<init>", 0, File.class, new GStringImpl(new Object[]{this.directory}, new String[]{"", "/terraform.tfstate"})));
        IndyInterface.bootstrap("invoke", "leftShift", 0, files, IndyInterface.bootstrap("init", "<init>", 0, File.class, new GStringImpl(new Object[]{this.directory}, new String[]{"", "/terraform.tfstate.backup"})));
        IndyInterface.bootstrap("invoke", "leftShift", 0, files, IndyInterface.bootstrap("init", "<init>", 0, File.class, new GStringImpl(new Object[]{this.directory}, new String[]{"", "/snapshot.tf.json"})));
        CallSite file = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, files));
        if (callSite != null) {
            while (callSite.hasNext()) {
                file = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "exists", 0, file)) == false || !(IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "delete", 0, file)) == false)) continue;
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, file)}, new String[]{"Error deleting file ", ""})));
            }
        }
        CallSite dir = IndyInterface.bootstrap("init", "<init>", 0, File.class, new GStringImpl(new Object[]{this.directory}, new String[]{"", ""}));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "delete", 0, dir)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, dir)}, new String[]{"Error deleting directory ", ""})));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RestoreSnapshotAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RestoreSnapshotAtomicOperation.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RestoreSnapshotAtomicOperation.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RestoreSnapshotAtomicOperation.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RestoreSnapshotAtomicOperation.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(RestoreSnapshotAtomicOperation.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public GoogleConfigurationProperties getGoogleConfigurationProperties() {
        return this.googleConfigurationProperties;
    }

    @Generated
    public void setGoogleConfigurationProperties(GoogleConfigurationProperties googleConfigurationProperties) {
        this.googleConfigurationProperties = googleConfigurationProperties;
    }

    @Generated
    public GoogleClusterProvider getGoogleClusterProvider() {
        return this.googleClusterProvider;
    }

    @Generated
    public void setGoogleClusterProvider(GoogleClusterProvider googleClusterProvider) {
        this.googleClusterProvider = googleClusterProvider;
    }

    @Generated
    public GoogleLoadBalancerProvider getGoogleLoadBalancerProvider() {
        return this.googleLoadBalancerProvider;
    }

    @Generated
    public void setGoogleLoadBalancerProvider(GoogleLoadBalancerProvider googleLoadBalancerProvider) {
        this.googleLoadBalancerProvider = googleLoadBalancerProvider;
    }

    @Generated
    public GoogleSecurityGroupProvider getGoogleSecurityGroupProvider() {
        return this.googleSecurityGroupProvider;
    }

    @Generated
    public void setGoogleSecurityGroupProvider(GoogleSecurityGroupProvider googleSecurityGroupProvider) {
        this.googleSecurityGroupProvider = googleSecurityGroupProvider;
    }

    @Generated
    public AccountCredentialsRepository getAccountCredentialsRepository() {
        return this.accountCredentialsRepository;
    }

    @Generated
    public void setAccountCredentialsRepository(AccountCredentialsRepository accountCredentialsRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
    }

    @Generated
    public JobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    @Generated
    public void setJobExecutor(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public Front50Service getFront50Service() {
        return this.front50Service;
    }

    @Generated
    public void setFront50Service(Front50Service front50Service) {
        this.front50Service = front50Service;
    }
}

