/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.validators;

import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.description.BaseGoogleInstanceDescription;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoHealingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoscalingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleDisk;
import com.netflix.spinnaker.clouddriver.google.model.GoogleDiskType;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstanceTypeDisk;
import com.netflix.spinnaker.clouddriver.google.security.GoogleCredentials;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class StandardGceAttributeValidator
implements GroovyObject {
    private String context;
    private ValidationErrors errors;
    private Object customInstanceRegExp;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public StandardGceAttributeValidator(String context, ValidationErrors errors) {
        ValidationErrors validationErrors;
        String string;
        MetaClass metaClass;
        String string2 = "(.*)-?custom-(\\d{1,2})-(\\d{3,6})(-ext)?";
        this.customInstanceRegExp = string2;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.context = string = context;
        this.errors = validationErrors = errors;
    }

    public Object validateNotEmpty(Object value, String attribute) {
        return IndyInterface.bootstrap("invoke", "validateNotEmptyAsPart", 2, this, value, attribute, attribute);
    }

    public Object validateNotEmptyAsPart(Object value, String attribute, String part) {
        if (DefaultTypeTransformation.booleanUnbox((Object)value) || value instanceof Number) {
            return true;
        }
        IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, attribute, new GStringImpl(new Object[]{this.context, part}, new String[]{"", ".", ".empty"}));
        return false;
    }

    public Object validateName(String value, String attribute) {
        return IndyInterface.bootstrap("invoke", "validateNameAsPart", 2, this, value, attribute, attribute);
    }

    public Object validateNameAsPart(String value, String attribute, String part) {
        CallSite result = IndyInterface.bootstrap("invoke", "validateNotEmptyAsPart", 2, this, value, attribute, part);
        return result;
    }

    public Object validateCredentials(String accountName, CredentialsRepository<GoogleNamedAccountCredentials> credentialsRepository) {
        Object result = IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, accountName, "credentials");
        if (IndyInterface.bootstrap("cast", "()", 0, result) != false) {
            CallSite credentials = IndyInterface.bootstrap("invoke", "getOne", 0, credentialsRepository, accountName);
            if (!(IndyInterface.bootstrap("getProperty", "credentials", 1, credentials) instanceof GoogleCredentials)) {
                IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "credentials", new GStringImpl(new Object[]{this.context}, new String[]{"", ".credentials.invalid"}));
                result = false;
            }
        }
        return result;
    }

    public Object validateRegion(String region, GoogleNamedAccountCredentials credentials) {
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, region, "region")) && DefaultTypeTransformation.booleanUnbox((Object)((Object)credentials))) {
            if (!ScriptBytecodeAdapter.isCase((Object)region, (Object)IndyInterface.bootstrap("getProperty", "regionToZonesMap", 4, credentials))) {
                return IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "region", new GStringImpl(new Object[]{this.context}, new String[]{"", ".region.invalid"}));
            }
            if (!ScriptBytecodeAdapter.isCase((Object)region, (Object)ScriptBytecodeAdapter.getPropertySpreadSafe(StandardGceAttributeValidator.class, (Object)IndyInterface.bootstrap("getProperty", "regions", 4, credentials), (String)"name"))) {
                return IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "region", new GStringImpl(new Object[]{this.context}, new String[]{"", ".region.unconfigured"}));
            }
        }
        return null;
    }

    public Object validateZone(String zone, GoogleNamedAccountCredentials credentials) {
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, zone, "zone")) && DefaultTypeTransformation.booleanUnbox((Object)((Object)credentials))) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "regionFromZone", 0, credentials, zone)) == false) {
                return IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "zone", new GStringImpl(new Object[]{this.context}, new String[]{"", ".zone.invalid"}));
            }
            if (!ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("invoke", "regionFromZone", 0, credentials, zone), (Object)ScriptBytecodeAdapter.getPropertySpreadSafe(StandardGceAttributeValidator.class, (Object)IndyInterface.bootstrap("getProperty", "regions", 4, credentials), (String)"name"))) {
                return IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "zone", new GStringImpl(new Object[]{this.context}, new String[]{"", ".zone.unconfigured"}));
            }
        }
        return null;
    }

    public Object validateNetwork(String network) {
        return IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, network, "network");
    }

    public Object validateNonNegativeLong(long value, String attribute) {
        Boolean result = true;
        if (value < (long)0) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, attribute, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".negative"}));
            result = false;
        }
        return result;
    }

    public Object validateInRangeExclusive(double value, double min, double max, String attribute) {
        Boolean result = true;
        if (value <= min || !(value < max)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, attribute, new GStringImpl(new Object[]{this.context, attribute, min, max}, new String[]{"", ".", " must be between ", " and ", "."}));
            result = false;
        }
        return result;
    }

    public Object validateInRangeInclusive(int value, int min, int max, String attribute) {
        Boolean result = true;
        if (value < min || value > max) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, attribute, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".rangeViolation"}), new GStringImpl(new Object[]{this.context, attribute, min, max}, new String[]{"", ".", " must be between ", " and ", ", inclusive."}));
            result = false;
        }
        return result;
    }

    public Object validateMaxNotLessThanMin(long minValue, long maxValue, String minAttribute, String maxAttribute) {
        Boolean result = true;
        if (maxValue < minValue) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, maxAttribute, new GStringImpl(new Object[]{this.context, maxAttribute}, new String[]{"", ".", ".lessThanMin"}), new GStringImpl(new Object[]{this.context, maxAttribute, this.context, minAttribute}, new String[]{"", ".", " must not be less than ", ".", "."}));
            result = false;
        }
        return result;
    }

    public Object validateServerGroupName(String serverGroupName) {
        return IndyInterface.bootstrap("invoke", "validateName", 2, this, serverGroupName, "serverGroupName");
    }

    public Object validateImage(BaseGoogleInstanceDescription.ImageSource imageSource, String image, Artifact imageArtifact) {
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)imageSource), (Object)IndyInterface.bootstrap("getProperty", "ARTIFACT", 0, BaseGoogleInstanceDescription.ImageSource.class))) {
            return IndyInterface.bootstrap("invoke", "validateImageArtifact", 2, this, imageArtifact);
        }
        return IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, image, "image");
    }

    public Object validateImageArtifact(Artifact imageArtifact) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, imageArtifact, "imageArtifact")) == false) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getType", 0, imageArtifact), (Object)IndyInterface.bootstrap("getProperty", "GCE_IMAGE_TYPE", 0, GCEUtil.class))) {
            return IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "imageArtifact.type", new GStringImpl(new Object[]{this.context}, new String[]{"", ".imageArtifact.type.invalid"}));
        }
        return null;
    }

    public Object validateImageName(String imageName) {
        return IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, imageName, "imageName");
    }

    public Object validateNameList(List<String> names, String componentDescription) {
        return IndyInterface.bootstrap("invoke", "validateNameListHelper", 2, this, names, componentDescription, false);
    }

    public Object validateOptionalNameList(List<String> names, String componentDescription) {
        return IndyInterface.bootstrap("invoke", "validateNameListHelper", 2, this, names, componentDescription, true);
    }

    public Object validateNameListHelper(List<String> names, String componentDescription, boolean emptyListIsOk) {
        Reference componentDescription2 = new Reference((Object)componentDescription);
        if (emptyListIsOk && IndyInterface.bootstrap("cast", "()", 0, names) == false) {
            return true;
        }
        Reference result = new Reference((Object)IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, names, new GStringImpl(new Object[]{(String)componentDescription2.get()}, new String[]{"", "s"})));
        public final class _validateNameListHelper_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private /* synthetic */ Reference componentDescription;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateNameListHelper_closure1(Object _outerInstance, Object _thisObject, Reference result, Reference componentDescription) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.result = reference2 = result;
                this.componentDescription = reference = componentDescription;
            }

            public Object doCall(Object value, Object index) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "and", 0, this.result.get(), IndyInterface.bootstrap("invoke", "validateNameAsPart", 2, this, value, new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.componentDescription.get())}, new String[]{"", "s"}), new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.componentDescription.get()), index}, new String[]{"", "", ""})));
                this.result.set((Object)callSite);
                return callSite;
            }

            @Generated
            public Object call(Object value, Object index) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, value, index);
            }

            @Generated
            public Object getResult() {
                return this.result.get();
            }

            @Generated
            public String getComponentDescription() {
                return IndyInterface.bootstrap("cast", "()", 0, this.componentDescription.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateNameListHelper_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "eachWithIndex", 0, names, new _validateNameListHelper_closure1(this, this, result, componentDescription2));
        return result.get();
    }

    public Object validateInstanceIds(List<String> instanceIds) {
        return IndyInterface.bootstrap("invoke", "validateNameList", 2, this, instanceIds, "instanceId");
    }

    public Object validateInstanceName(String instanceName) {
        return IndyInterface.bootstrap("invoke", "validateName", 2, this, instanceName, "instanceName");
    }

    public Object validateInstanceType(String instanceType, String location, GoogleNamedAccountCredentials credentials) {
        IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, instanceType, "instanceType");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 1, instanceType, "custom")) != false) {
            boolean extendMemory = false;
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 1, instanceType, "ext")) != false) {
                extendMemory = true;
            }
            return IndyInterface.bootstrap("invoke", "validateCustomInstanceType", 2, this, instanceType, location, credentials, extendMemory);
        }
        return null;
    }

    public Object validateCustomInstanceType(String instanceType, String location, GoogleNamedAccountCredentials credentials, boolean extendMemory) {
        Matcher customTypeMatcher = ScriptBytecodeAdapter.findRegex((Object)instanceType, (Object)this.customInstanceRegExp);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 0, customTypeMatcher)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "instanceType", new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), "Custom instance string must match pattern /(.*)-?custom-(\\d{1,2})-(\\d{3,6})(-ext)?/.");
            return false;
        }
        CallSite vCpuCount = IndyInterface.bootstrap("invoke", "toDouble", 0, IndyInterface.bootstrap("invoke", "group", 0, customTypeMatcher, 2));
        CallSite memory = IndyInterface.bootstrap("invoke", "toDouble", 0, IndyInterface.bootstrap("invoke", "group", 0, customTypeMatcher, 3));
        CallSite memoryInGbs = IndyInterface.bootstrap("invoke", "div", 0, memory, 1024);
        CallSite maxMemory = IndyInterface.bootstrap("invoke", "multiply", 0, vCpuCount, 8);
        CallSite minMemory = IndyInterface.bootstrap("invoke", "div", 0, IndyInterface.bootstrap("invoke", "ceil", 0, Math.class, IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "multiply", 0, $const$0, vCpuCount), 4)), 4);
        if (ScriptBytecodeAdapter.compareLessThan((Object)vCpuCount, (Object)1)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "instanceType", new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), "vCPU count must be greater than or equal to 1.");
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)vCpuCount, (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "mod", 0, vCpuCount, 2), (Object)1)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "instanceType", new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), "Above 1, vCPU count must be even.");
        }
        if (!extendMemory) {
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)memoryInGbs, (Object)maxMemory)) {
                IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "instanceType", new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), "Memory per vCPU must be less than 8GB.");
            }
            if (ScriptBytecodeAdapter.compareLessThan((Object)memoryInGbs, (Object)minMemory)) {
                IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "instanceType", new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), "Memory per vCPU must be greater than 0.5GB.");
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "mod", 0, memory, 256), (Object)0)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "instanceType", new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), "Total memory must be a multiple of 256MB.");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, location) != false) {
            if (ScriptBytecodeAdapter.isCase((Object)location, (Object)IndyInterface.bootstrap("getProperty", "locationToInstanceTypesMap", 4, credentials))) {
                CallSite vCpuMaxForLocation = IndyInterface.bootstrap("getProperty", "vCpuMax", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "locationToInstanceTypesMap", 4, credentials), location));
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)vCpuCount, (Object)vCpuMaxForLocation)) {
                    return IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "instanceType", new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), new GStringImpl(new Object[]{location, vCpuMaxForLocation}, new String[]{"", " does not support more than ", " vCPUs."}));
                }
            } else {
                return IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "instanceType", new GStringImpl(new Object[]{this.context}, new String[]{"", ".instanceType.invalid"}), new GStringImpl(new Object[]{location}, new String[]{"", " not found."}));
            }
        }
        return null;
    }

    public Object validateMinCpuPlatform(String minCpuPlatform, String location, GoogleNamedAccountCredentials credentials) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "locationToCpuPlatformsMap", 4, credentials), location), minCpuPlatform)) == false) {
            return IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "minCpuPlatform", new GStringImpl(new Object[]{this.context}, new String[]{"", ".minCpuPlatform.invalid"}), new GStringImpl(new Object[]{minCpuPlatform, location}, new String[]{"CPU platform ", " is not available in ", "."}));
        }
        return null;
    }

    public Object validateInstanceTypeDisks(GoogleInstanceTypeDisk instanceTypeDisk, List<GoogleDisk> specifiedDisks) {
        Reference instanceTypeDisk2 = new Reference((Object)instanceTypeDisk);
        public final class _validateInstanceTypeDisks_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateInstanceTypeDisks_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object disk, Object index) {
                IndyInterface.bootstrap("invoke", "validateNotEmptyAsPart", 2, this, IndyInterface.bootstrap("getProperty", "type", 0, disk), "disks", new GStringImpl(new Object[]{index}, new String[]{"disk", ".type"}));
                IndyInterface.bootstrap("invoke", "validateNotEmptyAsPart", 2, this, IndyInterface.bootstrap("getProperty", "sizeGb", 0, disk), "disks", new GStringImpl(new Object[]{index}, new String[]{"disk", ".sizeGb"}));
                CallSite callSite = IndyInterface.bootstrap("getProperty", "sizeGb", 0, disk);
                return IndyInterface.bootstrap("invoke", "validateNonNegativeLong", 2, this, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0), new GStringImpl(new Object[]{index}, new String[]{"disk", ".sizeGb"}));
            }

            @Generated
            public Object call(Object disk, Object index) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, disk, index);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "eachWithIndex", 0, specifiedDisks, new _validateInstanceTypeDisks_closure2(this, this));
        if (IndyInterface.bootstrap("cast", "()", 0, specifiedDisks) != false) {
            public final class _validateInstanceTypeDisks_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _validateInstanceTypeDisks_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("getProperty", "persistent", 0, it);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            int persistentDiskCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "findAll", 0, specifiedDisks, new _validateInstanceTypeDisks_closure3(this, this))));
            if (!(persistentDiskCount != 0)) {
                IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, "disks", new GStringImpl(new Object[]{this.context}, new String[]{"", ".disks.missingPersistentDisk"}), "A persistent boot disk is required.");
            }
        }
        public final class _validateInstanceTypeDisks_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateInstanceTypeDisks_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "persistent", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _validateInstanceTypeDisks_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateInstanceTypeDisks_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object persistentDisk, Object index) {
                if (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("getProperty", "sizeGb", 0, persistentDisk), (Object)10)) {
                    return IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), "disks", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), index}, new String[]{"", ".disk", ".sizeGb.invalidSize"}), "Persistent disks must be at least 10GB.");
                }
                return null;
            }

            @Generated
            public Object call(Object persistentDisk, Object index) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, persistentDisk, index);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "eachWithIndex", 0, IndyInterface.bootstrap("invoke", "findAll", 0, specifiedDisks, new _validateInstanceTypeDisks_closure4(this, this)), new _validateInstanceTypeDisks_closure5(this, this));
        public final class _validateInstanceTypeDisks_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateInstanceTypeDisks_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "persistent", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference firstPersistentDisk = new Reference((Object)IndyInterface.bootstrap("invoke", "find", 0, specifiedDisks, new _validateInstanceTypeDisks_closure6(this, this)));
        public final class _validateInstanceTypeDisks_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference firstPersistentDisk;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateInstanceTypeDisks_closure7(Object _outerInstance, Object _thisObject, Reference firstPersistentDisk) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.firstPersistentDisk = reference = firstPersistentDisk;
            }

            public Object doCall(Object disk, Object index) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 0, disk, this.firstPersistentDisk.get())) != false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "sourceImage", 0, this.firstPersistentDisk.get())) != false) {
                        return IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), "disks", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), index}, new String[]{"", ".disk", ".sourceImage.unexpected"}), "The boot disk must not specify source image, it must be specified at the top-level on the request as `image`.");
                    }
                } else if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "persistent", 0, disk)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "sourceImage", 0, disk)) == false) {
                    return IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), "disks", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), index}, new String[]{"", ".disk", ".sourceImage.required"}), "All non-boot persistent disks are required to specify source image.");
                }
                return null;
            }

            @Generated
            public Object call(Object disk, Object index) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, disk, index);
            }

            @Generated
            public Object getFirstPersistentDisk() {
                return this.firstPersistentDisk.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "eachWithIndex", 0, specifiedDisks, new _validateInstanceTypeDisks_closure7(this, this, firstPersistentDisk));
        public final class _validateInstanceTypeDisks_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateInstanceTypeDisks_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, it), (Object)IndyInterface.bootstrap("getProperty", "LOCAL_SSD", 0, GoogleDiskType.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _validateInstanceTypeDisks_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instanceTypeDisk;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateInstanceTypeDisks_closure9(Object _outerInstance, Object _thisObject, Reference instanceTypeDisk) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.instanceTypeDisk = reference = instanceTypeDisk;
            }

            public Object doCall(Object localSSDDisk, Object index) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "supportsLocalSSD", 4, IndyInterface.bootstrap("cast", "()", 0, this.instanceTypeDisk.get()))) == false) {
                    IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), "disks", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), index}, new String[]{"", ".disk", ".type.localSSDUnsupported"}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "instanceType", 4, IndyInterface.bootstrap("cast", "()", 0, this.instanceTypeDisk.get()))}, new String[]{"Instance type ", " does not support Local SSD."}));
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "sizeGb", 0, localSSDDisk), (Object)375)) {
                    IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), "disks", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), index}, new String[]{"", ".disk", ".sizeGb.invalidSize"}), "Local SSD disks must be exactly 375GB.");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoDelete", 0, localSSDDisk)) == false) {
                    return IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), "disks", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), index}, new String[]{"", ".disk", ".autoDelete.required"}), "Local SSD disks must have auto-delete set.");
                }
                return null;
            }

            @Generated
            public Object call(Object localSSDDisk, Object index) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, localSSDDisk, index);
            }

            @Generated
            public GoogleInstanceTypeDisk getInstanceTypeDisk() {
                return IndyInterface.bootstrap("cast", "()", 0, this.instanceTypeDisk.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstanceTypeDisks_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("invoke", "eachWithIndex", 0, IndyInterface.bootstrap("invoke", "findAll", 0, specifiedDisks, new _validateInstanceTypeDisks_closure8(this, this)), new _validateInstanceTypeDisks_closure9(this, this, instanceTypeDisk2));
    }

    public Object validateAutoscalingPolicy(GoogleAutoscalingPolicy policy) {
        if (IndyInterface.bootstrap("cast", "()", 0, policy) != false) {
            public final class _validateAutoscalingPolicy_closure10
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _validateAutoscalingPolicy_closure10(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "minNumReplicas", 12, this), null)) {
                        IndyInterface.bootstrap("invoke", "validateNonNegativeLong", 2, this, IndyInterface.bootstrap("getProperty", "minNumReplicas", 12, this), "autoscalingPolicy.minNumReplicas");
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "maxNumReplicas", 12, this), null)) {
                        IndyInterface.bootstrap("invoke", "validateNonNegativeLong", 2, this, IndyInterface.bootstrap("getProperty", "maxNumReplicas", 12, this), "autoscalingPolicy.maxNumReplicas");
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "coolDownPeriodSec", 12, this), null)) {
                        IndyInterface.bootstrap("invoke", "validateNonNegativeLong", 2, this, IndyInterface.bootstrap("getProperty", "coolDownPeriodSec", 12, this), "autoscalingPolicy.coolDownPeriodSec");
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "minNumReplicas", 12, this), null) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "maxNumReplicas", 12, this), null)) {
                        IndyInterface.bootstrap("invoke", "validateMaxNotLessThanMin", 2, this, IndyInterface.bootstrap("getProperty", "minNumReplicas", 12, this), IndyInterface.bootstrap("getProperty", "maxNumReplicas", 12, this), "autoscalingPolicy.minNumReplicas", "autoscalingPolicy.maxNumReplicas");
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "cpuUtilization", 12, this), null)) {
                        public final class _closure13
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure13(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "utilizationTarget", 12, this), null)) {
                                    IndyInterface.bootstrap("invoke", "validateInRangeExclusive", 2, this, IndyInterface.bootstrap("getProperty", "utilizationTarget", 12, this), false, true, "autoscalingPolicy.cpuUtilization.utilizationTarget");
                                }
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "predictiveMethod", 12, this), null)) {
                                    return IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, IndyInterface.bootstrap("getProperty", "predictiveMethod", 12, this), "autoscalingPolicy.cpuUtilization.predictiveMethod");
                                }
                                return null;
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure13.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("getProperty", "cpuUtilization", 12, this), new _closure13((Object)this, this.getThisObject()));
                    }
                    public final class _closure14
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure14(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object utilization, Object index) {
                            Reference path = new Reference((Object)new GStringImpl(new Object[]{index}, new String[]{"autoscalingPolicy.customMetricUtilizations[", "]"}));
                            public final class _closure16
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference path;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure16(Object _outerInstance, Object _thisObject, Reference path) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.path = reference = path;
                                }

                                public Object doCall(Object it) {
                                    IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, IndyInterface.bootstrap("getProperty", "metric", 12, this), new GStringImpl(new Object[]{this.path.get()}, new String[]{"", ".metric"}));
                                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "utilizationTarget", 12, this), null)) {
                                        IndyInterface.bootstrap("invoke", "validateNotEmpty", 2, this, IndyInterface.bootstrap("getProperty", "utilizationTargetType", 12, this), new GStringImpl(new Object[]{this.path.get()}, new String[]{"", ".utilizationTargetType"}));
                                        if (ScriptBytecodeAdapter.compareLessThanEqual((Object)IndyInterface.bootstrap("getProperty", "utilizationTarget", 12, this), (Object)0)) {
                                            IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), this.path.get()}, new String[]{"", ".", ".utilizationTarget"}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), this.path.get()}, new String[]{"", ".", ".utilizationTarget must be greater than zero."}));
                                        }
                                    }
                                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "singleInstanceAssignment", 12, this), null) && ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("getProperty", "singleInstanceAssignment", 12, this), (Object)0)) {
                                        return IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), this.path.get()}, new String[]{"", ".", ".singleInstanceAssignment"}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 12, this), this.path.get()}, new String[]{"", ".", ".singleInstanceAssignment must be greater than zero."}));
                                    }
                                    return null;
                                }

                                @Generated
                                public Object getPath() {
                                    return this.path.get();
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure16.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            return IndyInterface.bootstrap("invoke", "with", 0, utilization, new _closure16((Object)this, this.getThisObject(), path));
                        }

                        @Generated
                        public Object call(Object utilization, Object index) {
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, utilization, index);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure14.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "eachWithIndex", 0, IndyInterface.bootstrap("getProperty", "customMetricUtilizations", 12, this), new _closure14((Object)this, this.getThisObject()));
                    public final class _closure15
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure15(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object scalingSchedule) {
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)scalingSchedule, null)) {
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "duration", 0, scalingSchedule), null)) {
                                    IndyInterface.bootstrap("invoke", "validateInRangeExclusive", 2, this, IndyInterface.bootstrap("getProperty", "duration", 0, scalingSchedule), 300, IndyInterface.bootstrap("getProperty", "MAX_VALUE", 0, Integer.class), "autoscalingPolicy.scalingSchedule.duration");
                                }
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "scheduleCron", 0, scalingSchedule), null)) {
                                    IndyInterface.bootstrap("invoke", "validateCronExpression", 2, this, IndyInterface.bootstrap("getProperty", "scheduleCron", 0, scalingSchedule), "autoscalingPolicy.scalingSchedule.scheduleCron");
                                }
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "timezone", 0, scalingSchedule), null)) {
                                    return IndyInterface.bootstrap("invoke", "validateTimeZone", 2, this, IndyInterface.bootstrap("getProperty", "timezone", 0, scalingSchedule), "autoscalingPolicy.scalingSchedule.timezone");
                                }
                            }
                            return null;
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure15.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "scalingSchedules", 12, this), new _closure15((Object)this, this.getThisObject()));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "loadBalancingUtilization", 12, this), null) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "utilizationTarget", 0, IndyInterface.bootstrap("getProperty", "loadBalancingUtilization", 12, this)))) {
                        return IndyInterface.bootstrap("invoke", "validateInRangeExclusive", 2, this, IndyInterface.bootstrap("getProperty", "utilizationTarget", 0, IndyInterface.bootstrap("getProperty", "loadBalancingUtilization", 12, this)), false, true, "autoscalingPolicy.loadBalancingUtilization.utilizationTarget");
                    }
                    return null;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _validateAutoscalingPolicy_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return IndyInterface.bootstrap("invoke", "with", 0, policy, new _validateAutoscalingPolicy_closure10(this, this));
        }
        return null;
    }

    public Object validateAutoHealingPolicy(GoogleAutoHealingPolicy policy, boolean rejectEmptyMaxUnavailable) {
        Reference rejectEmptyMaxUnavailable2 = new Reference((Object)rejectEmptyMaxUnavailable);
        public final class _validateAutoHealingPolicy_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference rejectEmptyMaxUnavailable;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateAutoHealingPolicy_closure11(Object _outerInstance, Object _thisObject, Reference rejectEmptyMaxUnavailable) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.rejectEmptyMaxUnavailable = reference = rejectEmptyMaxUnavailable;
            }

            public Object doCall(Object it) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "initialDelaySec", 12, this), null)) {
                    IndyInterface.bootstrap("invoke", "validateNonNegativeLong", 2, this, IndyInterface.bootstrap("getProperty", "initialDelaySec", 12, this), "autoHealingPolicy.initialDelaySec");
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "healthCheck", 12, this), null)) {
                    IndyInterface.bootstrap("invoke", "validateName", 2, this, IndyInterface.bootstrap("getProperty", "healthCheck", 12, this), "autoHealingPolicy.healthCheck");
                    public final class _closure17
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference rejectEmptyMaxUnavailable;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure17(Object _outerInstance, Object _thisObject, Reference rejectEmptyMaxUnavailable) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.rejectEmptyMaxUnavailable = reference = rejectEmptyMaxUnavailable;
                        }

                        public Object doCall(Object it) {
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "fixed", 12, this), null)) {
                                return IndyInterface.bootstrap("invoke", "validateNonNegativeLong", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "fixed", 12, this), Integer.class))), Integer.TYPE), "autoHealingPolicy.maxUnavailable.fixed");
                            }
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "percent", 12, this), null)) {
                                return IndyInterface.bootstrap("invoke", "validateInRangeInclusive", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "percent", 12, this), Integer.class))), Integer.TYPE), false, 100, "autoHealingPolicy.maxUnavailable.percent");
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.rejectEmptyMaxUnavailable.get())) != false) {
                                return IndyInterface.bootstrap("invoke", "rejectValue", 0, IndyInterface.bootstrap("getProperty", "errors", 4, this.getThisObject()), "autoHealingPolicy.maxUnavailable", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "context", 4, this.getThisObject())}, new String[]{"", ".autoHealingPolicy.maxUnavailable.neitherFixedNorPercent"}));
                            }
                            return null;
                        }

                        @Generated
                        public boolean getRejectEmptyMaxUnavailable() {
                            return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("cast", "()", 0, this.rejectEmptyMaxUnavailable.get()));
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure17.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "with", 1, IndyInterface.bootstrap("getProperty", "maxUnavailable", 12, this), new _closure17((Object)this, this.getThisObject(), this.rejectEmptyMaxUnavailable));
                }
                return null;
            }

            @Generated
            public boolean getRejectEmptyMaxUnavailable() {
                return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("cast", "()", 0, this.rejectEmptyMaxUnavailable.get()));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateAutoHealingPolicy_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("invoke", "with", 1, policy, new _validateAutoHealingPolicy_closure11(this, this, rejectEmptyMaxUnavailable2));
    }

    public Object validateTags(List<String> tags) {
        return IndyInterface.bootstrap("invoke", "validateOptionalNameList", 2, this, tags, "tag");
    }

    public Object validateMap(Map<String, String> mappings, String componentDescription) {
        Reference componentDescription2 = new Reference((Object)componentDescription);
        if (ScriptBytecodeAdapter.compareEqual(mappings, null)) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, new GStringImpl(new Object[]{(String)componentDescription2.get()}, new String[]{"", "s"}), new GStringImpl(new Object[]{this.context, (String)componentDescription2.get()}, new String[]{"", ".", "s.empty"}));
            return false;
        }
        Reference result = new Reference((Object)true);
        public final class _validateMap_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private /* synthetic */ Reference componentDescription;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateMap_closure12(Object _outerInstance, Object _thisObject, Reference result, Reference componentDescription) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.result = reference2 = result;
                this.componentDescription = reference = componentDescription;
            }

            public Object doCall(Object key, Object value) {
                this.result.set((Object)IndyInterface.bootstrap("invoke", "and", 0, this.result.get(), IndyInterface.bootstrap("invoke", "validateNameAsPart", 2, this, key, new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.componentDescription.get())}, new String[]{"", "s"}), new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.componentDescription.get())}, new String[]{"", "s.key"}))));
                if (IndyInterface.bootstrap("cast", "()", 0, value) != false) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "and", 0, this.result.get(), IndyInterface.bootstrap("invoke", "validateNameAsPart", 2, this, value, new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.componentDescription.get())}, new String[]{"", "s"}), new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.componentDescription.get()), key}, new String[]{"", ".", ".value"})));
                    this.result.set((Object)callSite);
                    return callSite;
                }
                return null;
            }

            @Generated
            public Object call(Object key, Object value) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, key, value);
            }

            @Generated
            public Object getResult() {
                return this.result.get();
            }

            @Generated
            public String getComponentDescription() {
                return IndyInterface.bootstrap("cast", "()", 0, this.componentDescription.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateMap_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, mappings, new _validateMap_closure12(this, this, result, componentDescription2));
        return result.get();
    }

    public Object validateAuthScopes(List<String> authScopes) {
        return IndyInterface.bootstrap("invoke", "validateOptionalNameList", 2, this, authScopes, "authScope");
    }

    public Object validateCronExpression(String expression, String attribute) {
        CallSite result = IndyInterface.bootstrap("invoke", "isValidExpression", 0, CronSequenceGenerator.class, IndyInterface.bootstrap("invoke", "plus", 0, "* ", expression));
        if (IndyInterface.bootstrap("cast", "()", 0, result) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, attribute, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", " must be a valid CRON expression."}));
        }
        return result;
    }

    public Object validateTimeZone(String timeZone, String attribute) {
        Object result = true;
        try {
            result = IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "of", 0, Set.class, IndyInterface.bootstrap("invoke", "getAvailableIDs", 0, TimeZone.class)), timeZone);
        }
        catch (Exception e) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, this.errors, attribute, new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", " must be a time zone name from the tz database."}));
            result = false;
        }
        return result;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StandardGceAttributeValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public Object validateAutoHealingPolicy(GoogleAutoHealingPolicy policy) {
        return this.validateAutoHealingPolicy(policy, true);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        $const$0 = bigDecimal = new BigDecimal("0.5");
    }

    static {
        StandardGceAttributeValidator.__$swapInit();
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public void setContext(String string) {
        this.context = string;
    }

    @Generated
    public ValidationErrors getErrors() {
        return this.errors;
    }

    @Generated
    public void setErrors(ValidationErrors validationErrors) {
        this.errors = validationErrors;
    }

    @Generated
    public Object getCustomInstanceRegExp() {
        return this.customInstanceRegExp;
    }

    @Generated
    public void setCustomInstanceRegExp(Object object) {
        this.customInstanceRegExp = object;
    }
}

