/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.names;

import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.google.model.GoogleLabeledResource;
import com.netflix.spinnaker.clouddriver.names.NamingStrategy;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class GoogleLabeledResourceNamer
implements NamingStrategy<GoogleLabeledResource> {
    static String GCE_MONIKER_PREFIX = "spinnaker-moniker-";
    static String APP = GCE_MONIKER_PREFIX + "application";
    static String CLUSTER = GCE_MONIKER_PREFIX + "cluster";
    static String DETAIL = GCE_MONIKER_PREFIX + "detail";
    static String STACK = GCE_MONIKER_PREFIX + "stack";
    static String SEQUENCE = GCE_MONIKER_PREFIX + "sequence";

    public String getName() {
        return "gceAnnotations";
    }

    public void applyMoniker(GoogleLabeledResource labeledResource, Moniker moniker) {
        Map<String, String> templateLabels = labeledResource.getLabels();
        GoogleLabeledResourceNamer.setIfPresent(value -> templateLabels.putIfAbsent(APP, value.toLowerCase()), moniker.getApp());
        GoogleLabeledResourceNamer.setIfPresent(value -> templateLabels.putIfAbsent(CLUSTER, value.toLowerCase()), moniker.getCluster());
        GoogleLabeledResourceNamer.setIfPresent(value -> templateLabels.putIfAbsent(DETAIL, value.toLowerCase()), moniker.getDetail());
        GoogleLabeledResourceNamer.setIfPresent(value -> templateLabels.putIfAbsent(STACK, value.toLowerCase()), moniker.getStack());
        GoogleLabeledResourceNamer.setIfPresent(value -> templateLabels.put(SEQUENCE, (String)value), moniker.getSequence() != null ? moniker.getSequence().toString() : null);
    }

    public Moniker deriveMoniker(GoogleLabeledResource labeledResource) {
        String name = labeledResource.getName();
        Names parsed = Names.parseName((String)name);
        Moniker moniker = Moniker.builder().app(parsed.getApp()).cluster(parsed.getCluster()).detail(parsed.getDetail()).stack(parsed.getStack()).sequence(parsed.getSequence()).build();
        Map<String, String> labels = labeledResource.getLabels();
        if (moniker.getApp() != null && labels != null) {
            GoogleLabeledResourceNamer.setIfPresent(arg_0 -> ((Moniker)moniker).setApp(arg_0), labels.get(APP));
            String cluster = labels.get(CLUSTER);
            String stack = labels.get(STACK);
            String detail = labels.get(DETAIL);
            String sequence = labels.get(SEQUENCE);
            if (cluster == null && (detail != null || stack != null)) {
                cluster = GoogleLabeledResourceNamer.getClusterName(moniker.getApp(), stack, detail);
            }
            GoogleLabeledResourceNamer.setIfPresent(arg_0 -> ((Moniker)moniker).setStack(arg_0), stack);
            GoogleLabeledResourceNamer.setIfPresent(arg_0 -> ((Moniker)moniker).setDetail(arg_0), detail);
            GoogleLabeledResourceNamer.setIfPresent(arg_0 -> ((Moniker)moniker).setCluster(arg_0), cluster);
            GoogleLabeledResourceNamer.setIfPresent(arg_0 -> ((Moniker)moniker).setSequence(arg_0), sequence != null ? Integer.valueOf(Integer.parseInt(sequence)) : null);
        }
        return moniker;
    }

    private static String getClusterName(String app, String stack, String detail) {
        StringBuilder sb = new StringBuilder(app);
        if (StringUtils.isNotEmpty((CharSequence)stack)) {
            sb.append("-").append(stack);
        }
        if (StringUtils.isEmpty((CharSequence)stack) && StringUtils.isNotEmpty((CharSequence)detail)) {
            sb.append("-");
        }
        if (StringUtils.isNotEmpty((CharSequence)detail)) {
            sb.append("-").append(detail);
        }
        return sb.toString();
    }

    private static <T> void setIfPresent(Consumer<T> setter, T value) {
        if (value != null) {
            setter.accept(value);
        }
    }
}

