/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleHealthCheck;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.model.health.GoogleLoadBalancerHealth;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancerType;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancerView;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleNetworkLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSslLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTcpLoadBalancer;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerInstance;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerServerGroup;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoogleLoadBalancerProvider
implements LoadBalancerProvider<GoogleLoadBalancerView>,
GroovyObject {
    private final String cloudProvider;
    @Autowired
    private Cache cacheView;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private AccountCredentialsProvider accountCredentialsProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public GoogleLoadBalancerProvider() {
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Set<GoogleLoadBalancerView> getApplicationLoadBalancers(String application) {
        CallSite pattern = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, "*", "*", new GStringImpl(new Object[]{application}, new String[]{"", "*"})));
        Reference identifiers = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toSet", 0, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class)), pattern))));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isNullOrEmpty", 0, Strings.class, application)) == false) {
            CallSite applicationServerGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class), application}, new String[]{"", ":*:", "-*"}))));
            public final class _getApplicationLoadBalancers_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference identifiers;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getApplicationLoadBalancers_closure1(Object _outerInstance, Object _thisObject, Reference identifiers) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.identifiers = reference = identifiers;
                }

                public Object doCall(CacheData serverGroup) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, serverGroup), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class)));
                    CallSite relatedLoadBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                    public final class _closure10
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference identifiers;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure10(Object _outerInstance, Object _thisObject, Reference identifiers) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.identifiers = reference = identifiers;
                        }

                        public Object doCall(String lb) {
                            return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.identifiers.get()), lb);
                        }

                        @Generated
                        public Object call(String lb) {
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, lb);
                        }

                        @Generated
                        public Set getIdentifiers() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.identifiers.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure10.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "each", 0, relatedLoadBalancers, new _closure10((Object)this, this.getThisObject(), this.identifiers));
                }

                @Generated
                public Object call(CacheData serverGroup) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, serverGroup);
                }

                @Generated
                public Set getIdentifiers() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.identifiers.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getApplicationLoadBalancers_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, applicationServerGroups, new _getApplicationLoadBalancers_closure1(this, this, identifiers));
        }
        public final class _getApplicationLoadBalancers_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getApplicationLoadBalancers_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(CacheData loadBalancerCacheData) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", "relationships", 1, loadBalancerCacheData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Keys.Namespace.class)));
                return IndyInterface.bootstrap("invoke", "loadBalancersFromCacheData", 2, this, loadBalancerCacheData, ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class))), Set.class));
            }

            @Generated
            public Object call(CacheData loadBalancerCacheData) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, loadBalancerCacheData);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getApplicationLoadBalancers_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class)), (Set)identifiers.get(), IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Keys.Namespace.class)))), new _getApplicationLoadBalancers_closure2(this, this)), Set.class));
    }

    public GoogleLoadBalancerView loadBalancersFromCacheData(CacheData loadBalancerCacheData, Set<String> allApplicationInstanceKeys) {
        Reference allApplicationInstanceKeys2 = new Reference(allApplicationInstanceKeys);
        Reference loadBalancer = new Reference(null);
        CallSite callSite = IndyInterface.bootstrap("invoke", "valueOf", 0, GoogleLoadBalancerType.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "type", 1, IndyInterface.bootstrap("getProperty", "attributes", 0, loadBalancerCacheData)), String.class))), String.class));
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "INTERNAL", 0, GoogleLoadBalancerType.class))) {
            loadBalancer.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, loadBalancerCacheData), GoogleInternalLoadBalancer.class)));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "INTERNAL_MANAGED", 0, GoogleLoadBalancerType.class))) {
            loadBalancer.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, loadBalancerCacheData), GoogleInternalHttpLoadBalancer.class)));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "HTTP", 0, GoogleLoadBalancerType.class))) {
            loadBalancer.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, loadBalancerCacheData), GoogleHttpLoadBalancer.class)));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "NETWORK", 0, GoogleLoadBalancerType.class))) {
            loadBalancer.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, loadBalancerCacheData), GoogleNetworkLoadBalancer.class)));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "SSL", 0, GoogleLoadBalancerType.class))) {
            loadBalancer.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, loadBalancerCacheData), GoogleSslLoadBalancer.class)));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "TCP", 0, GoogleLoadBalancerType.class))) {
            loadBalancer.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, loadBalancerCacheData), GoogleTcpLoadBalancer.class)));
        } else {
            loadBalancer.set((Object)IndyInterface.bootstrap("cast", "()", 0, null));
        }
        Reference loadBalancerView = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "view", 5, (GoogleLoadBalancer)loadBalancer.get())));
        CallSite serverGroupKeys = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 1, loadBalancerCacheData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)));
        if (IndyInterface.bootstrap("cast", "()", 0, serverGroupKeys) == false) {
            return (GoogleLoadBalancerView)loadBalancerView.get();
        }
        public final class _loadBalancersFromCacheData_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference allApplicationInstanceKeys;
            private /* synthetic */ Reference loadBalancerView;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadBalancersFromCacheData_closure3(Object _outerInstance, Object _thisObject, Reference loadBalancer, Reference allApplicationInstanceKeys, Reference loadBalancerView) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.loadBalancer = reference3 = loadBalancer;
                this.allApplicationInstanceKeys = reference2 = allApplicationInstanceKeys;
                this.loadBalancerView = reference = loadBalancerView;
            }

            public Object doCall(CacheData serverGroupCacheData) {
                if (IndyInterface.bootstrap("cast", "()", 0, serverGroupCacheData) == false) {
                    return null;
                }
                CallSite serverGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "attributes", 0, serverGroupCacheData), GoogleServerGroup.class));
                Object isDisabled = false;
                CallSite callSite = IndyInterface.bootstrap("getProperty", "type", 4, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()));
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "HTTP", 0, GoogleLoadBalancerType.class))) {
                    CallSite isDisabledFromHttp = IndyInterface.bootstrap("invoke", "determineHttpLoadBalancerDisabledState", 0, Utils.class, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()), serverGroup);
                    isDisabled = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "asg", 4, serverGroup), IndyInterface.bootstrap("getProperty", "REGIONAL_LOAD_BALANCER_NAMES", 0, GCEUtil.class))) != false ? Boolean.valueOf(DefaultTypeTransformation.booleanUnbox((Object)isDisabledFromHttp) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "disabled", 4, serverGroup))) : isDisabledFromHttp);
                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "INTERNAL", 0, GoogleLoadBalancerType.class))) {
                    isDisabled = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "determineInternalLoadBalancerDisabledState", 0, Utils.class, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()), serverGroup));
                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "INTERNAL_MANAGED", 0, GoogleLoadBalancerType.class))) {
                    isDisabled = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "determineInternalHttpLoadBalancerDisabledState", 0, Utils.class, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()), serverGroup));
                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "NETWORK", 0, GoogleLoadBalancerType.class))) {
                    isDisabled = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "disabled", 4, serverGroup));
                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "SSL", 0, GoogleLoadBalancerType.class))) {
                    CallSite isDisabledFromSsl = IndyInterface.bootstrap("invoke", "determineSslLoadBalancerDisabledState", 0, Utils.class, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()), serverGroup);
                    isDisabled = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "asg", 4, serverGroup), IndyInterface.bootstrap("getProperty", "REGIONAL_LOAD_BALANCER_NAMES", 0, GCEUtil.class))) != false ? Boolean.valueOf(DefaultTypeTransformation.booleanUnbox((Object)isDisabledFromSsl) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "disabled", 4, serverGroup))) : isDisabledFromSsl);
                } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "TCP", 0, GoogleLoadBalancerType.class))) {
                    CallSite isDisabledFromTcp = IndyInterface.bootstrap("invoke", "determineTcpLoadBalancerDisabledState", 0, Utils.class, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()), serverGroup);
                    isDisabled = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "asg", 4, serverGroup), IndyInterface.bootstrap("getProperty", "REGIONAL_LOAD_BALANCER_NAMES", 0, GCEUtil.class))) != false ? Boolean.valueOf(DefaultTypeTransformation.booleanUnbox((Object)isDisabledFromTcp) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "disabled", 4, serverGroup))) : isDisabledFromTcp);
                } else {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "type", 4, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())), IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()))}, new String[]{"Illegal type ", " for load balancer ", ""})));
                }
                Reference loadBalancerServerGroup = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerServerGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "name", 4, serverGroup), "region", IndyInterface.bootstrap("getProperty", "region", 4, serverGroup), "isDisabled", isDisabled, "detachedInstances", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "instances", ScriptBytecodeAdapter.createList((Object[])new Object[0]), "cloudProvider", IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class)})));
                Reference serverGroupInstancePattern = new Reference((Object)IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "account", 4, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())), IndyInterface.bootstrap("getProperty", "region", 4, serverGroup), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, serverGroup)}, new String[]{"", "-.*"})));
                public final class _closure11
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroupInstancePattern;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure11(Object _outerInstance, Object _thisObject, Reference serverGroupInstancePattern) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.serverGroupInstancePattern = reference = serverGroupInstancePattern;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.matchRegex((Object)it, (Object)this.serverGroupInstancePattern.get());
                    }

                    @Generated
                    public Object getServerGroupInstancePattern() {
                        return this.serverGroupInstancePattern.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite instanceKeys = IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("cast", "()", 0, this.allApplicationInstanceKeys.get()), new _closure11((Object)this, this.getThisObject(), serverGroupInstancePattern));
                public final class _closure12
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure12(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("getProperty", "name", 1, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, it));
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference instanceNames = new Reference((Object)IndyInterface.bootstrap("invoke", "collect", 0, instanceKeys, new _closure12((Object)this, this.getThisObject())));
                public final class _closure13
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instanceNames;
                    private /* synthetic */ Reference loadBalancerServerGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure13(Object _outerInstance, Object _thisObject, Reference instanceNames, Reference loadBalancerServerGroup) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.instanceNames = reference2 = instanceNames;
                        this.loadBalancerServerGroup = reference = loadBalancerServerGroup;
                    }

                    public Object doCall(GoogleLoadBalancerHealth googleLoadBalancerHealth) {
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "remove", 0, this.instanceNames.get(), IndyInterface.bootstrap("getProperty", "instanceName", 4, googleLoadBalancerHealth))) == false) {
                            return null;
                        }
                        return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "instances", 0, this.loadBalancerServerGroup.get()), IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerInstance.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", IndyInterface.bootstrap("getProperty", "instanceName", 4, googleLoadBalancerHealth), "zone", IndyInterface.bootstrap("getProperty", "instanceZone", 4, googleLoadBalancerHealth), "health", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"state", (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "state", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "lbHealthSummaries", 4, googleLoadBalancerHealth), false)), String.class)), "description", IndyInterface.bootstrap("getProperty", "description", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "lbHealthSummaries", 4, googleLoadBalancerHealth), false))})})));
                    }

                    @Generated
                    public Object call(GoogleLoadBalancerHealth googleLoadBalancerHealth) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, googleLoadBalancerHealth);
                    }

                    @Generated
                    public Object getInstanceNames() {
                        return this.instanceNames.get();
                    }

                    @Generated
                    public Object getLoadBalancerServerGroup() {
                        return this.loadBalancerServerGroup.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure13.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "healths", 4, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())), new _closure13((Object)this, this.getThisObject(), instanceNames, loadBalancerServerGroup));
                Object object = instanceNames.get();
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)loadBalancerServerGroup.get(), (String)"detachedInstances");
                return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "serverGroups", 4, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerView.get())), loadBalancerServerGroup.get());
            }

            @Generated
            public Object call(CacheData serverGroupCacheData) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, serverGroupCacheData);
            }

            @Generated
            public GoogleLoadBalancer getLoadBalancer() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
            }

            @Generated
            public Set getAllApplicationInstanceKeys() {
                return IndyInterface.bootstrap("cast", "()", 0, this.allApplicationInstanceKeys.get());
            }

            @Generated
            public GoogleLoadBalancerView getLoadBalancerView() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerView.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadBalancersFromCacheData_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), serverGroupKeys), new _loadBalancersFromCacheData_closure3(this, this, loadBalancer, allApplicationInstanceKeys2, loadBalancerView));
        return (GoogleLoadBalancerView)loadBalancerView.get();
    }

    public List<GoogleLoadBalancerAccountRegionSummary> list() {
        public final class _list_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _list_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "name", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _list_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite loadBalancerViewsByName = IndyInterface.bootstrap("invoke", "groupBy", 0, IndyInterface.bootstrap("invoke", "getApplicationLoadBalancers", 2, this, ""), new _list_closure4(this, this));
        public final class _list_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _list_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String name, List<GoogleLoadBalancerView> views) {
                Reference summary = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleLoadBalancerAccountRegionSummary.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name})));
                public final class _closure14
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference summary;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure14(Object _outerInstance, Object _thisObject, Reference summary) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.summary = reference = summary;
                    }

                    public Object doCall(GoogleLoadBalancerView view) {
                        CallSite loadBalancerType = IndyInterface.bootstrap("getProperty", "loadBalancerType", 4, view);
                        Object backendServices = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                        CallSite urlMapName = null;
                        CallSite callSite = loadBalancerType;
                        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "HTTP", 0, GoogleLoadBalancerType.class))) {
                            GoogleHttpLoadBalancer.View httpView = (GoogleHttpLoadBalancer.View)((Object)IndyInterface.bootstrap("invoke", "asType", 0, view, GoogleHttpLoadBalancer.View.class));
                            public final class _closure15
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure15(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    return IndyInterface.bootstrap("getProperty", "name", 0, it);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure15.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            backendServices = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getBackendServicesFromHttpLoadBalancerView", 0, Utils.class, httpView), new _closure15((Object)this, this.getThisObject()));
                            urlMapName = IndyInterface.bootstrap("getProperty", "urlMapName", 4, httpView);
                        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "INTERNAL_MANAGED", 0, GoogleLoadBalancerType.class))) {
                            GoogleInternalHttpLoadBalancer.InternalHttpLbView httpView = (GoogleInternalHttpLoadBalancer.InternalHttpLbView)((Object)IndyInterface.bootstrap("invoke", "asType", 0, view, GoogleInternalHttpLoadBalancer.InternalHttpLbView.class));
                            public final class _closure16
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure16(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    return IndyInterface.bootstrap("getProperty", "name", 0, it);
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure16.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            backendServices = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getBackendServicesFromInternalHttpLoadBalancerView", 0, Utils.class, httpView), new _closure16((Object)this, this.getThisObject()));
                            urlMapName = IndyInterface.bootstrap("getProperty", "urlMapName", 4, httpView);
                        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "INTERNAL", 0, GoogleLoadBalancerType.class))) {
                            GoogleInternalLoadBalancer.View ilbView = (GoogleInternalLoadBalancer.View)((Object)IndyInterface.bootstrap("invoke", "asType", 0, view, GoogleInternalLoadBalancer.View.class));
                            IndyInterface.bootstrap("invoke", "leftShift", 0, backendServices, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "backendService", 4, ilbView)));
                        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "SSL", 0, GoogleLoadBalancerType.class))) {
                            GoogleSslLoadBalancer.View sslView = (GoogleSslLoadBalancer.View)((Object)IndyInterface.bootstrap("invoke", "asType", 0, view, GoogleSslLoadBalancer.View.class));
                            IndyInterface.bootstrap("invoke", "leftShift", 0, backendServices, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "backendService", 4, sslView)));
                        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "TCP", 0, GoogleLoadBalancerType.class))) {
                            GoogleTcpLoadBalancer.View tcpView = (GoogleTcpLoadBalancer.View)((Object)IndyInterface.bootstrap("invoke", "asType", 0, view, GoogleTcpLoadBalancer.View.class));
                            IndyInterface.bootstrap("invoke", "leftShift", 0, backendServices, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "backendService", 4, tcpView)));
                        }
                        Object[] objectArray = new Object[12];
                        objectArray[0] = "account";
                        objectArray[1] = IndyInterface.bootstrap("getProperty", "account", 4, view);
                        objectArray[2] = "region";
                        objectArray[3] = IndyInterface.bootstrap("getProperty", "region", 4, view);
                        objectArray[4] = "name";
                        objectArray[5] = IndyInterface.bootstrap("getProperty", "name", 4, view);
                        objectArray[6] = "loadBalancerType";
                        objectArray[7] = loadBalancerType;
                        objectArray[8] = "backendServices";
                        List list = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "unique", 0, backendServices), List.class));
                        objectArray[9] = IndyInterface.bootstrap("cast", "()", 0, list) != false ? list : null;
                        objectArray[10] = "urlMapName";
                        objectArray[11] = urlMapName;
                        return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "mappedRegions", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "mappedAccounts", 0, this.summary.get()), IndyInterface.bootstrap("getProperty", "account", 4, view))), IndyInterface.bootstrap("getProperty", "region", 4, view))), IndyInterface.bootstrap("init", "<init>", 0, GoogleLoadBalancerSummary.class, ScriptBytecodeAdapter.createMap((Object[])objectArray)));
                    }

                    @Generated
                    public Object call(GoogleLoadBalancerView view) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, view);
                    }

                    @Generated
                    public Object getSummary() {
                        return this.summary.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure14.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, views, new _closure14((Object)this, this.getThisObject(), summary));
                return summary.get();
            }

            @Generated
            public Object call(String name, List<GoogleLoadBalancerView> views) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, name, views);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _list_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, loadBalancerViewsByName, new _list_closure5(this, this)));
    }

    public GoogleLoadBalancerAccountRegionSummary get(String name) {
        Reference name2 = new Reference((Object)name);
        public final class _get_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _get_closure6(Object _outerInstance, Object _thisObject, Reference name) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.name = reference = name;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.name.get()));
            }

            @Generated
            public String getName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _get_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("invoke", "list", 2, this), new _get_closure6(this, this, name2)));
    }

    /*
     * WARNING - void declaration
     */
    public List<GoogleLoadBalancerDetails> byAccountAndRegionAndName(String account, String region, String name) {
        void var2_2;
        Reference account2 = new Reference((Object)account);
        Reference region2 = new Reference((Object)var2_2);
        public final class _byAccountAndRegionAndName_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference region;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _byAccountAndRegionAndName_closure7(Object _outerInstance, Object _thisObject, Reference account, Reference region) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.account = reference2 = account;
                this.region = reference = region;
            }

            public Object doCall(Object view) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "account", 0, view), (Object)IndyInterface.bootstrap("cast", "()", 0, this.account.get())) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "region", 0, view), (Object)IndyInterface.bootstrap("cast", "()", 0, this.region.get()));
            }

            @Generated
            public String getAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.account.get());
            }

            @Generated
            public String getRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _byAccountAndRegionAndName_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite view = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("invoke", "getApplicationLoadBalancers", 2, this, name), new _byAccountAndRegionAndName_closure7(this, this, account2, region2)));
        if (IndyInterface.bootstrap("cast", "()", 0, view) == false) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        Object backendServiceHealthChecks = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object instancePort = null;
        CallSite loadBalancerPort = null;
        CallSite sessionAffinity = null;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "loadBalancerType", 4, view);
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "NETWORK", 0, GoogleLoadBalancerType.class))) {
            GoogleNetworkLoadBalancer.View nlbView = (GoogleNetworkLoadBalancer.View)((Object)IndyInterface.bootstrap("invoke", "asType", 0, view, GoogleNetworkLoadBalancer.View.class));
            sessionAffinity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "sessionAffinity", 4, nlbView));
            instancePort = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "derivePortOrPortRange", 0, Utils.class, IndyInterface.bootstrap("getProperty", "portRange", 4, view)));
            loadBalancerPort = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "derivePortOrPortRange", 0, Utils.class, IndyInterface.bootstrap("getProperty", "portRange", 4, view)));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "HTTP", 0, GoogleLoadBalancerType.class))) {
            instancePort = "http";
            loadBalancerPort = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "derivePortOrPortRange", 0, Utils.class, IndyInterface.bootstrap("getProperty", "portRange", 4, view)));
            GoogleHttpLoadBalancer.View httpView = (GoogleHttpLoadBalancer.View)((Object)IndyInterface.bootstrap("invoke", "asType", 0, view, GoogleHttpLoadBalancer.View.class));
            CallSite backendServices = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getBackendServicesFromHttpLoadBalancerView", 0, Utils.class, httpView));
            public final class _byAccountAndRegionAndName_closure8
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _byAccountAndRegionAndName_closure8(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, it), IndyInterface.bootstrap("getProperty", "view", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 0, it))});
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _byAccountAndRegionAndName_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            backendServiceHealthChecks = IndyInterface.bootstrap("invoke", "collectEntries", 0, backendServices, new _byAccountAndRegionAndName_closure8(this, this));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "INTERNAL_MANAGED", 0, GoogleLoadBalancerType.class))) {
            instancePort = "http";
            loadBalancerPort = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "derivePortOrPortRange", 0, Utils.class, IndyInterface.bootstrap("getProperty", "portRange", 4, view)));
            GoogleInternalHttpLoadBalancer.InternalHttpLbView httpView = (GoogleInternalHttpLoadBalancer.InternalHttpLbView)((Object)IndyInterface.bootstrap("invoke", "asType", 0, view, GoogleInternalHttpLoadBalancer.InternalHttpLbView.class));
            CallSite backendServices = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getBackendServicesFromInternalHttpLoadBalancerView", 0, Utils.class, httpView));
            public final class _byAccountAndRegionAndName_closure9
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _byAccountAndRegionAndName_closure9(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, it), IndyInterface.bootstrap("getProperty", "view", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 0, it))});
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _byAccountAndRegionAndName_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            backendServiceHealthChecks = IndyInterface.bootstrap("invoke", "collectEntries", 0, backendServices, new _byAccountAndRegionAndName_closure9(this, this));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "INTERNAL", 0, GoogleLoadBalancerType.class))) {
            GoogleInternalLoadBalancer.View ilbView = (GoogleInternalLoadBalancer.View)((Object)IndyInterface.bootstrap("invoke", "asType", 0, view, GoogleInternalLoadBalancer.View.class));
            CallSite portString = IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("getProperty", "ports", 4, ilbView), ",");
            instancePort = IndyInterface.bootstrap("cast", "()", 0, portString);
            loadBalancerPort = IndyInterface.bootstrap("cast", "()", 0, portString);
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "SSL", 0, GoogleLoadBalancerType.class))) {
            instancePort = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "derivePortOrPortRange", 0, Utils.class, IndyInterface.bootstrap("getProperty", "portRange", 4, view)));
            loadBalancerPort = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "derivePortOrPortRange", 0, Utils.class, IndyInterface.bootstrap("getProperty", "portRange", 4, view)));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "TCP", 0, GoogleLoadBalancerType.class))) {
            instancePort = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "derivePortOrPortRange", 0, Utils.class, IndyInterface.bootstrap("getProperty", "portRange", 4, view)));
            loadBalancerPort = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "derivePortOrPortRange", 0, Utils.class, IndyInterface.bootstrap("getProperty", "portRange", 4, view)));
        } else {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, view)}, new String[]{"Load balancer ", " is an unknown load balancer type."})));
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[18];
        objectArray2[0] = "loadBalancerName";
        objectArray2[1] = IndyInterface.bootstrap("getProperty", "name", 4, view);
        objectArray2[2] = "loadBalancerType";
        objectArray2[3] = IndyInterface.bootstrap("getProperty", "loadBalancerType", 4, view);
        objectArray2[4] = "createdTime";
        objectArray2[5] = IndyInterface.bootstrap("getProperty", "createdTime", 4, view);
        objectArray2[6] = "dnsname";
        objectArray2[7] = IndyInterface.bootstrap("getProperty", "ipAddress", 4, view);
        objectArray2[8] = "ipAddress";
        objectArray2[9] = IndyInterface.bootstrap("getProperty", "ipAddress", 4, view);
        objectArray2[10] = "sessionAffinity";
        objectArray2[11] = sessionAffinity;
        objectArray2[12] = "healthCheck";
        objectArray2[13] = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "hasProperty", 0, view, "healthCheck")) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "healthCheck", 4, view)) ? IndyInterface.bootstrap("getProperty", "healthCheck", 4, view) : null;
        objectArray2[14] = "backendServiceHealthChecks";
        Object object = backendServiceHealthChecks;
        objectArray2[15] = IndyInterface.bootstrap("cast", "()", 0, object) != false ? object : null;
        objectArray2[16] = "listenerDescriptions";
        objectArray2[17] = ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.createMap((Object[])new Object[]{"listener", IndyInterface.bootstrap("init", "<init>", 0, ListenerDescription.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instancePort", instancePort, "loadBalancerPort", loadBalancerPort, "instanceProtocol", IndyInterface.bootstrap("getProperty", "ipProtocol", 4, view), "protocol", IndyInterface.bootstrap("getProperty", "ipProtocol", 4, view)}))})});
        objectArray[0] = IndyInterface.bootstrap("init", "<init>", 0, GoogleLoadBalancerDetails.class, ScriptBytecodeAdapter.createMap((Object[])objectArray2));
        return ScriptBytecodeAdapter.createList((Object[])objectArray);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleLoadBalancerProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleLoadBalancerProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleLoadBalancerProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleLoadBalancerProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ @VisibleForTesting void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GoogleLoadBalancerProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GoogleLoadBalancerProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    @Generated
    public Cache getCacheView() {
        return this.cacheView;
    }

    @Generated
    public @VisibleForTesting void setCacheView(Cache cache) {
        this.cacheView = cache;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public @VisibleForTesting void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public AccountCredentialsProvider getAccountCredentialsProvider() {
        return this.accountCredentialsProvider;
    }

    @Generated
    public @VisibleForTesting void setAccountCredentialsProvider(AccountCredentialsProvider accountCredentialsProvider) {
        this.accountCredentialsProvider = accountCredentialsProvider;
    }

    public static class GoogleLoadBalancerAccountRegionSummary
    implements LoadBalancerProvider.Item,
    GroovyObject {
        private String name;
        @JsonIgnore
        private Map<String, GoogleLoadBalancerAccount> mappedAccounts;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public GoogleLoadBalancerAccountRegionSummary() {
            MetaClass metaClass;
            CallSite callSite = IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _closure1(this, this));
            this.mappedAccounts = IndyInterface.bootstrap("cast", "()", 0, callSite);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @JsonProperty(value="accounts")
        public List<GoogleLoadBalancerAccount> getByAccounts() {
            return (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "values", 0, this.mappedAccounts), List.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GoogleLoadBalancerAccountRegionSummary.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegionSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegionSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegionSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegionSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegionSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegionSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), GoogleLoadBalancerAccountRegionSummary.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ @VisibleForTesting void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ @VisibleForTesting void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GoogleLoadBalancerAccountRegionSummary.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GoogleLoadBalancerAccountRegionSummary.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GoogleLoadBalancerAccountRegionSummary.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GoogleLoadBalancerAccountRegionSummary.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @VisibleForTesting void setName(String string) {
            this.name = string;
        }

        @Generated
        public Map<String, GoogleLoadBalancerAccount> getMappedAccounts() {
            return this.mappedAccounts;
        }

        @Generated
        public @VisibleForTesting void setMappedAccounts(Map<String, GoogleLoadBalancerAccount> map) {
            this.mappedAccounts = map;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String accountName) {
                return IndyInterface.bootstrap("init", "<init>", 0, GoogleLoadBalancerAccount.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", accountName}));
            }

            @Generated
            public Object call(String accountName) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, accountName);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
    }

    public static class GoogleLoadBalancerDetails
    implements LoadBalancerProvider.Details,
    GroovyObject {
        private Long createdTime;
        private String dnsname;
        private String ipAddress;
        private String loadBalancerName;
        private GoogleLoadBalancerType loadBalancerType;
        private GoogleHealthCheck.View healthCheck;
        private String sessionAffinity;
        private Map<String, GoogleHealthCheck.View> backendServiceHealthChecks;
        private List<Map<String, ListenerDescription>> listenerDescriptions;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public GoogleLoadBalancerDetails() {
            MetaClass metaClass;
            List list;
            Map map;
            this.backendServiceHealthChecks = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.listenerDescriptions = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GoogleLoadBalancerDetails.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerDetails.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerDetails.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerDetails.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerDetails.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerDetails.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerDetails.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), GoogleLoadBalancerDetails.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ @VisibleForTesting void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ @VisibleForTesting void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GoogleLoadBalancerDetails.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GoogleLoadBalancerDetails.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GoogleLoadBalancerDetails.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GoogleLoadBalancerDetails.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Long getCreatedTime() {
            return this.createdTime;
        }

        @Generated
        public @VisibleForTesting void setCreatedTime(Long l) {
            this.createdTime = l;
        }

        @Generated
        public String getDnsname() {
            return this.dnsname;
        }

        @Generated
        public @VisibleForTesting void setDnsname(String string) {
            this.dnsname = string;
        }

        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @Generated
        public @VisibleForTesting void setIpAddress(String string) {
            this.ipAddress = string;
        }

        @Generated
        public String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Generated
        public @VisibleForTesting void setLoadBalancerName(String string) {
            this.loadBalancerName = string;
        }

        @Generated
        public GoogleLoadBalancerType getLoadBalancerType() {
            return this.loadBalancerType;
        }

        @Generated
        public @VisibleForTesting void setLoadBalancerType(GoogleLoadBalancerType googleLoadBalancerType) {
            this.loadBalancerType = googleLoadBalancerType;
        }

        @Generated
        public GoogleHealthCheck.View getHealthCheck() {
            return this.healthCheck;
        }

        @Generated
        public @VisibleForTesting void setHealthCheck(GoogleHealthCheck.View view) {
            this.healthCheck = view;
        }

        @Generated
        public String getSessionAffinity() {
            return this.sessionAffinity;
        }

        @Generated
        public @VisibleForTesting void setSessionAffinity(String string) {
            this.sessionAffinity = string;
        }

        @Generated
        public Map<String, GoogleHealthCheck.View> getBackendServiceHealthChecks() {
            return this.backendServiceHealthChecks;
        }

        @Generated
        public @VisibleForTesting void setBackendServiceHealthChecks(Map<String, GoogleHealthCheck.View> map) {
            this.backendServiceHealthChecks = map;
        }

        @Generated
        public List<Map<String, ListenerDescription>> getListenerDescriptions() {
            return this.listenerDescriptions;
        }

        @Generated
        public @VisibleForTesting void setListenerDescriptions(List<Map<String, ListenerDescription>> list) {
            this.listenerDescriptions = list;
        }
    }

    public static class ListenerDescription
    implements GroovyObject {
        private String instancePort;
        private String instanceProtocol;
        private String loadBalancerPort;
        private String protocol;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ListenerDescription() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ListenerDescription.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ListenerDescription.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ListenerDescription.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(ListenerDescription.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(ListenerDescription.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ListenerDescription.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ListenerDescription.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), ListenerDescription.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ @VisibleForTesting void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ @VisibleForTesting void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ListenerDescription.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ListenerDescription.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ListenerDescription.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ListenerDescription.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getInstancePort() {
            return this.instancePort;
        }

        @Generated
        public @VisibleForTesting void setInstancePort(String string) {
            this.instancePort = string;
        }

        @Generated
        public String getInstanceProtocol() {
            return this.instanceProtocol;
        }

        @Generated
        public @VisibleForTesting void setInstanceProtocol(String string) {
            this.instanceProtocol = string;
        }

        @Generated
        public String getLoadBalancerPort() {
            return this.loadBalancerPort;
        }

        @Generated
        public @VisibleForTesting void setLoadBalancerPort(String string) {
            this.loadBalancerPort = string;
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public @VisibleForTesting void setProtocol(String string) {
            this.protocol = string;
        }
    }

    public static class GoogleLoadBalancerAccount
    implements LoadBalancerProvider.ByAccount,
    GroovyObject {
        private String name;
        @JsonIgnore
        private Map<String, GoogleLoadBalancerAccountRegion> mappedRegions;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public GoogleLoadBalancerAccount() {
            MetaClass metaClass;
            CallSite callSite = IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _closure1(this, this));
            this.mappedRegions = IndyInterface.bootstrap("cast", "()", 0, callSite);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @JsonProperty(value="regions")
        public List<GoogleLoadBalancerAccountRegion> getByRegions() {
            return (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "values", 0, this.mappedRegions), List.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GoogleLoadBalancerAccount.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccount.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccount.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccount.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccount.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccount.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccount.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), GoogleLoadBalancerAccount.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ @VisibleForTesting void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ @VisibleForTesting void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GoogleLoadBalancerAccount.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GoogleLoadBalancerAccount.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GoogleLoadBalancerAccount.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GoogleLoadBalancerAccount.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @VisibleForTesting void setName(String string) {
            this.name = string;
        }

        @Generated
        public Map<String, GoogleLoadBalancerAccountRegion> getMappedRegions() {
            return this.mappedRegions;
        }

        @Generated
        public @VisibleForTesting void setMappedRegions(Map<String, GoogleLoadBalancerAccountRegion> map) {
            this.mappedRegions = map;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String region) {
                return IndyInterface.bootstrap("init", "<init>", 0, GoogleLoadBalancerAccountRegion.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", region}));
            }

            @Generated
            public Object call(String region) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, region);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
    }

    public static class GoogleLoadBalancerAccountRegion
    implements LoadBalancerProvider.ByRegion,
    GroovyObject {
        private String name;
        private List<GoogleLoadBalancerSummary> loadBalancers;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public GoogleLoadBalancerAccountRegion() {
            MetaClass metaClass;
            List list;
            this.loadBalancers = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GoogleLoadBalancerAccountRegion.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegion.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegion.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegion.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegion.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegion.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerAccountRegion.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), GoogleLoadBalancerAccountRegion.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ @VisibleForTesting void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ @VisibleForTesting void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GoogleLoadBalancerAccountRegion.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GoogleLoadBalancerAccountRegion.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GoogleLoadBalancerAccountRegion.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GoogleLoadBalancerAccountRegion.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @VisibleForTesting void setName(String string) {
            this.name = string;
        }

        @Generated
        public List<GoogleLoadBalancerSummary> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Generated
        public @VisibleForTesting void setLoadBalancers(List<GoogleLoadBalancerSummary> list) {
            this.loadBalancers = list;
        }
    }

    public static class GoogleLoadBalancerSummary
    implements LoadBalancerProvider.Details,
    GroovyObject {
        private GoogleLoadBalancerType loadBalancerType;
        private String account;
        private String region;
        private String name;
        private String type;
        private List<String> backendServices;
        private String urlMapName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public GoogleLoadBalancerSummary() {
            MetaClass metaClass;
            CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class);
            this.type = IndyInterface.bootstrap("cast", "()", 0, callSite);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GoogleLoadBalancerSummary.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GoogleLoadBalancerSummary.class, GoogleLoadBalancerProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), GoogleLoadBalancerSummary.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ @VisibleForTesting void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ @VisibleForTesting void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GoogleLoadBalancerSummary.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GoogleLoadBalancerSummary.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GoogleLoadBalancerSummary.class, GoogleLoadBalancerProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GoogleLoadBalancerSummary.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public GoogleLoadBalancerType getLoadBalancerType() {
            return this.loadBalancerType;
        }

        @Generated
        public @VisibleForTesting void setLoadBalancerType(GoogleLoadBalancerType googleLoadBalancerType) {
            this.loadBalancerType = googleLoadBalancerType;
        }

        @Generated
        public String getAccount() {
            return this.account;
        }

        @Generated
        public @VisibleForTesting void setAccount(String string) {
            this.account = string;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public @VisibleForTesting void setRegion(String string) {
            this.region = string;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @VisibleForTesting void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public @VisibleForTesting void setType(String string) {
            this.type = string;
        }

        @Generated
        public List<String> getBackendServices() {
            return this.backendServices;
        }

        @Generated
        public @VisibleForTesting void setBackendServices(List<String> list) {
            this.backendServices = list;
        }

        @Generated
        public String getUrlMapName() {
            return this.urlMapName;
        }

        @Generated
        public @VisibleForTesting void setUrlMapName(String string) {
            this.urlMapName = string;
        }
    }
}

