/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.util.Throwables;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.ComputeRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.BatchComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeRequest;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.http.client.HttpResponseException;

final class BatchComputeRequestImpl<RequestT extends ComputeRequest<ResponseT>, ResponseT>
implements BatchComputeRequest<RequestT, ResponseT> {
    @VisibleForTesting
    static final int MAX_BATCH_SIZE = 100;
    private static final Duration CONNECT_TIMEOUT = Duration.ofMinutes(2L);
    private static final Duration READ_TIMEOUT = Duration.ofMinutes(2L);
    private final Compute compute;
    private final Registry registry;
    private final String userAgent;
    private final ListeningExecutorService executor;
    private final List<QueuedRequest<RequestT, ResponseT>> queuedRequests;

    BatchComputeRequestImpl(Compute compute, Registry registry, String userAgent, ListeningExecutorService executor) {
        this.compute = compute;
        this.registry = registry;
        this.userAgent = userAgent;
        this.executor = executor;
        this.queuedRequests = new ArrayList<QueuedRequest<RequestT, ResponseT>>();
    }

    @Override
    public void queue(GoogleComputeRequest<RequestT, ResponseT> request, JsonBatchCallback<ResponseT> callback) {
        this.queuedRequests.add(new QueuedRequest<RequestT, ResponseT>(request.getRequest(), callback));
    }

    @Override
    public void execute(String batchContext) throws IOException {
        if (this.queuedRequests.size() == 0) {
            return;
        }
        List requestPartitions = Lists.partition(this.queuedRequests, (int)100);
        List<BatchRequest> queuedBatches = this.createBatchRequests(requestPartitions);
        String statusCode = "500";
        String success = "false";
        long start = this.registry.clock().monotonicTime();
        try {
            this.executeBatches(queuedBatches);
            success = "true";
            statusCode = "200";
        }
        catch (HttpResponseException e) {
            statusCode = Integer.toString(e.getStatusCode());
            throw e;
        }
        finally {
            long nanos = this.registry.clock().monotonicTime() - start;
            String status = statusCode.charAt(0) + "xx";
            ImmutableMap tags = ImmutableMap.of((Object)"context", (Object)batchContext, (Object)"success", (Object)success, (Object)"status", (Object)status, (Object)"statusCode", (Object)statusCode);
            this.registry.timer(this.registry.createId("google.batchExecute", (Map)tags)).record(Duration.ofNanos(nanos));
            this.registry.counter(this.registry.createId("google.batchSize", (Map)tags)).increment((long)this.queuedRequests.size());
        }
    }

    private void executeBatches(List<BatchRequest> queuedBatches) throws IOException {
        if (queuedBatches.size() == 1) {
            queuedBatches.get(0).execute();
            return;
        }
        List<ListenableFuture<Void>> futures = queuedBatches.stream().map(batchRequest -> this.executor.submit(() -> {
            batchRequest.execute();
            return null;
        })).collect(Collectors.toList());
        try {
            new FailFastFuture(futures, (ExecutorService)this.executor).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfPossible((Throwable)cause, IOException.class);
            throw new RuntimeException(cause);
        }
    }

    private List<BatchRequest> createBatchRequests(List<List<QueuedRequest<RequestT, ResponseT>>> requestPartitions) throws IOException {
        ArrayList<BatchRequest> queuedBatches = new ArrayList<BatchRequest>();
        try {
            requestPartitions.forEach(partition -> {
                BatchRequest batch = this.newBatch();
                partition.forEach(qr -> BatchComputeRequestImpl.wrapIOException(() -> qr.getRequest().queue(batch, qr.getCallback())));
                queuedBatches.add(batch);
            });
            return queuedBatches;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private BatchRequest newBatch() {
        return this.compute.batch(request -> {
            request.getHeaders().setUserAgent(this.userAgent);
            request.setConnectTimeout((int)CONNECT_TIMEOUT.toMillis());
            request.setReadTimeout((int)READ_TIMEOUT.toMillis());
        });
    }

    private static void wrapIOException(IoExceptionRunnable runnable) {
        try {
            runnable.run();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static final class QueuedRequest<RequestT extends ComputeRequest<ResponseT>, ResponseT> {
        private final RequestT request;
        private final JsonBatchCallback<ResponseT> callback;

        @Generated
        public RequestT getRequest() {
            return this.request;
        }

        @Generated
        public JsonBatchCallback<ResponseT> getCallback() {
            return this.callback;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueuedRequest)) {
                return false;
            }
            QueuedRequest other = (QueuedRequest)o;
            RequestT this$request = this.getRequest();
            RequestT other$request = other.getRequest();
            if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
                return false;
            }
            JsonBatchCallback<ResponseT> this$callback = this.getCallback();
            JsonBatchCallback<ResponseT> other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RequestT $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            JsonBatchCallback<ResponseT> $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BatchComputeRequestImpl.QueuedRequest(request=" + String.valueOf(this.getRequest()) + ", callback=" + String.valueOf(this.getCallback()) + ")";
        }

        @Generated
        public QueuedRequest(RequestT request, JsonBatchCallback<ResponseT> callback) {
            this.request = request;
            this.callback = callback;
        }
    }

    private static class FailFastFuture
    extends AbstractFuture<Void> {
        private final AtomicInteger remainingFutures;

        FailFastFuture(List<ListenableFuture<Void>> futures, ExecutorService executor) {
            this.remainingFutures = new AtomicInteger(futures.size());
            for (ListenableFuture<Void> future : futures) {
                Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(Object result) {
                        if (remainingFutures.decrementAndGet() == 0) {
                            this.set(null);
                        }
                    }

                    public void onFailure(Throwable t) {
                        this.setException(t);
                    }
                }, (Executor)executor);
            }
        }
    }

    @FunctionalInterface
    private static interface IoExceptionRunnable {
        public void run() throws IOException;
    }
}

