/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponseException;
import com.google.api.services.compute.ComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.BatchComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetFirstBatchComputeRequest<RequestT extends ComputeRequest<ResponseT>, ResponseT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetFirstBatchComputeRequest.class);
    private final BatchComputeRequest<RequestT, ResponseT> delegate;
    private final Callback<ResponseT> callback;

    private GetFirstBatchComputeRequest(BatchComputeRequest<RequestT, ResponseT> delegate) {
        this.delegate = delegate;
        this.callback = new Callback();
    }

    public static <RequestT extends ComputeRequest<ResponseT>, ResponseT> GetFirstBatchComputeRequest<RequestT, ResponseT> create(BatchComputeRequest<RequestT, ResponseT> batchRequest) {
        return new GetFirstBatchComputeRequest<RequestT, ResponseT>(batchRequest);
    }

    public void queue(GoogleComputeGetRequest<RequestT, ResponseT> request) {
        this.delegate.queue(request, this.callback);
    }

    public Optional<ResponseT> execute(String batchContext) throws IOException {
        this.delegate.execute(batchContext);
        if (this.callback.response != null) {
            if (!this.callback.exceptions.isEmpty()) {
                this.logIgnoredExceptions();
            }
            return Optional.of(this.callback.response);
        }
        if (!this.callback.exceptions.isEmpty()) {
            HttpResponseException e = this.callback.exceptions.get(0);
            this.callback.exceptions.subList(1, this.callback.exceptions.size()).forEach(e::addSuppressed);
            throw e;
        }
        return Optional.empty();
    }

    private void logIgnoredExceptions() {
        this.callback.exceptions.forEach(e -> log.warn("Error in batch response, but ignoring because a valid response was found", (Throwable)e));
    }

    private static class Callback<T>
    extends JsonBatchCallback<T> {
        T response;
        List<HttpResponseException> exceptions = new ArrayList<HttpResponseException>();

        private Callback() {
        }

        public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
            if (e.getCode() != 404) {
                this.exceptions.add(new HttpResponseException.Builder(e.getCode(), e.getMessage(), responseHeaders).setMessage(e.getMessage()).build());
            }
        }

        public synchronized void onSuccess(T response, HttpHeaders responseHeaders) {
            if (this.response == null) {
                this.response = response;
            }
        }
    }
}

