/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.InstanceTemplateList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.GlobalGoogleComputeRequestFactory;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeOperationRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.PaginatedComputeRequestImpl;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;

public class InstanceTemplates {
    private final Compute.InstanceTemplates computeApi;
    private final GoogleNamedAccountCredentials credentials;
    private final GlobalGoogleComputeRequestFactory requestFactory;
    private static final String defaultView = "FULL";

    InstanceTemplates(GoogleNamedAccountCredentials credentials, GoogleOperationPoller operationPoller, Registry registry) {
        this.computeApi = credentials.getCompute().instanceTemplates();
        this.credentials = credentials;
        this.requestFactory = new GlobalGoogleComputeRequestFactory("instanceTemplates", credentials, operationPoller, registry);
    }

    public GoogleComputeOperationRequest<Compute.InstanceTemplates.Delete> delete(String name) throws IOException {
        Compute.InstanceTemplates.Delete request = this.computeApi.delete(this.credentials.getProject(), name);
        return this.requestFactory.wrapOperationRequest(request, "delete");
    }

    public GoogleComputeGetRequest<Compute.InstanceTemplates.Get, InstanceTemplate> get(String name) throws IOException {
        Compute.InstanceTemplates.Get request = this.computeApi.get(this.credentials.getProject(), name);
        return this.requestFactory.wrapGetRequest(request, "get");
    }

    public GoogleComputeOperationRequest<Compute.InstanceTemplates.Insert> insert(InstanceTemplate template) throws IOException {
        Compute.InstanceTemplates.Insert request = this.computeApi.insert(this.credentials.getProject(), template);
        return this.requestFactory.wrapOperationRequest(request, "insert");
    }

    public PaginatedComputeRequest<Compute.InstanceTemplates.List, InstanceTemplate> list() {
        return new PaginatedComputeRequestImpl(pageToken -> this.requestFactory.wrapRequest(this.computeApi.list(this.credentials.getProject()).setPageToken(pageToken).setView(defaultView), "list"), InstanceTemplateList::getNextPageToken, InstanceTemplateList::getItems);
    }
}

