/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.compute;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.ComputeRequest;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest;
import com.google.api.services.compute.model.Operation;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeGetRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeOperationRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleServerGroupManagers;
import com.netflix.spinnaker.clouddriver.google.compute.ZonalGoogleComputeRequestFactory;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import java.io.IOException;
import java.util.List;

final class ZoneGoogleServerGroupManagers
implements GoogleServerGroupManagers {
    private final GoogleNamedAccountCredentials credentials;
    private final ZonalGoogleComputeRequestFactory requestFactory;
    private final Compute.InstanceGroupManagers managers;
    private final String instanceGroupName;
    private final String zone;

    ZoneGoogleServerGroupManagers(GoogleNamedAccountCredentials credentials, GoogleOperationPoller operationPoller, Registry registry, String instanceGroupName, String zone) {
        this.credentials = credentials;
        this.requestFactory = new ZonalGoogleComputeRequestFactory("instanceGroupManagers", credentials, operationPoller, registry);
        this.managers = credentials.getCompute().instanceGroupManagers();
        this.instanceGroupName = instanceGroupName;
        this.zone = zone;
    }

    @Override
    public GoogleComputeOperationRequest<ComputeRequest<Operation>> abandonInstances(List<String> instances) throws IOException {
        InstanceGroupManagersAbandonInstancesRequest request = new InstanceGroupManagersAbandonInstancesRequest();
        request.setInstances(instances);
        return this.requestFactory.wrapOperationRequest(this.managers.abandonInstances(this.credentials.getProject(), this.zone, this.instanceGroupName, request), "abandonInstances", this.zone);
    }

    @Override
    public GoogleComputeOperationRequest<ComputeRequest<Operation>> delete() throws IOException {
        return this.requestFactory.wrapOperationRequest(this.managers.delete(this.credentials.getProject(), this.zone, this.instanceGroupName), "delete", this.zone);
    }

    @Override
    public GoogleComputeGetRequest<ComputeRequest<InstanceGroupManager>, InstanceGroupManager> get() throws IOException {
        return this.requestFactory.wrapGetRequest(this.managers.get(this.credentials.getProject(), this.zone, this.instanceGroupName), "get", this.zone);
    }

    @Override
    public GoogleComputeOperationRequest patch(InstanceGroupManager content) throws IOException {
        return this.requestFactory.wrapOperationRequest(this.managers.patch(this.credentials.getProject(), this.zone, this.instanceGroupName, content), "patch", this.zone);
    }

    @Override
    public GoogleComputeOperationRequest<ComputeRequest<Operation>> update(InstanceGroupManager content) throws IOException {
        return this.requestFactory.wrapOperationRequest(this.managers.update(this.credentials.getProject(), this.zone, this.instanceGroupName, content), "update", this.zone);
    }
}

