/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Operation;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutorTraits;
import com.netflix.spinnaker.clouddriver.google.config.GoogleConfigurationProperties;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationException;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationTimedOutException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class GoogleOperationPoller
implements GoogleExecutorTraits,
GroovyObject {
    private static final String METRIC_NAME = "google.operationWaits";
    private static final String STARTED_METRIC_NAME = "google.operationWaitRequests";
    @Autowired
    private Registry registry;
    @Autowired
    private GoogleConfigurationProperties googleConfigurationProperties;
    @Autowired
    private SafeRetry safeRetry;
    @VisibleForTesting
    private ThreadSleeper threadSleeper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public GoogleOperationPoller() {
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ThreadSleeper.class);
        this.threadSleeper = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    /*
     * WARNING - void declaration
     */
    public Operation waitForZonalOperation(Compute compute, String projectName, String zone, String operationName, Long timeoutSeconds, Task task, String resourceString, String basePhase) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference projectName2 = new Reference((Object)var2_2);
        Reference zone2 = new Reference((Object)var3_3);
        Reference operationName2 = new Reference((Object)operationName);
        Map tags = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"basePhase", basePhase, "scope", IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), "zone", (String)zone2.get()});
        public final class _waitForZonalOperation_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference projectName;
            private /* synthetic */ Reference zone;
            private /* synthetic */ Reference operationName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _waitForZonalOperation_closure1(Object _outerInstance, Object _thisObject, Reference compute, Reference projectName, Reference zone, Reference operationName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.compute = reference4 = compute;
                this.projectName = reference3 = projectName;
                this.zone = reference2 = zone;
                this.operationName = reference = operationName;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "zoneOperations", 0, IndyInterface.bootstrap("cast", "()", 0, this.compute.get())), IndyInterface.bootstrap("cast", "()", 0, this.projectName.get()), IndyInterface.bootstrap("cast", "()", 0, this.zone.get()), IndyInterface.bootstrap("cast", "()", 0, this.operationName.get())), "compute.zoneOperations.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.zone.get()));
            }

            @Generated
            public Compute getCompute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
            }

            @Generated
            public String getProjectName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.projectName.get());
            }

            @Generated
            public String getZone() {
                return IndyInterface.bootstrap("cast", "()", 0, this.zone.get());
            }

            @Generated
            public String getOperationName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.operationName.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _waitForZonalOperation_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "handleFinishedAsyncOperation", 0, GoogleOperationPoller.class, IndyInterface.bootstrap("invoke", "waitForOperation", 2, this, new _waitForZonalOperation_closure1(this, this, compute2, projectName2, zone2, operationName2), tags, basePhase, IndyInterface.bootstrap("invoke", "getTimeout", 2, this, timeoutSeconds)), task, resourceString, basePhase));
    }

    /*
     * WARNING - void declaration
     */
    public Operation waitForRegionalOperation(Compute compute, String projectName, String region, String operationName, Long timeoutSeconds, Task task, String resourceString, String basePhase) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference projectName2 = new Reference((Object)var2_2);
        Reference region2 = new Reference((Object)var3_3);
        Reference operationName2 = new Reference((Object)operationName);
        Map tags = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"basePhase", basePhase, "scope", IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), "region", (String)region2.get()});
        public final class _waitForRegionalOperation_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference projectName;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference operationName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _waitForRegionalOperation_closure2(Object _outerInstance, Object _thisObject, Reference compute, Reference projectName, Reference region, Reference operationName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.compute = reference4 = compute;
                this.projectName = reference3 = projectName;
                this.region = reference2 = region;
                this.operationName = reference = operationName;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "regionOperations", 0, IndyInterface.bootstrap("cast", "()", 0, this.compute.get())), IndyInterface.bootstrap("cast", "()", 0, this.projectName.get()), IndyInterface.bootstrap("cast", "()", 0, this.region.get()), IndyInterface.bootstrap("cast", "()", 0, this.operationName.get())), "compute.regionOperations.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.region.get()));
            }

            @Generated
            public Compute getCompute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
            }

            @Generated
            public String getProjectName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.projectName.get());
            }

            @Generated
            public String getRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
            }

            @Generated
            public String getOperationName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.operationName.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _waitForRegionalOperation_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "handleFinishedAsyncOperation", 0, GoogleOperationPoller.class, IndyInterface.bootstrap("invoke", "waitForOperation", 2, this, new _waitForRegionalOperation_closure2(this, this, compute2, projectName2, region2, operationName2), tags, basePhase, IndyInterface.bootstrap("invoke", "getTimeout", 2, this, timeoutSeconds)), task, resourceString, basePhase));
    }

    /*
     * WARNING - void declaration
     */
    public Operation waitForGlobalOperation(Compute compute, String projectName, String operationName, Long timeoutSeconds, Task task, String resourceString, String basePhase) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference projectName2 = new Reference((Object)var2_2);
        Reference operationName2 = new Reference((Object)var3_3);
        Map tags = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"basePhase", basePhase, "scope", IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)});
        public final class _waitForGlobalOperation_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference projectName;
            private /* synthetic */ Reference operationName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _waitForGlobalOperation_closure3(Object _outerInstance, Object _thisObject, Reference compute, Reference projectName, Reference operationName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.compute = reference3 = compute;
                this.projectName = reference2 = projectName;
                this.operationName = reference = operationName;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "globalOperations", 0, IndyInterface.bootstrap("cast", "()", 0, this.compute.get())), IndyInterface.bootstrap("cast", "()", 0, this.projectName.get()), IndyInterface.bootstrap("cast", "()", 0, this.operationName.get())), "compute.globalOperations.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
            }

            @Generated
            public Compute getCompute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
            }

            @Generated
            public String getProjectName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.projectName.get());
            }

            @Generated
            public String getOperationName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.operationName.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _waitForGlobalOperation_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "handleFinishedAsyncOperation", 0, GoogleOperationPoller.class, IndyInterface.bootstrap("invoke", "waitForOperation", 2, this, new _waitForGlobalOperation_closure3(this, this, compute2, projectName2, operationName2), tags, basePhase, IndyInterface.bootstrap("invoke", "getTimeout", 2, this, timeoutSeconds)), task, resourceString, basePhase));
    }

    private long getTimeout(Long timeoutSeconds) {
        return DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "max", 0, Math.class, ScriptBytecodeAdapter.compareNotEqual((Object)timeoutSeconds, null) ? timeoutSeconds : IndyInterface.bootstrap("getProperty", "asyncOperationTimeoutSecondsDefault", 4, this.googleConfigurationProperties), false));
    }

    private static Object handleFinishedAsyncOperation(Operation operation, Task task, String resourceString, String basePhase) {
        if (IndyInterface.bootstrap("cast", "()", 0, operation) == false) {
            CallSite errorMsg = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{resourceString}, new String[]{"Operation on ", " timed out."}));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, basePhase, errorMsg);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleOperationTimedOutException.class, errorMsg));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getError", 0, operation)) != false) {
            CallSite error = IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("invoke", "getErrors", 1, IndyInterface.bootstrap("invoke", "getError", 1, operation)), false);
            CallSite errorMsg = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{resourceString, error}, new String[]{"Failed to complete operation on ", " with error: ", ""}));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, basePhase, errorMsg);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleOperationException.class, errorMsg));
        }
        return IndyInterface.bootstrap("invoke", "updateStatus", 0, task, basePhase, new GStringImpl(new Object[]{resourceString}, new String[]{"Done operating on ", "."}));
    }

    private Operation waitForOperation(Closure<Operation> getOperation, Map timerTags, String basePhase, long timeoutSeconds) {
        CallSite clock = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clock", 0, this.registry));
        long startNs = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "monotonicTime", 0, clock));
        int totalTimePollingSeconds = 0;
        boolean timeoutExceeded = false;
        int pollInterval = 1;
        int pollIncrement = 0;
        IndyInterface.bootstrap("invoke", "increment", 0, IndyInterface.bootstrap("invoke", "counter", 0, this.registry, IndyInterface.bootstrap("invoke", "createId", 0, this.registry, STARTED_METRIC_NAME, timerTags)));
        CallSite metricId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createId", 0, this.registry, METRIC_NAME, timerTags));
        while (!timeoutExceeded) {
            IndyInterface.bootstrap("invoke", "sleep", 0, this.threadSleeper, pollInterval);
            totalTimePollingSeconds = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "plus", 0, totalTimePollingSeconds, pollInterval));
            Operation operation = (Operation)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, getOperation, "operation", null, ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "wait", "phase", basePhase}), this.registry), Operation.class);
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getStatus", 0, operation), (Object)"DONE")) {
                IndyInterface.bootstrap("invoke", "record", 0, IndyInterface.bootstrap("invoke", "timer", 0, this.registry, IndyInterface.bootstrap("invoke", "withTag", 0, metricId, "status", "DONE")), IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "monotonicTime", 0, clock), startNs), IndyInterface.bootstrap("getProperty", "NANOSECONDS", 0, TimeUnit.class));
                return operation;
            }
            if ((long)totalTimePollingSeconds > timeoutSeconds) {
                IndyInterface.bootstrap("invoke", "record", 0, IndyInterface.bootstrap("invoke", "timer", 0, this.registry, IndyInterface.bootstrap("invoke", "withTag", 0, metricId, "status", "TIMEOUT")), IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "monotonicTime", 0, clock), startNs), IndyInterface.bootstrap("getProperty", "NANOSECONDS", 0, TimeUnit.class));
                timeoutExceeded = true;
                continue;
            }
            int oldIncrement = pollIncrement;
            pollInterval = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "plus", 0, pollInterval, oldIncrement));
            pollInterval = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "min", 0, Math.class, pollInterval, IndyInterface.bootstrap("getProperty", "asyncOperationMaxPollingIntervalSeconds", 4, this.googleConfigurationProperties)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleOperationPoller.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleOperationPoller.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleOperationPoller.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleOperationPoller.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GoogleOperationPoller.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GoogleOperationPoller.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public static String getMETRIC_NAME() {
        return METRIC_NAME;
    }

    @Generated
    public static String getSTARTED_METRIC_NAME() {
        return STARTED_METRIC_NAME;
    }

    @Override
    @Generated
    public Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Generated
    public GoogleConfigurationProperties getGoogleConfigurationProperties() {
        return this.googleConfigurationProperties;
    }

    @Generated
    public void setGoogleConfigurationProperties(GoogleConfigurationProperties googleConfigurationProperties) {
        this.googleConfigurationProperties = googleConfigurationProperties;
    }

    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Generated
    public void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    @Generated
    public @VisibleForTesting ThreadSleeper getThreadSleeper() {
        return this.threadSleeper;
    }

    @Generated
    public void setThreadSleeper(@VisibleForTesting ThreadSleeper threadSleeper) {
        this.threadSleeper = threadSleeper;
    }

    public static class ThreadSleeper
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ThreadSleeper() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void sleep(long seconds) {
            IndyInterface.bootstrap("invoke", "sleep", 0, IndyInterface.bootstrap("invoke", "currentThread", 0, Thread.class), IndyInterface.bootstrap("invoke", "multiply", 0, seconds, 1000));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ThreadSleeper.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ThreadSleeper.class, GoogleOperationPoller.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ThreadSleeper.class, GoogleOperationPoller.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(ThreadSleeper.class, GoogleOperationPoller.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(ThreadSleeper.class, GoogleOperationPoller.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ThreadSleeper.class, GoogleOperationPoller.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ThreadSleeper.class, GoogleOperationPoller.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), ThreadSleeper.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleOperationPoller.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleOperationPoller.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ThreadSleeper.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ThreadSleeper.class, GoogleOperationPoller.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ThreadSleeper.class, GoogleOperationPoller.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ThreadSleeper.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

