/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.handlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.Autoscaler;
import com.google.api.services.compute.model.Backend;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.DistributionPolicy;
import com.google.api.services.compute.model.DistributionPolicyZoneConfiguration;
import com.google.api.services.compute.model.FixedOrPercent;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceGroupManagerAutoHealingPolicy;
import com.google.api.services.compute.model.InstanceProperties;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.NamedPort;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.ServiceAccount;
import com.google.api.services.compute.model.Tags;
import com.netflix.frigga.Names;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeployDescription;
import com.netflix.spinnaker.clouddriver.deploy.DeployHandler;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutorTraits;
import com.netflix.spinnaker.clouddriver.google.config.GoogleConfigurationProperties;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.BasicGoogleDeployDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationException;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleUserDataProvider;
import com.netflix.spinnaker.clouddriver.google.model.GoogleHealthCheck;
import com.netflix.spinnaker.clouddriver.google.model.GoogleLabeledResource;
import com.netflix.spinnaker.clouddriver.google.model.GoogleNetwork;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSubnet;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleBackendService;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancerType;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancerView;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleNetworkLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSslLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTcpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleLoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleNetworkProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSubnetProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.config.GoogleConfiguration;
import com.netflix.spinnaker.moniker.Moniker;
import com.netflix.spinnaker.moniker.Namer;
import groovy.lang.Closure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BasicGoogleDeployHandler
implements DeployHandler<BasicGoogleDeployDescription>,
GoogleExecutorTraits {
    @Generated
    private static final Logger log = LogManager.getLogger(BasicGoogleDeployHandler.class);
    private static final String BASE_PHASE = "DEPLOY";
    private static final String DEFAULT_NETWORK_NAME = "default";
    private static final String ACCESS_CONFIG_NAME = "External NAT";
    private static final String ACCESS_CONFIG_TYPE = "ONE_TO_ONE_NAT";
    private static final Integer MAX_NAME_SIZE = 64;
    private static final Integer TEMPLATE_UUID_SIZE = 8;
    @Autowired
    private GoogleConfigurationProperties googleConfigurationProperties;
    @Autowired
    private GoogleClusterProvider googleClusterProvider;
    @Autowired
    private GoogleConfiguration.DeployDefaults googleDeployDefaults;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private GoogleUserDataProvider googleUserDataProvider;
    @Autowired
    GoogleLoadBalancerProvider googleLoadBalancerProvider;
    @Autowired
    GoogleNetworkProvider googleNetworkProvider;
    @Autowired
    GoogleSubnetProvider googleSubnetProvider;
    @Autowired
    String clouddriverUserAgentApplicationName;
    @Autowired
    Cache cacheView;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    SafeRetry safeRetry;
    @Autowired
    Registry registry;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public DeploymentResult handle(BasicGoogleDeployDescription description, List priorOutputs) {
        Task task = BasicGoogleDeployHandler.getTask();
        try {
            String region = this.getRegionFromInput(description);
            String location = this.getLocationFromInput(description, region);
            GCEServerGroupNameResolver nameResolver = this.getServerGroupNameResolver(description, region);
            String clusterName = nameResolver.getClusterName(description.getApplication(), description.getStack(), description.getFreeFormDetails());
            task.updateStatus(BASE_PHASE, String.format("Initializing creation of server group for cluster %s in %s...", clusterName, location));
            task.updateStatus(BASE_PHASE, "Looking up next sequence...");
            String nextServerGroupName = nameResolver.resolveNextServerGroupName(description.getApplication(), description.getStack(), description.getFreeFormDetails(), false);
            task.updateStatus(BASE_PHASE, String.format("Produced server group name: %s", nextServerGroupName));
            String machineTypeName = this.getMachineTypeNameFromInput(description, task, location);
            GoogleNetwork network = this.buildNetworkFromInput(description, task);
            GoogleSubnet subnet = this.buildSubnetFromInput(description, task, network, region);
            LoadBalancerInfo lbToUpdate = this.getLoadBalancerToUpdateFromInput(description, task);
            task.updateStatus(BASE_PHASE, String.format("Composing server group %s...", nextServerGroupName));
            description.setBaseDeviceName(nextServerGroupName);
            Image bootImage = this.buildBootImage(description, task);
            List<AttachedDisk> attachedDisks = this.buildAttachedDisks(description, task, bootImage);
            NetworkInterface networkInterface = this.buildNetworkInterface(description, network, subnet);
            GoogleHttpLoadBalancingPolicy lbPolicy = null;
            List<BackendService> backendServicesToUpdate = this.getBackendServiceToUpdate(description, nextServerGroupName, lbToUpdate, lbPolicy, region);
            List<BackendService> regionBackendServicesToUpdate = this.getRegionBackendServicesToUpdate(description, nextServerGroupName, lbToUpdate, lbPolicy, region);
            String now = String.valueOf(System.currentTimeMillis());
            String suffix = now.substring(now.length() - TEMPLATE_UUID_SIZE);
            String instanceTemplateName = String.format("%s-%s", nextServerGroupName, suffix);
            if (instanceTemplateName.length() > MAX_NAME_SIZE) {
                throw new IllegalArgumentException("Max name length ${MAX_NAME_SIZE} exceeded in resolved instance template name ${instanceTemplateName}.");
            }
            this.addUserDataToInstanceMetadata(description, nextServerGroupName, instanceTemplateName, task);
            this.addSelectZonesToInstanceMetadata(description);
            Metadata metadata = this.buildMetadataFromInstanceMetadata(description);
            Tags tags = this.buildTagsFromInput(description);
            List<ServiceAccount> serviceAccounts = this.buildServiceAccountFromInput(description);
            Scheduling scheduling = this.buildSchedulingFromInput(description);
            Map<String, String> labels = this.buildLabelsFromInput(description, nextServerGroupName, region);
            this.setupMonikerForOperation(description, nextServerGroupName, clusterName);
            this.validateAcceleratorConfig(description);
            InstanceProperties instanceProperties = this.buildInstancePropertiesFromInput(description, machineTypeName, attachedDisks, networkInterface, metadata, tags, serviceAccounts, scheduling, labels);
            this.addShieldedVmConfigToInstanceProperties(description, instanceProperties, bootImage);
            this.addMinCpuPlatformToInstanceProperties(description, instanceProperties);
            InstanceTemplate instanceTemplate = this.buildInstanceTemplate(instanceTemplateName, instanceProperties);
            String instanceTemplateUrl = "";
            instanceTemplateUrl = this.createInstanceTemplateAndWait(description.getCredentials(), instanceTemplate, task);
            this.setCapacityFromInput(description);
            this.setAutoscalerCapacityFromInput(description);
            this.setCapacityFromSource(description, task);
            List<InstanceGroupManagerAutoHealingPolicy> autoHealingPolicy = this.buildAutoHealingPolicyFromInput(description, task);
            InstanceGroupManager instanceGroupManager = this.buildInstanceGroupFromInput(description, nextServerGroupName, instanceTemplateUrl, lbToUpdate.targetPools, autoHealingPolicy);
            this.setNamedPortsToInstanceGroup(description, lbToUpdate, instanceGroupManager);
            this.createInstanceGroupManagerFromInput(description, instanceGroupManager, lbToUpdate, nextServerGroupName, region, task);
            task.updateStatus(BASE_PHASE, String.format("Done creating server group %s in %s.", nextServerGroupName, location));
            this.updateBackendServices(description, lbToUpdate, nextServerGroupName, backendServicesToUpdate, task);
            this.updateRegionalBackendServices(description, lbToUpdate, nextServerGroupName, region, regionBackendServicesToUpdate, task);
            DeploymentResult deploymentResult = new DeploymentResult();
            deploymentResult.setServerGroupNames(List.of(String.format("%s:%s", region, nextServerGroupName)));
            deploymentResult.setServerGroupNameByRegion(Map.of(region, nextServerGroupName));
            return deploymentResult;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error in handler: " + e.getMessage());
        }
    }

    protected GCEServerGroupNameResolver getServerGroupNameResolver(BasicGoogleDeployDescription description, String region) {
        GoogleNamedAccountCredentials credentials = description.getCredentials();
        return new GCEServerGroupNameResolver(credentials.getProject(), region, credentials, this.googleClusterProvider, this.safeRetry, this);
    }

    protected String getRegionFromInput(BasicGoogleDeployDescription description) {
        return StringUtils.isNotBlank((CharSequence)description.getRegion()) ? description.getRegion() : description.getCredentials().regionFromZone(description.getZone());
    }

    protected String getLocationFromInput(BasicGoogleDeployDescription description, String region) {
        return description.getRegional() != false ? region : description.getZone();
    }

    protected String getMachineTypeNameFromInput(BasicGoogleDeployDescription description, Task task, String location) {
        if (description.getInstanceType().contains("custom-")) {
            return description.getInstanceType();
        }
        List<String> queryZone = description.getRegional().booleanValue() ? (Optional.ofNullable(description.getSelectZones()).orElse(false).booleanValue() ? Optional.ofNullable(description.getDistributionPolicy().getZones()).orElse(Collections.singletonList(location)) : Collections.singletonList(location)) : Collections.singletonList(location);
        String machineTypeName = "";
        for (String zoneOrLocation : queryZone) {
            String msg = description.getRegional().booleanValue() ? (description.getSelectZones().booleanValue() ? "Machine type " + description.getInstanceType() + " not found in zone " + zoneOrLocation + ". When using selectZones, the machine type must be available in all selected zones." : "Machine type " + description.getInstanceType() + " not found in zone " + zoneOrLocation + ". When using Regional distribution without explicit selection of Zones, the machine type must be available in all zones of the region.") : "Machine type " + description.getInstanceType() + " not found in region " + zoneOrLocation + ".";
            try {
                machineTypeName = GCEUtil.queryMachineType(description.getInstanceType(), zoneOrLocation, description.getCredentials(), task, BASE_PHASE);
            }
            catch (GoogleOperationException e) {
                throw new GoogleOperationException(msg);
            }
        }
        return machineTypeName;
    }

    protected GoogleNetwork buildNetworkFromInput(BasicGoogleDeployDescription description, Task task) {
        String networkName = StringUtils.isNotBlank((CharSequence)description.getNetwork()) ? description.getNetwork() : DEFAULT_NETWORK_NAME;
        return GCEUtil.queryNetwork(description.getAccountName(), networkName, task, BASE_PHASE, this.googleNetworkProvider);
    }

    protected GoogleSubnet buildSubnetFromInput(BasicGoogleDeployDescription description, Task task, GoogleNetwork network, String region) {
        GoogleSubnet subnet;
        GoogleSubnet googleSubnet = subnet = StringUtils.isNotBlank((CharSequence)description.getSubnet()) ? GCEUtil.querySubnet(description.getAccountName(), region, description.getSubnet(), task, BASE_PHASE, this.googleSubnetProvider) : null;
        if (subnet != null && network.getId().contains("/") && network.getAutoCreateSubnets().booleanValue()) {
            subnet = GCEUtil.querySubnet(description.getAccountName(), region, network.getId(), task, BASE_PHASE, this.googleSubnetProvider);
        }
        return subnet;
    }

    protected LoadBalancerInfo getLoadBalancerToUpdateFromInput(BasicGoogleDeployDescription description, Task task) {
        LoadBalancerInfo info = new LoadBalancerInfo();
        if (description.getLoadBalancers().isEmpty()) {
            return info;
        }
        List<GoogleLoadBalancerView> foundLB = GCEUtil.queryAllLoadBalancers(this.googleLoadBalancerProvider, description.getLoadBalancers(), task, BASE_PHASE);
        info.internalLoadBalancers = foundLB.stream().filter(lb -> lb.getLoadBalancerType() == GoogleLoadBalancerType.INTERNAL).collect(Collectors.toList());
        info.internalHttpLoadBalancers = foundLB.stream().filter(lb -> lb.getLoadBalancerType() == GoogleLoadBalancerType.INTERNAL_MANAGED).collect(Collectors.toList());
        info.sslLoadBalancers = foundLB.stream().filter(lb -> lb.getLoadBalancerType() == GoogleLoadBalancerType.SSL).collect(Collectors.toList());
        info.tcpLoadBalancers = foundLB.stream().filter(lb -> lb.getLoadBalancerType() == GoogleLoadBalancerType.TCP).collect(Collectors.toList());
        if (!description.getDisableTraffic().booleanValue()) {
            info.targetPools = foundLB.stream().filter(lb -> lb.getLoadBalancerType() == GoogleLoadBalancerType.NETWORK).map(lb -> (GoogleNetworkLoadBalancer.View)lb).map(GoogleNetworkLoadBalancer.View::getTargetPool).distinct().collect(Collectors.toList());
        }
        return info;
    }

    protected Image buildBootImage(BasicGoogleDeployDescription description, Task task) {
        return GCEUtil.getBootImage(description, task, BASE_PHASE, this.clouddriverUserAgentApplicationName, this.googleConfigurationProperties.getBaseImageProjects(), this.safeRetry, this);
    }

    protected List<AttachedDisk> buildAttachedDisks(BasicGoogleDeployDescription description, Task task, Image bootImage) {
        return GCEUtil.buildAttachedDisks(description, null, false, this.googleDeployDefaults, task, BASE_PHASE, this.clouddriverUserAgentApplicationName, this.googleConfigurationProperties.getBaseImageProjects(), bootImage, this.safeRetry, this);
    }

    protected NetworkInterface buildNetworkInterface(BasicGoogleDeployDescription description, GoogleNetwork network, GoogleSubnet subnet) {
        boolean associatePublicIpAddress = description.getAssociatePublicIpAddress() == null || description.getAssociatePublicIpAddress() != false;
        return GCEUtil.buildNetworkInterface(network, subnet, associatePublicIpAddress, ACCESS_CONFIG_NAME, ACCESS_CONFIG_TYPE);
    }

    protected boolean hasBackedServiceFromInput(BasicGoogleDeployDescription description, LoadBalancerInfo loadBalancerInfo) {
        Map<String, String> instanceMetadata = description.getInstanceMetadata();
        return !instanceMetadata.isEmpty() && instanceMetadata.containsKey("backend-service-names") || !loadBalancerInfo.getSslLoadBalancers().isEmpty() || !loadBalancerInfo.getTcpLoadBalancers().isEmpty();
    }

    protected GoogleHttpLoadBalancingPolicy buildLoadBalancerPolicyFromInput(BasicGoogleDeployDescription description) throws JsonProcessingException {
        Map<String, String> instanceMetadata = description.getInstanceMetadata();
        String sourcePolicyJson = instanceMetadata.get("load-balancing-policy");
        if (description.getLoadBalancingPolicy() != null && description.getLoadBalancingPolicy().getBalancingMode() != null) {
            return description.getLoadBalancingPolicy();
        }
        if (StringUtils.isNotBlank((CharSequence)sourcePolicyJson)) {
            return (GoogleHttpLoadBalancingPolicy)this.objectMapper.readValue(sourcePolicyJson, GoogleHttpLoadBalancingPolicy.class);
        }
        log.warn("No load balancing policy found in the operation description or the source server group, adding defaults");
        GoogleHttpLoadBalancingPolicy policy = new GoogleHttpLoadBalancingPolicy();
        policy.setBalancingMode(GoogleLoadBalancingPolicy.BalancingMode.UTILIZATION);
        policy.setMaxUtilization(Float.valueOf(0.8f));
        policy.setCapacityScaler(Float.valueOf(1.0f));
        NamedPort namedPort = new NamedPort();
        namedPort.setName("http");
        namedPort.setPort(GoogleHttpLoadBalancingPolicy.getHTTP_DEFAULT_PORT());
        policy.setNamedPorts(List.of(namedPort));
        return policy;
    }

    protected List<BackendService> getBackendServiceToUpdate(BasicGoogleDeployDescription description, String serverGroupName, LoadBalancerInfo lbInfo, GoogleHttpLoadBalancingPolicy policy, String region) {
        if (this.hasBackedServiceFromInput(description, lbInfo)) {
            ArrayList<BackendService> backendServicesToUpdate = new ArrayList<BackendService>();
            Map<String, String> instanceMetadata = description.getInstanceMetadata();
            ArrayList<String> backendServices = instanceMetadata.get("backend-service-names") != null ? new ArrayList<String>(Arrays.asList(instanceMetadata.get("backend-service-names").split(","))) : new ArrayList();
            backendServices.addAll(lbInfo.getSslLoadBalancers().stream().map(lb -> (GoogleSslLoadBalancer.View)lb).map(it -> it.getBackendService().getName()).collect(Collectors.toList()));
            backendServices.addAll(lbInfo.getTcpLoadBalancers().stream().map(lb -> (GoogleTcpLoadBalancer.View)lb).map(it -> it.getBackendService().getName()).collect(Collectors.toList()));
            List globalLbNames = lbInfo.getSslLoadBalancers().stream().map(GoogleLoadBalancerView::getName).collect(Collectors.toList());
            globalLbNames.addAll(lbInfo.getTcpLoadBalancers().stream().map(GoogleLoadBalancerView::getName).collect(Collectors.toList()));
            globalLbNames.addAll(GCEUtil.resolveHttpLoadBalancerNamesMetadata(backendServices, description.getCredentials().getCompute(), description.getCredentials().getProject(), this));
            instanceMetadata.put("global-load-balancer-names", String.join((CharSequence)",", globalLbNames));
            backendServices.forEach(backendServiceName -> {
                try {
                    BackendService backendService = this.getBackendServiceFromProvider(description.getCredentials(), (String)backendServiceName);
                    GCEUtil.updateMetadataWithLoadBalancingPolicy(policy, instanceMetadata, this.objectMapper);
                    Backend backendToAdd = GCEUtil.backendFromLoadBalancingPolicy(policy);
                    if (description.getRegional().booleanValue()) {
                        backendToAdd.setGroup(GCEUtil.buildRegionalServerGroupUrl(description.getCredentials().getProject(), region, serverGroupName));
                    } else {
                        backendToAdd.setGroup(GCEUtil.buildZonalServerGroupUrl(description.getCredentials().getProject(), description.getZone(), serverGroupName));
                    }
                    if (backendService.getBackends() == null) {
                        backendService.setBackends(new ArrayList());
                    }
                    backendService.getBackends().add(backendToAdd);
                    backendServicesToUpdate.add(backendService);
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            });
            return backendServicesToUpdate;
        }
        return Collections.emptyList();
    }

    protected List<BackendService> getRegionBackendServicesToUpdate(BasicGoogleDeployDescription description, String serverGroupName, LoadBalancerInfo lbInfo, GoogleHttpLoadBalancingPolicy policy, String region) {
        if (!lbInfo.getInternalLoadBalancers().isEmpty() || !lbInfo.getInternalHttpLoadBalancers().isEmpty()) {
            ArrayList<BackendService> regionBackendServicesToUpdate = new ArrayList<BackendService>();
            Map<String, String> instanceMetadata = description.getInstanceMetadata();
            ArrayList<String> existingRegionalLbs = instanceMetadata.get("load-balancer-names") != null ? new ArrayList<String>(Arrays.asList(instanceMetadata.get("load-balancer-names").split(","))) : new ArrayList();
            ArrayList<String> regionBackendServices = instanceMetadata.get("region-backend-service-names") != null ? new ArrayList<String>(Arrays.asList(instanceMetadata.get("region-backend-service-names").split(","))) : new ArrayList();
            List<String> ilbServices = lbInfo.getInternalLoadBalancers().stream().map(lb -> (GoogleInternalLoadBalancer.View)lb).map(it -> it.getBackendService().getName()).collect(Collectors.toList());
            ilbServices.addAll(regionBackendServices);
            ilbServices.stream().distinct().collect(Collectors.toList());
            List<String> ilbNames = lbInfo.getInternalLoadBalancers().stream().map(GoogleLoadBalancerView::getName).collect(Collectors.toList());
            ilbNames.addAll(lbInfo.getInternalHttpLoadBalancers().stream().map(GoogleLoadBalancerView::getName).collect(Collectors.toList()));
            ilbNames.forEach(ilbName -> {
                if (!existingRegionalLbs.contains(ilbName)) {
                    existingRegionalLbs.add((String)ilbName);
                }
            });
            instanceMetadata.put("load-balancer-names", String.join((CharSequence)",", existingRegionalLbs));
            List internalHttpLbBackendServices = lbInfo.getInternalHttpLoadBalancers().stream().map(lb -> (GoogleInternalHttpLoadBalancer.InternalHttpLbView)lb).map(Utils::getBackendServicesFromInternalHttpLoadBalancerView).flatMap(Collection::stream).map(GoogleBackendService::getName).collect(Collectors.toList());
            ilbServices.forEach(backendServiceName -> {
                try {
                    BackendService backendService = this.getRegionBackendServiceFromProvider(description.getCredentials(), region, serverGroupName);
                    Backend backendToAdd = internalHttpLbBackendServices.contains(backendServiceName) ? GCEUtil.backendFromLoadBalancingPolicy(policy) : new Backend();
                    if (description.getRegional().booleanValue()) {
                        backendToAdd.setGroup(GCEUtil.buildRegionalServerGroupUrl(description.getCredentials().getProject(), region, serverGroupName));
                    } else {
                        backendToAdd.setGroup(GCEUtil.buildZonalServerGroupUrl(description.getCredentials().getProject(), description.getZone(), serverGroupName));
                    }
                    if (backendService.getBackends() == null) {
                        backendService.setBackends(new ArrayList());
                    }
                    backendService.getBackends().add(backendToAdd);
                    regionBackendServicesToUpdate.add(backendService);
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            });
            return regionBackendServicesToUpdate;
        }
        return Collections.emptyList();
    }

    protected void addUserDataToInstanceMetadata(BasicGoogleDeployDescription description, String serverGroupName, String instanceTemplateName, Task task) {
        Map userDataMap = this.getUserData(description, serverGroupName, instanceTemplateName, task);
        Map instanceMetadata = description.getInstanceMetadata();
        if (!instanceMetadata.isEmpty()) {
            instanceMetadata.putAll(userDataMap);
        } else {
            instanceMetadata = userDataMap;
        }
        description.setInstanceMetadata(instanceMetadata);
    }

    protected Map getUserData(BasicGoogleDeployDescription description, String serverGroupName, String instanceTemplateName, Task task) {
        String customUserData = StringUtils.isNotBlank((CharSequence)description.getUserData()) ? description.getUserData() : "";
        Map userData = this.googleUserDataProvider.getUserData(serverGroupName, instanceTemplateName, description, description.getCredentials(), customUserData);
        task.updateStatus(BASE_PHASE, "Resolved user data.");
        return userData;
    }

    protected void addSelectZonesToInstanceMetadata(BasicGoogleDeployDescription description) {
        if (description.getRegional().booleanValue() && description.getSelectZones().booleanValue()) {
            Map<String, String> instanceMetadata = description.getInstanceMetadata();
            instanceMetadata.put("select-zones", "true");
            description.setInstanceMetadata(instanceMetadata);
        }
    }

    protected Metadata buildMetadataFromInstanceMetadata(BasicGoogleDeployDescription description) {
        return GCEUtil.buildMetadataFromMap(description.getInstanceMetadata());
    }

    protected Tags buildTagsFromInput(BasicGoogleDeployDescription description) {
        return GCEUtil.buildTagsFromList(description.getTags());
    }

    protected List<ServiceAccount> buildServiceAccountFromInput(BasicGoogleDeployDescription description) {
        if (!description.getAuthScopes().isEmpty() && StringUtils.isBlank((CharSequence)description.getServiceAccountEmail())) {
            description.setServiceAccountEmail(DEFAULT_NETWORK_NAME);
        }
        return GCEUtil.buildServiceAccount(description.getServiceAccountEmail(), description.getAuthScopes());
    }

    protected Scheduling buildSchedulingFromInput(BasicGoogleDeployDescription description) {
        return GCEUtil.buildScheduling(description);
    }

    protected Map<String, String> buildLabelsFromInput(BasicGoogleDeployDescription description, String serverGroupName, String region) {
        Map<String, String> labels = description.getLabels();
        if (labels == null) {
            labels = new HashMap<String, String>();
        }
        labels.put("spinnaker-region", region);
        labels.put("spinnaker-server-group", serverGroupName);
        return labels;
    }

    private void setupMonikerForOperation(BasicGoogleDeployDescription description, String serverGroupName, String clusterName) {
        Namer namer = NamerRegistry.lookup().withProvider(GoogleCloudProvider.getID()).withAccount(description.getAccountName()).withResource(GoogleLabeledResource.class);
        Integer sequence = Names.parseName((String)serverGroupName).getSequence();
        Moniker moniker = Moniker.builder().app(description.getApplication()).cluster(clusterName).detail(description.getFreeFormDetails()).stack(description.getStack()).sequence(sequence).build();
        GoogleInstanceTemplate googleInstanceTemplate = new GoogleInstanceTemplate();
        googleInstanceTemplate.labels = description.getLabels();
        namer.applyMoniker((Object)googleInstanceTemplate, moniker);
    }

    protected void validateAcceleratorConfig(BasicGoogleDeployDescription description) {
        if (!(description.getAcceleratorConfigs() == null || description.getAcceleratorConfigs().isEmpty() || description.getRegional().booleanValue() && !description.getSelectZones().booleanValue())) {
            throw new IllegalArgumentException("Accelerators are only supported with regional server groups if the zones are specified by the user.");
        }
    }

    protected InstanceProperties buildInstancePropertiesFromInput(BasicGoogleDeployDescription description, String machineTypeName, List<AttachedDisk> attachedDisks, NetworkInterface networkInterface, Metadata metadata, Tags tags, List<ServiceAccount> serviceAccounts, Scheduling scheduling, Map<String, String> labels) {
        return new InstanceProperties().setMachineType(machineTypeName).setDisks(attachedDisks).setGuestAccelerators(description.getAcceleratorConfigs() != null && !description.getAcceleratorConfigs().isEmpty() ? description.getAcceleratorConfigs() : Collections.emptyList()).setNetworkInterfaces(List.of(networkInterface)).setCanIpForward(description.getCanIpForward()).setMetadata(metadata).setTags(tags).setLabels(labels).setScheduling(scheduling).setServiceAccounts(serviceAccounts).setResourceManagerTags(description.getResourceManagerTags()).setPartnerMetadata(description.getPartnerMetadata());
    }

    protected void addShieldedVmConfigToInstanceProperties(BasicGoogleDeployDescription description, InstanceProperties instanceProperties, Image bootImage) {
        if (GCEUtil.isShieldedVmCompatible(bootImage)) {
            instanceProperties.setShieldedVmConfig(GCEUtil.buildShieldedVmConfig(description));
        }
    }

    protected void addMinCpuPlatformToInstanceProperties(BasicGoogleDeployDescription description, InstanceProperties instanceProperties) {
        if (StringUtils.isNotBlank((CharSequence)description.getMinCpuPlatform())) {
            instanceProperties.setMinCpuPlatform(description.getMinCpuPlatform());
        }
    }

    protected InstanceTemplate buildInstanceTemplate(String name, InstanceProperties properties) {
        return new InstanceTemplate().setName(name).setProperties(properties);
    }

    protected void setCapacityFromInput(BasicGoogleDeployDescription description) {
        if (description.getCapacity() != null) {
            description.setTargetSize(description.getCapacity().getDesired());
        }
    }

    protected void setAutoscalerCapacityFromInput(BasicGoogleDeployDescription description) {
        if (this.autoscalerIsSpecified(description)) {
            if (description.getCapacity() != null) {
                description.getAutoscalingPolicy().setMinNumReplicas(description.getCapacity().getMin());
                description.getAutoscalingPolicy().setMaxNumReplicas(description.getCapacity().getMax());
            }
            GCEUtil.calibrateTargetSizeWithAutoscaler(description);
        }
    }

    protected boolean autoscalerIsSpecified(BasicGoogleDeployDescription description) {
        return description.getAutoscalingPolicy() != null && (description.getAutoscalingPolicy().getCpuUtilization() != null || description.getAutoscalingPolicy().getLoadBalancingUtilization() != null || description.getAutoscalingPolicy().getCustomMetricUtilizations() != null || description.getAutoscalingPolicy().getScalingSchedules() != null);
    }

    protected void setCapacityFromSource(BasicGoogleDeployDescription description, Task task) {
        BasicGoogleDeployDescription.Source source = description.getSource();
        if (source != null && source.getUseSourceCapacity() != null && source.getUseSourceCapacity().booleanValue() && StringUtils.isNotBlank((CharSequence)source.getRegion()) && StringUtils.isNotBlank((CharSequence)source.getServerGroupName())) {
            task.updateStatus(BASE_PHASE, String.format("Looking up server group %s in %s in order to copy the current capacity...", source.getServerGroupName(), source.getRegion()));
            GoogleServerGroup.View ancestorServerGroup = GCEUtil.queryServerGroup(this.googleClusterProvider, description.getAccountName(), source.getRegion(), source.getServerGroupName());
            description.setTargetSize(ancestorServerGroup.getCapacity().getDesired());
            description.setAutoscalingPolicy(ancestorServerGroup.getAutoscalingPolicy());
        }
    }

    protected List<InstanceGroupManagerAutoHealingPolicy> buildAutoHealingPolicyFromInput(BasicGoogleDeployDescription description, Task task) {
        GoogleHealthCheck autoHealingHealthCheck = null;
        if (description.getAutoHealingPolicy() != null && StringUtils.isNotBlank((CharSequence)description.getAutoHealingPolicy().getHealthCheck())) {
            autoHealingHealthCheck = (GoogleHealthCheck)GCEUtil.queryHealthCheck(description.getCredentials().getProject(), description.getAccountName(), description.getAutoHealingPolicy().getHealthCheck(), description.getAutoHealingPolicy().getHealthCheckKind(), description.getCredentials().getCompute(), this.cacheView, task, BASE_PHASE, this);
        }
        List<InstanceGroupManagerAutoHealingPolicy> autoHealingPolicy = null;
        if (autoHealingHealthCheck != null) {
            InstanceGroupManagerAutoHealingPolicy policy = new InstanceGroupManagerAutoHealingPolicy();
            policy.setHealthCheck(autoHealingHealthCheck.getSelfLink());
            policy.setInitialDelaySec(description.getAutoHealingPolicy().getInitialDelaySec());
            autoHealingPolicy = List.of(policy);
        }
        if (autoHealingPolicy != null && description.getAutoHealingPolicy().getMaxUnavailable() != null) {
            FixedOrPercent maxUnavailable = new FixedOrPercent();
            maxUnavailable.setFixed(Integer.valueOf(description.getAutoHealingPolicy().getMaxUnavailable().getFixed().intValue()));
            maxUnavailable.setPercent(Integer.valueOf(description.getAutoHealingPolicy().getMaxUnavailable().getPercent().intValue()));
            autoHealingPolicy.get(0).set("maxUnavailable", (Object)maxUnavailable);
        }
        return autoHealingPolicy;
    }

    protected InstanceGroupManager buildInstanceGroupFromInput(BasicGoogleDeployDescription description, String serverGroupName, String instanceTemplateUrl, List<String> targetPools, List<InstanceGroupManagerAutoHealingPolicy> autoHealingPolicy) {
        return new InstanceGroupManager().setName(serverGroupName).setBaseInstanceName(serverGroupName).setInstanceTemplate(instanceTemplateUrl).setTargetSize(description.getTargetSize()).setTargetPools(targetPools).setAutoHealingPolicies(autoHealingPolicy);
    }

    protected void setNamedPortsToInstanceGroup(BasicGoogleDeployDescription description, LoadBalancerInfo lbInfo, InstanceGroupManager instanceGroupManager) {
        if ((this.hasBackedServiceFromInput(description, lbInfo) || !lbInfo.internalHttpLoadBalancers.isEmpty()) && (description.getLoadBalancingPolicy() != null || description.getSource() != null && StringUtils.isNotBlank((CharSequence)description.getSource().getServerGroupName()))) {
            List<Object> namedPorts = new ArrayList();
            String sourceGroupName = description.getSource().getServerGroupName();
            if (StringUtils.isNotBlank((CharSequence)sourceGroupName) && description.getLoadBalancingPolicy() == null) {
                GoogleServerGroup.View sourceServerGroup = this.googleClusterProvider.getServerGroup(description.getAccountName(), description.getSource().getRegion(), sourceGroupName);
                if (sourceServerGroup == null) {
                    log.warn(String.format("Could not locate source server group %s to update named port.", sourceGroupName));
                } else {
                    namedPorts = sourceServerGroup.getNamedPorts().entrySet().stream().map(entry -> new NamedPort().setName((String)entry.getKey()).setPort((Integer)entry.getValue())).collect(Collectors.toList());
                }
            } else if (description.getLoadBalancingPolicy().getNamedPorts() != null) {
                namedPorts = description.getLoadBalancingPolicy().getNamedPorts();
            } else if (description.getLoadBalancingPolicy().getListeningPort() != null) {
                log.warn("Deriving named ports from deprecated 'listeningPort' attribute. Please update your deploy description to use 'namedPorts'.");
                namedPorts.add(new NamedPort().setName("http").setPort(description.getLoadBalancingPolicy().getListeningPort()));
            }
            if (namedPorts.isEmpty()) {
                log.warn("Could not locate named port on either load balancing policy or source server group. Setting default named port.");
                namedPorts.add(new NamedPort().setName("http").setPort(GoogleHttpLoadBalancingPolicy.getHTTP_DEFAULT_PORT()));
            }
            instanceGroupManager.setNamedPorts(namedPorts);
        }
    }

    protected void createInstanceGroupManagerFromInput(BasicGoogleDeployDescription description, InstanceGroupManager instanceGroupManager, LoadBalancerInfo lbInfo, String serverGroupName, String region, Task task) throws IOException {
        if (description.getRegional().booleanValue()) {
            this.setDistributionPolicyToInstanceGroup(description, instanceGroupManager);
            String targetLink = this.createRegionalInstanceGroupManagerAndWait(description, lbInfo, serverGroupName, region, instanceGroupManager, task);
            this.createRegionalAutoscaler(description, serverGroupName, targetLink, region, task);
        } else {
            String targetLink = this.createInstanceGroupManagerAndWait(description, lbInfo, serverGroupName, instanceGroupManager, task);
            this.createAutoscaler(description, serverGroupName, targetLink, task);
        }
    }

    protected void setDistributionPolicyToInstanceGroup(BasicGoogleDeployDescription description, InstanceGroupManager instanceGroupManager) {
        if (description.getDistributionPolicy() != null) {
            DistributionPolicy distributionPolicy = new DistributionPolicy();
            if (description.getSelectZones().booleanValue() && !description.getDistributionPolicy().getZones().isEmpty()) {
                log.info(String.format("Configuring explicit zones selected for regional server group: %s", String.join((CharSequence)", ", description.getDistributionPolicy().getZones())));
                List selectedZones = description.getDistributionPolicy().getZones().stream().map(it -> new DistributionPolicyZoneConfiguration().setZone(GCEUtil.buildZoneUrl(description.getCredentials().getProject(), it))).collect(Collectors.toList());
                distributionPolicy.setZones(selectedZones);
            }
            if (StringUtils.isNotBlank((CharSequence)description.getDistributionPolicy().getTargetShape())) {
                distributionPolicy.setTargetShape(description.getDistributionPolicy().getTargetShape());
            }
            if (!distributionPolicy.getZones().isEmpty() || StringUtils.isNotBlank((CharSequence)distributionPolicy.getTargetShape())) {
                instanceGroupManager.setDistributionPolicy(distributionPolicy);
            }
        }
    }

    private void updateBackendServices(BasicGoogleDeployDescription description, LoadBalancerInfo lbInfo, String serverGroupName, List<BackendService> backendServicesToUpdate, Task task) {
        if (!description.getDisableTraffic().booleanValue() && this.hasBackedServiceFromInput(description, lbInfo)) {
            backendServicesToUpdate.forEach(backendService -> {
                this.safeRetry.doRetry(this.updateBackendServices(description.getCredentials().getCompute(), description.getCredentials().getProject(), backendService.getName(), (BackendService)backendService), "Load balancer backend service", task, List.of(Integer.valueOf(400), Integer.valueOf(412)), Collections.emptyList(), Map.of("action", "update", "phase", BASE_PHASE, "operation", "updateBackendServices", TAG_SCOPE, SCOPE_GLOBAL), this.registry);
                task.updateStatus(BASE_PHASE, String.format("Done associating server group %s with backend service %s.", serverGroupName, backendService.getName()));
            });
        }
    }

    private void updateRegionalBackendServices(BasicGoogleDeployDescription description, LoadBalancerInfo lbInfo, String serverGroupName, String region, List<BackendService> regionBackendServicesToUpdate, Task task) {
        if (!(description.getDisableTraffic().booleanValue() || lbInfo.internalLoadBalancers.isEmpty() && lbInfo.internalHttpLoadBalancers.isEmpty())) {
            regionBackendServicesToUpdate.forEach(backendService -> {
                this.safeRetry.doRetry(this.updateBackendServices(description.getCredentials().getCompute(), description.getCredentials().getProject(), backendService.getName(), (BackendService)backendService, region), "Internal load balancer backend service", task, List.of(Integer.valueOf(400), Integer.valueOf(412)), Collections.emptyList(), Map.of("action", "update", "phase", BASE_PHASE, "operation", "updateRegionBackendServices", TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region), this.registry);
                task.updateStatus(BASE_PHASE, String.format("Done associating server group %s with backend service %s.", serverGroupName, backendService.getName()));
            });
        }
    }

    protected BackendService getBackendServiceFromProvider(GoogleNamedAccountCredentials credentials, String backendServiceName) throws IOException {
        return (BackendService)this.timeExecute((AbstractGoogleClientRequest)credentials.getCompute().backendServices().get(credentials.getProject(), backendServiceName), "compute.backendServices.get", new String[]{TAG_SCOPE, SCOPE_GLOBAL});
    }

    protected BackendService getRegionBackendServiceFromProvider(GoogleNamedAccountCredentials credentials, String region, String backendServiceName) throws IOException {
        return (BackendService)this.timeExecute((AbstractGoogleClientRequest)credentials.getCompute().regionBackendServices().get(credentials.getProject(), region, backendServiceName), "compute.regionBackendServices.get", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
    }

    private String createInstanceTemplateAndWait(GoogleNamedAccountCredentials credentials, InstanceTemplate template, Task task) throws IOException {
        Operation instanceTemplateCreateOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)credentials.getCompute().instanceTemplates().insert(credentials.getProject(), template), "compute.instanceTemplates.insert", new String[]{TAG_SCOPE, SCOPE_GLOBAL});
        String instanceTemplateUrl = instanceTemplateCreateOperation.getTargetLink();
        this.googleOperationPoller.waitForGlobalOperation(credentials.getCompute(), credentials.getProject(), instanceTemplateCreateOperation.getName(), null, task, "instance template " + GCEUtil.getLocalName(instanceTemplateUrl), BASE_PHASE);
        return instanceTemplateUrl;
    }

    protected String createRegionalInstanceGroupManagerAndWait(BasicGoogleDeployDescription description, LoadBalancerInfo lbInfo, String serverGroupName, String region, InstanceGroupManager instanceGroupManager, Task task) throws IOException {
        Operation migCreateOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)description.getCredentials().getCompute().regionInstanceGroupManagers().insert(description.getCredentials().getProject(), region, instanceGroupManager), "compute.regionInstanceGroupManagers.insert", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
        if (!description.getDisableTraffic().booleanValue() && this.hasBackedServiceFromInput(description, lbInfo) || this.autoscalerIsSpecified(description) || !description.getDisableTraffic().booleanValue() && (!lbInfo.internalLoadBalancers.isEmpty() || !lbInfo.internalHttpLoadBalancers.isEmpty())) {
            this.googleOperationPoller.waitForRegionalOperation(description.getCredentials().getCompute(), description.getCredentials().getProject(), region, migCreateOperation.getName(), null, task, String.format("managed instance group %s", serverGroupName), BASE_PHASE);
        }
        return migCreateOperation.getTargetLink();
    }

    protected void createRegionalAutoscaler(BasicGoogleDeployDescription description, String serverGroupName, String targetLink, String region, Task task) throws IOException {
        if (this.autoscalerIsSpecified(description)) {
            task.updateStatus(BASE_PHASE, String.format("Creating regional autoscaler for %s...", serverGroupName));
            Autoscaler autoscaler = GCEUtil.buildAutoscaler(serverGroupName, targetLink, description.getAutoscalingPolicy());
            this.timeExecute((AbstractGoogleClientRequest)description.getCredentials().getCompute().regionAutoscalers().insert(description.getCredentials().getProject(), region, autoscaler), "compute.regionAutoscalers.insert", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
        }
    }

    protected String createInstanceGroupManagerAndWait(BasicGoogleDeployDescription description, LoadBalancerInfo lbInfo, String serverGroupName, InstanceGroupManager instanceGroupManager, Task task) throws IOException {
        Operation createOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)description.getCredentials().getCompute().instanceGroupManagers().insert(description.getCredentials().getProject(), description.getZone(), instanceGroupManager), "compute.instanceGroupManagers.insert", new String[]{TAG_SCOPE, SCOPE_ZONAL, TAG_ZONE, description.getZone()});
        if (!description.getDisableTraffic().booleanValue() && this.hasBackedServiceFromInput(description, lbInfo) || this.autoscalerIsSpecified(description) || !description.getDisableTraffic().booleanValue() && (!lbInfo.internalLoadBalancers.isEmpty() || !lbInfo.internalHttpLoadBalancers.isEmpty())) {
            this.googleOperationPoller.waitForZonalOperation(description.getCredentials().getCompute(), description.getCredentials().getProject(), description.getZone(), createOperation.getName(), null, task, String.format("managed instance group %s", serverGroupName), BASE_PHASE);
        }
        return createOperation.getTargetLink();
    }

    protected void createAutoscaler(BasicGoogleDeployDescription description, String serverGroupName, String targetLink, Task task) throws IOException {
        if (this.autoscalerIsSpecified(description)) {
            task.updateStatus(BASE_PHASE, String.format("Creating zonal autoscaler for %s...", serverGroupName));
            Autoscaler autoscaler = GCEUtil.buildAutoscaler(serverGroupName, targetLink, description.getAutoscalingPolicy());
            this.timeExecute((AbstractGoogleClientRequest)description.getCredentials().getCompute().autoscalers().insert(description.getCredentials().getProject(), description.getZone(), autoscaler), "compute.autoscalers.insert", new String[]{TAG_SCOPE, SCOPE_ZONAL, TAG_ZONE, description.getZone()});
        }
    }

    private Closure updateBackendServices(final Compute compute, final String project, final String backendServiceName, final BackendService backendService) {
        return new Closure<Object>((Object)this, (Object)this){

            public Object call() {
                BackendService serviceToUpdate = null;
                try {
                    serviceToUpdate = (BackendService)BasicGoogleDeployHandler.this.timeExecute((AbstractGoogleClientRequest)compute.backendServices().get(project, backendServiceName), "compute.backendServices.get", new String[]{GoogleExecutorTraits.TAG_SCOPE, GoogleExecutorTraits.SCOPE_GLOBAL});
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                if (serviceToUpdate.getBackends() == null) {
                    serviceToUpdate.setBackends(new ArrayList());
                }
                BackendService finalServiceToUpdate = serviceToUpdate;
                backendService.getBackends().forEach(it -> finalServiceToUpdate.getBackends().add(it));
                HashSet seenGroup = new HashSet();
                serviceToUpdate.getBackends().stream().filter(backend -> seenGroup.add(backend.getGroup())).collect(Collectors.toList());
                try {
                    BasicGoogleDeployHandler.this.timeExecute((AbstractGoogleClientRequest)compute.backendServices().update(project, backendServiceName, serviceToUpdate), "compute.backendServices.update", new String[]{GoogleExecutorTraits.TAG_SCOPE, GoogleExecutorTraits.SCOPE_GLOBAL});
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                return null;
            }
        };
    }

    private Closure updateBackendServices(final Compute compute, final String project, final String backendServiceName, final BackendService backendService, String region) {
        return new Closure<Object>((Object)this, (Object)this){

            public Object call() {
                BackendService serviceToUpdate = null;
                try {
                    serviceToUpdate = (BackendService)BasicGoogleDeployHandler.this.timeExecute((AbstractGoogleClientRequest)compute.backendServices().get(project, backendServiceName), "compute.regionBackendServices.get", new String[]{GoogleExecutorTraits.TAG_SCOPE, GoogleExecutorTraits.SCOPE_GLOBAL});
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                if (serviceToUpdate.getBackends() == null) {
                    serviceToUpdate.setBackends(new ArrayList());
                }
                BackendService finalServiceToUpdate = serviceToUpdate;
                backendService.getBackends().forEach(it -> finalServiceToUpdate.getBackends().add(it));
                HashSet seenGroup = new HashSet();
                serviceToUpdate.getBackends().stream().filter(backend -> seenGroup.add(backend.getGroup())).collect(Collectors.toList());
                try {
                    BasicGoogleDeployHandler.this.timeExecute((AbstractGoogleClientRequest)compute.backendServices().update(project, backendServiceName, serviceToUpdate), "compute.regionBackendServices.update", new String[]{GoogleExecutorTraits.TAG_SCOPE, GoogleExecutorTraits.SCOPE_GLOBAL});
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                return null;
            }
        };
    }

    public boolean handles(DeployDescription description) {
        return description instanceof BasicGoogleDeployDescription;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    class LoadBalancerInfo {
        List<String> targetPools = new ArrayList<String>();
        List<GoogleLoadBalancerView> internalLoadBalancers = new ArrayList<GoogleLoadBalancerView>();
        List<GoogleLoadBalancerView> internalHttpLoadBalancers = new ArrayList<GoogleLoadBalancerView>();
        List<GoogleLoadBalancerView> sslLoadBalancers = new ArrayList<GoogleLoadBalancerView>();
        List<GoogleLoadBalancerView> tcpLoadBalancers = new ArrayList<GoogleLoadBalancerView>();

        @Generated
        public LoadBalancerInfo() {
        }

        @Generated
        public List<String> getTargetPools() {
            return this.targetPools;
        }

        @Generated
        public List<GoogleLoadBalancerView> getInternalLoadBalancers() {
            return this.internalLoadBalancers;
        }

        @Generated
        public List<GoogleLoadBalancerView> getInternalHttpLoadBalancers() {
            return this.internalHttpLoadBalancers;
        }

        @Generated
        public List<GoogleLoadBalancerView> getSslLoadBalancers() {
            return this.sslLoadBalancers;
        }

        @Generated
        public List<GoogleLoadBalancerView> getTcpLoadBalancers() {
            return this.tcpLoadBalancers;
        }

        @Generated
        public LoadBalancerInfo setTargetPools(List<String> targetPools) {
            this.targetPools = targetPools;
            return this;
        }

        @Generated
        public LoadBalancerInfo setInternalLoadBalancers(List<GoogleLoadBalancerView> internalLoadBalancers) {
            this.internalLoadBalancers = internalLoadBalancers;
            return this;
        }

        @Generated
        public LoadBalancerInfo setInternalHttpLoadBalancers(List<GoogleLoadBalancerView> internalHttpLoadBalancers) {
            this.internalHttpLoadBalancers = internalHttpLoadBalancers;
            return this;
        }

        @Generated
        public LoadBalancerInfo setSslLoadBalancers(List<GoogleLoadBalancerView> sslLoadBalancers) {
            this.sslLoadBalancers = sslLoadBalancers;
            return this;
        }

        @Generated
        public LoadBalancerInfo setTcpLoadBalancers(List<GoogleLoadBalancerView> tcpLoadBalancers) {
            this.tcpLoadBalancers = tcpLoadBalancers;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoadBalancerInfo)) {
                return false;
            }
            LoadBalancerInfo other = (LoadBalancerInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$targetPools = this.getTargetPools();
            List<String> other$targetPools = other.getTargetPools();
            if (this$targetPools == null ? other$targetPools != null : !((Object)this$targetPools).equals(other$targetPools)) {
                return false;
            }
            List<GoogleLoadBalancerView> this$internalLoadBalancers = this.getInternalLoadBalancers();
            List<GoogleLoadBalancerView> other$internalLoadBalancers = other.getInternalLoadBalancers();
            if (this$internalLoadBalancers == null ? other$internalLoadBalancers != null : !((Object)this$internalLoadBalancers).equals(other$internalLoadBalancers)) {
                return false;
            }
            List<GoogleLoadBalancerView> this$internalHttpLoadBalancers = this.getInternalHttpLoadBalancers();
            List<GoogleLoadBalancerView> other$internalHttpLoadBalancers = other.getInternalHttpLoadBalancers();
            if (this$internalHttpLoadBalancers == null ? other$internalHttpLoadBalancers != null : !((Object)this$internalHttpLoadBalancers).equals(other$internalHttpLoadBalancers)) {
                return false;
            }
            List<GoogleLoadBalancerView> this$sslLoadBalancers = this.getSslLoadBalancers();
            List<GoogleLoadBalancerView> other$sslLoadBalancers = other.getSslLoadBalancers();
            if (this$sslLoadBalancers == null ? other$sslLoadBalancers != null : !((Object)this$sslLoadBalancers).equals(other$sslLoadBalancers)) {
                return false;
            }
            List<GoogleLoadBalancerView> this$tcpLoadBalancers = this.getTcpLoadBalancers();
            List<GoogleLoadBalancerView> other$tcpLoadBalancers = other.getTcpLoadBalancers();
            return !(this$tcpLoadBalancers == null ? other$tcpLoadBalancers != null : !((Object)this$tcpLoadBalancers).equals(other$tcpLoadBalancers));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoadBalancerInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $targetPools = this.getTargetPools();
            result = result * 59 + ($targetPools == null ? 43 : ((Object)$targetPools).hashCode());
            List<GoogleLoadBalancerView> $internalLoadBalancers = this.getInternalLoadBalancers();
            result = result * 59 + ($internalLoadBalancers == null ? 43 : ((Object)$internalLoadBalancers).hashCode());
            List<GoogleLoadBalancerView> $internalHttpLoadBalancers = this.getInternalHttpLoadBalancers();
            result = result * 59 + ($internalHttpLoadBalancers == null ? 43 : ((Object)$internalHttpLoadBalancers).hashCode());
            List<GoogleLoadBalancerView> $sslLoadBalancers = this.getSslLoadBalancers();
            result = result * 59 + ($sslLoadBalancers == null ? 43 : ((Object)$sslLoadBalancers).hashCode());
            List<GoogleLoadBalancerView> $tcpLoadBalancers = this.getTcpLoadBalancers();
            result = result * 59 + ($tcpLoadBalancers == null ? 43 : ((Object)$tcpLoadBalancers).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BasicGoogleDeployHandler.LoadBalancerInfo(targetPools=" + String.valueOf(this.getTargetPools()) + ", internalLoadBalancers=" + String.valueOf(this.getInternalLoadBalancers()) + ", internalHttpLoadBalancers=" + String.valueOf(this.getInternalHttpLoadBalancers()) + ", sslLoadBalancers=" + String.valueOf(this.getSslLoadBalancers()) + ", tcpLoadBalancers=" + String.valueOf(this.getTcpLoadBalancers()) + ")";
        }
    }

    static class GoogleInstanceTemplate
    implements GoogleLabeledResource {
        Map<String, String> labels;

        GoogleInstanceTemplate() {
        }

        @Override
        public Map<String, String> getLabels() {
            return this.labels;
        }
    }
}

