/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.compute.model.InstanceGroupManagersSetTargetPoolsRequest;
import com.google.api.services.compute.model.InstanceGroupsListInstancesRequest;
import com.google.api.services.compute.model.InstanceReference;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.ManagedInstance;
import com.google.api.services.compute.model.RegionInstanceGroupManagersSetTargetPoolsRequest;
import com.google.api.services.compute.model.RegionInstanceGroupsListInstancesRequest;
import com.google.api.services.compute.model.TargetPool;
import com.google.api.services.compute.model.TargetPoolsAddInstanceRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.consul.deploy.ops.EnableDisableConsulInstance;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.EnableDisableGoogleServerGroupDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoscalingPolicy;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleLoadBalancerProvider;
import com.netflix.spinnaker.kork.client.ServiceClientProvider;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractEnableDisableAtomicOperation
extends GoogleAtomicOperation<Void> {
    private static final List<Integer> RETRY_ERROR_CODES;
    private static final List<Integer> SUCCESSFUL_ERROR_CODES;
    private EnableDisableGoogleServerGroupDescription description;
    @Autowired
    private GoogleClusterProvider googleClusterProvider;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private GoogleLoadBalancerProvider googleLoadBalancerProvider;
    @Autowired
    private SafeRetry safeRetry;
    @Autowired
    private ServiceClientProvider serviceClientProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AbstractEnableDisableAtomicOperation(EnableDisableGoogleServerGroupDescription description) {
        EnableDisableGoogleServerGroupDescription enableDisableGoogleServerGroupDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = enableDisableGoogleServerGroupDescription = description;
    }

    public abstract boolean isDisable();

    public abstract String getPhaseName();

    public Void operate(List priorOutputs) {
        String verb = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "disable", 12, this)) != false ? "disable" : "enable";
        String presentParticipling = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "disable", 12, this)) != false ? "Disabling" : "Enabling";
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{verb, IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description)}, new String[]{"Initializing ", " server group operation for ", " in "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "region", 4, this.description)}, new String[]{"", "..."})));
        CallSite accountName = IndyInterface.bootstrap("getProperty", "accountName", 4, this.description);
        Reference credentials = new Reference((Object)IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        Reference compute = new Reference((Object)IndyInterface.bootstrap("getProperty", "compute", 0, credentials.get()));
        Reference project = new Reference((Object)IndyInterface.bootstrap("getProperty", "project", 0, credentials.get()));
        Reference region = new Reference((Object)IndyInterface.bootstrap("getProperty", "region", 4, this.description));
        Reference serverGroupName = new Reference((Object)IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description));
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "queryServerGroup", 0, GCEUtil.class, this.googleClusterProvider, accountName, region.get(), serverGroupName.get());
        CallSite isRegional = IndyInterface.bootstrap("getProperty", "regional", 0, serverGroup);
        CallSite zone = IndyInterface.bootstrap("getProperty", "zone", 0, serverGroup);
        CallSite managedInstanceGroup = IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? IndyInterface.bootstrap("invoke", "queryRegionalManagedInstanceGroup", 0, GCEUtil.class, project.get(), region.get(), serverGroupName.get(), credentials.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), this.safeRetry, this) : IndyInterface.bootstrap("invoke", "queryZonalManagedInstanceGroup", 0, GCEUtil.class, project.get(), zone, serverGroupName.get(), credentials.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), this.safeRetry, this);
        CallSite currentTargetPoolUrls = IndyInterface.bootstrap("invoke", "getTargetPools", 0, managedInstanceGroup);
        Object newTargetPoolUrls = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "enabled", 1, IndyInterface.bootstrap("getProperty", "consulConfig", 0, credentials.get()))) != false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), new GStringImpl(new Object[]{presentParticipling}, new String[]{"", " server group in Consul..."}));
            CallSite instances = null;
            instances = IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? IndyInterface.bootstrap("invoke", "getManagedInstances", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "listManagedInstances", 0, IndyInterface.bootstrap("invoke", "regionInstanceGroupManagers", 0, compute.get()), project.get(), region.get(), serverGroupName.get()), "compute.regionInstanceGroupManagers.listManagedInstances", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region.get())) : IndyInterface.bootstrap("invoke", "getManagedInstances", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "listManagedInstances", 0, IndyInterface.bootstrap("invoke", "instanceGroupManagers", 0, compute.get()), project.get(), zone, serverGroupName.get()), "compute.instanceGroupManagers.listManagedInstances", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), zone));
            public final class _operate_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference credentials;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure1(Object _outerInstance, Object _thisObject, Reference credentials) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.credentials = reference = credentials;
                }

                public Object doCall(ManagedInstance instance) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "operate", 0, EnableDisableConsulInstance.class, IndyInterface.bootstrap("getProperty", "consulConfig", 0, this.credentials.get()), IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getInstance", 0, instance)), IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "disable", 12, this)) != false ? IndyInterface.bootstrap("getProperty", "disable", 0, EnableDisableConsulInstance.State.class) : IndyInterface.bootstrap("getProperty", "enable", 0, EnableDisableConsulInstance.State.class), IndyInterface.bootstrap("getProperty", "serviceClientProvider", 12, this));
                    try {
                        return callSite;
                    }
                    catch (SpinnakerServerException ignored) {
                        Object var4_4 = null;
                        return var4_4;
                    }
                }

                @Generated
                public Object call(ManagedInstance instance) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, instance);
                }

                @Generated
                public Object getCredentials() {
                    return this.credentials.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, instances, new _operate_closure1(this, this, credentials));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "disable", 12, this)) != false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Disabling autoscaling for server group disable...");
            IndyInterface.bootstrap("invoke", "setAutoscalingPolicyMode", 2, this, compute.get(), project.get(), serverGroup, IndyInterface.bootstrap("getProperty", "OFF", 0, GoogleAutoscalingPolicy.AutoscalingMode.class));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Deregistering server group from Http(s) load balancers...");
            IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "destroyHttpLoadBalancerBackends", 2, this, compute.get(), project.get(), serverGroup, this.googleLoadBalancerProvider, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this)), "Http load balancer backends", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, SUCCESSFUL_ERROR_CODES, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "destroyHttpLoadBalancerBackends", "action", "destroy", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Deregistering server group from Internal Http(s) load balancers...");
            IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "destroyInternalHttpLoadBalancerBackends", 2, this, compute.get(), project.get(), serverGroup, this.googleLoadBalancerProvider, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this)), "Internal Http load balancer backends", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, SUCCESSFUL_ERROR_CODES, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "destroyInternalHttpLoadBalancerBackends", "action", "destroy", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region.get()}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Deregistering server group from internal load balancers...");
            IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "destroyInternalLoadBalancerBackends", 2, this, compute.get(), project.get(), serverGroup, this.googleLoadBalancerProvider, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this)), "Internal load balancer backends", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, SUCCESSFUL_ERROR_CODES, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "destroyInternalLoadBalancerBackends", "action", "destroy", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Deregistering server group from ssl load balancers...");
            IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "destroySslLoadBalancerBackends", 2, this, compute.get(), project.get(), serverGroup, this.googleLoadBalancerProvider, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this)), "Ssl load balancer backends", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, SUCCESSFUL_ERROR_CODES, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "destroySslLoadBalancerBackends", "action", "destroy", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Deregistering server group from tcp load balancers...");
            IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "destroyTcpLoadBalancerBackends", 2, this, compute.get(), project.get(), serverGroup, this.googleLoadBalancerProvider, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this)), "Tcp load balancer backends", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, SUCCESSFUL_ERROR_CODES, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "destroyTcpLoadBalancerBackends", "action", "destroy", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Deregistering server group from network load balancers...");
            public final class _operate_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference serverGroupName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure2(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference serverGroupName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.compute = reference4 = compute;
                    this.project = reference3 = project;
                    this.region = reference2 = region;
                    this.serverGroupName = reference = serverGroupName;
                }

                public Object doCall(Object targetPoolUrl) {
                    CallSite targetPoolLocalName = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, targetPoolUrl);
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), new GStringImpl(new Object[]{targetPoolLocalName}, new String[]{"Deregistering instances from ", "..."}));
                    TargetPool targetPool = (TargetPool)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "doRetry", 0, IndyInterface.bootstrap("getProperty", "safeRetry", 12, this), IndyInterface.bootstrap("invoke", "getTargetPool", 2, this, this.compute.get(), this.project.get(), this.region.get(), targetPoolLocalName), "target pool", IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "RETRY_ERROR_CODES", 0, AbstractEnableDisableAtomicOperation.class), ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "getTargetPool", "action", "destroy", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get()}), IndyInterface.bootstrap("getProperty", "registry", 12, this)), TargetPool.class);
                    CallSite instanceUrls = IndyInterface.bootstrap("invoke", "getInstances", 0, targetPool);
                    public final class _closure23
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference serverGroupName;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure23(Object _outerInstance, Object _thisObject, Reference serverGroupName) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.serverGroupName = reference = serverGroupName;
                        }

                        public Object doCall(Object instanceUrl) {
                            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, instanceUrl), new GStringImpl(new Object[]{this.serverGroupName.get()}, new String[]{"", "-"}))) != false ? IndyInterface.bootstrap("init", "<init>", 0, InstanceReference.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instance", instanceUrl})) : null;
                        }

                        @Generated
                        public Object getServerGroupName() {
                            return this.serverGroupName.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure23.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite instanceReferencesToRemove = IndyInterface.bootstrap("invoke", "findResults", 1, instanceUrls, new _closure23((Object)this, this.getThisObject(), this.serverGroupName));
                    if (IndyInterface.bootstrap("cast", "()", 0, instanceReferencesToRemove) != false) {
                        CallSite targetPoolsRemoveInstanceRequest = IndyInterface.bootstrap("init", "<init>", 0, TargetPoolsRemoveInstanceRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instances", instanceReferencesToRemove}));
                        return IndyInterface.bootstrap("invoke", "doRetry", 0, IndyInterface.bootstrap("getProperty", "safeRetry", 12, this), IndyInterface.bootstrap("invoke", "removeInstancesFromTargetPool", 2, this, this.compute.get(), this.project.get(), this.region.get(), targetPoolLocalName, targetPoolsRemoveInstanceRequest), "instances", IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "RETRY_ERROR_CODES", 0, AbstractEnableDisableAtomicOperation.class), ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "removeInstancesFromTargetPool", "action", "deregister", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get()}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
                    }
                    return null;
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getRegion() {
                    return this.region.get();
                }

                @Generated
                public Object getServerGroupName() {
                    return this.serverGroupName.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, currentTargetPoolUrls, new _operate_closure2(this, this, compute, project, region, serverGroupName));
        } else {
            CallSite instanceTemplateUrl = IndyInterface.bootstrap("invoke", "getInstanceTemplate", 0, managedInstanceGroup);
            InstanceTemplate instanceTemplate = (InstanceTemplate)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "getInstanceTemplate", 2, this, compute.get(), project.get(), instanceTemplateUrl), "instance template", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "getInstanceTemplate", "action", "get", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this)), InstanceTemplate.class);
            CallSite metadataItems = IndyInterface.bootstrap("getProperty", "items", 1, IndyInterface.bootstrap("getProperty", "metadata", 1, IndyInterface.bootstrap("getProperty", "properties", 1, instanceTemplate)));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Re-enabling autoscaling for server group enable...");
            CallSite metadataMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildMapFromMetadata", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "metadata", 1, IndyInterface.bootstrap("getProperty", "properties", 1, instanceTemplate))));
            CallSite autoscalerJson = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getPropertySafe(AbstractEnableDisableAtomicOperation.class, (Object)metadataMap, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "AUTOSCALING_POLICY", 0, GCEUtil.class)))));
            if (IndyInterface.bootstrap("cast", "()", 0, autoscalerJson) != false) {
                CallSite autoscaler = IndyInterface.bootstrap("invoke", "readValue", 0, this.objectMapper, autoscalerJson, Map.class);
                CallSite callSite = IndyInterface.bootstrap("getProperty", "mode", 1, IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 1, autoscaler));
                CallSite enabledMode = IndyInterface.bootstrap("invoke", "valueOf", 0, GoogleAutoscalingPolicy.AutoscalingMode.class, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "ON");
                IndyInterface.bootstrap("invoke", "setAutoscalingPolicyMode", 2, this, compute.get(), project.get(), serverGroup, enabledMode);
            } else {
                IndyInterface.bootstrap("invoke", "setAutoscalingPolicyMode", 2, this, compute.get(), project.get(), serverGroup, IndyInterface.bootstrap("getProperty", "ON", 0, GoogleAutoscalingPolicy.AutoscalingMode.class));
            }
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Registering server group with Http(s) load balancers...");
            IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "addHttpLoadBalancerBackends", 2, this, compute.get(), this.objectMapper, project.get(), serverGroup, this.googleLoadBalancerProvider, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this)), "Http load balancer backends", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "addHttpLoadBalancerBackends", "action", "add", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Registering server group with Internal Http(s) load balancers...");
            IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "addInternalHttpLoadBalancerBackends", 2, this, compute.get(), this.objectMapper, project.get(), serverGroup, this.googleLoadBalancerProvider, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this)), "Internal Http load balancer backends", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "addInternalHttpLoadBalancerBackends", "action", "add", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region.get()}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Registering server group with Internal load balancers...");
            IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "addInternalLoadBalancerBackends", 2, this, compute.get(), project.get(), serverGroup, this.googleLoadBalancerProvider, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this)), "Internal load balancer backends", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "addInternalLoadbalancerBackends", "action", "add", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Registering server group with Ssl load balancers...");
            IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "addSslLoadBalancerBackends", 2, this, compute.get(), this.objectMapper, project.get(), serverGroup, this.googleLoadBalancerProvider, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this)), "Ssl load balancer backends", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "addSslLoadbalancerBackends", "action", "add", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Registering server group with Tcp load balancers...");
            IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "addTcpLoadBalancerBackends", 2, this, compute.get(), this.objectMapper, project.get(), serverGroup, this.googleLoadBalancerProvider, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this)), "Tcp load balancer backends", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "addTcpLoadbalancerBackends", "action", "add", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), "Registering instances with network load balancers...");
            CallSite groupInstances = IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "listInstancesInRegionalGroup", 2, this, compute.get(), project.get(), region.get(), serverGroupName.get(), IndyInterface.bootstrap("init", "<init>", 0, RegionInstanceGroupsListInstancesRequest.class)), "instances in regional group", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "listInstanesInRegionalGroup", "action", "list", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region.get()}), IndyInterface.bootstrap("getProperty", "registry", 12, this)) : IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, IndyInterface.bootstrap("invoke", "listInstancesInZonalGroup", 2, this, compute.get(), project.get(), zone, serverGroupName.get(), IndyInterface.bootstrap("init", "<init>", 0, InstanceGroupsListInstancesRequest.class)), "instances in zonal group", IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "listInstanesInZonalGroup", "action", "list", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), zone}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
            public final class _operate_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object groupInstance) {
                    return IndyInterface.bootstrap("init", "<init>", 0, InstanceReference.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instance", IndyInterface.bootstrap("getProperty", "instance", 0, groupInstance)}));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Reference instanceReferencesToAdd = new Reference((Object)IndyInterface.bootstrap("invoke", "collect", 0, groupInstances, new _operate_closure3(this, this)));
            Reference newForwardingRuleNames = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            public final class _operate_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference newForwardingRuleNames;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure4(Object _outerInstance, Object _thisObject, Reference newForwardingRuleNames) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.newForwardingRuleNames = reference = newForwardingRuleNames;
                }

                public Object doCall(Object item) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, item), (Object)"load-balancer-names")) {
                        List list = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("getProperty", "value", 0, item), ","), List.class));
                        this.newForwardingRuleNames.set((Object)list);
                        return list;
                    }
                    return null;
                }

                @Generated
                public Object getNewForwardingRuleNames() {
                    return this.newForwardingRuleNames.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, metadataItems, new _operate_closure4(this, this, newForwardingRuleNames));
            CallSite forwardingRules = IndyInterface.bootstrap("invoke", "queryRegionalForwardingRules", 0, GCEUtil.class, project.get(), region.get(), newForwardingRuleNames.get(), compute.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), this.safeRetry, this);
            public final class _operate_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object forwardingRule) {
                    return IndyInterface.bootstrap("getProperty", "target", 0, forwardingRule);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            newTargetPoolUrls = IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "collect", 0, forwardingRules, new _operate_closure5(this, this)), null);
            public final class _operate_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference instanceReferencesToAdd;
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference region;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure6(Object _outerInstance, Object _thisObject, Reference instanceReferencesToAdd, Reference compute, Reference project, Reference region) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.instanceReferencesToAdd = reference4 = instanceReferencesToAdd;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.region = reference = region;
                }

                public Object doCall(Object newTargetPoolUrl) {
                    CallSite targetPoolLocalName = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, newTargetPoolUrl);
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), new GStringImpl(new Object[]{targetPoolLocalName}, new String[]{"Registering instances with ", "..."}));
                    if (IndyInterface.bootstrap("cast", "()", 0, this.instanceReferencesToAdd.get()) != false) {
                        CallSite targetPoolsAddInstanceRequest = IndyInterface.bootstrap("init", "<init>", 0, TargetPoolsAddInstanceRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instances", this.instanceReferencesToAdd.get()}));
                        return IndyInterface.bootstrap("invoke", "doRetry", 0, IndyInterface.bootstrap("getProperty", "safeRetry", 12, this), IndyInterface.bootstrap("invoke", "addInstancesToTargetPool", 2, this, this.compute.get(), this.project.get(), this.region.get(), targetPoolLocalName, targetPoolsAddInstanceRequest), "instances", IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "RETRY_ERROR_CODES", 0, AbstractEnableDisableAtomicOperation.class), ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"operation", "addInstancesToTargetPool", "action", "register", "phase", IndyInterface.bootstrap("getProperty", "phaseName", 12, this), IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get()}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
                    }
                    return null;
                }

                @Generated
                public Object getInstanceReferencesToAdd() {
                    return this.instanceReferencesToAdd.get();
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getRegion() {
                    return this.region.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, newTargetPoolUrls, new _operate_closure6(this, this, instanceReferencesToAdd, compute, project, region));
            if (IndyInterface.bootstrap("cast", "()", 0, currentTargetPoolUrls) != false) {
                newTargetPoolUrls = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "plus", 0, (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, currentTargetPoolUrls, Set.class)), ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, newTargetPoolUrls, Set.class))), Set.class)), List.class));
            }
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), new GStringImpl(new Object[]{presentParticipling, IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description), region.get()}, new String[]{"", " server group ", " in ", "..."}));
        if (IndyInterface.bootstrap("cast", "()", 0, isRegional) != false) {
            CallSite instanceGroupManagersSetTargetPoolsRequest = IndyInterface.bootstrap("init", "<init>", 0, RegionInstanceGroupManagersSetTargetPoolsRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"targetPools", newTargetPoolUrls}));
            IndyInterface.bootstrap("invoke", "setFingerprint", 0, instanceGroupManagersSetTargetPoolsRequest, IndyInterface.bootstrap("invoke", "getFingerprint", 0, managedInstanceGroup));
            IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setTargetPools", 0, IndyInterface.bootstrap("invoke", "regionInstanceGroupManagers", 0, compute.get()), project.get(), region.get(), serverGroupName.get(), instanceGroupManagersSetTargetPoolsRequest), "compute.regionInstanceGroupManagers.setTargetPools", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region.get());
        } else {
            CallSite instanceGroupManagersSetTargetPoolsRequest = IndyInterface.bootstrap("init", "<init>", 0, InstanceGroupManagersSetTargetPoolsRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"targetPools", newTargetPoolUrls}));
            IndyInterface.bootstrap("invoke", "setFingerprint", 0, instanceGroupManagersSetTargetPoolsRequest, IndyInterface.bootstrap("invoke", "getFingerprint", 0, managedInstanceGroup));
            IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setTargetPools", 0, IndyInterface.bootstrap("invoke", "instanceGroupManagers", 0, compute.get()), project.get(), zone, serverGroupName.get(), instanceGroupManagersSetTargetPoolsRequest), "compute.regionInstanceGroupManagers.setTargetPools", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), zone);
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, presentParticipling), IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description), region.get()}, new String[]{"Done ", " server group ", " in ", "."}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroyHttpLoadBalancerBackends(Object compute, Object project, Object serverGroup, Object googleLoadBalancerProvider, Object task, Object phaseName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference googleLoadBalancerProvider2 = new Reference(googleLoadBalancerProvider);
        Reference task2 = new Reference(task);
        Reference phaseName2 = new Reference(phaseName);
        public final class _destroyHttpLoadBalancerBackends_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phaseName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroyHttpLoadBalancerBackends_closure7(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider, Reference task, Reference phaseName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.compute = reference6 = compute;
                this.project = reference5 = project;
                this.serverGroup = reference4 = serverGroup;
                this.googleLoadBalancerProvider = reference3 = googleLoadBalancerProvider;
                this.task = reference2 = task;
                this.phaseName = reference = phaseName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "destroyHttpLoadBalancerBackends", 0, GCEUtil.class, this.compute.get(), this.project.get(), this.serverGroup.get(), this.googleLoadBalancerProvider.get(), this.task.get(), this.phaseName.get(), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getServerGroup() {
                return this.serverGroup.get();
            }

            @Generated
            public Object getGoogleLoadBalancerProvider() {
                return this.googleLoadBalancerProvider.get();
            }

            @Generated
            public Object getTask() {
                return this.task.get();
            }

            @Generated
            public Object getPhaseName() {
                return this.phaseName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyHttpLoadBalancerBackends_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroyHttpLoadBalancerBackends_closure7(this, this, compute2, project2, serverGroup2, googleLoadBalancerProvider2, task2, phaseName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroyInternalHttpLoadBalancerBackends(Object compute, Object project, Object serverGroup, Object googleLoadBalancerProvider, Object task, Object phaseName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference googleLoadBalancerProvider2 = new Reference(googleLoadBalancerProvider);
        Reference task2 = new Reference(task);
        Reference phaseName2 = new Reference(phaseName);
        public final class _destroyInternalHttpLoadBalancerBackends_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phaseName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroyInternalHttpLoadBalancerBackends_closure8(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider, Reference task, Reference phaseName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.compute = reference6 = compute;
                this.project = reference5 = project;
                this.serverGroup = reference4 = serverGroup;
                this.googleLoadBalancerProvider = reference3 = googleLoadBalancerProvider;
                this.task = reference2 = task;
                this.phaseName = reference = phaseName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "destroyInternalHttpLoadBalancerBackends", 0, GCEUtil.class, this.compute.get(), this.project.get(), this.serverGroup.get(), this.googleLoadBalancerProvider.get(), this.task.get(), this.phaseName.get(), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getServerGroup() {
                return this.serverGroup.get();
            }

            @Generated
            public Object getGoogleLoadBalancerProvider() {
                return this.googleLoadBalancerProvider.get();
            }

            @Generated
            public Object getTask() {
                return this.task.get();
            }

            @Generated
            public Object getPhaseName() {
                return this.phaseName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyInternalHttpLoadBalancerBackends_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroyInternalHttpLoadBalancerBackends_closure8(this, this, compute2, project2, serverGroup2, googleLoadBalancerProvider2, task2, phaseName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroyInternalLoadBalancerBackends(Object compute, Object project, Object serverGroup, Object googleLoadBalancerProvider, Object task, Object phaseName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference googleLoadBalancerProvider2 = new Reference(googleLoadBalancerProvider);
        Reference task2 = new Reference(task);
        Reference phaseName2 = new Reference(phaseName);
        public final class _destroyInternalLoadBalancerBackends_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phaseName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroyInternalLoadBalancerBackends_closure9(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider, Reference task, Reference phaseName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.compute = reference6 = compute;
                this.project = reference5 = project;
                this.serverGroup = reference4 = serverGroup;
                this.googleLoadBalancerProvider = reference3 = googleLoadBalancerProvider;
                this.task = reference2 = task;
                this.phaseName = reference = phaseName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "destroyInternalLoadBalancerBackends", 0, GCEUtil.class, this.compute.get(), this.project.get(), this.serverGroup.get(), this.googleLoadBalancerProvider.get(), this.task.get(), this.phaseName.get(), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getServerGroup() {
                return this.serverGroup.get();
            }

            @Generated
            public Object getGoogleLoadBalancerProvider() {
                return this.googleLoadBalancerProvider.get();
            }

            @Generated
            public Object getTask() {
                return this.task.get();
            }

            @Generated
            public Object getPhaseName() {
                return this.phaseName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyInternalLoadBalancerBackends_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroyInternalLoadBalancerBackends_closure9(this, this, compute2, project2, serverGroup2, googleLoadBalancerProvider2, task2, phaseName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroySslLoadBalancerBackends(Object compute, Object project, Object serverGroup, Object googleLoadBalancerProvider, Object task, Object phaseName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference googleLoadBalancerProvider2 = new Reference(googleLoadBalancerProvider);
        Reference task2 = new Reference(task);
        Reference phaseName2 = new Reference(phaseName);
        public final class _destroySslLoadBalancerBackends_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phaseName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroySslLoadBalancerBackends_closure10(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider, Reference task, Reference phaseName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.compute = reference6 = compute;
                this.project = reference5 = project;
                this.serverGroup = reference4 = serverGroup;
                this.googleLoadBalancerProvider = reference3 = googleLoadBalancerProvider;
                this.task = reference2 = task;
                this.phaseName = reference = phaseName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "destroySslLoadBalancerBackends", 0, GCEUtil.class, this.compute.get(), this.project.get(), this.serverGroup.get(), this.googleLoadBalancerProvider.get(), this.task.get(), this.phaseName.get(), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getServerGroup() {
                return this.serverGroup.get();
            }

            @Generated
            public Object getGoogleLoadBalancerProvider() {
                return this.googleLoadBalancerProvider.get();
            }

            @Generated
            public Object getTask() {
                return this.task.get();
            }

            @Generated
            public Object getPhaseName() {
                return this.phaseName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroySslLoadBalancerBackends_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroySslLoadBalancerBackends_closure10(this, this, compute2, project2, serverGroup2, googleLoadBalancerProvider2, task2, phaseName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroyTcpLoadBalancerBackends(Object compute, Object project, Object serverGroup, Object googleLoadBalancerProvider, Object task, Object phaseName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference googleLoadBalancerProvider2 = new Reference(googleLoadBalancerProvider);
        Reference task2 = new Reference(task);
        Reference phaseName2 = new Reference(phaseName);
        public final class _destroyTcpLoadBalancerBackends_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phaseName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroyTcpLoadBalancerBackends_closure11(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider, Reference task, Reference phaseName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.compute = reference6 = compute;
                this.project = reference5 = project;
                this.serverGroup = reference4 = serverGroup;
                this.googleLoadBalancerProvider = reference3 = googleLoadBalancerProvider;
                this.task = reference2 = task;
                this.phaseName = reference = phaseName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "destroyTcpLoadBalancerBackends", 0, GCEUtil.class, this.compute.get(), this.project.get(), this.serverGroup.get(), this.googleLoadBalancerProvider.get(), this.task.get(), this.phaseName.get(), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getServerGroup() {
                return this.serverGroup.get();
            }

            @Generated
            public Object getGoogleLoadBalancerProvider() {
                return this.googleLoadBalancerProvider.get();
            }

            @Generated
            public Object getTask() {
                return this.task.get();
            }

            @Generated
            public Object getPhaseName() {
                return this.phaseName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyTcpLoadBalancerBackends_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroyTcpLoadBalancerBackends_closure11(this, this, compute2, project2, serverGroup2, googleLoadBalancerProvider2, task2, phaseName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure addHttpLoadBalancerBackends(Object compute, Object objectMapper, Object project, Object serverGroup, Object googleLoadBalancerProvider, Object task, Object phaseName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference objectMapper2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)var3_3);
        Reference serverGroup2 = new Reference(serverGroup);
        Reference googleLoadBalancerProvider2 = new Reference(googleLoadBalancerProvider);
        Reference task2 = new Reference(task);
        Reference phaseName2 = new Reference(phaseName);
        public final class _addHttpLoadBalancerBackends_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference objectMapper;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phaseName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addHttpLoadBalancerBackends_closure12(Object _outerInstance, Object _thisObject, Reference compute, Reference objectMapper, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider, Reference task, Reference phaseName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                this.compute = reference7 = compute;
                this.objectMapper = reference6 = objectMapper;
                this.project = reference5 = project;
                this.serverGroup = reference4 = serverGroup;
                this.googleLoadBalancerProvider = reference3 = googleLoadBalancerProvider;
                this.task = reference2 = task;
                this.phaseName = reference = phaseName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "addHttpLoadBalancerBackends", 0, GCEUtil.class, this.compute.get(), this.objectMapper.get(), this.project.get(), this.serverGroup.get(), this.googleLoadBalancerProvider.get(), this.task.get(), this.phaseName.get(), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getObjectMapper() {
                return this.objectMapper.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getServerGroup() {
                return this.serverGroup.get();
            }

            @Generated
            public Object getGoogleLoadBalancerProvider() {
                return this.googleLoadBalancerProvider.get();
            }

            @Generated
            public Object getTask() {
                return this.task.get();
            }

            @Generated
            public Object getPhaseName() {
                return this.phaseName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addHttpLoadBalancerBackends_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _addHttpLoadBalancerBackends_closure12(this, this, compute2, objectMapper2, project2, serverGroup2, googleLoadBalancerProvider2, task2, phaseName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure addInternalHttpLoadBalancerBackends(Object compute, Object objectMapper, Object project, Object serverGroup, Object googleLoadBalancerProvider, Object task, Object phaseName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference objectMapper2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)var3_3);
        Reference serverGroup2 = new Reference(serverGroup);
        Reference googleLoadBalancerProvider2 = new Reference(googleLoadBalancerProvider);
        Reference task2 = new Reference(task);
        Reference phaseName2 = new Reference(phaseName);
        public final class _addInternalHttpLoadBalancerBackends_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference objectMapper;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phaseName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addInternalHttpLoadBalancerBackends_closure13(Object _outerInstance, Object _thisObject, Reference compute, Reference objectMapper, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider, Reference task, Reference phaseName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                this.compute = reference7 = compute;
                this.objectMapper = reference6 = objectMapper;
                this.project = reference5 = project;
                this.serverGroup = reference4 = serverGroup;
                this.googleLoadBalancerProvider = reference3 = googleLoadBalancerProvider;
                this.task = reference2 = task;
                this.phaseName = reference = phaseName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "addInternalHttpLoadBalancerBackends", 0, GCEUtil.class, this.compute.get(), this.objectMapper.get(), this.project.get(), this.serverGroup.get(), this.googleLoadBalancerProvider.get(), this.task.get(), this.phaseName.get(), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getObjectMapper() {
                return this.objectMapper.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getServerGroup() {
                return this.serverGroup.get();
            }

            @Generated
            public Object getGoogleLoadBalancerProvider() {
                return this.googleLoadBalancerProvider.get();
            }

            @Generated
            public Object getTask() {
                return this.task.get();
            }

            @Generated
            public Object getPhaseName() {
                return this.phaseName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addInternalHttpLoadBalancerBackends_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _addInternalHttpLoadBalancerBackends_closure13(this, this, compute2, objectMapper2, project2, serverGroup2, googleLoadBalancerProvider2, task2, phaseName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure addSslLoadBalancerBackends(Object compute, Object objectMapper, Object project, Object serverGroup, Object googleLoadBalancerProvider, Object task, Object phaseName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference objectMapper2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)var3_3);
        Reference serverGroup2 = new Reference(serverGroup);
        Reference googleLoadBalancerProvider2 = new Reference(googleLoadBalancerProvider);
        Reference task2 = new Reference(task);
        Reference phaseName2 = new Reference(phaseName);
        public final class _addSslLoadBalancerBackends_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference objectMapper;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phaseName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addSslLoadBalancerBackends_closure14(Object _outerInstance, Object _thisObject, Reference compute, Reference objectMapper, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider, Reference task, Reference phaseName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                this.compute = reference7 = compute;
                this.objectMapper = reference6 = objectMapper;
                this.project = reference5 = project;
                this.serverGroup = reference4 = serverGroup;
                this.googleLoadBalancerProvider = reference3 = googleLoadBalancerProvider;
                this.task = reference2 = task;
                this.phaseName = reference = phaseName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "addSslLoadBalancerBackends", 0, GCEUtil.class, this.compute.get(), this.objectMapper.get(), this.project.get(), this.serverGroup.get(), this.googleLoadBalancerProvider.get(), this.task.get(), this.phaseName.get(), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getObjectMapper() {
                return this.objectMapper.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getServerGroup() {
                return this.serverGroup.get();
            }

            @Generated
            public Object getGoogleLoadBalancerProvider() {
                return this.googleLoadBalancerProvider.get();
            }

            @Generated
            public Object getTask() {
                return this.task.get();
            }

            @Generated
            public Object getPhaseName() {
                return this.phaseName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addSslLoadBalancerBackends_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _addSslLoadBalancerBackends_closure14(this, this, compute2, objectMapper2, project2, serverGroup2, googleLoadBalancerProvider2, task2, phaseName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure addTcpLoadBalancerBackends(Object compute, Object objectMapper, Object project, Object serverGroup, Object googleLoadBalancerProvider, Object task, Object phaseName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference objectMapper2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)var3_3);
        Reference serverGroup2 = new Reference(serverGroup);
        Reference googleLoadBalancerProvider2 = new Reference(googleLoadBalancerProvider);
        Reference task2 = new Reference(task);
        Reference phaseName2 = new Reference(phaseName);
        public final class _addTcpLoadBalancerBackends_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference objectMapper;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phaseName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addTcpLoadBalancerBackends_closure15(Object _outerInstance, Object _thisObject, Reference compute, Reference objectMapper, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider, Reference task, Reference phaseName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                this.compute = reference7 = compute;
                this.objectMapper = reference6 = objectMapper;
                this.project = reference5 = project;
                this.serverGroup = reference4 = serverGroup;
                this.googleLoadBalancerProvider = reference3 = googleLoadBalancerProvider;
                this.task = reference2 = task;
                this.phaseName = reference = phaseName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "addTcpLoadBalancerBackends", 0, GCEUtil.class, this.compute.get(), this.objectMapper.get(), this.project.get(), this.serverGroup.get(), this.googleLoadBalancerProvider.get(), this.task.get(), this.phaseName.get(), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getObjectMapper() {
                return this.objectMapper.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getServerGroup() {
                return this.serverGroup.get();
            }

            @Generated
            public Object getGoogleLoadBalancerProvider() {
                return this.googleLoadBalancerProvider.get();
            }

            @Generated
            public Object getTask() {
                return this.task.get();
            }

            @Generated
            public Object getPhaseName() {
                return this.phaseName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addTcpLoadBalancerBackends_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _addTcpLoadBalancerBackends_closure15(this, this, compute2, objectMapper2, project2, serverGroup2, googleLoadBalancerProvider2, task2, phaseName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure addInternalLoadBalancerBackends(Object compute, Object project, Object serverGroup, Object googleLoadBalancerProvider, Object task, Object phaseName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference googleLoadBalancerProvider2 = new Reference(googleLoadBalancerProvider);
        Reference task2 = new Reference(task);
        Reference phaseName2 = new Reference(phaseName);
        public final class _addInternalLoadBalancerBackends_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private /* synthetic */ Reference task;
            private /* synthetic */ Reference phaseName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addInternalLoadBalancerBackends_closure16(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider, Reference task, Reference phaseName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.compute = reference6 = compute;
                this.project = reference5 = project;
                this.serverGroup = reference4 = serverGroup;
                this.googleLoadBalancerProvider = reference3 = googleLoadBalancerProvider;
                this.task = reference2 = task;
                this.phaseName = reference = phaseName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "addInternalLoadBalancerBackends", 0, GCEUtil.class, this.compute.get(), this.project.get(), this.serverGroup.get(), this.googleLoadBalancerProvider.get(), this.task.get(), this.phaseName.get(), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getServerGroup() {
                return this.serverGroup.get();
            }

            @Generated
            public Object getGoogleLoadBalancerProvider() {
                return this.googleLoadBalancerProvider.get();
            }

            @Generated
            public Object getTask() {
                return this.task.get();
            }

            @Generated
            public Object getPhaseName() {
                return this.phaseName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addInternalLoadBalancerBackends_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _addInternalLoadBalancerBackends_closure16(this, this, compute2, project2, serverGroup2, googleLoadBalancerProvider2, task2, phaseName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure getTargetPool(Object compute, Object project, Object region, Object targetPoolLocalName) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference region2 = new Reference((Object)var3_3);
        Reference targetPoolLocalName2 = new Reference(targetPoolLocalName);
        public final class _getTargetPool_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference targetPoolLocalName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getTargetPool_closure17(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference targetPoolLocalName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.region = reference2 = region;
                this.targetPoolLocalName = reference = targetPoolLocalName;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "targetPools", 0, this.compute.get()), this.project.get(), this.region.get(), this.targetPoolLocalName.get()), "compute.targetPools.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get());
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                return this.region.get();
            }

            @Generated
            public Object getTargetPoolLocalName() {
                return this.targetPoolLocalName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getTargetPool_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _getTargetPool_closure17(this, this, compute2, project2, region2, targetPoolLocalName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure listInstancesInRegionalGroup(Object compute, Object project, Object region, Object serverGroupName, Object regionInstanceGroupsListInstancesRequest) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference region2 = new Reference((Object)var3_3);
        Reference serverGroupName2 = new Reference(serverGroupName);
        Reference regionInstanceGroupsListInstancesRequest2 = new Reference(regionInstanceGroupsListInstancesRequest);
        public final class _listInstancesInRegionalGroup_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference serverGroupName;
            private /* synthetic */ Reference regionInstanceGroupsListInstancesRequest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _listInstancesInRegionalGroup_closure18(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference serverGroupName, Reference regionInstanceGroupsListInstancesRequest) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.compute = reference5 = compute;
                this.project = reference4 = project;
                this.region = reference3 = region;
                this.serverGroupName = reference2 = serverGroupName;
                this.regionInstanceGroupsListInstancesRequest = reference = regionInstanceGroupsListInstancesRequest;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "listInstances", 0, IndyInterface.bootstrap("invoke", "regionInstanceGroups", 0, this.compute.get()), this.project.get(), this.region.get(), this.serverGroupName.get(), this.regionInstanceGroupsListInstancesRequest.get()), "compute.regionInstanceGroups.listInstances", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get()));
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                return this.region.get();
            }

            @Generated
            public Object getServerGroupName() {
                return this.serverGroupName.get();
            }

            @Generated
            public Object getRegionInstanceGroupsListInstancesRequest() {
                return this.regionInstanceGroupsListInstancesRequest.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _listInstancesInRegionalGroup_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _listInstancesInRegionalGroup_closure18(this, this, compute2, project2, region2, serverGroupName2, regionInstanceGroupsListInstancesRequest2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure listInstancesInZonalGroup(Object compute, Object project, Object zone, Object serverGroupName, Object instanceGroupsListInstancesRequest) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference zone2 = new Reference((Object)var3_3);
        Reference serverGroupName2 = new Reference(serverGroupName);
        Reference instanceGroupsListInstancesRequest2 = new Reference(instanceGroupsListInstancesRequest);
        public final class _listInstancesInZonalGroup_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference zone;
            private /* synthetic */ Reference serverGroupName;
            private /* synthetic */ Reference instanceGroupsListInstancesRequest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _listInstancesInZonalGroup_closure19(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference zone, Reference serverGroupName, Reference instanceGroupsListInstancesRequest) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.compute = reference5 = compute;
                this.project = reference4 = project;
                this.zone = reference3 = zone;
                this.serverGroupName = reference2 = serverGroupName;
                this.instanceGroupsListInstancesRequest = reference = instanceGroupsListInstancesRequest;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "listInstances", 0, IndyInterface.bootstrap("invoke", "instanceGroups", 0, this.compute.get()), this.project.get(), this.zone.get(), this.serverGroupName.get(), this.instanceGroupsListInstancesRequest.get()), "compute.instanceGroups.listInstances", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), this.zone.get()));
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getZone() {
                return this.zone.get();
            }

            @Generated
            public Object getServerGroupName() {
                return this.serverGroupName.get();
            }

            @Generated
            public Object getInstanceGroupsListInstancesRequest() {
                return this.instanceGroupsListInstancesRequest.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _listInstancesInZonalGroup_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _listInstancesInZonalGroup_closure19(this, this, compute2, project2, zone2, serverGroupName2, instanceGroupsListInstancesRequest2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure getInstanceTemplate(Object compute, Object project, Object instanceTemplateUrl) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference instanceTemplateUrl2 = new Reference((Object)var3_3);
        public final class _getInstanceTemplate_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference instanceTemplateUrl;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInstanceTemplate_closure20(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference instanceTemplateUrl) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.compute = reference3 = compute;
                this.project = reference2 = project;
                this.instanceTemplateUrl = reference = instanceTemplateUrl;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "instanceTemplates", 0, this.compute.get()), this.project.get(), IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, this.instanceTemplateUrl.get())), "compute.instanceTemplates.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getInstanceTemplateUrl() {
                return this.instanceTemplateUrl.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInstanceTemplate_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _getInstanceTemplate_closure20(this, this, compute2, project2, instanceTemplateUrl2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure removeInstancesFromTargetPool(Object compute, Object project, Object region, Object targetPoolLocalName, Object targetPoolsRemoveInstanceRequest) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference region2 = new Reference((Object)var3_3);
        Reference targetPoolLocalName2 = new Reference(targetPoolLocalName);
        Reference targetPoolsRemoveInstanceRequest2 = new Reference(targetPoolsRemoveInstanceRequest);
        public final class _removeInstancesFromTargetPool_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference targetPoolLocalName;
            private /* synthetic */ Reference targetPoolsRemoveInstanceRequest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeInstancesFromTargetPool_closure21(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference targetPoolLocalName, Reference targetPoolsRemoveInstanceRequest) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.compute = reference5 = compute;
                this.project = reference4 = project;
                this.region = reference3 = region;
                this.targetPoolLocalName = reference2 = targetPoolLocalName;
                this.targetPoolsRemoveInstanceRequest = reference = targetPoolsRemoveInstanceRequest;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "removeInstance", 0, IndyInterface.bootstrap("invoke", "targetPools", 0, this.compute.get()), this.project.get(), this.region.get(), this.targetPoolLocalName.get(), this.targetPoolsRemoveInstanceRequest.get()), "compute.targetPools.removeInstance", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get());
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                return this.region.get();
            }

            @Generated
            public Object getTargetPoolLocalName() {
                return this.targetPoolLocalName.get();
            }

            @Generated
            public Object getTargetPoolsRemoveInstanceRequest() {
                return this.targetPoolsRemoveInstanceRequest.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeInstancesFromTargetPool_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _removeInstancesFromTargetPool_closure21(this, this, compute2, project2, region2, targetPoolLocalName2, targetPoolsRemoveInstanceRequest2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure addInstancesToTargetPool(Object compute, Object project, Object region, Object targetPoolLocalName, Object targetPoolsAddInstanceRequest) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference(compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference region2 = new Reference((Object)var3_3);
        Reference targetPoolLocalName2 = new Reference(targetPoolLocalName);
        Reference targetPoolsAddInstanceRequest2 = new Reference(targetPoolsAddInstanceRequest);
        public final class _addInstancesToTargetPool_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference targetPoolLocalName;
            private /* synthetic */ Reference targetPoolsAddInstanceRequest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addInstancesToTargetPool_closure22(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference targetPoolLocalName, Reference targetPoolsAddInstanceRequest) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.compute = reference5 = compute;
                this.project = reference4 = project;
                this.region = reference3 = region;
                this.targetPoolLocalName = reference2 = targetPoolLocalName;
                this.targetPoolsAddInstanceRequest = reference = targetPoolsAddInstanceRequest;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "addInstance", 0, IndyInterface.bootstrap("invoke", "targetPools", 0, this.compute.get()), this.project.get(), this.region.get(), this.targetPoolLocalName.get(), this.targetPoolsAddInstanceRequest.get()), "compute.targetPools.addInstance", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get());
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                return this.region.get();
            }

            @Generated
            public Object getTargetPoolLocalName() {
                return this.targetPoolLocalName.get();
            }

            @Generated
            public Object getTargetPoolsAddInstanceRequest() {
                return this.targetPoolsAddInstanceRequest.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addInstancesToTargetPool_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _addInstancesToTargetPool_closure22(this, this, compute2, project2, region2, targetPoolLocalName2, targetPoolsAddInstanceRequest2);
    }

    public void setAutoscalingPolicyMode(Object compute, String project, Object serverGroup, GoogleAutoscalingPolicy.AutoscalingMode mode) {
        CallSite serverGroupName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, serverGroup));
        CallSite region = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "region", 0, serverGroup));
        CallSite zone = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "zone", 0, serverGroup));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 0, serverGroup)) != false) {
            CallSite autoscaler = IndyInterface.bootstrap("invoke", "buildAutoscaler", 0, GCEUtil.class, serverGroupName, IndyInterface.bootstrap("getProperty", "selfLink", 0, serverGroup), IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 0, serverGroup));
            IndyInterface.bootstrap("invoke", "setMode", 0, IndyInterface.bootstrap("invoke", "getAutoscalingPolicy", 0, autoscaler), IndyInterface.bootstrap("invoke", "toString", 0, mode));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "regional", 0, serverGroup)) != false) {
                IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "update", 0, IndyInterface.bootstrap("invoke", "regionAutoscalers", 0, compute), project, region, autoscaler), "compute.regionAutoscalers.update", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region);
            } else {
                IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "update", 0, IndyInterface.bootstrap("invoke", "autoscalers", 0, compute), project, zone, autoscaler), "compute.autoscalers.update", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), zone);
            }
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractEnableDisableAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        List list;
        List list2;
        RETRY_ERROR_CODES = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412});
        SUCCESSFUL_ERROR_CODES = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{404});
    }

    @Generated
    public EnableDisableGoogleServerGroupDescription getDescription() {
        return this.description;
    }

    @Generated
    public @VisibleForTesting void setDescription(EnableDisableGoogleServerGroupDescription enableDisableGoogleServerGroupDescription) {
        this.description = enableDisableGoogleServerGroupDescription;
    }

    @Generated
    public GoogleClusterProvider getGoogleClusterProvider() {
        return this.googleClusterProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleClusterProvider(GoogleClusterProvider googleClusterProvider) {
        this.googleClusterProvider = googleClusterProvider;
    }

    @Generated
    public GoogleOperationPoller getGoogleOperationPoller() {
        return this.googleOperationPoller;
    }

    @Generated
    public @VisibleForTesting void setGoogleOperationPoller(GoogleOperationPoller googleOperationPoller) {
        this.googleOperationPoller = googleOperationPoller;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public @VisibleForTesting void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public GoogleLoadBalancerProvider getGoogleLoadBalancerProvider() {
        return this.googleLoadBalancerProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleLoadBalancerProvider(GoogleLoadBalancerProvider googleLoadBalancerProvider) {
        this.googleLoadBalancerProvider = googleLoadBalancerProvider;
    }

    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Generated
    public @VisibleForTesting void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    @Generated
    public ServiceClientProvider getServiceClientProvider() {
        return this.serviceClientProvider;
    }

    @Generated
    public @VisibleForTesting void setServiceClientProvider(ServiceClientProvider serviceClientProvider) {
        this.serviceClientProvider = serviceClientProvider;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

