/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.BasicGoogleDeployDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.handlers.BasicGoogleDeployHandler;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleUserDataProvider;
import com.netflix.spinnaker.clouddriver.google.model.GoogleDisk;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class CopyLastGoogleServerGroupAtomicOperation
extends GoogleAtomicOperation<DeploymentResult> {
    private static final String BASE_PHASE = "COPY_LAST_SERVER_GROUP";
    private final BasicGoogleDeployDescription description;
    @Autowired
    private BasicGoogleDeployHandler basicGoogleDeployHandler;
    @Autowired
    private GoogleClusterProvider googleClusterProvider;
    @Autowired
    private GoogleUserDataProvider googleUserDataProvider;
    @Autowired
    private SafeRetry safeRetry;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public CopyLastGoogleServerGroupAtomicOperation(BasicGoogleDeployDescription description) {
        BasicGoogleDeployDescription basicGoogleDeployDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = basicGoogleDeployDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public DeploymentResult operate(List priorOutputs) {
        CallSite newDescription = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cloneAndOverrideDescription", 2, this));
        CallSite credentials = IndyInterface.bootstrap("getProperty", "credentials", 4, newDescription);
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, credentials);
        CallSite isRegional = IndyInterface.bootstrap("getProperty", "regional", 4, newDescription);
        CallSite zone = IndyInterface.bootstrap("getProperty", "zone", 4, newDescription);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "region", 4, newDescription);
        CallSite region = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("invoke", "regionFromZone", 0, credentials, zone);
        CallSite serverGroupNameResolver = IndyInterface.bootstrap("init", "<init>", 0, GCEServerGroupNameResolver.class, project, region, credentials, this.googleClusterProvider, this.safeRetry, this);
        CallSite clusterName = IndyInterface.bootstrap("invoke", "combineAppStackDetail", 0, serverGroupNameResolver, IndyInterface.bootstrap("getProperty", "application", 4, newDescription), IndyInterface.bootstrap("getProperty", "stack", 4, newDescription), IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, newDescription));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{clusterName, IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? region : zone}, new String[]{"Initializing copy of server group for cluster ", " in ", "..."}));
        CallSite result = IndyInterface.bootstrap("invoke", "handle", 0, this.basicGoogleDeployHandler, newDescription, priorOutputs);
        CallSite newServerGroupName = IndyInterface.bootstrap("invoke", "getServerGroupName", 0, CopyLastGoogleServerGroupAtomicOperation.class, IndyInterface.bootstrap("invoke", "getAt", 1, IndyInterface.bootstrap("getProperty", "serverGroupNames", 1, result), false));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{clusterName}, new String[]{"Finished copying server group for cluster ", ". "}), new GStringImpl(new Object[]{newServerGroupName, IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? region : zone}, new String[]{"New server group = ", " in ", "."})));
        return IndyInterface.bootstrap("cast", "()", 0, result);
    }

    private BasicGoogleDeployDescription cloneAndOverrideDescription() {
        CallSite newDescription = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, this.description));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "region", 1, IndyInterface.bootstrap("getProperty", "source", 5, this.description))) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "serverGroupName", 1, IndyInterface.bootstrap("getProperty", "source", 5, this.description))) == false) {
            return newDescription;
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "serverGroupName", 0, IndyInterface.bootstrap("getProperty", "source", 4, this.description))}, new String[]{"Initializing copy of server group ", "..."}));
        CallSite ancestorServerGroup = IndyInterface.bootstrap("invoke", "queryServerGroup", 0, GCEUtil.class, this.googleClusterProvider, IndyInterface.bootstrap("getProperty", "accountName", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 0, IndyInterface.bootstrap("getProperty", "source", 4, this.description)), IndyInterface.bootstrap("getProperty", "serverGroupName", 0, IndyInterface.bootstrap("getProperty", "source", 4, this.description)));
        if (IndyInterface.bootstrap("cast", "()", 0, ancestorServerGroup) == false) {
            return newDescription;
        }
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, newDescription));
        CallSite ancestorNames = IndyInterface.bootstrap("invoke", "parseName", 0, Names.class, IndyInterface.bootstrap("getProperty", "name", 0, ancestorServerGroup));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "region", 4, this.description);
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("invoke", "getLocalName", 0, Utils.class, IndyInterface.bootstrap("getProperty", "region", 0, ancestorServerGroup));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"region");
        CallSite callSite3 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "regional", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "regional", 4, this.description) : IndyInterface.bootstrap("getProperty", "regional", 0, ancestorServerGroup);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite3, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"regional");
        CallSite callSite4 = IndyInterface.bootstrap("getProperty", "zone", 4, this.description);
        CallSite callSite5 = IndyInterface.bootstrap("cast", "()", 0, callSite4) != false ? callSite4 : IndyInterface.bootstrap("invoke", "getLocalName", 0, Utils.class, IndyInterface.bootstrap("getProperty", "zone", 0, ancestorServerGroup));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite5, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"zone");
        CallSite callSite6 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "loadBalancers", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "loadBalancers", 4, this.description) : (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 0, ancestorServerGroup), List.class));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite6, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"loadBalancers");
        CallSite callSite7 = IndyInterface.bootstrap("getProperty", "application", 4, this.description);
        CallSite callSite8 = IndyInterface.bootstrap("cast", "()", 0, callSite7) != false ? callSite7 : IndyInterface.bootstrap("getProperty", "app", 0, ancestorNames);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite8, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"application");
        CallSite callSite9 = IndyInterface.bootstrap("getProperty", "stack", 4, this.description);
        CallSite callSite10 = IndyInterface.bootstrap("cast", "()", 0, callSite9) != false ? callSite9 : IndyInterface.bootstrap("getProperty", "stack", 0, ancestorNames);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite10, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"stack");
        CallSite callSite11 = IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, this.description);
        CallSite callSite12 = IndyInterface.bootstrap("cast", "()", 0, callSite11) != false ? callSite11 : IndyInterface.bootstrap("getProperty", "detail", 0, ancestorNames);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite12, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"freeFormDetails");
        CallSite callSite13 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "targetSize", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "targetSize", 4, this.description) : IndyInterface.bootstrap("getProperty", "desired", 0, IndyInterface.bootstrap("getProperty", "capacity", 0, ancestorServerGroup));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite13, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"targetSize");
        CallSite callSite14 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "distributionPolicy", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "distributionPolicy", 4, this.description) : IndyInterface.bootstrap("getProperty", "distributionPolicy", 0, ancestorServerGroup);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite14, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"distributionPolicy");
        CallSite callSite15 = IndyInterface.bootstrap("getProperty", "selectZones", 4, this.description);
        CallSite callSite16 = IndyInterface.bootstrap("cast", "()", 0, callSite15) != false ? callSite15 : IndyInterface.bootstrap("getProperty", "selectZones", 0, ancestorServerGroup);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite16, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"selectZones");
        CallSite ancestorInstanceTemplate = IndyInterface.bootstrap("getProperty", "instanceTemplate", 0, IndyInterface.bootstrap("getProperty", "launchConfig", 0, ancestorServerGroup));
        if (IndyInterface.bootstrap("cast", "()", 0, ancestorInstanceTemplate) != false) {
            CallSite ancestorInstanceProperties = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "properties", 0, ancestorInstanceTemplate));
            CallSite callSite17 = IndyInterface.bootstrap("getProperty", "instanceType", 4, this.description);
            CallSite callSite18 = IndyInterface.bootstrap("cast", "()", 0, callSite17) != false ? callSite17 : IndyInterface.bootstrap("getProperty", "machineType", 0, ancestorInstanceProperties);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite18, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"instanceType");
            CallSite callSite19 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "minCpuPlatform", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "minCpuPlatform", 4, this.description) : IndyInterface.bootstrap("getProperty", "minCpuPlatform", 0, ancestorInstanceProperties);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite19, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"minCpuPlatform");
            CallSite attachedDisks = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "disks", 1, ancestorInstanceProperties));
            if (IndyInterface.bootstrap("cast", "()", 0, attachedDisks) != false) {
                public final class _cloneAndOverrideDescription_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _cloneAndOverrideDescription_closure1(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("getProperty", "boot", 0, it);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _cloneAndOverrideDescription_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite bootDisk = IndyInterface.bootstrap("invoke", "find", 0, attachedDisks, new _cloneAndOverrideDescription_closure1(this, this));
                CallSite callSite20 = IndyInterface.bootstrap("getProperty", "image", 4, this.description);
                CallSite callSite21 = IndyInterface.bootstrap("cast", "()", 0, callSite20) != false ? callSite20 : IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "sourceImage", 0, IndyInterface.bootstrap("getProperty", "initializeParams", 0, bootDisk)));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite21, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"image");
                CallSite callSite22 = IndyInterface.bootstrap("getProperty", "disks", 4, this.description);
                public final class _cloneAndOverrideDescription_closure2
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _cloneAndOverrideDescription_closure2(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object attachedDisk) {
                        CallSite initializeParams = IndyInterface.bootstrap("getProperty", "initializeParams", 0, attachedDisk);
                        return IndyInterface.bootstrap("init", "<init>", 0, GoogleDisk.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", IndyInterface.bootstrap("getProperty", "diskType", 0, initializeParams), "sizeGb", IndyInterface.bootstrap("getProperty", "diskSizeGb", 0, initializeParams), "autoDelete", IndyInterface.bootstrap("getProperty", "autoDelete", 0, attachedDisk), "sourceImage", IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "sourceImage", 0, initializeParams))}));
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _cloneAndOverrideDescription_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite23 = IndyInterface.bootstrap("cast", "()", 0, callSite22) != false ? callSite22 : IndyInterface.bootstrap("invoke", "collect", 0, attachedDisks, new _cloneAndOverrideDescription_closure2(this, this));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite23, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"disks");
            }
            CallSite instanceMetadata = IndyInterface.bootstrap("getProperty", "metadata", 0, ancestorInstanceProperties);
            if (IndyInterface.bootstrap("cast", "()", 0, instanceMetadata) != false) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "instanceMetadata", 4, this.description)) != false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "userData", 4, this.description)) != false) {
                        CallSite callSite24 = IndyInterface.bootstrap("getProperty", "instanceMetadata", 4, this.description);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite24, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"instanceMetadata");
                        CallSite callSite25 = IndyInterface.bootstrap("getProperty", "userData", 4, this.description);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite25, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"userData");
                    } else {
                        public final class _cloneAndOverrideDescription_closure3
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _cloneAndOverrideDescription_closure3(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)"customUserData");
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _cloneAndOverrideDescription_closure3.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite item = IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("invoke", "getItems", 0, instanceMetadata), new _cloneAndOverrideDescription_closure3(this, this));
                        if (IndyInterface.bootstrap("cast", "()", 0, item) != false) {
                            CallSite ancestorCustomUserData = IndyInterface.bootstrap("getProperty", "value", 0, item);
                            CallSite customUserDataMap = IndyInterface.bootstrap("invoke", "leftShift", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"customUserData", IndyInterface.bootstrap("getProperty", "value", 0, item)}), IndyInterface.bootstrap("invoke", "stringToUserDataMap", 0, this.googleUserDataProvider, ancestorCustomUserData));
                            CallSite callSite26 = IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "instanceMetadata", 4, this.description), customUserDataMap);
                            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite26, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"instanceMetadata");
                        }
                    }
                } else {
                    CallSite callSite27 = IndyInterface.bootstrap("invoke", "buildMapFromMetadata", 0, GCEUtil.class, instanceMetadata);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite27, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"instanceMetadata");
                }
            }
            CallSite tags = IndyInterface.bootstrap("getProperty", "tags", 0, ancestorInstanceProperties);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)tags, null)) {
                CallSite callSite28 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "tags", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "tags", 4, this.description) : IndyInterface.bootstrap("getProperty", "items", 0, tags);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite28, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"tags");
            }
            CallSite labels = IndyInterface.bootstrap("getProperty", "labels", 0, ancestorInstanceProperties);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)labels, null)) {
                CallSite callSite29 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "labels", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "labels", 4, this.description) : labels;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite29, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"labels");
            }
            CallSite scheduling = IndyInterface.bootstrap("getProperty", "scheduling", 0, ancestorInstanceProperties);
            if (IndyInterface.bootstrap("cast", "()", 0, scheduling) != false) {
                CallSite callSite30 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "preemptible", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "preemptible", 4, this.description) : IndyInterface.bootstrap("getProperty", "preemptible", 0, scheduling);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite30, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"preemptible");
                CallSite callSite31 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "automaticRestart", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "automaticRestart", 4, this.description) : IndyInterface.bootstrap("getProperty", "automaticRestart", 0, scheduling);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite31, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"automaticRestart");
                CallSite callSite32 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "onHostMaintenance", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "onHostMaintenance", 4, this.description) : IndyInterface.bootstrap("getProperty", "onHostMaintenance", 0, scheduling);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite32, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"onHostMaintenance");
            }
            CallSite callSite33 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 4, this.description) : IndyInterface.bootstrap("getProperty", "email", 1, IndyInterface.bootstrap("invoke", "getAt", 1, IndyInterface.bootstrap("getProperty", "serviceAccounts", 0, ancestorInstanceProperties), false));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite33, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"serviceAccountEmail");
            CallSite callSite34 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "authScopes", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "authScopes", 4, this.description) : IndyInterface.bootstrap("invoke", "retrieveScopesFromServiceAccount", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 4, newDescription), IndyInterface.bootstrap("getProperty", "serviceAccounts", 0, ancestorInstanceProperties));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite34, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"authScopes");
            CallSite callSite35 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "network", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "network", 4, this.description) : IndyInterface.bootstrap("invoke", "decorateXpnResourceIdIfNeeded", 0, Utils.class, project, IndyInterface.bootstrap("getProperty", "network", 1, IndyInterface.bootstrap("invoke", "getAt", 1, IndyInterface.bootstrap("getProperty", "networkInterfaces", 0, ancestorInstanceProperties), false)));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite35, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"network");
            CallSite callSite36 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "subnet", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "subnet", 4, this.description) : IndyInterface.bootstrap("invoke", "decorateXpnResourceIdIfNeeded", 0, Utils.class, project, IndyInterface.bootstrap("getProperty", "subnetwork", 1, IndyInterface.bootstrap("invoke", "getAt", 1, IndyInterface.bootstrap("getProperty", "networkInterfaces", 0, ancestorInstanceProperties), false)));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite36, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"subnet");
            CallSite callSite37 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "associatePublicIpAddress", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "associatePublicIpAddress", 4, this.description) : Boolean.valueOf(ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("getProperty", "accessConfigs", 1, IndyInterface.bootstrap("invoke", "getAt", 1, IndyInterface.bootstrap("getProperty", "networkInterfaces", 0, ancestorInstanceProperties), false))), (Object)0));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite37, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"associatePublicIpAddress");
            CallSite callSite38 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "canIpForward", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "canIpForward", 4, this.description) : IndyInterface.bootstrap("getProperty", "canIpForward", 0, ancestorInstanceProperties);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite38, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"canIpForward");
            CallSite shieldedVmConfig = IndyInterface.bootstrap("getProperty", "shieldedVmConfig", 0, ancestorInstanceProperties);
            if (IndyInterface.bootstrap("cast", "()", 0, shieldedVmConfig) != false) {
                CallSite callSite39 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "enableSecureBoot", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "enableSecureBoot", 4, this.description) : IndyInterface.bootstrap("getProperty", "enableSecureBoot", 0, shieldedVmConfig);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite39, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"enableSecureBoot");
                CallSite callSite40 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "enableVtpm", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "enableVtpm", 4, this.description) : IndyInterface.bootstrap("getProperty", "enableVtpm", 0, shieldedVmConfig);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite40, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"enableVtpm");
                CallSite callSite41 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "enableIntegrityMonitoring", 4, this.description), null) ? IndyInterface.bootstrap("getProperty", "enableIntegrityMonitoring", 4, this.description) : IndyInterface.bootstrap("getProperty", "enableIntegrityMonitoring", 0, shieldedVmConfig);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite41, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"enableIntegrityMonitoring");
            }
        }
        CallSite ancestorAutoscalingPolicyDescription = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 0, ancestorServerGroup));
        CallSite callSite42 = IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 4, this.description);
        CallSite callSite43 = IndyInterface.bootstrap("cast", "()", 0, callSite42) != false ? callSite42 : ancestorAutoscalingPolicyDescription;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite43, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"autoscalingPolicy");
        CallSite ancestorAutoHealingPolicy = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoHealingPolicy", 0, ancestorServerGroup));
        CallSite ancestorAutoHealingPolicyDescription = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildAutoHealingPolicyDescriptionFromAutoHealingPolicy", 0, GCEUtil.class, ancestorAutoHealingPolicy));
        CallSite callSite44 = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "autoHealingPolicy", 4, this.description), null) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "overwriteAncestorAutoHealingPolicy", 4, this.description)) ? IndyInterface.bootstrap("getProperty", "autoHealingPolicy", 4, this.description) : ancestorAutoHealingPolicyDescription;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite44, CopyLastGoogleServerGroupAtomicOperation.class, (GroovyObject)newDescription, (String)"autoHealingPolicy");
        return newDescription;
    }

    private static String getServerGroupName(String regionPlusServerGroupName) {
        if (IndyInterface.bootstrap("cast", "()", 0, regionPlusServerGroupName) == false) {
            return "Unknown";
        }
        CallSite nameParts = IndyInterface.bootstrap("invoke", "split", 0, regionPlusServerGroupName, ":");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, nameParts, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "length", 0, nameParts), true)));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CopyLastGoogleServerGroupAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public BasicGoogleDeployHandler getBasicGoogleDeployHandler() {
        return this.basicGoogleDeployHandler;
    }

    @Generated
    public @VisibleForTesting void setBasicGoogleDeployHandler(BasicGoogleDeployHandler basicGoogleDeployHandler) {
        this.basicGoogleDeployHandler = basicGoogleDeployHandler;
    }

    @Generated
    public GoogleClusterProvider getGoogleClusterProvider() {
        return this.googleClusterProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleClusterProvider(GoogleClusterProvider googleClusterProvider) {
        this.googleClusterProvider = googleClusterProvider;
    }

    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Generated
    public @VisibleForTesting void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

