/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.google.api.services.compute.model.Instance;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.google.config.GoogleConfigurationProperties;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.CreateGoogleInstanceDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleNetworkProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSubnetProvider;
import com.netflix.spinnaker.config.GoogleConfiguration;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateGoogleInstanceAtomicOperation
extends GoogleAtomicOperation<DeploymentResult> {
    private static final String BASE_PHASE = "DEPLOY";
    private static final String DEFAULT_NETWORK_NAME = "default";
    private static final String accessConfigName = "External NAT";
    private static final String accessConfigType = "ONE_TO_ONE_NAT";
    @Autowired
    private GoogleConfigurationProperties googleConfigurationProperties;
    @Autowired
    private GoogleConfiguration.DeployDefaults googleDeployDefaults;
    @Autowired
    private GoogleNetworkProvider googleNetworkProvider;
    @Autowired
    private GoogleSubnetProvider googleSubnetProvider;
    @Autowired
    private String clouddriverUserAgentApplicationName;
    @Autowired
    private SafeRetry safeRetry;
    private final CreateGoogleInstanceDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public CreateGoogleInstanceAtomicOperation(CreateGoogleInstanceDescription description) {
        CreateGoogleInstanceDescription createGoogleInstanceDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = createGoogleInstanceDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public DeploymentResult operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "instanceName", 4, this.description), IndyInterface.bootstrap("getProperty", "zone", 4, this.description)}, new String[]{"Initializing creation of instance ", " in ", "..."}));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "accountName", 4, this.description)}, new String[]{"Unable to resolve credentials for Google account '", "'."})));
        }
        CallSite accountName = IndyInterface.bootstrap("getProperty", "accountName", 4, this.description);
        CallSite credentials = IndyInterface.bootstrap("getProperty", "credentials", 4, this.description);
        CallSite compute = IndyInterface.bootstrap("getProperty", "compute", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        CallSite zone = IndyInterface.bootstrap("getProperty", "zone", 4, this.description);
        CallSite region = IndyInterface.bootstrap("invoke", "regionFromZone", 0, credentials, zone);
        CallSite canIpForward = IndyInterface.bootstrap("getProperty", "canIpForward", 4, this.description);
        CallSite machineTypeName = null;
        machineTypeName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("getProperty", "instanceType", 4, this.description), "custom")) != false ? IndyInterface.bootstrap("getProperty", "instanceType", 4, this.description) : IndyInterface.bootstrap("invoke", "queryMachineType", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "instanceType", 4, this.description), zone, credentials, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "network", 4, this.description);
        CallSite network = IndyInterface.bootstrap("invoke", "queryNetwork", 0, GCEUtil.class, accountName, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : DEFAULT_NETWORK_NAME, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this.googleNetworkProvider);
        CallSite subnet = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnet", 4, this.description)) != false ? IndyInterface.bootstrap("invoke", "querySubnet", 0, GCEUtil.class, accountName, region, IndyInterface.bootstrap("getProperty", "subnet", 4, this.description), IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this.googleSubnetProvider) : null;
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Composing instance...");
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "instanceName", 4, this.description);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, CreateGoogleInstanceAtomicOperation.class, (GroovyObject)this.description, (String)"baseDeviceName");
        CallSite bootImage = IndyInterface.bootstrap("invoke", "getBootImage", 0, GCEUtil.class, this.description, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this.clouddriverUserAgentApplicationName, IndyInterface.bootstrap("getProperty", "baseImageProjects", 4, this.googleConfigurationProperties), this.safeRetry, this);
        CallSite attachedDisks = IndyInterface.bootstrap("invoke", "buildAttachedDisks", 0, GCEUtil.class, this.description, zone, true, this.googleDeployDefaults, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this.clouddriverUserAgentApplicationName, IndyInterface.bootstrap("getProperty", "baseImageProjects", 4, this.googleConfigurationProperties), bootImage, this.safeRetry, this);
        CallSite networkInterface = IndyInterface.bootstrap("invoke", "buildNetworkInterface", 0, GCEUtil.class, network, subnet, ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "associatePublicIpAddress", 4, this.description), null) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "associatePublicIpAddress", 4, this.description)), accessConfigName, accessConfigType);
        CallSite metadata = IndyInterface.bootstrap("invoke", "buildMetadataFromMap", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "instanceMetadata", 4, this.description));
        CallSite tags = IndyInterface.bootstrap("invoke", "buildTagsFromList", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "tags", 4, this.description));
        CallSite serviceAccount = IndyInterface.bootstrap("invoke", "buildServiceAccount", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 4, this.description), IndyInterface.bootstrap("getProperty", "authScopes", 4, this.description));
        CallSite scheduling = IndyInterface.bootstrap("invoke", "buildScheduling", 0, GCEUtil.class, this.description);
        CallSite instance = IndyInterface.bootstrap("init", "<init>", 0, Instance.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "instanceName", 4, this.description), "machineType", new GStringImpl(new Object[]{zone, machineTypeName}, new String[]{"zones/", "/machineTypes/", ""}), "disks", attachedDisks, "networkInterfaces", ScriptBytecodeAdapter.createList((Object[])new Object[]{networkInterface}), "canIpForward", canIpForward, "metadata", metadata, "tags", tags, "labels", IndyInterface.bootstrap("getProperty", "labels", 4, this.description), "scheduling", scheduling, "serviceAccounts", serviceAccount}));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isShieldedVmCompatible", 0, GCEUtil.class, bootImage)) != false) {
            CallSite shieldedVmConfig = IndyInterface.bootstrap("invoke", "buildShieldedVmConfig", 0, GCEUtil.class, this.description);
            IndyInterface.bootstrap("invoke", "setShieldedVmConfig", 0, instance, shieldedVmConfig);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "minCpuPlatform", 4, this.description)) != false) {
            CallSite callSite3 = IndyInterface.bootstrap("getProperty", "minCpuPlatform", 4, this.description);
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)instance, (String)"minCpuPlatform");
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "instanceName", 4, this.description)}, new String[]{"Creating instance ", "..."}));
        IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "instances", 0, compute), project, zone, instance), "compute.instances.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), zone);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "instanceName", 4, this.description), IndyInterface.bootstrap("getProperty", "zone", 4, this.description)}, new String[]{"Done creating instance ", " in ", "."}));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DeploymentResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"serverGroupNames", ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "instanceName", 4, this.description)})})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CreateGoogleInstanceAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public GoogleNetworkProvider getGoogleNetworkProvider() {
        return this.googleNetworkProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleNetworkProvider(GoogleNetworkProvider googleNetworkProvider) {
        this.googleNetworkProvider = googleNetworkProvider;
    }

    @Generated
    public GoogleSubnetProvider getGoogleSubnetProvider() {
        return this.googleSubnetProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleSubnetProvider(GoogleSubnetProvider googleSubnetProvider) {
        this.googleSubnetProvider = googleSubnetProvider;
    }

    @Generated
    public String getClouddriverUserAgentApplicationName() {
        return this.clouddriverUserAgentApplicationName;
    }

    @Generated
    public @VisibleForTesting void setClouddriverUserAgentApplicationName(String string) {
        this.clouddriverUserAgentApplicationName = string;
    }

    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Generated
    public @VisibleForTesting void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

