/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.InstanceGroupManagersSetAutoHealingRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersSetAutoHealingRequest;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutor;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.description.DeleteGoogleAutoscalingPolicyDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationsRegistry;
import com.netflix.spinnaker.clouddriver.orchestration.OrchestrationProcessor;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteGoogleAutoscalingPolicyAtomicOperation
extends GoogleAtomicOperation<Void> {
    private static final String BASE_PHASE = "DELETE_SCALING_POLICY";
    private final DeleteGoogleAutoscalingPolicyDescription description;
    private GoogleClusterProvider googleClusterProvider;
    private GoogleOperationPoller googleOperationPoller;
    private AtomicOperationsRegistry atomicOperationsRegistry;
    private OrchestrationProcessor orchestrationProcessor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DeleteGoogleAutoscalingPolicyAtomicOperation(DeleteGoogleAutoscalingPolicyDescription description, @Autowired GoogleClusterProvider googleClusterProvider, @Autowired GoogleOperationPoller googleOperationPoller, @Autowired AtomicOperationsRegistry atomicOperationsRegistry, @Autowired OrchestrationProcessor orchestrationProcessor) {
        OrchestrationProcessor orchestrationProcessor2;
        AtomicOperationsRegistry atomicOperationsRegistry2;
        GoogleOperationPoller googleOperationPoller2;
        GoogleClusterProvider googleClusterProvider2;
        DeleteGoogleAutoscalingPolicyDescription deleteGoogleAutoscalingPolicyDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = deleteGoogleAutoscalingPolicyDescription = description;
        this.googleClusterProvider = googleClusterProvider2 = googleClusterProvider;
        this.googleOperationPoller = googleOperationPoller2 = googleOperationPoller;
        this.atomicOperationsRegistry = atomicOperationsRegistry2 = atomicOperationsRegistry;
        this.orchestrationProcessor = orchestrationProcessor2 = orchestrationProcessor;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        CallSite credentials = IndyInterface.bootstrap("getProperty", "credentials", 4, this.description);
        CallSite serverGroupName = IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description);
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, credentials);
        CallSite compute = IndyInterface.bootstrap("getProperty", "compute", 0, credentials);
        CallSite accountName = IndyInterface.bootstrap("getProperty", "accountName", 4, this.description);
        CallSite region = IndyInterface.bootstrap("getProperty", "region", 4, this.description);
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "queryServerGroup", 0, GCEUtil.class, this.googleClusterProvider, accountName, region, serverGroupName);
        CallSite isRegional = IndyInterface.bootstrap("getProperty", "regional", 0, serverGroup);
        CallSite zone = IndyInterface.bootstrap("getProperty", "zone", 0, serverGroup);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "deleteAutoHealingPolicy", 4, this.description)) != false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description)}, new String[]{"Initializing deletion of autoHealing policy for ", "..."}));
            if (IndyInterface.bootstrap("cast", "()", 0, isRegional) != false) {
                CallSite request = IndyInterface.bootstrap("invoke", "setAutoHealingPolicies", 0, IndyInterface.bootstrap("init", "<init>", 0, RegionInstanceGroupManagersSetAutoHealingRequest.class), ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                CallSite deleteOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setAutoHealingPolicies", 0, IndyInterface.bootstrap("invoke", "regionInstanceGroupManagers", 0, compute), project, region, serverGroupName, request), "compute.regionInstanceGroupManagers.setAutoHealingPolicies", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_REGION", 0, GoogleExecutor.class), region);
                IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, this.googleOperationPoller, compute, project, region, IndyInterface.bootstrap("invoke", "getName", 0, deleteOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{serverGroupName}, new String[]{"autoHealing policy for ", ""}), BASE_PHASE);
                IndyInterface.bootstrap("invoke", "deletePolicyMetadata", 2, this, compute, credentials, project, IndyInterface.bootstrap("invoke", "buildRegionalServerGroupUrl", 0, GCEUtil.class, project, region, serverGroupName));
            } else {
                CallSite request = IndyInterface.bootstrap("invoke", "setAutoHealingPolicies", 0, IndyInterface.bootstrap("init", "<init>", 0, InstanceGroupManagersSetAutoHealingRequest.class), ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                CallSite deleteOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setAutoHealingPolicies", 0, IndyInterface.bootstrap("invoke", "instanceGroupManagers", 0, compute), project, zone, serverGroupName, request), "compute.instanceGroupManagers.setAutoHealingPolicies", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 0, GoogleExecutor.class), zone);
                IndyInterface.bootstrap("invoke", "waitForZonalOperation", 0, this.googleOperationPoller, compute, project, zone, IndyInterface.bootstrap("invoke", "getName", 0, deleteOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{serverGroupName}, new String[]{"autoHealing policy for ", ""}), BASE_PHASE);
                IndyInterface.bootstrap("invoke", "deletePolicyMetadata", 2, this, compute, credentials, project, IndyInterface.bootstrap("invoke", "buildZonalServerGroupUrl", 0, GCEUtil.class, project, zone, serverGroupName));
            }
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName}, new String[]{"Done deleting autoHealing policy for ", "."}));
        } else {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description)}, new String[]{"Initializing deletion of scaling policy for ", "..."}));
            if (IndyInterface.bootstrap("cast", "()", 0, isRegional) != false) {
                CallSite deleteOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "regionAutoscalers", 0, compute), project, region, serverGroupName), "compute.regionAutoscalers.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_REGION", 0, GoogleExecutor.class), region);
                IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, this.googleOperationPoller, compute, project, region, IndyInterface.bootstrap("invoke", "getName", 0, deleteOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{serverGroupName}, new String[]{"autoScaling policy for ", ""}), BASE_PHASE);
                IndyInterface.bootstrap("invoke", "deletePolicyMetadata", 2, this, compute, credentials, project, IndyInterface.bootstrap("invoke", "buildRegionalServerGroupUrl", 0, GCEUtil.class, project, region, serverGroupName));
            } else {
                CallSite deleteOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "autoscalers", 0, compute), project, zone, serverGroupName), "compute.autoscalers.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 0, GoogleExecutor.class), zone);
                IndyInterface.bootstrap("invoke", "waitForZonalOperation", 0, this.googleOperationPoller, compute, project, zone, IndyInterface.bootstrap("invoke", "getName", 0, deleteOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{serverGroupName}, new String[]{"autoScaling policy for ", ""}), BASE_PHASE);
                IndyInterface.bootstrap("invoke", "deletePolicyMetadata", 2, this, compute, credentials, project, IndyInterface.bootstrap("invoke", "buildZonalServerGroupUrl", 0, GCEUtil.class, project, zone, serverGroupName));
            }
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName}, new String[]{"Done deleting scaling policy for ", "."}));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public void deletePolicyMetadata(Compute compute, GoogleNamedAccountCredentials credentials, String project, String groupUrl) {
        CallSite groupName = IndyInterface.bootstrap("invoke", "getLocalName", 0, Utils.class, groupUrl);
        CallSite groupRegion = IndyInterface.bootstrap("invoke", "getRegionFromGroupUrl", 0, Utils.class, groupUrl);
        CallSite templateUrl = null;
        CallSite callSite = IndyInterface.bootstrap("invoke", "determineServerGroupType", 0, Utils.class, groupUrl);
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "REGIONAL", 0, GoogleServerGroup.ServerGroupType.class))) {
            templateUrl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceTemplate", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "regionInstanceGroupManagers", 0, compute), project, groupRegion, groupName), "compute.regionInstanceGroupManagers.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_REGION", 0, GoogleExecutor.class), groupRegion)));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "ZONAL", 0, GoogleServerGroup.ServerGroupType.class))) {
            CallSite groupZone = IndyInterface.bootstrap("invoke", "getZoneFromGroupUrl", 0, Utils.class, groupUrl);
            templateUrl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceTemplate", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "instanceGroupManagers", 0, compute), project, groupZone, groupName), "compute.instanceGroupManagers.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 0, GoogleExecutor.class), groupZone)));
        } else {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{groupUrl}, new String[]{"Server group referenced by ", " has illegal type."})));
        }
        CallSite template = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "instanceTemplates", 0, compute), project, IndyInterface.bootstrap("invoke", "getLocalName", 0, Utils.class, templateUrl)), "compute.instancesTemplates.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 0, GoogleExecutor.class)));
        CallSite instanceDescription = IndyInterface.bootstrap("invoke", "buildInstanceDescriptionFromTemplate", 0, GCEUtil.class, project, template);
        Map templateOpMap = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"image", IndyInterface.bootstrap("getProperty", "image", 0, instanceDescription), "instanceType", IndyInterface.bootstrap("getProperty", "instanceType", 0, instanceDescription), "credentials", IndyInterface.bootstrap("invoke", "getName", 0, credentials), "disks", IndyInterface.bootstrap("getProperty", "disks", 0, instanceDescription), "instanceMetadata", IndyInterface.bootstrap("getProperty", "instanceMetadata", 0, instanceDescription), "tags", IndyInterface.bootstrap("getProperty", "tags", 0, instanceDescription), "network", IndyInterface.bootstrap("getProperty", "network", 0, instanceDescription), "subnet", IndyInterface.bootstrap("getProperty", "subnet", 0, instanceDescription), "serviceAccountEmail", IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 0, instanceDescription), "authScopes", IndyInterface.bootstrap("getProperty", "authScopes", 0, instanceDescription), "preemptible", IndyInterface.bootstrap("getProperty", "preemptible", 0, instanceDescription), "automaticRestart", IndyInterface.bootstrap("getProperty", "automaticRestart", 0, instanceDescription), "onHostMaintenance", IndyInterface.bootstrap("getProperty", "onHostMaintenance", 0, instanceDescription), "region", groupRegion, "serverGroupName", groupName});
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "minCpuPlatform", 0, instanceDescription)) != false) {
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "minCpuPlatform", 0, instanceDescription);
            ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)templateOpMap, (String)"minCpuPlatform");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "instanceMetadata", 1, templateOpMap)) != false) {
            IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("getProperty", "instanceMetadata", 0, templateOpMap), IndyInterface.bootstrap("getProperty", "AUTOSCALING_POLICY", 0, GCEUtil.class));
            CallSite converter = IndyInterface.bootstrap("invoke", "getAtomicOperationConverter", 0, this.atomicOperationsRegistry, "modifyGoogleServerGroupInstanceTemplateDescription", "gce");
            CallSite templateOp = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertOperation", 0, converter, templateOpMap));
            IndyInterface.bootstrap("invoke", "process", 0, this.orchestrationProcessor, "gce", ScriptBytecodeAdapter.createList((Object[])new Object[]{templateOp}), IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)));
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeleteGoogleAutoscalingPolicyAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public AtomicOperationsRegistry getAtomicOperationsRegistry() {
        return this.atomicOperationsRegistry;
    }

    @Generated
    public @VisibleForTesting void setAtomicOperationsRegistry(AtomicOperationsRegistry atomicOperationsRegistry) {
        this.atomicOperationsRegistry = atomicOperationsRegistry;
    }

    @Generated
    public OrchestrationProcessor getOrchestrationProcessor() {
        return this.orchestrationProcessor;
    }

    @Generated
    public @VisibleForTesting void setOrchestrationProcessor(OrchestrationProcessor orchestrationProcessor) {
        this.orchestrationProcessor = orchestrationProcessor;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

