/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.google.api.services.compute.Compute;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeApiFactory;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.DestroyGoogleServerGroupDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleLoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DestroyGoogleServerGroupAtomicOperation
extends GoogleAtomicOperation<Void> {
    private static final String BASE_PHASE = "DESTROY_SERVER_GROUP";
    private static final List<Integer> RETRY_ERROR_CODES;
    private static final List<Integer> SUCCESSFUL_ERROR_CODES;
    private final DestroyGoogleServerGroupDescription description;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private GoogleClusterProvider googleClusterProvider;
    @Autowired
    private GoogleLoadBalancerProvider googleLoadBalancerProvider;
    @Autowired
    private SafeRetry safeRetry;
    @Autowired
    private GoogleComputeApiFactory computeApiFactory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DestroyGoogleServerGroupAtomicOperation(DestroyGoogleServerGroupDescription description) {
        DestroyGoogleServerGroupDescription destroyGoogleServerGroupDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = destroyGoogleServerGroupDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description)}, new String[]{"Initializing destruction of server group ", " in "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "region", 4, this.description)}, new String[]{"", "..."})));
        CallSite accountName = IndyInterface.bootstrap("getProperty", "accountName", 4, this.description);
        CallSite credentials = IndyInterface.bootstrap("getProperty", "credentials", 4, this.description);
        CallSite compute = IndyInterface.bootstrap("getProperty", "compute", 0, credentials);
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, credentials);
        CallSite region = IndyInterface.bootstrap("getProperty", "region", 4, this.description);
        CallSite serverGroupName = IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description);
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "queryServerGroup", 0, GCEUtil.class, this.googleClusterProvider, accountName, region, serverGroupName);
        CallSite isRegional = IndyInterface.bootstrap("getProperty", "regional", 0, serverGroup);
        CallSite zone = IndyInterface.bootstrap("getProperty", "zone", 0, serverGroup);
        CallSite instanceTemplateName = IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "instanceTemplate", 0, IndyInterface.bootstrap("getProperty", "launchConfig", 0, serverGroup)));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Identified instance template.");
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Checking for autoscaler...");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 0, serverGroup)) != false) {
            Map tags = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "phase", BASE_PHASE});
            if (IndyInterface.bootstrap("cast", "()", 0, isRegional) != false) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this);
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), callSite);
                CallSite callSite2 = region;
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), callSite2);
                String string = "compute.regionAutoscalers.delete";
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, "operation", string);
            } else {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this);
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), callSite);
                CallSite callSite3 = zone;
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), callSite3);
                String string = "compute.autoscalers.delete";
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, "operation", string);
            }
            IndyInterface.bootstrap("invoke", "destroy", 2, this, IndyInterface.bootstrap("invoke", "destroyAutoscaler", 2, this, compute, serverGroupName, project, region, zone, isRegional), "autoscaler", tags);
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Deleted autoscaler");
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Checking for associated HTTP(S) load balancer backend services...");
        IndyInterface.bootstrap("invoke", "destroy", 2, this, IndyInterface.bootstrap("invoke", "destroyHttpLoadBalancerBackends", 2, this, compute, project, serverGroup, this.googleLoadBalancerProvider), "Http load balancer backends", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "destroy", "operation", "destroyHttpLoadBalancerBackends", "phase", BASE_PHASE, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Checking for associated Internal load balancer backend services...");
        IndyInterface.bootstrap("invoke", "destroy", 2, this, IndyInterface.bootstrap("invoke", "destroyInternalLoadBalancerBackends", 2, this, compute, project, serverGroup, this.googleLoadBalancerProvider), "Internal load balancer backends", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "destroy", "operation", "destroyInternalLoadBalancerBackends", "phase", BASE_PHASE, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Checking for associated Ssl load balancer backend services...");
        IndyInterface.bootstrap("invoke", "destroy", 2, this, IndyInterface.bootstrap("invoke", "destroySslLoadBalancerBackends", 2, this, compute, project, serverGroup, this.googleLoadBalancerProvider), "Ssl load balancer backends", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "destroy", "operation", "destroySslLoadBalancerBackends", "phase", BASE_PHASE, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Checking for associated Tcp load balancer backend services...");
        IndyInterface.bootstrap("invoke", "destroy", 2, this, IndyInterface.bootstrap("invoke", "destroyTcpLoadBalancerBackends", 2, this, compute, project, serverGroup, this.googleLoadBalancerProvider), "Tcp load balancer backends", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "destroy", "operation", "destroyTcpLoadBalancerBackends", "phase", BASE_PHASE, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}));
        if (true) {
            Map tags = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "phase", BASE_PHASE});
            if (IndyInterface.bootstrap("cast", "()", 0, isRegional) != false) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this);
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), callSite);
                CallSite callSite4 = region;
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), callSite4);
                String string = "compute.regionInstanceGroupManagers.delete";
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, "operation", string);
            } else {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this);
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), callSite);
                CallSite callSite5 = zone;
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), callSite5);
                String string = "compute.instanceGroupManagers.delete";
                IndyInterface.bootstrap("invoke", "putAt", 0, tags, "operation", string);
            }
            IndyInterface.bootstrap("invoke", "destroy", 2, this, IndyInterface.bootstrap("invoke", "destroyInstanceGroup", 2, this, credentials, serverGroup), "instance group", tags);
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Deleted instance group.");
        IndyInterface.bootstrap("invoke", "destroy", 2, this, IndyInterface.bootstrap("invoke", "destroyInstanceTemplate", 2, this, compute, instanceTemplateName, project), "instance template", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "operation", "compute.instanceTemplates.delete", "phase", BASE_PHASE, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Deleted instance template.");
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName, region}, new String[]{"Done destroying server group ", " in ", "."}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public void destroy(Closure operation, String resource, Map tags) {
        IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, operation, resource, IndyInterface.bootstrap("getProperty", "task", 12, this), RETRY_ERROR_CODES, SUCCESSFUL_ERROR_CODES, tags, IndyInterface.bootstrap("getProperty", "registry", 12, this));
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroyInstanceTemplate(Compute compute, String instanceTemplateName, String project) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference instanceTemplateName2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)var3_3);
        public final class _destroyInstanceTemplate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference instanceTemplateName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroyInstanceTemplate_closure1(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference instanceTemplateName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.compute = reference3 = compute;
                this.project = reference2 = project;
                this.instanceTemplateName = reference = instanceTemplateName;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "instanceTemplates", 0, IndyInterface.bootstrap("cast", "()", 0, this.compute.get())), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("cast", "()", 0, this.instanceTemplateName.get())), "compute.instanceTemplates.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                return null;
            }

            @Generated
            public Compute getCompute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
            }

            @Generated
            public String getProject() {
                return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
            }

            @Generated
            public String getInstanceTemplateName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.instanceTemplateName.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyInstanceTemplate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroyInstanceTemplate_closure1(this, this, compute2, project2, instanceTemplateName2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroyAutoscaler(Compute compute, String serverGroupName, String project, String region, String zone, Boolean isRegional) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference serverGroupName2 = new Reference((Object)var2_2);
        Reference project2 = new Reference((Object)var3_3);
        Reference region2 = new Reference((Object)region);
        Reference zone2 = new Reference((Object)zone);
        Reference isRegional2 = new Reference((Object)isRegional);
        public final class _destroyAutoscaler_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference isRegional;
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference serverGroupName;
            private /* synthetic */ Reference zone;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroyAutoscaler_closure2(Object _outerInstance, Object _thisObject, Reference isRegional, Reference compute, Reference project, Reference region, Reference serverGroupName, Reference zone) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.isRegional = reference6 = isRegional;
                this.compute = reference5 = compute;
                this.project = reference4 = project;
                this.region = reference3 = region;
                this.serverGroupName = reference2 = serverGroupName;
                this.zone = reference = zone;
            }

            public Object doCall(Object it) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.isRegional.get())) != false) {
                    CallSite autoscalerDeleteOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "regionAutoscalers", 0, IndyInterface.bootstrap("cast", "()", 0, this.compute.get())), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("cast", "()", 0, this.region.get()), IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get())), "compute.regionAutoscalers.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.region.get()));
                    CallSite autoscalerDeleteOperationName = IndyInterface.bootstrap("invoke", "getName", 0, autoscalerDeleteOperation);
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), "Waiting on delete operation for autoscaler...");
                    IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.compute.get()), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("cast", "()", 0, this.region.get()), autoscalerDeleteOperationName, null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get())}, new String[]{"regional autoscaler ", ""}), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
                } else {
                    CallSite autoscalerDeleteOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "autoscalers", 0, IndyInterface.bootstrap("cast", "()", 0, this.compute.get())), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("cast", "()", 0, this.zone.get()), IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get())), "compute.autoscalers.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.zone.get()));
                    CallSite autoscalerDeleteOperationName = IndyInterface.bootstrap("invoke", "getName", 0, autoscalerDeleteOperation);
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), "Waiting on delete operation for autoscaler...");
                    IndyInterface.bootstrap("invoke", "waitForZonalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.compute.get()), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("cast", "()", 0, this.zone.get()), autoscalerDeleteOperationName, null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get())}, new String[]{"zonal autoscaler ", ""}), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
                }
                return null;
            }

            @Generated
            public Boolean getIsRegional() {
                return IndyInterface.bootstrap("cast", "()", 0, this.isRegional.get());
            }

            @Generated
            public Compute getCompute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
            }

            @Generated
            public String getProject() {
                return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
            }

            @Generated
            public String getRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
            }

            @Generated
            public String getServerGroupName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroupName.get());
            }

            @Generated
            public String getZone() {
                return IndyInterface.bootstrap("cast", "()", 0, this.zone.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyAutoscaler_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroyAutoscaler_closure2(this, this, isRegional2, compute2, project2, region2, serverGroupName2, zone2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroyHttpLoadBalancerBackends(Compute compute, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference googleLoadBalancerProvider2 = new Reference((Object)googleLoadBalancerProvider);
        public final class _destroyHttpLoadBalancerBackends_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroyHttpLoadBalancerBackends_closure3(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.serverGroup = reference2 = serverGroup;
                this.googleLoadBalancerProvider = reference = googleLoadBalancerProvider;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "destroyHttpLoadBalancerBackends", 0, GCEUtil.class, IndyInterface.bootstrap("cast", "()", 0, this.compute.get()), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()), IndyInterface.bootstrap("cast", "()", 0, this.googleLoadBalancerProvider.get()), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Compute getCompute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
            }

            @Generated
            public String getProject() {
                return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
            }

            @Generated
            public GoogleServerGroup.View getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            @Generated
            public GoogleLoadBalancerProvider getGoogleLoadBalancerProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.googleLoadBalancerProvider.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyHttpLoadBalancerBackends_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroyHttpLoadBalancerBackends_closure3(this, this, compute2, project2, serverGroup2, googleLoadBalancerProvider2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroyInternalLoadBalancerBackends(Compute compute, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference googleLoadBalancerProvider2 = new Reference((Object)googleLoadBalancerProvider);
        public final class _destroyInternalLoadBalancerBackends_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroyInternalLoadBalancerBackends_closure4(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.serverGroup = reference2 = serverGroup;
                this.googleLoadBalancerProvider = reference = googleLoadBalancerProvider;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "destroyInternalLoadBalancerBackends", 0, GCEUtil.class, IndyInterface.bootstrap("cast", "()", 0, this.compute.get()), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()), IndyInterface.bootstrap("cast", "()", 0, this.googleLoadBalancerProvider.get()), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Compute getCompute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
            }

            @Generated
            public String getProject() {
                return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
            }

            @Generated
            public GoogleServerGroup.View getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            @Generated
            public GoogleLoadBalancerProvider getGoogleLoadBalancerProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.googleLoadBalancerProvider.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyInternalLoadBalancerBackends_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroyInternalLoadBalancerBackends_closure4(this, this, compute2, project2, serverGroup2, googleLoadBalancerProvider2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroySslLoadBalancerBackends(Compute compute, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference googleLoadBalancerProvider2 = new Reference((Object)googleLoadBalancerProvider);
        public final class _destroySslLoadBalancerBackends_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroySslLoadBalancerBackends_closure5(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.serverGroup = reference2 = serverGroup;
                this.googleLoadBalancerProvider = reference = googleLoadBalancerProvider;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "destroySslLoadBalancerBackends", 0, GCEUtil.class, IndyInterface.bootstrap("cast", "()", 0, this.compute.get()), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()), IndyInterface.bootstrap("cast", "()", 0, this.googleLoadBalancerProvider.get()), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Compute getCompute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
            }

            @Generated
            public String getProject() {
                return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
            }

            @Generated
            public GoogleServerGroup.View getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            @Generated
            public GoogleLoadBalancerProvider getGoogleLoadBalancerProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.googleLoadBalancerProvider.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroySslLoadBalancerBackends_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroySslLoadBalancerBackends_closure5(this, this, compute2, project2, serverGroup2, googleLoadBalancerProvider2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroyTcpLoadBalancerBackends(Compute compute, String project, GoogleServerGroup.View serverGroup, GoogleLoadBalancerProvider googleLoadBalancerProvider) {
        void var3_3;
        void var2_2;
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)var2_2);
        Reference serverGroup2 = new Reference((Object)var3_3);
        Reference googleLoadBalancerProvider2 = new Reference((Object)googleLoadBalancerProvider);
        public final class _destroyTcpLoadBalancerBackends_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference serverGroup;
            private /* synthetic */ Reference googleLoadBalancerProvider;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroyTcpLoadBalancerBackends_closure6(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference serverGroup, Reference googleLoadBalancerProvider) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.serverGroup = reference2 = serverGroup;
                this.googleLoadBalancerProvider = reference = googleLoadBalancerProvider;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "destroyTcpLoadBalancerBackends", 0, GCEUtil.class, IndyInterface.bootstrap("cast", "()", 0, this.compute.get()), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()), IndyInterface.bootstrap("cast", "()", 0, this.googleLoadBalancerProvider.get()), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.getThisObject());
                return null;
            }

            @Generated
            public Compute getCompute() {
                return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
            }

            @Generated
            public String getProject() {
                return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
            }

            @Generated
            public GoogleServerGroup.View getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            @Generated
            public GoogleLoadBalancerProvider getGoogleLoadBalancerProvider() {
                return IndyInterface.bootstrap("cast", "()", 0, this.googleLoadBalancerProvider.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyTcpLoadBalancerBackends_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroyTcpLoadBalancerBackends_closure6(this, this, compute2, project2, serverGroup2, googleLoadBalancerProvider2);
    }

    /*
     * WARNING - void declaration
     */
    public Closure destroyInstanceGroup(GoogleNamedAccountCredentials credentials, GoogleServerGroup.View serverGroup) {
        void var2_2;
        Reference credentials2 = new Reference((Object)credentials);
        Reference serverGroup2 = new Reference((Object)var2_2);
        public final class _destroyInstanceGroup_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _destroyInstanceGroup_closure7(Object _outerInstance, Object _thisObject, Reference credentials, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.credentials = reference2 = credentials;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                CallSite serverGroupManagers = IndyInterface.bootstrap("invoke", "createServerGroupManagers", 0, IndyInterface.bootstrap("getProperty", "computeApiFactory", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.credentials.get()), IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()));
                CallSite deleteOperation = IndyInterface.bootstrap("invoke", "delete", 0, serverGroupManagers);
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), "Waiting on delete operation for managed instance group...");
                IndyInterface.bootstrap("invoke", "executeAndWait", 0, deleteOperation, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
                return null;
            }

            @Generated
            public GoogleNamedAccountCredentials getCredentials() {
                return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
            }

            @Generated
            public GoogleServerGroup.View getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _destroyInstanceGroup_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return new _destroyInstanceGroup_closure7(this, this, credentials2, serverGroup2);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DestroyGoogleServerGroupAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        List list;
        List list2;
        RETRY_ERROR_CODES = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 412});
        SUCCESSFUL_ERROR_CODES = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{404});
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.google.deploy.ops.DestroyGoogleServerGroupAtomicOperation");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public GoogleOperationPoller getGoogleOperationPoller() {
        return this.googleOperationPoller;
    }

    @Generated
    public @VisibleForTesting void setGoogleOperationPoller(GoogleOperationPoller googleOperationPoller) {
        this.googleOperationPoller = googleOperationPoller;
    }

    @Generated
    public GoogleClusterProvider getGoogleClusterProvider() {
        return this.googleClusterProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleClusterProvider(GoogleClusterProvider googleClusterProvider) {
        this.googleClusterProvider = googleClusterProvider;
    }

    @Generated
    public GoogleLoadBalancerProvider getGoogleLoadBalancerProvider() {
        return this.googleLoadBalancerProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleLoadBalancerProvider(GoogleLoadBalancerProvider googleLoadBalancerProvider) {
        this.googleLoadBalancerProvider = googleLoadBalancerProvider;
    }

    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Generated
    public @VisibleForTesting void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    @Generated
    public GoogleComputeApiFactory getComputeApiFactory() {
        return this.computeApiFactory;
    }

    @Generated
    public @VisibleForTesting void setComputeApiFactory(GoogleComputeApiFactory googleComputeApiFactory) {
        this.computeApiFactory = googleComputeApiFactory;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

