/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.google.api.services.compute.model.InstanceGroupManagersSetInstanceTemplateRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersSetTemplateRequest;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.config.GoogleConfigurationProperties;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.BaseGoogleInstanceDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.description.ModifyGoogleServerGroupInstanceTemplateDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleNetworkProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSubnetProvider;
import com.netflix.spinnaker.config.GoogleConfiguration;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class ModifyGoogleServerGroupInstanceTemplateAtomicOperation
extends GoogleAtomicOperation<Void> {
    private static final String BASE_PHASE = "MODIFY_SERVER_GROUP_INSTANCE_TEMPLATE";
    private static final String accessConfigName = "External NAT";
    private static final String accessConfigType = "ONE_TO_ONE_NAT";
    private final ModifyGoogleServerGroupInstanceTemplateDescription description;
    @Autowired
    private GoogleConfigurationProperties googleConfigurationProperties;
    @Autowired
    private GoogleConfiguration.DeployDefaults googleDeployDefaults;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private GoogleClusterProvider googleClusterProvider;
    @Autowired
    private GoogleNetworkProvider googleNetworkProvider;
    @Autowired
    private GoogleSubnetProvider googleSubnetProvider;
    @Autowired
    private String clouddriverUserAgentApplicationName;
    @Autowired
    private SafeRetry safeRetry;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ModifyGoogleServerGroupInstanceTemplateAtomicOperation(ModifyGoogleServerGroupInstanceTemplateDescription description) {
        ModifyGoogleServerGroupInstanceTemplateDescription modifyGoogleServerGroupInstanceTemplateDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = modifyGoogleServerGroupInstanceTemplateDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description)}, new String[]{"Initializing modification of instance template for ", " "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "region", 4, this.description)}, new String[]{"in ", "..."})));
        CallSite accountName = IndyInterface.bootstrap("getProperty", "accountName", 4, this.description);
        CallSite credentials = IndyInterface.bootstrap("getProperty", "credentials", 4, this.description);
        CallSite compute = IndyInterface.bootstrap("getProperty", "compute", 0, credentials);
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, credentials);
        CallSite region = IndyInterface.bootstrap("getProperty", "region", 4, this.description);
        CallSite canIpForward = IndyInterface.bootstrap("getProperty", "canIpForward", 4, this.description);
        CallSite serverGroupName = IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description);
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "queryServerGroup", 0, GCEUtil.class, this.googleClusterProvider, accountName, region, serverGroupName);
        CallSite isRegional = IndyInterface.bootstrap("getProperty", "regional", 0, serverGroup);
        CallSite zone = IndyInterface.bootstrap("getProperty", "zone", 0, serverGroup);
        CallSite location = IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? region : zone;
        CallSite instanceGroupManagers = IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? IndyInterface.bootstrap("invoke", "regionInstanceGroupManagers", 0, compute) : IndyInterface.bootstrap("invoke", "instanceGroupManagers", 0, compute);
        CallSite instanceTemplates = IndyInterface.bootstrap("invoke", "instanceTemplates", 0, compute);
        CallSite managedInstanceGroup = IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, instanceGroupManagers, project, region, serverGroupName), "compute.regionInstanceGroupManagers", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region) : IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, instanceGroupManagers, project, zone, serverGroupName), "compute.instanceGroupManagers.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), zone);
        CallSite origInstanceTemplateName = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "instanceTemplate", 0, managedInstanceGroup));
        if (IndyInterface.bootstrap("cast", "()", 0, origInstanceTemplateName) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceNotFoundException.class, new GStringImpl(new Object[]{serverGroupName}, new String[]{"Unable to determine instance template for server group ", "."})));
        }
        CallSite instanceTemplate = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, instanceTemplates, project, origInstanceTemplateName), "compute.instanceTemplates.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
        CallSite originalDescription = IndyInterface.bootstrap("invoke", "buildInstanceDescriptionFromTemplate", 0, GCEUtil.class, project, instanceTemplate);
        CallSite properties = IndyInterface.bootstrap("invoke", "plus", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), IndyInterface.bootstrap("getProperty", "properties", 4, this.description));
        IndyInterface.bootstrap("invoke", "removeAll", 0, IndyInterface.bootstrap("invoke", "keySet", 0, properties), ScriptBytecodeAdapter.createList((Object[])new Object[]{"class", "serverGroupName", "region", "accountName", "credentials", "applications"}));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object key, Object value) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)value, null) ? ScriptBytecodeAdapter.createMap((Object[])new Object[]{key, value}) : null;
            }

            @Generated
            public Object call(Object key, Object value) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, key, value);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite overriddenProperties = IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "findResults", 0, properties, new _operate_closure1(this, this)));
        CallSite newDescriptionProperties = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), IndyInterface.bootstrap("getProperty", "properties", 0, originalDescription)), overriddenProperties);
        IndyInterface.bootstrap("invoke", "removeAll", 0, IndyInterface.bootstrap("invoke", "keySet", 0, newDescriptionProperties), ScriptBytecodeAdapter.createList((Object[])new Object[]{"class", "accountName", "credentials", "account", "name"}));
        CallSite callSite = IndyInterface.bootstrap("invoke", "resolveAuthScopes", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "authScopes", 0, newDescriptionProperties));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)newDescriptionProperties, (String)"authScopes");
        CallSite newDescription = IndyInterface.bootstrap("init", "<init>", 0, BaseGoogleInstanceDescription.class, newDescriptionProperties);
        if (ScriptBytecodeAdapter.compareEqual((Object)newDescription, (Object)originalDescription)) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName, region}, new String[]{"No changes required for instance template of ", " in ", "."}));
        } else {
            CallSite instanceTemplateProperties = IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate);
            IndyInterface.bootstrap("invoke", "setName", 0, instanceTemplate, new GStringImpl(new Object[]{serverGroupName, IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class)}, new String[]{"", "-", ""}));
            if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "image", 0, overriddenProperties)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "disks", 0, overriddenProperties)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "instanceType", 0, overriddenProperties))) {
                CallSite clonedDescription = IndyInterface.bootstrap("invoke", "clone", 0, this.description);
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "disks", 0, overriddenProperties);
                ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)clonedDescription, (String)"disks");
                CallSite callSite3 = IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description);
                ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)clonedDescription, (String)"baseDeviceName");
                CallSite bootImage = IndyInterface.bootstrap("invoke", "getBootImage", 0, GCEUtil.class, this.description, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this.clouddriverUserAgentApplicationName, IndyInterface.bootstrap("getProperty", "baseImageProjects", 4, this.googleConfigurationProperties), this.safeRetry, this);
                CallSite attachedDisks = IndyInterface.bootstrap("invoke", "buildAttachedDisks", 0, GCEUtil.class, clonedDescription, null, false, this.googleDeployDefaults, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this.clouddriverUserAgentApplicationName, IndyInterface.bootstrap("getProperty", "baseImageProjects", 4, this.googleConfigurationProperties), bootImage, this.safeRetry, this);
                IndyInterface.bootstrap("invoke", "setDisks", 0, instanceTemplateProperties, attachedDisks);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "instanceType", 0, overriddenProperties)) != false) {
                CallSite machineTypeName = null;
                machineTypeName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("getProperty", "instanceType", 4, this.description), "custom")) != false ? IndyInterface.bootstrap("getProperty", "instanceType", 4, this.description) : IndyInterface.bootstrap("invoke", "queryMachineType", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "instanceType", 4, this.description), location, credentials, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE);
                IndyInterface.bootstrap("invoke", "setMachineType", 0, instanceTemplateProperties, machineTypeName);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "minCpuPlatform", 0, overriddenProperties)) != false) {
                IndyInterface.bootstrap("invoke", "setMinCpuPlatform", 0, instanceTemplateProperties, IndyInterface.bootstrap("getProperty", "minCpuPlatform", 4, this.description));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "canIpForward", 0, overriddenProperties)) != false) {
                IndyInterface.bootstrap("invoke", "setCanIpForward", 0, instanceTemplateProperties, canIpForward);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "shieldedVmConfig", 0, overriddenProperties)) != false) {
                IndyInterface.bootstrap("invoke", "setShieldedVmConfig", 0, instanceTemplateProperties, IndyInterface.bootstrap("getProperty", "shieldedVmConfig", 4, this.description));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "instanceMetadata", 0, overriddenProperties)) != false) {
                CallSite metadata = IndyInterface.bootstrap("invoke", "buildMetadataFromMap", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "instanceMetadata", 4, this.description));
                IndyInterface.bootstrap("invoke", "setMetadata", 0, instanceTemplateProperties, metadata);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "tags", 0, overriddenProperties)) != false) {
                CallSite tags = IndyInterface.bootstrap("invoke", "buildTagsFromList", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "tags", 4, this.description));
                IndyInterface.bootstrap("invoke", "setTags", 0, instanceTemplateProperties, tags);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "labels", 0, overriddenProperties)) != false) {
                IndyInterface.bootstrap("invoke", "setLabels", 0, instanceTemplateProperties, IndyInterface.bootstrap("getProperty", "labels", 4, this.description));
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 0, overriddenProperties), null) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "authScopes", 0, overriddenProperties), null)) {
                CallSite serviceAccount = IndyInterface.bootstrap("invoke", "buildServiceAccount", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 4, this.description), IndyInterface.bootstrap("getProperty", "authScopes", 4, this.description));
                IndyInterface.bootstrap("invoke", "setServiceAccounts", 0, instanceTemplateProperties, serviceAccount);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "network", 0, overriddenProperties)) != false) {
                CallSite network = IndyInterface.bootstrap("invoke", "queryNetwork", 0, GCEUtil.class, accountName, IndyInterface.bootstrap("getProperty", "network", 0, newDescription), IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this.googleNetworkProvider);
                CallSite subnet = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnet", 4, this.description)) != false ? IndyInterface.bootstrap("invoke", "querySubnet", 0, GCEUtil.class, accountName, region, IndyInterface.bootstrap("getProperty", "subnet", 4, this.description), IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this.googleSubnetProvider) : null;
                CallSite networkInterface = IndyInterface.bootstrap("invoke", "buildNetworkInterface", 0, GCEUtil.class, network, subnet, ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "associatePublicIpAddress", 4, this.description), null) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "associatePublicIpAddress", 4, this.description)), accessConfigName, accessConfigType);
                IndyInterface.bootstrap("invoke", "setNetworkInterfaces", 0, instanceTemplateProperties, ScriptBytecodeAdapter.createList((Object[])new Object[]{networkInterface}));
            }
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate)}, new String[]{"Inserting new instance template ", "..."}));
            CallSite instanceTemplateCreateOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, instanceTemplates, project, instanceTemplate), "compute.instanceTemplates.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
            CallSite instanceTemplateUrl = IndyInterface.bootstrap("getProperty", "targetLink", 0, instanceTemplateCreateOperation);
            IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute, project, IndyInterface.bootstrap("invoke", "getName", 0, instanceTemplateCreateOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate)}, new String[]{"instance template ", ""}), BASE_PHASE);
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate), serverGroupName}, new String[]{"Setting instance template ", " on server group ", "..."}));
            if (IndyInterface.bootstrap("cast", "()", 0, isRegional) != false) {
                CallSite regionInstanceGroupManagersSetTemplateRequest = IndyInterface.bootstrap("init", "<init>", 0, RegionInstanceGroupManagersSetTemplateRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceTemplate", instanceTemplateUrl}));
                CallSite setInstanceTemplateOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setInstanceTemplate", 0, instanceGroupManagers, project, region, serverGroupName, regionInstanceGroupManagersSetTemplateRequest), "compute.regionInstanceGroupManagers.setInstanceTemplate", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region);
                IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, this.googleOperationPoller, compute, project, region, IndyInterface.bootstrap("invoke", "getName", 0, setInstanceTemplateOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{serverGroupName}, new String[]{"server group ", ""}), BASE_PHASE);
            } else {
                CallSite instanceGroupManagersSetInstanceTemplateRequest = IndyInterface.bootstrap("init", "<init>", 0, InstanceGroupManagersSetInstanceTemplateRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceTemplate", instanceTemplateUrl}));
                CallSite setInstanceTemplateOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setInstanceTemplate", 0, instanceGroupManagers, project, zone, serverGroupName, instanceGroupManagersSetInstanceTemplateRequest), "compute.instanceGroupManagers.setInstanceTemplate", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), zone);
                IndyInterface.bootstrap("invoke", "waitForZonalOperation", 0, this.googleOperationPoller, compute, project, zone, IndyInterface.bootstrap("invoke", "getName", 0, setInstanceTemplateOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{serverGroupName}, new String[]{"server group ", ""}), BASE_PHASE);
            }
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{origInstanceTemplateName}, new String[]{"Deleting original instance template ", "..."}));
            IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, instanceTemplates, project, origInstanceTemplateName), "compute.instanceTemplates.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName, region}, new String[]{"Done modifying instance template of ", " in ", "."}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ModifyGoogleServerGroupInstanceTemplateAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public GoogleConfigurationProperties getGoogleConfigurationProperties() {
        return this.googleConfigurationProperties;
    }

    @Generated
    public @VisibleForTesting void setGoogleConfigurationProperties(GoogleConfigurationProperties googleConfigurationProperties) {
        this.googleConfigurationProperties = googleConfigurationProperties;
    }

    @Generated
    public GoogleConfiguration.DeployDefaults getGoogleDeployDefaults() {
        return this.googleDeployDefaults;
    }

    @Generated
    public @VisibleForTesting void setGoogleDeployDefaults(GoogleConfiguration.DeployDefaults deployDefaults) {
        this.googleDeployDefaults = deployDefaults;
    }

    @Generated
    public GoogleOperationPoller getGoogleOperationPoller() {
        return this.googleOperationPoller;
    }

    @Generated
    public @VisibleForTesting void setGoogleOperationPoller(GoogleOperationPoller googleOperationPoller) {
        this.googleOperationPoller = googleOperationPoller;
    }

    @Generated
    public GoogleClusterProvider getGoogleClusterProvider() {
        return this.googleClusterProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleClusterProvider(GoogleClusterProvider googleClusterProvider) {
        this.googleClusterProvider = googleClusterProvider;
    }

    @Generated
    public GoogleNetworkProvider getGoogleNetworkProvider() {
        return this.googleNetworkProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleNetworkProvider(GoogleNetworkProvider googleNetworkProvider) {
        this.googleNetworkProvider = googleNetworkProvider;
    }

    @Generated
    public GoogleSubnetProvider getGoogleSubnetProvider() {
        return this.googleSubnetProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleSubnetProvider(GoogleSubnetProvider googleSubnetProvider) {
        this.googleSubnetProvider = googleSubnetProvider;
    }

    @Generated
    public String getClouddriverUserAgentApplicationName() {
        return this.clouddriverUserAgentApplicationName;
    }

    @Generated
    public @VisibleForTesting void setClouddriverUserAgentApplicationName(String string) {
        this.clouddriverUserAgentApplicationName = string;
    }

    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Generated
    public @VisibleForTesting void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

