/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.FixedOrPercent;
import com.google.api.services.compute.model.InstanceGroupManagerAutoHealingPolicy;
import com.google.api.services.compute.model.InstanceGroupManagersSetAutoHealingRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersSetAutoHealingRequest;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutor;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.description.UpsertGoogleAutoscalingPolicyDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoHealingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoscalingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationsRegistry;
import com.netflix.spinnaker.clouddriver.orchestration.OrchestrationProcessor;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertGoogleAutoscalingPolicyAtomicOperation
extends GoogleAtomicOperation<Void> {
    private static final String BASE_PHASE = "UPSERT_SCALING_POLICY";
    private GoogleClusterProvider googleClusterProvider;
    private GoogleOperationPoller googleOperationPoller;
    private AtomicOperationsRegistry atomicOperationsRegistry;
    private OrchestrationProcessor orchestrationProcessor;
    private Cache cacheView;
    private ObjectMapper objectMapper;
    private final UpsertGoogleAutoscalingPolicyDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public UpsertGoogleAutoscalingPolicyAtomicOperation(UpsertGoogleAutoscalingPolicyDescription description, @Autowired GoogleClusterProvider googleClusterProvider, @Autowired GoogleOperationPoller googleOperationPoller, @Autowired AtomicOperationsRegistry atomicOperationsRegistry, @Autowired OrchestrationProcessor orchestrationProcessor, @Autowired Cache cacheView, @Autowired ObjectMapper objectMapper) {
        ObjectMapper objectMapper2;
        Cache cache;
        OrchestrationProcessor orchestrationProcessor2;
        AtomicOperationsRegistry atomicOperationsRegistry2;
        GoogleOperationPoller googleOperationPoller2;
        GoogleClusterProvider googleClusterProvider2;
        UpsertGoogleAutoscalingPolicyDescription upsertGoogleAutoscalingPolicyDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = upsertGoogleAutoscalingPolicyDescription = description;
        this.googleClusterProvider = googleClusterProvider2 = googleClusterProvider;
        this.googleOperationPoller = googleOperationPoller2 = googleOperationPoller;
        this.atomicOperationsRegistry = atomicOperationsRegistry2 = atomicOperationsRegistry;
        this.orchestrationProcessor = orchestrationProcessor2 = orchestrationProcessor;
        this.cacheView = cache = cacheView;
        this.objectMapper = objectMapper2 = objectMapper;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description)}, new String[]{"Initializing upsert of scaling policy for ", "..."}));
        Reference serverGroupName = new Reference((Object)IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description));
        CallSite credentials = IndyInterface.bootstrap("getProperty", "credentials", 4, this.description);
        Reference project = new Reference((Object)IndyInterface.bootstrap("getProperty", "project", 0, credentials));
        Reference compute = new Reference((Object)IndyInterface.bootstrap("getProperty", "compute", 0, credentials));
        CallSite accountName = IndyInterface.bootstrap("getProperty", "accountName", 4, this.description);
        Reference region = new Reference((Object)IndyInterface.bootstrap("getProperty", "region", 4, this.description));
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "queryServerGroup", 0, GCEUtil.class, this.googleClusterProvider, accountName, region.get(), serverGroupName.get());
        CallSite isRegional = IndyInterface.bootstrap("getProperty", "regional", 0, serverGroup);
        Reference zone = new Reference((Object)IndyInterface.bootstrap("getProperty", "zone", 0, serverGroup));
        CallSite autoscaler = null;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 4, this.description)) != false) {
            CallSite ancestorAutoscalingPolicyDescription = IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 0, serverGroup);
            if (IndyInterface.bootstrap("cast", "()", 0, ancestorAutoscalingPolicyDescription) != false) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName.get()}, new String[]{"Updating autoscaler for ", "..."}));
                autoscaler = IndyInterface.bootstrap("invoke", "buildAutoscaler", 0, GCEUtil.class, serverGroupName.get(), IndyInterface.bootstrap("getProperty", "selfLink", 0, serverGroup), IndyInterface.bootstrap("invoke", "copyAndOverrideAncestorAutoscalingPolicy", 0, UpsertGoogleAutoscalingPolicyAtomicOperation.class, ancestorAutoscalingPolicyDescription, IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 4, this.description)));
                if (IndyInterface.bootstrap("cast", "()", 0, isRegional) != false) {
                    CallSite updateOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "update", 0, IndyInterface.bootstrap("invoke", "regionAutoscalers", 0, compute.get()), project.get(), region.get(), autoscaler), "compute.regionAutoscalers.update", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_REGION", 0, GoogleExecutor.class), region.get());
                    IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), region.get(), IndyInterface.bootstrap("invoke", "getName", 0, updateOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getName", 0, autoscaler), serverGroupName.get()}, new String[]{"autoScaler ", " for server group ", ""}), BASE_PHASE);
                } else {
                    CallSite updateOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "update", 0, IndyInterface.bootstrap("invoke", "autoscalers", 0, compute.get()), project.get(), zone.get(), autoscaler), "compute.autoscalers.update", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 0, GoogleExecutor.class), zone.get());
                    IndyInterface.bootstrap("invoke", "waitForZonalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), zone.get(), IndyInterface.bootstrap("invoke", "getName", 0, updateOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getName", 0, autoscaler), serverGroupName.get()}, new String[]{"autoScaler ", " for server group ", ""}), BASE_PHASE);
                }
            } else {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName.get()}, new String[]{"Creating new autoscaler for ", "..."}));
                autoscaler = IndyInterface.bootstrap("invoke", "buildAutoscaler", 0, GCEUtil.class, serverGroupName.get(), IndyInterface.bootstrap("getProperty", "selfLink", 0, serverGroup), IndyInterface.bootstrap("invoke", "normalizeNewAutoscalingPolicy", 0, UpsertGoogleAutoscalingPolicyAtomicOperation.class, IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 4, this.description)));
                if (IndyInterface.bootstrap("cast", "()", 0, isRegional) != false) {
                    CallSite insertOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "regionAutoscalers", 0, compute.get()), project.get(), region.get(), autoscaler), "compute.regionAutoscalers.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_REGION", 0, GoogleExecutor.class), region.get());
                    IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), region.get(), IndyInterface.bootstrap("invoke", "getName", 0, insertOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getName", 0, autoscaler), serverGroupName.get()}, new String[]{"autoScaler ", " for server group ", ""}), BASE_PHASE);
                } else {
                    CallSite insertOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "autoscalers", 0, compute.get()), project.get(), zone.get(), autoscaler), "compute.autoscalers.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 0, GoogleExecutor.class), zone.get());
                    IndyInterface.bootstrap("invoke", "waitForZonalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), zone.get(), IndyInterface.bootstrap("invoke", "getName", 0, insertOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getName", 0, autoscaler), serverGroupName.get()}, new String[]{"autoScaler ", " for server group ", ""}), BASE_PHASE);
                }
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoHealingPolicy", 4, this.description)) != false) {
            CallSite ancestorAutoHealingPolicyDescription = IndyInterface.bootstrap("invoke", "buildAutoHealingPolicyDescriptionFromAutoHealingPolicy", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "autoHealingPolicy", 0, serverGroup));
            public final class _operate_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference serverGroupName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure1(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference serverGroupName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.compute = reference4 = compute;
                    this.project = reference3 = project;
                    this.region = reference2 = region;
                    this.serverGroupName = reference = serverGroupName;
                }

                public Object doCall(List<InstanceGroupManagerAutoHealingPolicy> policy) {
                    CallSite request = IndyInterface.bootstrap("invoke", "setAutoHealingPolicies", 0, IndyInterface.bootstrap("init", "<init>", 0, RegionInstanceGroupManagersSetAutoHealingRequest.class), policy);
                    CallSite autoHealingOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setAutoHealingPolicies", 0, IndyInterface.bootstrap("invoke", "regionInstanceGroupManagers", 0, this.compute.get()), this.project.get(), this.region.get(), this.serverGroupName.get(), request), "compute.regionInstanceGroupManagers.setAutoHealingPolicies", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_REGION", 0, GoogleExecutor.class), this.region.get());
                    return IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.compute.get(), this.project.get(), this.region.get(), IndyInterface.bootstrap("invoke", "getName", 0, autoHealingOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{policy, this.serverGroupName.get()}, new String[]{"autoHealing policy ", " for server group ", ""}), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
                }

                @Generated
                public Object call(List<InstanceGroupManagerAutoHealingPolicy> policy) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, policy);
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getRegion() {
                    return this.region.get();
                }

                @Generated
                public Object getServerGroupName() {
                    return this.serverGroupName.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            _operate_closure1 regionalRequest = new _operate_closure1(this, this, compute, project, region, serverGroupName);
            public final class _operate_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference zone;
                private /* synthetic */ Reference serverGroupName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure2(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference zone, Reference serverGroupName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.compute = reference4 = compute;
                    this.project = reference3 = project;
                    this.zone = reference2 = zone;
                    this.serverGroupName = reference = serverGroupName;
                }

                public Object doCall(List<InstanceGroupManagerAutoHealingPolicy> policy) {
                    CallSite request = IndyInterface.bootstrap("invoke", "setAutoHealingPolicies", 0, IndyInterface.bootstrap("init", "<init>", 0, InstanceGroupManagersSetAutoHealingRequest.class), policy);
                    CallSite autoHealingOp = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setAutoHealingPolicies", 0, IndyInterface.bootstrap("invoke", "instanceGroupManagers", 0, this.compute.get()), this.project.get(), this.zone.get(), this.serverGroupName.get(), request), "compute.instanceGroupManagers.setAutoHealingPolicies", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 0, GoogleExecutor.class), this.zone.get());
                    return IndyInterface.bootstrap("invoke", "waitForZonalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.compute.get(), this.project.get(), this.zone.get(), IndyInterface.bootstrap("invoke", "getName", 0, autoHealingOp), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{policy, this.serverGroupName.get()}, new String[]{"autoHealing policy ", " for server group ", ""}), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
                }

                @Generated
                public Object call(List<InstanceGroupManagerAutoHealingPolicy> policy) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, policy);
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getZone() {
                    return this.zone.get();
                }

                @Generated
                public Object getServerGroupName() {
                    return this.serverGroupName.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            _operate_closure2 zonalRequest = new _operate_closure2(this, this, compute, project, zone, serverGroupName);
            if (IndyInterface.bootstrap("cast", "()", 0, ancestorAutoHealingPolicyDescription) != false) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName.get()}, new String[]{"Updating autoHealing policy for ", "..."}));
                CallSite autoHealingPolicy = IndyInterface.bootstrap("invoke", "buildAutoHealingPolicyFromAutoHealingPolicyDescription", 2, this, IndyInterface.bootstrap("invoke", "copyAndOverrideAncestorAutoHealingPolicy", 0, UpsertGoogleAutoscalingPolicyAtomicOperation.class, ancestorAutoHealingPolicyDescription, IndyInterface.bootstrap("getProperty", "autoHealingPolicy", 4, this.description)), project.get(), compute.get());
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? IndyInterface.bootstrap("invoke", "call", 0, regionalRequest, autoHealingPolicy) : IndyInterface.bootstrap("invoke", "call", 0, zonalRequest, autoHealingPolicy);
            } else {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName.get()}, new String[]{"Creating new autoHealing policy for ", "..."}));
                CallSite autoHealingPolicy = IndyInterface.bootstrap("invoke", "buildAutoHealingPolicyFromAutoHealingPolicyDescription", 2, this, IndyInterface.bootstrap("invoke", "normalizeNewAutoHealingPolicy", 0, UpsertGoogleAutoscalingPolicyAtomicOperation.class, IndyInterface.bootstrap("getProperty", "autoHealingPolicy", 4, this.description)), project.get(), compute.get());
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? IndyInterface.bootstrap("invoke", "call", 0, regionalRequest, autoHealingPolicy) : IndyInterface.bootstrap("invoke", "call", 0, zonalRequest, autoHealingPolicy);
            }
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "writeMetadata", 4, this.description), null) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "writeMetadata", 4, this.description))) {
            if (IndyInterface.bootstrap("cast", "()", 0, isRegional) != false) {
                IndyInterface.bootstrap("invoke", "updatePolicyMetadata", 2, this, compute.get(), credentials, project.get(), IndyInterface.bootstrap("invoke", "buildRegionalServerGroupUrl", 0, GCEUtil.class, project.get(), region.get(), serverGroupName.get()), autoscaler);
            } else {
                IndyInterface.bootstrap("invoke", "updatePolicyMetadata", 2, this, compute.get(), credentials, project.get(), IndyInterface.bootstrap("invoke", "buildZonalServerGroupUrl", 0, GCEUtil.class, project.get(), zone.get(), serverGroupName.get()), autoscaler);
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private static GoogleAutoscalingPolicy copyAndOverrideAncestorAutoscalingPolicy(GoogleAutoscalingPolicy ancestor, GoogleAutoscalingPolicy update) {
        Reference update2 = new Reference((Object)update);
        Reference newDescription = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, ancestor)));
        if (IndyInterface.bootstrap("cast", "()", 0, (GoogleAutoscalingPolicy)update2.get()) == false) {
            return (GoogleAutoscalingPolicy)newDescription.get();
        }
        public final class _copyAndOverrideAncestorAutoscalingPolicy_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference update;
            private /* synthetic */ Reference newDescription;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _copyAndOverrideAncestorAutoscalingPolicy_closure3(Object _outerInstance, Object _thisObject, Reference update, Reference newDescription) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.update = reference2 = update;
                this.newDescription = reference = newDescription;
            }

            public Object doCall(Object it) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.update.get()), it), null)) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.update.get()), it);
                    IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.newDescription.get()), it, callSite);
                    return callSite;
                }
                return null;
            }

            @Generated
            public GoogleAutoscalingPolicy getUpdate() {
                return IndyInterface.bootstrap("cast", "()", 0, this.update.get());
            }

            @Generated
            public GoogleAutoscalingPolicy getNewDescription() {
                return IndyInterface.bootstrap("cast", "()", 0, this.newDescription.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copyAndOverrideAncestorAutoscalingPolicy_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"minNumReplicas", "maxNumReplicas", "coolDownPeriodSec", "customMetricUtilizations", "mode", "scalingSchedules"}), new _copyAndOverrideAncestorAutoscalingPolicy_closure3(UpsertGoogleAutoscalingPolicyAtomicOperation.class, UpsertGoogleAutoscalingPolicyAtomicOperation.class, update2, newDescription));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "scaleInControl", 4, (GoogleAutoscalingPolicy)update2.get()), null)) {
            CallSite scaleInControl = IndyInterface.bootstrap("getProperty", "scaleInControl", 4, (GoogleAutoscalingPolicy)update2.get());
            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "timeWindowSec", 0, scaleInControl), null) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "maxScaledInReplicas", 0, scaleInControl), null)) {
                CallSite callSite = scaleInControl;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoscalingPolicy)newDescription.get()), (String)"scaleInControl");
            } else {
                Object var6_6 = null;
                ScriptBytecodeAdapter.setGroovyObjectProperty(var6_6, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoscalingPolicy)newDescription.get()), (String)"scaleInControl");
            }
        }
        public final class _copyAndOverrideAncestorAutoscalingPolicy_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference update;
            private /* synthetic */ Reference newDescription;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _copyAndOverrideAncestorAutoscalingPolicy_closure4(Object _outerInstance, Object _thisObject, Reference update, Reference newDescription) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.update = reference2 = update;
                this.newDescription = reference = newDescription;
            }

            public Object doCall(Object it) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.update.get()), it), null)) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "utilizationTarget", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.update.get()), it)), null)) {
                        CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.update.get()), it);
                        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.newDescription.get()), it, callSite);
                        return callSite;
                    }
                    Object var3_3 = null;
                    IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.newDescription.get()), it, var3_3);
                    return var3_3;
                }
                return null;
            }

            @Generated
            public GoogleAutoscalingPolicy getUpdate() {
                return IndyInterface.bootstrap("cast", "()", 0, this.update.get());
            }

            @Generated
            public GoogleAutoscalingPolicy getNewDescription() {
                return IndyInterface.bootstrap("cast", "()", 0, this.newDescription.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copyAndOverrideAncestorAutoscalingPolicy_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"cpuUtilization", "loadBalancingUtilization"}), new _copyAndOverrideAncestorAutoscalingPolicy_closure4(UpsertGoogleAutoscalingPolicyAtomicOperation.class, UpsertGoogleAutoscalingPolicyAtomicOperation.class, update2, newDescription));
        return (GoogleAutoscalingPolicy)newDescription.get();
    }

    private static GoogleAutoscalingPolicy normalizeNewAutoscalingPolicy(GoogleAutoscalingPolicy newPolicy) {
        Reference newPolicy2 = new Reference((Object)newPolicy);
        public final class _normalizeNewAutoscalingPolicy_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference newPolicy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _normalizeNewAutoscalingPolicy_closure5(Object _outerInstance, Object _thisObject, Reference newPolicy) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.newPolicy = reference = newPolicy;
            }

            public Object doCall(Object it) {
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "utilizationTarget", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.newPolicy.get()), it)), null)) {
                    Object var2_2 = null;
                    IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.newPolicy.get()), it, var2_2);
                    return var2_2;
                }
                return null;
            }

            @Generated
            public GoogleAutoscalingPolicy getNewPolicy() {
                return IndyInterface.bootstrap("cast", "()", 0, this.newPolicy.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _normalizeNewAutoscalingPolicy_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"cpuUtilization", "loadBalancingUtilization"}), new _normalizeNewAutoscalingPolicy_closure5(UpsertGoogleAutoscalingPolicyAtomicOperation.class, UpsertGoogleAutoscalingPolicyAtomicOperation.class, newPolicy2));
        return (GoogleAutoscalingPolicy)newPolicy2.get();
    }

    @VisibleForTesting
    public static GoogleAutoHealingPolicy copyAndOverrideAncestorAutoHealingPolicy(GoogleAutoHealingPolicy ancestor, GoogleAutoHealingPolicy update) {
        Reference update2 = new Reference((Object)update);
        Reference newDescription = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, ancestor)));
        if (IndyInterface.bootstrap("cast", "()", 0, (GoogleAutoHealingPolicy)update2.get()) == false) {
            return (GoogleAutoHealingPolicy)newDescription.get();
        }
        public final class _copyAndOverrideAncestorAutoHealingPolicy_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference update;
            private /* synthetic */ Reference newDescription;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _copyAndOverrideAncestorAutoHealingPolicy_closure6(Object _outerInstance, Object _thisObject, Reference update, Reference newDescription) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.update = reference2 = update;
                this.newDescription = reference = newDescription;
            }

            public Object doCall(Object it) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.update.get()), it), null)) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.update.get()), it);
                    IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.newDescription.get()), it, callSite);
                    return callSite;
                }
                return null;
            }

            @Generated
            public GoogleAutoHealingPolicy getUpdate() {
                return IndyInterface.bootstrap("cast", "()", 0, this.update.get());
            }

            @Generated
            public GoogleAutoHealingPolicy getNewDescription() {
                return IndyInterface.bootstrap("cast", "()", 0, this.newDescription.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copyAndOverrideAncestorAutoHealingPolicy_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"healthCheck", "initialDelaySec", "healthCheckKind"}), new _copyAndOverrideAncestorAutoHealingPolicy_closure6(UpsertGoogleAutoscalingPolicyAtomicOperation.class, UpsertGoogleAutoscalingPolicyAtomicOperation.class, update2, newDescription));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "maxUnavailable", 4, (GoogleAutoHealingPolicy)update2.get()), null)) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "fixed", 0, IndyInterface.bootstrap("getProperty", "maxUnavailable", 4, (GoogleAutoHealingPolicy)update2.get())), null) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "percent", 0, IndyInterface.bootstrap("getProperty", "maxUnavailable", 4, (GoogleAutoHealingPolicy)update2.get())), null)) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "maxUnavailable", 4, (GoogleAutoHealingPolicy)update2.get());
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoHealingPolicy)newDescription.get()), (String)"maxUnavailable");
            } else {
                Object var5_5 = null;
                ScriptBytecodeAdapter.setGroovyObjectProperty(var5_5, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)((GoogleAutoHealingPolicy)newDescription.get()), (String)"maxUnavailable");
            }
        }
        return (GoogleAutoHealingPolicy)newDescription.get();
    }

    private static GoogleAutoHealingPolicy normalizeNewAutoHealingPolicy(GoogleAutoHealingPolicy newPolicy) {
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "fixed", 1, IndyInterface.bootstrap("getProperty", "maxUnavailable", 4, newPolicy)), null) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "percent", 1, IndyInterface.bootstrap("getProperty", "maxUnavailable", 4, newPolicy)), null)) {
            Object var1_1 = null;
            ScriptBytecodeAdapter.setGroovyObjectProperty(var1_1, UpsertGoogleAutoscalingPolicyAtomicOperation.class, (GroovyObject)newPolicy, (String)"maxUnavailable");
        }
        return newPolicy;
    }

    private Object buildAutoHealingPolicyFromAutoHealingPolicyDescription(GoogleAutoHealingPolicy autoHealingPolicyDescription, String project, Compute compute) {
        CallSite autoHealingHealthCheck = IndyInterface.bootstrap("invoke", "queryHealthCheck", 0, GCEUtil.class, project, IndyInterface.bootstrap("getProperty", "accountName", 4, this.description), IndyInterface.bootstrap("getProperty", "healthCheck", 4, autoHealingPolicyDescription), IndyInterface.bootstrap("getProperty", "healthCheckKind", 4, autoHealingPolicyDescription), compute, this.cacheView, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this);
        CallSite autoHealingPolicy = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 5, autoHealingPolicyDescription)) != false ? ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("init", "<init>", 0, InstanceGroupManagerAutoHealingPolicy.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"healthCheck", IndyInterface.bootstrap("getProperty", "selfLink", 0, autoHealingHealthCheck), "initialDelaySec", IndyInterface.bootstrap("getProperty", "initialDelaySec", 4, autoHealingPolicyDescription)}))}) : null);
        if (DefaultTypeTransformation.booleanUnbox((Object)autoHealingPolicy) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "maxUnavailable", 4, autoHealingPolicyDescription))) {
            CallSite maxUnavailable = IndyInterface.bootstrap("init", "<init>", 0, FixedOrPercent.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fixed", (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "fixed", 0, IndyInterface.bootstrap("getProperty", "maxUnavailable", 4, autoHealingPolicyDescription)), Integer.class)), "percent", (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "percent", 0, IndyInterface.bootstrap("getProperty", "maxUnavailable", 4, autoHealingPolicyDescription)), Integer.class))}));
            IndyInterface.bootstrap("invoke", "setMaxUnavailable", 0, IndyInterface.bootstrap("invoke", "getAt", 0, autoHealingPolicy, false), maxUnavailable);
        }
        return autoHealingPolicy;
    }

    public void updatePolicyMetadata(Compute compute, GoogleNamedAccountCredentials credentials, String project, String groupUrl, Object autoscaler) {
        CallSite groupName = IndyInterface.bootstrap("invoke", "getLocalName", 0, Utils.class, groupUrl);
        CallSite groupRegion = IndyInterface.bootstrap("invoke", "getRegionFromGroupUrl", 0, Utils.class, groupUrl);
        CallSite templateUrl = null;
        CallSite callSite = IndyInterface.bootstrap("invoke", "determineServerGroupType", 0, Utils.class, groupUrl);
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "REGIONAL", 0, GoogleServerGroup.ServerGroupType.class))) {
            templateUrl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceTemplate", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "regionInstanceGroupManagers", 0, compute), project, groupRegion, groupName), "compute.regionInstanceGroupManagers.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_REGION", 0, GoogleExecutor.class), groupRegion)));
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "ZONAL", 0, GoogleServerGroup.ServerGroupType.class))) {
            CallSite groupZone = IndyInterface.bootstrap("invoke", "getZoneFromGroupUrl", 0, Utils.class, groupUrl);
            templateUrl = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceTemplate", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "instanceGroupManagers", 0, compute), project, groupZone, groupName), "compute.instanceGroupManagers.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 0, GoogleExecutor.class), groupZone)));
        } else {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{groupUrl}, new String[]{"Server group referenced by ", " has illegal type."})));
        }
        CallSite template = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "instanceTemplates", 0, compute), project, IndyInterface.bootstrap("invoke", "getLocalName", 0, Utils.class, templateUrl)), "compute.instancesTemplates.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 0, GoogleExecutor.class)));
        CallSite instanceDescription = IndyInterface.bootstrap("invoke", "buildInstanceDescriptionFromTemplate", 0, GCEUtil.class, project, template);
        Map templateOpMap = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"image", IndyInterface.bootstrap("getProperty", "image", 0, instanceDescription), "instanceType", IndyInterface.bootstrap("getProperty", "instanceType", 0, instanceDescription), "credentials", IndyInterface.bootstrap("invoke", "getName", 0, credentials), "disks", IndyInterface.bootstrap("getProperty", "disks", 0, instanceDescription), "instanceMetadata", IndyInterface.bootstrap("getProperty", "instanceMetadata", 0, instanceDescription), "tags", IndyInterface.bootstrap("getProperty", "tags", 0, instanceDescription), "network", IndyInterface.bootstrap("getProperty", "network", 0, instanceDescription), "subnet", IndyInterface.bootstrap("getProperty", "subnet", 0, instanceDescription), "serviceAccountEmail", IndyInterface.bootstrap("getProperty", "serviceAccountEmail", 0, instanceDescription), "authScopes", IndyInterface.bootstrap("getProperty", "authScopes", 0, instanceDescription), "preemptible", IndyInterface.bootstrap("getProperty", "preemptible", 0, instanceDescription), "automaticRestart", IndyInterface.bootstrap("getProperty", "automaticRestart", 0, instanceDescription), "onHostMaintenance", IndyInterface.bootstrap("getProperty", "onHostMaintenance", 0, instanceDescription), "region", groupRegion, "serverGroupName", groupName});
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "minCpuPlatform", 0, instanceDescription)) != false) {
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "minCpuPlatform", 0, instanceDescription);
            ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)templateOpMap, (String)"minCpuPlatform");
        }
        CallSite instanceMetadata = IndyInterface.bootstrap("getProperty", "instanceMetadata", 1, templateOpMap);
        if (DefaultTypeTransformation.booleanUnbox((Object)instanceMetadata) && DefaultTypeTransformation.booleanUnbox((Object)autoscaler)) {
            CallSite callSite3 = IndyInterface.bootstrap("invoke", "writeValueAsString", 0, this.objectMapper, autoscaler);
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)instanceMetadata, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "AUTOSCALING_POLICY", 0, GCEUtil.class))));
        } else if (IndyInterface.bootstrap("cast", "()", 0, autoscaler) != false) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "AUTOSCALING_POLICY", 0, GCEUtil.class), IndyInterface.bootstrap("invoke", "writeValueAsString", 0, this.objectMapper, autoscaler)});
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)templateOpMap, (String)"instanceMetadata");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "instanceMetadata", 0, templateOpMap)) != false) {
            CallSite converter = IndyInterface.bootstrap("invoke", "getAtomicOperationConverter", 0, this.atomicOperationsRegistry, "modifyGoogleServerGroupInstanceTemplateDescription", "gce");
            CallSite templateOp = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertOperation", 0, converter, templateOpMap));
            IndyInterface.bootstrap("invoke", "process", 0, this.orchestrationProcessor, "gce", ScriptBytecodeAdapter.createList((Object[])new Object[]{templateOp}), IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "randomUUID", 0, UUID.class)));
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertGoogleAutoscalingPolicyAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public AtomicOperationsRegistry getAtomicOperationsRegistry() {
        return this.atomicOperationsRegistry;
    }

    @Generated
    public @VisibleForTesting void setAtomicOperationsRegistry(AtomicOperationsRegistry atomicOperationsRegistry) {
        this.atomicOperationsRegistry = atomicOperationsRegistry;
    }

    @Generated
    public OrchestrationProcessor getOrchestrationProcessor() {
        return this.orchestrationProcessor;
    }

    @Generated
    public @VisibleForTesting void setOrchestrationProcessor(OrchestrationProcessor orchestrationProcessor) {
        this.orchestrationProcessor = orchestrationProcessor;
    }

    @Generated
    public Cache getCacheView() {
        return this.cacheView;
    }

    @Generated
    public @VisibleForTesting void setCacheView(Cache cache) {
        this.cacheView = cache;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public @VisibleForTesting void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

