/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops;

import com.google.api.services.compute.model.InstanceGroupManagersSetInstanceTemplateRequest;
import com.google.api.services.compute.model.InstanceGroupsListInstancesRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersSetTemplateRequest;
import com.google.api.services.compute.model.RegionInstanceGroupsListInstancesRequest;
import com.google.api.services.compute.model.Tags;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.description.UpsertGoogleServerGroupTagsDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertGoogleServerGroupTagsAtomicOperation
extends GoogleAtomicOperation<Void> {
    private static final String BASE_PHASE = "UPSERT_SERVER_GROUP_TAGS";
    private final UpsertGoogleServerGroupTagsDescription description;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private GoogleClusterProvider googleClusterProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public UpsertGoogleServerGroupTagsAtomicOperation(UpsertGoogleServerGroupTagsDescription description) {
        UpsertGoogleServerGroupTagsDescription upsertGoogleServerGroupTagsDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = upsertGoogleServerGroupTagsDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description)}, new String[]{"Initializing upsert of server group tags for ", " in "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "region", 4, this.description)}, new String[]{"", "..."})));
        CallSite accountName = IndyInterface.bootstrap("getProperty", "accountName", 4, this.description);
        CallSite credentials = IndyInterface.bootstrap("getProperty", "credentials", 4, this.description);
        Reference compute = new Reference((Object)IndyInterface.bootstrap("getProperty", "compute", 0, credentials));
        Reference project = new Reference((Object)IndyInterface.bootstrap("getProperty", "project", 0, credentials));
        CallSite region = IndyInterface.bootstrap("getProperty", "region", 4, this.description);
        CallSite serverGroupName = IndyInterface.bootstrap("getProperty", "serverGroupName", 4, this.description);
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "queryServerGroup", 0, GCEUtil.class, this.googleClusterProvider, accountName, region, serverGroupName);
        CallSite isRegional = IndyInterface.bootstrap("getProperty", "regional", 0, serverGroup);
        CallSite zone = IndyInterface.bootstrap("getProperty", "zone", 0, serverGroup);
        String tagsDescription = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "tags", 4, this.description)) != false ? new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "tags", 4, this.description)}, new String[]{"tags ", ""}) : "empty set of tags";
        CallSite regionalInstanceGroupManagers = IndyInterface.bootstrap("invoke", "regionInstanceGroupManagers", 0, compute.get());
        CallSite instanceGroupManagers = IndyInterface.bootstrap("invoke", "instanceGroupManagers", 0, compute.get());
        CallSite instanceTemplates = IndyInterface.bootstrap("invoke", "instanceTemplates", 0, compute.get());
        Reference instances = new Reference((Object)IndyInterface.bootstrap("invoke", "instances", 0, compute.get()));
        CallSite managedInstanceGroup = IndyInterface.bootstrap("cast", "()", 0, isRegional) != false ? IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, regionalInstanceGroupManagers, project.get(), region, serverGroupName), "compute.regionInstanceGroupManagers.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region) : IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, instanceGroupManagers, project.get(), zone, serverGroupName), "compute.instanceGroupManagers.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), zone);
        CallSite origInstanceTemplateName = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getInstanceTemplate", 0, managedInstanceGroup));
        CallSite instanceTemplate = IndyInterface.bootstrap("invoke", "queryInstanceTemplate", 0, GCEUtil.class, origInstanceTemplateName, credentials, this);
        IndyInterface.bootstrap("invoke", "setName", 0, instanceTemplate, new GStringImpl(new Object[]{serverGroupName, IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class)}, new String[]{"", "-", ""}));
        Reference tags = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, Tags.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"items", IndyInterface.bootstrap("getProperty", "tags", 4, this.description)})));
        IndyInterface.bootstrap("invoke", "setTags", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate), tags.get());
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate), tagsDescription}, new String[]{"Inserting new instance template ", " with ", "..."}));
        CallSite instanceTemplateCreateOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, instanceTemplates, project.get(), instanceTemplate), "compute.instanceTemplates.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
        CallSite instanceTemplateUrl = IndyInterface.bootstrap("getProperty", "targetLink", 0, instanceTemplateCreateOperation);
        IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("invoke", "getName", 0, instanceTemplateCreateOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate)}, new String[]{"instance template ", ""}), BASE_PHASE);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate), serverGroupName}, new String[]{"Setting instance template ", " on server group ", "..."}));
        CallSite groupInstances = null;
        if (IndyInterface.bootstrap("cast", "()", 0, isRegional) != false) {
            CallSite regionInstanceGroupManagersSetTemplateRequest = IndyInterface.bootstrap("init", "<init>", 0, RegionInstanceGroupManagersSetTemplateRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceTemplate", instanceTemplateUrl}));
            CallSite setInstanceTemplateOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setInstanceTemplate", 0, regionalInstanceGroupManagers, project.get(), region, serverGroupName, regionInstanceGroupManagersSetTemplateRequest), "compute.regionInstanceGroupManagers.setInstanceTemplate", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 0, IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this)), region);
            IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), region, IndyInterface.bootstrap("invoke", "getName", 0, setInstanceTemplateOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{serverGroupName}, new String[]{"server group ", ""}), BASE_PHASE);
            groupInstances = IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "listInstances", 0, IndyInterface.bootstrap("invoke", "regionInstanceGroups", 0, compute.get()), project.get(), region, serverGroupName, IndyInterface.bootstrap("init", "<init>", 0, RegionInstanceGroupsListInstancesRequest.class)), "compute.regionInstanceGroups.listInstances", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region));
        } else {
            CallSite instanceGroupManagersSetInstanceTemplateRequest = IndyInterface.bootstrap("init", "<init>", 0, InstanceGroupManagersSetInstanceTemplateRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceTemplate", instanceTemplateUrl}));
            CallSite setInstanceTemplateOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setInstanceTemplate", 0, instanceGroupManagers, project.get(), zone, serverGroupName, instanceGroupManagersSetInstanceTemplateRequest), "compute.instanceGroupManagers.setInstanceTemplate", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), zone);
            IndyInterface.bootstrap("invoke", "waitForZonalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), zone, IndyInterface.bootstrap("invoke", "getName", 0, setInstanceTemplateOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{serverGroupName}, new String[]{"server group ", ""}), BASE_PHASE);
            groupInstances = IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "listInstances", 0, IndyInterface.bootstrap("invoke", "instanceGroups", 0, compute.get()), project.get(), zone, serverGroupName, IndyInterface.bootstrap("init", "<init>", 0, InstanceGroupsListInstancesRequest.class)), "compute.instanceGroups.listInstance", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), zone));
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{tagsDescription, serverGroupName}, new String[]{"Setting ", " on each instance in server group ", "..."}));
        Reference instanceUpdateOperations = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instances;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference tags;
            private /* synthetic */ Reference instanceUpdateOperations;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject, Reference instances, Reference project, Reference tags, Reference instanceUpdateOperations) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.instances = reference4 = instances;
                this.project = reference3 = project;
                this.tags = reference2 = tags;
                this.instanceUpdateOperations = reference = instanceUpdateOperations;
            }

            public Object doCall(Object groupInstance) {
                CallSite localInstanceName = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "instance", 0, groupInstance));
                CallSite instanceZone = IndyInterface.bootstrap("invoke", "getZoneFromInstanceUrl", 2, this, IndyInterface.bootstrap("getProperty", "instance", 0, groupInstance));
                CallSite instance = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, this.instances.get(), this.project.get(), instanceZone, localInstanceName), "compute.instances.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), instanceZone);
                CallSite tagsFingerprint = IndyInterface.bootstrap("getProperty", "fingerprint", 0, IndyInterface.bootstrap("getProperty", "tags", 0, instance));
                CallSite callSite = tagsFingerprint;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)this.tags.get(), (String)"fingerprint");
                return IndyInterface.bootstrap("invoke", "leftShift", 0, this.instanceUpdateOperations.get(), IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "setTags", 0, this.instances.get(), this.project.get(), instanceZone, localInstanceName, this.tags.get()), "compute.instances.setTags", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), instanceZone));
            }

            @Generated
            public Object getInstances() {
                return this.instances.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getTags() {
                return this.tags.get();
            }

            @Generated
            public Object getInstanceUpdateOperations() {
                return this.instanceUpdateOperations.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, groupInstances, new _operate_closure1(this, this, instances, project, tags, instanceUpdateOperations));
        public final class _operate_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure2(Object _outerInstance, Object _thisObject, Reference compute, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.compute = reference2 = compute;
                this.project = reference = project;
            }

            public Object doCall(Object instanceUpdateOperation) {
                CallSite localInstanceName = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "targetLink", 0, instanceUpdateOperation));
                return IndyInterface.bootstrap("invoke", "waitForZonalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.compute.get(), this.project.get(), IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getZone", 0, instanceUpdateOperation)), IndyInterface.bootstrap("invoke", "getName", 0, instanceUpdateOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{localInstanceName}, new String[]{"instance ", ""}), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, instanceUpdateOperations.get(), new _operate_closure2(this, this, compute, project));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{origInstanceTemplateName}, new String[]{"Deleting original instance template ", "..."}));
        IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, instanceTemplates, project.get(), origInstanceTemplateName), "compute.instanceTemplates.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{serverGroupName, region}, new String[]{"Done tagging server group ", " in ", "."}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private static String getZoneFromInstanceUrl(String instanceUrl) {
        if (IndyInterface.bootstrap("cast", "()", 0, instanceUrl) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        int indexOfZonesSegment = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, instanceUrl, "/zones/"));
        int indexOfInstancesSegment = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, instanceUrl, "/instances/"));
        if (indexOfZonesSegment == -1 || indexOfInstancesSegment == -1) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, instanceUrl, IndyInterface.bootstrap("invoke", "plus", 0, indexOfZonesSegment, 7), indexOfInstancesSegment));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertGoogleServerGroupTagsAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public GoogleOperationPoller getGoogleOperationPoller() {
        return this.googleOperationPoller;
    }

    @Generated
    public @VisibleForTesting void setGoogleOperationPoller(GoogleOperationPoller googleOperationPoller) {
        this.googleOperationPoller = googleOperationPoller;
    }

    @Generated
    public GoogleClusterProvider getGoogleClusterProvider() {
        return this.googleClusterProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleClusterProvider(GoogleClusterProvider googleClusterProvider) {
        this.googleClusterProvider = googleClusterProvider;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

