/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.PathMatcher;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.DeleteGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.DeleteGoogleLoadBalancerAtomicOperation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteGoogleHttpLoadBalancerAtomicOperation
extends DeleteGoogleLoadBalancerAtomicOperation {
    private static final String BASE_PHASE = "DELETE_LOAD_BALANCER";
    @Autowired
    private SafeRetry safeRetry;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    private DeleteGoogleLoadBalancerDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DeleteGoogleHttpLoadBalancerAtomicOperation(DeleteGoogleLoadBalancerDescription description) {
        DeleteGoogleLoadBalancerDescription deleteGoogleLoadBalancerDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = deleteGoogleLoadBalancerDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    private static void addServicesFromPathMatchers(List<String> backendServiceUrls, List<PathMatcher> pathMatchers) {
        CallSite pathMatcher = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, pathMatchers));
        if (callSite != null) {
            while (callSite.hasNext()) {
                pathMatcher = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                IndyInterface.bootstrap("invoke", "add", 0, backendServiceUrls, IndyInterface.bootstrap("invoke", "getDefaultService", 0, pathMatcher));
                CallSite pathRule = null;
                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "getPathRules", 0, pathMatcher)));
                if (callSite2 == null) continue;
                while (callSite2.hasNext()) {
                    pathRule = IndyInterface.bootstrap("cast", "()", 0, callSite2.next());
                    IndyInterface.bootstrap("invoke", "add", 0, backendServiceUrls, IndyInterface.bootstrap("invoke", "getService", 0, pathRule));
                }
            }
        }
    }

    @Override
    public Void operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Initializing deletion of HTTP load balancer ", "..."}));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "accountName", 4, this.description)}, new String[]{"Unable to resolve credentials for Google account '", "'."})));
        }
        Reference compute = new Reference((Object)IndyInterface.bootstrap("getProperty", "compute", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
        Reference project = new Reference((Object)IndyInterface.bootstrap("getProperty", "project", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
        Reference forwardingRuleName = new Reference((Object)IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{forwardingRuleName.get()}, new String[]{"Retrieving global forwarding rule ", "..."}));
        CallSite projectForwardingRules = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getItems", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "list", 0, IndyInterface.bootstrap("invoke", "globalForwardingRules", 0, compute.get()), project.get()), "compute.globalForwardingRules.list", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this))));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference forwardingRuleName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject, Reference forwardingRuleName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.forwardingRuleName = reference = forwardingRuleName;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)this.forwardingRuleName.get());
            }

            @Generated
            public Object getForwardingRuleName() {
                return this.forwardingRuleName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite forwardingRule = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, projectForwardingRules, new _operate_closure1(this, this, forwardingRuleName)));
        if (IndyInterface.bootstrap("cast", "()", 0, forwardingRule) == false) {
            IndyInterface.bootstrap("invoke", "updateStatusAndThrowNotFoundException", 0, GCEUtil.class, new GStringImpl(new Object[]{forwardingRuleName.get(), project.get()}, new String[]{"Global forwarding rule ", " not found for ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE);
        }
        CallSite targetProxyName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getTarget", 0, forwardingRule)));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{targetProxyName}, new String[]{"Retrieving target proxy ", "..."}));
        CallSite retrievedTargetProxy = IndyInterface.bootstrap("invoke", "getTargetProxyFromRule", 0, GCEUtil.class, compute.get(), project.get(), forwardingRule, BASE_PHASE, this.safeRetry, this);
        if (IndyInterface.bootstrap("cast", "()", 0, retrievedTargetProxy) == false) {
            IndyInterface.bootstrap("invoke", "updateStatusAndThrowNotFoundException", 0, GCEUtil.class, new GStringImpl(new Object[]{targetProxyName, project.get()}, new String[]{"Target proxy ", " not found for ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE);
        }
        Reference urlMapName = new Reference((Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getUrlMap", 0, retrievedTargetProxy)));
        Reference listenersToDelete = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _operate_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference urlMapName;
            private /* synthetic */ Reference listenersToDelete;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure2(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference urlMapName, Reference listenersToDelete) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.urlMapName = reference2 = urlMapName;
                this.listenersToDelete = reference = listenersToDelete;
            }

            public Object doCall(ForwardingRule rule) {
                block6: {
                    CallSite proxy = IndyInterface.bootstrap("invoke", "getTargetProxyFromRule", 0, GCEUtil.class, this.compute.get(), this.project.get(), rule, IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), IndyInterface.bootstrap("getProperty", "safeRetry", 12, this), this.getThisObject());
                    if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "urlMap", 1, proxy)), (Object)this.urlMapName.get())) break block6;
                    CallSite callSite = IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.listenersToDelete.get()), IndyInterface.bootstrap("invoke", "getName", 0, rule));
                    try {
                        return callSite;
                    }
                    catch (GoogleJsonResponseException e) {
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getStatusCode", 0, e), (Object)404)) {
                            throw (Throwable)e;
                        }
                    }
                }
                return null;
            }

            @Generated
            public Object call(ForwardingRule rule) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, rule);
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getUrlMapName() {
                return this.urlMapName.get();
            }

            @Generated
            public List getListenersToDelete() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listenersToDelete.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, projectForwardingRules, new _operate_closure2(this, this, compute, project, urlMapName, listenersToDelete));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{urlMapName.get()}, new String[]{"Retrieving URL map ", "..."}));
        CallSite mapList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "list", 0, IndyInterface.bootstrap("invoke", "urlMaps", 0, compute.get()), project.get()), "compute.urlMaps.list", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)));
        CallSite projectUrlMaps = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getItems", 0, mapList));
        public final class _operate_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference urlMapName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure3(Object _outerInstance, Object _thisObject, Reference urlMapName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.urlMapName = reference = urlMapName;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)this.urlMapName.get());
            }

            @Generated
            public Object getUrlMapName() {
                return this.urlMapName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite urlMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, projectUrlMaps, new _operate_closure3(this, this, urlMapName)));
        public final class _operate_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference urlMapName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure4(Object _outerInstance, Object _thisObject, Reference urlMapName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.urlMapName = reference = urlMapName;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)this.urlMapName.get());
            }

            @Generated
            public Object getUrlMapName() {
                return this.urlMapName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "removeAll", 0, projectUrlMaps, new _operate_closure4(this, this, urlMapName));
        CallSite backendServiceUrls = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        IndyInterface.bootstrap("invoke", "add", 0, backendServiceUrls, IndyInterface.bootstrap("invoke", "getDefaultService", 0, urlMap));
        IndyInterface.bootstrap("invoke", "addServicesFromPathMatchers", 0, DeleteGoogleHttpLoadBalancerAtomicOperation.class, backendServiceUrls, IndyInterface.bootstrap("invoke", "getPathMatchers", 0, urlMap));
        IndyInterface.bootstrap("invoke", "unique", 0, backendServiceUrls);
        CallSite healthCheckUrls = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        CallSite backendServiceUrl = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, backendServiceUrls));
        if (callSite != null) {
            while (callSite.hasNext()) {
                backendServiceUrl = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                Reference backendServiceName = new Reference((Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, backendServiceUrl));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{backendServiceName.get()}, new String[]{"Retrieving backend service ", "..."}));
                public final class _operate_closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference backendServiceName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _operate_closure5(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference backendServiceName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.compute = reference3 = compute;
                        this.project = reference2 = project;
                        this.backendServiceName = reference = backendServiceName;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "backendServices", 0, this.compute.get()), this.project.get(), this.backendServiceName.get()), "compute.backendServices.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                    }

                    @Generated
                    public Object getCompute() {
                        return this.compute.get();
                    }

                    @Generated
                    public Object getProject() {
                        return this.project.get();
                    }

                    @Generated
                    public Object getBackendServiceName() {
                        return this.backendServiceName.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                BackendService backendService = (BackendService)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, new _operate_closure5(this, this, compute, project, backendServiceName), new GStringImpl(new Object[]{backendServiceName.get()}, new String[]{"Backend service ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", BASE_PHASE, "operation", "compute.backendServices.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this)), BackendService.class);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "backends", 1, backendService)) != false) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Server groups still associated with Http(s) load balancer ", ". Failing..."}));
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Server groups still associated with Http(s) load balancer: ", "."})));
                }
                IndyInterface.bootstrap("invoke", "addAll", 0, healthCheckUrls, IndyInterface.bootstrap("invoke", "getHealthChecks", 0, backendService));
            }
        }
        IndyInterface.bootstrap("invoke", "unique", 0, healthCheckUrls);
        Reference timeoutSeconds = new Reference((Object)IndyInterface.bootstrap("getProperty", "deleteOperationTimeoutSeconds", 4, this.description));
        public final class _operate_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference timeoutSeconds;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure6(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference timeoutSeconds) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.compute = reference3 = compute;
                this.project = reference2 = project;
                this.timeoutSeconds = reference = timeoutSeconds;
            }

            public Object doCall(String ruleName) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{ruleName}, new String[]{"Deleting listener ", "..."}));
                CallSite operation = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "deleteGlobalListener", 0, GCEUtil.class, this.compute.get(), this.project.get(), ruleName, IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), IndyInterface.bootstrap("getProperty", "safeRetry", 12, this), this.getThisObject()));
                return IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.compute.get(), this.project.get(), IndyInterface.bootstrap("invoke", "getName", 0, operation), this.timeoutSeconds.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "listener ", ruleName), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
            }

            @Generated
            public Object call(String ruleName) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, ruleName);
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getTimeoutSeconds() {
                return this.timeoutSeconds.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, (List)listenersToDelete.get(), new _operate_closure6(this, this, compute, project, timeoutSeconds));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{urlMapName.get()}, new String[]{"Deleting URL map ", "..."}));
        public final class _operate_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference urlMapName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure7(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference urlMapName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.compute = reference3 = compute;
                this.project = reference2 = project;
                this.urlMapName = reference = urlMapName;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "urlMaps", 0, this.compute.get()), this.project.get(), this.urlMapName.get()), "compute.urlMaps.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getUrlMapName() {
                return this.urlMapName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Operation deleteUrlMapOperation = (Operation)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, new _operate_closure7(this, this, compute, project, urlMapName), new GStringImpl(new Object[]{urlMapName.get()}, new String[]{"Url map ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), ScriptBytecodeAdapter.createList((Object[])new Object[]{404}), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "phase", BASE_PHASE, "operation", "compute.urlMaps.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this)), Operation.class);
        IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("invoke", "getName", 0, deleteUrlMapOperation), timeoutSeconds.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "url map ", urlMapName.get()), BASE_PHASE);
        CallSite deleteBackendServiceAsyncOperations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        CallSite backendServiceUrl2 = null;
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, backendServiceUrls));
        if (callSite2 != null) {
            while (callSite2.hasNext()) {
                backendServiceUrl2 = IndyInterface.bootstrap("cast", "()", 0, callSite2.next());
                Reference backendServiceName = new Reference((Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, backendServiceUrl2));
                public final class _operate_closure8
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference backendServiceName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _operate_closure8(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference backendServiceName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.compute = reference3 = compute;
                        this.project = reference2 = project;
                        this.backendServiceName = reference = backendServiceName;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "backendServices", 0, this.compute.get()), this.project.get(), this.backendServiceName.get()), "compute.backendServices.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                    }

                    @Generated
                    public Object getCompute() {
                        return this.compute.get();
                    }

                    @Generated
                    public Object getProject() {
                        return this.project.get();
                    }

                    @Generated
                    public Object getBackendServiceName() {
                        return this.backendServiceName.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure8.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite deleteBackendServiceOp = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "deleteIfNotInUse", 0, GCEUtil.class, new _operate_closure8(this, this, compute, project, backendServiceName), new GStringImpl(new Object[]{backendServiceName.get()}, new String[]{"Backend service ", ""}), project.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "operation", "compute.backendServices.delete", "phase", BASE_PHASE, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), this.safeRetry, this));
                if (IndyInterface.bootstrap("cast", "()", 0, deleteBackendServiceOp) == false) continue;
                IndyInterface.bootstrap("invoke", "add", 0, deleteBackendServiceAsyncOperations, IndyInterface.bootstrap("init", "<init>", 0, BackendServiceAsyncDeleteOperation.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"backendServiceName", backendServiceName.get(), "operationName", IndyInterface.bootstrap("invoke", "getName", 0, deleteBackendServiceOp)})));
            }
        }
        CallSite asyncOperation = null;
        CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, deleteBackendServiceAsyncOperations));
        if (callSite3 != null) {
            while (callSite3.hasNext()) {
                asyncOperation = IndyInterface.bootstrap("cast", "()", 0, callSite3.next());
                IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("getProperty", "operationName", 4, asyncOperation), timeoutSeconds.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "backend service ", IndyInterface.bootstrap("getProperty", "backendServiceName", 4, asyncOperation)), BASE_PHASE);
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "deleteHealthChecks", 4, this.description)) != false) {
            CallSite deleteHealthCheckAsyncOperations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
            CallSite healthCheckUrl = null;
            CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, healthCheckUrls));
            if (callSite4 != null) {
                while (callSite4.hasNext()) {
                    healthCheckUrl = IndyInterface.bootstrap("cast", "()", 0, callSite4.next());
                    Reference healthCheckName = new Reference((Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, healthCheckUrl));
                    public final class _operate_closure9
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference compute;
                        private /* synthetic */ Reference project;
                        private /* synthetic */ Reference healthCheckName;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _operate_closure9(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference healthCheckName) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            this.compute = reference3 = compute;
                            this.project = reference2 = project;
                            this.healthCheckName = reference = healthCheckName;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "healthChecks", 0, this.compute.get()), this.project.get(), this.healthCheckName.get()), "compute.healthChecks.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                        }

                        @Generated
                        public Object getCompute() {
                            return this.compute.get();
                        }

                        @Generated
                        public Object getProject() {
                            return this.project.get();
                        }

                        @Generated
                        public Object getHealthCheckName() {
                            return this.healthCheckName.get();
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _operate_closure9.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite deleteHealthCheckOp = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "deleteIfNotInUse", 0, GCEUtil.class, new _operate_closure9(this, this, compute, project, healthCheckName), new GStringImpl(new Object[]{healthCheckName.get()}, new String[]{"Http health check ", ""}), project.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "operation", "compute.healthChecks.delete", "phase", BASE_PHASE, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), this.safeRetry, this));
                    if (IndyInterface.bootstrap("cast", "()", 0, deleteHealthCheckOp) == false) continue;
                    IndyInterface.bootstrap("invoke", "add", 0, deleteHealthCheckAsyncOperations, IndyInterface.bootstrap("init", "<init>", 0, HealthCheckAsyncDeleteOperation.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"healthCheckName", healthCheckName.get(), "operationName", IndyInterface.bootstrap("invoke", "getName", 0, deleteHealthCheckOp)})));
                }
            }
            CallSite asyncOperation2 = null;
            CallSite callSite5 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, deleteHealthCheckAsyncOperations));
            if (callSite5 != null) {
                while (callSite5.hasNext()) {
                    asyncOperation2 = IndyInterface.bootstrap("cast", "()", 0, callSite5.next());
                    IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("getProperty", "operationName", 4, asyncOperation2), timeoutSeconds.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "health check ", IndyInterface.bootstrap("getProperty", "healthCheckName", 4, asyncOperation2)), BASE_PHASE);
                }
            }
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Done deleting http load balancer ", "."}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeleteGoogleHttpLoadBalancerAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DeleteGoogleHttpLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DeleteGoogleHttpLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DeleteGoogleHttpLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ @VisibleForTesting @VisibleForTesting void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DeleteGoogleHttpLoadBalancerAtomicOperation.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.DeleteGoogleHttpLoadBalancerAtomicOperation");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Override
    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Override
    @Generated
    public @VisibleForTesting @VisibleForTesting void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ Void super$3$operate(List list) {
        return super.operate(list);
    }

    public /* synthetic */ SafeRetry super$3$getSafeRetry() {
        return super.getSafeRetry();
    }

    public /* synthetic */ void super$3$setSafeRetry(SafeRetry safeRetry) {
        super.setSafeRetry(safeRetry);
    }

    public static class BackendServiceAsyncDeleteOperation
    implements GroovyObject {
        private String backendServiceName;
        private String operationName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public BackendServiceAsyncDeleteOperation() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != BackendServiceAsyncDeleteOperation.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), BackendServiceAsyncDeleteOperation.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), BackendServiceAsyncDeleteOperation.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(BackendServiceAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), BackendServiceAsyncDeleteOperation.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getBackendServiceName() {
            return this.backendServiceName;
        }

        @Generated
        public void setBackendServiceName(String string) {
            this.backendServiceName = string;
        }

        @Generated
        public String getOperationName() {
            return this.operationName;
        }

        @Generated
        public void setOperationName(String string) {
            this.operationName = string;
        }
    }

    public static class HealthCheckAsyncDeleteOperation
    implements GroovyObject {
        private String healthCheckName;
        private String operationName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public HealthCheckAsyncDeleteOperation() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != HealthCheckAsyncDeleteOperation.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), HealthCheckAsyncDeleteOperation.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), HealthCheckAsyncDeleteOperation.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(HealthCheckAsyncDeleteOperation.class, DeleteGoogleHttpLoadBalancerAtomicOperation.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), HealthCheckAsyncDeleteOperation.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getHealthCheckName() {
            return this.healthCheckName;
        }

        @Generated
        public void setHealthCheckName(String string) {
            this.healthCheckName = string;
        }

        @Generated
        public String getOperationName() {
            return this.operationName;
        }

        @Generated
        public void setOperationName(String string) {
            this.operationName = string;
        }
    }
}

