/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.Operation;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.DeleteGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteGoogleInternalLoadBalancerAtomicOperation
extends GoogleAtomicOperation<Void> {
    private static final String BASE_PHASE = "DELETE_INTERNAL_LOAD_BALANCER";
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private SafeRetry safeRetry;
    private DeleteGoogleLoadBalancerDescription description;
    @VisibleForTesting
    private GoogleOperationPoller.ThreadSleeper threadSleeper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DeleteGoogleInternalLoadBalancerAtomicOperation() {
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, GoogleOperationPoller.ThreadSleeper.class);
        this.threadSleeper = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public DeleteGoogleInternalLoadBalancerAtomicOperation(DeleteGoogleLoadBalancerDescription description) {
        DeleteGoogleLoadBalancerDescription deleteGoogleLoadBalancerDescription;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, GoogleOperationPoller.ThreadSleeper.class);
        this.threadSleeper = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = deleteGoogleLoadBalancerDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Initializing deletion of load balancer ", " "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "region", 4, this.description)}, new String[]{"in ", "..."})));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "accountName", 4, this.description)}, new String[]{"Unable to resolve credentials for Google account '", "'."})));
        }
        Reference compute = new Reference((Object)IndyInterface.bootstrap("getProperty", "compute", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
        Reference project = new Reference((Object)IndyInterface.bootstrap("getProperty", "project", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)));
        Reference region = new Reference((Object)IndyInterface.bootstrap("getProperty", "region", 4, this.description));
        Reference forwardingRuleName = new Reference((Object)IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{forwardingRuleName.get(), region.get()}, new String[]{"Retrieving forwarding rule ", " in ", "..."}));
        CallSite projectForwardingRules = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getItems", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "list", 0, IndyInterface.bootstrap("invoke", "forwardingRules", 0, compute.get()), project.get(), region.get()), "compute.forwardingRules.list", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this))));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference forwardingRuleName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject, Reference forwardingRuleName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.forwardingRuleName = reference = forwardingRuleName;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)this.forwardingRuleName.get());
            }

            @Generated
            public Object getForwardingRuleName() {
                return this.forwardingRuleName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite forwardingRule = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, projectForwardingRules, new _operate_closure1(this, this, forwardingRuleName)));
        if (ScriptBytecodeAdapter.compareEqual((Object)forwardingRule, null)) {
            IndyInterface.bootstrap("invoke", "updateStatusAndThrowNotFoundException", 0, GCEUtil.class, new GStringImpl(new Object[]{forwardingRuleName.get(), region.get(), project.get()}, new String[]{"Forwarding rule ", " not found in ", " for ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE);
        }
        Reference backendServiceName = new Reference((Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "backendService", 0, forwardingRule)));
        Reference listenersToDelete = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _operate_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference backendServiceName;
            private /* synthetic */ Reference listenersToDelete;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure2(Object _outerInstance, Object _thisObject, Reference backendServiceName, Reference listenersToDelete) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.backendServiceName = reference2 = backendServiceName;
                this.listenersToDelete = reference = listenersToDelete;
            }

            public Object doCall(ForwardingRule rule) {
                block6: {
                    if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getBackendService", 0, rule)), (Object)this.backendServiceName.get())) break block6;
                    CallSite callSite = IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.listenersToDelete.get()), IndyInterface.bootstrap("invoke", "getName", 0, rule));
                    try {
                        return callSite;
                    }
                    catch (GoogleJsonResponseException e) {
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getStatusCode", 0, e), (Object)404)) {
                            throw (Throwable)e;
                        }
                    }
                }
                return null;
            }

            @Generated
            public Object call(ForwardingRule rule) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, rule);
            }

            @Generated
            public Object getBackendServiceName() {
                return this.backendServiceName.get();
            }

            @Generated
            public List getListenersToDelete() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listenersToDelete.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, projectForwardingRules, new _operate_closure2(this, this, backendServiceName, listenersToDelete));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{backendServiceName.get(), region.get()}, new String[]{"Retrieving backend service ", " in ", "..."}));
        public final class _operate_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference backendServiceName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure3(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference backendServiceName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.region = reference2 = region;
                this.backendServiceName = reference = backendServiceName;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "regionBackendServices", 0, this.compute.get()), this.project.get(), this.region.get(), this.backendServiceName.get()), "compute.regionBackendServices.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get());
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                return this.region.get();
            }

            @Generated
            public Object getBackendServiceName() {
                return this.backendServiceName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        BackendService backendService = (BackendService)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, new _operate_closure3(this, this, compute, project, region, backendServiceName), new GStringImpl(new Object[]{backendServiceName.get()}, new String[]{"Region backend service ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", "BASE_PHASE", "operation", "compute.regionBackendServices.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region.get()}), IndyInterface.bootstrap("getProperty", "registry", 12, this)), BackendService.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)backendService, null)) {
            IndyInterface.bootstrap("invoke", "updateStatusAndThrowNotFoundException", 0, GCEUtil.class, new GStringImpl(new Object[]{backendServiceName.get(), region.get(), project.get()}, new String[]{"Backend service ", " not found in ", " for ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE);
        }
        CallSite healthCheckUrl = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "healthChecks", 0, backendService), false);
        Reference healthCheckName = new Reference((Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, healthCheckUrl));
        CallSite healthCheckType = IndyInterface.bootstrap("invoke", "getHealthCheckType", 0, Utils.class, healthCheckUrl);
        Closure healthCheckGet = null;
        String operationName = null;
        CallSite callSite = healthCheckType;
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"httpHealthChecks")) {
            operationName = "compute.httpHealthChecks.get";
            public final class _operate_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference healthCheckName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure4(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference healthCheckName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.healthCheckName = reference = healthCheckName;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "httpHealthChecks", 0, this.compute.get()), this.project.get(), this.healthCheckName.get()), "compute.httpHealthChecks.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getHealthCheckName() {
                    return this.healthCheckName.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            healthCheckGet = new _operate_closure4(this, this, compute, project, healthCheckName);
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"httpsHealthChecks")) {
            operationName = "copmute.httpsHealthChecks.get";
            public final class _operate_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference healthCheckName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure5(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference healthCheckName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.healthCheckName = reference = healthCheckName;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "httpsHealthChecks", 0, this.compute.get()), this.project.get(), this.healthCheckName.get()), "compute.httpsHealthChecks.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getHealthCheckName() {
                    return this.healthCheckName.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            healthCheckGet = new _operate_closure5(this, this, compute, project, healthCheckName);
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"healthChecks")) {
            operationName = "compute.healthChecks.get";
            public final class _operate_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference healthCheckName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure6(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference healthCheckName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.healthCheckName = reference = healthCheckName;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "healthChecks", 0, this.compute.get()), this.project.get(), this.healthCheckName.get()), "compute.healthChecks.get", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getHealthCheckName() {
                    return this.healthCheckName.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            healthCheckGet = new _operate_closure6(this, this, compute, project, healthCheckName);
        } else {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{healthCheckName.get()}, new String[]{"Unknown health check type for health check named: ", "."})));
        }
        CallSite healthCheck = IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, healthCheckGet, new GStringImpl(new Object[]{healthCheckName.get()}, new String[]{"Health check ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "get", "phase", BASE_PHASE, "operation", operationName, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this));
        if (ScriptBytecodeAdapter.compareEqual((Object)healthCheck, null)) {
            IndyInterface.bootstrap("invoke", "updateStatusAndThrowNotFoundException", 0, GCEUtil.class, new GStringImpl(new Object[]{healthCheckName.get(), project.get()}, new String[]{"Health check ", " not found for ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE);
        }
        Reference timeoutSeconds = new Reference((Object)IndyInterface.bootstrap("getProperty", "deleteOperationTimeoutSeconds", 4, this.description));
        public final class _operate_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference timeoutSeconds;
            private /* synthetic */ Reference forwardingRuleName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure7(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference timeoutSeconds, Reference forwardingRuleName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.compute = reference5 = compute;
                this.project = reference4 = project;
                this.region = reference3 = region;
                this.timeoutSeconds = reference2 = timeoutSeconds;
                this.forwardingRuleName = reference = forwardingRuleName;
            }

            public Object doCall(String ruleName) {
                Reference ruleName2 = new Reference((Object)ruleName);
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{(String)ruleName2.get()}, new String[]{"Deleting listener ", "..."}));
                public final class _closure12
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference compute;
                    private /* synthetic */ Reference project;
                    private /* synthetic */ Reference region;
                    private /* synthetic */ Reference ruleName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure12(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference ruleName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        this.compute = reference4 = compute;
                        this.project = reference3 = project;
                        this.region = reference2 = region;
                        this.ruleName = reference = ruleName;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "forwardingRules", 0, this.compute.get()), this.project.get(), this.region.get(), IndyInterface.bootstrap("cast", "()", 0, this.ruleName.get())), "compute.forwardingRules.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get());
                    }

                    @Generated
                    public Object getCompute() {
                        return this.compute.get();
                    }

                    @Generated
                    public Object getProject() {
                        return this.project.get();
                    }

                    @Generated
                    public Object getRegion() {
                        return this.region.get();
                    }

                    @Generated
                    public String getRuleName() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.ruleName.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Operation deleteForwardingRuleOp = (Operation)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "doRetry", 0, IndyInterface.bootstrap("getProperty", "safeRetry", 12, this), new _closure12((Object)this, this.getThisObject(), this.compute, this.project, this.region, ruleName2), new GStringImpl(new Object[]{(String)ruleName2.get()}, new String[]{"Regional forwarding rule ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 412}), ScriptBytecodeAdapter.createList((Object[])new Object[]{404}), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "phase", IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), "operation", "compute.forwardingRules.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get()}), IndyInterface.bootstrap("getProperty", "registry", 12, this)), Operation.class);
                if (IndyInterface.bootstrap("cast", "()", 0, deleteForwardingRuleOp) != false) {
                    return IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, IndyInterface.bootstrap("getProperty", "googleOperationPoller", 12, this), this.compute.get(), this.project.get(), this.region.get(), IndyInterface.bootstrap("invoke", "getName", 0, deleteForwardingRuleOp), this.timeoutSeconds.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{this.forwardingRuleName.get()}, new String[]{"Regional forwarding rule ", ""}), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this));
                }
                return null;
            }

            @Generated
            public Object call(String ruleName) {
                Reference ruleName2 = new Reference((Object)ruleName);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (String)ruleName2.get());
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                return this.region.get();
            }

            @Generated
            public Object getTimeoutSeconds() {
                return this.timeoutSeconds.get();
            }

            @Generated
            public Object getForwardingRuleName() {
                return this.forwardingRuleName.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, (List)listenersToDelete.get(), new _operate_closure7(this, this, compute, project, region, timeoutSeconds, forwardingRuleName));
        public final class _operate_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference compute;
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference backendServiceName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure8(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference backendServiceName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.compute = reference4 = compute;
                this.project = reference3 = project;
                this.region = reference2 = region;
                this.backendServiceName = reference = backendServiceName;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "regionBackendServices", 0, this.compute.get()), this.project.get(), this.region.get(), this.backendServiceName.get()), "compute.regionBackendServices.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), this.region.get());
            }

            @Generated
            public Object getCompute() {
                return this.compute.get();
            }

            @Generated
            public Object getProject() {
                return this.project.get();
            }

            @Generated
            public Object getRegion() {
                return this.region.get();
            }

            @Generated
            public Object getBackendServiceName() {
                return this.backendServiceName.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite deleteBackendServiceOp = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "deleteIfNotInUse", 0, GCEUtil.class, new _operate_closure8(this, this, compute, project, region, backendServiceName), new GStringImpl(new Object[]{backendServiceName.get()}, new String[]{"Region backend service ", ""}), project.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "operation", "compute.regionBackendServices.delete", "phase", BASE_PHASE, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region.get()}), this.safeRetry, this));
        if (IndyInterface.bootstrap("cast", "()", 0, deleteBackendServiceOp) != false) {
            IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), region.get(), IndyInterface.bootstrap("invoke", "getName", 0, deleteBackendServiceOp), timeoutSeconds.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{backendServiceName.get()}, new String[]{"Regional backend service ", ""}), BASE_PHASE);
        }
        Closure deleteHealthCheckClosure = null;
        CallSite callSite2 = healthCheckType;
        if (ScriptBytecodeAdapter.isCase((Object)callSite2, (Object)"httpHealthChecks")) {
            public final class _operate_closure9
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference healthCheckName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure9(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference healthCheckName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.healthCheckName = reference = healthCheckName;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "httpHealthChecks", 0, this.compute.get()), this.project.get(), this.healthCheckName.get()), "compute.httpHealthChecks.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getHealthCheckName() {
                    return this.healthCheckName.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            deleteHealthCheckClosure = new _operate_closure9(this, this, compute, project, healthCheckName);
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite2, (Object)"httpsHealthChecks")) {
            public final class _operate_closure10
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference healthCheckName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure10(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference healthCheckName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.healthCheckName = reference = healthCheckName;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "httpsHealthChecks", 0, this.compute.get()), this.project.get(), this.healthCheckName.get()), "compute.httpsHealthChecks.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getHealthCheckName() {
                    return this.healthCheckName.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            deleteHealthCheckClosure = new _operate_closure10(this, this, compute, project, healthCheckName);
        } else if (ScriptBytecodeAdapter.isCase((Object)callSite2, (Object)"healthChecks")) {
            public final class _operate_closure11
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference healthCheckName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure11(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference healthCheckName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.compute = reference3 = compute;
                    this.project = reference2 = project;
                    this.healthCheckName = reference = healthCheckName;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "healthChecks", 0, this.compute.get()), this.project.get(), this.healthCheckName.get()), "compute.healthChecks.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
                }

                @Generated
                public Object getCompute() {
                    return this.compute.get();
                }

                @Generated
                public Object getProject() {
                    return this.project.get();
                }

                @Generated
                public Object getHealthCheckName() {
                    return this.healthCheckName.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            deleteHealthCheckClosure = new _operate_closure11(this, this, compute, project, healthCheckName);
        } else {
            CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "warn", 0, log, new GStringImpl(new Object[]{healthCheckName.get()}, new String[]{"Unknown health check type for health check named: ", "."})) : null;
        }
        CallSite deleteHealthCheckOp = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "deleteIfNotInUse", 0, GCEUtil.class, deleteHealthCheckClosure, new GStringImpl(new Object[]{healthCheckName.get()}, new String[]{"Health check ", ""}), project.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "delete", "operation", IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "compute.", healthCheckType), ".delete"), "phase", BASE_PHASE, IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), this.safeRetry, this));
        if (IndyInterface.bootstrap("cast", "()", 0, deleteHealthCheckOp) != false) {
            IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute.get(), project.get(), IndyInterface.bootstrap("invoke", "getName", 0, deleteHealthCheckOp), timeoutSeconds.get(), IndyInterface.bootstrap("getProperty", "task", 12, this), new GStringImpl(new Object[]{healthCheckName.get()}, new String[]{"Health check ", ""}), BASE_PHASE);
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), region.get()}, new String[]{"Done deleting internal load balancer ", " in ", "."}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeleteGoogleInternalLoadBalancerAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.DeleteGoogleInternalLoadBalancerAtomicOperation");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Generated
    public @VisibleForTesting void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    @Generated
    public @VisibleForTesting GoogleOperationPoller.ThreadSleeper getThreadSleeper() {
        return this.threadSleeper;
    }

    @Generated
    public @VisibleForTesting void setThreadSleeper(@VisibleForTesting GoogleOperationPoller.ThreadSleeper threadSleeper) {
        this.threadSleeper = threadSleeper;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

