/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.json.GenericJson;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.BackendServiceList;
import com.google.api.services.compute.model.ConnectionDraining;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.HealthCheck;
import com.google.api.services.compute.model.HealthCheckList;
import com.google.api.services.compute.model.HostRule;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.PathRule;
import com.google.api.services.compute.model.RegionTargetHttpsProxiesSetSslCertificatesRequest;
import com.google.api.services.compute.model.TargetHttpProxy;
import com.google.api.services.compute.model.TargetHttpsProxy;
import com.google.api.services.compute.model.UrlMap;
import com.google.api.services.compute.model.UrlMapReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutorTraits;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.BaseGoogleInstanceDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.description.UpsertGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationException;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.UpsertGoogleLoadBalancerAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.model.GoogleHealthCheck;
import com.netflix.spinnaker.clouddriver.google.model.GoogleNetwork;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSubnet;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleBackendService;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHostRule;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancedBackend;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GooglePathMatcher;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSessionAffinity;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTargetProxyType;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleNetworkProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSubnetProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationsRegistry;
import com.netflix.spinnaker.clouddriver.orchestration.OrchestrationProcessor;
import groovy.lang.Closure;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertGoogleInternalHttpLoadBalancerAtomicOperation
extends UpsertGoogleLoadBalancerAtomicOperation {
    private static final Logger log = LoggerFactory.getLogger(GoogleInternalHttpLoadBalancer.class);
    private static final String BASE_PHASE = "UPSERT_INTERNAL_HTTP_LOAD_BALANCER";
    private static final String PATH_MATCHER_PREFIX = "pm";
    public static final String TARGET_HTTP_PROXY_NAME_PREFIX = "target-http-proxy";
    public static final String TARGET_HTTPS_PROXY_NAME_PREFIX = "target-https-proxy";
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    @Autowired
    private AtomicOperationsRegistry atomicOperationsRegistry;
    @Autowired
    private GoogleNetworkProvider googleNetworkProvider;
    @Autowired
    private GoogleSubnetProvider googleSubnetProvider;
    @Autowired
    private OrchestrationProcessor orchestrationProcessor;
    @Autowired
    private SafeRetry safeRetry;
    private final UpsertGoogleLoadBalancerDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public UpsertGoogleInternalHttpLoadBalancerAtomicOperation(UpsertGoogleLoadBalancerDescription description) {
        this.description = description;
    }

    @Override
    public Map operate(List priorOutputs) {
        GoogleNetwork network = GCEUtil.queryNetwork(this.description.getAccountName(), this.description.getNetwork(), UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), BASE_PHASE, this.googleNetworkProvider);
        GoogleSubnet subnet = GCEUtil.querySubnet(this.description.getAccountName(), this.description.getRegion(), this.description.getSubnet(), UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), BASE_PHASE, this.googleSubnetProvider);
        GoogleInternalHttpLoadBalancer internalHttpLoadBalancer = new GoogleInternalHttpLoadBalancer();
        internalHttpLoadBalancer.setName(this.description.getLoadBalancerName());
        internalHttpLoadBalancer.setUrlMapName(this.description.getUrlMapName());
        internalHttpLoadBalancer.setDefaultService(this.description.getDefaultService());
        internalHttpLoadBalancer.setHostRules(this.description.getHostRules() != null ? this.description.getHostRules() : new ArrayList());
        internalHttpLoadBalancer.setCertificate(this.description.getCertificate());
        internalHttpLoadBalancer.setIpAddress(this.description.getIpAddress());
        internalHttpLoadBalancer.setIpProtocol(this.description.getIpProtocol());
        internalHttpLoadBalancer.setNetwork(network.getSelfLink());
        internalHttpLoadBalancer.setSubnet(subnet.getSelfLink());
        internalHttpLoadBalancer.setPortRange(this.description.getPortRange());
        String internalHttpLoadBalancerName = internalHttpLoadBalancer.getName();
        UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Initializing upsert of Internal HTTP load balancer " + internalHttpLoadBalancerName + "...");
        if (this.description.getCredentials() == null) {
            throw new IllegalArgumentException("Unable to resolve credentials for Google account '" + this.description.getAccountName() + "'.");
        }
        final Compute compute = this.description.getCredentials().getCompute();
        final String project = this.description.getCredentials().getProject();
        final String region = this.description.getRegion();
        HashSet healthCheckExistsSet = new HashSet();
        HashSet healthCheckNeedsUpdatedSet = new HashSet();
        HashSet serviceExistsSet = new HashSet();
        HashSet serviceNeedsUpdatedSet = new HashSet();
        boolean targetProxyExists = false;
        boolean targetProxyNeedsUpdated = false;
        ImmutableList backendServicesFromDescription = ImmutableSet.copyOf(Utils.getBackendServicesFromInternalHttpLoadBalancerView(internalHttpLoadBalancer.getView())).asList();
        List healthChecksFromDescription = backendServicesFromDescription.stream().map(GoogleBackendService::getHealthCheck).distinct().collect(Collectors.toList());
        String name = internalHttpLoadBalancer.getUrlMapName();
        String urlMapName = name != null ? name : internalHttpLoadBalancerName;
        try {
            Object backendServiceName;
            String healthCheckName;
            ForwardingRule existingRule;
            boolean urlMapExists;
            UrlMap existingUrlMap;
            List existingServices;
            List existingHealthChecks;
            block45: {
                block44: {
                    existingHealthChecks = ((HealthCheckList)this.timeExecute((AbstractGoogleClientRequest)compute.regionHealthChecks().list(project, region), "compute.regionHealthChecks.list", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region})).getItems();
                    existingServices = ((BackendServiceList)this.timeExecute((AbstractGoogleClientRequest)compute.regionBackendServices().list(project, region), "compute.regionBackendServices.list", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region})).getItems();
                    existingUrlMap = null;
                    try {
                        existingUrlMap = (UrlMap)this.timeExecute((AbstractGoogleClientRequest)compute.regionUrlMaps().get(project, region, urlMapName), "compute.regionUrlMaps.get", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                    }
                    catch (GoogleJsonResponseException e2) {
                        if (e2.getStatusCode() == 404) break block44;
                        throw e2;
                    }
                }
                urlMapExists = existingUrlMap != null;
                existingRule = null;
                try {
                    existingRule = (ForwardingRule)this.timeExecute((AbstractGoogleClientRequest)compute.forwardingRules().get(project, region, internalHttpLoadBalancerName), "compute.forwardingRules.get", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                }
                catch (GoogleJsonResponseException e3) {
                    if (e3.getStatusCode() == 404) break block45;
                    throw e3;
                }
            }
            boolean forwardingRuleExists = existingRule != null;
            GenericJson existingProxy = null;
            if (forwardingRuleExists) {
                Iterator<Object> targetProxyName = GCEUtil.getLocalName(existingRule.getTarget());
                switch (Utils.getTargetProxyType(existingRule.getTarget())) {
                    case HTTP: {
                        existingProxy = (GenericJson)this.timeExecute((AbstractGoogleClientRequest)compute.regionTargetHttpProxies().get(project, region, (String)((Object)targetProxyName)), "compute.regionTargetHttpProxies.get", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                        break;
                    }
                    case HTTPS: {
                        existingProxy = (GenericJson)this.timeExecute((AbstractGoogleClientRequest)compute.regionTargetHttpsProxies().get(project, region, (String)((Object)targetProxyName)), "compute.regionTargetHttpsProxies.get", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                        if (!StringGroovyMethods.asBoolean((CharSequence)internalHttpLoadBalancer.getCertificate())) {
                            throw new IllegalArgumentException(internalHttpLoadBalancerName + " is an Https load balancer, but the upsert description does not contain a certificate.");
                        }
                        targetProxyNeedsUpdated = !GCEUtil.getLocalName((String)((TargetHttpsProxy)existingProxy).getSslCertificates().get(0)).equals(GCEUtil.getLocalName(GCEUtil.buildCertificateUrl(project, internalHttpLoadBalancer.getCertificate())));
                        break;
                    }
                    default: {
                        log.warn("Unexpected target proxy type for " + (String)((Object)targetProxyName) + ".");
                    }
                }
                boolean bl = targetProxyExists = existingProxy != null;
                if (targetProxyExists && !GCEUtil.getLocalName((String)existingProxy.get((Object)"urlMap")).equals(this.description.getUrlMapName())) {
                    throw new IllegalStateException("Listener with name " + existingRule.getName() + " already exists and points to url map: " + GCEUtil.getLocalName((String)existingProxy.get((Object)"urlMap")) + ", which is different from the description url map: " + this.description.getUrlMapName() + ".");
                }
            }
            if ((long)healthChecksFromDescription.size() != healthChecksFromDescription.stream().map(GoogleHealthCheck::getName).distinct().count()) {
                throw new GoogleOperationException("Duplicate health checks with different attributes in the description. Please specify one object per named health check.");
            }
            for (GoogleHealthCheck healthCheck : healthChecksFromDescription) {
                healthCheckName = healthCheck.getName();
                existingHealthChecks.stream().filter(e -> e.getName().equals(healthCheckName)).findFirst().ifPresent(existingHealthCheck -> {
                    healthCheckExistsSet.add(healthCheck.getName());
                    if (GCEUtil.healthCheckShouldBeUpdated(existingHealthCheck, healthCheck).booleanValue()) {
                        healthCheckNeedsUpdatedSet.add(healthCheck.getName());
                    }
                });
            }
            if ((long)backendServicesFromDescription.size() != backendServicesFromDescription.stream().map(GoogleBackendService::getName).distinct().count()) {
                throw new GoogleOperationException("Duplicate backend services with different attributes in the description. Please specify one object per named backend service.");
            }
            for (GoogleBackendService backendService : backendServicesFromDescription) {
                backendServiceName = backendService.getName();
                existingServices.stream().filter(arg_0 -> UpsertGoogleInternalHttpLoadBalancerAtomicOperation.lambda$operate$2((String)backendServiceName, arg_0)).findFirst().ifPresent(existingService -> {
                    serviceExistsSet.add(backendService.getName());
                    HashSet existingHcs = existingService.getHealthChecks() == null ? new HashSet() : existingService.getHealthChecks().stream().map(GCEUtil::getLocalName).collect(Collectors.toSet());
                    Boolean differentHealthChecks = Sets.difference(existingHcs, (Set)ImmutableSet.of((Object)backendService.getHealthCheck().getName())).size() > 0;
                    Boolean differentSessionAffinity = !GoogleSessionAffinity.valueOf(existingService.getSessionAffinity()).equals((Object)backendService.getSessionAffinity());
                    Boolean differentSessionCookieTtl = !Objects.equals(existingService.getAffinityCookieTtlSec(), backendService.getAffinityCookieTtlSec());
                    Boolean differentPortName = !Objects.equals(existingService.getPortName(), backendService.getPortName());
                    Integer drainingSec = existingService.getConnectionDraining() == null ? 0 : existingService.getConnectionDraining().getDrainingTimeoutSec();
                    Boolean differentConnectionDraining = !Objects.equals(drainingSec, backendService.getConnectionDrainingTimeoutSec());
                    if (differentHealthChecks.booleanValue() || differentSessionAffinity.booleanValue() || differentSessionCookieTtl.booleanValue() || differentPortName.booleanValue() || differentConnectionDraining.booleanValue()) {
                        serviceNeedsUpdatedSet.add(backendService.getName());
                    }
                });
            }
            for (GoogleHealthCheck healthCheck : healthChecksFromDescription) {
                healthCheckName = healthCheck.getName();
                if (!healthCheckExistsSet.contains(healthCheck.getName())) {
                    UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Creating health check " + healthCheckName + " in " + region + "...");
                    HealthCheck newHealthCheck = GCEUtil.createNewHealthCheck(healthCheck);
                    Operation insertHealthCheckOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)compute.regionHealthChecks().insert(project, region, newHealthCheck), "compute.regionHealthChecks.insert", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                    this.googleOperationPoller.waitForRegionalOperation(compute, project, region, insertHealthCheckOperation.getName(), null, UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "region health check " + healthCheckName, BASE_PHASE);
                    continue;
                }
                if (!healthCheckExistsSet.contains(healthCheck.getName()) || !healthCheckNeedsUpdatedSet.contains(healthCheck.getName())) continue;
                UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Updating health check " + healthCheckName + "...");
                HealthCheck hcToUpdate = existingHealthChecks.stream().filter(hc -> hc.getName().equals(healthCheckName)).findFirst().get();
                GCEUtil.updateExistingHealthCheck(hcToUpdate, healthCheck);
                Operation updateHealthCheckOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)compute.regionHealthChecks().update(project, region, healthCheckName, hcToUpdate), "compute.regionHealthChecks.update", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                this.googleOperationPoller.waitForRegionalOperation(compute, project, region, updateHealthCheckOperation.getName(), null, UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "region health check " + healthCheckName, BASE_PHASE);
            }
            for (GoogleBackendService backendService : backendServicesFromDescription) {
                String sessionAffinity;
                backendServiceName = backendService.getName();
                String string = sessionAffinity = backendService.getSessionAffinity() != null ? backendService.getSessionAffinity().toString() : "NONE";
                if (!serviceExistsSet.contains(backendService.getName())) {
                    UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Creating backend service " + (String)backendServiceName + " in " + region + "...");
                    BackendService service = new BackendService();
                    BackendService bs = service.setName((String)backendServiceName);
                    service.setLoadBalancingScheme("INTERNAL_MANAGED");
                    service.setPortName(backendService.getPortName() != null ? backendService.getPortName() : "http");
                    service.setConnectionDraining(new ConnectionDraining().setDrainingTimeoutSec(backendService.getConnectionDrainingTimeoutSec()));
                    service.setHealthChecks(Arrays.asList(GCEUtil.buildRegionalHealthCheckUrl(project, region, backendService.getHealthCheck().getName())));
                    service.setSessionAffinity(sessionAffinity);
                    service.setAffinityCookieTtlSec(backendService.getAffinityCookieTtlSec());
                    Operation insertBackendServiceOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)compute.regionBackendServices().insert(project, region, bs), "compute.regionBackendServices.insert", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                    this.googleOperationPoller.waitForRegionalOperation(compute, project, region, insertBackendServiceOperation.getName(), null, UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "region backend service " + (String)backendServiceName, BASE_PHASE);
                    continue;
                }
                if (!serviceExistsSet.contains(backendService.getName())) continue;
                if (serviceNeedsUpdatedSet.contains(backendService.getName())) {
                    UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Updating backend service " + (String)backendServiceName + " in " + region + "...");
                    BackendService bsToUpdate = existingServices.stream().filter(arg_0 -> UpsertGoogleInternalHttpLoadBalancerAtomicOperation.lambda$operate$5((String)backendServiceName, arg_0)).findFirst().get();
                    String hcName = backendService.getHealthCheck().getName();
                    bsToUpdate.setPortName(backendService.getPortName() != null ? backendService.getPortName() : "http");
                    bsToUpdate.setConnectionDraining(new ConnectionDraining().setDrainingTimeoutSec(backendService.getConnectionDrainingTimeoutSec()));
                    bsToUpdate.setHealthChecks(Arrays.asList(GCEUtil.buildRegionalHealthCheckUrl(project, region, hcName)));
                    bsToUpdate.setSessionAffinity(sessionAffinity);
                    bsToUpdate.setAffinityCookieTtlSec(backendService.getAffinityCookieTtlSec());
                    Operation updateServiceOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)compute.regionBackendServices().update(project, region, (String)backendServiceName, bsToUpdate), "compute.regionBackendServices.update", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                    this.googleOperationPoller.waitForRegionalOperation(compute, project, region, updateServiceOperation.getName(), null, UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "region backend service  " + (String)backendServiceName, BASE_PHASE);
                }
                this.fixBackendMetadata(compute, this.description.getCredentials(), project, this.getAtomicOperationsRegistry(), this.getOrchestrationProcessor(), this.description.getLoadBalancerName(), backendService);
            }
            if (this.description.getBackendServiceDiff() != null) {
                for (GoogleBackendService backendService : this.description.getBackendServiceDiff()) {
                    this.fixBackendMetadata(compute, this.description.getCredentials(), project, this.getAtomicOperationsRegistry(), this.getOrchestrationProcessor(), this.description.getLoadBalancerName(), backendService);
                }
            }
            String urlMapUrl = null;
            if (!urlMapExists) {
                UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Creating URL map " + urlMapName + " in " + region + "...");
                UrlMap newUrlMap = new UrlMap();
                newUrlMap.setName(urlMapName);
                newUrlMap.setHostRules(new ArrayList());
                newUrlMap.setPathMatchers(new ArrayList());
                newUrlMap.setDefaultService(GCEUtil.buildRegionBackendServiceUrl(project, region, internalHttpLoadBalancer.getDefaultService().getName()));
                for (GoogleHostRule hostRule : internalHttpLoadBalancer.getHostRules()) {
                    String pathMatcherName = "pm-" + UUID.randomUUID().toString();
                    GooglePathMatcher pathMatcher = hostRule.getPathMatcher();
                    PathMatcher matcher = new PathMatcher();
                    matcher.setDefaultService(GCEUtil.buildRegionBackendServiceUrl(project, region, pathMatcher.getDefaultService().getName()));
                    matcher.setPathRules(pathMatcher.getPathRules().stream().map(p -> {
                        PathRule rule = new PathRule();
                        rule.setPaths(p.getPaths());
                        rule.setService(GCEUtil.buildRegionBackendServiceUrl(project, region, p.getBackendService().getName()));
                        return rule;
                    }).collect(Collectors.toList()));
                    newUrlMap.getPathMatchers().add(matcher);
                    HostRule rule = new HostRule();
                    rule.setHosts(hostRule.getHostPatterns());
                    rule.setPathMatcher(pathMatcherName);
                    newUrlMap.getHostRules().add(rule);
                }
                Operation insertUrlMapOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)compute.regionUrlMaps().insert(project, region, newUrlMap), "compute.regionUrlMaps.insert", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                this.googleOperationPoller.waitForRegionalOperation(compute, project, region, insertUrlMapOperation.getName(), null, UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "region url map " + urlMapName, BASE_PHASE);
                urlMapUrl = insertUrlMapOperation.getTargetLink();
            } else if (urlMapExists) {
                UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Updating URL map " + urlMapName + " in " + region + "...");
                existingUrlMap.setDefaultService(GCEUtil.buildRegionBackendServiceUrl(project, region, internalHttpLoadBalancer.getDefaultService().getName()));
                existingUrlMap.setPathMatchers(new ArrayList());
                existingUrlMap.setHostRules(new ArrayList());
                for (GoogleHostRule hostRule : internalHttpLoadBalancer.getHostRules()) {
                    String pathMatcherName = "pm-" + UUID.randomUUID().toString();
                    GooglePathMatcher pathMatcher = hostRule.getPathMatcher();
                    PathMatcher matcher = new PathMatcher();
                    matcher.setName(pathMatcherName);
                    matcher.setDefaultService(GCEUtil.buildRegionBackendServiceUrl(project, region, pathMatcher.getDefaultService().getName()));
                    matcher.setPathRules(pathMatcher.getPathRules().stream().map(p -> {
                        PathRule rule = new PathRule();
                        rule.setService(GCEUtil.buildRegionBackendServiceUrl(project, region, p.getBackendService().getName()));
                        rule.setPaths(p.getPaths());
                        return rule;
                    }).collect(Collectors.toList()));
                    existingUrlMap.getPathMatchers().add(matcher);
                    HostRule rule = new HostRule();
                    rule.setHosts(hostRule.getHostPatterns());
                    existingUrlMap.getHostRules().add(rule.setPathMatcher(pathMatcherName));
                }
                Operation updateUrlMapOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)compute.regionUrlMaps().update(project, region, urlMapName, existingUrlMap), "compute.regionUrlMaps.update", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                this.googleOperationPoller.waitForRegionalOperation(compute, project, region, updateUrlMapOperation.getName(), null, UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "region url map " + urlMapName, BASE_PHASE);
                urlMapUrl = updateUrlMapOperation.getTargetLink();
            } else {
                urlMapUrl = existingUrlMap.getSelfLink();
            }
            String targetProxyUrl = null;
            if (!targetProxyExists) {
                Operation insertTargetProxyOperation;
                if (!StringUtils.isEmpty((CharSequence)internalHttpLoadBalancer.getCertificate())) {
                    targetProxyName = internalHttpLoadBalancerName + "-target-https-proxy";
                    UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Creating target proxy " + targetProxyName + " in " + region + "...");
                    proxy = new TargetHttpsProxy();
                    proxy.setSslCertificates(Arrays.asList(GCEUtil.buildCertificateUrl(project, internalHttpLoadBalancer.getCertificate())));
                    proxy.setUrlMap(urlMapUrl);
                    proxy.setName(targetProxyName);
                    targetProxy = proxy;
                    insertTargetProxyOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)compute.regionTargetHttpsProxies().insert(project, region, targetProxy), "compute.regionTargetHttpsProxies.insert", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                } else {
                    targetProxyName = internalHttpLoadBalancerName + "-target-http-proxy";
                    UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Creating target proxy " + targetProxyName + " in " + region + "...");
                    proxy = new TargetHttpProxy();
                    proxy.setName(targetProxyName);
                    proxy.setUrlMap(urlMapUrl);
                    targetProxy = proxy;
                    insertTargetProxyOperation = (Operation)this.timeExecute((AbstractGoogleClientRequest)compute.regionTargetHttpProxies().insert(project, region, (TargetHttpProxy)targetProxy), "compute.regionTargetHttpProxies.insert", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                }
                this.googleOperationPoller.waitForRegionalOperation(compute, project, region, insertTargetProxyOperation.getName(), null, UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "region target proxy " + targetProxyName, BASE_PHASE);
                targetProxyUrl = insertTargetProxyOperation.getTargetLink();
            } else if (targetProxyExists && targetProxyNeedsUpdated) {
                GoogleTargetProxyType proxyType = Utils.getTargetProxyType((String)existingProxy.get((Object)"selfLink"));
                switch (proxyType) {
                    case HTTP: {
                        break;
                    }
                    case HTTPS: {
                        targetProxyName = internalHttpLoadBalancerName + "-target-https-proxy";
                        UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Updating target proxy " + targetProxyName + " in " + region + "...");
                        RegionTargetHttpsProxiesSetSslCertificatesRequest request = new RegionTargetHttpsProxiesSetSslCertificatesRequest();
                        RegionTargetHttpsProxiesSetSslCertificatesRequest setSslReq = request.setSslCertificates(Arrays.asList(GCEUtil.buildRegionalCertificateUrl(project, region, internalHttpLoadBalancer.getCertificate())));
                        Operation sslCertOp = (Operation)this.timeExecute((AbstractGoogleClientRequest)compute.regionTargetHttpsProxies().setSslCertificates(project, region, targetProxyName, setSslReq), "compute.regionTargetHttpsProxies.setSslCertificates", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                        this.googleOperationPoller.waitForRegionalOperation(compute, project, region, sslCertOp.getName(), null, UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "set ssl cert " + internalHttpLoadBalancer.getCertificate(), BASE_PHASE);
                        UrlMapReference reference = new UrlMapReference();
                        UrlMapReference urlMapRef = reference.setUrlMap(urlMapUrl);
                        Operation setUrlMapOp = (Operation)this.timeExecute((AbstractGoogleClientRequest)compute.regionTargetHttpsProxies().setUrlMap(project, region, targetProxyName, urlMapRef), "compute.regionTargetHttpsProxies.setUrlMap", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, region});
                        this.googleOperationPoller.waitForRegionalOperation(compute, project, region, setUrlMapOp.getName(), null, UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "set urlMap " + urlMapUrl + " for target proxy " + targetProxyName, BASE_PHASE);
                        targetProxyUrl = setUrlMapOp.getTargetLink();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Updating Internal Http load balancer " + internalHttpLoadBalancerName + " in " + region + " failed. Could not update target proxy; Illegal target proxy type " + String.valueOf((Object)proxyType) + ".");
                    }
                }
            } else {
                targetProxyUrl = (String)existingProxy.get((Object)"selfLink");
            }
            if (!forwardingRuleExists) {
                UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Creating internal forwarding rule " + internalHttpLoadBalancerName + " in " + region + "...");
                final ForwardingRule rule = new ForwardingRule();
                rule.setName(internalHttpLoadBalancerName);
                rule.setLoadBalancingScheme("INTERNAL_MANAGED");
                rule.setIPAddress(internalHttpLoadBalancer.getIpAddress());
                rule.setIPProtocol(internalHttpLoadBalancer.getIpProtocol());
                rule.setNetwork(internalHttpLoadBalancer.getNetwork());
                rule.setSubnetwork(internalHttpLoadBalancer.getSubnet());
                rule.setPortRange(StringGroovyMethods.asBoolean((CharSequence)internalHttpLoadBalancer.getCertificate()) ? "443" : internalHttpLoadBalancer.getPortRange());
                rule.setTarget(targetProxyUrl);
                Operation forwardingRuleOp = this.safeRetry.doRetry(new Closure<Operation>((Object)this, (Object)this){

                    public Operation call() {
                        try {
                            return (Operation)UpsertGoogleInternalHttpLoadBalancerAtomicOperation.this.timeExecute((AbstractGoogleClientRequest)compute.forwardingRules().insert(project, region, rule), "compute.forwardingRules.insert", new String[]{GoogleExecutorTraits.TAG_SCOPE, GoogleExecutorTraits.SCOPE_REGIONAL, GoogleExecutorTraits.TAG_REGION, region});
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }, "forwarding rule " + this.description.getLoadBalancerName(), UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), Arrays.asList(400, 403, 412), new ArrayList<Integer>(), (Map<String, String>)ImmutableMap.of((Object)"action", (Object)"insert", (Object)"phase", (Object)BASE_PHASE, (Object)"operation", (Object)"compute.forwardingRules.insert", (Object)TAG_SCOPE, (Object)SCOPE_REGIONAL, (Object)TAG_REGION, (Object)region), this.getRegistry());
                this.googleOperationPoller.waitForRegionalOperation(compute, project, region, forwardingRuleOp.getName(), null, UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask(), "forwarding rule " + internalHttpLoadBalancerName, BASE_PHASE);
            }
            if (this.description.getListenersToDelete() != null) {
                for (String forwardingRuleName : this.description.getListenersToDelete()) {
                    UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Deleting listener " + forwardingRuleName + " in " + region + "...");
                    GCEUtil.deleteRegionalListener(compute, project, region, forwardingRuleName, BASE_PHASE, this.getSafeRetry(), this);
                }
            }
            UpsertGoogleInternalHttpLoadBalancerAtomicOperation.getTask().updateStatus(BASE_PHASE, "Done upserting Internal HTTP load balancer " + internalHttpLoadBalancerName + " in " + region);
            HashMap<String, String> lb = new HashMap<String, String>(1);
            lb.put("name", internalHttpLoadBalancerName);
            HashMap<String, HashMap<String, String>> regionToLb = new HashMap<String, HashMap<String, String>>(1);
            regionToLb.put("region", lb);
            HashMap<String, HashMap<String, HashMap<String, String>>> lbs = new HashMap<String, HashMap<String, HashMap<String, String>>>(1);
            lbs.put("loadBalancers", regionToLb);
            return lbs;
        }
        catch (IOException e4) {
            throw new UncheckedIOException(e4);
        }
    }

    private void fixBackendMetadata(Compute compute, GoogleNamedAccountCredentials credentials, String project, AtomicOperationsRegistry atomicOperationsRegistry, OrchestrationProcessor orchestrationProcessor, String loadBalancerName, GoogleBackendService backendService) {
        try {
            for (GoogleLoadBalancedBackend backend : backendService.getBackends()) {
                String groupName = Utils.getLocalName(backend.getServerGroupUrl());
                String groupRegion = Utils.getRegionFromGroupUrl(backend.getServerGroupUrl());
                String templateUrl = null;
                switch (Utils.determineServerGroupType(backend.getServerGroupUrl())) {
                    case REGIONAL: {
                        templateUrl = ((InstanceGroupManager)this.timeExecute((AbstractGoogleClientRequest)compute.regionInstanceGroupManagers().get(project, groupRegion, groupName), "compute.regionInstanceGroupManagers.get", new String[]{TAG_SCOPE, SCOPE_REGIONAL, TAG_REGION, groupRegion})).getInstanceTemplate();
                        break;
                    }
                    case ZONAL: {
                        String groupZone = Utils.getZoneFromGroupUrl(backend.getServerGroupUrl());
                        templateUrl = ((InstanceGroupManager)this.timeExecute((AbstractGoogleClientRequest)compute.instanceGroupManagers().get(project, groupZone, groupName), "compute.instanceGroupManagers.get", new String[]{TAG_SCOPE, SCOPE_ZONAL, TAG_ZONE, groupZone})).getInstanceTemplate();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Server group referenced by " + backend.getServerGroupUrl() + " has illegal type.");
                    }
                }
                InstanceTemplate template = (InstanceTemplate)this.timeExecute((AbstractGoogleClientRequest)compute.instanceTemplates().get(project, Utils.getLocalName(templateUrl)), "compute.instancesTemplates.get", new String[]{TAG_SCOPE, SCOPE_GLOBAL});
                BaseGoogleInstanceDescription instanceDescription = GCEUtil.buildInstanceDescriptionFromTemplate(project, template);
                HashMap<String, Object> templateOpMap = new HashMap<String, Object>(15);
                templateOpMap.put("image", instanceDescription.getImage());
                templateOpMap.put("instanceType", instanceDescription.getInstanceType());
                templateOpMap.put("credentials", credentials.getName());
                templateOpMap.put("disks", instanceDescription.getDisks());
                templateOpMap.put("instanceMetadata", instanceDescription.getInstanceMetadata());
                templateOpMap.put("tags", instanceDescription.getTags());
                templateOpMap.put("network", instanceDescription.getNetwork());
                templateOpMap.put("subnet", instanceDescription.getSubnet());
                templateOpMap.put("serviceAccountEmail", instanceDescription.getServiceAccountEmail());
                templateOpMap.put("authScopes", instanceDescription.getAuthScopes());
                templateOpMap.put("preemptible", instanceDescription.getPreemptible());
                templateOpMap.put("automaticRestart", instanceDescription.getAutomaticRestart());
                templateOpMap.put("onHostMaintenance", (Object)instanceDescription.getOnHostMaintenance());
                templateOpMap.put("region", groupRegion);
                templateOpMap.put("serverGroupName", groupName);
                if (StringGroovyMethods.asBoolean((CharSequence)instanceDescription.getMinCpuPlatform())) {
                    templateOpMap.put("minCpuPlatform", instanceDescription.getMinCpuPlatform());
                }
                if (templateOpMap.containsKey("instanceMetadata")) {
                    instanceMetadata = (HashMap<String, String>)templateOpMap.get("instanceMetadata");
                    String regionLbStr = (String)instanceMetadata.get("load-balancer-names");
                    ArrayList<String> regionalLbs = regionLbStr != null ? new ArrayList<String>(Arrays.asList(regionLbStr.split(","))) : new ArrayList();
                    regionalLbs.add(loadBalancerName);
                    instanceMetadata.put("load-balancer-names", regionalLbs.stream().distinct().collect(Collectors.joining(",")));
                    String backendsStr = (String)instanceMetadata.get("region-backend-service-names");
                    ArrayList<String> bsNames = backendsStr != null ? new ArrayList<String>(Arrays.asList(backendsStr.split(","))) : new ArrayList();
                    bsNames.add(backendService.getName());
                    instanceMetadata.put("region-backend-service-names", bsNames.stream().distinct().collect(Collectors.joining(",")));
                } else {
                    instanceMetadata = new HashMap<String, String>(2);
                    instanceMetadata.put("load-balancer-names", loadBalancerName);
                    instanceMetadata.put("region-backend-service-names", backendService.getName());
                    templateOpMap.put("instanceMetadata", instanceMetadata);
                }
                AtomicOperationConverter converter = atomicOperationsRegistry.getAtomicOperationConverter("modifyGoogleServerGroupInstanceTemplateDescription", "gce");
                AtomicOperation templateOp = converter.convertOperation(templateOpMap);
                orchestrationProcessor.process("gce", new ArrayList<AtomicOperation>(Arrays.asList(templateOp)), UUID.randomUUID().toString());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public AtomicOperationsRegistry getAtomicOperationsRegistry() {
        return this.atomicOperationsRegistry;
    }

    public void setAtomicOperationsRegistry(AtomicOperationsRegistry atomicOperationsRegistry) {
        this.atomicOperationsRegistry = atomicOperationsRegistry;
    }

    public OrchestrationProcessor getOrchestrationProcessor() {
        return this.orchestrationProcessor;
    }

    public void setOrchestrationProcessor(OrchestrationProcessor orchestrationProcessor) {
        this.orchestrationProcessor = orchestrationProcessor;
    }

    @Override
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Override
    public void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    private static /* synthetic */ boolean lambda$operate$5(String backendServiceName, BackendService s) {
        return s.getName().equals(backendServiceName);
    }

    private static /* synthetic */ boolean lambda$operate$2(String backendServiceName, BackendService e) {
        return e.getName().equals(backendServiceName);
    }
}

