/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.HealthCheckReference;
import com.google.api.services.compute.model.HttpHealthCheck;
import com.google.api.services.compute.model.InstanceReference;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.TargetPool;
import com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsAddInstanceRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.deploy.GoogleOperationPoller;
import com.netflix.spinnaker.clouddriver.google.deploy.SafeRetry;
import com.netflix.spinnaker.clouddriver.google.deploy.description.UpsertGoogleLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleOperationException;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.GoogleAtomicOperation;
import com.netflix.spinnaker.clouddriver.google.deploy.ops.loadbalancer.Constants;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSessionAffinity;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertGoogleLoadBalancerAtomicOperation
extends GoogleAtomicOperation<Map> {
    private static final String BASE_PHASE = "UPSERT_LOAD_BALANCER";
    @Autowired
    private SafeRetry safeRetry;
    @Autowired
    private GoogleOperationPoller googleOperationPoller;
    private final UpsertGoogleLoadBalancerDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public UpsertGoogleLoadBalancerAtomicOperation() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public UpsertGoogleLoadBalancerAtomicOperation(UpsertGoogleLoadBalancerDescription description) {
        UpsertGoogleLoadBalancerDescription upsertGoogleLoadBalancerDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = upsertGoogleLoadBalancerDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Map operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Initializing upsert of load balancer ", " "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "region", 4, this.description)}, new String[]{"in ", "..."})));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "accountName", 4, this.description)}, new String[]{"Unable to resolve credentials for Google account '", "'."})));
        }
        CallSite compute = IndyInterface.bootstrap("getProperty", "compute", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description));
        CallSite region = IndyInterface.bootstrap("getProperty", "region", 4, this.description);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ipProtocol", 4, this.description);
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("getProperty", "DEFAULT_IP_PROTOCOL", 0, Constants.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, UpsertGoogleLoadBalancerAtomicOperation.class, (GroovyObject)this.description, (String)"ipProtocol");
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "portRange", 4, this.description);
        CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : IndyInterface.bootstrap("getProperty", "DEFAULT_PORT_RANGE", 0, Constants.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite4, UpsertGoogleLoadBalancerAtomicOperation.class, (GroovyObject)this.description, (String)"portRange");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)) != false) {
            public final class _operate_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operate_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "checkIntervalSec", 12, this);
                    CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("getProperty", "DEFAULT_CHECK_INTERVAL_SEC", 0, Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, _operate_closure1.class, (GroovyObject)this, (String)"checkIntervalSec");
                    CallSite callSite3 = IndyInterface.bootstrap("getProperty", "healthyThreshold", 12, this);
                    CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : IndyInterface.bootstrap("getProperty", "DEFAULT_HEALTHY_THRESHOLD", 0, Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite4, _operate_closure1.class, (GroovyObject)this, (String)"healthyThreshold");
                    CallSite callSite5 = IndyInterface.bootstrap("getProperty", "unhealthyThreshold", 12, this);
                    CallSite callSite6 = IndyInterface.bootstrap("cast", "()", 0, callSite5) != false ? callSite5 : IndyInterface.bootstrap("getProperty", "DEFAULT_UNHEALTHY_THRESHOLD", 0, Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite6, _operate_closure1.class, (GroovyObject)this, (String)"unhealthyThreshold");
                    CallSite callSite7 = IndyInterface.bootstrap("getProperty", "port", 12, this);
                    CallSite callSite8 = IndyInterface.bootstrap("cast", "()", 0, callSite7) != false ? callSite7 : IndyInterface.bootstrap("getProperty", "DEFAULT_PORT", 0, Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite8, _operate_closure1.class, (GroovyObject)this, (String)"port");
                    CallSite callSite9 = IndyInterface.bootstrap("getProperty", "timeoutSec", 12, this);
                    CallSite callSite10 = IndyInterface.bootstrap("cast", "()", 0, callSite9) != false ? callSite9 : IndyInterface.bootstrap("getProperty", "DEFAULT_TIMEOUT_SEC", 0, Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite10, _operate_closure1.class, (GroovyObject)this, (String)"timeoutSec");
                    CallSite callSite11 = IndyInterface.bootstrap("getProperty", "requestPath", 12, this);
                    CallSite callSite12 = IndyInterface.bootstrap("cast", "()", 0, callSite11) != false ? callSite11 : IndyInterface.bootstrap("getProperty", "DEFAULT_REQUEST_PATH", 0, Constants.class);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite12, _operate_closure1.class, (GroovyObject)this, (String)"requestPath");
                    return callSite12;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description), new _operate_closure1(this, this));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "instances", 4, this.description)) != false) {
            CallSite callSite5 = IndyInterface.bootstrap("invoke", "queryInstanceUrls", 0, GCEUtil.class, project, region, IndyInterface.bootstrap("getProperty", "instances", 4, this.description), compute, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this);
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite5, UpsertGoogleLoadBalancerAtomicOperation.class, (GroovyObject)this.description, (String)"instances");
        }
        CallSite existingForwardingRule = null;
        CallSite existingTargetPool = null;
        CallSite existingHttpHealthCheck = null;
        boolean needToUpdateForwardingRule = false;
        boolean needToUpdateTargetPool = false;
        boolean needToUpdateHttpHealthCheck = false;
        boolean needToDeleteHttpHealthCheck = false;
        boolean needToCreateNewForwardingRule = false;
        boolean needToCreateNewTargetPool = false;
        boolean needToCreateNewHttpHealthCheck = false;
        existingForwardingRule = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "queryRegionalForwardingRule", 0, GCEUtil.class, project, IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), compute, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this));
        if (IndyInterface.bootstrap("cast", "()", 0, existingForwardingRule) != false) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "region", 4, this.description), (Object)IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "region", 0, existingForwardingRule)))) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleOperationException.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "There is already a network load balancer named ", new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "region", 0, existingForwardingRule))}, new String[]{"", " (in region ", "). "})), "Please specify a different name.")));
            }
            needToUpdateForwardingRule = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "ipAddress", 4, this.description)) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "ipAddress", 4, this.description), (Object)IndyInterface.bootstrap("getProperty", "IPAddress", 0, existingForwardingRule)) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "ipProtocol", 4, this.description), (Object)IndyInterface.bootstrap("getProperty", "IPProtocol", 0, existingForwardingRule)) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "portRange", 4, this.description), (Object)IndyInterface.bootstrap("getProperty", "portRange", 0, existingForwardingRule));
            existingTargetPool = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "queryTargetPool", 0, GCEUtil.class, project, region, IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "target", 0, existingForwardingRule)), compute, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this));
            if (IndyInterface.bootstrap("cast", "()", 0, existingTargetPool) != false) {
                CallSite newSessionAffinity = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "orElse", 0, IndyInterface.bootstrap("invoke", "ofNullable", 0, Optional.class, IndyInterface.bootstrap("getProperty", "sessionAffinity", 4, this.description)), IndyInterface.bootstrap("getProperty", "NONE", 0, GoogleSessionAffinity.class)));
                boolean sessionAffinityChanged = ScriptBytecodeAdapter.compareNotEqual((Object)newSessionAffinity, (Object)IndyInterface.bootstrap("invoke", "valueOf", 0, GoogleSessionAffinity.class, IndyInterface.bootstrap("invoke", "getSessionAffinity", 0, existingTargetPool)));
                if (sessionAffinityChanged && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "any", 0, IndyInterface.bootstrap("getProperty", "instances", 0, existingTargetPool)))) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Impossible to change Session Affinity for target pool with existing instances.");
                    IndyInterface.bootstrap("invoke", "fail", 0, IndyInterface.bootstrap("getProperty", "task", 12, this));
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                needToUpdateTargetPool = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "instances", 4, this.description), null) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthChecks", 0, existingTargetPool)) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)) == false && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "healthChecks", 0, existingTargetPool));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthChecks", 0, existingTargetPool)) != false) {
                    existingHttpHealthCheck = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "queryHttpHealthCheck", 0, GCEUtil.class, project, IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "healthChecks", 0, existingTargetPool), false)), compute, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, this));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)) != false) {
                        needToUpdateHttpHealthCheck = ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "checkIntervalSec", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)), (Object)IndyInterface.bootstrap("getProperty", "checkIntervalSec", 0, existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "healthyThreshold", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)), (Object)IndyInterface.bootstrap("getProperty", "healthyThreshold", 0, existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "unhealthyThreshold", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)), (Object)IndyInterface.bootstrap("getProperty", "unhealthyThreshold", 0, existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "port", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)), (Object)IndyInterface.bootstrap("getProperty", "port", 0, existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "timeoutSec", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)), (Object)IndyInterface.bootstrap("getProperty", "timeoutSec", 0, existingHttpHealthCheck)) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "requestPath", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)), (Object)IndyInterface.bootstrap("getProperty", "requestPath", 0, existingHttpHealthCheck));
                    } else {
                        needToDeleteHttpHealthCheck = true;
                    }
                } else {
                    needToCreateNewHttpHealthCheck = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description));
                }
            } else {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "target", 0, existingForwardingRule))}, new String[]{"Unable to retrieve referenced target pool ", "."}));
                needToCreateNewTargetPool = true;
                needToCreateNewHttpHealthCheck = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description));
            }
        } else {
            needToCreateNewForwardingRule = true;
            needToCreateNewTargetPool = true;
            needToCreateNewHttpHealthCheck = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description));
        }
        List httpHealthChecksResourceLinks = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (needToUpdateHttpHealthCheck) {
            IndyInterface.bootstrap("invoke", "updateHttpHealthCheck", 2, this, existingHttpHealthCheck, compute, project);
        } else if (needToCreateNewHttpHealthCheck) {
            IndyInterface.bootstrap("invoke", "createNewHttpHealthCheck", 2, this, httpHealthChecksResourceLinks, compute, project);
        }
        CallSite targetPoolName = null;
        CallSite targetPoolResourceOperation = null;
        CallSite targetPoolResourceLink = null;
        if (needToUpdateTargetPool) {
            targetPoolName = IndyInterface.bootstrap("getProperty", "name", 0, existingTargetPool);
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{targetPoolName, region}, new String[]{"Updating target pool ", " in ", "..."}));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "instances", 4, this.description), null)) {
                CallSite instancesToAdd = IndyInterface.bootstrap("invoke", "minus", 0, (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "instances", 4, this.description), Set.class)), ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "instances", 0, existingTargetPool), Set.class))), Set.class));
                List instancesToRemove = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "instances", 0, existingTargetPool)) != false ? IndyInterface.bootstrap("invoke", "minus", 0, (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "instances", 0, existingTargetPool), Set.class)), ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "instances", 4, this.description), Set.class))), Set.class)) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                IndyInterface.bootstrap("invoke", "addInstancesToTargetPoolIfNecessary", 2, this, targetPoolName, instancesToAdd, region, compute, project);
                IndyInterface.bootstrap("invoke", "removeInstancesFromTargetPoolIfNecessary", 2, this, targetPoolName, instancesToRemove, region, compute, project);
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)) == false && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "healthChecks", 0, existingTargetPool))) {
                targetPoolResourceOperation = IndyInterface.bootstrap("invoke", "removeHttpHealthCheckFromTargetPool", 2, this, targetPoolName, targetPoolResourceOperation, existingTargetPool, existingHttpHealthCheck, region, compute, project);
                targetPoolResourceLink = IndyInterface.bootstrap("getProperty", "targetLink", 0, targetPoolResourceOperation);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthChecks", 0, existingTargetPool)) == false) {
                targetPoolResourceOperation = IndyInterface.bootstrap("invoke", "addHttpHealthCheckToTargetPool", 2, this, targetPoolName, targetPoolResourceOperation, httpHealthChecksResourceLinks, region, compute, project);
                targetPoolResourceLink = IndyInterface.bootstrap("getProperty", "targetLink", 0, targetPoolResourceOperation);
            }
        } else if (needToCreateNewTargetPool) {
            CallSite callSite6 = IndyInterface.bootstrap("invoke", "createNewTargetPool", 2, this, targetPoolName, targetPoolResourceOperation, httpHealthChecksResourceLinks, region, compute, project);
            targetPoolResourceOperation = IndyInterface.bootstrap("invoke", "getAt", 0, callSite6, Integer.valueOf(0));
            targetPoolName = IndyInterface.bootstrap("invoke", "getAt", 0, callSite6, Integer.valueOf(1));
            targetPoolResourceLink = IndyInterface.bootstrap("getProperty", "targetLink", 0, targetPoolResourceOperation);
        } else {
            targetPoolName = IndyInterface.bootstrap("getProperty", "name", 0, existingTargetPool);
            targetPoolResourceLink = IndyInterface.bootstrap("getProperty", "selfLink", 0, existingTargetPool);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, targetPoolResourceOperation) != false) {
            IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, this.googleOperationPoller, compute, project, region, IndyInterface.bootstrap("invoke", "getName", 0, targetPoolResourceOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "target pool ", IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, targetPoolResourceLink)), BASE_PHASE);
            IndyInterface.bootstrap("invoke", "deleteHttpHealthCheckIfNecessary", 2, this, existingHttpHealthCheck, needToDeleteHttpHealthCheck, compute, project);
        }
        IndyInterface.bootstrap("invoke", "updateForwardingRuleIfNecessary", 2, this, needToUpdateForwardingRule, targetPoolName, targetPoolResourceLink, region, compute, project);
        IndyInterface.bootstrap("invoke", "createNewForwardingRuleIfNecessary", 2, this, needToCreateNewForwardingRule, targetPoolName, targetPoolResourceLink, region, compute, project);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), region}, new String[]{"Done upserting load balancer ", " in ", "."}));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancers", ScriptBytecodeAdapter.createMap((Object[])new Object[]{region, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)})})});
    }

    private void updateHttpHealthCheck(HttpHealthCheck existingHttpHealthCheck, Compute compute, String project) {
        CallSite healthCheckName = IndyInterface.bootstrap("getProperty", "name", 0, existingHttpHealthCheck);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{healthCheckName}, new String[]{"Updating health check ", "..."}));
        CallSite httpHealthCheck = IndyInterface.bootstrap("invoke", "buildHttpHealthCheck", 0, GCEUtil.class, healthCheckName, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description));
        IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "update", 0, IndyInterface.bootstrap("invoke", "httpHealthChecks", 0, compute), project, healthCheckName, httpHealthCheck), "compute.httpHealthChecks.update", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
    }

    private void createNewHttpHealthCheck(List<String> httpHealthChecksResourceLinks, Compute compute, String project) {
        CallSite healthCheckName = IndyInterface.bootstrap("invoke", "format", 0, String.class, "%s-%s-%d", IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), IndyInterface.bootstrap("getProperty", "HEALTH_CHECK_NAME_PREFIX", 0, Constants.class), IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{healthCheckName}, new String[]{"Creating health check ", "..."}));
        CallSite httpHealthCheck = IndyInterface.bootstrap("invoke", "buildHttpHealthCheck", 0, GCEUtil.class, healthCheckName, IndyInterface.bootstrap("getProperty", "healthCheck", 4, this.description));
        CallSite httpHealthCheckResourceOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "httpHealthChecks", 0, compute), project, httpHealthCheck), "compute.httpHealthChecks.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
        CallSite httpHealthCheckResourceLink = IndyInterface.bootstrap("getProperty", "targetLink", 0, httpHealthCheckResourceOperation);
        IndyInterface.bootstrap("invoke", "leftShift", 0, httpHealthChecksResourceLinks, httpHealthCheckResourceLink);
        IndyInterface.bootstrap("invoke", "waitForGlobalOperation", 0, this.googleOperationPoller, compute, project, IndyInterface.bootstrap("invoke", "getName", 0, httpHealthCheckResourceOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "health check ", IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, httpHealthCheckResourceLink)), BASE_PHASE);
    }

    private void addInstancesToTargetPoolIfNecessary(String targetPoolName, Set<String> instancesToAdd, String region, Compute compute, String project) {
        if (IndyInterface.bootstrap("cast", "()", 0, instancesToAdd) != false) {
            public final class _addInstancesToTargetPoolIfNecessary_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _addInstancesToTargetPoolIfNecessary_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object instanceUrl) {
                    return IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, instanceUrl);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addInstancesToTargetPoolIfNecessary_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite instanceLocalNamesToAdd = IndyInterface.bootstrap("invoke", "collect", 0, instancesToAdd, new _addInstancesToTargetPoolIfNecessary_closure2(this, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{instanceLocalNamesToAdd}, new String[]{"Adding instances ", "..."}));
            CallSite targetPoolsAddInstanceRequest = IndyInterface.bootstrap("init", "<init>", 0, TargetPoolsAddInstanceRequest.class);
            public final class _addInstancesToTargetPoolIfNecessary_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _addInstancesToTargetPoolIfNecessary_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object instanceUrl) {
                    return IndyInterface.bootstrap("init", "<init>", 0, InstanceReference.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instance", instanceUrl}));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addInstancesToTargetPoolIfNecessary_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite = IndyInterface.bootstrap("invoke", "collect", 0, instancesToAdd, new _addInstancesToTargetPoolIfNecessary_closure3(this, this));
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)targetPoolsAddInstanceRequest, (String)"instances");
            IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "addInstance", 0, IndyInterface.bootstrap("invoke", "targetPools", 0, compute), project, region, targetPoolName, targetPoolsAddInstanceRequest), "compute.targetPools.addInstance", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region);
        }
    }

    private void removeInstancesFromTargetPoolIfNecessary(String targetPoolName, Collection instancesToRemove, String region, Compute compute, String project) {
        if (IndyInterface.bootstrap("cast", "()", 0, instancesToRemove) != false) {
            public final class _removeInstancesFromTargetPoolIfNecessary_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _removeInstancesFromTargetPoolIfNecessary_closure4(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object instanceUrl) {
                    return IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, instanceUrl);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _removeInstancesFromTargetPoolIfNecessary_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite instanceLocalNamesToRemove = IndyInterface.bootstrap("invoke", "collect", 0, instancesToRemove, new _removeInstancesFromTargetPoolIfNecessary_closure4(this, this));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{instanceLocalNamesToRemove}, new String[]{"Removing instances ", "..."}));
            CallSite targetPoolsRemoveInstanceRequest = IndyInterface.bootstrap("init", "<init>", 0, TargetPoolsRemoveInstanceRequest.class);
            public final class _removeInstancesFromTargetPoolIfNecessary_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _removeInstancesFromTargetPoolIfNecessary_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object instanceUrl) {
                    return IndyInterface.bootstrap("init", "<init>", 0, InstanceReference.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instance", instanceUrl}));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _removeInstancesFromTargetPoolIfNecessary_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite = IndyInterface.bootstrap("invoke", "collect", 0, instancesToRemove, new _removeInstancesFromTargetPoolIfNecessary_closure5(this, this));
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)targetPoolsRemoveInstanceRequest, (String)"instances");
            IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "removeInstance", 0, IndyInterface.bootstrap("invoke", "targetPools", 0, compute), project, region, targetPoolName, targetPoolsRemoveInstanceRequest), "compute.targetPools.removeInstance", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region);
        }
    }

    private Operation removeHttpHealthCheckFromTargetPool(String targetPoolName, Operation targetPoolResourceOperation, TargetPool existingTargetPool, HttpHealthCheck existingHttpHealthCheck, String region, Compute compute, String project) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, existingHttpHealthCheck)}, new String[]{"Removing health check ", "..."}));
        CallSite targetPoolsRemoveHealthCheckRequest = IndyInterface.bootstrap("init", "<init>", 0, TargetPoolsRemoveHealthCheckRequest.class);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("init", "<init>", 0, HealthCheckReference.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"healthCheck", IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "healthChecks", 0, existingTargetPool), false)}))});
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)targetPoolsRemoveHealthCheckRequest, (String)"healthChecks");
        targetPoolResourceOperation = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "removeHealthCheck", 0, IndyInterface.bootstrap("invoke", "targetPools", 0, compute), project, region, targetPoolName, targetPoolsRemoveHealthCheckRequest), "compute.targetPools.removeHealthCheck", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region));
        return targetPoolResourceOperation;
    }

    private Operation addHttpHealthCheckToTargetPool(String targetPoolName, Operation targetPoolResourceOperation, List<String> httpHealthChecksResourceLinks, String region, Compute compute, String project) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("invoke", "getAt", 0, httpHealthChecksResourceLinks, false))}, new String[]{"Adding health check ", "..."}));
        CallSite targetPoolsAddHealthCheckRequest = IndyInterface.bootstrap("init", "<init>", 0, TargetPoolsAddHealthCheckRequest.class);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("init", "<init>", 0, HealthCheckReference.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"healthCheck", IndyInterface.bootstrap("invoke", "getAt", 0, httpHealthChecksResourceLinks, false)}))});
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)targetPoolsAddHealthCheckRequest, (String)"healthChecks");
        targetPoolResourceOperation = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "addHealthCheck", 0, IndyInterface.bootstrap("invoke", "targetPools", 0, compute), project, region, targetPoolName, targetPoolsAddHealthCheckRequest), "compute.targetPools.addHealthCheck", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region));
        return targetPoolResourceOperation;
    }

    private List createNewTargetPool(String targetPoolName, Operation targetPoolResourceOperation, List<String> httpHealthChecksResourceLinks, String region, Compute compute, String project) {
        targetPoolName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "format", 0, String.class, "%s-%s-%d", IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), IndyInterface.bootstrap("getProperty", "TARGET_POOL_NAME_PREFIX", 0, GCEUtil.class), IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class)));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{targetPoolName, region}, new String[]{"Creating target pool ", " in ", "..."}));
        CallSite targetPool = IndyInterface.bootstrap("init", "<init>", 0, TargetPool.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", targetPoolName, "healthChecks", httpHealthChecksResourceLinks, "instances", IndyInterface.bootstrap("getProperty", "instances", 4, this.description), "sessionAffinity", IndyInterface.bootstrap("getProperty", "sessionAffinity", 4, this.description)}));
        targetPoolResourceOperation = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "targetPools", 0, compute), project, region, targetPool), "compute.tagetPools.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region));
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{targetPoolResourceOperation, targetPoolName});
    }

    private void deleteHttpHealthCheckIfNecessary(HttpHealthCheck existingHttpHealthCheck, boolean needToDeleteHttpHealthCheck, Compute compute, String project) {
        if (needToDeleteHttpHealthCheck) {
            CallSite healthCheckName = IndyInterface.bootstrap("getProperty", "name", 0, existingHttpHealthCheck);
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{healthCheckName}, new String[]{"Deleting health check ", "..."}));
            IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "httpHealthChecks", 0, compute), project, healthCheckName), "compute.httpHealthChecks.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this));
        }
    }

    private void updateForwardingRuleIfNecessary(boolean needToUpdateForwardingRule, String targetPoolName, String targetPoolResourceLink, String region, Compute compute, String project) {
        if (needToUpdateForwardingRule) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Deleting forwarding rule ", "..."}));
            CallSite forwardingRuleResourceOperation = IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "forwardingRules", 0, compute), project, region, IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)), "compute.forwardingRules.delete", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), region);
            CallSite forwardingRuleResourceLink = IndyInterface.bootstrap("getProperty", "targetLink", 0, forwardingRuleResourceOperation);
            IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, this.googleOperationPoller, compute, project, region, IndyInterface.bootstrap("invoke", "getName", 0, forwardingRuleResourceOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "forwarding rule ", IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, forwardingRuleResourceLink)), BASE_PHASE);
            IndyInterface.bootstrap("invoke", "createNewForwardingRuleIfNecessary", 2, this, true, targetPoolName, targetPoolResourceLink, region, compute, project);
        }
    }

    private void createNewForwardingRuleIfNecessary(boolean needToCreateNewForwardingRule, String targetPoolName, String targetPoolResourceLink, String region, Compute compute, String project) {
        Reference region2 = new Reference((Object)region);
        Reference compute2 = new Reference((Object)compute);
        Reference project2 = new Reference((Object)project);
        if (needToCreateNewForwardingRule) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Creating forwarding rule ", " to "}), new GStringImpl(new Object[]{targetPoolName, (String)region2.get()}, new String[]{"", " in ", "..."})));
            Reference forwardingRule = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, ForwardingRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description), "target", targetPoolResourceLink, "IPProtocol", IndyInterface.bootstrap("getProperty", "ipProtocol", 4, this.description), "IPAddress", IndyInterface.bootstrap("getProperty", "ipAddress", 4, this.description), "portRange", IndyInterface.bootstrap("getProperty", "portRange", 4, this.description)})));
            public final class _createNewForwardingRuleIfNecessary_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference compute;
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference forwardingRule;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _createNewForwardingRuleIfNecessary_closure6(Object _outerInstance, Object _thisObject, Reference compute, Reference project, Reference region, Reference forwardingRule) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.compute = reference4 = compute;
                    this.project = reference3 = project;
                    this.region = reference2 = region;
                    this.forwardingRule = reference = forwardingRule;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "insert", 0, IndyInterface.bootstrap("invoke", "forwardingRules", 0, IndyInterface.bootstrap("cast", "()", 0, this.compute.get())), IndyInterface.bootstrap("cast", "()", 0, this.project.get()), IndyInterface.bootstrap("cast", "()", 0, this.region.get()), this.forwardingRule.get()), "compute.forwardingRules.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_REGIONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_REGION", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.region.get()));
                }

                @Generated
                public Compute getCompute() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.compute.get());
                }

                @Generated
                public String getProject() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
                }

                @Generated
                public String getRegion() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                }

                @Generated
                public Object getForwardingRule() {
                    return this.forwardingRule.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createNewForwardingRuleIfNecessary_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Operation forwardingRuleOperation = (Operation)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "doRetry", 0, this.safeRetry, new _createNewForwardingRuleIfNecessary_closure6(this, this, compute2, project2, region2, forwardingRule), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 4, this.description)}, new String[]{"Regional forwarding rule ", ""}), IndyInterface.bootstrap("getProperty", "task", 12, this), ScriptBytecodeAdapter.createList((Object[])new Object[]{400, 403, 412}), ScriptBytecodeAdapter.createList((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", "insert", "phase", BASE_PHASE, "operation", "compute.forwardingRules.insert", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 12, this)}), IndyInterface.bootstrap("getProperty", "registry", 12, this)), Operation.class);
            IndyInterface.bootstrap("invoke", "waitForRegionalOperation", 0, this.googleOperationPoller, (Compute)compute2.get(), (String)project2.get(), (String)region2.get(), IndyInterface.bootstrap("invoke", "getName", 0, forwardingRuleOperation), null, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, "forwarding rule ", IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, targetPoolResourceLink)), BASE_PHASE);
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertGoogleLoadBalancerAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public SafeRetry getSafeRetry() {
        return this.safeRetry;
    }

    @Generated
    public @VisibleForTesting void setSafeRetry(SafeRetry safeRetry) {
        this.safeRetry = safeRetry;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

