/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.deploy.ops.snapshot;

import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.AttachedDiskInitializeParams;
import com.google.api.services.compute.model.InstanceProperties;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.ServiceAccount;
import com.google.api.services.compute.model.ShieldedVmConfig;
import com.google.api.services.compute.model.Tags;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.google.deploy.description.snapshot.SaveSnapshotDescription;
import com.netflix.spinnaker.clouddriver.google.deploy.exception.GoogleResourceIllegalStateException;
import com.netflix.spinnaker.clouddriver.google.model.GoogleAutoscalingPolicy;
import com.netflix.spinnaker.clouddriver.google.model.GoogleCluster;
import com.netflix.spinnaker.clouddriver.google.model.GoogleHealthCheck;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSecurityGroup;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancerView;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleLoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSecurityGroupProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.model.securitygroups.IpRangeRule;
import com.netflix.spinnaker.clouddriver.model.securitygroups.Rule;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class SaveSnapshotAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    private static final String BASE_PHASE = "SAVE_SNAPSHOT";
    private final SaveSnapshotDescription description;
    private GoogleNamedAccountCredentials credentials;
    private final String applicationName;
    private final String accountName;
    private String project;
    private List applicationTags;
    private int numInstanceGroupManagers;
    private int numInstanceTemplates;
    private int numTargetPools;
    private int numForwardingRules;
    private int numHealthChecks;
    private int numAutoscalers;
    private int numFirewalls;
    @Autowired
    private GoogleClusterProvider googleClusterProvider;
    @Autowired
    private GoogleLoadBalancerProvider googleLoadBalancerProvider;
    @Autowired
    private GoogleSecurityGroupProvider googleSecurityGroupProvider;
    @Autowired
    private AccountCredentialsRepository accountCredentialsRepository;
    @Autowired
    private Front50Service front50Service;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public SaveSnapshotAtomicOperation(SaveSnapshotDescription description) {
        List list;
        SaveSnapshotDescription saveSnapshotDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = saveSnapshotDescription = description;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "applicationName", 4, description);
        this.applicationName = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "accountName", 4, description);
        this.accountName = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        this.applicationTags = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        GoogleNamedAccountCredentials googleNamedAccountCredentials;
        this.credentials = googleNamedAccountCredentials = (GoogleNamedAccountCredentials)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getOne", 0, this.accountCredentialsRepository, this.accountName), GoogleNamedAccountCredentials.class));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "project", 4, this.credentials);
        this.project = IndyInterface.bootstrap("cast", "()", 0, callSite);
        Reference resourceMap = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        IndyInterface.bootstrap("invoke", "initializeResourceMap", 2, this, resourceMap.get());
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"Serializing server groups for the application ", " in account ", ""}));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject, Reference resourceMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.resourceMap = reference = resourceMap;
            }

            public Object doCall(GoogleCluster.View cluster) {
                public final class _closure14
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference resourceMap;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure14(Object _outerInstance, Object _thisObject, Reference resourceMap) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.resourceMap = reference = resourceMap;
                    }

                    public Object doCall(GoogleServerGroup.View serverGroup) {
                        return IndyInterface.bootstrap("invoke", "addServerGroupToResourceMap", 2, this, serverGroup, this.resourceMap.get());
                    }

                    @Generated
                    public Object call(GoogleServerGroup.View serverGroup) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, serverGroup);
                    }

                    @Generated
                    public Object getResourceMap() {
                        return this.resourceMap.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure14.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "serverGroups", 4, cluster), new _closure14((Object)this, this.getThisObject(), this.resourceMap));
            }

            @Generated
            public Object call(GoogleCluster.View cluster) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, cluster);
            }

            @Generated
            public Object getResourceMap() {
                return this.resourceMap.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getClusters", 0, this.googleClusterProvider, this.applicationName, this.accountName), new _operate_closure1(this, this, resourceMap));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"Serializing load balancers for the application ", " in account ", ""}));
        public final class _operate_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure2(Object _outerInstance, Object _thisObject, Reference resourceMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.resourceMap = reference = resourceMap;
            }

            public Object doCall(GoogleLoadBalancerView loadBalancer) {
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "account", 4, loadBalancer), (Object)IndyInterface.bootstrap("getProperty", "accountName", 4, this.getThisObject()))) {
                    return IndyInterface.bootstrap("invoke", "addLoadBalancerToResourceMap", 2, this, loadBalancer, this.resourceMap.get());
                }
                return null;
            }

            @Generated
            public Object call(GoogleLoadBalancerView loadBalancer) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, loadBalancer);
            }

            @Generated
            public Object getResourceMap() {
                return this.resourceMap.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getApplicationLoadBalancers", 0, this.googleLoadBalancerProvider, this.applicationName), new _operate_closure2(this, this, resourceMap));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{this.applicationName, this.accountName}, new String[]{"Serializing security groups for application ", " in account ", ""}));
        public final class _operate_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference resourceMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure3(Object _outerInstance, Object _thisObject, Reference resourceMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.resourceMap = reference = resourceMap;
            }

            public Object doCall(GoogleSecurityGroup securityGroup) {
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "accountName", 4, securityGroup), (Object)IndyInterface.bootstrap("getProperty", "accountName", 4, this.getThisObject())) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "targetTags", 4, securityGroup)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "disjoint", 0, Collections.class, IndyInterface.bootstrap("getProperty", "targetTags", 4, securityGroup), IndyInterface.bootstrap("getProperty", "applicationTags", 12, this))) == false) {
                    return IndyInterface.bootstrap("invoke", "addSecurityGroupToResourceMap", 2, this, securityGroup, this.resourceMap.get());
                }
                return null;
            }

            @Generated
            public Object call(GoogleSecurityGroup securityGroup) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, securityGroup);
            }

            @Generated
            public Object getResourceMap() {
                return this.resourceMap.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.googleSecurityGroupProvider, true), new _operate_closure3(this, this, resourceMap));
        IndyInterface.bootstrap("invoke", "cleanUpResourceMap", 2, this, resourceMap.get());
        Map snapshot = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"application", this.applicationName, "account", this.accountName, "infrastructure", resourceMap.get(), "configLang", "TERRAFORM"});
        IndyInterface.bootstrap("invoke", "saveSnapshot", 0, this.front50Service, snapshot);
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void initializeResourceMap(Map resourceMap) {
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)resourceMap, (String)"google_compute_instance_group_manager");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map2, null, (Object)resourceMap, (String)"google_compute_instance_template");
        Map map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map3, null, (Object)resourceMap, (String)"google_compute_target_pool");
        Map map4 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map4, null, (Object)resourceMap, (String)"google_compute_forwarding_rule");
        Map map5 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map5, null, (Object)resourceMap, (String)"google_compute_http_health_check");
        Map map6 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map6, null, (Object)resourceMap, (String)"google_compute_autoscaler");
        Map map7 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map7, null, (Object)resourceMap, (String)"google_compute_firewall");
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void cleanUpResourceMap(Map resourceMap) {
        if (this.numInstanceGroupManagers == 0) {
            IndyInterface.bootstrap("invoke", "remove", 0, resourceMap, "google_compute_instance_group_manager");
        }
        if (this.numInstanceTemplates == 0) {
            IndyInterface.bootstrap("invoke", "remove", 0, resourceMap, "google_compute_instance_template");
        }
        if (this.numTargetPools == 0) {
            IndyInterface.bootstrap("invoke", "remove", 0, resourceMap, "google_compute_target_pool");
        }
        if (this.numForwardingRules == 0) {
            IndyInterface.bootstrap("invoke", "remove", 0, resourceMap, "google_compute_forwarding_rule");
        }
        if (this.numHealthChecks == 0) {
            IndyInterface.bootstrap("invoke", "remove", 0, resourceMap, "google_compute_http_health_check");
        }
        if (this.numAutoscalers == 0) {
            IndyInterface.bootstrap("invoke", "remove", 0, resourceMap, "google_compute_autoscaler");
        }
        if (this.numFirewalls == 0) {
            IndyInterface.bootstrap("invoke", "remove", 0, resourceMap, "google_compute_firewall");
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void addServerGroupToResourceMap(GoogleServerGroup.View serverGroup, Map resourceMap) {
        Reference serverGroupMap = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 4, serverGroup)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, "Required server group name not found"));
        }
        CallSite callSite = IndyInterface.bootstrap("getProperty", "name", 4, serverGroup);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)serverGroupMap.get(), (String)"name");
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "name", 4, serverGroup);
        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)serverGroupMap.get(), (String)"base_instance_name");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "zone", 4, serverGroup)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, serverGroup)}, new String[]{"Required zone not found for server group: ", ""})));
        }
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "zone", 4, serverGroup);
        ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)serverGroupMap.get(), (String)"zone");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "image", 0, IndyInterface.bootstrap("getProperty", "imageSummary", 4, serverGroup))) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, serverGroup)}, new String[]{"Required instance template not found for server group: ", ""})));
        }
        CallSite instanceTemplateMap = IndyInterface.bootstrap("getProperty", "image", 0, IndyInterface.bootstrap("getProperty", "imageSummary", 4, serverGroup));
        CallSite instanceTemplate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertMapToInstanceTemplate", 2, this, instanceTemplateMap));
        IndyInterface.bootstrap("invoke", "addInstanceTemplateToResourceMap", 2, this, instanceTemplate, resourceMap);
        CallSite callSite4 = IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate)}, new String[]{"${google_compute_instance_template.", ".self_link}"}));
        ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)serverGroupMap.get(), (String)"instance_template");
        String string = this.project;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)serverGroupMap.get(), (String)"project");
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)serverGroupMap.get(), (String)"target_pools");
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "loadBalancers", 4, serverGroup)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 4, serverGroup))) == false) {
            public final class _addServerGroupToResourceMap_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroupMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _addServerGroupToResourceMap_closure4(Object _outerInstance, Object _thisObject, Reference serverGroupMap) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.serverGroupMap = reference = serverGroupMap;
                }

                public Object doCall(String loadBalancer) {
                    CallSite target_pool = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "${google_compute_target_pool.", loadBalancer), ".self_link}");
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "target_pools", 0, this.serverGroupMap.get()), target_pool);
                }

                @Generated
                public Object call(String loadBalancer) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, loadBalancer);
                }

                @Generated
                public Object getServerGroupMap() {
                    return this.serverGroupMap.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addServerGroupToResourceMap_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 4, serverGroup), new _addServerGroupToResourceMap_closure4(this, this, serverGroupMap));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 4, serverGroup)) != false) {
            IndyInterface.bootstrap("invoke", "addAutoscalerToResourceMap", 2, this, IndyInterface.bootstrap("getProperty", "name", 4, serverGroup), IndyInterface.bootstrap("getProperty", "zone", 4, serverGroup), IndyInterface.bootstrap("getProperty", "autoscalingPolicy", 4, serverGroup), resourceMap);
        } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "total", 1, IndyInterface.bootstrap("getProperty", "instanceCounts", 4, serverGroup))) != false) {
            CallSite callSite5 = IndyInterface.bootstrap("getProperty", "total", 0, IndyInterface.bootstrap("getProperty", "instanceCounts", 4, serverGroup));
            ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)serverGroupMap.get(), (String)"target_size");
        }
        int n = this.numInstanceGroupManagers;
        this.numInstanceGroupManagers = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        Object object = serverGroupMap.get();
        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "google_compute_instance_group_manager", 0, resourceMap), IndyInterface.bootstrap("getProperty", "name", 4, serverGroup), object);
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void addInstanceTemplateToResourceMap(InstanceTemplate instanceTemplate, Map resourceMap) {
        Reference instanceTemplateMap = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, "Required instance template name not found"));
        }
        CallSite callSite = IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)instanceTemplateMap.get(), (String)"name");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "machineType", 1, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate))) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate)}, new String[]{"Required machine type not found for instance template: ", ""})));
        }
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "machineType", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate));
        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)instanceTemplateMap.get(), (String)"machine_type");
        String string = this.project;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)instanceTemplateMap.get(), (String)"project");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "canIpForward", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)), null)) {
            CallSite callSite3 = IndyInterface.bootstrap("getProperty", "canIpForward", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate));
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)instanceTemplateMap.get(), (String)"can_ip_forward");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "description", 0, instanceTemplate)) != false) {
            CallSite callSite4 = IndyInterface.bootstrap("getProperty", "description", 0, instanceTemplate);
            ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)instanceTemplateMap.get(), (String)"description");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "description", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate))) != false) {
            CallSite callSite5 = IndyInterface.bootstrap("getProperty", "description", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate));
            ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)instanceTemplateMap.get(), (String)"instance_description");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "items", 1, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)))) != false) {
            CallSite callSite6 = IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)));
            ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)instanceTemplateMap.get(), (String)"tags");
            IndyInterface.bootstrap("invoke", "addAll", 0, this.applicationTags, IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate))));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "addDisksToInstanceTemplateMap", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "disks", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)), List.class))), List.class), instanceTemplateMap.get())) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate)}, new String[]{"No properly formatted disks found for instance template: ", ""})));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "networkInterfaces", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate))) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "networkInterfaces", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)))) == false) {
            IndyInterface.bootstrap("invoke", "addNetworkInterfacesToInstanceTemplateMap", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "networkInterfaces", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)), List.class))), List.class), instanceTemplateMap.get());
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "scheduling", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate))) != false) {
            IndyInterface.bootstrap("invoke", "addSchedulingToInstanceTemplateMap", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((Scheduling)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "scheduling", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)), Scheduling.class)), Scheduling.class), instanceTemplateMap.get());
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "serviceAccounts", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)), null) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "serviceAccounts", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)))) == false) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)instanceTemplateMap.get(), (String)"service_account");
            List serviceAccounts = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "serviceAccounts", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)), List.class));
            CallSite callSite7 = IndyInterface.bootstrap("invoke", "getScopes", 0, IndyInterface.bootstrap("invoke", "getAt", 0, serviceAccounts, false));
            ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)IndyInterface.bootstrap("getProperty", "service_account", 0, instanceTemplateMap.get()), (String)"scopes");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "metadata", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate))) != false) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)instanceTemplateMap.get(), (String)"metadata");
            IndyInterface.bootstrap("invoke", "getItems", 0, IndyInterface.bootstrap("invoke", "getMetadata", 0, IndyInterface.bootstrap("invoke", "getProperties", 0, instanceTemplate)));
            ArrayList items = (ArrayList)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("getProperty", "metadata", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate))), ArrayList.class));
            public final class _addInstanceTemplateToResourceMap_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference instanceTemplateMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _addInstanceTemplateToResourceMap_closure5(Object _outerInstance, Object _thisObject, Reference instanceTemplateMap) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.instanceTemplateMap = reference = instanceTemplateMap;
                }

                public Object doCall(Map item) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "value", 0, item);
                    IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "metadata", 0, this.instanceTemplateMap.get()), IndyInterface.bootstrap("getProperty", "key", 0, item), callSite);
                    return callSite;
                }

                @Generated
                public Object call(Map item) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, item);
                }

                @Generated
                public Object getInstanceTemplateMap() {
                    return this.instanceTemplateMap.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addInstanceTemplateToResourceMap_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, items, new _addInstanceTemplateToResourceMap_closure5(this, this, instanceTemplateMap));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "shieldedVmConfig", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate))) != false) {
            IndyInterface.bootstrap("invoke", "addShieldedVmConfigToInstanceTemplateMap", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((ShieldedVmConfig)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "shieldedVmConfig", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplate)), ShieldedVmConfig.class)), ShieldedVmConfig.class), instanceTemplateMap.get());
        }
        int n = this.numInstanceTemplates;
        this.numInstanceTemplates = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        Object object = instanceTemplateMap.get();
        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "google_compute_instance_template", 0, resourceMap), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplate), String.class))), String.class), object);
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void addSchedulingToInstanceTemplateMap(Scheduling scheduling, Map instanceTemplateMap) {
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)instanceTemplateMap, (String)"scheduling");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "automaticRestart", 0, scheduling), null)) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "automaticRestart", 0, scheduling);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "scheduling", 0, instanceTemplateMap), (String)"automatic_restart");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "onHostMaintenance", 0, scheduling)) != false) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "onHostMaintenance", 0, scheduling);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "scheduling", 0, instanceTemplateMap), (String)"on_host_maintenance");
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "preemptible", 0, scheduling), null)) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "preemptible", 0, scheduling);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "scheduling", 0, instanceTemplateMap), (String)"preemptible");
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void addShieldedVmConfigToInstanceTemplateMap(ShieldedVmConfig shieldedVmConfig, Map instanceTemplateMap) {
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)instanceTemplateMap, (String)"shielded_vm_config");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "enableSecureBoot", 0, shieldedVmConfig), null)) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "enableSecureBoot", 0, shieldedVmConfig);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "shielded_vm_config", 0, instanceTemplateMap), (String)"enable_secure_boot");
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "enableVtpm", 0, shieldedVmConfig), null)) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "enableVtpm", 0, shieldedVmConfig);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "shielded_vm_config", 0, instanceTemplateMap), (String)"enable_vtpm");
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "enableIntegrityMonitoring", 0, shieldedVmConfig), null)) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "enableIntegrityMonitoring", 0, shieldedVmConfig);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("getProperty", "shielded_vm_config", 0, instanceTemplateMap), (String)"enable_integrity_monitoring");
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void addNetworkInterfacesToInstanceTemplateMap(List<NetworkInterface> networkInterfaces, Map instanceTemplateMap) {
        Reference instanceTemplateMap2 = new Reference((Object)instanceTemplateMap);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)((Map)instanceTemplateMap2.get()), (String)"network_interface");
        public final class _addNetworkInterfacesToInstanceTemplateMap_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instanceTemplateMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addNetworkInterfacesToInstanceTemplateMap_closure6(Object _outerInstance, Object _thisObject, Reference instanceTemplateMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.instanceTemplateMap = reference = instanceTemplateMap;
            }

            public Object doCall(NetworkInterface networkInterface) {
                Reference networkInterfaceMap = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "network", 0, networkInterface)) != false) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "last", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("getProperty", "network", 0, networkInterface), "/"));
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)networkInterfaceMap.get(), (String)"network");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnetwork", 0, networkInterface)) != false) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "last", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("getProperty", "subnetwork", 0, networkInterface), "/"));
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)networkInterfaceMap.get(), (String)"subnetwork");
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "accessConfigs", 0, networkInterface), null) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "accessConfigs", 0, networkInterface))) == false) {
                    List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)networkInterfaceMap.get(), (String)"access_config");
                    public final class _closure15
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference networkInterfaceMap;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure15(Object _outerInstance, Object _thisObject, Reference networkInterfaceMap) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.networkInterfaceMap = reference = networkInterfaceMap;
                        }

                        public Object doCall(AccessConfig accessConfig) {
                            Map accessConfigMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                            CallSite callSite = IndyInterface.bootstrap("getProperty", "natIP", 0, accessConfig);
                            IndyInterface.bootstrap("invoke", "putAt", 0, accessConfigMap, "nat_ip", callSite);
                            return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "access_config", 0, this.networkInterfaceMap.get()), accessConfigMap);
                        }

                        @Generated
                        public Object call(AccessConfig accessConfig) {
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, accessConfig);
                        }

                        @Generated
                        public Object getNetworkInterfaceMap() {
                            return this.networkInterfaceMap.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure15.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "accessConfigs", 0, networkInterface), new _closure15((Object)this, this.getThisObject(), networkInterfaceMap));
                } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "accessConfigs", 0, networkInterface))) != false) {
                    List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)networkInterfaceMap.get(), (String)"access_config");
                    Map accessConfigMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                    String string = "";
                    IndyInterface.bootstrap("invoke", "putAt", 0, accessConfigMap, "nat_ip", string);
                    IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "access_config", 0, networkInterfaceMap.get()), accessConfigMap);
                }
                return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "network_interface", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceTemplateMap.get())), networkInterfaceMap.get());
            }

            @Generated
            public Object call(NetworkInterface networkInterface) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, networkInterface);
            }

            @Generated
            public Map getInstanceTemplateMap() {
                return IndyInterface.bootstrap("cast", "()", 0, this.instanceTemplateMap.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addNetworkInterfacesToInstanceTemplateMap_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, networkInterfaces, new _addNetworkInterfacesToInstanceTemplateMap_closure6(this, this, instanceTemplateMap2));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Boolean addDisksToInstanceTemplateMap(List<AttachedDisk> disks, Map instanceTemplateMap) {
        Reference instanceTemplateMap2 = new Reference((Object)instanceTemplateMap);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)((Map)instanceTemplateMap2.get()), (String)"disk");
        Reference numDisks = new Reference((Object)0);
        public final class _addDisksToInstanceTemplateMap_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instanceTemplateMap;
            private /* synthetic */ Reference numDisks;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addDisksToInstanceTemplateMap_closure7(Object _outerInstance, Object _thisObject, Reference instanceTemplateMap, Reference numDisks) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.instanceTemplateMap = reference2 = instanceTemplateMap;
                this.numDisks = reference = numDisks;
            }

            public Object doCall(AttachedDisk disk) {
                Map diskMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "source", 0, disk)) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "sourceImage", 1, IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk))) == false) {
                    return false;
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "autoDelete", 0, disk), null)) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "autoDelete", 0, disk);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"auto_delete");
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "boot", 0, disk), null)) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "boot", 0, disk);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"boot");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "deviceName", 0, disk)) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "deviceName", 0, disk);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"device_name");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "diskName", 1, IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk))) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "diskName", 0, IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk));
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"name");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "sourceImage", 1, IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk))) != false) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "last", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("getProperty", "sourceImage", 0, IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk)), "/"));
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"source_image");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "source", 0, disk)) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "source", 0, disk);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"source");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "interface", 0, disk)) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "interface", 0, disk);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"interface");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "mode", 0, disk)) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "mode", 0, disk);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"mode");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "diskType", 1, IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk))) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "diskType", 1, IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk));
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"disk_type");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "diskSizeGb", 1, IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk))) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "diskSizeGb", 1, IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk));
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"disk_size_gb");
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "type", 0, disk)) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "type", 0, disk);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)diskMap, (String)"type");
                }
                IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "disk", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceTemplateMap.get())), diskMap);
                Object object = this.numDisks.get();
                this.numDisks.set((Object)IndyInterface.bootstrap("invoke", "next", 0, object));
                return object;
            }

            @Generated
            public Object call(AttachedDisk disk) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, disk);
            }

            @Generated
            public Map getInstanceTemplateMap() {
                return IndyInterface.bootstrap("cast", "()", 0, this.instanceTemplateMap.get());
            }

            @Generated
            public Object getNumDisks() {
                return this.numDisks.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addDisksToInstanceTemplateMap_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, disks, new _addDisksToInstanceTemplateMap_closure7(this, this, instanceTemplateMap2, numDisks));
        return ScriptBytecodeAdapter.compareGreaterThan((Object)numDisks.get(), (Object)0);
    }

    private Void addAutoscalerToResourceMap(String targetName, String targetZone, GoogleAutoscalingPolicy autoscalingPolicy, Map resourceMap) {
        Reference autoscalerMap = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        String string = targetName;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)autoscalerMap.get(), (String)"name");
        CallSite callSite = IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{targetName}, new String[]{"${google_compute_instance_group_manager.", ".self_link}"}));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)autoscalerMap.get(), (String)"target");
        String string2 = targetZone;
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)autoscalerMap.get(), (String)"zone");
        String string3 = this.project;
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)autoscalerMap.get(), (String)"project");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)autoscalerMap.get(), (String)"autoscaling_policy");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "maxNumReplicas", 4, autoscalingPolicy)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, autoscalerMap.get())}, new String[]{"Required maximum number of replicas not found for autoscaler: ", ""})));
        }
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "maxNumReplicas", 4, autoscalingPolicy);
        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get()), (String)"max_replicas");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "minNumReplicas", 4, autoscalingPolicy)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, autoscalerMap.get())}, new String[]{"Required minimum number of replicas not found for autoscaler: ", ""})));
        }
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "minNumReplicas", 4, autoscalingPolicy);
        ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get()), (String)"min_replicas");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "coolDownPeriodSec", 4, autoscalingPolicy)) != false) {
            CallSite callSite4 = IndyInterface.bootstrap("getProperty", "coolDownPeriodSec", 4, autoscalingPolicy);
            ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get()), (String)"cooldown_period");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "utilizationTarget", 1, IndyInterface.bootstrap("getProperty", "cpuUtilization", 4, autoscalingPolicy))) != false) {
            Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)map2, null, (Object)IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get()), (String)"cpu_utilization");
            CallSite callSite5 = IndyInterface.bootstrap("getProperty", "utilizationTarget", 0, IndyInterface.bootstrap("getProperty", "cpuUtilization", 4, autoscalingPolicy));
            ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)IndyInterface.bootstrap("getProperty", "cpu_utilization", 0, IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get())), (String)"target");
            CallSite callSite6 = IndyInterface.bootstrap("getProperty", "predictiveMethod", 0, IndyInterface.bootstrap("getProperty", "cpuUtilization", 4, autoscalingPolicy));
            if (ScriptBytecodeAdapter.isCase((Object)callSite6, (Object)"NONE")) {
                String string4 = "none";
                ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)IndyInterface.bootstrap("getProperty", "cpu_utilization", 0, IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get())), (String)"predictive_method");
            } else if (ScriptBytecodeAdapter.isCase((Object)callSite6, (Object)"OPTIMIZE_AVAILABILITY")) {
                String string5 = "optimize_availability";
                ScriptBytecodeAdapter.setProperty((Object)string5, null, (Object)IndyInterface.bootstrap("getProperty", "cpu_utilization", 0, IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get())), (String)"predictive_method");
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "customMetricUtilizations", 4, autoscalingPolicy)) != false) {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get()), (String)"metric");
            public final class _addAutoscalerToResourceMap_closure8
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference autoscalerMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _addAutoscalerToResourceMap_closure8(Object _outerInstance, Object _thisObject, Reference autoscalerMap) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.autoscalerMap = reference = autoscalerMap;
                }

                public Object doCall(Map metric) {
                    CallSite callSite;
                    Map metricMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "metric", 0, metric)) == false) {
                        return null;
                    }
                    CallSite callSite2 = IndyInterface.bootstrap("getProperty", "metric", 0, metric);
                    ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)metricMap, (String)"name");
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "utilizationTarget", 0, metric)) == false) {
                        return null;
                    }
                    CallSite callSite3 = IndyInterface.bootstrap("getProperty", "utilizationTarget", 0, metric);
                    ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)metricMap, (String)"target");
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "filter", 0, metric)) != false) {
                        CallSite callSite4 = IndyInterface.bootstrap("getProperty", "filter", 0, metric);
                        ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)metricMap, (String)"filter");
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "singleInstanceAssignment", 0, metric)) != false) {
                        CallSite callSite5 = IndyInterface.bootstrap("getProperty", "singleInstanceAssignment", 0, metric);
                        ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)metricMap, (String)"single_instance_assignment");
                    }
                    if (ScriptBytecodeAdapter.isCase((Object)(callSite = IndyInterface.bootstrap("getProperty", "utilizationTargetType", 0, metric)), (Object)"GAUGE")) {
                        String string = "gauge";
                        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)metricMap, (String)"type");
                    } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"DELTA PER SECOND")) {
                        String string = "delta";
                        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)metricMap, (String)"type");
                    } else if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"DELTA PER MINUTE")) {
                        String string = "cumulative";
                        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)metricMap, (String)"type");
                    } else {
                        String string = "gauge";
                        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)metricMap, (String)"type");
                    }
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "metric", 0, IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, this.autoscalerMap.get())), metricMap);
                }

                @Generated
                public Object call(Map metric) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, metric);
                }

                @Generated
                public Object getAutoscalerMap() {
                    return this.autoscalerMap.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addAutoscalerToResourceMap_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "customMetricUtilizations", 4, autoscalingPolicy), new _addAutoscalerToResourceMap_closure8(this, this, autoscalerMap));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "scalingSchedules", 4, autoscalingPolicy)) != false) {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get()), (String)"scalingSchedules");
            public final class _addAutoscalerToResourceMap_closure9
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference autoscalerMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _addAutoscalerToResourceMap_closure9(Object _outerInstance, Object _thisObject, Reference autoscalerMap) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.autoscalerMap = reference = autoscalerMap;
                }

                public Object doCall(Map scalingSchedule) {
                    Map scalingScheduleMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "scalingSchedule", 0, scalingSchedule)) != false) {
                        CallSite callSite = IndyInterface.bootstrap("getProperty", "scalingSchedule", 0, scalingSchedule);
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)scalingScheduleMap, (String)"name");
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "description", 0, scalingSchedule)) != false) {
                        CallSite callSite = IndyInterface.bootstrap("getProperty", "description", 0, scalingSchedule);
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)scalingScheduleMap, (String)"description");
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "disabled", 0, scalingSchedule)) != false) {
                        CallSite callSite = IndyInterface.bootstrap("getProperty", "disabled", 0, scalingSchedule);
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)scalingScheduleMap, (String)"disabled");
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "durationSec", 0, scalingSchedule)) != false) {
                        CallSite callSite = IndyInterface.bootstrap("getProperty", "durationSec", 0, scalingSchedule);
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)scalingScheduleMap, (String)"duration_sec");
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "minRequiredReplicas", 0, scalingSchedule)) != false) {
                        CallSite callSite = IndyInterface.bootstrap("getProperty", "minRequiredReplicas", 0, scalingSchedule);
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)scalingScheduleMap, (String)"min_required_replicas");
                    }
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "timeZone", 0, scalingSchedule)) != false) {
                        CallSite callSite = IndyInterface.bootstrap("getProperty", "timeZone", 0, scalingSchedule);
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)scalingScheduleMap, (String)"time_zone");
                    }
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "scalingSchedules", 0, IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, this.autoscalerMap.get())), scalingScheduleMap);
                }

                @Generated
                public Object call(Map scalingSchedule) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, scalingSchedule);
                }

                @Generated
                public Object getAutoscalerMap() {
                    return this.autoscalerMap.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _addAutoscalerToResourceMap_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "scalingSchedules", 4, autoscalingPolicy), new _addAutoscalerToResourceMap_closure9(this, this, autoscalerMap));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "utilizationTarget", 1, IndyInterface.bootstrap("getProperty", "loadBalancingUtilization", 4, autoscalingPolicy))) != false) {
            Map map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)map3, null, (Object)IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get()), (String)"load_balancing_utilization");
            CallSite callSite7 = IndyInterface.bootstrap("getProperty", "utilizationTarget", 0, IndyInterface.bootstrap("getProperty", "loadBalancingUtilization", 4, autoscalingPolicy));
            ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)IndyInterface.bootstrap("getProperty", "load_balancing_utilization", 0, IndyInterface.bootstrap("getProperty", "autoscaling_policy", 0, autoscalerMap.get())), (String)"target");
        }
        int n = this.numAutoscalers;
        this.numAutoscalers = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        Object object = autoscalerMap.get();
        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "google_compute_autoscaler", 0, resourceMap), targetName, object);
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void addLoadBalancerToResourceMap(GoogleLoadBalancerView loadBalancer, Map resourceMap) {
        Map targetPoolMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Map forwardingRuleMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, "Required name not found for load balancer"));
        }
        CallSite callSite = IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)forwardingRuleMap, (String)"name");
        String string = this.project;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)forwardingRuleMap, (String)"project");
        String string2 = this.project;
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)targetPoolMap, (String)"project");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ipProtocol", 4, loadBalancer)) != false) {
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "ipProtocol", 4, loadBalancer);
            ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)forwardingRuleMap, (String)"ip_protocol");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "portRange", 4, loadBalancer)) != false) {
            CallSite callSite3 = IndyInterface.bootstrap("getProperty", "portRange", 4, loadBalancer);
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)forwardingRuleMap, (String)"port_range");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "region", 4, loadBalancer)) != false) {
            CallSite callSite4 = IndyInterface.bootstrap("getProperty", "region", 4, loadBalancer);
            ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)forwardingRuleMap, (String)"region");
            CallSite callSite5 = IndyInterface.bootstrap("getProperty", "region", 4, loadBalancer);
            ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)targetPoolMap, (String)"region");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "targetPool", 4, loadBalancer)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer)}, new String[]{"Required target pool name not found for load balancer: ", ""})));
        }
        CallSite callSite6 = IndyInterface.bootstrap("invoke", "last", 0, IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("getProperty", "targetPool", 4, loadBalancer), "/"));
        ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)targetPoolMap, (String)"name");
        CallSite callSite7 = IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer)}, new String[]{"${google_compute_target_pool.", ".self_link}"}));
        ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)forwardingRuleMap, (String)"target");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, loadBalancer)) != false) {
            IndyInterface.bootstrap("invoke", "addHealthCheckToResourceMap", 2, this, IndyInterface.bootstrap("getProperty", "healthCheck", 4, loadBalancer), resourceMap);
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "healthCheck", 4, loadBalancer))}, new String[]{"${google_compute_http_health_check.", ".name}"}))});
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)targetPoolMap, (String)"health_checks");
        }
        int n = this.numTargetPools;
        this.numTargetPools = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        int n2 = this.numForwardingRules;
        this.numForwardingRules = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n2));
        Map map = targetPoolMap;
        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "google_compute_target_pool", 0, resourceMap), IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer), map);
        Map map2 = forwardingRuleMap;
        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "google_compute_forwarding_rule", 0, resourceMap), IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer), map2);
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void addHealthCheckToResourceMap(GoogleHealthCheck.View healthCheck, Map resourceMap) {
        Map healthCheckMap = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 4, healthCheck)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, "Required health check name not found"));
        }
        CallSite callSite = IndyInterface.bootstrap("getProperty", "name", 4, healthCheck);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)healthCheckMap, (String)"name");
        String string = this.project;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)healthCheckMap, (String)"project");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "interval", 4, healthCheck)) != false) {
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "interval", 4, healthCheck);
            ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)healthCheckMap, (String)"check_interval_sec");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "healthyThreshold", 4, healthCheck)) != false) {
            CallSite callSite3 = IndyInterface.bootstrap("getProperty", "healthyThreshold", 4, healthCheck);
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)healthCheckMap, (String)"healthy_threshold");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "port", 4, healthCheck)) != false) {
            CallSite callSite4 = IndyInterface.bootstrap("getProperty", "port", 4, healthCheck);
            ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)healthCheckMap, (String)"port");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "requestPath", 4, healthCheck)) != false) {
            CallSite callSite5 = IndyInterface.bootstrap("getProperty", "requestPath", 4, healthCheck);
            ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)healthCheckMap, (String)"request_path");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "timeout", 4, healthCheck)) != false) {
            CallSite callSite6 = IndyInterface.bootstrap("getProperty", "timeout", 4, healthCheck);
            ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)healthCheckMap, (String)"timeout_sec");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "unhealthyThreshold", 4, healthCheck)) != false) {
            CallSite callSite7 = IndyInterface.bootstrap("getProperty", "unhealthyThreshold", 4, healthCheck);
            ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)healthCheckMap, (String)"unhealthy_threshold");
        }
        int n = this.numHealthChecks;
        this.numHealthChecks = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        Map map = healthCheckMap;
        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "google_compute_http_health_check", 0, resourceMap), IndyInterface.bootstrap("getProperty", "name", 4, healthCheck), map);
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Void addSecurityGroupToResourceMap(GoogleSecurityGroup securityGroup, Map resourceMap) {
        Reference firewallMap = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 4, securityGroup)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, "Required security group name not found for a resource within the scope of serialization"));
        }
        CallSite callSite = IndyInterface.bootstrap("getProperty", "name", 4, securityGroup);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)firewallMap.get(), (String)"name");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "network", 4, securityGroup)) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "network", 4, securityGroup)}, new String[]{"Required network name not found for security group: ", ""})));
        }
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "network", 4, securityGroup);
        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)firewallMap.get(), (String)"network");
        String string = this.project;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)firewallMap.get(), (String)"project");
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)firewallMap.get(), (String)"allow");
        List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)list2, null, (Object)firewallMap.get(), (String)"source_ranges");
        if (!(DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "inboundRules", 4, securityGroup)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "inboundRules", 4, securityGroup))) == false)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, GoogleResourceIllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "network", 4, securityGroup)}, new String[]{"At least one rule is required for security group: ", ""})));
        }
        public final class _addSecurityGroupToResourceMap_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference firewallMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addSecurityGroupToResourceMap_closure10(Object _outerInstance, Object _thisObject, Reference firewallMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.firewallMap = reference = firewallMap;
            }

            public Object doCall(IpRangeRule rule) {
                Reference allow = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "range", 4, rule)) != false) {
                    IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "source_ranges", 0, this.firewallMap.get()), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "ip", 0, IndyInterface.bootstrap("getProperty", "range", 4, rule)), IndyInterface.bootstrap("getProperty", "cidr", 0, IndyInterface.bootstrap("getProperty", "range", 4, rule))));
                }
                CallSite callSite = IndyInterface.bootstrap("getProperty", "protocol", 4, rule);
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)allow.get(), (String)"protocol");
                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "portRanges", 4, rule)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "portRanges", 4, rule))) == false) {
                    List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)allow.get(), (String)"ports");
                    public final class _closure16
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference allow;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure16(Object _outerInstance, Object _thisObject, Reference allow) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.allow = reference = allow;
                        }

                        public Object doCall(Rule.PortRange range) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "startPort", 0, range), (Object)IndyInterface.bootstrap("getProperty", "endPort", 0, range)) ? IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "ports", 0, this.allow.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "startPort", 0, range)}, new String[]{"", ""}))) : IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "ports", 0, this.allow.get()), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "startPort", 0, range), IndyInterface.bootstrap("getProperty", "endPort", 0, range)}, new String[]{"", "-", ""})));
                        }

                        @Generated
                        public Object call(Rule.PortRange range) {
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, range);
                        }

                        @Generated
                        public Object getAllow() {
                            return this.allow.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure16.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "portRanges", 4, rule), new _closure16((Object)this, this.getThisObject(), allow));
                }
                return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "allow", 0, this.firewallMap.get()), allow.get());
            }

            @Generated
            public Object call(IpRangeRule rule) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, rule);
            }

            @Generated
            public Object getFirewallMap() {
                return this.firewallMap.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addSecurityGroupToResourceMap_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "inboundRules", 4, securityGroup), new _addSecurityGroupToResourceMap_closure10(this, this, firewallMap));
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "targetTags", 4, securityGroup)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "targetTags", 4, securityGroup))) == false) {
            CallSite callSite3 = IndyInterface.bootstrap("getProperty", "targetTags", 4, securityGroup);
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)firewallMap.get(), (String)"target_tags");
        }
        int n = this.numFirewalls;
        this.numFirewalls = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
        Object object = firewallMap.get();
        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "google_compute_firewall", 0, resourceMap), IndyInterface.bootstrap("getProperty", "name", 4, securityGroup), object);
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private InstanceTemplate convertMapToInstanceTemplate(Map instanceTemplateMap) {
        CallSite instanceTemplate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, InstanceTemplate.class));
        String string = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "creationTimestamp", 0, instanceTemplateMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)instanceTemplate, (String)"creationTimestamp");
        String string2 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "description", 0, instanceTemplateMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)instanceTemplate, (String)"description");
        BigInteger bigInteger = (BigInteger)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "id", 0, instanceTemplateMap), BigInteger.class));
        ScriptBytecodeAdapter.setProperty((Object)bigInteger, null, (Object)instanceTemplate, (String)"id");
        String string3 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "kind", 0, instanceTemplateMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)instanceTemplate, (String)"kind");
        String string4 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "name", 0, instanceTemplateMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)instanceTemplate, (String)"name");
        String string5 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "selfLink", 0, instanceTemplateMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string5, null, (Object)instanceTemplate, (String)"selfLink");
        String string6 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "sourceInstance", 0, instanceTemplateMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string6, null, (Object)instanceTemplate, (String)"sourceInstance");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplateMap)) != false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "convertMapToInstanceProperties", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "properties", 0, instanceTemplateMap), Map.class))), Map.class));
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)instanceTemplate, (String)"properties");
        }
        return instanceTemplate;
    }

    private InstanceProperties convertMapToInstanceProperties(Map instancePropertiesMap) {
        Reference instanceProperties = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, InstanceProperties.class)));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "canIpForward", 0, instancePropertiesMap), Boolean.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)((InstanceProperties)instanceProperties.get()), (String)"canIpForward");
        String string = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "machineType", 0, instancePropertiesMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)((InstanceProperties)instanceProperties.get()), (String)"machineType");
        String string2 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "description", 0, instancePropertiesMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)((InstanceProperties)instanceProperties.get()), (String)"description");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "disks", 0, instancePropertiesMap)) != false) {
            CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
            ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)((InstanceProperties)instanceProperties.get()), (String)"disks");
            List diskMapList = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "disks", 0, instancePropertiesMap), List.class));
            public final class _convertMapToInstanceProperties_closure11
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference instanceProperties;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _convertMapToInstanceProperties_closure11(Object _outerInstance, Object _thisObject, Reference instanceProperties) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.instanceProperties = reference = instanceProperties;
                }

                public Object doCall(Map diskMap) {
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "disks", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceProperties.get())), IndyInterface.bootstrap("invoke", "convertMapToAttachedDisk", 2, this, diskMap));
                }

                @Generated
                public Object call(Map diskMap) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, diskMap);
                }

                @Generated
                public InstanceProperties getInstanceProperties() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.instanceProperties.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _convertMapToInstanceProperties_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, diskMapList, new _convertMapToInstanceProperties_closure11(this, this, instanceProperties));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "metadata", 0, instancePropertiesMap)) != false) {
            CallSite callSite3 = IndyInterface.bootstrap("init", "<init>", 0, Metadata.class);
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)((InstanceProperties)instanceProperties.get()), (String)"metadata");
            List list = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("getProperty", "metadata", 0, instancePropertiesMap)), List.class));
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)IndyInterface.bootstrap("getProperty", "metadata", 0, (InstanceProperties)instanceProperties.get()), (String)"items");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "scheduling", 0, instancePropertiesMap)) != false) {
            CallSite callSite4 = IndyInterface.bootstrap("invoke", "convertMapToScheduling", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "scheduling", 0, instancePropertiesMap), Map.class))), Map.class));
            ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)((InstanceProperties)instanceProperties.get()), (String)"scheduling");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "networkInterfaces", 0, instancePropertiesMap)) != false) {
            CallSite callSite5 = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
            ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)((InstanceProperties)instanceProperties.get()), (String)"networkInterfaces");
            List networkInterfaceMaps = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "networkInterfaces", 0, instancePropertiesMap), List.class));
            public final class _convertMapToInstanceProperties_closure12
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference instanceProperties;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _convertMapToInstanceProperties_closure12(Object _outerInstance, Object _thisObject, Reference instanceProperties) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.instanceProperties = reference = instanceProperties;
                }

                public Object doCall(Map networkInterfaceMap) {
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "networkInterfaces", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceProperties.get())), IndyInterface.bootstrap("invoke", "convertMapToNetworkInterface", 2, this, networkInterfaceMap));
                }

                @Generated
                public Object call(Map networkInterfaceMap) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, networkInterfaceMap);
                }

                @Generated
                public InstanceProperties getInstanceProperties() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.instanceProperties.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _convertMapToInstanceProperties_closure12.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, networkInterfaceMaps, new _convertMapToInstanceProperties_closure12(this, this, instanceProperties));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "tags", 0, instancePropertiesMap)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("getProperty", "tags", 0, instancePropertiesMap)))) {
            CallSite callSite6 = IndyInterface.bootstrap("init", "<init>", 0, Tags.class);
            ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)((InstanceProperties)instanceProperties.get()), (String)"tags");
            List list = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("getProperty", "tags", 0, instancePropertiesMap)), List.class));
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)IndyInterface.bootstrap("getProperty", "tags", 0, (InstanceProperties)instanceProperties.get()), (String)"items");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "serviceAccounts", 0, instancePropertiesMap)) != false) {
            CallSite callSite7 = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
            ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)((InstanceProperties)instanceProperties.get()), (String)"serviceAccounts");
            List serviceAccountMaps = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "serviceAccounts", 0, instancePropertiesMap), List.class));
            public final class _convertMapToInstanceProperties_closure13
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference instanceProperties;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _convertMapToInstanceProperties_closure13(Object _outerInstance, Object _thisObject, Reference instanceProperties) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.instanceProperties = reference = instanceProperties;
                }

                public Object doCall(Map serviceAccountMap) {
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "serviceAccounts", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceProperties.get())), IndyInterface.bootstrap("invoke", "convertMapToServiceAccount", 2, this, serviceAccountMap));
                }

                @Generated
                public Object call(Map serviceAccountMap) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, serviceAccountMap);
                }

                @Generated
                public InstanceProperties getInstanceProperties() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.instanceProperties.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _convertMapToInstanceProperties_closure13.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, serviceAccountMaps, new _convertMapToInstanceProperties_closure13(this, this, instanceProperties));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "shieldedVmConfig", 0, instancePropertiesMap)) != false) {
            CallSite callSite8 = IndyInterface.bootstrap("invoke", "convertMapToShieldedVmConfig", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "shieldedVmConfig", 0, instancePropertiesMap), Map.class))), Map.class));
            ScriptBytecodeAdapter.setProperty((Object)callSite8, null, (Object)((InstanceProperties)instanceProperties.get()), (String)"shieldedVmConfig");
        }
        return (InstanceProperties)instanceProperties.get();
    }

    private AttachedDisk convertMapToAttachedDisk(Map diskMap) {
        CallSite disk = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AttachedDisk.class));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "autoDelete", 0, diskMap), Boolean.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)disk, (String)"autoDelete");
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "boot", 0, diskMap), Boolean.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)disk, (String)"boot");
        String string = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "deviceName", 0, diskMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)disk, (String)"deviceName");
        String string2 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "source", 0, diskMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)disk, (String)"source");
        String string3 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "interface", 0, diskMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)disk, (String)"interface");
        String string4 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "mode", 0, diskMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string4, null, (Object)disk, (String)"mode");
        String string5 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "type", 0, diskMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string5, null, (Object)disk, (String)"type");
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "initializeParams", 0, diskMap)) != false) {
            CallSite callSite3 = IndyInterface.bootstrap("init", "<init>", 0, AttachedDiskInitializeParams.class);
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)disk, (String)"initializeParams");
            String string6 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "diskName", 0, IndyInterface.bootstrap("getProperty", "initializeParams", 0, diskMap)), String.class));
            ScriptBytecodeAdapter.setProperty((Object)string6, null, (Object)IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk), (String)"diskName");
            String string7 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "sourceImage", 0, IndyInterface.bootstrap("getProperty", "initializeParams", 0, diskMap)), String.class));
            ScriptBytecodeAdapter.setProperty((Object)string7, null, (Object)IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk), (String)"sourceImage");
            String string8 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "diskType", 0, IndyInterface.bootstrap("getProperty", "initializeParams", 0, diskMap)), String.class));
            ScriptBytecodeAdapter.setProperty((Object)string8, null, (Object)IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk), (String)"diskType");
            Long l = (Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "diskSizeGb", 0, IndyInterface.bootstrap("getProperty", "initializeParams", 0, diskMap)), Long.class));
            ScriptBytecodeAdapter.setProperty((Object)l, null, (Object)IndyInterface.bootstrap("getProperty", "initializeParams", 0, disk), (String)"diskSizeGb");
        }
        return disk;
    }

    private Scheduling convertMapToScheduling(Map schedulingMap) {
        CallSite scheduling = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Scheduling.class));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "automaticRestart", 0, schedulingMap), Boolean.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)scheduling, (String)"automaticRestart");
        String string = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "onHostMaintenance", 0, schedulingMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)scheduling, (String)"onHostMaintenance");
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "preemptible", 0, schedulingMap), Boolean.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)scheduling, (String)"preemptible");
        return scheduling;
    }

    private ShieldedVmConfig convertMapToShieldedVmConfig(Map shieldedVmConfigMap) {
        CallSite shieldedVmConfig = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ShieldedVmConfig.class));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "enableSecureBoot", 0, shieldedVmConfigMap), Boolean.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)shieldedVmConfig, (String)"enableSecureBoot");
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "enableVtpm", 0, shieldedVmConfigMap), Boolean.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)shieldedVmConfig, (String)"enableVtpm");
        CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "enableIntegrityMonitoring", 0, shieldedVmConfigMap), Boolean.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)shieldedVmConfig, (String)"enableIntegrityMonitoring");
        return shieldedVmConfig;
    }

    private NetworkInterface convertMapToNetworkInterface(Map networkInterfaceMap) {
        CallSite networkInterface = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, NetworkInterface.class));
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)networkInterface, (String)"accessConfigs");
        String string = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "network", 0, networkInterfaceMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)networkInterface, (String)"network");
        String string2 = (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "subnetwork", 0, networkInterfaceMap), String.class));
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)networkInterface, (String)"subnetwork");
        return networkInterface;
    }

    private ServiceAccount convertMapToServiceAccount(Map serviceAccountMap) {
        CallSite serviceAccount = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ServiceAccount.class));
        List list = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "scopes", 0, serviceAccountMap), List.class));
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)serviceAccount, (String)"scopes");
        return serviceAccount;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SaveSnapshotAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public GoogleClusterProvider getGoogleClusterProvider() {
        return this.googleClusterProvider;
    }

    @Generated
    public void setGoogleClusterProvider(GoogleClusterProvider googleClusterProvider) {
        this.googleClusterProvider = googleClusterProvider;
    }

    @Generated
    public GoogleLoadBalancerProvider getGoogleLoadBalancerProvider() {
        return this.googleLoadBalancerProvider;
    }

    @Generated
    public void setGoogleLoadBalancerProvider(GoogleLoadBalancerProvider googleLoadBalancerProvider) {
        this.googleLoadBalancerProvider = googleLoadBalancerProvider;
    }

    @Generated
    public GoogleSecurityGroupProvider getGoogleSecurityGroupProvider() {
        return this.googleSecurityGroupProvider;
    }

    @Generated
    public void setGoogleSecurityGroupProvider(GoogleSecurityGroupProvider googleSecurityGroupProvider) {
        this.googleSecurityGroupProvider = googleSecurityGroupProvider;
    }

    @Generated
    public AccountCredentialsRepository getAccountCredentialsRepository() {
        return this.accountCredentialsRepository;
    }

    @Generated
    public void setAccountCredentialsRepository(AccountCredentialsRepository accountCredentialsRepository) {
        this.accountCredentialsRepository = accountCredentialsRepository;
    }

    @Generated
    public Front50Service getFront50Service() {
        return this.front50Service;
    }

    @Generated
    public void setFront50Service(Front50Service front50Service) {
        this.front50Service = front50Service;
    }
}

