/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.model.callbacks;

import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.PathRule;
import com.google.api.services.compute.model.UrlMap;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleBackendService;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHostRule;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GooglePathMatcher;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GooglePathRule;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSslLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTargetProxyType;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTcpLoadBalancer;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.MapEntry;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class Utils
implements GroovyObject {
    public static final String TARGET_POOL_NAME_PREFIX = "tp";
    public static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    private static final Splitter onSlash;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public Utils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static long getTimeFromTimestamp(String timestamp) {
        if (IndyInterface.bootstrap("cast", "()", 0, timestamp) != false) {
            return DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "getTime", 0, IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("init", "<init>", 0, SimpleDateFormat.class, SIMPLE_DATE_FORMAT), timestamp)));
        }
        return DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class));
    }

    public static String derivePortOrPortRange(String portRange) {
        if (IndyInterface.bootstrap("cast", "()", 0, portRange) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, portRange, "-")) == false) {
            return portRange;
        }
        CallSite tokens = IndyInterface.bootstrap("invoke", "split", 0, portRange, "-");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, tokens), (Object)2)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{portRange}, new String[]{"Port range ", " formatted improperly."})));
        }
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, tokens, false), (Object)IndyInterface.bootstrap("invoke", "getAt", 0, tokens, true)) ? portRange : IndyInterface.bootstrap("invoke", "getAt", 0, tokens, false));
    }

    public static String getLocalName(String fullUrl) {
        if (IndyInterface.bootstrap("cast", "()", 0, fullUrl) == false) {
            return fullUrl;
        }
        int lastIndex = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "lastIndexOf", 0, fullUrl, "/"));
        return IndyInterface.bootstrap("cast", "()", 0, lastIndex != -1 ? IndyInterface.bootstrap("invoke", "substring", 0, fullUrl, IndyInterface.bootstrap("invoke", "plus", 0, lastIndex, true)) : fullUrl);
    }

    @Nonnull
    public static GoogleTargetProxyType getTargetProxyType(@Nullable String fullUrl) {
        String resourceType = Utils.getResourceType(Strings.nullToEmpty((String)fullUrl));
        return GoogleTargetProxyType.fromResourceType(resourceType);
    }

    @Nonnull
    private static String getResourceType(@Nonnull String uri) {
        return IndyInterface.bootstrap("cast", "()", 0, Lists.reverse((List)onSlash.splitToList((CharSequence)uri)).stream().skip(1).findFirst().orElse(""));
    }

    public static String getZoneFromInstanceUrl(String fullUrl) {
        String zones = "zones/";
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, fullUrl, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "indexOf", 0, fullUrl, zones), IndyInterface.bootstrap("invoke", "length", 0, zones)), IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "indexOf", 0, fullUrl, "instances/"), true)));
    }

    public static String getHealthCheckType(String fullUrl) {
        if (IndyInterface.bootstrap("cast", "()", 0, fullUrl) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{fullUrl}, new String[]{"Health check url ", " malformed."})));
        }
        int lastIndex = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "lastIndexOf", 0, fullUrl, "/"));
        if (lastIndex == -1) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{fullUrl}, new String[]{"Health check url ", " malformed."})));
        }
        CallSite withoutName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, fullUrl, false, lastIndex));
        return Utils.getLocalName((String)((Object)withoutName));
    }

    public static Map<String, String> buildMapFromMetadata(Metadata metadata) {
        public final class _buildMapFromMetadata_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildMapFromMetadata_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Metadata.Items metadataItems) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "key", 0, metadataItems), IndyInterface.bootstrap("getProperty", "value", 0, metadataItems)});
            }

            @Generated
            public Object call(Metadata.Items metadataItems) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, metadataItems);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildMapFromMetadata_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 1, IndyInterface.bootstrap("getProperty", "items", 0, metadata), new _buildMapFromMetadata_closure1(Utils.class, Utils.class)));
    }

    public static String getRegionFromGroupUrl(String fullUrl) {
        if (IndyInterface.bootstrap("cast", "()", 0, fullUrl) == false) {
            return fullUrl;
        }
        CallSite urlParts = IndyInterface.bootstrap("invoke", "split", 0, fullUrl, "/");
        if (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("getProperty", "length", 0, urlParts), (Object)4)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group Url ", " malformed."})));
        }
        CallSite regionsOrZones = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, urlParts, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "length", 0, urlParts), 4)));
        CallSite callSite = regionsOrZones;
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"regions")) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, urlParts, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "length", 0, urlParts), 3)));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"zones")) {
            CallSite zone = IndyInterface.bootstrap("invoke", "getAt", 0, urlParts, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "length", 0, urlParts), 3));
            CallSite lastDash = IndyInterface.bootstrap("invoke", "lastIndexOf", 0, zone, "-");
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, zone, false, lastDash));
        }
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group Url ", " malformed."})));
    }

    public static String getZoneFromGroupUrl(String fullUrl) {
        if (IndyInterface.bootstrap("cast", "()", 0, fullUrl) == false) {
            return fullUrl;
        }
        CallSite urlParts = IndyInterface.bootstrap("invoke", "split", 0, fullUrl, "/");
        if (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("getProperty", "length", 0, urlParts), (Object)4)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group url ", " malformed."})));
        }
        CallSite regionsOrZones = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, urlParts, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "length", 0, urlParts), 4)));
        CallSite callSite = regionsOrZones;
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"regions")) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{fullUrl}, new String[]{"Can't parse a zone from regional group url ", "."})));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"zones")) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, urlParts, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "length", 0, urlParts), 3)));
        }
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group url ", " malformed."})));
    }

    public static GoogleServerGroup.ServerGroupType determineServerGroupType(String fullUrl) {
        if (IndyInterface.bootstrap("cast", "()", 0, fullUrl) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, fullUrl);
        }
        CallSite urlParts = IndyInterface.bootstrap("invoke", "split", 0, fullUrl, "/");
        if (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("getProperty", "length", 0, urlParts), (Object)4)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group Url ", " malformed."})));
        }
        CallSite regionsOrZones = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, urlParts, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "length", 0, urlParts), 4)));
        CallSite callSite = regionsOrZones;
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"regions")) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "REGIONAL", 0, GoogleServerGroup.ServerGroupType.class));
        }
        if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"zones")) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ZONAL", 0, GoogleServerGroup.ServerGroupType.class));
        }
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{fullUrl}, new String[]{"Server group Url ", " malformed."})));
    }

    public static List<String> deriveNetworkLoadBalancerNamesFromTargetPoolUrls(List<String> targetPoolUrls) {
        if (IndyInterface.bootstrap("cast", "()", 0, targetPoolUrls) != false) {
            public final class _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object targetPoolUrl) {
                    CallSite targetPoolLocalName = IndyInterface.bootstrap("invoke", "getLocalName", 2, this, targetPoolUrl);
                    return IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "split", 0, targetPoolLocalName, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "TARGET_POOL_NAME_PREFIX", 12, this)}, new String[]{"-", "-"})), false);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, targetPoolUrls, new _deriveNetworkLoadBalancerNamesFromTargetPoolUrls_closure2(Utils.class, Utils.class)));
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    public static Object getImmutableCopy(Object value) {
        CallSite valueClass = IndyInterface.bootstrap("invoke", "getClass", 0, value);
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isPrimitiveOrWrapper", 0, ClassUtils.class, valueClass)) || ScriptBytecodeAdapter.compareEqual((Object)valueClass, String.class)) {
            return value;
        }
        if (value instanceof Cloneable) {
            return IndyInterface.bootstrap("invoke", "clone", 0, value);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, value) != false) {
            return IndyInterface.bootstrap("invoke", "toString", 0, value);
        }
        return null;
    }

    public static List<GoogleBackendService> getBackendServicesFromHttpLoadBalancerView(GoogleHttpLoadBalancer.View googleLoadBalancer) {
        List backendServices = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "defaultService", 4, googleLoadBalancer)});
        IndyInterface.bootstrap("invoke", "collectBackendServicesFromHostRules", 0, Utils.class, IndyInterface.bootstrap("getProperty", "hostRules", 5, googleLoadBalancer), backendServices);
        return backendServices;
    }

    public static List<GoogleBackendService> getBackendServicesFromInternalHttpLoadBalancerView(GoogleInternalHttpLoadBalancer.InternalHttpLbView googleLoadBalancer) {
        List backendServices = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "defaultService", 4, googleLoadBalancer)});
        IndyInterface.bootstrap("invoke", "collectBackendServicesFromHostRules", 0, Utils.class, IndyInterface.bootstrap("getProperty", "hostRules", 5, googleLoadBalancer), backendServices);
        return backendServices;
    }

    public static void collectBackendServicesFromHostRules(List<GoogleHostRule> hostRules, List<GoogleBackendService> backendServices) {
        Reference backendServices2 = new Reference(backendServices);
        public final class _collectBackendServicesFromHostRules_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _collectBackendServicesFromHostRules_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(GoogleHostRule hostRule) {
                return IndyInterface.bootstrap("getProperty", "pathMatcher", 4, hostRule);
            }

            @Generated
            public Object call(GoogleHostRule hostRule) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, hostRule);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectBackendServicesFromHostRules_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite pathMatchers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, hostRules, new _collectBackendServicesFromHostRules_closure3(Utils.class, Utils.class)));
        public final class _collectBackendServicesFromHostRules_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference backendServices;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _collectBackendServicesFromHostRules_closure4(Object _outerInstance, Object _thisObject, Reference backendServices) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.backendServices = reference = backendServices;
            }

            public Object doCall(GooglePathMatcher pathMatcher) {
                IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.backendServices.get()), IndyInterface.bootstrap("getProperty", "defaultService", 4, pathMatcher));
                public final class _closure22
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference backendServices;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure22(Object _outerInstance, Object _thisObject, Reference backendServices) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.backendServices = reference = backendServices;
                    }

                    public Object doCall(GooglePathRule googlePathRule) {
                        return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.backendServices.get()), IndyInterface.bootstrap("getProperty", "backendService", 4, googlePathRule));
                    }

                    @Generated
                    public Object call(GooglePathRule googlePathRule) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, googlePathRule);
                    }

                    @Generated
                    public List getBackendServices() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.backendServices.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure22.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "pathRules", 5, pathMatcher), new _closure22((Object)this, this.getThisObject(), this.backendServices));
            }

            @Generated
            public Object call(GooglePathMatcher pathMatcher) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, pathMatcher);
            }

            @Generated
            public List getBackendServices() {
                return IndyInterface.bootstrap("cast", "()", 0, this.backendServices.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectBackendServicesFromHostRules_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _collectBackendServicesFromHostRules_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _collectBackendServicesFromHostRules_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)it, null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectBackendServicesFromHostRules_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "findAll", 1, IndyInterface.bootstrap("invoke", "each", 1, pathMatchers, new _collectBackendServicesFromHostRules_closure4(Utils.class, Utils.class, backendServices2)), new _collectBackendServicesFromHostRules_closure5(Utils.class, Utils.class));
    }

    public static List<String> getBackendServicesFromUrlMap(UrlMap urlMap) {
        Reference backendServices = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "defaultService", 0, urlMap))}));
        public final class _getBackendServicesFromUrlMap_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference backendServices;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getBackendServicesFromUrlMap_closure6(Object _outerInstance, Object _thisObject, Reference backendServices) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.backendServices = reference = backendServices;
            }

            public Object doCall(PathMatcher pathMatcher) {
                IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.backendServices.get()), IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "defaultService", 0, pathMatcher)));
                public final class _closure23
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference backendServices;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure23(Object _outerInstance, Object _thisObject, Reference backendServices) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.backendServices = reference = backendServices;
                    }

                    public Object doCall(PathRule pathRule) {
                        return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.backendServices.get()), IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "service", 0, pathRule)));
                    }

                    @Generated
                    public Object call(PathRule pathRule) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, pathRule);
                    }

                    @Generated
                    public List getBackendServices() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.backendServices.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure23.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "pathRules", 1, pathMatcher), new _closure23((Object)this, this.getThisObject(), this.backendServices));
            }

            @Generated
            public Object call(PathMatcher pathMatcher) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, pathMatcher);
            }

            @Generated
            public List getBackendServices() {
                return IndyInterface.bootstrap("cast", "()", 0, this.backendServices.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getBackendServicesFromUrlMap_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "pathMatchers", 1, urlMap), new _getBackendServicesFromUrlMap_closure6(Utils.class, Utils.class, backendServices));
        return (List)backendServices.get();
    }

    public static boolean determineHttpLoadBalancerDisabledState(GoogleHttpLoadBalancer loadBalancer, GoogleServerGroup serverGroup) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite httpLoadBalancersFromMetadata = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "asg", 4, (GoogleServerGroup)serverGroup2.get()), IndyInterface.bootstrap("getProperty", "GLOBAL_LOAD_BALANCER_NAMES", 0, GCEUtil.class));
        Reference backendServicesFromMetadata = new Reference((Object)IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "asg", 4, (GoogleServerGroup)serverGroup2.get()), IndyInterface.bootstrap("getProperty", "BACKEND_SERVICE_NAMES", 0, GCEUtil.class)));
        public final class _determineHttpLoadBalancerDisabledState_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference backendServicesFromMetadata;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineHttpLoadBalancerDisabledState_closure7(Object _outerInstance, Object _thisObject, Reference backendServicesFromMetadata) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.backendServicesFromMetadata = reference = backendServicesFromMetadata;
            }

            public Object doCall(Object it) {
                return DefaultTypeTransformation.booleanUnbox((Object)it) && ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)this.backendServicesFromMetadata.get());
            }

            @Generated
            public Object getBackendServicesFromMetadata() {
                return this.backendServicesFromMetadata.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineHttpLoadBalancerDisabledState_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _determineHttpLoadBalancerDisabledState_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineHttpLoadBalancerDisabledState_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "backends", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineHttpLoadBalancerDisabledState_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite serviceBackends = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "getBackendServicesFromHttpLoadBalancerView", 0, Utils.class, IndyInterface.bootstrap("getProperty", "view", 4, loadBalancer)), new _determineHttpLoadBalancerDisabledState_closure7(Utils.class, Utils.class, backendServicesFromMetadata)), new _determineHttpLoadBalancerDisabledState_closure8(Utils.class, Utils.class)));
        public final class _determineHttpLoadBalancerDisabledState_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineHttpLoadBalancerDisabledState_closure9(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "region", 4, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get())), (Object)IndyInterface.bootstrap("invoke", "getRegionFromGroupUrl", 0, Utils.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 0, it)));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineHttpLoadBalancerDisabledState_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _determineHttpLoadBalancerDisabledState_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineHttpLoadBalancerDisabledState_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineHttpLoadBalancerDisabledState_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite backendGroupNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "flatten", 0, serviceBackends), new _determineHttpLoadBalancerDisabledState_closure9(Utils.class, Utils.class, serverGroup2)), new _determineHttpLoadBalancerDisabledState_closure10(Utils.class, Utils.class)));
        return ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer), (Object)httpLoadBalancersFromMetadata) && !ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 4, (GoogleServerGroup)serverGroup2.get()), (Object)backendGroupNames);
    }

    public static boolean determineInternalHttpLoadBalancerDisabledState(GoogleInternalHttpLoadBalancer loadBalancer, GoogleServerGroup serverGroup) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite loadBalancersFromMetadata = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "asg", 4, (GoogleServerGroup)serverGroup2.get()), IndyInterface.bootstrap("getProperty", "REGIONAL_LOAD_BALANCER_NAMES", 0, GCEUtil.class));
        Reference backendServicesFromMetadata = new Reference((Object)IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "asg", 4, (GoogleServerGroup)serverGroup2.get()), IndyInterface.bootstrap("getProperty", "REGION_BACKEND_SERVICE_NAMES", 0, GCEUtil.class)));
        public final class _determineInternalHttpLoadBalancerDisabledState_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference backendServicesFromMetadata;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineInternalHttpLoadBalancerDisabledState_closure11(Object _outerInstance, Object _thisObject, Reference backendServicesFromMetadata) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.backendServicesFromMetadata = reference = backendServicesFromMetadata;
            }

            public Object doCall(Object it) {
                return DefaultTypeTransformation.booleanUnbox((Object)it) && ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)this.backendServicesFromMetadata.get());
            }

            @Generated
            public Object getBackendServicesFromMetadata() {
                return this.backendServicesFromMetadata.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalHttpLoadBalancerDisabledState_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _determineInternalHttpLoadBalancerDisabledState_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineInternalHttpLoadBalancerDisabledState_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "backends", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalHttpLoadBalancerDisabledState_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite serviceBackends = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "getBackendServicesFromInternalHttpLoadBalancerView", 0, Utils.class, IndyInterface.bootstrap("getProperty", "view", 4, loadBalancer)), new _determineInternalHttpLoadBalancerDisabledState_closure11(Utils.class, Utils.class, backendServicesFromMetadata)), new _determineInternalHttpLoadBalancerDisabledState_closure12(Utils.class, Utils.class)));
        public final class _determineInternalHttpLoadBalancerDisabledState_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineInternalHttpLoadBalancerDisabledState_closure13(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "region", 4, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get())), (Object)IndyInterface.bootstrap("invoke", "getRegionFromGroupUrl", 0, Utils.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 0, it)));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalHttpLoadBalancerDisabledState_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _determineInternalHttpLoadBalancerDisabledState_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineInternalHttpLoadBalancerDisabledState_closure14(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalHttpLoadBalancerDisabledState_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite backendGroupNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "flatten", 0, serviceBackends), new _determineInternalHttpLoadBalancerDisabledState_closure13(Utils.class, Utils.class, serverGroup2)), new _determineInternalHttpLoadBalancerDisabledState_closure14(Utils.class, Utils.class)));
        return ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer), (Object)loadBalancersFromMetadata) && !ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 4, (GoogleServerGroup)serverGroup2.get()), (Object)backendGroupNames);
    }

    public static String decorateXpnResourceIdIfNeeded(String managedProjectId, String xpnResource) {
        if (IndyInterface.bootstrap("cast", "()", 0, xpnResource) == false) {
            return xpnResource;
        }
        CallSite xpnResourceProject = IndyInterface.bootstrap("invoke", "deriveProjectId", 0, GCEUtil.class, xpnResource);
        CallSite xpnResourceId = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, xpnResource);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)xpnResourceProject, (Object)managedProjectId)) {
            xpnResourceId = new GStringImpl(new Object[]{xpnResourceProject, xpnResourceId}, new String[]{"", "/", ""});
        }
        return IndyInterface.bootstrap("cast", "()", 0, xpnResourceId);
    }

    public static boolean determineInternalLoadBalancerDisabledState(GoogleInternalLoadBalancer loadBalancer, GoogleServerGroup serverGroup) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite regionalLoadBalancersFromMetadata = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "asg", 4, (GoogleServerGroup)serverGroup2.get()), IndyInterface.bootstrap("getProperty", "REGIONAL_LOAD_BALANCER_NAMES", 0, GCEUtil.class));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "backendService", 4, loadBalancer), null)) {
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "warn", 0, log, new GStringImpl(new Object[]{loadBalancer}, new String[]{"Malformed internal load balancer encountered: ", ""})) : null;
        }
        CallSite serviceBackends = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "backends", 1, IndyInterface.bootstrap("getProperty", "backendService", 5, loadBalancer)));
        public final class _determineInternalLoadBalancerDisabledState_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineInternalLoadBalancerDisabledState_closure15(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "region", 4, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get())), (Object)IndyInterface.bootstrap("invoke", "getRegionFromGroupUrl", 0, Utils.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 0, it)));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalLoadBalancerDisabledState_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _determineInternalLoadBalancerDisabledState_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineInternalLoadBalancerDisabledState_closure16(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineInternalLoadBalancerDisabledState_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite backendGroupNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, serviceBackends, new _determineInternalLoadBalancerDisabledState_closure15(Utils.class, Utils.class, serverGroup2)), new _determineInternalLoadBalancerDisabledState_closure16(Utils.class, Utils.class)));
        return ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer), (Object)regionalLoadBalancersFromMetadata) && !ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 4, (GoogleServerGroup)serverGroup2.get()), (Object)backendGroupNames);
    }

    public static boolean determineSslLoadBalancerDisabledState(GoogleSslLoadBalancer loadBalancer, GoogleServerGroup serverGroup) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite globalLoadBalancersFromMetadata = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "asg", 4, (GoogleServerGroup)serverGroup2.get()), IndyInterface.bootstrap("getProperty", "GLOBAL_LOAD_BALANCER_NAMES", 0, GCEUtil.class));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "backendService", 4, loadBalancer), null)) {
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "warn", 0, log, new GStringImpl(new Object[]{loadBalancer}, new String[]{"Malformed ssl load balancer encountered: ", ""})) : null;
        }
        CallSite serviceBackends = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "backends", 1, IndyInterface.bootstrap("getProperty", "backendService", 5, loadBalancer)));
        public final class _determineSslLoadBalancerDisabledState_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineSslLoadBalancerDisabledState_closure17(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "region", 4, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get())), (Object)IndyInterface.bootstrap("invoke", "getRegionFromGroupUrl", 0, Utils.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 0, it)));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineSslLoadBalancerDisabledState_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _determineSslLoadBalancerDisabledState_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineSslLoadBalancerDisabledState_closure18(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineSslLoadBalancerDisabledState_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite backendGroupNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, serviceBackends, new _determineSslLoadBalancerDisabledState_closure17(Utils.class, Utils.class, serverGroup2)), new _determineSslLoadBalancerDisabledState_closure18(Utils.class, Utils.class)));
        return ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer), (Object)globalLoadBalancersFromMetadata) && !ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 4, (GoogleServerGroup)serverGroup2.get()), (Object)backendGroupNames);
    }

    public static boolean determineTcpLoadBalancerDisabledState(GoogleTcpLoadBalancer loadBalancer, GoogleServerGroup serverGroup) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite globalLoadBalancersFromMetadata = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "asg", 4, (GoogleServerGroup)serverGroup2.get()), IndyInterface.bootstrap("getProperty", "GLOBAL_LOAD_BALANCER_NAMES", 0, GCEUtil.class));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "backendService", 4, loadBalancer), null)) {
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "warn", 0, log, new GStringImpl(new Object[]{loadBalancer}, new String[]{"Malformed tcp load balancer encountered: ", ""})) : null;
        }
        CallSite serviceBackends = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "backends", 1, IndyInterface.bootstrap("getProperty", "backendService", 5, loadBalancer)));
        public final class _determineTcpLoadBalancerDisabledState_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineTcpLoadBalancerDisabledState_closure19(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "region", 4, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get())), (Object)IndyInterface.bootstrap("invoke", "getRegionFromGroupUrl", 0, Utils.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 0, it)));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineTcpLoadBalancerDisabledState_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _determineTcpLoadBalancerDisabledState_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _determineTcpLoadBalancerDisabledState_closure20(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "serverGroupUrl", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _determineTcpLoadBalancerDisabledState_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite backendGroupNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, serviceBackends, new _determineTcpLoadBalancerDisabledState_closure19(Utils.class, Utils.class, serverGroup2)), new _determineTcpLoadBalancerDisabledState_closure20(Utils.class, Utils.class)));
        return ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 4, loadBalancer), (Object)globalLoadBalancersFromMetadata) && !ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "name", 4, (GoogleServerGroup)serverGroup2.get()), (Object)backendGroupNames);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Collection<String>> mergeOnDemandCacheRelationships(Map<String, Collection<String>> onDemandRelationships, Map<String, Collection<String>> existingRelationships) {
        void var1_1;
        Reference onDemandRelationships2 = new Reference(onDemandRelationships);
        Reference existingRelationships2 = new Reference((Object)var1_1);
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{(Map)onDemandRelationships2.get(), (Map)existingRelationships2.get()}, new String[]{"Merging onDemand relationships: ", " with existing relationships: ", ""})) : null;
        CallSite relationshipKeys = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "keySet", 0, (Map)existingRelationships2.get()), IndyInterface.bootstrap("invoke", "keySet", 0, (Map)onDemandRelationships2.get())));
        public final class _mergeOnDemandCacheRelationships_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference onDemandRelationships;
            private /* synthetic */ Reference existingRelationships;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mergeOnDemandCacheRelationships_closure21(Object _outerInstance, Object _thisObject, Reference onDemandRelationships, Reference existingRelationships) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.onDemandRelationships = reference2 = onDemandRelationships;
                this.existingRelationships = reference = existingRelationships;
            }

            public Object doCall(String key) {
                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.onDemandRelationships.get()), key)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingRelationships.get()), key))) {
                    CallSite ret = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class));
                    IndyInterface.bootstrap("invoke", "addAll", 0, ret, IndyInterface.bootstrap("invoke", "getOrDefault", 0, IndyInterface.bootstrap("cast", "()", 0, this.onDemandRelationships.get()), key, ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                    IndyInterface.bootstrap("invoke", "addAll", 0, ret, IndyInterface.bootstrap("invoke", "getOrDefault", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingRelationships.get()), key, ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                    return IndyInterface.bootstrap("init", "<init>", 0, MapEntry.class, key, ret);
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.onDemandRelationships.get()), key)) != false) {
                    return IndyInterface.bootstrap("init", "<init>", 0, MapEntry.class, key, IndyInterface.bootstrap("invoke", "getOrDefault", 0, IndyInterface.bootstrap("cast", "()", 0, this.onDemandRelationships.get()), key, ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingRelationships.get()), key)) != false) {
                    return IndyInterface.bootstrap("init", "<init>", 0, MapEntry.class, key, IndyInterface.bootstrap("invoke", "getOrDefault", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingRelationships.get()), key, ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                }
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{key}, new String[]{"Attempted to merge relationship key ", " that neither exists in onDemand cache data nor existing cache data."})) : null;
                return null;
            }

            @Generated
            public Object call(String key) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, key);
            }

            @Generated
            public Map getOnDemandRelationships() {
                return IndyInterface.bootstrap("cast", "()", 0, this.onDemandRelationships.get());
            }

            @Generated
            public Map getExistingRelationships() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingRelationships.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mergeOnDemandCacheRelationships_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, relationshipKeys, new _mergeOnDemandCacheRelationships_closure21(Utils.class, Utils.class, onDemandRelationships2, existingRelationships2)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Utils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "omitEmptyStrings", 0, IndyInterface.bootstrap("invoke", "on", 0, Splitter.class, "/"));
        onSlash = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite2);
    }
}

