/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.Autoscaler;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.compute.BatchPaginatedComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GetFirstBatchComputeRequest;
import com.netflix.spinnaker.clouddriver.google.compute.GoogleComputeApiFactory;
import com.netflix.spinnaker.clouddriver.google.compute.Instances;
import com.netflix.spinnaker.clouddriver.google.compute.ZoneAutoscalers;
import com.netflix.spinnaker.clouddriver.google.compute.ZoneInstanceGroupManagers;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.provider.agent.AbstractGoogleServerGroupCachingAgent;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.kork.client.ServiceClientProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class GoogleZonalServerGroupCachingAgent
extends AbstractGoogleServerGroupCachingAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GoogleZonalServerGroupCachingAgent.class);

    public GoogleZonalServerGroupCachingAgent(GoogleNamedAccountCredentials credentials, GoogleComputeApiFactory computeApiFactory, Registry registry, String region, ObjectMapper objectMapper, ServiceClientProvider serviceClientProvider) {
        super(credentials, computeApiFactory, registry, region, objectMapper, serviceClientProvider);
    }

    @Override
    Collection<String> getOnDemandKeysToEvictForMissingServerGroup(ProviderCache providerCache, String serverGroupName) {
        String serverGroupKey = Keys.getServerGroupKey(serverGroupName, null, this.getAccountName(), this.getRegion(), "*");
        return providerCache.filterIdentifiers(Keys.Namespace.SERVER_GROUPS.getNs(), serverGroupKey);
    }

    @Override
    boolean keyOwnedByThisAgent(Map<String, String> parsedKey) {
        return this.getAccountName().equals(parsedKey.get("account")) && this.getRegion().equals(parsedKey.get("region")) && parsedKey.get("zone") != null;
    }

    @Override
    Collection<InstanceGroupManager> retrieveInstanceGroupManagers() throws IOException {
        ZoneInstanceGroupManagers managersApi = this.getComputeApiFactory().createZoneInstanceGroupManagers(this.getCredentials());
        BatchPaginatedComputeRequest request = this.getComputeApiFactory().createPaginatedBatchRequest(this.getCredentials());
        this.getZonesForRegion().forEach(zone -> request.queue(managersApi.list((String)zone)));
        return request.execute(this.getBatchContext("igm"));
    }

    @Override
    Collection<Autoscaler> retrieveAutoscalers() throws IOException {
        ZoneAutoscalers autoscalersApi = this.getComputeApiFactory().createZoneAutoscalers(this.getCredentials());
        BatchPaginatedComputeRequest request = this.getComputeApiFactory().createPaginatedBatchRequest(this.getCredentials());
        this.getZonesForRegion().forEach(zone -> request.queue(autoscalersApi.list((String)zone)));
        return request.execute(this.getBatchContext("autoscaler"));
    }

    @Override
    Optional<InstanceGroupManager> retrieveInstanceGroupManager(String name) throws IOException {
        ZoneInstanceGroupManagers managersApi = this.getComputeApiFactory().createZoneInstanceGroupManagers(this.getCredentials());
        GetFirstBatchComputeRequest<Compute.InstanceGroupManagers.Get, InstanceGroupManager> request = GetFirstBatchComputeRequest.create(this.getComputeApiFactory().createBatchRequest(this.getCredentials()));
        for (String zone : this.getZonesForRegion()) {
            request.queue(managersApi.get(zone, name));
        }
        return request.execute(this.getBatchContext("igm"));
    }

    @Override
    Optional<Autoscaler> retrieveAutoscaler(InstanceGroupManager manager) throws IOException {
        ZoneAutoscalers autoscalersApi = this.getComputeApiFactory().createZoneAutoscalers(this.getCredentials());
        return autoscalersApi.get(this.getZone(manager), manager.getName()).executeGet();
    }

    @Override
    Collection<Instance> retrieveRelevantInstances(InstanceGroupManager manager) throws IOException {
        Instances instancesApi = this.getComputeApiFactory().createInstances(this.getCredentials());
        return (Collection)instancesApi.list(this.getZone(manager)).execute().stream().collect(ImmutableList.toImmutableList());
    }

    private String getZone(InstanceGroupManager manager) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)manager.getZone()) ? 1 : 0) != 0, (String)"Managed instance group %s did not have a zone.", (Object)manager.getName());
        return Utils.getLocalName(manager.getZone());
    }

    @Override
    String getBatchContextPrefix() {
        return "ZonalServerGroupCaching";
    }
}

