/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.model.GoogleApplication;
import com.netflix.spinnaker.clouddriver.model.Application;
import com.netflix.spinnaker.clouddriver.model.ApplicationProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
final class GoogleApplicationProvider
implements ApplicationProvider {
    private final Cache cacheView;
    private final ObjectMapper objectMapper;

    @Autowired
    GoogleApplicationProvider(Cache cacheView, ObjectMapper objectMapper) {
        this.cacheView = cacheView;
        this.objectMapper = objectMapper;
    }

    public Set<? extends Application> getApplications(boolean expand) {
        RelationshipCacheFilter filter = expand ? RelationshipCacheFilter.include((String[])new String[]{Keys.Namespace.CLUSTERS.getNs()}) : RelationshipCacheFilter.none();
        Collection data = this.cacheView.getAll(Keys.Namespace.APPLICATIONS.getNs(), this.cacheView.filterIdentifiers(Keys.Namespace.APPLICATIONS.getNs(), GoogleCloudProvider.getID() + ":*"), (CacheFilter)filter);
        return data.stream().map(this::applicationFromCacheData).collect(Collectors.toSet());
    }

    @Nullable
    ApplicationCacheData getApplicationCacheData(String name) {
        CacheData cacheData = this.cacheView.get(Keys.Namespace.APPLICATIONS.getNs(), Keys.getApplicationKey(name), (CacheFilter)RelationshipCacheFilter.include((String[])new String[]{Keys.Namespace.CLUSTERS.getNs(), Keys.Namespace.INSTANCES.getNs()}));
        return this.getApplicationCacheData(cacheData);
    }

    private ApplicationCacheData getApplicationCacheData(CacheData cacheData) {
        if (cacheData == null) {
            return null;
        }
        return new ApplicationCacheData(cacheData.getAttributes(), this.getRelationships(cacheData, Keys.Namespace.CLUSTERS), this.getRelationships(cacheData, Keys.Namespace.INSTANCES));
    }

    public Application getApplication(String name) {
        return this.applicationFromCacheData(this.getApplicationCacheData(name));
    }

    private GoogleApplication.View applicationFromCacheData(CacheData cacheData) {
        return this.applicationFromCacheData(this.getApplicationCacheData(cacheData));
    }

    private GoogleApplication.View applicationFromCacheData(ApplicationCacheData applicationCacheData) {
        if (applicationCacheData == null) {
            return null;
        }
        GoogleApplication application = (GoogleApplication)this.objectMapper.convertValue(applicationCacheData.getApplicationAttributes(), GoogleApplication.class);
        if (application == null) {
            return null;
        }
        GoogleApplication.View applicationView = application.getView();
        Set<String> clusters = applicationCacheData.getClusterIdentifiers();
        clusters.forEach(key -> {
            Map<String, String> parsedKey = Keys.parse(key);
            applicationView.getClusterNames().get(parsedKey.get("account")).add(parsedKey.get("name"));
        });
        List<Map<String, String>> instances = applicationCacheData.getInstanceIdentifiers().stream().map(Keys::parse).collect(Collectors.toList());
        applicationView.setInstances(instances);
        return applicationView;
    }

    private Set<String> getRelationships(CacheData cacheData, Keys.Namespace namespace) {
        Collection relationships = (Collection)cacheData.getRelationships().get(namespace.getNs());
        return relationships == null ? Collections.emptySet() : new HashSet(relationships);
    }

    static final class ApplicationCacheData {
        private final Map<String, Object> applicationAttributes;
        private final Set<String> clusterIdentifiers;
        private final Set<String> instanceIdentifiers;

        @Generated
        public ApplicationCacheData(Map<String, Object> applicationAttributes, Set<String> clusterIdentifiers, Set<String> instanceIdentifiers) {
            this.applicationAttributes = applicationAttributes;
            this.clusterIdentifiers = clusterIdentifiers;
            this.instanceIdentifiers = instanceIdentifiers;
        }

        @Generated
        public Map<String, Object> getApplicationAttributes() {
            return this.applicationAttributes;
        }

        @Generated
        public Set<String> getClusterIdentifiers() {
            return this.clusterIdentifiers;
        }

        @Generated
        public Set<String> getInstanceIdentifiers() {
            return this.instanceIdentifiers;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationCacheData)) {
                return false;
            }
            ApplicationCacheData other = (ApplicationCacheData)o;
            Map<String, Object> this$applicationAttributes = this.getApplicationAttributes();
            Map<String, Object> other$applicationAttributes = other.getApplicationAttributes();
            if (this$applicationAttributes == null ? other$applicationAttributes != null : !((Object)this$applicationAttributes).equals(other$applicationAttributes)) {
                return false;
            }
            Set<String> this$clusterIdentifiers = this.getClusterIdentifiers();
            Set<String> other$clusterIdentifiers = other.getClusterIdentifiers();
            if (this$clusterIdentifiers == null ? other$clusterIdentifiers != null : !((Object)this$clusterIdentifiers).equals(other$clusterIdentifiers)) {
                return false;
            }
            Set<String> this$instanceIdentifiers = this.getInstanceIdentifiers();
            Set<String> other$instanceIdentifiers = other.getInstanceIdentifiers();
            return !(this$instanceIdentifiers == null ? other$instanceIdentifiers != null : !((Object)this$instanceIdentifiers).equals(other$instanceIdentifiers));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $applicationAttributes = this.getApplicationAttributes();
            result = result * 59 + ($applicationAttributes == null ? 43 : ((Object)$applicationAttributes).hashCode());
            Set<String> $clusterIdentifiers = this.getClusterIdentifiers();
            result = result * 59 + ($clusterIdentifiers == null ? 43 : ((Object)$clusterIdentifiers).hashCode());
            Set<String> $instanceIdentifiers = this.getInstanceIdentifiers();
            result = result * 59 + ($instanceIdentifiers == null ? 43 : ((Object)$instanceIdentifiers).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GoogleApplicationProvider.ApplicationCacheData(applicationAttributes=" + String.valueOf(this.getApplicationAttributes()) + ", clusterIdentifiers=" + String.valueOf(this.getClusterIdentifiers()) + ", instanceIdentifiers=" + String.valueOf(this.getInstanceIdentifiers()) + ")";
        }
    }
}

