/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.consul.provider.ConsulProviderUtils;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.model.GoogleCluster;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstance;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSecurityGroup;
import com.netflix.spinnaker.clouddriver.google.model.GoogleServerGroup;
import com.netflix.spinnaker.clouddriver.google.model.callbacks.Utils;
import com.netflix.spinnaker.clouddriver.google.model.health.GoogleLoadBalancerHealth;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalHttpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleInternalLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleLoadBalancerType;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleNetworkLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleSslLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.model.loadbalancing.GoogleTcpLoadBalancer;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleApplicationProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleInstanceProvider;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSecurityGroupProvider;
import com.netflix.spinnaker.clouddriver.model.ClusterProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoogleClusterProvider
implements ClusterProvider<GoogleCluster.View>,
GroovyObject {
    @Autowired
    private GoogleCloudProvider googleCloudProvider;
    @Autowired
    private Cache cacheView;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private GoogleApplicationProvider applicationProvider;
    @Autowired
    private GoogleInstanceProvider instanceProvider;
    @Autowired
    private GoogleSecurityGroupProvider securityGroupProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public GoogleClusterProvider() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Map<String, Set<GoogleCluster.View>> getClusters() {
        public final class _getClusters_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getClusters_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "accountName", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getClusters_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Keys.Namespace.class))), new _getClusters_closure1(this, this)));
    }

    public Map<String, Set<GoogleCluster.View>> getClusterDetails(String applicationName) {
        public final class _getClusterDetails_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getClusterDetails_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{k, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class, v)});
            }

            @Generated
            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getClusterDetails_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "getClusters", 2, this, applicationName, true), new _getClusterDetails_closure2(this, this)));
    }

    public Map<String, Set<GoogleCluster.View>> getClusterSummaries(String applicationName) {
        public final class _getClusterSummaries_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getClusterSummaries_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{k, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class, v)});
            }

            @Generated
            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getClusterSummaries_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "getClusters", 2, this, applicationName, false), new _getClusterSummaries_closure3(this, this)));
    }

    public Map<String, Set<GoogleCluster.View>> getClusters(String applicationName, boolean includeInstanceDetails) {
        CallSite applicationCacheData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getApplicationCacheData", 0, this.applicationProvider, applicationName));
        if (ScriptBytecodeAdapter.compareEqual((Object)applicationCacheData, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        }
        CallSite clusterIdentifiers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getClusterIdentifiers", 0, applicationCacheData));
        CallSite clusterCacheData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Keys.Namespace.class)), clusterIdentifiers, IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)))));
        CallSite instanceIdentifiers = IndyInterface.bootstrap("cast", "()", 0, includeInstanceDetails ? IndyInterface.bootstrap("invoke", "getInstanceIdentifiers", 0, applicationCacheData) : IndyInterface.bootstrap("invoke", "emptySet", 0, Collections.class));
        Reference instanceCacheData = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceCacheData", 0, this.instanceProvider, instanceIdentifiers)));
        Reference clustersByAccount = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class)));
        Reference securityGroupsByAccount = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class)));
        public final class _getClusters_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference securityGroupsByAccount;
            private /* synthetic */ Reference clustersByAccount;
            private /* synthetic */ Reference instanceCacheData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getClusters_closure4(Object _outerInstance, Object _thisObject, Reference securityGroupsByAccount, Reference clustersByAccount, Reference instanceCacheData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.securityGroupsByAccount = reference3 = securityGroupsByAccount;
                this.clustersByAccount = reference2 = clustersByAccount;
                this.instanceCacheData = reference = instanceCacheData;
            }

            public Object doCall(Object cacheData) {
                Reference accountName = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "getAttributes", 0, cacheData), "accountName")));
                public final class _closure31
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference accountName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure31(Object _outerInstance, Object _thisObject, Reference accountName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.accountName = reference = accountName;
                    }

                    public Object doCall(Object a) {
                        return IndyInterface.bootstrap("invoke", "getAllByAccount", 0, IndyInterface.bootstrap("getProperty", "securityGroupProvider", 12, this), false, IndyInterface.bootstrap("cast", "()", 0, this.accountName.get()));
                    }

                    @Generated
                    public String getAccountName() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.accountName.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure31.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite accountSecurityGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "computeIfAbsent", 0, IndyInterface.bootstrap("cast", "()", 0, this.securityGroupsByAccount.get()), (String)accountName.get(), new _closure31((Object)this, this.getThisObject(), accountName)));
                public final class _closure32
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure32(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object a) {
                        return IndyInterface.bootstrap("init", "<init>", 0, HashSet.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure32.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite accountClusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "computeIfAbsent", 0, IndyInterface.bootstrap("cast", "()", 0, this.clustersByAccount.get()), (String)accountName.get(), new _closure32((Object)this, this.getThisObject())));
                return IndyInterface.bootstrap("invoke", "add", 0, accountClusters, IndyInterface.bootstrap("invoke", "clusterFromCacheData", 2, this, cacheData, IndyInterface.bootstrap("cast", "()", 0, this.instanceCacheData.get()), accountSecurityGroups));
            }

            @Generated
            public Map getSecurityGroupsByAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.securityGroupsByAccount.get());
            }

            @Generated
            public Map getClustersByAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.clustersByAccount.get());
            }

            @Generated
            public Collection getInstanceCacheData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.instanceCacheData.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getClusters_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, clusterCacheData, new _getClusters_closure4(this, this, securityGroupsByAccount, clustersByAccount, instanceCacheData));
        return (Map)clustersByAccount.get();
    }

    public Set<GoogleCluster.View> getClusters(String applicationName, String account) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("invoke", "getClusterDetails", 2, this, applicationName), account));
    }

    public GoogleCluster.View getCluster(String application, String account, String name, boolean includeDetails) {
        CallSite callSite;
        CallSite clusterData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "getClusterKey", 0, Keys.class, account, application, name), IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Keys.Namespace.class)))));
        CallSite allClusterInstanceKeys = IndyInterface.bootstrap("cast", "()", 0, includeDetails ? (IndyInterface.bootstrap("cast", "()", 0, callSite = IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", "relationships", 1, clusterData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Keys.Namespace.class)))) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0])) : (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, clusterData) != false ? IndyInterface.bootstrap("invoke", "clusterFromCacheData", 2, this, clusterData, allClusterInstanceKeys) : null);
    }

    public GoogleCluster.View getCluster(String applicationName, String accountName, String clusterName) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCluster", 2, this, applicationName, accountName, clusterName, true));
    }

    public GoogleServerGroup.View getServerGroup(String account, String region, String name, boolean includeDetails) {
        CallSite cacheData = IndyInterface.bootstrap("invoke", "searchCacheForServerGroup", 2, this, IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, name, "*", account, region));
        if (IndyInterface.bootstrap("cast", "()", 0, cacheData) == false) {
            cacheData = IndyInterface.bootstrap("invoke", "searchCacheForServerGroup", 2, this, IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, name, "*", account, region, "*"));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, cacheData) != false) {
            CallSite securityGroups = IndyInterface.bootstrap("invoke", "getAllByAccount", 0, this.securityGroupProvider, false, account);
            CallSite callSite = IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", "relationships", 0, cacheData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Keys.Namespace.class)));
            CallSite instanceKeys = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            CallSite instances = IndyInterface.bootstrap("invoke", "getInstances", 0, this.instanceProvider, account, ScriptBytecodeAdapter.createPojoWrapper((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, instanceKeys, List.class))), List.class), securityGroups);
            CallSite loadBalancers = IndyInterface.bootstrap("invoke", "loadBalancersFromKeys", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, cacheData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class))), List.class))), List.class));
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "view", 1, IndyInterface.bootstrap("invoke", "serverGroupFromCacheData", 2, this, cacheData, account, instances, securityGroups, loadBalancers)));
        }
        return null;
    }

    private CacheData searchCacheForServerGroup(String pattern) {
        CallSite identifiers = IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), pattern);
        CallSite cacheDataResults = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), identifiers, IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Keys.Namespace.class))));
        if (IndyInterface.bootstrap("cast", "()", 0, cacheDataResults) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "first", 0, cacheDataResults));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public GoogleServerGroup.View getServerGroup(String account, String region, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerGroup", 2, this, account, region, name, true));
    }

    public String getCloudProviderId() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "id", 4, this.googleCloudProvider));
    }

    public boolean supportsMinimalClusters() {
        return false;
    }

    public GoogleCluster.View clusterFromCacheData(CacheData clusterCacheData, Set<String> instanceKeySuperSet) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clusterFromCacheData", 2, this, clusterCacheData, IndyInterface.bootstrap("invoke", "getInstanceCacheData", 0, this.instanceProvider, instanceKeySuperSet), IndyInterface.bootstrap("invoke", "getAllByAccount", 0, this.securityGroupProvider, false, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "getAttributes", 0, clusterCacheData), "accountName")), String.class))));
    }

    public GoogleCluster.View clusterFromCacheData(CacheData clusterCacheData, Collection<CacheData> instanceCacheDataSuperSet, Set<GoogleSecurityGroup> securityGroups) {
        Reference securityGroups2 = new Reference(securityGroups);
        Reference clusterView = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "view", 1, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, clusterCacheData), GoogleCluster.class))));
        CallSite serverGroupKeys = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterCacheData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)));
        if (IndyInterface.bootstrap("cast", "()", 0, serverGroupKeys) != false) {
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{serverGroupKeys}, new String[]{"Server group keys from cluster relationships: ", ""})) : null;
            CallSite filter = IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class)));
            CallSite serverGroupData = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), serverGroupKeys, filter);
            public final class _clusterFromCacheData_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _clusterFromCacheData_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("getProperty", "name", 1, IndyInterface.bootstrap("getProperty", "attributes", 1, it));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _clusterFromCacheData_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "collect", 1, serverGroupData, new _clusterFromCacheData_closure5(this, this))}, new String[]{"Retrieved cache data for server groups: ", ""})) : null;
            public final class _clusterFromCacheData_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference clusterView;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _clusterFromCacheData_closure6(Object _outerInstance, Object _thisObject, Reference clusterView) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.clusterView = reference = clusterView;
                }

                public Object doCall(Object instance) {
                    public final class _closure33
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure33(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("getProperty", "cluster", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, it));
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure33.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    public final class _closure34
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference clusterView;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure34(Object _outerInstance, Object _thisObject, Reference clusterView) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.clusterView = reference = clusterView;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "contains", 0, it, IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.clusterView.get())));
                        }

                        @Generated
                        public GoogleCluster.View getClusterView() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.clusterView.get());
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure34.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "any", 1, IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, instance), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Keys.Namespace.class))), new _closure33((Object)this, this.getThisObject())), new _closure34((Object)this, this.getThisObject(), this.clusterView));
                }

                @Generated
                public GoogleCluster.View getClusterView() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.clusterView.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _clusterFromCacheData_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite instanceCacheData = IndyInterface.bootstrap("invoke", "findAll", 0, instanceCacheDataSuperSet, new _clusterFromCacheData_closure6(this, this, clusterView));
            Reference instances = new Reference((Object)IndyInterface.bootstrap("invoke", "getInstancesFromCacheData", 0, this.instanceProvider, IndyInterface.bootstrap("getProperty", "accountName", 4, (GoogleCluster.View)clusterView.get()), instanceCacheData, (Set)securityGroups2.get()));
            public final class _clusterFromCacheData_closure7
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _clusterFromCacheData_closure7(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object serverGroup) {
                    return (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, serverGroup), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class))), List.class));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _clusterFromCacheData_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite loadBalancerKeys = IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "collect", 0, serverGroupData, new _clusterFromCacheData_closure7(this, this)));
            Reference loadBalancers = new Reference((Object)IndyInterface.bootstrap("invoke", "loadBalancersFromKeys", 2, this, ScriptBytecodeAdapter.createPojoWrapper((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, loadBalancerKeys, List.class))), List.class)));
            public final class _clusterFromCacheData_closure8
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference clusterView;
                private /* synthetic */ Reference instances;
                private /* synthetic */ Reference securityGroups;
                private /* synthetic */ Reference loadBalancers;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _clusterFromCacheData_closure8(Object _outerInstance, Object _thisObject, Reference clusterView, Reference instances, Reference securityGroups, Reference loadBalancers) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.clusterView = reference4 = clusterView;
                    this.instances = reference3 = instances;
                    this.securityGroups = reference2 = securityGroups;
                    this.loadBalancers = reference = loadBalancers;
                }

                public Object doCall(CacheData serverGroupCacheData) {
                    CallSite serverGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "serverGroupFromCacheData", 2, this, serverGroupCacheData, IndyInterface.bootstrap("getProperty", "accountName", 4, IndyInterface.bootstrap("cast", "()", 0, this.clusterView.get())), this.instances.get(), IndyInterface.bootstrap("cast", "()", 0, this.securityGroups.get()), this.loadBalancers.get()));
                    IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "serverGroups", 4, IndyInterface.bootstrap("cast", "()", 0, this.clusterView.get())), IndyInterface.bootstrap("getProperty", "view", 4, serverGroup));
                    return IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 4, IndyInterface.bootstrap("cast", "()", 0, this.clusterView.get())), IndyInterface.bootstrap("getProperty", "loadBalancers", 4, serverGroup));
                }

                @Generated
                public Object call(CacheData serverGroupCacheData) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, serverGroupCacheData);
                }

                @Generated
                public GoogleCluster.View getClusterView() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.clusterView.get());
                }

                @Generated
                public Object getInstances() {
                    return this.instances.get();
                }

                @Generated
                public Set getSecurityGroups() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.securityGroups.get());
                }

                @Generated
                public Object getLoadBalancers() {
                    return this.loadBalancers.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _clusterFromCacheData_closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, serverGroupData, new _clusterFromCacheData_closure8(this, this, clusterView, instances, securityGroups2, loadBalancers));
            public final class _clusterFromCacheData_closure9
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _clusterFromCacheData_closure9(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("getProperty", "name", 1, it);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _clusterFromCacheData_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("getProperty", "serverGroups", 5, (GoogleCluster.View)clusterView.get()), new _clusterFromCacheData_closure9(this, this))}, new String[]{"Server groups added to cluster: ", ""})) : null;
        }
        return (GoogleCluster.View)clusterView.get();
    }

    public Set<GoogleLoadBalancer> loadBalancersFromKeys(List<String> loadBalancerKeys) {
        public final class _loadBalancersFromKeys_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadBalancersFromKeys_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite loadBalancer = null;
                CallSite callSite = IndyInterface.bootstrap("invoke", "valueOf", 0, GoogleLoadBalancerType.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "type", 1, IndyInterface.bootstrap("getProperty", "attributes", 0, it)), String.class))), String.class));
                loadBalancer = ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "INTERNAL", 0, GoogleLoadBalancerType.class)) ? IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "attributes", 0, it), GoogleInternalLoadBalancer.class) : (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "HTTP", 0, GoogleLoadBalancerType.class)) ? IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "attributes", 0, it), GoogleHttpLoadBalancer.class) : (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "INTERNAL_MANAGED", 0, GoogleLoadBalancerType.class)) ? IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "attributes", 0, it), GoogleInternalHttpLoadBalancer.class) : (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "NETWORK", 0, GoogleLoadBalancerType.class)) ? IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "attributes", 0, it), GoogleNetworkLoadBalancer.class) : (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "SSL", 0, GoogleLoadBalancerType.class)) ? IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "attributes", 0, it), GoogleSslLoadBalancer.class) : (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "TCP", 0, GoogleLoadBalancerType.class)) ? IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "attributes", 0, it), GoogleTcpLoadBalancer.class) : null)))));
                return loadBalancer;
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadBalancersFromKeys_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class)), loadBalancerKeys), new _loadBalancersFromKeys_closure10(this, this)), Set.class));
    }

    public GoogleServerGroup serverGroupFromCacheData(CacheData cacheData, String account, List<GoogleInstance> instances, Set<GoogleSecurityGroup> securityGroups, Set<GoogleLoadBalancer> loadBalancers) {
        Reference loadBalancers2 = new Reference(loadBalancers);
        Reference serverGroup = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData), GoogleServerGroup.class)));
        String string = account;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, GoogleClusterProvider.class, (GroovyObject)((GoogleServerGroup)serverGroup.get()), (String)"account");
        Reference loadBalancerKeys = new Reference((Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, cacheData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class))));
        public final class _serverGroupFromCacheData_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancerKeys;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure11(Object _outerInstance, Object _thisObject, Reference loadBalancerKeys) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.loadBalancerKeys = reference = loadBalancerKeys;
            }

            public Object doCall(Object loadBalancer) {
                CallSite loadBalancerKey = IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "region", 0, loadBalancer), IndyInterface.bootstrap("getProperty", "account", 0, loadBalancer), IndyInterface.bootstrap("getProperty", "name", 0, loadBalancer));
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 1, this.loadBalancerKeys.get(), loadBalancerKey)) != false ? loadBalancer : null;
            }

            @Generated
            public Object getLoadBalancerKeys() {
                return this.loadBalancerKeys.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        loadBalancers2.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, (Set)loadBalancers2.get(), new _serverGroupFromCacheData_closure11(this, this, loadBalancerKeys))));
        Object object = ScriptBytecodeAdapter.getPropertySpreadSafe(GoogleClusterProvider.class, (Object)((Set)loadBalancers2.get()), (String)"view");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GoogleClusterProvider.class, (GroovyObject)((GoogleServerGroup)serverGroup.get()), (String)"loadBalancers");
        CallSite callSite = IndyInterface.bootstrap("invoke", "getMatchingSecurityGroupNames", 0, GoogleSecurityGroupProvider.class, account, securityGroups, IndyInterface.bootstrap("getProperty", "instanceTemplateTags", 4, (GoogleServerGroup)serverGroup.get()), IndyInterface.bootstrap("getProperty", "instanceTemplateServiceAccounts", 4, (GoogleServerGroup)serverGroup.get()), IndyInterface.bootstrap("getProperty", "networkName", 4, (GoogleServerGroup)serverGroup.get()));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, GoogleClusterProvider.class, (GroovyObject)((GoogleServerGroup)serverGroup.get()), (String)"securityGroups");
        if (IndyInterface.bootstrap("cast", "()", 0, instances) != false) {
            public final class _serverGroupFromCacheData_closure12
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference serverGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _serverGroupFromCacheData_closure12(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.serverGroup = reference = serverGroup;
                }

                public Object doCall(GoogleInstance instance) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "serverGroup", 4, instance), (Object)IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()))) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "region", 4, instance), (Object)IndyInterface.bootstrap("getProperty", "region", 4, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get())));
                }

                @Generated
                public Object call(GoogleInstance instance) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, instance);
                }

                @Generated
                public GoogleServerGroup getServerGroup() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure12.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "findAll", 0, instances, new _serverGroupFromCacheData_closure12(this, this, serverGroup));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, GoogleClusterProvider.class, (GroovyObject)((GoogleServerGroup)serverGroup.get()), (String)"instances");
            public final class _serverGroupFromCacheData_closure13
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancers;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _serverGroupFromCacheData_closure13(Object _outerInstance, Object _thisObject, Reference loadBalancers) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.loadBalancers = reference = loadBalancers;
                }

                public Object doCall(GoogleInstance instance) {
                    CallSite foundHealths = IndyInterface.bootstrap("invoke", "getLoadBalancerHealths", 2, this, IndyInterface.bootstrap("getProperty", "name", 4, instance), ScriptBytecodeAdapter.createPojoWrapper((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get()), List.class))), List.class));
                    if (IndyInterface.bootstrap("cast", "()", 0, foundHealths) != false) {
                        CallSite callSite = foundHealths;
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, _serverGroupFromCacheData_closure13.class, (GroovyObject)instance, (String)"loadBalancerHealths");
                        return callSite;
                    }
                    return null;
                }

                @Generated
                public Object call(GoogleInstance instance) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, instance);
                }

                @Generated
                public Set getLoadBalancers() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure13.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "instances", 4, (GoogleServerGroup)serverGroup.get()), new _serverGroupFromCacheData_closure13(this, this, loadBalancers2));
        }
        public final class _serverGroupFromCacheData_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure14(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, it), (Object)IndyInterface.bootstrap("getProperty", "INTERNAL", 0, GoogleLoadBalancerType.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite internalLoadBalancers = IndyInterface.bootstrap("invoke", "findAll", 0, (Set)loadBalancers2.get(), new _serverGroupFromCacheData_closure14(this, this));
        public final class _serverGroupFromCacheData_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure15(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object loadBalancer) {
                return IndyInterface.bootstrap("invoke", "determineInternalLoadBalancerDisabledState", 0, Utils.class, loadBalancer, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite internalDisabledStates = IndyInterface.bootstrap("invoke", "collect", 0, internalLoadBalancers, new _serverGroupFromCacheData_closure15(this, this, serverGroup));
        public final class _serverGroupFromCacheData_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure16(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, it), (Object)IndyInterface.bootstrap("getProperty", "HTTP", 0, GoogleLoadBalancerType.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite httpLoadBalancers = IndyInterface.bootstrap("invoke", "findAll", 0, (Set)loadBalancers2.get(), new _serverGroupFromCacheData_closure16(this, this));
        public final class _serverGroupFromCacheData_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure17(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object loadBalancer) {
                return IndyInterface.bootstrap("invoke", "determineHttpLoadBalancerDisabledState", 0, Utils.class, loadBalancer, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite httpDisabledStates = IndyInterface.bootstrap("invoke", "collect", 0, httpLoadBalancers, new _serverGroupFromCacheData_closure17(this, this, serverGroup));
        public final class _serverGroupFromCacheData_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure18(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, it), (Object)IndyInterface.bootstrap("getProperty", "INTERNAL_MANAGED", 0, GoogleLoadBalancerType.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite internalHttpLoadBalancers = IndyInterface.bootstrap("invoke", "findAll", 0, (Set)loadBalancers2.get(), new _serverGroupFromCacheData_closure18(this, this));
        public final class _serverGroupFromCacheData_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure19(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object loadBalancer) {
                return IndyInterface.bootstrap("invoke", "determineInternalHttpLoadBalancerDisabledState", 0, Utils.class, loadBalancer, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite internalHttpDisabledStates = IndyInterface.bootstrap("invoke", "collect", 0, internalHttpLoadBalancers, new _serverGroupFromCacheData_closure19(this, this, serverGroup));
        public final class _serverGroupFromCacheData_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure20(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, it), (Object)IndyInterface.bootstrap("getProperty", "SSL", 0, GoogleLoadBalancerType.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite sslLoadBalancers = IndyInterface.bootstrap("invoke", "findAll", 0, (Set)loadBalancers2.get(), new _serverGroupFromCacheData_closure20(this, this));
        public final class _serverGroupFromCacheData_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure21(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object loadBalancer) {
                return IndyInterface.bootstrap("invoke", "determineSslLoadBalancerDisabledState", 0, Utils.class, loadBalancer, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite sslDisabledStates = IndyInterface.bootstrap("invoke", "collect", 0, sslLoadBalancers, new _serverGroupFromCacheData_closure21(this, this, serverGroup));
        public final class _serverGroupFromCacheData_closure22
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure22(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, it), (Object)IndyInterface.bootstrap("getProperty", "TCP", 0, GoogleLoadBalancerType.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite tcpLoadBalancers = IndyInterface.bootstrap("invoke", "findAll", 0, (Set)loadBalancers2.get(), new _serverGroupFromCacheData_closure22(this, this));
        public final class _serverGroupFromCacheData_closure23
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroup;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure23(Object _outerInstance, Object _thisObject, Reference serverGroup) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.serverGroup = reference = serverGroup;
            }

            public Object doCall(Object loadBalancer) {
                return IndyInterface.bootstrap("invoke", "determineTcpLoadBalancerDisabledState", 0, Utils.class, loadBalancer, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()));
            }

            @Generated
            public GoogleServerGroup getServerGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite tcpDisabledStates = IndyInterface.bootstrap("invoke", "collect", 0, tcpLoadBalancers, new _serverGroupFromCacheData_closure23(this, this, serverGroup));
        public final class _serverGroupFromCacheData_closure24
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _serverGroupFromCacheData_closure24(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "consulNode", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("getProperty", "instances", 4, (GoogleServerGroup)serverGroup.get()), new _serverGroupFromCacheData_closure24(this, this));
        CallSite consulNodes = IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        CallSite consulDiscoverable = IndyInterface.bootstrap("invoke", "consulServerGroupDiscoverable", 0, ConsulProviderUtils.class, consulNodes);
        Object consulDisabled = false;
        if (IndyInterface.bootstrap("cast", "()", 0, consulDiscoverable) != false) {
            consulDisabled = IndyInterface.bootstrap("invoke", "serverGroupDisabled", 0, ConsulProviderUtils.class, consulNodes);
        }
        Object isDisabled = true;
        Boolean anyDisabledStates = DefaultTypeTransformation.booleanUnbox((Object)internalDisabledStates) || DefaultTypeTransformation.booleanUnbox((Object)httpDisabledStates) || DefaultTypeTransformation.booleanUnbox((Object)sslDisabledStates) || DefaultTypeTransformation.booleanUnbox((Object)tcpDisabledStates);
        Boolean disabledStatesSizeMatch = ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "size", 0, internalDisabledStates), IndyInterface.bootstrap("invoke", "size", 0, httpDisabledStates)), IndyInterface.bootstrap("invoke", "size", 0, sslDisabledStates)), IndyInterface.bootstrap("invoke", "size", 0, tcpDisabledStates)), (Object)IndyInterface.bootstrap("invoke", "size", 0, (Set)loadBalancers2.get()));
        Boolean excludesNetwork = DefaultTypeTransformation.booleanUnbox((Object)anyDisabledStates) && DefaultTypeTransformation.booleanUnbox((Object)disabledStatesSizeMatch);
        if (IndyInterface.bootstrap("cast", "()", 0, httpDisabledStates) != false) {
            public final class _serverGroupFromCacheData_closure25
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _serverGroupFromCacheData_closure25(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure25.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            isDisabled = IndyInterface.bootstrap("invoke", "and", 0, isDisabled, IndyInterface.bootstrap("invoke", "every", 0, httpDisabledStates, new _serverGroupFromCacheData_closure25(this, this)));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, internalDisabledStates) != false) {
            public final class _serverGroupFromCacheData_closure26
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _serverGroupFromCacheData_closure26(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure26.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            isDisabled = IndyInterface.bootstrap("invoke", "and", 0, isDisabled, IndyInterface.bootstrap("invoke", "every", 0, internalDisabledStates, new _serverGroupFromCacheData_closure26(this, this)));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, internalHttpDisabledStates) != false) {
            public final class _serverGroupFromCacheData_closure27
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _serverGroupFromCacheData_closure27(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure27.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            isDisabled = IndyInterface.bootstrap("invoke", "and", 0, isDisabled, IndyInterface.bootstrap("invoke", "every", 0, internalHttpDisabledStates, new _serverGroupFromCacheData_closure27(this, this)));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, sslDisabledStates) != false) {
            public final class _serverGroupFromCacheData_closure28
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _serverGroupFromCacheData_closure28(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure28.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            isDisabled = IndyInterface.bootstrap("invoke", "and", 0, isDisabled, IndyInterface.bootstrap("invoke", "every", 0, sslDisabledStates, new _serverGroupFromCacheData_closure28(this, this)));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, tcpDisabledStates) != false) {
            public final class _serverGroupFromCacheData_closure29
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _serverGroupFromCacheData_closure29(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return it;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _serverGroupFromCacheData_closure29.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            isDisabled = IndyInterface.bootstrap("invoke", "and", 0, isDisabled, IndyInterface.bootstrap("invoke", "every", 0, tcpDisabledStates, new _serverGroupFromCacheData_closure29(this, this)));
        }
        Object object2 = IndyInterface.bootstrap("cast", "()", 0, excludesNetwork) != false ? isDisabled : Boolean.valueOf(DefaultTypeTransformation.booleanUnbox((Object)isDisabled) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "disabled", 4, (GoogleServerGroup)serverGroup.get())));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, GoogleClusterProvider.class, (GroovyObject)((GoogleServerGroup)serverGroup.get()), (String)"disabled");
        if (IndyInterface.bootstrap("cast", "()", 0, consulDiscoverable) != false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, (Set)loadBalancers2.get()), (Object)0)) {
                boolean bl = true;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, GoogleClusterProvider.class, (GroovyObject)((GoogleServerGroup)serverGroup.get()), (String)"disabled");
            }
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)IndyInterface.bootstrap("invoke", "and", 0, IndyInterface.bootstrap("getProperty", "disabled", 4, (GoogleServerGroup)serverGroup.get()), consulDisabled), GoogleClusterProvider.class, (GroovyObject)((GoogleServerGroup)serverGroup.get()), (String)"disabled");
            boolean bl = true;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, GoogleClusterProvider.class, (GroovyObject)((GoogleServerGroup)serverGroup.get()), (String)"discovery");
        }
        return (GoogleServerGroup)serverGroup.get();
    }

    public static List<GoogleLoadBalancerHealth> getLoadBalancerHealths(String instanceName, List<GoogleLoadBalancer> loadBalancers) {
        Reference instanceName2 = new Reference((Object)instanceName);
        public final class _getLoadBalancerHealths_closure30
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instanceName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getLoadBalancerHealths_closure30(Object _outerInstance, Object _thisObject, Reference instanceName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.instanceName = reference = instanceName;
            }

            public Object doCall(List<GoogleLoadBalancerHealth> glbhs) {
                public final class _closure35
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instanceName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure35(Object _outerInstance, Object _thisObject, Reference instanceName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.instanceName = reference = instanceName;
                    }

                    public Object doCall(GoogleLoadBalancerHealth glbh) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "instanceName", 4, glbh), (Object)IndyInterface.bootstrap("cast", "()", 0, this.instanceName.get()));
                    }

                    @Generated
                    public Object call(GoogleLoadBalancerHealth glbh) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, glbh);
                    }

                    @Generated
                    public String getInstanceName() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.instanceName.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure35.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "findAll", 0, glbhs, new _closure35((Object)this, this.getThisObject(), this.instanceName));
            }

            @Generated
            public Object call(List<GoogleLoadBalancerHealth> glbhs) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, glbhs);
            }

            @Generated
            public String getInstanceName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.instanceName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLoadBalancerHealths_closure30.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "findResults", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(GoogleClusterProvider.class, loadBalancers, (String)"healths"), new _getLoadBalancerHealths_closure30(GoogleClusterProvider.class, GoogleClusterProvider.class, instanceName2))));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleClusterProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.google.provider.view.GoogleClusterProvider");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public GoogleCloudProvider getGoogleCloudProvider() {
        return this.googleCloudProvider;
    }

    @Generated
    public @VisibleForTesting void setGoogleCloudProvider(GoogleCloudProvider googleCloudProvider) {
        this.googleCloudProvider = googleCloudProvider;
    }

    @Generated
    public Cache getCacheView() {
        return this.cacheView;
    }

    @Generated
    public @VisibleForTesting void setCacheView(Cache cache) {
        this.cacheView = cache;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public @VisibleForTesting void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public GoogleApplicationProvider getApplicationProvider() {
        return this.applicationProvider;
    }

    @Generated
    public @VisibleForTesting void setApplicationProvider(GoogleApplicationProvider googleApplicationProvider) {
        this.applicationProvider = googleApplicationProvider;
    }

    @Generated
    public GoogleInstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }

    @Generated
    public @VisibleForTesting void setInstanceProvider(GoogleInstanceProvider googleInstanceProvider) {
        this.instanceProvider = googleInstanceProvider;
    }

    @Generated
    public GoogleSecurityGroupProvider getSecurityGroupProvider() {
        return this.securityGroupProvider;
    }

    @Generated
    public @VisibleForTesting void setSecurityGroupProvider(GoogleSecurityGroupProvider googleSecurityGroupProvider) {
        this.securityGroupProvider = googleSecurityGroupProvider;
    }
}

