/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutorTraits;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstance;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSecurityGroup;
import com.netflix.spinnaker.clouddriver.google.model.health.GoogleLoadBalancerHealth;
import com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSecurityGroupProvider;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.model.InstanceProvider;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoogleInstanceProvider
implements InstanceProvider<GoogleInstance.View, String>,
GoogleExecutorTraits,
GroovyObject {
    @Autowired
    private final Cache cacheView;
    @Autowired
    private AccountCredentialsProvider accountCredentialsProvider;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private GoogleSecurityGroupProvider securityGroupProvider;
    @Autowired
    private Registry registry;
    private final String cloudProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public GoogleInstanceProvider() {
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public GoogleInstance.View getInstance(String account, String region, String id) {
        Reference account2 = new Reference((Object)account);
        Reference securityGroups = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.securityGroupProvider, false)));
        CallSite key = IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, (String)account2.get(), region, id);
        public final class _getInstance_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference securityGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInstance_closure1(Object _outerInstance, Object _thisObject, Reference account, Reference securityGroups) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.account = reference2 = account;
                this.securityGroups = reference = securityGroups;
            }

            public Object doCall(CacheData cacheData) {
                return IndyInterface.bootstrap("getProperty", "view", 1, IndyInterface.bootstrap("invoke", "instanceFromCacheData", 2, this, cacheData, IndyInterface.bootstrap("cast", "()", 0, this.account.get()), IndyInterface.bootstrap("cast", "()", 0, this.securityGroups.get())));
            }

            @Generated
            public Object call(CacheData cacheData) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, cacheData);
            }

            @Generated
            public String getAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.account.get());
            }

            @Generated
            public Set getSecurityGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.securityGroups.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInstance_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResult", 1, IndyInterface.bootstrap("invoke", "getInstanceCacheData", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{key})), new _getInstance_closure1(this, this, account2, securityGroups)));
    }

    public List<GoogleInstance> getInstances(String account, List<String> instanceKeys, Set<GoogleSecurityGroup> securityGroups) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstancesFromCacheData", 2, this, account, IndyInterface.bootstrap("invoke", "getInstanceCacheData", 2, this, instanceKeys), securityGroups));
    }

    /*
     * WARNING - void declaration
     */
    public List<GoogleInstance> getInstancesFromCacheData(String account, Collection<CacheData> cacheData, Set<GoogleSecurityGroup> securityGroups) {
        void var3_3;
        Reference account2 = new Reference((Object)account);
        Reference securityGroups2 = new Reference((Object)var3_3);
        public final class _getInstancesFromCacheData_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference securityGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getInstancesFromCacheData_closure2(Object _outerInstance, Object _thisObject, Reference account, Reference securityGroups) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.account = reference2 = account;
                this.securityGroups = reference = securityGroups;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "instanceFromCacheData", 2, this, it, IndyInterface.bootstrap("cast", "()", 0, this.account.get()), IndyInterface.bootstrap("cast", "()", 0, this.securityGroups.get()));
            }

            @Generated
            public String getAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.account.get());
            }

            @Generated
            public Set getSecurityGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.securityGroups.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getInstancesFromCacheData_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 1, cacheData, new _getInstancesFromCacheData_closure2(this, this, account2, securityGroups2)));
    }

    public Collection<CacheData> getInstanceCacheData(Collection<String> keys) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Keys.Namespace.class)), keys, IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Keys.Namespace.class)))));
    }

    public String getConsoleOutput(String account, String region, String id) {
        CallSite accountCredentials = IndyInterface.bootstrap("invoke", "getCredentials", 0, this.accountCredentialsProvider, account);
        if (!(accountCredentials instanceof GoogleNamedAccountCredentials)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{account, region}, new String[]{"Invalid credentials: ", ":", ""})));
        }
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, accountCredentials);
        CallSite compute = IndyInterface.bootstrap("getProperty", "compute", 0, accountCredentials);
        CallSite googleInstance = IndyInterface.bootstrap("invoke", "getInstance", 2, this, account, region, id);
        if (IndyInterface.bootstrap("cast", "()", 0, googleInstance) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "contents", 0, IndyInterface.bootstrap("invoke", "timeExecute", 2, this, IndyInterface.bootstrap("invoke", "getSerialPortOutput", 0, IndyInterface.bootstrap("invoke", "instances", 0, compute), project, IndyInterface.bootstrap("getProperty", "zone", 0, googleInstance), id), "compute.instances.getSerialPortOutput", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 12, this), IndyInterface.bootstrap("getProperty", "SCOPE_ZONAL", 12, this), IndyInterface.bootstrap("getProperty", "TAG_ZONE", 12, this), IndyInterface.bootstrap("getProperty", "zone", 0, googleInstance))));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public GoogleInstance instanceFromCacheData(CacheData cacheData, String account, Set<GoogleSecurityGroup> securityGroups) {
        Reference instance = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData), GoogleInstance.class)));
        CallSite loadBalancerKeys = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, cacheData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class)));
        if (IndyInterface.bootstrap("cast", "()", 0, loadBalancerKeys) != false) {
            public final class _instanceFromCacheData_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference instance;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _instanceFromCacheData_closure3(Object _outerInstance, Object _thisObject, Reference instance) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.instance = reference = instance;
                }

                public Object doCall(CacheData loadBalancerCacheData) {
                    public final class _closure5
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference instance;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure5(Object _outerInstance, Object _thisObject, Reference instance) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.instance = reference = instance;
                        }

                        public Object doCall(Object health) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "instanceName", 0, health), (Object)IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.instance.get())));
                        }

                        @Generated
                        public GoogleInstance getInstance() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.instance.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure5.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    public final class _closure6
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure6(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), it, GoogleLoadBalancerHealth.class);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure6.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite foundHealths = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "healths", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, loadBalancerCacheData)), new _closure5((Object)this, this.getThisObject(), this.instance)), new _closure6((Object)this, this.getThisObject()));
                    if (IndyInterface.bootstrap("cast", "()", 0, foundHealths) != false) {
                        return IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("getProperty", "loadBalancerHealths", 4, IndyInterface.bootstrap("cast", "()", 0, this.instance.get())), foundHealths);
                    }
                    return null;
                }

                @Generated
                public Object call(CacheData loadBalancerCacheData) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, loadBalancerCacheData);
                }

                @Generated
                public GoogleInstance getInstance() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.instance.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _instanceFromCacheData_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Keys.Namespace.class)), loadBalancerKeys), new _instanceFromCacheData_closure3(this, this, instance));
        }
        public final class _instanceFromCacheData_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _instanceFromCacheData_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)"created-by");
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _instanceFromCacheData_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "value", 1, IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("getProperty", "items", 1, IndyInterface.bootstrap("getProperty", "metadata", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData))), new _instanceFromCacheData_closure4(this, this))));
        if (IndyInterface.bootstrap("cast", "()", 0, serverGroup) != false) {
            CallSite callSite = serverGroup;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, GoogleInstanceProvider.class, (GroovyObject)((GoogleInstance)instance.get()), (String)"serverGroup");
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "getMatchingSecurityGroupNames", 0, GoogleSecurityGroupProvider.class, account, securityGroups, ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "items", 0, IndyInterface.bootstrap("getProperty", "tags", 4, (GoogleInstance)instance.get())), Set.class))), Set.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "serviceAccounts", 4, (GoogleInstance)instance.get()), Set.class))), Set.class), IndyInterface.bootstrap("getProperty", "networkName", 4, (GoogleInstance)instance.get()));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, GoogleInstanceProvider.class, (GroovyObject)((GoogleInstance)instance.get()), (String)"securityGroups");
        return (GoogleInstance)instance.get();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleInstanceProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.google.provider.view.GoogleInstanceProvider");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final Cache getCacheView() {
        return this.cacheView;
    }

    @Generated
    public AccountCredentialsProvider getAccountCredentialsProvider() {
        return this.accountCredentialsProvider;
    }

    @Generated
    public @VisibleForTesting void setAccountCredentialsProvider(AccountCredentialsProvider accountCredentialsProvider) {
        this.accountCredentialsProvider = accountCredentialsProvider;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public @VisibleForTesting void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public GoogleSecurityGroupProvider getSecurityGroupProvider() {
        return this.securityGroupProvider;
    }

    @Generated
    public @VisibleForTesting void setSecurityGroupProvider(GoogleSecurityGroupProvider googleSecurityGroupProvider) {
        this.securityGroupProvider = googleSecurityGroupProvider;
    }

    @Override
    @Generated
    public Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public @VisibleForTesting void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }
}

