/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.iam.v1.model.ServiceAccount;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSecurityGroup;
import com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.model.AddressableRange;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupProvider;
import com.netflix.spinnaker.clouddriver.model.securitygroups.IpRangeRule;
import com.netflix.spinnaker.clouddriver.model.securitygroups.Rule;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoogleSecurityGroupProvider
implements SecurityGroupProvider<GoogleSecurityGroup>,
GroovyObject {
    private final CredentialsRepository<GoogleNamedAccountCredentials> credentialsRepository;
    private final Cache cacheView;
    private final ObjectMapper objectMapper;
    private final String cloudProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public GoogleSecurityGroupProvider(CredentialsRepository<GoogleNamedAccountCredentials> credentialsRepository, Cache cacheView, ObjectMapper objectMapper) {
        ObjectMapper objectMapper2;
        Cache cache;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        CredentialsRepository<GoogleNamedAccountCredentials> credentialsRepository2 = credentialsRepository;
        this.credentialsRepository = credentialsRepository2;
        this.cacheView = cache = cacheView;
        this.objectMapper = objectMapper2 = objectMapper;
    }

    public Set<GoogleSecurityGroup> getAll(boolean includeRules) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", "*", "*"), includeRules));
    }

    public Set<GoogleSecurityGroup> getAllByRegion(boolean includeRules, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", region, "*"), includeRules));
    }

    public Set<GoogleSecurityGroup> getAllByAccount(boolean includeRules, String account) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", "*", account), includeRules));
    }

    public Set<GoogleSecurityGroup> getAllByAccountAndName(boolean includeRules, String account, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, name, "*", "*", account), includeRules));
    }

    public Set<GoogleSecurityGroup> getAllByAccountAndRegion(boolean includeRules, String account, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", region, account), includeRules));
    }

    public GoogleSecurityGroup get(String account, String region, String name, String vpcId) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, name, "*", region, account), true), false));
    }

    public GoogleSecurityGroup getById(String account, String region, String id, String vpcId) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", id, region, account), true), false));
    }

    public Set<GoogleSecurityGroup> getAllMatchingKeyPattern(String pattern, boolean includeRules) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadResults", 2, this, includeRules, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), pattern)));
    }

    public Set<GoogleSecurityGroup> loadResults(boolean includeRules, Collection<String> identifiers) {
        CallSite transform = IndyInterface.bootstrap("invoke", "curry", 0, ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"fromCacheData"), includeRules);
        CallSite data = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), identifiers, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class));
        CallSite transformed = IndyInterface.bootstrap("invoke", "collect", 0, data, transform);
        return IndyInterface.bootstrap("cast", "()", 0, transformed);
    }

    public GoogleSecurityGroup fromCacheData(boolean includeRules, CacheData cacheData) {
        CallSite firewall = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "firewall", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData)));
        CallSite parts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, cacheData)));
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertToGoogleSecurityGroup", 2, this, includeRules, firewall, IndyInterface.bootstrap("getProperty", "account", 0, parts), IndyInterface.bootstrap("getProperty", "region", 0, parts), project));
    }

    private GoogleSecurityGroup convertToGoogleSecurityGroup(boolean includeRules, Map firewall, String account, String region, String project) {
        CallSite inboundRules = IndyInterface.bootstrap("cast", "()", 0, includeRules ? IndyInterface.bootstrap("invoke", "buildInboundIpRangeRules", 2, this, firewall) : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, GoogleSecurityGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", IndyInterface.bootstrap("invoke", "deriveResourceId", 2, this, project, IndyInterface.bootstrap("getProperty", "selfLink", 0, firewall)), "name", IndyInterface.bootstrap("getProperty", "name", 0, firewall), "description", IndyInterface.bootstrap("getProperty", "description", 0, firewall), "accountName", account, "region", region, "network", IndyInterface.bootstrap("invoke", "deriveResourceId", 2, this, project, IndyInterface.bootstrap("getProperty", "network", 0, firewall)), "selfLink", IndyInterface.bootstrap("getProperty", "selfLink", 0, firewall), "sourceTags", IndyInterface.bootstrap("getProperty", "sourceTags", 0, firewall), "targetTags", IndyInterface.bootstrap("getProperty", "targetTags", 0, firewall), "sourceServiceAccounts", IndyInterface.bootstrap("getProperty", "sourceServiceAccounts", 0, firewall), "targetServiceAccounts", IndyInterface.bootstrap("getProperty", "targetServiceAccounts", 0, firewall), "inboundRules", inboundRules})));
    }

    private List<Rule> buildInboundIpRangeRules(Map firewall) {
        Reference rangeRules = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _buildInboundIpRangeRules_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildInboundIpRangeRules_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object sourceRange) {
                List rangeParts = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "split", 0, sourceRange, "/"), List.class));
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, rangeParts), (Object)1)) {
                    IndyInterface.bootstrap("invoke", "leftShift", 0, rangeParts, "32");
                }
                return IndyInterface.bootstrap("init", "<init>", 0, AddressableRange.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ip", IndyInterface.bootstrap("invoke", "getAt", 0, rangeParts, false), "cidr", new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, rangeParts, true)}, new String[]{"/", ""})}));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInboundIpRangeRules_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference sourceRanges = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("getProperty", "sourceRanges", 0, firewall), new _buildInboundIpRangeRules_closure1(this, this))));
        public final class _buildInboundIpRangeRules_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildInboundIpRangeRules_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("init", "<init>", 0, HashSet.class);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInboundIpRangeRules_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference protocolToAllowedsMap = new Reference((Object)IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _buildInboundIpRangeRules_closure2(this, this)));
        public final class _buildInboundIpRangeRules_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference protocolToAllowedsMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildInboundIpRangeRules_closure3(Object _outerInstance, Object _thisObject, Reference protocolToAllowedsMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.protocolToAllowedsMap = reference = protocolToAllowedsMap;
            }

            public Object doCall(Object allowed) {
                return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("invoke", "getAt", 0, this.protocolToAllowedsMap.get(), IndyInterface.bootstrap("getProperty", "IPProtocol", 0, allowed)), allowed);
            }

            @Generated
            public Object getProtocolToAllowedsMap() {
                return this.protocolToAllowedsMap.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInboundIpRangeRules_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "allowed", 0, firewall), new _buildInboundIpRangeRules_closure3(this, this, protocolToAllowedsMap));
        public final class _buildInboundIpRangeRules_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sourceRanges;
            private /* synthetic */ Reference rangeRules;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildInboundIpRangeRules_closure4(Object _outerInstance, Object _thisObject, Reference sourceRanges, Reference rangeRules) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.sourceRanges = reference2 = sourceRanges;
                this.rangeRules = reference = rangeRules;
            }

            public Object doCall(String ipProtocol, Set<Map> allowedSet) {
                Reference ipProtocol2 = new Reference((Object)ipProtocol);
                Reference portRanges = new Reference((Object)((SortedSet)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), SortedSet.class))));
                public final class _closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference portRanges;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure6(Object _outerInstance, Object _thisObject, Reference portRanges) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.portRanges = reference = portRanges;
                    }

                    public Object doCall(Object allowed) {
                        public final class _closure8
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference portRanges;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure8(Object _outerInstance, Object _thisObject, Reference portRanges) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.portRanges = reference = portRanges;
                            }

                            public Object doCall(Object port) {
                                CallSite portRangeParts = IndyInterface.bootstrap("invoke", "split", 0, port, "-");
                                if (IndyInterface.bootstrap("cast", "()", 0, portRangeParts) != false) {
                                    CallSite portRange = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Rule.PortRange.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"startPort", IndyInterface.bootstrap("init", "<init>", 0, Integer.class, IndyInterface.bootstrap("invoke", "getAt", 0, portRangeParts, false))})));
                                    if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, portRangeParts), (Object)2)) {
                                        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, Integer.class, IndyInterface.bootstrap("invoke", "getAt", 0, portRangeParts, true));
                                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)portRange, (String)"endPort");
                                    } else {
                                        CallSite callSite = IndyInterface.bootstrap("getProperty", "startPort", 0, portRange);
                                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)portRange, (String)"endPort");
                                    }
                                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.portRanges.get()), portRange);
                                }
                                return null;
                            }

                            @Generated
                            public SortedSet getPortRanges() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.portRanges.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure8.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "each", 1, IndyInterface.bootstrap("getProperty", "ports", 0, allowed), new _closure8((Object)this, this.getThisObject(), this.portRanges));
                    }

                    @Generated
                    public SortedSet getPortRanges() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.portRanges.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, allowedSet, new _closure6((Object)this, this.getThisObject(), portRanges));
                if (IndyInterface.bootstrap("cast", "()", 0, (SortedSet)portRanges.get()) == false && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"tcp", "udp", "sctp"}), (String)ipProtocol2.get()))) {
                    IndyInterface.bootstrap("invoke", "leftShift", 0, (SortedSet)portRanges.get(), IndyInterface.bootstrap("init", "<init>", 0, Rule.PortRange.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"startPort", 1, "endPort", 65535})));
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.sourceRanges.get())) != false) {
                    public final class _closure7
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference rangeRules;
                        private /* synthetic */ Reference portRanges;
                        private /* synthetic */ Reference ipProtocol;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure7(Object _outerInstance, Object _thisObject, Reference rangeRules, Reference portRanges, Reference ipProtocol) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            this.rangeRules = reference3 = rangeRules;
                            this.portRanges = reference2 = portRanges;
                            this.ipProtocol = reference = ipProtocol;
                        }

                        public Object doCall(Object sourceRange) {
                            return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.rangeRules.get()), IndyInterface.bootstrap("init", "<init>", 0, IpRangeRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"range", sourceRange, "portRanges", IndyInterface.bootstrap("cast", "()", 0, this.portRanges.get()), "protocol", IndyInterface.bootstrap("cast", "()", 0, this.ipProtocol.get())})));
                        }

                        @Generated
                        public List getRangeRules() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.rangeRules.get());
                        }

                        @Generated
                        public SortedSet getPortRanges() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.portRanges.get());
                        }

                        @Generated
                        public String getIpProtocol() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.ipProtocol.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure7.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("cast", "()", 0, this.sourceRanges.get()), new _closure7((Object)this, this.getThisObject(), this.rangeRules, portRanges, ipProtocol2));
                }
                return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.rangeRules.get()), IndyInterface.bootstrap("init", "<init>", 0, IpRangeRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"range", IndyInterface.bootstrap("init", "<init>", 0, AddressableRange.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ip", "", "cidr", ""})), "portRanges", (SortedSet)portRanges.get(), "protocol", (String)ipProtocol2.get()})));
            }

            @Generated
            public Object call(String ipProtocol, Set<Map> allowedSet) {
                Reference ipProtocol2 = new Reference((Object)ipProtocol);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (String)ipProtocol2.get(), allowedSet);
            }

            @Generated
            public List getSourceRanges() {
                return IndyInterface.bootstrap("cast", "()", 0, this.sourceRanges.get());
            }

            @Generated
            public List getRangeRules() {
                return IndyInterface.bootstrap("cast", "()", 0, this.rangeRules.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildInboundIpRangeRules_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, protocolToAllowedsMap.get(), new _buildInboundIpRangeRules_closure4(this, this, sourceRanges, rangeRules));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sort", 0, (List)rangeRules.get()));
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getMatchingSecurityGroupNames(String account, Set<GoogleSecurityGroup> securityGroups, Set<String> tags, Set<ServiceAccount> serviceAccounts, String networkName) {
        void var3_3;
        void var2_2;
        Reference account2 = new Reference((Object)account);
        Reference tags2 = new Reference((Object)var2_2);
        Reference serviceAccounts2 = new Reference((Object)var3_3);
        Reference networkName2 = new Reference((Object)networkName);
        Set set = (Set)tags2.get();
        tags2.set((Object)(IndyInterface.bootstrap("cast", "()", 0, set) != false ? set : (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class))));
        Set set2 = (Set)serviceAccounts2.get();
        serviceAccounts2.set((Object)(IndyInterface.bootstrap("cast", "()", 0, set2) != false ? set2 : (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class))));
        public final class _getMatchingSecurityGroupNames_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference networkName;
            private /* synthetic */ Reference tags;
            private /* synthetic */ Reference serviceAccounts;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getMatchingSecurityGroupNames_closure5(Object _outerInstance, Object _thisObject, Reference account, Reference networkName, Reference tags, Reference serviceAccounts) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.account = reference4 = account;
                this.networkName = reference3 = networkName;
                this.tags = reference2 = tags;
                this.serviceAccounts = reference = serviceAccounts;
            }

            public Object doCall(GoogleSecurityGroup securityGroup) {
                Reference securityGroup2 = new Reference((Object)securityGroup);
                Boolean accountAndNetworkMatch = ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "accountName", 4, (GoogleSecurityGroup)securityGroup2.get()), (Object)IndyInterface.bootstrap("cast", "()", 0, this.account.get())) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "network", 4, (GoogleSecurityGroup)securityGroup2.get()), (Object)IndyInterface.bootstrap("cast", "()", 0, this.networkName.get()));
                if (IndyInterface.bootstrap("cast", "()", 0, accountAndNetworkMatch) == false) {
                    return null;
                }
                boolean hasTargetTags = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "targetTags", 4, (GoogleSecurityGroup)securityGroup2.get()));
                Object targetTagsInCommon = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                if (hasTargetTags) {
                    targetTagsInCommon = IndyInterface.bootstrap("invoke", "intersect", 0, IndyInterface.bootstrap("getProperty", "targetTags", 4, (GoogleSecurityGroup)securityGroup2.get()), IndyInterface.bootstrap("cast", "()", 0, this.tags.get()));
                }
                boolean hasTargetServiceAccounts = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "targetServiceAccounts", 4, (GoogleSecurityGroup)securityGroup2.get()));
                Reference targetServiceAccountsInCommon = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                public final class _closure9
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference securityGroup;
                    private /* synthetic */ Reference targetServiceAccountsInCommon;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure9(Object _outerInstance, Object _thisObject, Reference securityGroup, Reference targetServiceAccountsInCommon) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.securityGroup = reference2 = securityGroup;
                        this.targetServiceAccountsInCommon = reference = targetServiceAccountsInCommon;
                    }

                    public Object doCall(Object serviceAccount) {
                        if (ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "email", 0, serviceAccount), (Object)IndyInterface.bootstrap("getProperty", "targetServiceAccounts", 4, IndyInterface.bootstrap("cast", "()", 0, this.securityGroup.get())))) {
                            return IndyInterface.bootstrap("invoke", "add", 0, this.targetServiceAccountsInCommon.get(), IndyInterface.bootstrap("getProperty", "email", 0, serviceAccount));
                        }
                        return null;
                    }

                    @Generated
                    public GoogleSecurityGroup getSecurityGroup() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.securityGroup.get());
                    }

                    @Generated
                    public Object getTargetServiceAccountsInCommon() {
                        return this.targetServiceAccountsInCommon.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("cast", "()", 0, this.serviceAccounts.get()), new _closure9((Object)this, this.getThisObject(), securityGroup2, targetServiceAccountsInCommon));
                boolean isDefaultFirewallRule = !hasTargetTags && !hasTargetServiceAccounts;
                return isDefaultFirewallRule || DefaultTypeTransformation.booleanUnbox((Object)targetTagsInCommon) || DefaultTypeTransformation.booleanUnbox((Object)targetServiceAccountsInCommon.get()) ? IndyInterface.bootstrap("getProperty", "name", 4, (GoogleSecurityGroup)securityGroup2.get()) : null;
            }

            @Generated
            public Object call(GoogleSecurityGroup securityGroup) {
                Reference securityGroup2 = new Reference((Object)securityGroup);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (GoogleSecurityGroup)securityGroup2.get());
            }

            @Generated
            public String getAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.account.get());
            }

            @Generated
            public String getNetworkName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.networkName.get());
            }

            @Generated
            public Set getTags() {
                return IndyInterface.bootstrap("cast", "()", 0, this.tags.get());
            }

            @Generated
            public Set getServiceAccounts() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serviceAccounts.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMatchingSecurityGroupNames_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "findResults", 1, securityGroups, new _getMatchingSecurityGroupNames_closure5(GoogleSecurityGroupProvider.class, GoogleSecurityGroupProvider.class, account2, networkName2, tags2, serviceAccounts2));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    private String deriveResourceId(String project, String resourceLink) {
        CallSite firewallProject = IndyInterface.bootstrap("invoke", "deriveProjectId", 0, GCEUtil.class, resourceLink);
        CallSite firewallId = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, resourceLink);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)firewallProject, (Object)project)) {
            firewallId = new GStringImpl(new Object[]{firewallProject, firewallId}, new String[]{"", "/", ""});
        }
        return IndyInterface.bootstrap("cast", "()", 0, firewallId);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleSecurityGroupProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.google.provider.view.GoogleSecurityGroupProvider");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }
}

