/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.cache.Keys;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleSubnet;
import com.netflix.spinnaker.clouddriver.model.SubnetProvider;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoogleSubnetProvider
implements SubnetProvider<GoogleSubnet>,
GroovyObject {
    private final AccountCredentialsProvider accountCredentialsProvider;
    private final Cache cacheView;
    private final ObjectMapper objectMapper;
    private final String cloudProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public GoogleSubnetProvider(AccountCredentialsProvider accountCredentialsProvider, Cache cacheView, ObjectMapper objectMapper) {
        ObjectMapper objectMapper2;
        Cache cache;
        AccountCredentialsProvider accountCredentialsProvider2;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.accountCredentialsProvider = accountCredentialsProvider2 = accountCredentialsProvider;
        this.cacheView = cache = cacheView;
        this.objectMapper = objectMapper2 = objectMapper;
    }

    public Set<GoogleSubnet> getAll() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSubnetKey", 0, Keys.class, "*", "*", "*")));
    }

    public Set<GoogleSubnet> getAllMatchingKeyPattern(String pattern) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadResults", 2, this, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SUBNETS", 0, Keys.Namespace.class)), pattern)));
    }

    public Set<GoogleSubnet> loadResults(Collection<String> identifiers) {
        CallSite data = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SUBNETS", 0, Keys.Namespace.class)), identifiers, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class));
        CallSite transformed = IndyInterface.bootstrap("invoke", "collect", 0, data, ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"fromCacheData"));
        return IndyInterface.bootstrap("cast", "()", 0, transformed);
    }

    public GoogleSubnet fromCacheData(CacheData cacheData) {
        CallSite callSite;
        CallSite subnet = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnet", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData)));
        CallSite parts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, cacheData)));
        CallSite project = IndyInterface.bootstrap("getProperty", "project", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, GoogleSubnet.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"type", this.cloudProvider, "id", IndyInterface.bootstrap("getProperty", "id", 0, parts), "name", IndyInterface.bootstrap("getProperty", "name", 0, subnet), "gatewayAddress", IndyInterface.bootstrap("getProperty", "gatewayAddress", 0, subnet), "network", IndyInterface.bootstrap("invoke", "deriveNetworkId", 2, this, project, subnet), "cidrBlock", IndyInterface.bootstrap("getProperty", "ipCidrRange", 0, subnet), "account", IndyInterface.bootstrap("getProperty", "account", 0, parts), "region", IndyInterface.bootstrap("getProperty", "region", 0, parts), "selfLink", IndyInterface.bootstrap("getProperty", "selfLink", 0, subnet), "purpose", IndyInterface.bootstrap("cast", "()", 0, callSite = IndyInterface.bootstrap("getProperty", "purpose", 0, subnet)) != false ? callSite : "n/a"})));
    }

    private String deriveNetworkId(String project, Map subnet) {
        CallSite networkProject = IndyInterface.bootstrap("invoke", "deriveProjectId", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "network", 0, subnet));
        CallSite networkId = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, IndyInterface.bootstrap("getProperty", "network", 0, subnet));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)networkProject, (Object)project)) {
            networkId = new GStringImpl(new Object[]{networkProject, networkId}, new String[]{"", "/", ""});
        }
        return IndyInterface.bootstrap("cast", "()", 0, networkId);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GoogleSubnetProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }
}

