/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.google.security;

import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AcceleratorTypeAggregatedList;
import com.google.api.services.compute.model.MachineTypeAggregatedList;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.RegionList;
import com.google.api.services.compute.model.Zone;
import com.google.api.services.compute.model.ZoneList;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.consul.config.ConsulConfig;
import com.netflix.spinnaker.clouddriver.google.ComputeVersion;
import com.netflix.spinnaker.clouddriver.google.GoogleCloudProvider;
import com.netflix.spinnaker.clouddriver.google.GoogleExecutor;
import com.netflix.spinnaker.clouddriver.google.deploy.GCEUtil;
import com.netflix.spinnaker.clouddriver.google.model.GoogleInstanceTypeDisk;
import com.netflix.spinnaker.clouddriver.google.model.GoogleLabeledResource;
import com.netflix.spinnaker.clouddriver.google.security.AccountForClient;
import com.netflix.spinnaker.clouddriver.google.security.GoogleCredentials;
import com.netflix.spinnaker.clouddriver.google.security.GoogleImpersonatedServiceAccountCredentials;
import com.netflix.spinnaker.clouddriver.google.security.GoogleJsonCredentials;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.clouddriver.security.AbstractAccountCredentials;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import com.netflix.spinnaker.kork.client.ServiceClientProvider;
import com.netflix.spinnaker.moniker.Namer;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleNamedAccountCredentials
extends AbstractAccountCredentials<GoogleCredentials>
implements GroovyObject {
    private static final List<String> SORTED_CPU_PLATFORMS;
    public static final String CREDENTIALS_TYPE = "gce";
    private final String name;
    private final String environment;
    private final String accountType;
    private final String cloudProvider;
    private final List<String> requiredGroupMembership;
    private final Permissions permissions;
    private final GoogleCredentials credentials;
    private final String project;
    private final String xpnHostProject;
    private final String applicationName;
    private final List<String> imageProjects;
    private final ComputeVersion computeVersion;
    private final Map<String, List<String>> regionToZonesMap;
    private final Map<String, Map> locationToInstanceTypesMap;
    private final Map<String, List<String>> locationToCpuPlatformsMap;
    private final List<GoogleInstanceTypeDisk> instanceTypeDisks;
    private final ConsulConfig consulConfig;
    private final Compute compute;
    private final String userDataFile;
    private final List<String> regionsToManage;
    private final Map<String, Map> zoneToAcceleratorTypesMap;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks, ConsulConfig consulConfig, Compute compute, String userDataFile, List<String> regionsToManage, Map<String, Map> zoneToAcceleratorTypesMap) {
        String string;
        Compute compute2;
        ConsulConfig consulConfig2;
        ComputeVersion computeVersion2;
        String string2;
        String string3;
        String string4;
        GoogleCredentials googleCredentials;
        Permissions permissions2;
        String string5;
        String string6;
        String string7;
        String string8;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.name = string8 = name;
        this.environment = string7 = environment;
        this.accountType = string6 = accountType;
        this.cloudProvider = string5 = cloudProvider;
        List<String> list = requiredGroupMembership;
        this.requiredGroupMembership = list;
        this.permissions = permissions2 = permissions;
        this.credentials = googleCredentials = credentials;
        this.project = string4 = project;
        this.xpnHostProject = string3 = xpnHostProject;
        this.applicationName = string2 = applicationName;
        List<String> list2 = imageProjects;
        this.imageProjects = list2;
        this.computeVersion = computeVersion2 = computeVersion;
        Map<String, List<String>> map = regionToZonesMap;
        this.regionToZonesMap = map;
        Map<String, Map> map2 = locationToInstanceTypesMap;
        this.locationToInstanceTypesMap = map2;
        Map<String, List<String>> map3 = locationToCpuPlatformsMap;
        this.locationToCpuPlatformsMap = map3;
        List<GoogleInstanceTypeDisk> list3 = instanceTypeDisks;
        this.instanceTypeDisks = list3;
        this.consulConfig = consulConfig2 = consulConfig;
        this.compute = compute2 = compute;
        this.userDataFile = string = userDataFile;
        List<String> list4 = regionsToManage;
        this.regionsToManage = list4;
        Map<String, Map> map4 = zoneToAcceleratorTypesMap;
        this.zoneToAcceleratorTypesMap = map4;
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks, ConsulConfig consulConfig, Compute compute, String userDataFile, List<String> regionsToManage) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, instanceTypeDisks, consulConfig, compute, userDataFile, regionsToManage, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks, ConsulConfig consulConfig, Compute compute, String userDataFile) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, instanceTypeDisks, consulConfig, compute, userDataFile, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks, ConsulConfig consulConfig, Compute compute) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, instanceTypeDisks, consulConfig, compute, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks, ConsulConfig consulConfig) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, instanceTypeDisks, consulConfig, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap, List<GoogleInstanceTypeDisk> instanceTypeDisks) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, instanceTypeDisks, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> locationToCpuPlatformsMap) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, locationToCpuPlatformsMap, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap, Map<String, Map> locationToInstanceTypesMap) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, locationToInstanceTypesMap, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion, Map<String, List<String>> regionToZonesMap) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, regionToZonesMap, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects, ComputeVersion computeVersion) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, computeVersion, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName, List<String> imageProjects) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, imageProjects, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject, String applicationName) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, applicationName, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project, String xpnHostProject) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, xpnHostProject, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials, String project) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, project, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions, GoogleCredentials credentials) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, credentials, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership, Permissions permissions) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, permissions, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider, List<String> requiredGroupMembership) {
        this(name, environment, accountType, cloudProvider, requiredGroupMembership, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType, String cloudProvider) {
        this(name, environment, accountType, cloudProvider, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment, String accountType) {
        this(name, environment, accountType, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class))), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name, String environment) {
        this(name, environment, null, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class))), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials(String name) {
        this(name, null, null, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class))), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    @Generated
    public GoogleNamedAccountCredentials() {
        this(null, null, null, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class))), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public List<Map> getRegions() {
        Reference regionList = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        if (ScriptBytecodeAdapter.compareNotEqual(this.regionsToManage, null)) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, this.regionsToManage)) == false) {
                public final class _getRegions_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _getRegions_closure1(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "regionsToManage", 12, this), IndyInterface.bootstrap("invoke", "getKey", 0, it));
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getRegions_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _getRegions_closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference regionList;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _getRegions_closure2(Object _outerInstance, Object _thisObject, Reference regionList) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.regionList = reference = regionList;
                    }

                    public Object doCall(String region, List<String> zones) {
                        return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.regionList.get()), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", region, "zones", zones}));
                    }

                    @Generated
                    public Object call(String region, List<String> zones) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, region, zones);
                    }

                    @Generated
                    public List getRegionList() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.regionList.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getRegions_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.regionToZonesMap, new _getRegions_closure1((Object)this, (Object)this)), new _getRegions_closure2((Object)this, (Object)this, regionList));
            }
        } else {
            public final class _getRegions_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference regionList;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getRegions_closure3(Object _outerInstance, Object _thisObject, Reference regionList) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.regionList = reference = regionList;
                }

                public Object doCall(String region, List<String> zones) {
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.regionList.get()), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", region, "zones", zones}));
                }

                @Generated
                public Object call(String region, List<String> zones) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, region, zones);
                }

                @Generated
                public List getRegionList() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.regionList.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getRegions_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, this.regionToZonesMap, new _getRegions_closure3((Object)this, (Object)this, regionList));
        }
        return (List)regionList.get();
    }

    public String regionFromZone(String zone) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "regionFromZone", 0, GoogleNamedAccountCredentials.class, zone, this.regionToZonesMap));
    }

    public static String regionFromZone(String zone, Map<String, List<String>> regionToZonesMap) {
        if (ScriptBytecodeAdapter.compareEqual((Object)zone, null) || ScriptBytecodeAdapter.compareEqual(regionToZonesMap, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite region = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "keySet", 0, regionToZonesMap)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                region = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "get", 0, regionToZonesMap, region), zone)) == false) continue;
                return region;
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public List<String> getZonesFromRegion(String region) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.compareNotEqual((Object)region, null) && ScriptBytecodeAdapter.compareNotEqual(this.regionToZonesMap, null) ? IndyInterface.bootstrap("invoke", "get", 0, this.regionToZonesMap, region) : null);
    }

    private static Map<String, List<String>> queryRegions(Compute compute, String project) {
        CallSite regionList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchRegions", 0, GoogleNamedAccountCredentials.class, compute, project));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertRegionListToMap", 0, GoogleNamedAccountCredentials.class, regionList));
    }

    @VisibleForTesting
    public static Map<String, List<String>> convertRegionListToMap(RegionList regionList) {
        public final class _convertRegionListToMap_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _convertRegionListToMap_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Region region) {
                public final class _closure12
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure12(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(String zone) {
                        return IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, zone);
                    }

                    @Generated
                    public Object call(String zone) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, zone);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, region), IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "zones", 0, region), new _closure12((Object)this, this.getThisObject()))});
            }

            @Generated
            public Object call(Region region) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, region);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertRegionListToMap_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("getProperty", "items", 0, regionList), new _convertRegionListToMap_closure4(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class)));
    }

    private static RegionList fetchRegions(Compute compute, String project) {
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 0, GoogleExecutor.class, IndyInterface.bootstrap("invoke", "getRegistry", 0, GoogleExecutor.class), IndyInterface.bootstrap("invoke", "list", 0, IndyInterface.bootstrap("invoke", "regions", 0, compute), project), "google.api", "compute.regions.list", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 0, GoogleExecutor.class)));
        try {
            return callSite;
        }
        catch (IOException ioe) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, RuntimeException.class, IndyInterface.bootstrap("invoke", "plus", 0, "Failed loading regions for ", project), ioe));
        }
    }

    private static Map<String, Map> queryAcceleratorTypes(Compute compute, String project) {
        CallSite acceleratorTypeList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 0, GoogleExecutor.class, IndyInterface.bootstrap("invoke", "getRegistry", 0, GoogleExecutor.class), IndyInterface.bootstrap("invoke", "aggregatedList", 0, IndyInterface.bootstrap("invoke", "acceleratorTypes", 0, compute), project), "google.api", "compute.acceleratorTypes.aggregatedList", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 0, GoogleExecutor.class)));
        CallSite nextPageToken = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getNextPageToken", 0, acceleratorTypeList));
        Reference zoneToAcceleratorTypesMap = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertAcceleratorTypeListToMap", 0, GoogleNamedAccountCredentials.class, acceleratorTypeList)));
        while (IndyInterface.bootstrap("cast", "()", 0, nextPageToken) != false) {
            acceleratorTypeList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 0, GoogleExecutor.class, IndyInterface.bootstrap("invoke", "getRegistry", 0, GoogleExecutor.class), IndyInterface.bootstrap("invoke", "aggregatedList", 0, IndyInterface.bootstrap("invoke", "acceleratorTypes", 0, compute), project), "google.api", "compute.acceleratorTypes.aggregatedList", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 0, GoogleExecutor.class)));
            nextPageToken = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getNextPageToken", 0, acceleratorTypeList));
            CallSite subsequentZoneToInstanceTypesMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertAcceleratorTypeListToMap", 0, GoogleNamedAccountCredentials.class, acceleratorTypeList));
            public final class _queryAcceleratorTypes_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference zoneToAcceleratorTypesMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _queryAcceleratorTypes_closure5(Object _outerInstance, Object _thisObject, Reference zoneToAcceleratorTypesMap) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.zoneToAcceleratorTypesMap = reference = zoneToAcceleratorTypesMap;
                }

                public Object doCall(Object zone, Object acceleratorTypes) {
                    if (ScriptBytecodeAdapter.isCase((Object)zone, (Object)IndyInterface.bootstrap("cast", "()", 0, this.zoneToAcceleratorTypesMap.get()))) {
                        CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "acceleratorTypes", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.zoneToAcceleratorTypesMap.get()), zone)), IndyInterface.bootstrap("getProperty", "acceleratorTypes", 0, acceleratorTypes));
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.zoneToAcceleratorTypesMap.get()), zone), (String)"acceleratorTypes");
                        return callSite;
                    }
                    Object object = acceleratorTypes;
                    IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.zoneToAcceleratorTypesMap.get()), zone, object);
                    return object;
                }

                @Generated
                public Object call(Object zone, Object acceleratorTypes) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, zone, acceleratorTypes);
                }

                @Generated
                public Map getZoneToAcceleratorTypesMap() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.zoneToAcceleratorTypesMap.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _queryAcceleratorTypes_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, subsequentZoneToInstanceTypesMap, new _queryAcceleratorTypes_closure5(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class, zoneToAcceleratorTypesMap));
        }
        return (Map)zoneToAcceleratorTypesMap.get();
    }

    private static Map<String, Map> queryInstanceTypes(Compute compute, String project, Map<String, List<String>> regionToZonesMap) {
        CallSite instanceTypeList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 0, GoogleExecutor.class, IndyInterface.bootstrap("invoke", "getRegistry", 0, GoogleExecutor.class), IndyInterface.bootstrap("invoke", "aggregatedList", 0, IndyInterface.bootstrap("invoke", "machineTypes", 0, compute), project), "google.api", "compute.machineTypes.aggregatedList", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 0, GoogleExecutor.class)));
        CallSite nextPageToken = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getNextPageToken", 0, instanceTypeList));
        Reference zoneToInstanceTypesMap = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertInstanceTypeListToMap", 0, GoogleNamedAccountCredentials.class, instanceTypeList)));
        while (IndyInterface.bootstrap("cast", "()", 0, nextPageToken) != false) {
            instanceTypeList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 0, GoogleExecutor.class, IndyInterface.bootstrap("invoke", "getRegistry", 0, GoogleExecutor.class), IndyInterface.bootstrap("invoke", "setPageToken", 0, IndyInterface.bootstrap("invoke", "aggregatedList", 0, IndyInterface.bootstrap("invoke", "machineTypes", 0, compute), project), nextPageToken), "google.api", "compute.machineTypes.aggregatedList", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 0, GoogleExecutor.class)));
            nextPageToken = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getNextPageToken", 0, instanceTypeList));
            CallSite subsequentZoneToInstanceTypesMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertInstanceTypeListToMap", 0, GoogleNamedAccountCredentials.class, instanceTypeList));
            public final class _queryInstanceTypes_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference zoneToInstanceTypesMap;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _queryInstanceTypes_closure6(Object _outerInstance, Object _thisObject, Reference zoneToInstanceTypesMap) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.zoneToInstanceTypesMap = reference = zoneToInstanceTypesMap;
                }

                public Object doCall(Object zone, Object instanceTypes) {
                    if (ScriptBytecodeAdapter.isCase((Object)zone, (Object)IndyInterface.bootstrap("cast", "()", 0, this.zoneToInstanceTypesMap.get()))) {
                        ScriptBytecodeAdapter.setProperty((Object)IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "instanceTypes", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.zoneToInstanceTypesMap.get()), zone)), IndyInterface.bootstrap("getProperty", "instanceTypes", 0, instanceTypes)), null, (Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.zoneToInstanceTypesMap.get()), zone), (String)"instanceTypes");
                        CallSite callSite = IndyInterface.bootstrap("invoke", "max", 0, Math.class, IndyInterface.bootstrap("getProperty", "vCpuMax", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.zoneToInstanceTypesMap.get()), zone)), IndyInterface.bootstrap("getProperty", "vCpuMax", 0, instanceTypes));
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.zoneToInstanceTypesMap.get()), zone), (String)"vCpuMax");
                        return callSite;
                    }
                    Object object = instanceTypes;
                    IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.zoneToInstanceTypesMap.get()), zone, object);
                    return object;
                }

                @Generated
                public Object call(Object zone, Object instanceTypes) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, zone, instanceTypes);
                }

                @Generated
                public Map getZoneToInstanceTypesMap() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.zoneToInstanceTypesMap.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _queryInstanceTypes_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, subsequentZoneToInstanceTypesMap, new _queryInstanceTypes_closure6(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class, zoneToInstanceTypesMap));
        }
        IndyInterface.bootstrap("invoke", "populateRegionInstanceTypes", 0, GoogleNamedAccountCredentials.class, (Map)zoneToInstanceTypesMap.get(), regionToZonesMap);
        return (Map)zoneToInstanceTypesMap.get();
    }

    public static Map<String, Map> convertAcceleratorTypeListToMap(AcceleratorTypeAggregatedList acceleratorTypeList) {
        public final class _convertAcceleratorTypeListToMap_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _convertAcceleratorTypeListToMap_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object zone, Object acceleratorTypesScopedList) {
                zone = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, zone);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "acceleratorTypes", 0, acceleratorTypesScopedList)) != false) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{zone, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"acceleratorTypes", acceleratorTypesScopedList})});
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            }

            @Generated
            public Object call(Object zone, Object acceleratorTypesScopedList) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, zone, acceleratorTypesScopedList);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertAcceleratorTypeListToMap_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite zoneToAcceleratorTypesMap = IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("getProperty", "items", 0, acceleratorTypeList), new _convertAcceleratorTypeListToMap_closure7(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class));
        return IndyInterface.bootstrap("cast", "()", 0, zoneToAcceleratorTypesMap);
    }

    @VisibleForTesting
    public static Map<String, Map> convertInstanceTypeListToMap(MachineTypeAggregatedList instanceTypeList) {
        public final class _convertInstanceTypeListToMap_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _convertInstanceTypeListToMap_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object zone, Object machineTypesScopedList) {
                zone = IndyInterface.bootstrap("invoke", "getLocalName", 0, GCEUtil.class, zone);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "machineTypes", 0, machineTypesScopedList)) != false) {
                    public final class _closure13
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure13(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("getProperty", "name", 0, it);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure13.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    public final class _closure14
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure14(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("getProperty", "guestCpus", 0, it);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure14.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{zone, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceTypes", IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "machineTypes", 0, machineTypesScopedList), new _closure13((Object)this, this.getThisObject())), "vCpuMax", IndyInterface.bootstrap("getProperty", "guestCpus", 0, IndyInterface.bootstrap("invoke", "max", 0, IndyInterface.bootstrap("getProperty", "machineTypes", 0, machineTypesScopedList), new _closure14((Object)this, this.getThisObject())))})});
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            }

            @Generated
            public Object call(Object zone, Object machineTypesScopedList) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, zone, machineTypesScopedList);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _convertInstanceTypeListToMap_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite zoneToInstanceTypesMap = IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("getProperty", "items", 0, instanceTypeList), new _convertInstanceTypeListToMap_closure8(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class));
        return IndyInterface.bootstrap("cast", "()", 0, zoneToInstanceTypesMap);
    }

    public static void populateRegionInstanceTypes(Map<String, Map> locationToInstanceTypesMap, Map<String, List<String>> regionToZonesMap) {
        Reference locationToInstanceTypesMap2 = new Reference(locationToInstanceTypesMap);
        public final class _populateRegionInstanceTypes_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference locationToInstanceTypesMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _populateRegionInstanceTypes_closure9(Object _outerInstance, Object _thisObject, Reference locationToInstanceTypesMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.locationToInstanceTypesMap = reference = locationToInstanceTypesMap;
            }

            public Object doCall(Object region, Object zoneNames) {
                Reference zoneNames2 = new Reference(zoneNames);
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, zoneNames2.get()), (Object)3)) {
                    zoneNames2.set((Object)IndyInterface.bootstrap("invoke", "drop", 0, IndyInterface.bootstrap("invoke", "sort", 0, zoneNames2.get()), IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "size", 0, zoneNames2.get()), 3)));
                }
                public final class _closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference zoneNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure15(Object _outerInstance, Object _thisObject, Reference zoneNames) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.zoneNames = reference = zoneNames;
                    }

                    public Object doCall(Object zone, Object instanceTypesDescriptor) {
                        return ScriptBytecodeAdapter.isCase((Object)zone, (Object)this.zoneNames.get());
                    }

                    @Generated
                    public Object call(Object zone, Object instanceTypesDescriptor) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, zone, instanceTypesDescriptor);
                    }

                    @Generated
                    public Object getZoneNames() {
                        return this.zoneNames.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite matchingInstanceTypesDescriptors = IndyInterface.bootstrap("invoke", "values", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("cast", "()", 0, this.locationToInstanceTypesMap.get()), new _closure15((Object)this, this.getThisObject(), zoneNames2)));
                if (IndyInterface.bootstrap("cast", "()", 0, matchingInstanceTypesDescriptors) != false) {
                    public final class _closure16
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure16(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("getProperty", "instanceTypes", 0, it);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure16.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite matchingInstanceTypes = IndyInterface.bootstrap("invoke", "collect", 0, matchingInstanceTypesDescriptors, new _closure16((Object)this, this.getThisObject()));
                    CallSite firstZoneInstanceTypes = IndyInterface.bootstrap("invoke", "getAt", 0, matchingInstanceTypes, false);
                    CallSite remainingZoneInstanceTypes = IndyInterface.bootstrap("invoke", "drop", 0, matchingInstanceTypes, true);
                    public final class _closure17
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure17(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object acc, Object el) {
                            return IndyInterface.bootstrap("invoke", "intersect", 0, acc, el);
                        }

                        @Generated
                        public Object call(Object acc, Object el) {
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, acc, el);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure17.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite commonInstanceTypes = IndyInterface.bootstrap("invoke", "inject", 0, remainingZoneInstanceTypes, firstZoneInstanceTypes, new _closure17((Object)this, this.getThisObject()));
                    public final class _closure18
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure18(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("getProperty", "vCpuMax", 0, it);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure18.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite vCpuMaxInRegion = IndyInterface.bootstrap("getProperty", "vCpuMax", 0, IndyInterface.bootstrap("invoke", "min", 0, matchingInstanceTypesDescriptors, new _closure18((Object)this, this.getThisObject())));
                    Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceTypes", commonInstanceTypes, "vCpuMax", vCpuMaxInRegion});
                    IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.locationToInstanceTypesMap.get()), region, map);
                    return map;
                }
                return null;
            }

            @Generated
            public Object call(Object region, Object zoneNames) {
                Reference zoneNames2 = new Reference(zoneNames);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, region, zoneNames2.get());
            }

            @Generated
            public Map getLocationToInstanceTypesMap() {
                return IndyInterface.bootstrap("cast", "()", 0, this.locationToInstanceTypesMap.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _populateRegionInstanceTypes_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, regionToZonesMap, new _populateRegionInstanceTypes_closure9(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class, locationToInstanceTypesMap2));
    }

    public static Map<String, List<String>> queryCpuPlatforms(Compute compute, String project, Map<String, List<String>> regionToZonesMap) {
        CallSite locationToCpuPlatformsMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        CallSite zoneList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 0, GoogleExecutor.class, IndyInterface.bootstrap("invoke", "getRegistry", 0, GoogleExecutor.class), IndyInterface.bootstrap("invoke", "list", 0, IndyInterface.bootstrap("invoke", "zones", 0, compute), project), "google.api", "compute.zones.list", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 0, GoogleExecutor.class)));
        CallSite nextPageToken = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getNextPageToken", 0, zoneList));
        IndyInterface.bootstrap("invoke", "populateLocationToCpuPlatformsMap", 0, GoogleNamedAccountCredentials.class, zoneList, locationToCpuPlatformsMap);
        while (IndyInterface.bootstrap("cast", "()", 0, nextPageToken) != false) {
            zoneList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "timeExecute", 0, GoogleExecutor.class, IndyInterface.bootstrap("invoke", "getRegistry", 0, GoogleExecutor.class), IndyInterface.bootstrap("invoke", "setPageToken", 0, IndyInterface.bootstrap("invoke", "list", 0, IndyInterface.bootstrap("invoke", "zones", 0, compute), project), nextPageToken), "google.api", "compute.zones.list", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 0, GoogleExecutor.class)));
            nextPageToken = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getNextPageToken", 0, zoneList));
            IndyInterface.bootstrap("invoke", "populateLocationToCpuPlatformsMap", 0, GoogleNamedAccountCredentials.class, zoneList, locationToCpuPlatformsMap);
        }
        IndyInterface.bootstrap("invoke", "populateRegionCpuPlatforms", 0, GoogleNamedAccountCredentials.class, locationToCpuPlatformsMap, regionToZonesMap);
        return locationToCpuPlatformsMap;
    }

    @VisibleForTesting
    public static void populateLocationToCpuPlatformsMap(ZoneList zoneList, Map<String, List<String>> locationToCpuPlatformsMap) {
        Reference locationToCpuPlatformsMap2 = new Reference(locationToCpuPlatformsMap);
        public final class _populateLocationToCpuPlatformsMap_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference locationToCpuPlatformsMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _populateLocationToCpuPlatformsMap_closure10(Object _outerInstance, Object _thisObject, Reference locationToCpuPlatformsMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.locationToCpuPlatformsMap = reference = locationToCpuPlatformsMap;
            }

            public Object doCall(Zone zone) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "availableCpuPlatforms", 0, zone)) != false) {
                    public final class _closure19
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure19(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object a, Object b) {
                            return ScriptBytecodeAdapter.compareTo((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("getProperty", "SORTED_CPU_PLATFORMS", 12, this), a), (Object)IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("getProperty", "SORTED_CPU_PLATFORMS", 12, this), b));
                        }

                        @Generated
                        public Object call(Object a, Object b) {
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, a, b);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure19.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite = IndyInterface.bootstrap("invoke", "toSorted", 0, IndyInterface.bootstrap("getProperty", "availableCpuPlatforms", 0, zone), new _closure19((Object)this, this.getThisObject()));
                    IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.locationToCpuPlatformsMap.get()), IndyInterface.bootstrap("getProperty", "name", 0, zone), callSite);
                    return callSite;
                }
                return null;
            }

            @Generated
            public Object call(Zone zone) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, zone);
            }

            @Generated
            public Map getLocationToCpuPlatformsMap() {
                return IndyInterface.bootstrap("cast", "()", 0, this.locationToCpuPlatformsMap.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _populateLocationToCpuPlatformsMap_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getItems", 0, zoneList), new _populateLocationToCpuPlatformsMap_closure10(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class, locationToCpuPlatformsMap2));
    }

    public static void populateRegionCpuPlatforms(Map<String, List<String>> locationToCpuPlatformsMap, Map<String, List<String>> regionToZonesMap) {
        Reference locationToCpuPlatformsMap2 = new Reference(locationToCpuPlatformsMap);
        public final class _populateRegionCpuPlatforms_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference locationToCpuPlatformsMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _populateRegionCpuPlatforms_closure11(Object _outerInstance, Object _thisObject, Reference locationToCpuPlatformsMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.locationToCpuPlatformsMap = reference = locationToCpuPlatformsMap;
            }

            public Object doCall(Object region, Object zoneNames) {
                Reference zoneNames2 = new Reference(zoneNames);
                if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, zoneNames2.get()), (Object)3)) {
                    zoneNames2.set((Object)IndyInterface.bootstrap("invoke", "drop", 0, IndyInterface.bootstrap("invoke", "sort", 0, zoneNames2.get()), IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "size", 0, zoneNames2.get()), 3)));
                }
                public final class _closure20
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference zoneNames;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure20(Object _outerInstance, Object _thisObject, Reference zoneNames) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.zoneNames = reference = zoneNames;
                    }

                    public Object doCall(Object zone, Object object) {
                        return ScriptBytecodeAdapter.isCase((Object)zone, (Object)this.zoneNames.get());
                    }

                    @Generated
                    public Object call(Object zone, Object object) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, zone, object);
                    }

                    @Generated
                    public Object getZoneNames() {
                        return this.zoneNames.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure20.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite matchingCpuPlatformsLists = IndyInterface.bootstrap("invoke", "values", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("cast", "()", 0, this.locationToCpuPlatformsMap.get()), new _closure20((Object)this, this.getThisObject(), zoneNames2)));
                if (IndyInterface.bootstrap("cast", "()", 0, matchingCpuPlatformsLists) != false) {
                    CallSite firstZoneCpuPlatforms = IndyInterface.bootstrap("invoke", "getAt", 0, matchingCpuPlatformsLists, false);
                    CallSite remainingZoneCpuPlatforms = IndyInterface.bootstrap("invoke", "drop", 0, matchingCpuPlatformsLists, true);
                    public final class _closure21
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure21(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object acc, Object el) {
                            return IndyInterface.bootstrap("invoke", "intersect", 0, acc, el);
                        }

                        @Generated
                        public Object call(Object acc, Object el) {
                            return IndyInterface.bootstrap("invoke", "doCall", 2, this, acc, el);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure21.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite commonCpuPlatforms = IndyInterface.bootstrap("invoke", "inject", 0, remainingZoneCpuPlatforms, firstZoneCpuPlatforms, new _closure21((Object)this, this.getThisObject()));
                    if (IndyInterface.bootstrap("cast", "()", 0, commonCpuPlatforms) != false) {
                        CallSite callSite = commonCpuPlatforms;
                        IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.locationToCpuPlatformsMap.get()), region, callSite);
                        return callSite;
                    }
                }
                return null;
            }

            @Generated
            public Object call(Object region, Object zoneNames) {
                Reference zoneNames2 = new Reference(zoneNames);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, region, zoneNames2.get());
            }

            @Generated
            public Map getLocationToCpuPlatformsMap() {
                return IndyInterface.bootstrap("cast", "()", 0, this.locationToCpuPlatformsMap.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _populateRegionCpuPlatforms_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, regionToZonesMap, new _populateRegionCpuPlatforms_closure11(GoogleNamedAccountCredentials.class, GoogleNamedAccountCredentials.class, locationToCpuPlatformsMap2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GoogleNamedAccountCredentials.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleNamedAccountCredentials.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleNamedAccountCredentials.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(GoogleNamedAccountCredentials.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ @VisibleForTesting @VisibleForTesting void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, GoogleNamedAccountCredentials.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(GoogleNamedAccountCredentials.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public @VisibleForTesting @VisibleForTesting void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        List list;
        SORTED_CPU_PLATFORMS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"Intel Sandy Bridge", "Intel Ivy Bridge", "Intel Haswell", "Intel Broadwell", "Intel Skylake"});
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.google.security.GoogleNamedAccountCredentials");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public static List<String> getSORTED_CPU_PLATFORMS() {
        return SORTED_CPU_PLATFORMS;
    }

    @Generated
    public final String getName() {
        return this.name;
    }

    @Generated
    public final String getEnvironment() {
        return this.environment;
    }

    @Generated
    public final String getAccountType() {
        return this.accountType;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    @Generated
    public final List<String> getRequiredGroupMembership() {
        return this.requiredGroupMembership;
    }

    @Generated
    public final Permissions getPermissions() {
        return this.permissions;
    }

    @Generated
    public final GoogleCredentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public final String getProject() {
        return this.project;
    }

    @Generated
    public final String getXpnHostProject() {
        return this.xpnHostProject;
    }

    @Generated
    public final String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public final List<String> getImageProjects() {
        return this.imageProjects;
    }

    @Generated
    public final ComputeVersion getComputeVersion() {
        return this.computeVersion;
    }

    @Generated
    public final Map<String, List<String>> getRegionToZonesMap() {
        return this.regionToZonesMap;
    }

    @Generated
    public final Map<String, Map> getLocationToInstanceTypesMap() {
        return this.locationToInstanceTypesMap;
    }

    @Generated
    public final Map<String, List<String>> getLocationToCpuPlatformsMap() {
        return this.locationToCpuPlatformsMap;
    }

    @Generated
    public final List<GoogleInstanceTypeDisk> getInstanceTypeDisks() {
        return this.instanceTypeDisks;
    }

    @Generated
    public final ConsulConfig getConsulConfig() {
        return this.consulConfig;
    }

    @Generated
    public final Compute getCompute() {
        return this.compute;
    }

    @Generated
    public final String getUserDataFile() {
        return this.userDataFile;
    }

    @Generated
    public final List<String> getRegionsToManage() {
        return this.regionsToManage;
    }

    @Generated
    public final Map<String, Map> getZoneToAcceleratorTypesMap() {
        return this.zoneToAcceleratorTypesMap;
    }

    public /* synthetic */ List super$1$getRequiredGroupMembership() {
        return super.getRequiredGroupMembership();
    }

    public /* synthetic */ Permissions super$2$getPermissions() {
        return super.getPermissions();
    }

    public static class Builder
    implements GroovyObject {
        private String name;
        private String environment;
        private String accountType;
        private Namer namer;
        private List<String> requiredGroupMembership;
        private Permissions permissions;
        private String project;
        private String xpnHostProject;
        private String applicationName;
        private List<String> imageProjects;
        private ComputeVersion computeVersion;
        private Map<String, List<String>> regionToZonesMap;
        private Map<String, Map> locationToInstanceTypesMap;
        private Map<String, Map> zoneToAcceleratorTypesMap;
        private Map<String, List<String>> locationToCpuPlatformsMap;
        private List<GoogleInstanceTypeDisk> instanceTypeDisks;
        private String jsonKey;
        private String serviceAccountId;
        private String serviceAccountProject;
        private GoogleCredentials credentials;
        private Compute compute;
        private ConsulConfig consulConfig;
        private String userDataFile;
        private List<String> regionsToManage;
        private boolean liveLookupsEnabled;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public Builder() {
            MetaClass metaClass;
            boolean bl;
            List list;
            Map map;
            Map map2;
            Map map3;
            List list2;
            List list3;
            this.requiredGroupMembership = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            CallSite callSite = IndyInterface.bootstrap("getProperty", "EMPTY", 0, Permissions.class);
            this.permissions = IndyInterface.bootstrap("cast", "()", 0, callSite);
            this.imageProjects = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            CallSite callSite2 = IndyInterface.bootstrap("getProperty", "DEFAULT", 0, ComputeVersion.class);
            this.computeVersion = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            this.regionToZonesMap = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.locationToInstanceTypesMap = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.zoneToAcceleratorTypesMap = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.instanceTypeDisks = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.liveLookupsEnabled = bl = true;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public Builder name(String name) {
            String string;
            this.name = string = name;
            return this;
        }

        public Builder environment(String environment) {
            String string;
            this.environment = string = environment;
            return this;
        }

        public Builder accountType(String accountType) {
            String string;
            this.accountType = string = accountType;
            return this;
        }

        public Builder namer(Namer namer) {
            Namer namer2;
            this.namer = namer2 = namer;
            return this;
        }

        public Builder requiredGroupMembership(List<String> requiredGroupMembership) {
            List<String> list = requiredGroupMembership;
            this.requiredGroupMembership = list;
            return this;
        }

        public Builder permissions(Permissions permissions) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isRestricted", 0, permissions)) != false) {
                Permissions permissions2;
                List list;
                this.requiredGroupMembership = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                this.permissions = permissions2 = permissions;
            }
            return this;
        }

        public Builder project(String project) {
            String string;
            this.project = string = project;
            return this;
        }

        public Builder applicationName(String applicationName) {
            String string;
            this.applicationName = string = applicationName;
            return this;
        }

        public Builder imageProjects(List<String> imageProjects) {
            List<String> list = imageProjects;
            this.imageProjects = list;
            return this;
        }

        public Builder computeVersion(ComputeVersion version) {
            ComputeVersion computeVersion;
            this.computeVersion = computeVersion = version;
            return this;
        }

        public Builder jsonKey(String jsonKey) {
            String string;
            this.jsonKey = string = jsonKey;
            return this;
        }

        public Builder serviceAccountId(String serviceAccountId) {
            String string;
            this.serviceAccountId = string = serviceAccountId;
            return this;
        }

        public Builder serviceAccountProject(String serviceAccountProject) {
            String string;
            this.serviceAccountProject = string = serviceAccountProject;
            return this;
        }

        @VisibleForTesting
        public Builder regionToZonesMap(Map<String, List<String>> regionToZonesMap) {
            Map<String, List<String>> map = regionToZonesMap;
            this.regionToZonesMap = map;
            return this;
        }

        @VisibleForTesting
        public Builder locationToInstanceTypesMap(Map<String, Map> locationToInstanceTypesMap) {
            Map<String, Map> map = locationToInstanceTypesMap;
            this.locationToInstanceTypesMap = map;
            return this;
        }

        public Builder locationToCpuPlatformsMap(Map<String, List<String>> locationToCpuPlatformsMap) {
            Map<String, List<String>> map = locationToCpuPlatformsMap;
            this.locationToCpuPlatformsMap = map;
            return this;
        }

        public Builder instanceTypeDisks(List<GoogleInstanceTypeDisk> instanceTypeDisks) {
            List<GoogleInstanceTypeDisk> list = instanceTypeDisks;
            this.instanceTypeDisks = list;
            return this;
        }

        public Builder liveLookupsEnabled(boolean enabled) {
            boolean bl;
            this.liveLookupsEnabled = bl = enabled;
            return this;
        }

        public Builder consulConfig(ConsulConfig consulConfig, ServiceClientProvider serviceClientProvider) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "enabled", 5, consulConfig)) != false) {
                ConsulConfig consulConfig2;
                IndyInterface.bootstrap("invoke", "applyDefaults", 0, consulConfig, serviceClientProvider);
                this.consulConfig = consulConfig2 = consulConfig;
            }
            return this;
        }

        public Builder userDataFile(String userDataFile) {
            String string;
            this.userDataFile = string = userDataFile;
            return this;
        }

        public Builder regionsToManage(List<String> regionsToManage, List<String> defaultRegions) {
            List<String> list = ScriptBytecodeAdapter.compareNotEqual(regionsToManage, null) ? regionsToManage : defaultRegions;
            this.regionsToManage = list;
            return this;
        }

        @VisibleForTesting
        public Builder credentials(GoogleCredentials credentials) {
            boolean bl;
            GoogleCredentials googleCredentials;
            this.credentials = googleCredentials = credentials;
            this.liveLookupsEnabled = bl = false;
            return this;
        }

        @VisibleForTesting
        public Builder compute(Compute compute) {
            boolean bl;
            Compute compute2;
            this.compute = compute2 = compute;
            this.liveLookupsEnabled = bl = false;
            return this;
        }

        public GoogleNamedAccountCredentials build() {
            Object credentials = this.credentials;
            Object credInfo = new GStringImpl(new Object[]{this.name}, new String[]{"Google Credentials (", "): "});
            if (ScriptBytecodeAdapter.compareEqual((Object)credentials, null)) {
                if (IndyInterface.bootstrap("cast", "()", 0, this.jsonKey) != false) {
                    credInfo = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, credInfo, "From JSON key"));
                    credentials = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, GoogleJsonCredentials.class, this.project, this.computeVersion, this.jsonKey));
                } else if (DefaultTypeTransformation.booleanUnbox((Object)this.serviceAccountId) && DefaultTypeTransformation.booleanUnbox((Object)this.serviceAccountProject)) {
                    credInfo = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, credInfo, new GStringImpl(new Object[]{this.serviceAccountProject, this.serviceAccountId}, new String[]{"Impersonating ", "/", ""})));
                    credentials = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, GoogleImpersonatedServiceAccountCredentials.class, this.project, this.computeVersion, this.serviceAccountId, this.serviceAccountProject));
                } else {
                    credInfo = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, credInfo, "Application Default Credentials"));
                    credentials = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, GoogleCredentials.class, this.project, this.computeVersion));
                }
            } else {
                credInfo = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, credInfo, "Direct"));
            }
            IndyInterface.bootstrap("invoke", "info", 0, ScriptBytecodeAdapter.getField(Builder.class, GoogleNamedAccountCredentials.class, (String)"log"), credInfo);
            Object compute = this.compute;
            if (ScriptBytecodeAdapter.compareEqual((Object)compute, null)) {
                compute = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCompute", 0, credentials, this.applicationName));
            }
            IndyInterface.bootstrap("invoke", "addGoogleClient", 0, AccountForClient.class, compute, this.name);
            if (this.liveLookupsEnabled) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getName", 1, IndyInterface.bootstrap("invoke", "timeExecute", 0, GoogleExecutor.class, IndyInterface.bootstrap("invoke", "getRegistry", 0, GoogleExecutor.class), IndyInterface.bootstrap("invoke", "getXpnHost", 0, IndyInterface.bootstrap("invoke", "projects", 0, compute), this.project), "google.api", "compute.projects.getXpnHost", IndyInterface.bootstrap("getProperty", "TAG_SCOPE", 0, GoogleExecutor.class), IndyInterface.bootstrap("getProperty", "SCOPE_GLOBAL", 0, GoogleExecutor.class)));
                this.xpnHostProject = IndyInterface.bootstrap("cast", "()", 0, callSite);
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "queryRegions", 2, this, compute, this.project);
                this.regionToZonesMap = IndyInterface.bootstrap("cast", "()", 0, callSite2);
                CallSite callSite3 = IndyInterface.bootstrap("invoke", "queryInstanceTypes", 2, this, compute, this.project, this.regionToZonesMap);
                this.locationToInstanceTypesMap = IndyInterface.bootstrap("cast", "()", 0, callSite3);
                CallSite callSite4 = IndyInterface.bootstrap("invoke", "queryAcceleratorTypes", 2, this, compute, this.project);
                this.zoneToAcceleratorTypesMap = IndyInterface.bootstrap("cast", "()", 0, callSite4);
                CallSite callSite5 = IndyInterface.bootstrap("invoke", "queryCpuPlatforms", 2, this, compute, this.project, this.regionToZonesMap);
                this.locationToCpuPlatformsMap = IndyInterface.bootstrap("cast", "()", 0, callSite5);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.namer) && DefaultTypeTransformation.booleanUnbox((Object)this.name)) {
                IndyInterface.bootstrap("invoke", "setNamer", 0, IndyInterface.bootstrap("invoke", "withAccount", 0, IndyInterface.bootstrap("invoke", "withProvider", 0, IndyInterface.bootstrap("invoke", "lookup", 0, NamerRegistry.class), IndyInterface.bootstrap("invoke", "getID", 0, GoogleCloudProvider.class)), this.name), GoogleLabeledResource.class, this.namer);
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, GoogleNamedAccountCredentials.class, this.name, this.environment, this.accountType, IndyInterface.bootstrap("getProperty", "ID", 0, GoogleCloudProvider.class), this.requiredGroupMembership, this.permissions, credentials, this.project, this.xpnHostProject, this.applicationName, this.imageProjects, this.computeVersion, this.regionToZonesMap, this.locationToInstanceTypesMap, this.locationToCpuPlatformsMap, this.instanceTypeDisks, this.consulConfig, compute, this.userDataFile, this.regionsToManage, this.zoneToAcceleratorTypesMap));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Builder.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, GoogleNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, GoogleNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, GoogleNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, GoogleNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, GoogleNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(Builder.class, GoogleNamedAccountCredentials.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), Builder.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ @VisibleForTesting void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleNamedAccountCredentials.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ @VisibleForTesting void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, GoogleNamedAccountCredentials.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), Builder.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(Builder.class, GoogleNamedAccountCredentials.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(Builder.class, GoogleNamedAccountCredentials.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), Builder.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public @VisibleForTesting void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @VisibleForTesting void setName(String string) {
            this.name = string;
        }

        @Generated
        public String getEnvironment() {
            return this.environment;
        }

        @Generated
        public @VisibleForTesting void setEnvironment(String string) {
            this.environment = string;
        }

        @Generated
        public String getAccountType() {
            return this.accountType;
        }

        @Generated
        public @VisibleForTesting void setAccountType(String string) {
            this.accountType = string;
        }

        @Generated
        public Namer getNamer() {
            return this.namer;
        }

        @Generated
        public @VisibleForTesting void setNamer(Namer namer) {
            this.namer = namer;
        }

        @Generated
        public List<String> getRequiredGroupMembership() {
            return this.requiredGroupMembership;
        }

        @Generated
        public @VisibleForTesting void setRequiredGroupMembership(List<String> list) {
            this.requiredGroupMembership = list;
        }

        @Generated
        public Permissions getPermissions() {
            return this.permissions;
        }

        @Generated
        public @VisibleForTesting void setPermissions(Permissions permissions) {
            this.permissions = permissions;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public @VisibleForTesting void setProject(String string) {
            this.project = string;
        }

        @Generated
        public String getXpnHostProject() {
            return this.xpnHostProject;
        }

        @Generated
        public @VisibleForTesting void setXpnHostProject(String string) {
            this.xpnHostProject = string;
        }

        @Generated
        public String getApplicationName() {
            return this.applicationName;
        }

        @Generated
        public @VisibleForTesting void setApplicationName(String string) {
            this.applicationName = string;
        }

        @Generated
        public List<String> getImageProjects() {
            return this.imageProjects;
        }

        @Generated
        public @VisibleForTesting void setImageProjects(List<String> list) {
            this.imageProjects = list;
        }

        @Generated
        public ComputeVersion getComputeVersion() {
            return this.computeVersion;
        }

        @Generated
        public @VisibleForTesting void setComputeVersion(ComputeVersion computeVersion) {
            this.computeVersion = computeVersion;
        }

        @Generated
        public Map<String, List<String>> getRegionToZonesMap() {
            return this.regionToZonesMap;
        }

        @Generated
        public @VisibleForTesting void setRegionToZonesMap(Map<String, List<String>> map) {
            this.regionToZonesMap = map;
        }

        @Generated
        public Map<String, Map> getLocationToInstanceTypesMap() {
            return this.locationToInstanceTypesMap;
        }

        @Generated
        public @VisibleForTesting void setLocationToInstanceTypesMap(Map<String, Map> map) {
            this.locationToInstanceTypesMap = map;
        }

        @Generated
        public Map<String, Map> getZoneToAcceleratorTypesMap() {
            return this.zoneToAcceleratorTypesMap;
        }

        @Generated
        public @VisibleForTesting void setZoneToAcceleratorTypesMap(Map<String, Map> map) {
            this.zoneToAcceleratorTypesMap = map;
        }

        @Generated
        public Map<String, List<String>> getLocationToCpuPlatformsMap() {
            return this.locationToCpuPlatformsMap;
        }

        @Generated
        public @VisibleForTesting void setLocationToCpuPlatformsMap(Map<String, List<String>> map) {
            this.locationToCpuPlatformsMap = map;
        }

        @Generated
        public List<GoogleInstanceTypeDisk> getInstanceTypeDisks() {
            return this.instanceTypeDisks;
        }

        @Generated
        public @VisibleForTesting void setInstanceTypeDisks(List<GoogleInstanceTypeDisk> list) {
            this.instanceTypeDisks = list;
        }

        @Generated
        public String getJsonKey() {
            return this.jsonKey;
        }

        @Generated
        public @VisibleForTesting void setJsonKey(String string) {
            this.jsonKey = string;
        }

        @Generated
        public String getServiceAccountId() {
            return this.serviceAccountId;
        }

        @Generated
        public @VisibleForTesting void setServiceAccountId(String string) {
            this.serviceAccountId = string;
        }

        @Generated
        public String getServiceAccountProject() {
            return this.serviceAccountProject;
        }

        @Generated
        public @VisibleForTesting void setServiceAccountProject(String string) {
            this.serviceAccountProject = string;
        }

        @Generated
        public GoogleCredentials getCredentials() {
            return this.credentials;
        }

        @Generated
        public @VisibleForTesting void setCredentials(GoogleCredentials googleCredentials) {
            this.credentials = googleCredentials;
        }

        @Generated
        public Compute getCompute() {
            return this.compute;
        }

        @Generated
        public @VisibleForTesting void setCompute(Compute compute) {
            this.compute = compute;
        }

        @Generated
        public ConsulConfig getConsulConfig() {
            return this.consulConfig;
        }

        @Generated
        public @VisibleForTesting void setConsulConfig(ConsulConfig consulConfig) {
            this.consulConfig = consulConfig;
        }

        @Generated
        public String getUserDataFile() {
            return this.userDataFile;
        }

        @Generated
        public @VisibleForTesting void setUserDataFile(String string) {
            this.userDataFile = string;
        }

        @Generated
        public List<String> getRegionsToManage() {
            return this.regionsToManage;
        }

        @Generated
        public @VisibleForTesting void setRegionsToManage(List<String> list) {
            this.regionsToManage = list;
        }

        @Generated
        public boolean getLiveLookupsEnabled() {
            return this.liveLookupsEnabled;
        }

        @Generated
        public boolean isLiveLookupsEnabled() {
            return this.liveLookupsEnabled;
        }

        @Generated
        public @VisibleForTesting void setLiveLookupsEnabled(boolean bl) {
            this.liveLookupsEnabled = bl;
        }
    }
}

