/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.saga.config;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.event.SpinnakerEvent;
import com.netflix.spinnaker.clouddriver.event.persistence.EventRepository;
import com.netflix.spinnaker.clouddriver.saga.SagaService;
import com.netflix.spinnaker.clouddriver.saga.config.SagaProperties;
import com.netflix.spinnaker.clouddriver.saga.persistence.DefaultSagaRepository;
import com.netflix.spinnaker.clouddriver.saga.persistence.SagaRepository;
import com.netflix.spinnaker.kork.jackson.ObjectMapperSubtypeConfigurer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SagaProperties.class})
@ComponentScan(value={"com.netflix.spinnaker.clouddriver.saga.controllers"})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0017\u00a8\u0006\r"}, d2={"Lcom/netflix/spinnaker/clouddriver/saga/config/SagaAutoConfiguration;", "", "()V", "sagaEventSubtypeLocator", "Lcom/netflix/spinnaker/kork/jackson/ObjectMapperSubtypeConfigurer$SubtypeLocator;", "sagaRepository", "Lcom/netflix/spinnaker/clouddriver/saga/persistence/SagaRepository;", "eventRepository", "Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository;", "sagaService", "Lcom/netflix/spinnaker/clouddriver/saga/SagaService;", "registry", "Lcom/netflix/spectator/api/Registry;", "clouddriver-saga"})
public class SagaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SagaRepository.class})
    @NotNull
    public SagaRepository sagaRepository(@NotNull EventRepository eventRepository) {
        Intrinsics.checkNotNullParameter((Object)eventRepository, (String)"eventRepository");
        return new DefaultSagaRepository(eventRepository);
    }

    @Bean
    @NotNull
    public SagaService sagaService(@NotNull SagaRepository sagaRepository, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)sagaRepository, (String)"sagaRepository");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return new SagaService(sagaRepository, registry);
    }

    @Bean
    @NotNull
    public ObjectMapperSubtypeConfigurer.SubtypeLocator sagaEventSubtypeLocator() {
        return (ObjectMapperSubtypeConfigurer.SubtypeLocator)new ObjectMapperSubtypeConfigurer.ClassSubtypeLocator(SpinnakerEvent.class, CollectionsKt.listOf((Object)"com.netflix.spinnaker.clouddriver.saga"));
    }
}

