/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.saga;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.clouddriver.saga.SagaCommand;
import com.netflix.spinnaker.clouddriver.saga.exceptions.SagaSystemException;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.ResolvableType;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u0001H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"getCommandTypeFromAction", "Ljava/lang/Class;", "Lcom/netflix/spinnaker/clouddriver/saga/SagaCommand;", "action", "Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaAction;", "getStepCommandName", "", "command", "commandClass", "clouddriver-saga"})
public final class UtilKt {
    @NotNull
    public static final String getStepCommandName(@NotNull SagaCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return UtilKt.getStepCommandName(command.getClass());
    }

    @NotNull
    public static final String getStepCommandName(@NotNull Class<SagaCommand> commandClass) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter(commandClass, (String)"commandClass");
        Object object = commandClass.getAnnotation(JsonTypeName.class);
        String string3 = string2 = object == null ? null : object.value();
        if (string2 == null) {
            object = commandClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"commandClass.simpleName");
            string = object;
        } else {
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final Class<SagaCommand> getCommandTypeFromAction(@NotNull Class<? extends SagaAction<?>> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ResolvableType actionType = ResolvableType.forClass(SagaAction.class, action);
        actionType.resolve();
        int[] nArray = new int[]{0};
        ResolvableType commandType = actionType.getGeneric(nArray);
        commandType.resolve();
        Class clazz = commandType.getRawClass();
        Intrinsics.checkNotNull((Object)clazz);
        Class rawClass = clazz;
        if (SagaCommand.class.isAssignableFrom(rawClass)) {
            return rawClass;
        }
        throw new SagaSystemException("Resolved next action is not a SagaCommand: " + rawClass.getSimpleName());
    }
}

