/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.saga.controllers;

import com.netflix.spinnaker.clouddriver.saga.models.Saga;
import com.netflix.spinnaker.clouddriver.saga.persistence.SagaRepository;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/saga"})
@RestController
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/spinnaker/clouddriver/saga/controllers/SagaController;", "", "sagaRepository", "Lcom/netflix/spinnaker/clouddriver/saga/persistence/SagaRepository;", "(Lcom/netflix/spinnaker/clouddriver/saga/persistence/SagaRepository;)V", "get", "Lcom/netflix/spinnaker/clouddriver/saga/models/Saga;", "name", "", "id", "clouddriver-saga"})
public class SagaController {
    @NotNull
    private final SagaRepository sagaRepository;

    public SagaController(@NotNull SagaRepository sagaRepository) {
        Intrinsics.checkNotNullParameter((Object)sagaRepository, (String)"sagaRepository");
        this.sagaRepository = sagaRepository;
    }

    @GetMapping(value={"/{name}/{id}"})
    @NotNull
    public Saga get(@PathVariable(value="name") @NotNull String name, @PathVariable(value="id") @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Saga saga = this.sagaRepository.get(name, id);
        if (saga == null) {
            throw new NotFoundException("Saga not found (name: " + name + ", id: " + id + ")");
        }
        return saga;
    }
}

