/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.saga.flow;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.netflix.spinnaker.clouddriver.saga.SagaCommand;
import com.netflix.spinnaker.clouddriver.saga.SagaCommandCompleted;
import com.netflix.spinnaker.clouddriver.saga.SagaCommandSkipped;
import com.netflix.spinnaker.clouddriver.saga.SagaConditionEvaluated;
import com.netflix.spinnaker.clouddriver.saga.UtilKt;
import com.netflix.spinnaker.clouddriver.saga.exceptions.SagaNotFoundException;
import com.netflix.spinnaker.clouddriver.saga.exceptions.SagaSystemException;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaAction;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaFlow;
import com.netflix.spinnaker.clouddriver.saga.flow.seekers.SagaCommandCompletedEventSeeker;
import com.netflix.spinnaker.clouddriver.saga.flow.seekers.SagaCommandEventSeeker;
import com.netflix.spinnaker.clouddriver.saga.models.Saga;
import com.netflix.spinnaker.clouddriver.saga.persistence.SagaRepository;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002*+B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001f\u001a\u00020\u0000H\u0002J\u0014\u0010 \u001a\u00020!2\n\u0010\"\u001a\u00060#R\u00020\nH\u0002J\t\u0010$\u001a\u00020\fH\u0096\u0002J\t\u0010%\u001a\u00020\u0002H\u0096\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010'\u001a\u00020!2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0)H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R#\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlowIterator;", "", "Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlowIterator$IteratorState;", "sagaRepository", "Lcom/netflix/spinnaker/clouddriver/saga/persistence/SagaRepository;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "saga", "Lcom/netflix/spinnaker/clouddriver/saga/models/Saga;", "flow", "Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlow;", "seekingEnabled", "", "stateRefreshingEnabled", "(Lcom/netflix/spinnaker/clouddriver/saga/persistence/SagaRepository;Lorg/springframework/context/ApplicationContext;Lcom/netflix/spinnaker/clouddriver/saga/models/Saga;Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlow;ZZ)V", "context", "Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlowIterator$Context;", "index", "", "latestSaga", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "seeked", "steps", "", "Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlow$Step;", "copyForSeeker", "evaluateConditionStep", "", "nextStep", "Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlow$ConditionStep;", "hasNext", "next", "seekToNextStep", "skipConditionalCommands", "conditionalSteps", "", "Context", "IteratorState", "clouddriver-saga"})
public final class SagaFlowIterator
implements Iterator<IteratorState>,
KMappedMarker {
    @NotNull
    private final SagaRepository sagaRepository;
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private Saga saga;
    @NotNull
    private final SagaFlow flow;
    private final boolean seekingEnabled;
    private final boolean stateRefreshingEnabled;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final Context context;
    private int index;
    private boolean seeked;
    @NotNull
    private List<SagaFlow.Step> steps;
    private Saga latestSaga;

    public SagaFlowIterator(@NotNull SagaRepository sagaRepository, @NotNull ApplicationContext applicationContext, @NotNull Saga saga, @NotNull SagaFlow flow, boolean seekingEnabled, boolean stateRefreshingEnabled) {
        Intrinsics.checkNotNullParameter((Object)sagaRepository, (String)"sagaRepository");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)saga, (String)"saga");
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        this.sagaRepository = sagaRepository;
        this.applicationContext = applicationContext;
        this.saga = saga;
        this.flow = flow;
        this.seekingEnabled = seekingEnabled;
        this.stateRefreshingEnabled = stateRefreshingEnabled;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SagaFlowIterator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        this.context = new Context(this.saga.getName(), this.saga.getId());
        this.steps = CollectionsKt.toMutableList((Collection)CollectionsKt.toList((Iterable)this.flow.getSteps$clouddriver_saga()));
    }

    public /* synthetic */ SagaFlowIterator(SagaRepository sagaRepository, ApplicationContext applicationContext, Saga saga, SagaFlow sagaFlow, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        this(sagaRepository, applicationContext, saga, sagaFlow, bl, bl2);
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @Override
    public boolean hasNext() {
        SagaFlow.Step nextStep;
        Saga saga;
        if (this.index >= this.steps.size()) {
            return false;
        }
        if (this.stateRefreshingEnabled) {
            saga = this.sagaRepository.get(this.context.getSagaName(), this.context.getSagaId());
            if (saga == null) {
                throw new SagaNotFoundException("Could not find Saga (" + this.context.getSagaName() + "/" + this.context.getSagaId() + " for flow traversal");
            }
            this.latestSaga = saga;
        }
        if (this.seekingEnabled) {
            Saga saga2;
            saga = this.latestSaga;
            if (saga == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"latestSaga");
                saga2 = null;
            } else {
                saga2 = saga;
            }
            this.seekToNextStep(saga2);
        }
        if ((nextStep = this.steps.get(this.index)) instanceof SagaFlow.ConditionStep) {
            this.evaluateConditionStep((SagaFlow.ConditionStep)nextStep);
        }
        return this.index < this.steps.size();
    }

    private final void evaluateConditionStep(SagaFlow.ConditionStep nextStep) {
        boolean result;
        boolean bl;
        boolean bl2;
        Object object;
        Saga saga;
        SagaFlow.ConditionPredicate conditionPredicate;
        try {
            conditionPredicate = (SagaFlow.ConditionPredicate)this.applicationContext.getBean(nextStep.getPredicate());
        }
        catch (BeansException e) {
            throw new SagaSystemException("Failed to create SagaFlow Predicate: " + nextStep.getPredicate().getSimpleName(), e);
        }
        SagaFlow.ConditionPredicate predicate = conditionPredicate;
        Saga saga2 = this.latestSaga;
        if (saga2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"latestSaga");
            saga = null;
        } else {
            saga = saga2;
        }
        SagaConditionEvaluated e = saga.maybeGetEvent(SagaConditionEvaluated.class, (Function1)new Function1<List<? extends SagaConditionEvaluated>, SagaConditionEvaluated>(predicate){
            final /* synthetic */ SagaFlow.ConditionPredicate $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final SagaConditionEvaluated invoke(@NotNull List<SagaConditionEvaluated> events) {
                Object v0;
                block1: {
                    void $this$firstOrNull$iv;
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    Iterable iterable = events;
                    SagaFlow.ConditionPredicate conditionPredicate = this.$predicate;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        SagaConditionEvaluated it = (SagaConditionEvaluated)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getConditionName(), (Object)conditionPredicate.getName())) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
        });
        Boolean previousEvaluationResult2 = e == null ? null : Boolean.valueOf(e.getResult());
        Object object2 = previousEvaluationResult2;
        if (object2 == null) {
            object = null;
        } else {
            Boolean bl3 = object2;
            bl2 = false;
            boolean bl4 = false;
            boolean it = bl3;
            boolean bl5 = false;
            this.getLog().debug("Condition '" + predicate.getName() + "' previously evaluated: " + previousEvaluationResult2);
            object = saga2 = bl3;
        }
        if (saga2 == null) {
            Saga saga3;
            Object object3;
            object2 = this.latestSaga;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"latestSaga");
                object3 = null;
            } else {
                object3 = object2;
            }
            object2 = predicate.test(object3);
            boolean bl6 = false;
            bl2 = false;
            boolean conditionResult = (Boolean)object2;
            boolean bl7 = false;
            this.getLog().debug("Condition '" + predicate.getName() + "' result: " + conditionResult);
            Object object4 = this.latestSaga;
            if (object4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"latestSaga");
                saga3 = null;
            } else {
                saga3 = object4;
            }
            object4 = nextStep.getPredicate().getName();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"nextStep.predicate.name");
            saga3.addEvent(new SagaConditionEvaluated((String)object4, conditionResult));
            if (!conditionResult) {
                this.skipConditionalCommands(nextStep.getNestedBuilder().getSteps$clouddriver_saga());
            }
            bl = (Boolean)object2;
        } else {
            bl = result = ((Boolean)((Object)saga2)).booleanValue();
        }
        if (result) {
            this.steps.addAll(this.index, (Collection<SagaFlow.Step>)nextStep.getNestedBuilder().getSteps$clouddriver_saga());
        }
        this.steps.remove(nextStep);
    }

    /*
     * WARNING - void declaration
     */
    private final void skipConditionalCommands(List<? extends SagaFlow.Step> conditionalSteps) {
        void $this$filterTo$iv$iv;
        Object object;
        SagaFlow.ActionStep it;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = conditionalSteps;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv2 instanceof SagaFlow.ActionStep)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Object $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv = iterator.next();
            element$iv$iv = element$iv$iv$iv;
            boolean bl = false;
            it = (SagaFlow.ActionStep)element$iv$iv;
            boolean bl2 = false;
            JsonTypeName jsonTypeName = UtilKt.getCommandTypeFromAction(it.getAction()).getAnnotation(JsonTypeName.class);
            if ((jsonTypeName == null ? null : jsonTypeName.value()) == null) continue;
            string = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List skippedCommandTypes = (List)destination$iv$iv;
        $this$mapNotNull$iv = this.latestSaga;
        if ($this$mapNotNull$iv == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"latestSaga");
            object = null;
        } else {
            object = $this$mapNotNull$iv;
        }
        $this$filterIsInstance$iv = ((Saga)object).getEvents();
        $i$f$filterIsInstance = false;
        $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv3 instanceof SagaCommand)) continue;
            destination$iv$iv.add(element$iv$iv3);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv4 : $this$filterTo$iv$iv) {
            boolean bl;
            block15: {
                void $this$none$iv;
                void $this$filterIsInstanceTo$iv$iv2;
                Iterable $this$filterIsInstance$iv2;
                Object object2;
                SagaCommand it2 = (SagaCommand)element$iv$iv4;
                boolean bl6 = false;
                element$iv$iv = this.latestSaga;
                if (element$iv$iv == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"latestSaga");
                    object2 = null;
                } else {
                    object2 = element$iv$iv;
                }
                element$iv$iv = ((Saga)object2).getEvents();
                boolean $i$f$filterIsInstance2 = false;
                it = $this$filterIsInstance$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo2 = false;
                for (Object element$iv$iv5 : $this$filterIsInstanceTo$iv$iv2) {
                    if (!(element$iv$iv5 instanceof SagaCommandCompleted)) continue;
                    destination$iv$iv2.add(element$iv$iv5);
                }
                $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        SagaCommandCompleted completed = (SagaCommandCompleted)element$iv;
                        boolean bl7 = false;
                        if (!completed.matches(it2.getClass())) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv4);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object3;
            SagaCommand it3 = (SagaCommand)element$iv;
            boolean bl = false;
            Object object4 = it3.getClass().getAnnotation(JsonTypeName.class);
            String commandName = object4 == null ? null : object4.value();
            if (commandName == null || !skippedCommandTypes.contains(commandName)) continue;
            object4 = this.latestSaga;
            if (object4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"latestSaga");
                object3 = null;
            } else {
                object3 = object4;
            }
            ((Saga)object3).addEvent(new SagaCommandSkipped(commandName, "Condition evaluated against running branch"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void seekToNextStep(Saga saga) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        if (this.seeked) {
            return;
        }
        this.seeked = true;
        Object object = new Function3[]{new SagaCommandCompletedEventSeeker(), new SagaCommandEventSeeker()};
        object = CollectionsKt.listOf((Object[])object);
        SagaFlowIterator sagaFlowIterator = this;
        boolean $i$f$mapNotNull = false;
        void var5_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer n;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Function3 it = (Function3)element$iv$iv;
            boolean bl2 = false;
            Integer n2 = (Integer)it.invoke((Object)this.index, this.steps, (Object)saga);
            if ((n2 == null ? null : Integer.valueOf(RangesKt.coerceAtLeast((int)n2, (int)0))) == null) continue;
            n = n;
            boolean bl3 = false;
            boolean bl4 = false;
            Integer it$iv$iv = n;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)list);
        int n3 = sagaFlowIterator.index = n == null ? this.index : n;
        if (this.index != 0) {
            this.getLog().info("Seeking to step index " + this.index);
        }
    }

    @Override
    @NotNull
    public IteratorState next() {
        Object object;
        Object object2;
        SagaFlow.Step step = this.steps.get(this.index);
        if (!(step instanceof SagaFlow.ActionStep)) {
            throw new SystemException("step must be an action: " + step);
        }
        SagaFlowIterator sagaFlowIterator = this;
        ++sagaFlowIterator.index;
        try {
            object2 = (SagaAction)this.applicationContext.getBean(((SagaFlow.ActionStep)step).getAction());
        }
        catch (BeansException e) {
            throw new SagaSystemException("Failed to create SagaAction: " + ((SagaFlow.ActionStep)step).getAction().getSimpleName(), e);
        }
        SagaAction action = object2;
        object2 = this.latestSaga;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"latestSaga");
            object = null;
        } else {
            object = object2;
        }
        if (action == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.clouddriver.saga.flow.SagaAction<com.netflix.spinnaker.clouddriver.saga.SagaCommand>");
        }
        return new IteratorState((Saga)object, action, this);
    }

    private final SagaFlowIterator copyForSeeker() {
        return new SagaFlowIterator(this.sagaRepository, this.applicationContext, this.saga, this.flow, false, false);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\bH\u00c2\u0003J-\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0015\u001a\u00020\u0013J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlowIterator$IteratorState;", "", "saga", "Lcom/netflix/spinnaker/clouddriver/saga/models/Saga;", "action", "Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaAction;", "Lcom/netflix/spinnaker/clouddriver/saga/SagaCommand;", "iterator", "Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlowIterator;", "(Lcom/netflix/spinnaker/clouddriver/saga/models/Saga;Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaAction;Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlowIterator;)V", "getAction", "()Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaAction;", "getSaga", "()Lcom/netflix/spinnaker/clouddriver/saga/models/Saga;", "component1", "component2", "component3", "copy", "equals", "", "other", "hasMoreSteps", "hashCode", "", "toString", "", "clouddriver-saga"})
    public static final class IteratorState {
        @NotNull
        private final Saga saga;
        @NotNull
        private final SagaAction<SagaCommand> action;
        @NotNull
        private final SagaFlowIterator iterator;

        public IteratorState(@NotNull Saga saga, @NotNull SagaAction<? super SagaCommand> action, @NotNull SagaFlowIterator iterator) {
            Intrinsics.checkNotNullParameter((Object)saga, (String)"saga");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
            this.saga = saga;
            this.action = action;
            this.iterator = iterator;
        }

        @NotNull
        public final Saga getSaga() {
            return this.saga;
        }

        @NotNull
        public final SagaAction<SagaCommand> getAction() {
            return this.action;
        }

        public final boolean hasMoreSteps() {
            return this.iterator.hasNext();
        }

        @NotNull
        public final Saga component1() {
            return this.saga;
        }

        @NotNull
        public final SagaAction<SagaCommand> component2() {
            return this.action;
        }

        private final SagaFlowIterator component3() {
            return this.iterator;
        }

        @NotNull
        public final IteratorState copy(@NotNull Saga saga, @NotNull SagaAction<? super SagaCommand> action, @NotNull SagaFlowIterator iterator) {
            Intrinsics.checkNotNullParameter((Object)saga, (String)"saga");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
            return new IteratorState(saga, action, iterator);
        }

        public static /* synthetic */ IteratorState copy$default(IteratorState iteratorState, Saga saga, SagaAction sagaAction, SagaFlowIterator sagaFlowIterator, int n, Object object) {
            if ((n & 1) != 0) {
                saga = iteratorState.saga;
            }
            if ((n & 2) != 0) {
                sagaAction = iteratorState.action;
            }
            if ((n & 4) != 0) {
                sagaFlowIterator = iteratorState.iterator;
            }
            return iteratorState.copy(saga, sagaAction, sagaFlowIterator);
        }

        @NotNull
        public String toString() {
            return "IteratorState(saga=" + this.saga + ", action=" + this.action + ", iterator=" + this.iterator + ")";
        }

        public int hashCode() {
            int result = this.saga.hashCode();
            result = result * 31 + this.action.hashCode();
            result = result * 31 + this.iterator.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IteratorState)) {
                return false;
            }
            IteratorState iteratorState = (IteratorState)other;
            if (!Intrinsics.areEqual((Object)this.saga, (Object)iteratorState.saga)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.action, iteratorState.action)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.iterator, (Object)iteratorState.iterator);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlowIterator$Context;", "", "sagaName", "", "sagaId", "(Ljava/lang/String;Ljava/lang/String;)V", "getSagaId", "()Ljava/lang/String;", "getSagaName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "clouddriver-saga"})
    private static final class Context {
        @NotNull
        private final String sagaName;
        @NotNull
        private final String sagaId;

        public Context(@NotNull String sagaName, @NotNull String sagaId) {
            Intrinsics.checkNotNullParameter((Object)sagaName, (String)"sagaName");
            Intrinsics.checkNotNullParameter((Object)sagaId, (String)"sagaId");
            this.sagaName = sagaName;
            this.sagaId = sagaId;
        }

        @NotNull
        public final String getSagaName() {
            return this.sagaName;
        }

        @NotNull
        public final String getSagaId() {
            return this.sagaId;
        }

        @NotNull
        public final String component1() {
            return this.sagaName;
        }

        @NotNull
        public final String component2() {
            return this.sagaId;
        }

        @NotNull
        public final Context copy(@NotNull String sagaName, @NotNull String sagaId) {
            Intrinsics.checkNotNullParameter((Object)sagaName, (String)"sagaName");
            Intrinsics.checkNotNullParameter((Object)sagaId, (String)"sagaId");
            return new Context(sagaName, sagaId);
        }

        public static /* synthetic */ Context copy$default(Context context, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = context.sagaName;
            }
            if ((n & 2) != 0) {
                string2 = context.sagaId;
            }
            return context.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Context(sagaName=" + this.sagaName + ", sagaId=" + this.sagaId + ")";
        }

        public int hashCode() {
            int result = this.sagaName.hashCode();
            result = result * 31 + this.sagaId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual((Object)this.sagaName, (Object)context.sagaName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sagaId, (Object)context.sagaId);
        }
    }
}

