/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.saga;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.saga.ManyCommands;
import com.netflix.spinnaker.clouddriver.saga.SagaActionErrorOccurred;
import com.netflix.spinnaker.clouddriver.saga.SagaCommand;
import com.netflix.spinnaker.clouddriver.saga.SagaCommandCompleted;
import com.netflix.spinnaker.clouddriver.saga.UtilKt;
import com.netflix.spinnaker.clouddriver.saga.exceptions.SagaIntegrationException;
import com.netflix.spinnaker.clouddriver.saga.exceptions.SagaMissingRequiredCommandException;
import com.netflix.spinnaker.clouddriver.saga.exceptions.SagaNotFoundException;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaAction;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaCompletionHandler;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaExceptionHandler;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaFlow;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaFlowIterator;
import com.netflix.spinnaker.clouddriver.saga.models.Saga;
import com.netflix.spinnaker.clouddriver.saga.persistence.SagaRepository;
import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J3\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001fH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J%\u0010#\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010$\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010%J \u0010&\u001a\u00060'j\u0002`(2\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010)\u001a\u00060'j\u0002`(H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/netflix/spinnaker/clouddriver/saga/SagaService;", "Lorg/springframework/context/ApplicationContextAware;", "sagaRepository", "Lcom/netflix/spinnaker/clouddriver/saga/persistence/SagaRepository;", "registry", "Lcom/netflix/spectator/api/Registry;", "(Lcom/netflix/spinnaker/clouddriver/saga/persistence/SagaRepository;Lcom/netflix/spectator/api/Registry;)V", "actionInvocationsId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "applyBlocking", "T", "sagaName", "", "sagaId", "flow", "Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlow;", "startingCommand", "Lcom/netflix/spinnaker/clouddriver/saga/SagaCommand;", "(Ljava/lang/String;Ljava/lang/String;Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlow;Lcom/netflix/spinnaker/clouddriver/saga/SagaCommand;)Ljava/lang/Object;", "getRequiredCommand", "Ljava/lang/Class;", "action", "Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaAction;", "initializeSaga", "Lcom/netflix/spinnaker/clouddriver/saga/models/Saga;", "command", "invokeCompletionHandler", "saga", "(Lcom/netflix/spinnaker/clouddriver/saga/models/Saga;Lcom/netflix/spinnaker/clouddriver/saga/flow/SagaFlow;)Ljava/lang/Object;", "invokeExceptionHandler", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "setApplicationContext", "", "clouddriver-saga"})
@Beta
public final class SagaService
implements ApplicationContextAware {
    @NotNull
    private final SagaRepository sagaRepository;
    @NotNull
    private final Registry registry;
    private ApplicationContext applicationContext;
    @NotNull
    private final Lazy log$delegate;
    private final Id actionInvocationsId;

    public SagaService(@NotNull SagaRepository sagaRepository, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)sagaRepository, (String)"sagaRepository");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.sagaRepository = sagaRepository;
        this.registry = registry;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SagaService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        this.actionInvocationsId = this.registry.createId("sagas.actions.invocations");
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    @Nullable
    public final <T> T applyBlocking(@NotNull String sagaName, @NotNull String sagaId, @NotNull SagaFlow flow, @NotNull SagaCommand startingCommand) {
        Intrinsics.checkNotNullParameter((Object)sagaName, (String)"sagaName");
        Intrinsics.checkNotNullParameter((Object)sagaId, (String)"sagaId");
        Intrinsics.checkNotNullParameter((Object)flow, (String)"flow");
        Intrinsics.checkNotNullParameter((Object)startingCommand, (String)"startingCommand");
        Saga initialSaga = this.initializeSaga(startingCommand, sagaName, sagaId);
        this.getLog().info("Applying saga: " + initialSaga.getName() + "/" + initialSaga.getId());
        if (initialSaga.isComplete()) {
            this.getLog().info("Saga already complete, exiting early: " + initialSaga.getName() + "/" + initialSaga.getId());
            return this.invokeCompletionHandler(initialSaga, flow);
        }
        ApplicationContext applicationContext = this.applicationContext;
        if (applicationContext == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
            applicationContext = null;
        }
        Iterator $this$forEach$iv = new SagaFlowIterator(this.sagaRepository, applicationContext, initialSaga, flow, false, false, 48, null);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            SagaCommand stepCommand;
            SagaAction.Result result;
            Object element$iv = iterator.next();
            SagaFlowIterator.IteratorState flowState = (SagaFlowIterator.IteratorState)element$iv;
            boolean bl = false;
            Saga saga = flowState.getSaga();
            SagaAction<SagaCommand> action = flowState.getAction();
            this.getLog().debug("Applying saga action " + action.getClass().getSimpleName() + " for " + saga.getName() + "/" + saga.getId());
            Class<SagaCommand> requiredCommand = this.getRequiredCommand(action);
            if (saga.finalizedCommand$clouddriver_saga(requiredCommand)) continue;
            if (saga.getNextCommand$clouddriver_saga(requiredCommand) == null) {
                throw new SagaMissingRequiredCommandException("Missing required command " + requiredCommand.getSimpleName());
            }
            try {
                SagaAction.Result it = result = action.apply(stepCommand, saga);
                boolean bl2 = false;
                this.registry.counter(this.actionInvocationsId.withTags("result", "success", "action", action.getClass().getSimpleName())).increment();
            }
            catch (Exception e) {
                Boolean bl3;
                Exception handledException = this.invokeExceptionHandler(flow, e);
                this.getLog().error("Encountered error while applying action '" + action.getClass().getSimpleName() + "' on " + saga.getName() + "/" + saga.getId(), (Throwable)handledException);
                String string = action.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"action.javaClass.simpleName");
                if (handledException instanceof SpinnakerException) {
                    bl3 = ((SpinnakerException)handledException).getRetryable();
                    if (bl3 == null) {
                        bl3 = false;
                    }
                } else {
                    bl3 = false;
                }
                Boolean bl4 = bl3;
                Intrinsics.checkNotNullExpressionValue((Object)bl4, (String)"when (handledException) \u2026 -> false\n              }");
                saga.addEvent(new SagaActionErrorOccurred(string, handledException, bl4));
                SagaRepository.DefaultImpls.save$default(this.sagaRepository, saga, null, 2, null);
                this.registry.counter(this.actionInvocationsId.withTags("result", "failure", "action", action.getClass().getSimpleName())).increment();
                this.getLog().error("Failed to apply action " + action.getClass().getSimpleName() + " for " + saga.getName() + "/" + saga.getId());
                throw handledException;
            }
            SagaAction.Result result2 = result;
            saga.setSequence$clouddriver_saga(stepCommand.getMetadata().getSequence());
            List it = e = CollectionsKt.toMutableList((Collection)result2.getEvents());
            boolean bl5 = false;
            it.add(new SagaCommandCompleted(UtilKt.getStepCommandName(stepCommand)));
            List newEvents = e;
            SagaCommand nextCommand = result2.getNextCommand();
            if (nextCommand == null) {
                if (flowState.hasMoreSteps() && !saga.hasUnappliedCommands$clouddriver_saga()) {
                    saga.complete$clouddriver_saga(false);
                    this.sagaRepository.save(saga, CollectionsKt.emptyList());
                    throw new SagaIntegrationException("Result did not return a nextCommand value, but flow has more steps defined");
                }
                saga.complete$clouddriver_saga(true);
            } else if (nextCommand instanceof ManyCommands) {
                newEvents.addAll((Collection)((ManyCommands)nextCommand).getCommands());
            } else {
                newEvents.add(nextCommand);
            }
            this.sagaRepository.save(saga, newEvents);
        }
        return this.invokeCompletionHandler(initialSaga, flow);
    }

    private final Saga initializeSaga(SagaCommand command, String sagaName, String sagaId) {
        Saga saga = this.sagaRepository.get(sagaName, sagaId);
        if (saga == null) {
            Saga saga2;
            Saga it = saga2 = new Saga(sagaName, sagaId);
            boolean bl = false;
            this.getLog().debug("Initializing new saga: " + sagaName + "/" + sagaId);
            it.addEvent(command);
            SagaRepository.DefaultImpls.save$default(this.sagaRepository, it, null, 2, null);
            saga = saga2;
        }
        return saga;
    }

    private final <T> T invokeCompletionHandler(Saga saga, SagaFlow flow) {
        block6: {
            Object t;
            block8: {
                block7: {
                    Class<? extends SagaCompletionHandler<?>> clazz = flow.getCompletionHandler$clouddriver_saga();
                    if (clazz == null) break block6;
                    Class<? extends SagaCompletionHandler<?>> completionHandler = clazz;
                    boolean bl = false;
                    ApplicationContext applicationContext = this.applicationContext;
                    if (applicationContext == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
                        applicationContext = null;
                    }
                    SagaCompletionHandler handler = (SagaCompletionHandler)applicationContext.getBean(completionHandler);
                    Saga saga2 = this.sagaRepository.get(saga.getName(), saga.getId());
                    if (saga2 == null) break block7;
                    Saga it = saga2;
                    boolean bl2 = false;
                    t = handler.handle(it);
                    if (t != null) break block8;
                }
                throw new SagaNotFoundException("Could not find Saga to complete by " + saga.getName() + "/" + saga.getId());
            }
            Object result = t;
            try {
                return result;
            }
            catch (ClassCastException e) {
                throw new SagaIntegrationException("The completion handler is incompatible with the expected return type", e);
            }
        }
        return null;
    }

    private final Exception invokeExceptionHandler(SagaFlow flow, Exception exception) {
        Class<? extends SagaExceptionHandler> clazz = flow.getExceptionHandler$clouddriver_saga();
        if (clazz != null) {
            Class<? extends SagaExceptionHandler> exceptionHandler = clazz;
            boolean bl = false;
            ApplicationContext applicationContext = this.applicationContext;
            if (applicationContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
                applicationContext = null;
            }
            SagaExceptionHandler handler = (SagaExceptionHandler)applicationContext.getBean(exceptionHandler);
            return handler.handle(exception);
        }
        return exception;
    }

    private final Class<SagaCommand> getRequiredCommand(SagaAction<? super SagaCommand> action) {
        return UtilKt.getCommandTypeFromAction(action.getClass());
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.applicationContext = applicationContext;
    }
}

