/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.saga.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.saga.CommandFinalizer;
import com.netflix.spinnaker.clouddriver.saga.SagaCommand;
import com.netflix.spinnaker.clouddriver.saga.SagaCompleted;
import com.netflix.spinnaker.clouddriver.saga.SagaEvent;
import com.netflix.spinnaker.clouddriver.saga.SagaLogAppended;
import com.netflix.spinnaker.clouddriver.saga.SagaRollbackStarted;
import com.netflix.spinnaker.clouddriver.saga.exceptions.SagaStateIntegrationException;
import com.netflix.spinnaker.clouddriver.saga.exceptions.SagaSystemException;
import com.netflix.spinnaker.kork.annotations.Beta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bJ\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0007J\u0017\u0010\u001b\u001a\u00020\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u001b\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0000\u00a2\u0006\u0002\b#J#\u0010$\u001a\u0002H%\"\b\b\u0000\u0010%*\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0!\u00a2\u0006\u0002\u0010'J=\u0010$\u001a\u0002H%\"\b\b\u0000\u0010%*\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0!2\u0018\u0010(\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0*\u0012\u0004\u0012\u0002H%0)\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0*H\u0007J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030*J\u001d\u0010.\u001a\u0004\u0018\u00010\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0000\u00a2\u0006\u0002\b0J\u0018\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0*2\b\b\u0002\u00102\u001a\u00020\u001dH\u0007J\u0006\u00103\u001a\u00020\u0007J\u0006\u00104\u001a\u00020\u0007J\r\u00105\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b6J\u001b\u00107\u001a\u00020\u00182\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0*H\u0000\u00a2\u0006\u0002\b8J\u0006\u00109\u001a\u00020\u001dJ\u0006\u0010:\u001a\u00020\u001dJ\u000e\u0010\u000e\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\u0003J+\u0010\u000e\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\u00032\u0016\u0010<\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010=\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010>J%\u0010?\u001a\u0004\u0018\u0001H%\"\b\b\u0000\u0010%*\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0!\u00a2\u0006\u0002\u0010'JA\u0010?\u001a\u0004\u0018\u0001H%\"\b\b\u0000\u0010%*\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0!2\u001a\u0010(\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0*\u0012\u0006\u0012\u0004\u0018\u0001H%0)\u00a2\u0006\u0002\u0010+J\u0015\u0010@\u001a\u00020\u00182\u0006\u0010A\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bBR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/netflix/spinnaker/clouddriver/saga/models/Saga;", "", "name", "", "id", "(Ljava/lang/String;Ljava/lang/String;)V", "sequence", "", "(Ljava/lang/String;Ljava/lang/String;J)V", "events", "", "Lcom/netflix/spinnaker/clouddriver/saga/SagaEvent;", "getId", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "getName", "pendingEvents", "addEvent", "", "event", "addEventForTest", "complete", "success", "", "complete$clouddriver_saga", "finalizedCommand", "command", "Ljava/lang/Class;", "Lcom/netflix/spinnaker/clouddriver/saga/SagaCommand;", "finalizedCommand$clouddriver_saga", "getEvent", "T", "clazz", "(Ljava/lang/Class;)Lcom/netflix/spinnaker/clouddriver/saga/SagaEvent;", "reducer", "Lkotlin/Function1;", "", "(Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)Lcom/netflix/spinnaker/clouddriver/saga/SagaEvent;", "getEvents", "getLogs", "getNextCommand", "requiredCommand", "getNextCommand$clouddriver_saga", "getPendingEvents", "flush", "getSequence", "getVersion", "hasUnappliedCommands", "hasUnappliedCommands$clouddriver_saga", "hydrateEvents", "hydrateEvents$clouddriver_saga", "isCompensating", "isComplete", "message", "replacements", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "maybeGetEvent", "setSequence", "appliedEventVersion", "setSequence$clouddriver_saga", "clouddriver-saga"})
@Beta
public final class Saga {
    @NotNull
    private final String name;
    @NotNull
    private final String id;
    private long sequence;
    @NotNull
    private final Lazy log$delegate;
    @NotNull
    private final List<SagaEvent> events;
    @NotNull
    private final List<SagaEvent> pendingEvents;

    public Saga(@NotNull String name, @NotNull String id, long sequence) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.name = name;
        this.id = id;
        this.sequence = sequence;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ Saga this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
        this.events = new ArrayList();
        this.pendingEvents = new ArrayList();
    }

    public /* synthetic */ Saga(String string, String string2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l = 0L;
        }
        this(string, string2, l);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public Saga(@NotNull String name, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this(name, id, 0L);
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void complete$clouddriver_saga(boolean success) {
        this.addEvent(new SagaCompleted(success));
    }

    public static /* synthetic */ void complete$clouddriver_saga$default(Saga saga, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        saga.complete$clouddriver_saga(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isComplete() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.events;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SagaCompleted)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return !((Collection)((List)destination$iv$iv)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCompensating() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.events;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SagaRollbackStarted)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return !((Collection)((List)destination$iv$iv)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final long getVersion() {
        long l;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.events;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SagaEvent sagaEvent = (SagaEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMetadata().getOriginatingVersion());
        }
        Long l2 = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        if (l2 != null) {
            long it = ((Number)l2).longValue();
            boolean bl = false;
            l = it + 1L;
        } else {
            l = 0L;
        }
        return l;
    }

    public final void addEvent(@NotNull SagaEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.pendingEvents.add(event);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends SagaEvent> T getEvent(@NotNull Class<T> clazz) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Iterable $this$filter$iv = CollectionsKt.reversed((Iterable)this.events);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SagaEvent it = (SagaEvent)element$iv$iv;
            boolean bl = false;
            if (!clazz.isAssignableFrom(it.getClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        switch (it.size()) {
            case 0: {
                throw SagaStateIntegrationException.Companion.typeNotFound(clazz, this);
            }
            case 1: {
                break;
            }
            default: {
                throw SagaStateIntegrationException.Companion.tooManyResults(clazz, this);
            }
        }
        return (T)((SagaEvent)CollectionsKt.first((List)it));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends SagaEvent> T getEvent(@NotNull Class<T> clazz, @NotNull Function1<? super List<? extends T>, ? extends T> reducer) {
        SagaEvent sagaEvent;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(reducer, (String)"reducer");
        Iterable $this$filter$iv = CollectionsKt.reversed((Iterable)this.events);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SagaEvent it = (SagaEvent)element$iv$iv;
            boolean bl = false;
            if (!clazz.isAssignableFrom(it.getClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        switch (it.size()) {
            case 0: {
                throw SagaStateIntegrationException.Companion.typeNotFound(clazz, this);
            }
            case 1: {
                sagaEvent = (SagaEvent)CollectionsKt.first((List)it);
                break;
            }
            default: {
                sagaEvent = (SagaEvent)reducer.invoke((Object)it);
            }
        }
        return (T)sagaEvent;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T extends SagaEvent> T maybeGetEvent(@NotNull Class<T> clazz) {
        SagaEvent sagaEvent;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Iterable $this$filter$iv = CollectionsKt.reversed((Iterable)this.events);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SagaEvent it = (SagaEvent)element$iv$iv;
            boolean bl = false;
            if (!clazz.isAssignableFrom(it.getClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        switch (it.size()) {
            case 0: {
                sagaEvent = null;
                break;
            }
            case 1: {
                sagaEvent = (SagaEvent)CollectionsKt.first((List)it);
                break;
            }
            default: {
                throw SagaStateIntegrationException.Companion.tooManyResults(clazz, this);
            }
        }
        return (T)sagaEvent;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T extends SagaEvent> T maybeGetEvent(@NotNull Class<T> clazz, @NotNull Function1<? super List<? extends T>, ? extends T> reducer) {
        SagaEvent sagaEvent;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(reducer, (String)"reducer");
        Iterable $this$filter$iv = CollectionsKt.reversed((Iterable)this.events);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SagaEvent it = (SagaEvent)element$iv$iv;
            boolean bl = false;
            if (!clazz.isAssignableFrom(it.getClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        switch (it.size()) {
            case 0: {
                sagaEvent = null;
                break;
            }
            case 1: {
                sagaEvent = (SagaEvent)CollectionsKt.first((List)it);
                break;
            }
            default: {
                throw SagaStateIntegrationException.Companion.tooManyResults(clazz, this);
            }
        }
        return (T)sagaEvent;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean finalizedCommand$clouddriver_saga(@NotNull Class<SagaCommand> command) {
        boolean bl;
        block4: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(command, (String)"command");
            Iterable $this$filterIsInstance$iv = this.getEvents();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CommandFinalizer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CommandFinalizer it = (CommandFinalizer)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(command)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SagaCommand getNextCommand$clouddriver_saga(@NotNull Class<SagaCommand> requiredCommand) {
        Object v0;
        block3: {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(requiredCommand, (String)"requiredCommand");
            Iterable $this$filterIsInstance$iv = this.getEvents();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof SagaCommand)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                SagaCommand it = (SagaCommand)element$iv$iv;
                boolean bl = false;
                if (this.finalizedCommand$clouddriver_saga(it.getClass())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SagaCommand it = (SagaCommand)element$iv;
                boolean bl = false;
                if (!requiredCommand.isAssignableFrom(it.getClass())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasUnappliedCommands$clouddriver_saga() {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = CollectionsKt.plus((Collection)this.getEvents(), (Iterable)this.pendingEvents);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SagaCommand)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            SagaCommand it = (SagaCommand)element$iv$iv;
            boolean bl = false;
            if (this.finalizedCommand$clouddriver_saga(it.getClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.any((Iterable)((List)destination$iv$iv));
    }

    @VisibleForTesting
    public final void addEventForTest(@NotNull SagaEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.events.add(event);
    }

    public final void hydrateEvents$clouddriver_saga(@NotNull List<? extends SagaEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (this.events.isEmpty()) {
            this.events.addAll((Collection<SagaEvent>)events);
        }
    }

    public final long getSequence() {
        return this.sequence;
    }

    public final void setSequence$clouddriver_saga(long appliedEventVersion) {
        if (this.sequence > appliedEventVersion) {
            throw new SagaSystemException("Attempted to set Saga sequence to an event version in the past (current: " + this.sequence + ", applying: " + appliedEventVersion + ")");
        }
        this.sequence = appliedEventVersion;
    }

    @JsonIgnoreProperties(value={"saga"})
    @NotNull
    public final List<SagaEvent> getEvents() {
        return CollectionsKt.toList((Iterable)this.events);
    }

    @JsonIgnore
    @VisibleForTesting
    @NotNull
    public final List<SagaEvent> getPendingEvents(boolean flush) {
        List pending = new ArrayList();
        pending.addAll((Collection)this.pendingEvents);
        if (flush) {
            this.pendingEvents.clear();
        }
        return CollectionsKt.toList((Iterable)pending);
    }

    public static /* synthetic */ List getPendingEvents$default(Saga saga, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return saga.getPendingEvents(bl);
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLog().info(message);
        this.addEvent(new SagaLogAppended(new SagaLogAppended.Message(message, null), null));
    }

    public final void log(@NotNull String message, Object ... replacements) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        Object[] objectArray = Arrays.copyOf(replacements, replacements.length);
        String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
        this.log(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getLogs() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.events;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SagaLogAppended)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SagaLogAppended it = (SagaLogAppended)element$iv$iv;
            boolean bl2 = false;
            if (it.getMessage().getUser() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

