/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.saga.persistence;

import com.netflix.spinnaker.clouddriver.event.Aggregate;
import com.netflix.spinnaker.clouddriver.event.persistence.EventRepository;
import com.netflix.spinnaker.clouddriver.saga.SagaEvent;
import com.netflix.spinnaker.clouddriver.saga.SagaSaved;
import com.netflix.spinnaker.clouddriver.saga.models.Saga;
import com.netflix.spinnaker.clouddriver.saga.persistence.SagaRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/netflix/spinnaker/clouddriver/saga/persistence/DefaultSagaRepository;", "Lcom/netflix/spinnaker/clouddriver/saga/persistence/SagaRepository;", "eventRepository", "Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository;", "(Lcom/netflix/spinnaker/clouddriver/event/persistence/EventRepository;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "get", "Lcom/netflix/spinnaker/clouddriver/saga/models/Saga;", "type", "", "id", "list", "", "criteria", "Lcom/netflix/spinnaker/clouddriver/saga/persistence/SagaRepository$ListCriteria;", "save", "", "saga", "additionalEvents", "Lcom/netflix/spinnaker/clouddriver/saga/SagaEvent;", "clouddriver-saga"})
public final class DefaultSagaRepository
implements SagaRepository {
    @NotNull
    private final EventRepository eventRepository;
    @NotNull
    private final Lazy log$delegate;

    public DefaultSagaRepository(@NotNull EventRepository eventRepository) {
        Intrinsics.checkNotNullParameter((Object)eventRepository, (String)"eventRepository");
        this.eventRepository = eventRepository;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ DefaultSagaRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
        }));
    }

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Saga> list(@NotNull SagaRepository.ListCriteria criteria) {
        List list;
        Iterable $this$mapNotNullTo$iv$iv;
        List list2;
        Intrinsics.checkNotNullParameter((Object)criteria, (String)"criteria");
        if (criteria.getNames() != null && !((Collection)criteria.getNames()).isEmpty()) {
            String token = null;
            List aggregates = new ArrayList();
            do {
                EventRepository.ListAggregatesResult it = this.eventRepository.listAggregates(new EventRepository.ListAggregatesCriteria(null, token, 1000, 1, null));
                boolean bl = false;
                aggregates.addAll(it.getAggregates());
                token = it.getNextPageToken();
            } while (token != null);
            list2 = aggregates;
        } else {
            list2 = this.eventRepository.listAggregates(new EventRepository.ListAggregatesCriteria(null, null, 0, 7, null)).getAggregates();
        }
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Saga it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Aggregate it = (Aggregate)element$iv$iv;
            boolean bl2 = false;
            if (this.get(it.getType(), it.getId()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List sagas = (List)destination$iv$iv;
        if (criteria.getRunning() == null) {
            list = sagas;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = sagas;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Saga it = (Saga)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.isComplete(), (Object)criteria.getRunning()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Saga get(@NotNull String type, @NotNull String id) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Object element$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstance$iv2;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List events = this.eventRepository.list(type, id);
        if (events.isEmpty()) {
            return null;
        }
        Object object = events;
        boolean $i$f$filterIsInstance = false;
        void var6_7 = $this$filterIsInstance$iv2;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv2 instanceof SagaSaved)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        SagaSaved it = (SagaSaved)CollectionsKt.last((List)((List)destination$iv$iv));
        boolean bl = false;
        Object saga = object = new Saga(it.getMetadata().getAggregateType(), it.getMetadata().getAggregateId(), it.getSequence());
        boolean bl2 = false;
        destination$iv$iv = events;
        Object object2 = saga;
        boolean $i$f$filterIsInstance2 = false;
        element$iv$iv2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv3 instanceof SagaEvent)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        ((Saga)object2).hydrateEvents$clouddriver_saga((List)destination$iv$iv2);
        return object;
    }

    @Override
    public void save(@NotNull Saga saga, @NotNull List<? extends SagaEvent> additionalEvents) {
        Intrinsics.checkNotNullParameter((Object)saga, (String)"saga");
        Intrinsics.checkNotNullParameter(additionalEvents, (String)"additionalEvents");
        List events = CollectionsKt.toMutableList((Collection)Saga.getPendingEvents$default(saga, false, 1, null));
        if (!((Collection)additionalEvents).isEmpty()) {
            events.addAll((Collection)additionalEvents);
        }
        events.add(new SagaSaved(saga.getSequence()));
        this.eventRepository.save(saga.getName(), saga.getId(), saga.getVersion(), events);
    }
}

