/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.fiat.model.Authorization;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractAccountCredentials<T>
implements AccountCredentials<T> {
    @JsonIgnore
    public abstract T getCredentials();

    public Permissions getPermissions() {
        Set rgm = Optional.ofNullable(this.getRequiredGroupMembership()).map(l -> l.stream().map(s -> Optional.ofNullable(s).map(String::trim).map(String::toLowerCase).orElse("")).filter(s -> !s.isEmpty()).collect(Collectors.toSet())).orElse(Collections.EMPTY_SET);
        if (rgm.isEmpty()) {
            return Permissions.EMPTY;
        }
        Permissions.Builder perms = new Permissions.Builder();
        for (String role : rgm) {
            perms.add(Authorization.READ, role);
            perms.add(Authorization.WRITE, role);
        }
        return perms.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountCredentials that = (AccountCredentials)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getType(), that.getType());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getType());
    }
}

