/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentScheduler;
import com.netflix.spinnaker.cats.agent.AgentSchedulerAware;
import com.netflix.spinnaker.cats.module.CatsModule;
import com.netflix.spinnaker.cats.module.CatsModuleAware;
import com.netflix.spinnaker.cats.provider.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public abstract class BaseProvider
extends AgentSchedulerAware
implements Provider {
    private final Collection<Agent> agents = Collections.newSetFromMap(new ConcurrentHashMap());

    public final Collection<Agent> getAgents() {
        return ImmutableList.copyOf(this.agents);
    }

    public final void addAgents(Collection<? extends Agent> agentsToSchedule) {
        this.agents.addAll(agentsToSchedule);
        AgentScheduler agentScheduler = this.getAgentScheduler();
        if (agentScheduler instanceof CatsModuleAware) {
            CatsModule catsModule = ((CatsModuleAware)agentScheduler).getCatsModule();
            agentsToSchedule.forEach(agent -> agentScheduler.schedule(agent, agent.getAgentExecution(catsModule.getProviderRegistry()), catsModule.getExecutionInstrumentation()));
        }
    }

    public final void removeAgentsForAccounts(Collection<String> namesOfDeletedAccounts) {
        namesOfDeletedAccounts.forEach(nameOfDeletedAccount -> {
            AgentScheduler scheduler = this.getAgentScheduler();
            List<Agent> agentsToDelete = this.agents.stream().filter(agent -> agent.handlesAccount(nameOfDeletedAccount)).collect(Collectors.toList());
            if (scheduler != null) {
                agentsToDelete.forEach(arg_0 -> ((AgentScheduler)scheduler).unschedule(arg_0));
            }
            this.agents.removeAll(agentsToDelete);
        });
    }
}

